<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

session_start();

require_once(dirname(__FILE__)."/include/lecture_config.php");
require_once(dirname(__FILE__)."/../site_config/confedit.class.php");

lire_fichier_configuration(dirname(__FILE__)."/../site_config/config.php");

if (!isset($_SESSION['langue']) || !$_SESSION['langue'])
    $_SESSION['langue'] = "fr";
$fichierlangue = dirname(__FILE__)."/../langues/".$_SESSION['langue'].".php";
require_once($fichierlangue);
require_once(dirname(__FILE__)."/include/outils.php");
require_once(dirname(__FILE__)."/include/tete_pied.php");
require_once(dirname(__FILE__)."/include/base_de_donnees.php");
require_once(dirname(__FILE__)."/partie_administrateur/maj_bdd.php");

init_erreurs();

$_SESSION['section'] = "";

$lien_bdd = connexion();
debut_html(INSCRIPTION,INSCRIPTION);
/*
echo '<script type="text/javascript">'."\n";
echo 'function verifier_champs() {'."\n";
echo 'if (document.formulaire.prenom.value == "") {';
echo 'alert("'.ENTRER_PRENOM.'");';
echo 'return false;';
echo "}\n";
echo 'else if (document.formulaire.nom.value == "") {';
echo 'alert("'.ENTRER_NOM.'");';
echo 'return false;';
echo "}\n";
echo 'else if (document.formulaire.login.value == "") {';
echo 'alert("'.ENTRER_LOGIN.'");';
echo 'return false;';
echo "}\n";
echo 'else if (document.formulaire.motdepasse.value == "") {';
echo 'alert("'.ENTRER_PASSWD.'");';
echo 'return false;';
echo "}\n";
echo 'else if (document.formulaire.motdepasse.value != "") {'."\n";
echo '  mot_de_passe = document.formulaire.motdepasse.value;'."\n";
echo '  if (mot_de_passe.length < 8 ) {'."\n";
echo '    alert("'.HUIT_CARACTERES.'");'."\n";
echo '    return false;'."\n";
echo "  } else\n";
echo '    return true;'."\n";
echo "} else\n";
echo '  return true;'."\n";
echo "}\n";
echo "</script>\n";
*/
if (!verif_bdd($lien_bdd)) {
    echo "<p class='erreur'>".MAJ_NECESSAIRE."</p><br>";
} else {
    $jeton = getJeton();
    echo '<div class="boite_inscription">'."\n";
    echo '<form method="POST" action="creation_compte_temporaire.php" name="formulaire">'."\n";
    echo '<p><input type="hidden" name="jeton" value="'.$jeton.'">'."</p>\n";
    echo '<table class="bordure">'."\n";
    echo '<tr>';
    echo '<td>'.PRENOM.'</td>';
    echo '<td><input type="text" name="prenom" class="texte" maxlength="20"><br><div class="commentaire"></div></td>';
    echo "</tr>\n";
    echo '<tr>';
    echo '<td>'.NOM_FAMILLE.'</td>';
    echo '<td><input type="text" name="nom" class="texte" maxlength="20"></td>';
    echo "</tr>\n";
    echo '<tr>';
    echo '<td>'.LOGIN.'</td>';
    echo '<td><input type="text" name="login" class="texte" maxlength="16"><br><div class="commentaire"></div></td>';
    echo "</tr>\n";
    echo '<tr>';
    echo '<td>'.MOT_DE_PASSE.'</td>';
    echo '<td><input type="password" name="motdepasse" class="texte" maxlength="30"></td>';
    echo "</tr>\n";
    
    if ($_SESSION['choix_du_mail'] != 'PAS_MAIL') {
        echo '<tr>';
        echo '<td>'.EMAIL.'</td>';
        echo '<td><input type="text" name="email" class="texte" maxlength="40"></td>';
        echo "</tr>\n";
    }
    
    $liste_langues = lire_liste_langues();
    echo '<tr><td>'.LANGUE.'</td>';
    echo '<td><select name="langue">';
    $langue = $_SESSION['langue'];
    for ( $i = 0; $i < count($liste_langues); $i++ )
    {
        $nom = $liste_langues[$i];
        if ($nom == $langue)
            echo '<option value="'.$nom.'" selected>'.$nom.'</option>';
        else
            echo '<option value="'.$nom.'">'.$nom.'</option>';
    }
    echo "</select></td></tr>\n";

    echo '<tr>';
    echo '<td></td><td>';
    echo '<input type="submit" name="'.CREER.'" class="valider">';
    echo '</td>';
    echo "</tr>\n";
    echo "</table>\n";
    echo "</form>\n";
    echo "</div>\n";
}

echo '<p><a href="index.php">'.RETOUR."</a></p>\n";

fin_html();

?>
