<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8


function debut_html($titre, $menu, $onload='', $id_projet=false)
{
    header('Content-Type: text/html; charset=utf-8');
    echo '<!DOCTYPE html>'."\n";
    echo "<html>\n";
    echo "<head>\n";
    echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">'."\n";
    
    if ($_SESSION['section'] == "administrateur" || $_SESSION['section'] == "utilisateur" || $_SESSION['section'] == "installation")
        $chemin_racine = '../..';
    else
        $chemin_racine = '..';
    
    if ($onload != '')
        echo '<script type="text/javascript" src="'.$chemin_racine.'/php/javascript/javascript.js"></script>'."\n";
    
    if ($_SESSION['section'] == "administrateur" )
        echo '<link href="'.$chemin_racine.'/design/css/style_admin.css" rel="stylesheet" type="text/css">'."\n";
    else
        echo '<link href="'.$chemin_racine.'/design/css/style_util.css" rel="stylesheet" type="text/css">'."\n";        
    
    echo '<title>'.$titre.'</title>'."\n";
    echo "</head>\n";
    if ($onload != "")
        echo "<body onload=\"$onload\">\n";
    else
        echo "<body>\n";
    echo '<div class="webjaxe">'."\n";
    echo '<div class="tete">'."\n";
    echo '<div class="logo-webjaxe">';
    if ($_SESSION['section'] == "administrateur" )
        echo '<img src="'.$chemin_racine.'/design/image-interface/titre_admin.gif" alt="WebJaxe" width="226" height="110">';
    else
        echo '<img src="'.$chemin_racine.'/design/image-interface/titre_util.gif" alt="WebJaxe" width="226" height="110">';
    echo '</div>'."\n";
    
    if ($_SESSION['section']=='administrateur' || $_SESSION['section']=='installation') {
        echo '<div class="titre-section">';
        if ($_SESSION['section']=='administrateur')
            echo ADMINISTRATION;
        else if ($_SESSION['section']=='installation')
            echo INSTALLATION;
        echo "</div>\n";
    }
    echo "<h1>".$titre."</h1>"."\n";
    echo '</div>'."\n"; // tete
    echo '<div class="corps">'."\n";
    echo '<div class="menu">'."\n";
    afficher_menu($menu, $id_projet);
    echo '</div>'."\n";
    echo '<div class="contenu">'."\n";
}


function afficher_menu($menu, $id_projet)
{
    if ($_SESSION['section'] == 'administrateur')
    {
        echo "<ul>\n";
        
        echo '<li><a href="../partie_utilisateur/index.php?page=liste_contributions" target="_top"';
        if ($menu == PARTIE_UTILISATEUR)
            echo ' class="selected"';
        echo '>'.PARTIE_UTILISATEUR.'</a></li>'."\n";
        
        echo '<li><a href="../partie_administrateur/administration.php?page=parametres_du_site" target="_top"';
        if ($menu == PARAMETRE_WEBJAXE)
            echo ' class="selected"';
        echo '>'.PARAMETRE_WEBJAXE.'</a></li>'."\n";
        
        echo '<li><a href="../partie_administrateur/administration.php?page=administration_projets" target="_top"';
        if ($menu == GESTION_PROJETS)
            echo ' class="selected"';
        echo '>'.GESTION_PROJETS.'</a></li>'."\n";
        
        echo '<li><a href="../partie_administrateur/administration.php?page=gestion_des_contributions" target="_top"';
        if ($menu == GESTION_CONTRIBUTIONS)
            echo ' class="selected"';
        echo '>'.GESTION_CONTRIBUTIONS.'</a></li>'."\n";
        
        echo '<li><a href="../partie_administrateur/administration.php?page=administration_utilisateurs" target="_top"';
        if ($menu == GESTION_UTILISATEURS)
            echo ' class="selected"';
        echo '>'.GESTION_UTILISATEURS.'</a></li>'."\n";
        
        echo '<li><a href="../partie_administrateur/administration.php?page=utilisateur_connectes" target="_top"';
        if ($menu == "utilisateur_connectes")
            echo ' class="selected"';
        echo '> Utilisateurs connectés</a></li>'."\n";
    
        
        echo '<li><a href="../deconnexion.php">'.DECONNECTION.'</a></li>'."\n";
        echo "</ul>\n";
    }
    else if ($_SESSION['section'] == 'utilisateur')
    {
        echo "<ul>\n";
        
        if (isset($_SESSION['status']) && $_SESSION['status'] == 'administrateur')
            echo '<li><a href="../partie_administrateur/administration.php?page=accueil" target="_top">'.ADMINISTRATION.'</a></li>'."\n";
        
        if ($id_projet != false)
            echo '<li><a href="../partie_utilisateur/index.php?page=liste_contributions#p'.$id_projet.'" target="_top"';
        else
            echo '<li><a href="../partie_utilisateur/index.php?page=liste_contributions" target="_top"';
        if ($menu == LISTE_CONTRIBUTIONS)
            echo ' class="selected"';
        echo '>'.LISTE_CONTRIBUTIONS.'</a></li>'."\n";
        
        if ($id_projet != false)
            echo '<li><a href="../partie_utilisateur/index.php?page=nouvelle_contribution&amp;id_projet='.$id_projet.'" target="_top"';
        else
            echo '<li><a href="../partie_utilisateur/index.php?page=nouvelle_contribution" target="_top"';
        if ($menu == NOUVELLE_CONTRIBUTION)
            echo ' class="selected"';
        echo '>'.NOUVELLE_CONTRIBUTION.'</a></li>'."\n";
        
        echo '<li><a href="../partie_utilisateur/index.php?page=nouveau_projet" target="_top"';
        if ($menu == NOUVEAU_PROJET)
            echo ' class="selected"';
        echo '>'.NOUVEAU_PROJET.'</a></li>'."\n";
        
        if ($menu == TITRE_EDITER_CONTRIBUTION)
            echo '<li><a href="#" target="_top" class="selected">'.TITRE_EDITER_CONTRIBUTION.'</a></li>'."\n";
         
        echo '<li><a href="../partie_utilisateur/index.php?page=preferences" target="_top"';
        if ($menu == PREFERENCES)
            echo ' class="selected"';
        echo '>'.PREFERENCES.'</a></li>'."\n";
        
        if ($id_projet != false)
            echo '<li><a href="../partie_utilisateur/index.php?page=rechercher&amp;id_projet='.$id_projet.'" target="_top"';
        else
            echo '<li><a href="../partie_utilisateur/index.php?page=rechercher" target="_top"';
        if ($menu == RECHERCHE)
            echo ' class="selected"';
        echo '>'.RECHERCHE.'</a></li>'."\n";
        
        echo "<li><a href=\"../deconnexion.php\" target=\"_top\">".DECONNECTION."</a></li>"."\n";
        echo "</ul>\n";
    }
    else
        echo "";
}


function fin_html()
{
    echo '</div>'."\n";
    echo '<div class="spacer"></div>'."\n";
    //echo '<div class="pied">'."\n";
    //echo '</div>'."\n";
    echo '</div>'."\n"; // corps
    echo '</div>'."\n"; // webjaxe

    echo "</body>\n";
    echo "</html>\n";
}

?>
