<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8


// Initialisation pour la gestion propre des erreurs
function init_erreurs() {
    // Fixe le niveau de rapport d'erreur pour ce script

    ob_start();
    
    function myErrorHandler ($errno, $errstr, $errfile, $errline) {    
        
        $debug = false;
        
        header("Pragma: no-cache");
        header("Cache-Control: no-cache");
        header("Expires: 0");
        switch ($errno) {
            case E_USER_ERROR: 
                ob_end_clean();
                debut_html(TITRE_ERREURS, "");
                if ($debug) {
                    echo "<p class=\"erreur\">FATAL [$errno] $errstr</p>\n";
                    echo "<p class=\"erreur\">".FICHIER.": $errfile ".LIGNE.": $errline</p>\n";
                } else
                    echo "<p class=\"erreur\">".$errstr."</p>";
                //if (isset($_SERVER['HTTP_REFERER']))
    			//    echo '<p><a href="'.$_SERVER['HTTP_REFERER'].'">'.RETOUR.'</a></p>';
    			// ne marche pas toujours
                fin_html();
                exit;
                break;
            
            case E_USER_WARNING:
                if ($debug) {
                    echo "<b>ERROR</b> [$errno] $errstr<br>\n";
                    echo "<p class=\"erreur\">".FICHIER.": $errfile ".LIGNE.": $errline</p>\n";
                } else
                    echo "<p class=\"erreur\">".CONTACTER_ADMIN."</p>";
                break;
            
            case E_USER_NOTICE:
                if ($debug) {
                    echo "<b>WARNING</b> [$errno] $errstr<br>\n";
                    echo "<p class=\"erreur\">".FICHIER.": $errfile ".LIGNE.": $errline</p>\n";
                } else
                    echo "<p>".PROBLEME_PAGE."</p>";
                break;
            
            case E_DEPRECATED:
                error_log("webjaxe: $errfile ligne $errline: DEPRECATED: [$errno] $errstr");
                if ($debug) {
                    ob_end_clean();
                    entete(TITRE_ERREURS);
                    echo "<p class=\"erreur\">deprecated [$errno] $errstr</p>\n";
                    pied();
                    exit;
                }
                break;
            
            default:
                error_log("webjaxe: $errfile ligne $errline: erreur: [$errno] $errstr");
                ob_end_clean();
                entete(TITRE_ERREURS);
                if ($debug)
                    echo "<p class=\"erreur\">default [$errno] $errstr</p>\n";
                else
                    echo "<p class=\"erreur\">".CONTACTER_ADMIN."</p>";
                pied();
                exit;
                break;
        }
    }
    $old_error_handler = set_error_handler('myErrorHandler');
}



// Initialisation pour la gestion propre des erreurs : affichage sous forme de texte simple
function init_erreurs_texte() {
    // Fixe le niveau de rapport d'erreur pour ce script
    ob_start();
    function myErrorHandler ($errno, $errstr, $errfile, $errline) {    
        
        $debug = false;
        
        switch ($errno) {
            case E_USER_ERROR: 
                ob_end_clean();
                header("content-type:text/plain; charset=utf-8");
                if ($debug) {
                    echo "FATAL [$errno] $errstr\n";
    				echo FICHIER.": $errfile ".LIGNE.": $errline";
                } else
                    echo $errstr;
                exit;
                break;
            
            case E_USER_WARNING:
                if ($debug) {
                    echo "ERROR [$errno] $errstr\n";
                    echo FICHIER.": $errfile ".LIGNE.": $errline";
                } else
                    echo CONTACTER_ADMIN;
                break;
            
            case E_USER_NOTICE:
                if ($debug) {
                    echo "WARNING [$errno] $errstr";
                    echo FICHIER.": $errfile ".LIGNE.": $errline";
                } else
                    echo CONTACTER_ADMIN;
    
                break;
            
            case E_DEPRECATED:
                error_log("webjaxe: $errfile ligne $errline: DEPRECATED: [$errno] $errstr");
                break;
            
            default:
                error_log("webjaxe: $errfile ligne $errline: erreur: [$errno] $errstr");
                ob_end_clean();
                header("content-type:text/plain; charset=utf-8");
                if ($debug)
                    echo "default [$errno] $errstr";
                else
                    echo CONTACTER_ADMIN;
                exit;
                break;
        }
    }
    $old_error_handler = set_error_handler('myErrorHandler');
}




// Entête des fichiers HTML
function entete($titre) {
    echo <<<ENDOFECHO
<!DOCTYPE html>

<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">

ENDOFECHO;
    echo "    <title>".$titre."</title>\n";
    echo <<<ENDOFECHO
</head>

<body>

ENDOFECHO;
}


// lance une erreur avec un message d'erreur
function erreur($message) {
    trigger_error($message, E_USER_ERROR);
}

// Pied de page des fichiers HTML
function pied() {
    echo <<<ENDOFECHO
</body>
</html>
ENDOFECHO;
}

// retourne un jeton s'il existe sinon il le génére
function getJeton() {
	if (isset($_SESSION['jeton']) && !empty($_SESSION['jeton']))
		return $_SESSION['jeton'];
	else {
        $jeton = md5(uniqid());
        $_SESSION['jeton'] = $jeton;
        return $jeton;
	}
}

// compare un jeton avec la variable de session 'jeton'
function comparerJeton($jeton) {
	if (isset($_SESSION['jeton']) && !empty($_SESSION['jeton']))
		return $_SESSION['jeton'] === $jeton ? true : false;
    else
        return false;
}

function lire_liste_langues() {
    $fichiers_langue = array();
    if (basename(getcwd()) == 'php')
        $handle = opendir('../langues');
    else
        $handle = opendir('../../langues');
    while ( $fichier = readdir($handle) )
    	if (substr($fichier, strlen($fichier) - 4) === '.php')
            $fichiers_langue[] = basename($fichier, '.php');
    closedir($handle);
    return($fichiers_langue);
}

?>
