<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

//--------------------------------------------------------------------------------------------------------------------------------------------
//----------------------------------------------------- requetes SQL -------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------------

// Effectue une requête sur la table des contributions
// Sélectionne les contributions dont l'id et/ou le nom correspondent
// (sélectionne toutes les contributions si aucune valeur de champ n'est donnée)
function requete_lire_contributions($lien_bdd,$id_contribution=false, $nom_contribution=false)
{
    if ($id_contribution==false && $nom_contribution==false)
    {
        $requete = "SELECT id FROM contributions ORDER BY nom ASC";
    }
    else if ($id_contribution!=false && $nom_contribution==false)
    {
        $requete = "SELECT * FROM contributions WHERE id='$id_contribution'";
    }
    else if ($id_contribution==false && $nom_contribution!=false)
    {
        $requete ="SELECT id FROM contributions WHERE nom='".$nom_contribution."' ";
    }

    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

// Requête renvoyant tous les champs des contributions correspondant à un utilisateur dont on donne l'id
// inutilisable depuis la création des sous-projets (il faut faire plusieurs requêtes)
/*
function requete_contributions_utilisateur($id_utilisateur)
{
    $requete = "SELECT contributions.* FROM participants, projets, contributions WHERE participants.id_utilisateur='$id_utilisateur' AND projets.id=participants.id_projet AND contributions.id_projet=projets.id";
    $resultat = executer_requete($requete);
    return($resultat);
}
*/

// renvoie tous les champs du projet d'une contribution
function requete_projet_contribution($lien_bdd,$id_contribution)
{
    $requete = "SELECT projets.* FROM contributions, projets WHERE contributions.id='$id_contribution' AND contributions.id_projet=projets.id";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

// renvoie la date et l'id de l'utilisateur correspondant au verrouillage de la contribution dont l'id est passé en paramètre
function requete_lire_verrouillage_contribution($lien_bdd,$id_contribution)
{
    $requete = "SELECT UNIX_TIMESTAMP(date_edition), id_dernier_utilisateur FROM contributions WHERE id='$id_contribution'";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

// renvoie tous les champs de l'historique d'une contribution éditée à une date précise
function requete_historiques_utilisateur($lien_bdd,$id_contribution, $rep_date)
{
    $requete = "SELECT * FROM historiques WHERE id_contribution='$id_contribution' AND dossier_historique='$rep_date'";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

// renvoie tous les champs de l'historique d'une contribution de la date la plus récente
function requete_historique_contribution($lien_bdd,$id_contribution)
{
    $requete = "SELECT * FROM historiques WHERE id_contribution='$id_contribution' ORDER BY dossier_historique DESC LIMIT 1";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}


//
// requêtes d'edition

function requete_creer_contribution($lien_bdd,$nom_contribution, $id_projet, $config) 
{
    $requete = "INSERT INTO contributions (nom, config, id_projet) VALUES ('$nom_contribution','$config', '$id_projet')";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

function requete_verrouiller_contribution($lien_bdd,$id_utilisateur, $id_contribution) {
    $requete = "UPDATE contributions SET id_dernier_utilisateur='$id_utilisateur', date_edition=NOW() WHERE id='$id_contribution'";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

function requete_creer_historique($lien_bdd,$id_contribution, $id_utilisateur, $dossier_historique) {
    $requete = "INSERT INTO historiques (id_contribution, id_utilisateur, dossier_historique) VALUES ('$id_contribution','$id_utilisateur', '$dossier_historique' )";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

//
//requêtes de suppression

function requete_supprimer_contribution($lien_bdd,$id_contribution)
{
    $requete = "DELETE FROM contributions WHERE id = '$id_contribution'";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

function requete_modifier_projet_contribution($lien_bdd,$id_contribution, $id_projet)
{
    $requete = "UPDATE contributions SET id_projet='$id_projet' WHERE id='$id_contribution'";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

function requete_supprimer_historique($lien_bdd,$id_contribution)
{
    $requete = "DELETE FROM historiques WHERE id_contribution = '$id_contribution'";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}

function requete_renommer_contribution($lien_bdd,$id_contribution, $nom)
{
    if ($id_contribution == false || $nom == false)
        return(false);
    $requete = "UPDATE contributions SET nom=\"$nom\" WHERE id='$id_contribution' ";
    $resultat = executer_requete($requete,$lien_bdd);
    return($resultat);
}


//--------------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------- fonctions -------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------------------------------------

// paramètre : un nom de contribution et le repertoire de date
// sortie : login de l'utilisateur
function login_utilisateur_historique($lien_bdd,$id_contribution, $rep_date)
{
    $resultat_requete = requete_historiques_utilisateur($lien_bdd,$id_contribution, $rep_date);
    if (!tester_resultat($resultat_requete)) {
        //error_log("l'historique n'existe pas"); //erreur(HISTORIQUE_EXISTE_PAS);
        return;
    }
    if (nombre_de_lignes($resultat_requete) == 0) {
        //error_log("l'historique n'existe pas"); //erreur(HISTORIQUE_EXISTE_PAS);
        return;
    }
    $id_utilisateur = lire_premier_resultat($resultat_requete,'id_utilisateur');
    if (false !== ($utilisateur = utilisateur($lien_bdd,$id_utilisateur)))
        return($utilisateur['login']);
    else 
        return INCONNU;
}

// liste des contributions de l'historique
function liste_des_historiques_contribution($lien_bdd,$id_contribution)
{
    $resultat_requete = requete_historique_contribution($lien_bdd,$id_contribution);
    if (!tester_resultat($resultat_requete)) 
        erreur(ECHEC_REQUETE);
    $liste = lire_le_resultat($resultat_requete);
    return($liste);
}


// paramètre : un numero id de contribution
// sortie : une chaine de caracteres avec le nom de la contribution
function nom_contribution($lien_bdd,$id_contribution)
{
    $resultat_requete = requete_lire_contributions($lien_bdd,$id_contribution);
    if (!tester_resultat($resultat_requete))
        erreur(CONTRIBUTION_EXISTE_PAS);
    if (nombre_de_lignes($resultat_requete) == 0)
        erreur(CONTRIBUTION_EXISTE_PAS);
    $nom_contribution = lire_premier_resultat($resultat_requete, 'nom') ;
    return($nom_contribution );
}

// paramètre : un nom de contribution
// sortie : id de la contribution
function id_contribution($lien_bdd,$nom_contribution)
{
    $resultat_requete = requete_lire_contributions($lien_bdd,false,$nom_contribution);
    if (!tester_resultat($resultat_requete))
        erreur(CONTRIBUTION_EXISTE_PAS);
    if (nombre_de_lignes($resultat_requete) == 0)
        erreur(CONTRIBUTION_EXISTE_PAS);
    $id_contribution = lire_premier_resultat($resultat_requete, 'id') ;
    return($id_contribution);
}

// renvoie true si une contribution avec ce nom existe dans la BDD
function contribution_existe($lien_bdd,$nom_contribution) {
    $resultat_nom_contribution = requete_lire_contributions($lien_bdd,false, $nom_contribution);
    if (!tester_resultat($resultat_nom_contribution))
        erreur(ECHEC_REQUETE);
    return(nombre_de_lignes($resultat_nom_contribution) != 0);
}

// paramètre : un id de contribution
// sortie : l'id du projet de la contribution
function id_projet_contribution($lien_bdd,$id_contribution)
{
    $resultat_requete = requete_lire_contributions($lien_bdd,$id_contribution);
    if (!tester_resultat($resultat_requete))
        erreur(CONTRIBUTION_EXISTE_PAS);
    if (nombre_de_lignes($resultat_requete) == 0)
        erreur(CONTRIBUTION_EXISTE_PAS);
    $id_projet = lire_premier_resultat($resultat_requete, 'id_projet') ;
    return($id_projet);
}

// paramètre : un id de contribution
// sortie : le projet de la contribution
function projet_contribution($lien_bdd,$id_contribution)
{
    $resultat_requete = requete_projet_contribution($lien_bdd,$id_contribution);
    if (!tester_resultat($resultat_requete))
        erreur(CONTRIBUTION_EXISTE_PAS);
    if (nombre_de_lignes($resultat_requete) == 0)
        erreur(CONTRIBUTION_EXISTE_PAS);
    $projet = lire_premier_resultat($resultat_requete) ;
    return($projet);
}

// paramètre : un numero id de contribution
// sortie : une chaine de caracteres avec le nom de la config correspondante
function config_contribution($lien_bdd,$id_contribution)
{
    $resultat_requete = requete_lire_contributions($lien_bdd,$id_contribution);
    if (!tester_resultat($resultat_requete))
        erreur(CONTRIBUTION_EXISTE_PAS);
    if (nombre_de_lignes($resultat_requete) == 0)
        erreur(CONTRIBUTION_EXISTE_PAS);
    $config = lire_premier_resultat($resultat_requete, 'config');
    if ($config == FALSE)
        $config = $_SESSION['chemin_configuration_jaxe'];
    return($config );
}

// liste des id des contributions
// paramètres : pas de paramètres en entrée
// sortie : retroune un tableau avec la liste des id des contributions existantes, ou FALSE s'il n'y en a pas
function liste_id_contributions($lien_bdd)
{
    $resultat_requete = requete_lire_contributions($lien_bdd);
    if (!tester_resultat($resultat_requete))
        erreur(REQUETE_LISTE_CONTRIBUTION);
    $liste_des_contributions = lire_le_resultat($resultat_requete, 'id');
    return($liste_des_contributions);
}


// liste des contributions d'un utilisateur
// paramètres : un numero id d'utilisateur
// sortie : retourne un tableau aves la liste des contributions de l'utilisateur, ou FALSE s'il n'y en a pas
function liste_des_contributions_utilisateur($lien_bdd,$utilisateur)
{
    $liste = array();
    $liste_projets = liste_des_projets_utilisateur($lien_bdd,$id_utilisateur);
    $lien = connexion();
    for ($i=0; $i<count($liste_projets); $i++) {
        $projet = $liste_projets[$i];
        $contribs_projet = liste_des_contributions_projet($lien_bdd,$projet['id']);
        if ($contribs_projet != false)
            $liste = array_merge($liste, $contribs_projet);
    }
    deconnecte_base($lien);
    return($liste);
}


// liste des contributeurs d'une contribution (en prenant en compte les projets parents)
// paramètres : un numero id de contribution
// sortie : le résultat de la requête sql, contenant la liste des tuples de la table utilisateur des utilisateurs concernés par la contribution
function liste_contributeurs($lien_bdd,$id_contribution)
{
    $projet = projet_contribution($lien_bdd,$id_contribution);
    $projets = array($projet);
    $projets_ancetres = liste_projets_ancetres($lien_bdd,$projet['id']);
    if ($projets_ancetres != false)
        $projets = array_merge($projets, $projets_ancetres);
    $liste_contributeurs = array();
    //$lien_bdd = connexion();
    foreach ($projets as $projet) {
        $resultat_requete = requete_lire_participants($lien_bdd, $projet['id'], false);
        if (!tester_resultat($resultat_requete))
            erreur(ECHEC_REQUETE);
        $liste = lire_le_resultat($resultat_requete);
        if ($liste != false)
            $liste_contributeurs = fusion_utilisateurs($liste_contributeurs, $liste);
    }
    //deconnecte_base($lien_bdd);
    
    return($liste_contributeurs);
}


// Supprime une contribution, (possible uniquement par l'administrateur sauf s'il n'y a qu'une seule personne
// sur le projet de la contribution)
// paramètre : un numero id de contribution
// sortie : true en cas de réussite
function supprimer_contribution($lien_bdd,$id_contribution)
{
    if (count(liste_contributeurs($lien_bdd,$id_contribution)) > 1 && $_SESSION['status'] != "administrateur")
        return(false);
    
    $resultat_la_contribution_a_virer = requete_lire_contributions($lien_bdd,$id_contribution);
    if (!tester_resultat($resultat_la_contribution_a_virer))
        erreur(CONTRIBUTION_EXISTE_PAS);
    if (nombre_de_lignes($resultat_la_contribution_a_virer) == 0)
        erreur(CONTRIBUTION_EXISTE_PAS);
    $nom_contribution_a_virer = lire_premier_resultat($resultat_la_contribution_a_virer, 'nom');
    if ($nom_contribution_a_virer == FALSE || $nom_contribution_a_virer == '') {
        error_log("supprimer_contribution $id_contribution : nom_contribution_a_virer = $nom_contribution_a_virer");
        erreur(ECHEC_REQUETE);
    }
    
    // suppresion dans la table des contributions       
    $resultat_supprimer_contribution = requete_supprimer_contribution($lien_bdd,$id_contribution);
    if ( tester_resultat($resultat_supprimer_contribution) == FALSE )
        erreur(ECHEC_REQUETE);
    
    // suppresion dans la table des historiques
    $resultat_supprimer_historique = requete_supprimer_historique($lien_bdd,$id_contribution);
    if ( tester_resultat($resultat_supprimer_historique) == FALSE )
        erreur(ECHEC_REQUETE);
    
    // suppression du dossier de la contribution
    $chemin_vers_repertoire = "../../contribXML/".$nom_contribution_a_virer."/";
    $poubelle = "../../poubelle/".basename ($chemin_vers_repertoire);
    if ( is_dir($chemin_vers_repertoire) == FALSE ) {
        error_log("supprimer_contribution $id_contribution : is_dir($chemin_vers_repertoire) == FALSE");
        erreur(PAS_DOSSIER);
    }
    if ( is_dir(dirname($poubelle)) == FALSE ) {
        error_log("supprimer_contribution $id_contribution : is_dir(dirname($poubelle)) == FALSE");
        exit(POUBELLE_INTROUVABLE);
    }
    // on crée un dossier unique pour pourvoir éviter le cas où une contribution portant le même nom a été jetée auparavant 
    $poubelle = dossier_unique($poubelle);
    rmdir($poubelle);
    if ( rename($chemin_vers_repertoire, $poubelle) == FALSE )
        erreur(ERREUR_DEPLACEMENT);
    else
        supprimer_vraiment($poubelle);
    
    // suppression du site correspondant s'il existe
    $chemin_vers_site = "../../sites/".$nom_contribution_a_virer."/";
    if (is_dir($chemin_vers_site)) {
        $poubelle = "../../poubelle/sites".basename($chemin_vers_site);
        if ( is_dir(dirname($poubelle)) == FALSE )
            exit(POUBELLE_INTROUVABLE);
        // on crée un dossier unique pour pourvoir éviter le cas où une contribution portant le même nom a été jetée auparavant 
        $poubelle = dossier_unique($poubelle);
        rmdir($poubelle);
        if ( rename($chemin_vers_site, $poubelle) == FALSE )
            erreur(ERREUR_DEPLACEMENT);
        else
            supprimer_vraiment($poubelle);
    }
    
    // suppression de l'historique correspondant s'il existe
    $chemin_vers_historique = "../../historique/".$nom_contribution_a_virer."/";
    if (is_dir($chemin_vers_historique)) {
        $poubelle = "../../poubelle/historique".basename($chemin_vers_historique);
        if ( is_dir(dirname($poubelle)) == FALSE )
            exit(POUBELLE_INTROUVABLE);
        // on crée un dossier unique pour pourvoir éviter le cas où une contribution portant le même nom a été jetée auparavant 
        $poubelle = dossier_unique($poubelle);
        rmdir($poubelle);
        if ( rename($chemin_vers_historique, $poubelle) == FALSE )
            erreur(ERREUR_DEPLACEMENT);
        else
            supprimer_vraiment($poubelle);
    }
    
    return(true);
}

// Supprime toutes les contributions !
function supprimer_contributions($lien_bdd)
{
    $liste_des_contributions = liste_id_contributions($lien_bdd);
    if ($liste_des_contributions != false)
    {
        for ($i=0; $i<count($liste_des_contributions); $i++)
        {
            if ($liste_des_contributions[$i]==false)
                erreur("supprimer_contributions $liste_des_contributions");
            supprimer_contribution($liste_des_contributions[$i]);
        }
    }
}

// crée une nouvelle contribution
// paramètres : une chaine de caratère - le nom de la contribution a créer, et le nom de la config
// sortie : la valeur booléenne true si l'operation a réussie
function creer_contribution($lien_bdd,$nom_contribution, $id_projet, $config)
{
    verifie_nom_contribution($nom_contribution);
    verifie_nom_config($config);
    $id_contribution = 0;
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $chemin = "../../contribXML/".$nom_contribution;
    
    // On vérifie si une contribution portant le même nom existe déjà
    if (contribution_existe($lien_bdd,$nom_contribution))
        erreur(CONTRIB_MEME_NOM);
    if (file_exists($chemin)) 
    {
        error_log("creer_contribution: $chemin existe déjà");
        erreur(CONTRIB_MEME_NOM);
    }
    
    
    //add by sarra
    if(!file_exists($chemin))
    {
		if (!mkdir($chemin))
        error_log("creer_contribution: échec de mkdir $chemin");
        else
        {
			 // Création de la contribution
			$resultat_ecrire_contributions = requete_creer_contribution($lien_bdd,$nom_contribution, $id_projet, $config);
			if ( tester_resultat($resultat_ecrire_contributions) == FALSE )
				erreur(ECHEC_REQUETE);
		}
        //copy("../../config/".$_SESSION['chemin_configuration_jaxe']."/docvide.xml", $chemin."/".$nom_contribution.".xml");
	}
    // création du répertoire de la contribution
    
    return(true);
}

// change le projet d'une contribution
function modifier_projet_contribution($lien_bdd,$id_contribution, $id_projet) 
{
    $resultat = requete_modifier_projet_contribution($lien_bdd,$id_contribution, $id_projet);
    if (!tester_resultat($resultat))
        erreur(ECHEC_REQUETE);
    return(true);
}


function verrouiller_contribution($lien_bdd,$id_contribution)
{
    $id_utilisateur = $_SESSION['id_utilisateur'];
    $resultat = requete_verrouiller_contribution($lien_bdd,$id_utilisateur, $id_contribution);
    if (!tester_resultat($resultat))
        erreur(ECHEC_REQUETE);
    return(true);
}

function mettre_a_jour_verrouillage($lien_bdd,$id_contribution)
{
    $id_utilisateur =$_SESSION['id_utilisateur'];
    $resultat = requete_verrouiller_contribution($lien_bdd,$id_utilisateur, $id_contribution);
    return(true); // utilisation de $resultat ?
}

// renvoie l'id de l'utilisateur qui utilise la contribution si elle est verrrouillée par quelqu'un d'autre,
// ou FALSE sinon
function verifier_verrouillage($lien_bdd,$id_contribution)
{
    $id_utilisateur = $_SESSION['id_utilisateur'];
    
    $resultat_verifier_verrouillage = requete_lire_verrouillage_contribution($lien_bdd,$id_contribution);
    
    if ($resultat_verifier_verrouillage == FALSE )
        $resultat = FALSE;
    else
    {
        $verifier_verrouillage = lire_premier_resultat($resultat_verifier_verrouillage);
        if ($verifier_verrouillage['id_dernier_utilisateur'] == NULL || $verifier_verrouillage['id_dernier_utilisateur'] == $id_utilisateur)
            $resultat = FALSE;
        else
        {
            if (time() - $verifier_verrouillage[0] > 30)
                $resultat = FALSE;
            else
                $resultat = $verifier_verrouillage['id_dernier_utilisateur'];
        }
    }
    
    return($resultat);
}

// permet de changer le nom d'une contribution
function renommage_contribution($lien_bdd,$id_contribution, $nom) {
    verifie_nom_contribution($nom);
    renommer_contribution(nom_contribution($lien_bdd,$id_contribution), $nom); // renomme la contribution dans les dossiers contribXML, historique et sites
    $resultat_requete = requete_renommer_contribution($lien_bdd,$id_contribution, $nom); // renomme la contribution dans la bd
    if (!tester_resultat($resultat_requete))
        erreur(ECHEC_REQUETE);
    return(true);
}

?>
