<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

//include(dirname(__FILE__)."/connectes.php");

// renvoit TRUE si l'on peut se connecter au serveur et que la base de données existe, FALSE sinon
function tester_base()
{
    if (!isset($_SESSION['serveur_base_de_donnes']) || !isset($_SESSION['login_base_de_donnes']))
        return(FALSE);
    $lien = connecte_base($_SESSION['serveur_db'],$_SESSION['login_base_de_donnes'],$_SESSION['pass_base_de_donnes']);
    if ($lien != false)
    {
		$lien = null; 
		return(TRUE);
	}
	else
		return(FALSE);
    
}

// renvoit la variable de connexion à la base
//sarra
function connecte_base($serveur, $login, $password)
{
	try
	{
		//$lien = new PDO($serveur,$login,$password, array(PDO::ATTR_PERSISTENT => true,PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES \'UTF8\'')); //PDO::ATTR_PERSISTENT => true,
		$lien = new PDO($serveur,$login,$password, array(PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES \'UTF8\'')); 
	}
	catch (PDOException $e) 
	{
		$lien = false;
		error_log($e->getMessage(),0);
	}
	return($lien);		
}

// connexion à la base de données avec les paramètres de la session
// renvoie un identifiant de connexion, qui peut être utilisé ensuite dans les requêtes
// et pour se déconnecter (attention à toujours fermer les connexions)
function connexion() {
    $lien = connecte_base($_SESSION['serveur_db'], $_SESSION['login_base_de_donnes'], $_SESSION['pass_base_de_donnes']);
    return($lien);
}

function deconnecte_base($lien)
{
    //mysql_close($lien);
    if($lien)
		$lien = null;
}

// renvoit TRUE si la base de données contient des tables, FALSE sinon
function tester_tables()
{
    $link = connecte_base($_SESSION['serveur_db'], $_SESSION['login_base_de_donnes'], $_SESSION['pass_base_de_donnes']);
    $resultat = executer_requete('SHOW TABLES', $link);
    if ($resultat == FALSE || $resultat->rowCount() == 0) 
    {
        $resultat == null;
        $link == null;
        return(FALSE);
    }
    $resultat == null;
    deconnecte_base($link);
    return(TRUE);
}

// Crée la base en utilisant les variables de session pour la connexion et le nom de la base
function creer_base() {
    
    try
	{
		$lien = new PDO($_SESSION['serveur_db'],$_SESSION['login_base_de_donnes'],$_SESSION['pass_base_de_donnes'], array(PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES \'UTF8\'')); 
		
	}
	catch (PDOException $e) {
		//erreur($e->getMessage().$_SESSION['serveur_base_de_donnes']);
		//error_log($e->getMessage(),0);
		$lien = FALSE;
	}
	
	if($lien == TRUE)
	{
		erreur("Base de données existante");
	}
	else
	{
		
		try
		{
			$lien = new PDO("mysql:host=".$_SESSION['serveur_base_de_donnes'],$_SESSION['login_base_de_donnes'],$_SESSION['pass_base_de_donnes'], array(PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES \'UTF8\'')); 
		}
		catch (PDOException $e) {
			error_log($e->getMessage(),0);
		}		
		
		$nom_base = $_SESSION['nom_base_de_donnes'];
		$result = $lien->prepare('CREATE DATABASE '.$nom_base);
		$result->execute();
		
		if ( $result == FALSE ) {
			$result = null;
			$lien = null;
			erreur(ECHEC_CREATION_BD);
		}
	}
    
    $lien = null;
}


// retourne le résultat de la requête SQL
function executer_requete($requete,$lien_bdd)
{
    if ($lien_bdd === false || $lien_bdd === null )
		$lien_bdd = connexion();
  
    $resultat = $lien_bdd->prepare($requete);
    $resultat->execute();

    //if ($lien_bdd == false)
     //   deconnecte_base($link);
    return($resultat);
}

function tester_resultat($resultat)
{
    if ($resultat == FALSE)
        return(FALSE);
    else
        return(TRUE);
}

function nombre_de_lignes($resultat)
{
	return ($resultat->rowCount());
}

// Cette fonction retourne un tableau avec le résultat de la requête.
// On peut passer le nom d'un champ en paramètre pour le sélectionner, dans ce cas la fonction
// renvoie un tableau avec les valeurs du champ.
// Renvoie FALSE s'il n'y a pas de résultat pour la requête.
function lire_le_resultat_old($resultat, $champ=FALSE)
{
    if (nombre_de_lignes($resultat) == 0)
        return(FALSE);
    
    $tab_resultat_lu = array();
    $i = 0;
    while ($resultat_lu = mysql_fetch_array($resultat)) 
    {
        if ($champ === FALSE)
            $tab_resultat_lu[$i] = $resultat_lu;
        else
            $tab_resultat_lu[$i] = $resultat_lu[$champ];
        $i = $i+1;
    }
    return ($tab_resultat_lu);
}

//sarra
function lire_le_resultat($resultat, $champ=FALSE)
{
    if ($resultat->rowCount() == 0)
       return(FALSE);
    
    $tab_resultat_lu = array();
    $i = 0;
    while ($resultat_lu = $resultat->fetch()) 
    {
        if ($champ === FALSE)
            $tab_resultat_lu[$i] = $resultat_lu;
        else
            $tab_resultat_lu[$i] = $resultat_lu[$champ];
        $i = $i+1;
    }
    return ($tab_resultat_lu);
}

// Cette fonction retourne le premier résultat de la requête.
// On peut passer le nom d'un champ en paramètre pour le sélectionner, dans ce cas le résultat est
// la valeur du champ pour le premier résultat de la requête.
// Renvoie FALSE s'il n'y a pas de résultat pour la requête.
function lire_premier_resultat($resultat, $champ=FALSE)
{
    if ($resultat->rowCount() == 0)
		return(FALSE);

    $array1 = $resultat->fetch();
    if ($champ === FALSE)
        return($array1);
    else
        return($array1[$champ]);

}
// LAST_INSERT_ID()
function dernier_id($resultat) {
    return($resultat->lastInsertId());
}


?>
