<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

session_start();

if (!isset($_SESSION['langue']) || !$_SESSION['langue'])
    $_SESSION['langue'] = "fr";
$fichierlangue = dirname(__FILE__)."/../langues/".$_SESSION['langue'].".php";
require_once($fichierlangue);
require_once(dirname(__FILE__)."/include/outils.php");
require_once(dirname(__FILE__)."/include/utilisateurs.php");
require_once(dirname(__FILE__)."/include/base_de_donnees.php");
require_once(dirname(__FILE__)."/include/lecture_config.php");
require_once(dirname(__FILE__)."/include/tete_pied.php");
require_once(dirname(__FILE__)."/include/verification_noms.php");
require_once(dirname(__FILE__)."/include/email.php");

init_erreurs();

$_SESSION['section'] = "visiteur";

if (!isset($_POST['prenom']) || !isset($_POST['nom']) || !isset($_POST['login']) || !isset($_POST['motdepasse']) || !isset($_POST['langue']) || !isset($_POST['jeton']))
    erreur(PARAMETRES_MANQUANT);

if(!comparerJeton($_POST['jeton']))
    erreur(JETON_INVALIDE);

$login = $_POST['login'];
password_utilisateur($_POST['motdepasse']);
$motdepasse = md5($_POST['motdepasse']);
$prenom = $_POST['prenom'];
$nom = $_POST['nom'];
$langue = $_POST['langue'];
if (isset($_POST['email']))
    $email = $_POST['email'];
else
    $email = '';
$status = "utilisateur";
$_SESSION['login'] = $login;

prenom_utilisateur($prenom);
nom_utilisateur($nom);
login_utilisateur($login);

if ($email != "")
    verifie_email($email);

verifie_langue($langue);

debut_html(INSCRIPTION, INSCRIPTION);
$lien_bdd = connexion();
$result = creation_compte_temporaire($lien_bdd,$prenom, $nom, $login, $status, $motdepasse, $langue, $email);
if( $result == TRUE )
{
    $to = '';
    $administrateurs = liste_administrateurs();
    if ($administrateurs != FALSE) {
        for ($i=0; $i<count($administrateurs); $i++) {
            $administrateur = $administrateurs[$i];
            $email = $administrateur['email'];
            if ($i == count($administrateurs)-1)
                $to .= $email;
            else
                $to .= $email.', ';
        }
    }
    
    $from = $_SESSION['email_admin'];
    if ($from != '' && $to != '') {
        $subject = NOUVEAU_UTILISATEUR_WJ." <".$login.">";
        $message = L_UTILISATEUR." ".$login." (".ucfirst($prenom)." ".strtoupper($nom).") ".VIENT_SINSCRIRE_A_WJ;
        envoi_mail($from, $to, $subject, $message);
    }
    echo "<p>".$login.VOUS_ETES_ENREGISTRE."</p>";
    echo "<p>".ATTENDRE_ACTIVATION."</p>";
    echo '<p><a href="index.php">'.RETOUR.'</a></p>';
    exit;
}
else
{
    echo "<p>".ECHEC_REQUETE."</p></body></html>";   
}
fin_html();
deconnecte_base();

?>
