<?php
// script pour PHP4.3+ ou PHP5, on suppose que magic_quotes est on
// encodage : UTF-8 (PHP est incapable de gérer un autre encodage...)

/*
XPAGES pour WebJaxe

Copyright (C) 2007 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

require_once("outils_xpages.php");


// Types de site qui peuvent être générés (peut correspondre à des paramètres de la feuille de style).
// Il n'est pas nécessaire de définir cette fonction si la feuille de style n'a pas de paramètres.
function types_sites() {
    $noms = array('auteurs', 'public');
    if ($_SESSION['langue'] == 'en')
        $titres = array('auteurs'=>'authors', 'public'=>'public');
    else if ($_SESSION['langue'] == 'de')
        $titres = array('auteurs'=>'Autoren', 'public'=>'öffentlichen');
    else
        $titres = array('auteurs'=>'auteurs', 'public'=>'public');
    return array(
        'noms' => $noms,
        'titres' => $titres
    );
}

// Transformation WebJaxe pour la production d'un site web à partir de documents XPAGES
function transfo_webjaxe($dossier_contribs, $xml_a_traiter, $chemin_site, $dossier_config, $dossier_temp, $redirection, $type) {
    
    $sep = DIRECTORY_SEPARATOR;
    
    if (! is_file($xml_a_traiter))
        erreur_xpages("Le fichier XML n'existe pas.");
    
    verifier_label($xml_a_traiter);
    
    $dossier_interface = $dossier_config.$sep."interface";
    $dossier_xsl = $dossier_config;
    
    // fichiers temporaires
    if (!is_dir($dossier_temp))
        mkdir($dossier_temp);
    $tmpxml = tempnam($dossier_temp, 'xml');
    $acopier = tempnam($dossier_temp, 'copier');
    $imagesxml = $chemin_site.$sep.'images.xml';
    
    $silencieux = ($redirection == NULL);
    if (!$silencieux) {
        while (ob_get_level() > 0) {
            ob_end_flush();
        }
        set_error_handler('erreurXPAGES');
        echo '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">'."\n";
        echo "<html><head>\n";
        echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">'."\n";
        echo "<title>Génération du site</title>";
        echo "</head><body>";
        echo "<p>Regroupement des fichiers XML...</p>";
        flush();
    }
    regroupement_xml($xml_a_traiter, $tmpxml, $dossier_xsl);
    
    if(!$dom = creation_liste_acopier($xml_a_traiter, $tmpxml, $acopier, $dossier_xsl))
        erreur_xpages("erreur à l'ouverture du fichier intermédiaire ".$acopier);
    
    if (!$silencieux) {
        echo "<p>Copie des fichiers attachés...</p>";
        flush();
    }
    copie_dossiers($dom, $chemin_site);
    
    if (!$silencieux) {
        echo "<p>Traitement des images...</p>";
        flush();
    }
    traitement_images($dom, $dossier_contribs, $chemin_site, $imagesxml);
    
    images_equations($dom, $chemin_site);
    
    if (!$silencieux) {
        echo "<p>Création des fichiers HTML...</p>";
        flush();
    }
    $tmphtml = tempnam($dossier_temp, 'html');
    creation_html($xml_a_traiter, $tmpxml, $tmphtml, $chemin_site, $dossier_xsl, $type);
    
    // effacement des fichiers temporaires
    nettoyage($acopier, $tmpxml, $imagesxml, $tmphtml);
    
    if (!$silencieux) {
        echo "<p>Copie du dossier d'interface...</p>";
        flush();
    }
    // copie du dossier d'interface
    copier_dossier($dossier_interface, $chemin_site.$sep.basename($dossier_interface));
    
    if (!$silencieux) {
        echo "<p>Fini !</p>";
        echo "<p><a href=\"$redirection\">Redirection</a> en cours...</p>";
        echo "<script type=\"text/javascript\">window.addEventListener ? window.addEventListener('load', function() { window.location.replace('$redirection') }, false) : window.attachEvent('onload', function() { window.location.replace('$redirection') });</script>";
        echo "</body>\n";
        echo "</html>";
        flush();
    }
}

function erreurXPAGES($errno, $errstr, $errfile, $errline) {
    echo "<p>Erreur $errno: $errstr dans $errfile ligne $errline</p>";
    exit;
}

function verifier_label($xml_a_traiter) {
    $label = '';
    $services = file($xml_a_traiter);
    foreach ($services as $s) {
        if (preg_match ("/<LABEL>(.*)<\/LABEL>/", $s, $trouve)) {
            $label = $trouve[1];
            break;
        }
    }
    if ($label != basename(dirname($xml_a_traiter)))
        erreur_xpages("Mauvais label pour la contribution (".$label." != ".basename(dirname($xml_a_traiter)).")");
}


// Regroupement du site à créer dans un grand fichier XML
function regroupement_xml($xml_a_traiter, $tmpxml, $dossier_xsl) {
    $params = array(
        'jaxe-uri-xml' => 'file://'.str_replace('\\', '/', $xml_a_traiter)
    );
    transfo_XSLT($xml_a_traiter, $dossier_xsl.DIRECTORY_SEPARATOR.'XPAGES1.xsl', $tmpxml, $params);
}


// Création du fichier XML avec la liste des dossiers à copier et des images à traiter
function creation_liste_acopier($xml_a_traiter, $tmpxml, $acopier, $dossier_xsl) {
    $params = array(
        'jaxe-fichier-xml' => $xml_a_traiter
    );
    transfo_XSLT($tmpxml, $dossier_xsl.DIRECTORY_SEPARATOR.'XPAGES2PHP.xsl', $acopier, $params);
    if (PHP_VERSION >= 5) {
        $dom = new DOMDocument();
        if (!$dom->load($acopier))
            return(false);
        return($dom);
    } else
        return(domxml_open_file($acopier)); // nécessite DOM XML
}


// Copie des dossiers des contributions dans le nouveau site
function copie_dossiers($dom, $chemin_site) {
    if (!is_dir($chemin_site))
        mkdir($chemin_site);
    if (PHP_VERSION >= 5)
        $dossiers = $dom->getElementsByTagName('DOSSIER');
    else
        $dossiers = $dom->get_elements_by_tagname('DOSSIER');
    foreach ($dossiers as $dossier) {
        if (PHP_VERSION >= 5)
            $chemin = $dossier->getAttribute('chemin');
        else
            $chemin = $dossier->get_attribute('chemin');
        $nomcontrib = basename($chemin);
        $dossier_sortie = $chemin_site.DIRECTORY_SEPARATOR.'pages_'.$nomcontrib;
        if (is_dir($chemin)) {
            copier_dossier($chemin, $dossier_sortie);
            $fxml = $dossier_sortie.DIRECTORY_SEPARATOR.$nomcontrib.'.xml';
            if (file_exists($fxml))
                unlink($fxml);
            $htmlimages = $dossier_sortie.DIRECTORY_SEPARATOR.'html_images';
            if (!is_dir($htmlimages))
                mkdir($htmlimages);
        } else if (!is_dir($dossier_sortie))
            mkdir($dossier_sortie);
    }
}


// Réduction des images et création de images.xml
function traitement_images($dom, $dossier_contribs, $chemin_site, $imagesxml) {
    $sep = DIRECTORY_SEPARATOR;
    
    if (PHP_VERSION >= 5) {
        $images = $dom->getElementsByTagName('IMAGE');
        $images_dom = new DOMDocument('1.0');
        $racine = $images_dom->appendChild($images_dom->createElement('IMAGES'));
    } else {
        $images = $dom->get_elements_by_tagname('IMAGE');
        $images_dom = domxml_new_doc('1.0');
        $racine = $images_dom->append_child($images_dom->create_element('IMAGES'));
    }
    foreach ($images as $image) {
        if (PHP_VERSION >= 5) {
            $nom = $image->getAttribute('nom');
            $contrib = $image->getAttribute('contrib');
            $localisation = $image->getAttribute('localisation');
        } else {
            $nom = $image->get_attribute('nom');
            $contrib = $image->get_attribute('contrib');
            $localisation = $image->get_attribute('localisation');
        }
        $chemin_image = $dossier_contribs.$sep.$contrib.$sep.$nom;
        if (! is_file($chemin_image))
            erreur_xpages("Fichier manquant: ".$nom);
        
        $path_info = pathinfo($chemin_image);
        $ext = strtolower($path_info['extension']);
        if ($ext == 'mpg' || $ext == 'mpeg') {
            $tdim = dimensions_mpeg($chemin_image);
            $format = -1;
            if ($tdim) {
                $largeur1 = $tdim[0];
                $hauteur1 = $tdim[1];
            }
        } else if ($ext == 'mp4') {
            $tdim = dimensions_mp4($chemin_image);
            $format = -1;
            if ($tdim) {
                $largeur1 = $tdim[0];
                $hauteur1 = $tdim[1];
            }
        } else if ($ext == 'ogg' || $ext == 'ogv') {
            $tdim = dimensions_ogg($chemin_image);
            $format = -1;
            if ($tdim) {
                $largeur1 = $tdim[0];
                $hauteur1 = $tdim[1];
            }
        } else if ($ext == 'webm') {
            $tdim = dimensions_webm($chemin_image);
            $format = -1;
            if ($tdim) {
                $largeur1 = $tdim[0];
                $hauteur1 = $tdim[1];
            }
        } else {
            $infos = getimagesize($chemin_image);
            $largeur1 = $infos[0];
            $hauteur1 = $infos[1];
            $format = $infos[2];
        }
        
        if ($format == IMAGETYPE_PNG || $format == IMAGETYPE_JPEG || $format == IMAGETYPE_GIF) {
            if ($localisation == 'texte') {
                $largeur_max = 700;
                $hauteur_max = 700;
                $dossier_images = 'images_texte';
            } else if ($localisation == 'page') {
                $largeur_max = 300;
                $hauteur_max = 300;
                $dossier_images = 'images_page';
            } else if ($localisation == 'icône') {
                $largeur_max = 100;
                $hauteur_max = 100;
                $dossier_images = 'images_icone';
            }
            if ($largeur1 > $largeur_max || $hauteur1 > $hauteur_max) {
                $redim = 'oui';
                if ($format == IMAGETYPE_GIF && est_anime($chemin_image)) {
                    // on n'essaye pas de redimensionner les GIF animés, c'est trop dur en PHP !
                    if ($largeur1 / $largeur_max > $hauteur1 / $hauteur_max) {
                        $largeur2 = $largeur_max;
                        $hauteur2 = round(($largeur_max / $largeur1) * $hauteur1);
                        if ($hauteur2 > $hauteur_max)
                            $hauteur2 = $hauteur_max;
                    } else {
                        $hauteur2 = $hauteur_max;
                        $largeur2 = round(($hauteur_max / $hauteur1) * $largeur1);
                        if ($largeur2 > $largeur_max)
                            $largeur2 = $largeur_max;
                    }
                    $chemin_image2 = $chemin_site.$sep.'pages_'.$contrib.$sep.$dossier_images.$sep.$nom;
                    mkdir_recursif(dirname($chemin_image2));
                    copy($chemin_image, $chemin_image2);
                } else {
                    $img = lire_image($chemin_image, $format);
                    if (! $img)
                        erreur_xpages("Erreur à la lecture de l'image: ".$chemin_image);
                    $img2 = redimensionner($img, $largeur_max, $hauteur_max);
                    imagedestroy($img);
                    if (! $img2)
                        erreur_xpages("Erreur au redimensionnement de l'image: ".$chemin_image);
                    else {
                        $largeur2 = imagesx($img2);
                        $hauteur2 = imagesy($img2);
                    }
                    $chemin_image2 = $chemin_site.$sep.'pages_'.$contrib.$sep.$dossier_images.$sep.$nom;
                    if (! enregistrer_image($img2, $chemin_image2, $format))
                        erreur_xpages("Erreur à l'enregistrement de l'image: ".$chemin_image2);
                    imagedestroy($img2);
                }
            } else
                $redim = 'non';
        } else
            $redim = 'non';
        if (PHP_VERSION >= 5) {
            $nimage = $images_dom->createElement('IMAGE');
            $nimage->setAttribute('nom', $nom);
            $nimage->setAttribute('contrib', $contrib);
            $nimage->setAttribute('localisation', $localisation);
            $nimage->setAttribute('redim', $redim);
            $nimage->setAttribute('largeur1', $largeur1);
            $nimage->setAttribute('hauteur1', $hauteur1);
            if ($redim == 'oui') {
                $nimage->setAttribute('largeur2', $largeur2);
                $nimage->setAttribute('hauteur2', $hauteur2);
            }
            $racine->appendChild($nimage);
        } else {
            $nimage = $images_dom->create_element('IMAGE');
            $nimage->set_attribute('nom', $nom);
            $nimage->set_attribute('contrib', $contrib);
            $nimage->set_attribute('localisation', $localisation);
            $nimage->set_attribute('redim', $redim);
            $nimage->set_attribute('largeur1', $largeur1);
            $nimage->set_attribute('hauteur1', $hauteur1);
            if ($redim == 'oui') {
                $nimage->set_attribute('largeur2', $largeur2);
                $nimage->set_attribute('hauteur2', $hauteur2);
            }
            $racine->append_child($nimage);
        }
    }
    if (PHP_VERSION >= 5)
        $images_dom->save($imagesxml);
    else
        $images_dom->dump_file($imagesxml, false, true);
}


// Les fichiers des images doivent être créés à partir du contenu,
// au format PNG et encodé en base64.
function images_equations($dom, $chemin_site) {
    $sep = DIRECTORY_SEPARATOR;
    
    if (PHP_VERSION >= 5)
        $equations = $dom->getElementsByTagName('EQUATION');
    else
        $equations = $dom->get_elements_by_tagname('EQUATION');
    foreach ($equations as $equation) {
        if (PHP_VERSION >= 5) {
            $numero = $equation->getAttribute('numero');
            $ensemble = $equation->getAttribute('ensemble');
            $contrib = $equation->getAttribute('contrib');
            $fc = $equation->firstChild;
            if ($fc)
                $donnees = $fc->nodeValue;
            else
                $donnees = '';
        } else {
            $numero = $equation->get_attribute('numero');
            $ensemble = $equation->get_attribute('ensemble');
            $contrib = $equation->get_attribute('contrib');
            $fc = $equation->first_child();
            if ($fc)
                $donnees = $fc->node_value();
            else
                $donnees = '';
        }
        if ($donnees == '')
            erreur_xpages("Equation ".$numero." de ".$contrib." sans image ?");
        else {
            $dossier_contrib = $chemin_site.$sep.'pages_'.$contrib;
            if (!is_dir($dossier_contrib))
                mkdir($dossier_contrib, 0755);
            $dossier_equations = $dossier_contrib.$sep.'equations_'.$ensemble;
            if (!is_dir($dossier_equations))
                mkdir($dossier_equations, 0755);
            $chemin_image = $dossier_equations.$sep.'equation'.$numero.'.png';
            $f = fopen($chemin_image, "wb");
            fwrite($f, base64_decode($donnees));
            fclose($f);
        }
    }
}


// création des fichiers HTML
function creation_html($xml_a_traiter, $tmpxml, $tmphtml, $chemin_site, $dossier_xsl, $type) {
    $nom_XPAGES3 = 'XPAGES3.xsl';
    if (preg_match('/^[a-zA-Z]:\\\\/', $dossier_xsl))
        $jaxe_uri_xsl = 'file:///'.str_replace('\\', '/', $dossier_xsl).'/'.$nom_XPAGES3; // windows : file:///C:/etc
    else
        $jaxe_uri_xsl = 'file://'.$dossier_xsl.'/'.$nom_XPAGES3;
    if (preg_match('/^[a-zA-Z]:\\\\/', $chemin_site))
        $uri_site = 'file:///'.str_replace('\\', '/', $chemin_site);
    else
        $uri_site = 'file://'.$chemin_site;
    if ($type == 'public')
        $sortie = 'public';
    else
        $sortie = 'production';
    $params = array(
        'jaxe-fichier-xml' => $xml_a_traiter,
        'jaxe-uri-xsl' => $jaxe_uri_xsl,
        'jaxe-uri-xml' => $xml_a_traiter,
        'sortie' => $sortie,
        'chemin-site' => $chemin_site,
        'uri-site' => $uri_site
    );
    transfo_XSLT($tmpxml, $dossier_xsl.DIRECTORY_SEPARATOR.$nom_XPAGES3, $tmphtml, $params);
}


// effacement des fichiers temporaires
function nettoyage($acopier, $tmpxml, $imagesxml, $tmphtml) {
    unlink($acopier);
    unlink($tmpxml);
    unlink($imagesxml);
    unlink($tmphtml);
}

?>
