<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>
    
    <xsl:param name="jaxe-fichier-xml"/>
    
    <!-- Renvoit un fichier identifiant les dossiers des contributions  copier et les images  rduire -->
    
    <!-- sparateur de chemins ( / ou \ ) -->
    <xsl:variable name="sep"><xsl:choose>
        <xsl:when test="contains($jaxe-fichier-xml, '\')">\</xsl:when>
        <xsl:otherwise>/</xsl:otherwise>
    </xsl:choose></xsl:variable>
    
    <!-- chemin du rpertoire du fichier XML -->
    <xsl:variable name="chemin-xml"><xsl:call-template name="rep-fichier"><xsl:with-param name="chemin" select="$jaxe-fichier-xml"/></xsl:call-template></xsl:variable>
    
    <!-- chemin du rpertoire contribXML (dans lequel se trouvent toutes les contributions) -->
    <xsl:variable name="chemin-contrib"><xsl:call-template name="rep-fichier"><xsl:with-param name="chemin" select="$chemin-xml"/></xsl:call-template></xsl:variable>
    
    
    <xsl:template match="/">
        
        <!-- nom du fichier XML (qui doit tre gal au label de l'ensemble) -->
        <xsl:variable name="nomfichierxml"><xsl:call-template name="nom-fichier">
            <xsl:with-param name="chemin" select="$jaxe-fichier-xml"/>
        </xsl:call-template></xsl:variable>
        
        <!-- nom du rpertoire du fichier XML (qui doit tre gal au label de l'ensemble) -->
        <xsl:variable name="nomrep"><xsl:call-template name="nom-fichier">
            <xsl:with-param name="chemin" select="$chemin-xml"/>
        </xsl:call-template></xsl:variable>
        
        <xsl:if test="$nomrep = XPAGES/INFORMATIONS/LABEL and $nomfichierxml = concat($nomrep, '.xml')">
            <ACOPIER>
                <xsl:call-template name="dossiers-contrib"/>
                <xsl:call-template name="images"/>
                <xsl:call-template name="equations"/>
            </ACOPIER>
        </xsl:if>
    </xsl:template>
    
    
    <!-- Liste les dossiers des contributions -->
    <xsl:template name="dossiers-contrib">
        <xsl:for-each select="//XPAGES">
            <xsl:variable name="label-ensemble" select="INFORMATIONS/LABEL"/>
            <xsl:if test="@contribution='oui' and $label-ensemble!=''">
                <DOSSIER chemin="{concat($chemin-contrib, $sep, $label-ensemble)}"/>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <!-- Liste des images. Les images trop grandes (en fonction de la localisation) seront rduites. -->
    <xsl:template name="images">
        <xsl:for-each select="//FICHIER[@nom!='']">
            <xsl:variable name="label-fichiers" select="ancestor::XPAGES[1]/@labelfichiers"/>
            <xsl:variable name="localisation"><xsl:choose>
                <xsl:when test="ancestor::ENVIMAGE[1]/@localisation!=''"><xsl:value-of select="ancestor::ENVIMAGE[1]/@localisation"/></xsl:when>
                <xsl:otherwise>texte</xsl:otherwise>
            </xsl:choose></xsl:variable>
            <IMAGE nom="{@nom|@fichier}" contrib="{$label-fichiers}" localisation="{$localisation}"/>
            <!-- rduction pour l'impression (localisation: texte) -->
            <xsl:if test="$localisation!='texte'">
                <IMAGE nom="{@nom|@fichier}" contrib="{$label-fichiers}" localisation="texte"/>
            </xsl:if>
        </xsl:for-each>
        <!-- //FICHIER[@nom!='']|//LOGO[@fichier!=''] n'est pas compris pas Sablotron -->
        <xsl:for-each select="//LOGO[@fichier!='' and not(starts-with(@fichier,'http://'))]">
            <xsl:variable name="label-fichiers" select="ancestor::XPAGES[1]/@labelfichiers"/>
            <xsl:variable name="localisation"><xsl:choose>
                <xsl:when test="ancestor::ENVIMAGE[1]/@localisation!=''"><xsl:value-of select="ancestor::ENVIMAGE[1]/@localisation"/></xsl:when>
                <xsl:otherwise>texte</xsl:otherwise>
            </xsl:choose></xsl:variable>
            <IMAGE nom="{@nom|@fichier}" contrib="{$label-fichiers}" localisation="{$localisation}"/>
        </xsl:for-each>
    </xsl:template>
    
    <!-- Liste des quations. Les fichiers des images doivent tre crs  partir du contenu en PNG base64 -->
    <xsl:template name="equations">
        <xsl:for-each select="//EQUATION | //EQUATEX">
            <xsl:variable name="label-ensemble" select="ancestor::XPAGES[1]/INFORMATIONS/LABEL"/>
            <xsl:variable name="label-fichiers" select="ancestor::XPAGES[1]/@labelfichiers"/>
            <xsl:variable name="numero"><xsl:number from="XPAGES[INFORMATIONS/LABEL=$label-ensemble]" count="EQUATION|EQUATEX" level="any"/></xsl:variable>
            <EQUATION ensemble="{$label-ensemble}" contrib="{$label-fichiers}" numero="{$numero}"><xsl:value-of select="."/></EQUATION>
        </xsl:for-each>
    </xsl:template>
    
    
    <!-- Templates outils -->
    
    <xsl:template name="nom-fichier">
    <!-- renvoit le nom d'un fichier  partir du chemin-->
        <xsl:param name="chemin"/>
        <xsl:choose>
            <xsl:when test="contains($chemin,$sep)">
                <xsl:call-template name="nom-fichier"><xsl:with-param name="chemin" select="substring-after($chemin,$sep)"/></xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$chemin"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="rep-fichier">
        <!-- renvoit le chemin du rpertoire d'un fichier  partir du chemin complet vers le fichier-->
        <xsl:param name="chemin"/>
        <xsl:choose>
            <xsl:when test="contains($chemin,$sep) and contains(substring-after($chemin,$sep),$sep)">
                <xsl:value-of select="substring-before($chemin,$sep)"/><xsl:value-of select="$sep"/><xsl:call-template name="rep-fichier"><xsl:with-param name="chemin" select="substring-after($chemin,$sep)"/></xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="substring-before($chemin,$sep)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
