<?php
// WebJaxe, Observatoire de Paris, licence GPL
// encodage : UTF-8

// Transformation WebJaxe pour la production d'un site web à partir de documents XPAGES
function transfo_webjaxe($dossier_contribs, $xml_a_traiter, $chemin_site, $dossier_config, $dossier_temp, $redirection) {
    
    $sep = DIRECTORY_SEPARATOR;
    
    if (! is_file($xml_a_traiter))
        erreur_xhtml("Le fichier XML n'existe pas.");
    
    // transformation du XML en HTML
    if (!is_dir($chemin_site))
        mkdir($chemin_site);
    $indexhtml = $chemin_site.$sep.'index.html';
    $params = array( );
    transfo_XSLT($xml_a_traiter, $dossier_config.DIRECTORY_SEPARATOR.'XHTML.xsl', $indexhtml, $params);
    
    // copie des fichiers associés
    copier_dossier(dirname($xml_a_traiter), $chemin_site);
    unlink($chemin_site.$sep.basename($xml_a_traiter));
    
    if ($redirection != NULL)
        header("Location:".$redirection);
}


// lance une erreur avec un message d'erreur
function erreur_xhtml($message) {
    trigger_error($message, E_USER_ERROR);
}


// Transformation XSLT
// Paramètres:
//     nom_fichier_entree: string
//     nom_fichier_xslt: string
//     nom_fichier_sortie: string
//     parametres: array (paramètres passés à la feuille de style)
function transfo_XSLT($nom_fichier_entree, $nom_fichier_xslt, $nom_fichier_sortie, $parametres) {
    if (PHP_VERSION >= 5) {
        $xsltproc = new XSLTProcessor();
        
        $domdoc_xslt = new DOMDocument();
        $domdoc_xslt->load($nom_fichier_xslt);
        $xsltproc->importStyleSheet($domdoc_xslt);
        if ($parametres) {
            foreach ($parametres as $param => $value) {
                $xsltproc->setParameter('', $param, $value);
            }
        }
        
        $domdoc_entree = new DOMDocument();
        $domdoc_entree->load($nom_fichier_entree);
        $result = $xsltproc->transformToURI($domdoc_entree, $nom_fichier_sortie);
        if ($result)
            return($result);
        else
            erreur_xhtml("Erreur dans la transformation XSLT");
    } else {
        $xsltproc = xslt_create(); // nécessite l'extension XSLT avec Sablotron et iconv
        xslt_set_encoding($xsltproc, 'ISO-8859-1');
        $xsl_string = join('', file($nom_fichier_xslt));
        $xml_string = join('', file($nom_fichier_entree));
        $arg_buffer = array('/xml' => $xml_string, '/xsl' => $xsl_string);
        $result = xslt_process($xsltproc, 'arg:/xml', 'arg:/xsl', NULL, $arg_buffer, $parametres);
        if ($result) {
            xslt_free($xsltproc);
            $fp = fopen($nom_fichier_sortie, "w+");
            fwrite($fp, $result);
            fclose($fp);
            return($result);
        } else {
            $errstr = xslt_error($xsltproc);
            $errno = xslt_errno($xsltproc);
            xslt_free($xsltproc);
            erreur_xhtml("Erreur dans la transformation XSLT: ".$errstr." code d'erreur: ".$errno);
        }
    }
}


// Copie d'un dossier source vers un dossier destination (attention, le dossier source
//     est copié *vers* le dossier destination, pas *à l'intérieur*)
function copier_dossier($source, $dest) {
    if (is_file($source)) {
        $c = copy($source, $dest);
        return $c;
    }
    
    if (!is_dir($dest))
        mkdir($dest);
    
    $dir = dir($source);
    while (false !== $entry = $dir->read()) {
        if ($entry == '.' || $entry == '..')
            continue;
        
        if ($dest !== "$source/$entry")
            copier_dossier("$source/$entry", "$dest/$entry");
    }
    
    $dir->close();
    return true;
}
