/*
 * Decompiled with CFR 0.152.
 */
package jaxe.wxs;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jaxe.wxs.Parent;
import jaxe.wxs.WXSAnnotated;
import jaxe.wxs.WXSList;
import jaxe.wxs.WXSRestriction;
import jaxe.wxs.WXSSchema;
import jaxe.wxs.WXSThing;
import jaxe.wxs.WXSType;
import jaxe.wxs.WXSUnion;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WXSSimpleType
extends WXSAnnotated
implements WXSType {
    private static final Logger LOG = Logger.getLogger(WXSSimpleType.class);
    protected WXSRestriction restriction = null;
    protected WXSList list = null;
    protected WXSUnion union = null;
    protected String name = null;
    protected Parent parent;
    protected WXSSchema schema;

    public WXSSimpleType(Element element, Parent parent, WXSSchema wXSSchema) {
        this.parseAnnotation(element);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            if ("restriction".equals(node.getLocalName())) {
                this.restriction = new WXSRestriction((Element)node, null, wXSSchema);
                continue;
            }
            if ("list".equals(node.getLocalName())) {
                this.list = new WXSList((Element)node, wXSSchema);
                continue;
            }
            if (!"union".equals(node.getLocalName())) continue;
            this.union = new WXSUnion((Element)node, wXSSchema);
        }
        if (element.getAttributeNode("name") != null) {
            this.name = element.getAttribute("name");
        }
        this.parent = parent;
        this.schema = wXSSchema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.schema.getTargetNamespace();
    }

    @Override
    public Parent getParent() {
        return this.parent;
    }

    @Override
    public void resoudreReferences(WXSSchema wXSSchema, WXSThing wXSThing) {
        if (this.restriction != null) {
            this.restriction.resoudreReferences(wXSSchema, wXSThing);
        }
        if (this.list != null) {
            this.list.resoudreReferences(wXSSchema, wXSThing);
        }
        if (this.union != null) {
            this.union.resoudreReferences(wXSSchema, wXSThing);
        }
    }

    @Override
    public ArrayList<String> listeValeurs() {
        if (this.restriction != null) {
            return this.restriction.listeValeurs();
        }
        if (this.union != null) {
            return this.union.listeValeurs();
        }
        return null;
    }

    @Override
    public boolean validerValeur(String string) {
        if (this.restriction != null) {
            return this.restriction.validerValeur(string);
        }
        if (this.list != null) {
            return this.list.validerValeur(string);
        }
        if (this.union != null) {
            return this.union.validerValeur(string);
        }
        return false;
    }

    public static boolean validerValeur(String string, String string2) {
        if ("string".equals(string)) {
            return true;
        }
        if ("normalizedString".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[^\\t\\r\\n]*");
        }
        if ("token".equals(string)) {
            if (string2.indexOf(10) != -1 || string2.indexOf(13) != -1 || string2.indexOf(9) != -1 || string2.indexOf("  ") != -1) {
                return false;
            }
            return !string2.startsWith(" ") && !string2.endsWith(" ");
        }
        if ("base64Binary".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "(([a-zA-Z0-9+/=]\\s?){4})*");
        }
        if ("hexBinary".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "(([0-9a-fA-F]){2})*");
        }
        if ("integer".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[+\\-]?\\d+");
        }
        if ("positiveInteger".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "\\+?0*[1-9]\\d*");
        }
        if ("negativeInteger".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "-0*[1-9]\\d*");
        }
        if ("nonNegativeInteger".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "(-0+)|(\\+?\\d+)");
        }
        if ("nonPositiveInteger".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "(\\+?0+)|(-\\d+)");
        }
        if ("long".equals(string)) {
            if (!WXSSimpleType.verifExpr(string2, "[+\\-]?\\d+")) {
                return false;
            }
            try {
                BigInteger bigInteger = new BigInteger(string2);
                BigInteger bigInteger2 = new BigInteger("9223372036854775807");
                BigInteger bigInteger3 = new BigInteger("-9223372036854775808");
                if (bigInteger.compareTo(bigInteger2) > 0) {
                    return false;
                }
                return bigInteger.compareTo(bigInteger3) >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("validerValeur(String, String) - NumberFormatException", numberFormatException);
                return false;
            }
        }
        if ("unsignedLong".equals(string)) {
            if (!WXSSimpleType.verifExpr(string2, "\\d+")) {
                return false;
            }
            try {
                BigInteger bigInteger = new BigInteger(string2);
                BigInteger bigInteger4 = new BigInteger("18446744073709551615");
                return bigInteger.compareTo(bigInteger4) <= 0;
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("validerValeur(String, String) - NumberFormatException", numberFormatException);
                return false;
            }
        }
        if ("int".equals(string)) {
            if (!WXSSimpleType.verifExpr(string2, "[+\\-]?\\d+")) {
                return false;
            }
            String string3 = string2;
            if (string3.startsWith("+")) {
                string3 = string3.substring(1);
            }
            try {
                long l = Long.parseLong(string3);
                return l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE;
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("validerValeur(String, String) - NumberFormatException", numberFormatException);
                return false;
            }
        }
        if ("unsignedInt".equals(string)) {
            if (!WXSSimpleType.verifExpr(string2, "\\d+")) {
                return false;
            }
            try {
                long l = Long.parseLong(string2);
                return l <= 0xFFFFFFFFL && l >= 0L;
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("validerValeur(String, String) - NumberFormatException", numberFormatException);
                return false;
            }
        }
        if ("short".equals(string)) {
            if (!WXSSimpleType.verifExpr(string2, "[+\\-]?\\d+")) {
                return false;
            }
            String string4 = string2;
            if (string4.startsWith("+")) {
                string4 = string4.substring(1);
            }
            try {
                int n = Integer.parseInt(string4);
                return n <= Short.MAX_VALUE && n >= Short.MIN_VALUE;
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("validerValeur(String, String) - NumberFormatException", numberFormatException);
                return false;
            }
        }
        if ("unsignedShort".equals(string)) {
            if (!WXSSimpleType.verifExpr(string2, "\\d+")) {
                return false;
            }
            try {
                int n = Integer.parseInt(string2);
                return n <= 65535 && n >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("validerValeur(String, String) - NumberFormatException", numberFormatException);
                return false;
            }
        }
        if ("byte".equals(string)) {
            if (!WXSSimpleType.verifExpr(string2, "[+\\-]?\\d+")) {
                return false;
            }
            String string5 = string2;
            if (string5.startsWith("+")) {
                string5 = string5.substring(1);
            }
            try {
                int n = Integer.parseInt(string5);
                return n <= 127 && n >= -128;
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("validerValeur(String, String) - NumberFormatException", numberFormatException);
                return false;
            }
        }
        if ("unsignedByte".equals(string)) {
            if (!WXSSimpleType.verifExpr(string2, "\\d+")) {
                return false;
            }
            try {
                int n = Integer.parseInt(string2);
                return n <= 255 && n >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("validerValeur(String, String) - NumberFormatException", numberFormatException);
                return false;
            }
        }
        if ("decimal".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[+\\-]?\\d+\\.?\\d*");
        }
        if ("float".equals(string)) {
            if (!WXSSimpleType.verifExpr(string2, "(-?INF)|(NaN)|([+\\-]?\\d+\\.?\\d*([eE][+\\-]?\\d{1,3})?)")) {
                return false;
            }
            if ("INF".equals(string2) || "-INF".equals(string2)) {
                return true;
            }
            try {
                Float.parseFloat(string2);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if ("double".equals(string)) {
            if (!WXSSimpleType.verifExpr(string2, "(-?INF)|(NaN)|([+\\-]?\\d+\\.?\\d*([eE][+\\-]?\\d{1,3})?)")) {
                return false;
            }
            if ("INF".equals(string2) || "-INF".equals(string2)) {
                return true;
            }
            try {
                Double.parseDouble(string2);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if ("boolean".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "(true)|(false)|1|0");
        }
        if ("duration".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "-?P(\\d{1,4}Y)?(\\d{1,2}M)?(\\d{1,2}D)?(T(\\d{1,2}H)?(\\d{1,2}M)?(\\d{1,2}(\\.\\d+)?S)?)?");
        }
        if ("dateTime".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "-?\\d{4}-[01]\\d-[0-3]\\dT[0-2]\\d:[0-5]\\d:[0-5]\\d(\\.\\d+)?(([+\\-][01]\\d:\\d{2})|Z)?");
        }
        if ("date".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "-?\\d{4}-[01]\\d-[0-3]\\d(([+\\-][01]\\d:\\d{2})|Z)?");
        }
        if ("time".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[0-2]\\d:[0-5]\\d:[0-5]\\d(\\.\\d+)?(([+\\-][01]\\d:\\d{2})|Z)?");
        }
        if ("gYear".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "-?\\d{4}(([+\\-][01]\\d:\\d{2})|Z)?");
        }
        if ("gYearMonth".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "-?\\d{4}-[01]\\d(([+\\-][01]\\d:\\d{2})|Z)?");
        }
        if ("gMonth".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "--[01]\\d(([+\\-][01]\\d:\\d{2})|Z)?");
        }
        if ("gMonthDay".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "--[01]\\d-[0-3]\\d(([+\\-][01]\\d:\\d{2})|Z)?");
        }
        if ("gDay".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "---[0-3]\\d(([+\\-][01]\\d:\\d{2})|Z)?");
        }
        if ("Name".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s][^<>&#!/?'\",\\s]*");
        }
        if ("QName".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s][^<>&#!/?'\",\\s]*");
        }
        if ("NCName".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s:][^<>&#!/?'\",:\\s]*");
        }
        if ("anyURI".equals(string)) {
            return true;
        }
        if ("language".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");
        }
        if ("ID".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s:][^<>&#!/?'\",:\\s]*");
        }
        if ("IDREF".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s:][^<>&#!/?'\",:\\s]*");
        }
        if ("IDREFS".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s:][^<>&#!/?'\",:]*");
        }
        if ("ENTITY".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s:][^<>&#!/?'\",:\\s]*");
        }
        if ("ENTITIES".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s:][^<>&#!/?'\",:]*");
        }
        if ("NOTATION".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[^0-9.\\-\\s][^\\s]*(\\s[^0-9.\\-\\s][^\\s]*)*");
        }
        if ("NMTOKEN".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[^<>&#!/?'\",\\s]+");
        }
        if ("NMTOKENS".equals(string)) {
            return WXSSimpleType.verifExpr(string2, "[^<>&#!/?'\",]+");
        }
        return true;
    }

    protected static boolean verifExpr(String string, String string2) {
        try {
            Pattern pattern = Pattern.compile("^" + string2 + "$");
            return pattern.matcher(string).matches();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            LOG.error("verifExpr(String, String): " + string2, patternSyntaxException);
            return true;
        }
    }
}

