/*
 * Decompiled with CFR 0.152.
 */
package jaxe.equations;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import jaxe.equations.MathBase;
import jaxe.equations.MathComponent;
import jaxe.equations.StringMathBuilder;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DialogueEquation
extends JDialog
implements ActionListener,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(DialogueEquation.class);
    JFrame jframe;
    boolean valide = false;
    MathComponent mathcomp;
    JTextArea zoneTexte;
    String texteEquation;
    JPanel epane;
    JaxeDocument doc;
    JTextField labelfield = null;
    String valeurLabel;

    public DialogueEquation(JaxeDocument jaxeDocument, String string) {
        this(jaxeDocument, string, null, null);
    }

    public DialogueEquation(JaxeDocument jaxeDocument, String string, String string2, String string3) {
        super(jaxeDocument.jframe, JaxeResourceBundle.getRB().getString("equation.Equation"), true);
        JPanel jPanel;
        this.doc = jaxeDocument;
        this.jframe = jaxeDocument.jframe;
        this.texteEquation = string;
        this.valeurLabel = string3;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.setContentPane(jPanel2);
        this.epane = new JPanel(new BorderLayout());
        this.mathcomp = new MathComponent(string);
        this.epane.add((Component)this.mathcomp, "Center");
        this.zoneTexte = new JTextArea(string, 2, 80);
        this.zoneTexte.setLineWrap(true);
        this.zoneTexte.setWrapStyleWord(true);
        this.zoneTexte.setBorder(BorderFactory.createBevelBorder(1));
        this.zoneTexte.getDocument().addDocumentListener(this);
        this.epane.add((Component)this.zoneTexte, "South");
        jPanel2.add((Component)this.epane, "Center");
        JPanel jPanel3 = new JPanel(new GridLayout(string2 == null ? 1 : 2, 1));
        if (string2 != null) {
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(new JLabel(string2));
            this.labelfield = new JTextField(string3, 30);
            jPanel.add(this.labelfield);
            jPanel3.add(jPanel);
        }
        jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(JaxeResourceBundle.getRB().getString("bouton.Annuler"));
        jButton.addActionListener(this);
        jButton.setActionCommand("Annuler");
        jPanel.add(jButton);
        JButton jButton2 = new JButton(JaxeResourceBundle.getRB().getString("bouton.OK"));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("OK");
        jPanel.add(jButton2);
        jPanel3.add(jPanel);
        jPanel2.add((Component)jPanel3, "South");
        this.getRootPane().setDefaultButton(jButton2);
        this.setSize(new Dimension(500, 300));
        this.zoneTexte.requestFocus();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DialogueEquation.this.zoneTexte.requestFocus();
                    }
                });
            }
        });
        Rectangle rectangle = this.jframe.getBounds();
        this.setLocation(rectangle.x + rectangle.width / 4, rectangle.y + rectangle.height / 4);
    }

    public boolean afficher() {
        this.setVisible(true);
        return this.valide;
    }

    public String getTexte() {
        return this.texteEquation;
    }

    public String getLabel() {
        return this.valeurLabel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("OK".equals(string)) {
            this.actionOK();
        } else if ("Annuler".equals(string)) {
            this.valide = false;
            this.setVisible(false);
        }
    }

    protected void actionOK() {
        this.valide = true;
        if (this.labelfield != null) {
            this.valeurLabel = this.labelfield.getText();
        }
        this.setVisible(false);
    }

    protected void changementTexte() {
        String[][] stringArrayArray = new String[][]{{"\u00b2", "^2"}, {"\u00b3", "^3"}, {"\u00bc", "^(1/4)"}, {"\u00bd", "^(1/2)"}, {"\u00be", "^(3/4)"}, {"\u03b1", "alpha"}, {"\u03b2", "beta"}, {"\u03b3", "gamma"}, {"\u03b4", "delta"}, {"\u03b5", "epsilon"}, {"\u03b6", "zeta"}, {"\u03b7", "eta"}, {"\u03b8", "theta"}, {"\u03b9", "iota"}, {"\u03ba", "kappa"}, {"\u03bb", "lambda"}, {"\u03bc", "mu"}, {"\u03bd", "nu"}, {"\u03be", "xi"}, {"\u03bf", "omicron"}, {"\u03c0", "pi"}, {"\u03c1", "rho"}, {"\u03c3", "sigma"}, {"\u03c4", "tau"}, {"\u03c5", "upsilon"}, {"\u03c6", "phi"}, {"\u03c7", "chi"}, {"\u03c8", "psi"}, {"\u03c9", "omega"}, {"\u0391", "Alpha"}, {"\u0392", "Beta"}, {"\u0393", "Gamma"}, {"\u0394", "Delta"}, {"\u0395", "Epsilon"}, {"\u0396", "Zeta"}, {"\u0397", "Eta"}, {"\u0398", "Theta"}, {"\u0399", "Iota"}, {"\u039a", "Kappa"}, {"\u039b", "Lambda"}, {"\u039c", "Mu"}, {"\u039d", "Nu"}, {"\u039e", "Xi"}, {"\u039f", "Omicron"}, {"\u03a0", "Pi"}, {"\u03a1", "Rho"}, {"\u03a3", "Sigma"}, {"\u03a4", "Tau"}, {"\u03a5", "Upsilon"}, {"\u03a6", "Phi"}, {"\u03a7", "Chi"}, {"\u03a8", "Psi"}, {"\u03a9", "Omega"}, {"\u00b5", "mu"}, {"|", "abs("}};
        if (this.zoneTexte.getText().indexOf(10) != -1) {
            this.actionOK();
        } else {
            int n;
            this.texteEquation = this.zoneTexte.getText();
            boolean bl = false;
            int n2 = this.zoneTexte.getCaretPosition();
            for (n = 0; n < stringArrayArray.length; ++n) {
                int n3 = this.texteEquation.indexOf(stringArrayArray[n][0]);
                while (n3 != -1) {
                    this.texteEquation = this.texteEquation.substring(0, n3) + stringArrayArray[n][1] + this.texteEquation.substring(n3 + stringArrayArray[n][0].length());
                    n2 = n3 + stringArrayArray[n][1].length();
                    n3 = this.texteEquation.indexOf(stringArrayArray[n][0]);
                    bl = true;
                }
            }
            n = n2;
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DialogueEquation.this.zoneTexte.setText(DialogueEquation.this.texteEquation);
                        DialogueEquation.this.zoneTexte.setCaretPosition(n);
                    }
                });
            } else {
                this.majAffichage();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changementTexte();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changementTexte();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.changementTexte();
    }

    protected void majAffichage() {
        this.mathcomp.setEquationString(this.texteEquation);
        this.mathcomp.repaint();
    }

    public static BufferedImage creerImage(String string) {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        MathBase mathBase = new MathBase(new StringMathBuilder(string).getMathRootElement(), graphics2D);
        Dimension dimension = new Dimension(mathBase.getWidth(), mathBase.getHeight());
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, true, true, 3, 0);
        WritableRaster writableRaster = ((ColorModel)componentColorModel).createCompatibleWritableRaster(dimension.width, dimension.height);
        BufferedImage bufferedImage2 = new BufferedImage(componentColorModel, writableRaster, false, null);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.setColor(Color.black);
        mathBase.paint(graphics2D2);
        return bufferedImage2;
    }

    public static void enregistrerImage(BufferedImage bufferedImage, Object object) throws IOException {
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("PNG").next();
        IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), null);
        Element element = (Element)iIOMetadata.getAsTree("javax_imageio_png_1.0");
        NodeList nodeList = element.getElementsByTagName("bKGD");
        if (nodeList.getLength() == 0) {
            Node node = element.getFirstChild();
            String string = node.getNodeName();
            if ("IHDR".equals(string) || "PLTE".equals(string)) {
                node = node.getNextSibling();
            }
            if (node != null && "PLTE".equals(node.getNodeName())) {
                node = node.getNextSibling();
            }
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("bKGD");
            if (node == null) {
                element.appendChild(iIOMetadataNode);
            } else {
                element.insertBefore(iIOMetadataNode, node);
            }
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("bKGD_Grayscale");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2.setAttribute("gray", "255");
            try {
                iIOMetadata.mergeTree("javax_imageio_png_1.0", element);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                LOG.error("enregistrerImage(BufferedImage, Object)", iIOInvalidTreeException);
            }
        }
        imageWriter.setOutput(ImageIO.createImageOutputStream(object));
        imageWriter.write(new IIOImage(bufferedImage, null, iIOMetadata));
    }
}

