/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jaxe.Config;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Deprecated
public class VerifTypeSimple {
    private static final Logger LOG = Logger.getLogger(VerifTypeSimple.class);
    private final boolean required;
    private String fixed = null;
    private Contraintes contraintes;
    private static final HashMap<String, Pattern> PATTERN_CACHE = new HashMap();

    @Deprecated
    public VerifTypeSimple(Config config, Element element) {
        Object object;
        String string = element.getAttribute("type");
        String string2 = element.getAttribute("use");
        this.required = "required".equals(string2);
        if (!"".equals(string)) {
            this.contraintes = new Contraintes(config, string, element);
        } else {
            for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (object instanceof Element && object.getLocalName().equals("simpleType")) {
                    this.contraintes = new Contraintes(config, (Element)object);
                    continue;
                }
                if (!(object instanceof Element) || !object.getLocalName().equals("complexType")) continue;
                for (Node node = object.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (!(node instanceof Element) || !node.getLocalName().equals("simpleContent")) continue;
                    this.contraintes = new Contraintes(config, (Element)node);
                }
            }
        }
        object = element.getAttribute("fixed");
        if (!"".equals(object)) {
            this.fixed = object;
        }
    }

    public String getBaseType() {
        if (this.contraintes == null) {
            return null;
        }
        return this.contraintes.getBaseType();
    }

    public ArrayList<String> getEnumeration() {
        if (this.contraintes == null) {
            if (this.fixed != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(this.fixed);
                arrayList.add("");
                return arrayList;
            }
            return null;
        }
        ArrayList<String> arrayList = this.contraintes.getEnumeration();
        if (this.fixed != null) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            if (!arrayList.contains(this.fixed)) {
                arrayList.add(this.fixed);
            }
            if (!arrayList.contains("")) {
                arrayList.add("");
            }
        }
        return arrayList;
    }

    public boolean estValide(String string) {
        if (this.fixed != null && !this.fixed.equals(string)) {
            return false;
        }
        if (this.contraintes == null) {
            return true;
        }
        return this.contraintes.valide(string);
    }

    class Restriction {
        private final String nom;
        private final String param;
        private int iparam;

        public Restriction(String string, String string2) {
            this.nom = string;
            this.param = string2;
            try {
                this.iparam = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public boolean valide(String string) {
            if ("length".equals(this.nom)) {
                return string.length() == this.iparam;
            }
            if ("minLength".equals(this.nom)) {
                return string.length() >= this.iparam;
            }
            if ("maxLength".equals(this.nom)) {
                return string.length() <= this.iparam;
            }
            if ("maxInclusive".equals(this.nom)) {
                try {
                    double d = Double.parseDouble(string);
                    return d <= (double)this.iparam;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if ("maxExclusive".equals(this.nom)) {
                try {
                    double d = Double.parseDouble(string);
                    return d < (double)this.iparam;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if ("minInclusive".equals(this.nom)) {
                try {
                    double d = Double.parseDouble(string);
                    return d >= (double)this.iparam;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if ("minExclusive".equals(this.nom)) {
                try {
                    double d = Double.parseDouble(string);
                    return d > (double)this.iparam;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if ("whiteSpace".equals(this.nom)) {
                if ("collapse".equals(this.param)) {
                    return !"replace".equals(string) && !"preserve".equals(string);
                }
                if ("replace".equals(this.param)) {
                    return !"preserve".equals(string);
                }
                return true;
            }
            if ("totalDigits".equals(this.nom)) {
                int n = 0;
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) < '0' || string.charAt(i) > '9') continue;
                    ++n;
                }
                return n <= this.iparam;
            }
            if ("fractionDigits".equals(this.nom)) {
                int n = 0;
                boolean bl = false;
                for (int i = 0; i < string.length(); ++i) {
                    if (!bl) {
                        if (string.charAt(i) != '.') continue;
                        bl = true;
                        continue;
                    }
                    if (string.charAt(i) < '0' || string.charAt(i) > '9') continue;
                    ++n;
                }
                return n <= this.iparam;
            }
            return true;
        }
    }

    class Liste {
        private Contraintes contraintesItem = null;

        public Liste(Config config, Element element) {
            String string;
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element) || !node.getLocalName().equals("simpleType")) continue;
                this.contraintesItem = new Contraintes(config, (Element)node);
                break;
            }
            if (this.contraintesItem == null && !"".equals(string = element.getAttribute("itemType"))) {
                this.contraintesItem = new Contraintes(config, string, element);
            }
        }

        protected boolean valide(String string) {
            String[] stringArray;
            if (this.contraintesItem == null) {
                return true;
            }
            for (String string2 : stringArray = string.trim().split("\\s")) {
                if (this.contraintesItem.valide(string2)) continue;
                return false;
            }
            return true;
        }

        protected ArrayList<String> getEnumeration() {
            return null;
        }
    }

    class Union {
        private ArrayList<Contraintes> contraintes = new ArrayList();

        public Union(Config config, Element element) {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element) || !node.getLocalName().equals("simpleType")) continue;
                this.contraintes.add(new Contraintes(config, (Element)node));
            }
            String string = element.getAttribute("memberTypes");
            if (!"".equals(string)) {
                String[] stringArray;
                for (String string2 : stringArray = string.split("\\s")) {
                    this.contraintes.add(new Contraintes(config, string2, element));
                }
            }
        }

        protected boolean valide(String string) {
            if (this.contraintes == null) {
                return true;
            }
            for (Contraintes contraintes : this.contraintes) {
                if (!contraintes.valide(string)) continue;
                return true;
            }
            return false;
        }

        protected ArrayList<String> getEnumeration() {
            ArrayList<String> arrayList = null;
            for (Contraintes contraintes : this.contraintes) {
                ArrayList<String> arrayList2 = contraintes.getEnumeration();
                if (arrayList2 == null) {
                    return null;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.addAll(arrayList2);
            }
            return arrayList;
        }
    }

    class Contraintes {
        private String baseType = null;
        private ArrayList<String> enumeration = null;
        private ArrayList<String> patterns = null;
        private ArrayList<Restriction> restrictions = null;
        private Union union = null;
        private Liste liste = null;

        public Contraintes(Config config, Element element) {
            this.lireTypeEtRestrictions(config, element);
        }

        public Contraintes(Config config, String string, Element element) {
            this.lireTypeEtRestrictions(config, string, element);
        }

        protected void lireTypeEtRestrictions(Config config, Element element) {
            Node node = null;
            for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (!(node2 instanceof Element) || !node2.getLocalName().equals("restriction") && !node2.getLocalName().equals("extension") && !node2.getLocalName().equals("union") && !node2.getLocalName().equals("list")) continue;
                node = (Element)node2;
                break;
            }
            if (node == null) {
                return;
            }
            if (node.getLocalName().equals("restriction")) {
                this.baseType = node.getAttribute("base");
                if (this.baseType.indexOf(58) != -1) {
                    this.baseType = this.baseType.substring(this.baseType.indexOf(58) + 1);
                }
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (!(node3 instanceof Element)) continue;
                    this.lireRestriction((Element)node3);
                }
            } else if (node.getLocalName().equals("extension")) {
                this.baseType = node.getAttribute("base");
                this.lireTypeEtRestrictions(config, this.baseType, element);
            } else if (node.getLocalName().equals("union")) {
                this.union = new Union(config, (Element)node);
                this.enumeration = this.union.getEnumeration();
            } else if (node.getLocalName().equals("list")) {
                this.liste = new Liste(config, (Element)node);
                this.enumeration = null;
            }
        }

        protected void lireTypeEtRestrictions(Config config, String string, Element element) {
            String string2 = config.espaceCible();
            boolean bl = string2 != null && string2.equals(element.getNamespaceURI());
            String string3 = element.getPrefix();
            int n = string.indexOf(58);
            if (!bl && (n == -1 && string3 == null || n != -1 && string.substring(0, n).equals(string3))) {
                this.baseType = string.substring(n + 1);
            } else {
                String string4;
                String string5;
                if (n == -1) {
                    string5 = string;
                    string4 = element.lookupNamespaceURI(null);
                } else {
                    string5 = string.substring(n + 1);
                    string4 = element.lookupNamespaceURI(string.substring(0, n));
                }
                Element element2 = config.getSchemaTypeElement(string5, string4);
                if (element2 == null) {
                    LOG.error("VerifTypeSimple(JaxeDocument, Element) - typesimple: attention: pas de d\u00e9finition de " + string5 + " dans le sch\u00e9ma", null);
                } else if (element2.getLocalName().equals("complexType")) {
                    for (Node node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
                        if (!(node instanceof Element) || !node.getLocalName().equals("simpleContent")) continue;
                        this.lireTypeEtRestrictions(config, (Element)node);
                    }
                } else if (element2.getLocalName().equals("simpleType")) {
                    this.lireTypeEtRestrictions(config, element2);
                }
            }
        }

        protected void lireRestriction(Element element) {
            if (element.getLocalName().equals("enumeration")) {
                String string = element.getAttribute("value");
                if (this.enumeration == null) {
                    this.enumeration = new ArrayList();
                }
                this.enumeration.add(string);
            } else if (element.getLocalName().equals("pattern")) {
                String string = element.getAttribute("value");
                if (this.patterns == null) {
                    this.patterns = new ArrayList();
                }
                string = this.remplacer(string, "\\i", "[^<>&#!/?'\",0-9.\\-\\s]");
                string = this.remplacer(string, "\\I", "[^a-zA-Z]");
                string = this.remplacer(string, "\\c", "[^<>&#!/?'\",\\s]");
                string = this.remplacer(string, "\\C", "\\W");
                this.patterns.add(string);
            } else {
                String string = element.getAttribute("value");
                if (this.restrictions == null) {
                    this.restrictions = new ArrayList();
                }
                this.restrictions.add(new Restriction(element.getLocalName(), string));
            }
        }

        protected String remplacer(String string, String string2, String string3) {
            int n = string.indexOf(string2);
            while (n != -1) {
                string = string.substring(0, n) + string3 + string.substring(n + string2.length());
                n = string.indexOf(string2);
            }
            return string;
        }

        protected boolean valide(String string) {
            boolean bl;
            if ((string == null || "".equals(string)) && VerifTypeSimple.this.required) {
                return false;
            }
            if (this.union != null) {
                return this.union.valide(string);
            }
            if (this.liste != null) {
                return this.liste.valide(string);
            }
            if (this.baseType != null && !this.verifType(this.baseType, string)) {
                return false;
            }
            if (this.enumeration != null) {
                if (string == null) {
                    return false;
                }
                bl = false;
                for (String string2 : this.enumeration) {
                    if (!string.equals(string2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
            }
            if (this.patterns != null) {
                bl = false;
                for (String string2 : this.patterns) {
                    if (!this.verifExpr(string, string2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
            }
            if (this.restrictions != null) {
                for (Restriction restriction : this.restrictions) {
                    if (restriction.valide(string)) continue;
                    return false;
                }
            }
            return true;
        }

        protected boolean verifType(String string, String string2) {
            if ("string".equals(string)) {
                return true;
            }
            if ("normalizedString".equals(string)) {
                return this.verifExpr(string2, "[^\\t\\r\\n]*");
            }
            if ("token".equals(string)) {
                if (string2.indexOf(10) != -1 || string2.indexOf(13) != -1 || string2.indexOf(9) != -1 || string2.indexOf("  ") != -1) {
                    return false;
                }
                return !string2.startsWith(" ") && !string2.endsWith(" ");
            }
            if ("base64Binary".equals(string)) {
                return this.verifExpr(string2, "(([a-zA-Z0-9+/=]\\s?){4})*");
            }
            if ("hexBinary".equals(string)) {
                return this.verifExpr(string2, "(([0-9a-fA-F]){2})*");
            }
            if ("integer".equals(string)) {
                return this.verifExpr(string2, "[+\\-]?\\d+");
            }
            if ("positiveInteger".equals(string)) {
                return this.verifExpr(string2, "\\+?0*[1-9]\\d*");
            }
            if ("negativeInteger".equals(string)) {
                return this.verifExpr(string2, "-0*[1-9]\\d*");
            }
            if ("nonNegativeInteger".equals(string)) {
                return this.verifExpr(string2, "(-0+)|(\\+?\\d+)");
            }
            if ("nonPositiveInteger".equals(string)) {
                return this.verifExpr(string2, "(\\+?0+)|(-\\d+)");
            }
            if ("long".equals(string)) {
                if (!this.verifExpr(string2, "[+\\-]?\\d+")) {
                    return false;
                }
                try {
                    BigInteger bigInteger = new BigInteger(string2);
                    BigInteger bigInteger2 = new BigInteger("9223372036854775807");
                    BigInteger bigInteger3 = new BigInteger("-9223372036854775808");
                    if (bigInteger.compareTo(bigInteger2) > 0) {
                        return false;
                    }
                    return bigInteger.compareTo(bigInteger3) >= 0;
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.error("verifType(String, String) - NumberFormatException", numberFormatException);
                    return false;
                }
            }
            if ("unsignedLong".equals(string)) {
                if (!this.verifExpr(string2, "\\d+")) {
                    return false;
                }
                try {
                    BigInteger bigInteger = new BigInteger(string2);
                    BigInteger bigInteger4 = new BigInteger("18446744073709551615");
                    return bigInteger.compareTo(bigInteger4) <= 0;
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.error("verifType(String, String) - NumberFormatException", numberFormatException);
                    return false;
                }
            }
            if ("int".equals(string)) {
                if (!this.verifExpr(string2, "[+\\-]?\\d+")) {
                    return false;
                }
                try {
                    long l = Long.parseLong(string2);
                    return l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE;
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.error("verifType(String, String) - NumberFormatException", numberFormatException);
                    return false;
                }
            }
            if ("unsignedInt".equals(string)) {
                if (!this.verifExpr(string2, "\\d+")) {
                    return false;
                }
                try {
                    long l = Long.parseLong(string2);
                    return l <= 0xFFFFFFFFL && l >= 0L;
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.error("verifType(String, String) - NumberFormatException", numberFormatException);
                    return false;
                }
            }
            if ("short".equals(string)) {
                if (!this.verifExpr(string2, "[+\\-]?\\d+")) {
                    return false;
                }
                try {
                    int n = Integer.parseInt(string2);
                    return n <= Short.MAX_VALUE && n >= Short.MIN_VALUE;
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.error("verifType(String, String) - NumberFormatException", numberFormatException);
                    return false;
                }
            }
            if ("unsignedShort".equals(string)) {
                if (!this.verifExpr(string2, "\\d+")) {
                    return false;
                }
                try {
                    int n = Integer.parseInt(string2);
                    return n <= 65535 && n >= 0;
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.error("verifType(String, String) - NumberFormatException", numberFormatException);
                    return false;
                }
            }
            if ("byte".equals(string)) {
                if (!this.verifExpr(string2, "[+\\-]?\\d+")) {
                    return false;
                }
                try {
                    int n = Integer.parseInt(string2);
                    return n <= 127 && n >= -128;
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.error("verifType(String, String) - NumberFormatException", numberFormatException);
                    return false;
                }
            }
            if ("unsignedByte".equals(string)) {
                if (!this.verifExpr(string2, "\\d+")) {
                    return false;
                }
                try {
                    int n = Integer.parseInt(string2);
                    return n <= 255 && n >= 0;
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.error("verifType(String, String) - NumberFormatException", numberFormatException);
                    return false;
                }
            }
            if ("decimal".equals(string)) {
                return this.verifExpr(string2, "[+\\-]?\\d+\\.?\\d*");
            }
            if ("float".equals(string)) {
                if (!this.verifExpr(string2, "(-?INF)|(NaN)|([+\\-]?\\d+\\.?\\d*([eE][+\\-]?\\d{1,3})?)")) {
                    return false;
                }
                if ("INF".equals(string2) || "-INF".equals(string2)) {
                    return true;
                }
                try {
                    Float.parseFloat(string2);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if ("double".equals(string)) {
                if (!this.verifExpr(string2, "(-?INF)|(NaN)|([+\\-]?\\d+\\.?\\d*([eE][+\\-]?\\d{1,3})?)")) {
                    return false;
                }
                if ("INF".equals(string2) || "-INF".equals(string2)) {
                    return true;
                }
                try {
                    Double.parseDouble(string2);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if ("boolean".equals(string)) {
                return this.verifExpr(string2, "(true)|(false)|1|0");
            }
            if ("duration".equals(string)) {
                return this.verifExpr(string2, "-?P(\\d{1,4}Y)?(\\d{1,2}M)?(\\d{1,2}D)?T?(\\d{1,2}H)?(\\d{1,2}M)?(\\d{1,2}(\\.\\d+)?S)?");
            }
            if ("dateTime".equals(string)) {
                return this.verifExpr(string2, "-?\\d{4}-[01]\\d-[0-3]\\dT[0-2]\\d:[0-5]\\d:[0-5]\\d(\\.\\d+)?(([+\\-][01]\\d:\\d{2})|Z)?");
            }
            if ("date".equals(string)) {
                return this.verifExpr(string2, "-?\\d{4}-[01]\\d-[0-3]\\d(([+\\-][01]\\d:\\d{2})|Z)?");
            }
            if ("time".equals(string)) {
                return this.verifExpr(string2, "[0-2]\\d:[0-5]\\d:[0-5]\\d(\\.\\d+)?(([+\\-][01]\\d:\\d{2})|Z)?");
            }
            if ("gYear".equals(string)) {
                return this.verifExpr(string2, "-?\\d{4}(([+\\-][01]\\d:\\d{2})|Z)?");
            }
            if ("gYearMonth".equals(string)) {
                return this.verifExpr(string2, "-?\\d{4}-[01]\\d(([+\\-][01]\\d:\\d{2})|Z)?");
            }
            if ("gMonth".equals(string)) {
                return this.verifExpr(string2, "--[01]\\d(([+\\-][01]\\d:\\d{2})|Z)?");
            }
            if ("gMonthDay".equals(string)) {
                return this.verifExpr(string2, "--[01]\\d-[0-3]\\d(([+\\-][01]\\d:\\d{2})|Z)?");
            }
            if ("gDay".equals(string)) {
                return this.verifExpr(string2, "---[0-3]\\d(([+\\-][01]\\d:\\d{2})|Z)?");
            }
            if ("Name".equals(string)) {
                return this.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s][^<>&#!/?'\",\\s]*");
            }
            if ("QName".equals(string)) {
                return this.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s][^<>&#!/?'\",\\s]*");
            }
            if ("NCName".equals(string)) {
                return this.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s:][^<>&#!/?'\",:\\s]*");
            }
            if ("anyURI".equals(string)) {
                return true;
            }
            if ("language".equals(string)) {
                return this.verifExpr(string2, "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");
            }
            if ("ID".equals(string)) {
                return this.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s:][^<>&#!/?'\",:\\s]*");
            }
            if ("IDREF".equals(string)) {
                return this.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s:][^<>&#!/?'\",:\\s]*");
            }
            if ("IDREFS".equals(string)) {
                return this.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s:][^<>&#!/?'\",:]*");
            }
            if ("ENTITY".equals(string)) {
                return this.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s:][^<>&#!/?'\",:\\s]*");
            }
            if ("ENTITIES".equals(string)) {
                return this.verifExpr(string2, "[^<>&#!/?'\",0-9.\\-\\s:][^<>&#!/?'\",:]*");
            }
            if ("NOTATION".equals(string)) {
                return this.verifExpr(string2, "[^0-9.\\-\\s][^\\s]*(\\s[^0-9.\\-\\s][^\\s]*)*");
            }
            if ("NMTOKEN".equals(string)) {
                return this.verifExpr(string2, "[^<>&#!/?'\",\\s]+");
            }
            if ("NMTOKENS".equals(string)) {
                return this.verifExpr(string2, "[^<>&#!/?'\",]+");
            }
            return true;
        }

        protected boolean verifExpr(String string, String string2) {
            try {
                Pattern pattern = (Pattern)PATTERN_CACHE.get(string2);
                if (pattern == null) {
                    pattern = Pattern.compile("^" + string2 + "$");
                    PATTERN_CACHE.put(string2, pattern);
                    return pattern.matcher(string).matches();
                }
                return pattern.matcher(string).matches();
            }
            catch (PatternSyntaxException patternSyntaxException) {
                LOG.error("verifExpr(String, String): " + string2, patternSyntaxException);
                return true;
            }
        }

        protected String getBaseType() {
            return this.baseType;
        }

        protected ArrayList<String> getEnumeration() {
            return this.enumeration;
        }
    }
}

