/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import jaxe.Jaxe;
import jaxe.JaxeResourceBundle;
import org.apache.log4j.Logger;

public class Preferences
extends JDialog
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(Preferences.class);
    private static final String[] nomsPrefs = new String[]{"fenetreArbre", "fenetreInsertion", "fenetreAttributs", "navigateur", "consIndent", "indenter", "iconeValide", "toujoursAfficherAttributs", "dictionnaire", "classeXSLT"};
    private static final String[] defPrefs = new String[]{"true", "true", "true", null, "false", "false", "true", "true", null, "org.apache.xalan.processor.TransformerFactoryImpl"};
    private static Properties prefs = Preferences.getPreferencesParDefaut();
    private final JCheckBox caseArbre;
    private final JCheckBox caseInsertion;
    private final JCheckBox caseAttributs;
    private final JLabel labelNav;
    private String prefNav;
    private final JCheckBox caseConsIndent;
    private final JCheckBox caseIndenter;
    private final JCheckBox caseIconeValide;
    private final JCheckBox caseAfficherAttributs;
    private final JLabel labelDico;
    private String prefDico;
    private final JComboBox choixXSLT;
    private static final String[] classesXSLT = new String[]{"", "org.apache.xalan.processor.TransformerFactoryImpl", "org.apache.xalan.xsltc.trax.TransformerFactoryImpl", "net.sf.saxon.TransformerFactoryImpl"};
    private static final String[] nomsXSLT = new String[]{JaxeResourceBundle.getRB().getString("pref.defaut"), "Xalan", "XSLTC", "Saxon"};

    public static File trouverFichier() {
        try {
            String string = System.getProperty("user.home");
            String string2 = System.getProperty("os.name");
            File file = string2.indexOf("Windows") != -1 ? new File(string, "jaxepreferences") : (string2.startsWith("Mac") ? new File(string, "Library/Preferences/Jaxe Preferences") : new File(string, ".jaxe"));
            return file;
        }
        catch (AccessControlException accessControlException) {
            LOG.error("Jaxe Preferences.trouverFichier", accessControlException);
            return null;
        }
    }

    public static Properties getPreferencesParDefaut() {
        Properties properties = new Properties();
        for (int i = 0; i < nomsPrefs.length; ++i) {
            String string = nomsPrefs[i];
            String string2 = defPrefs[i];
            if (string2 == null) continue;
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public static Properties chargerPref() {
        block7: {
            prefs = Preferences.getPreferencesParDefaut();
            try {
                java.util.prefs.Preferences preferences = java.util.prefs.Preferences.userNodeForPackage(Jaxe.class);
                if (preferences.get("fenetreArbre", null) != null) {
                    for (String string : nomsPrefs) {
                        String string2 = preferences.get(string, null);
                        if (string2 == null) continue;
                        prefs.setProperty(string, string2);
                    }
                    break block7;
                }
                try {
                    File file = Preferences.trouverFichier();
                    if (file != null && file.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        prefs.load(fileInputStream);
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    LOG.error("chargerPref()", iOException);
                    return null;
                }
                Preferences.enregistrerPref(prefs);
            }
            catch (SecurityException securityException) {
                LOG.error("chargerPref()", securityException);
            }
        }
        return prefs;
    }

    public static Properties getPref() {
        return prefs;
    }

    public static void enregistrerPref(Properties properties) {
        if (properties == null) {
            return;
        }
        prefs = properties;
        java.util.prefs.Preferences preferences = java.util.prefs.Preferences.userNodeForPackage(Jaxe.class);
        for (String string : nomsPrefs) {
            String string2 = prefs.getProperty(string);
            if (string2 != null) {
                preferences.put(string, string2);
                continue;
            }
            if (preferences.get(string, null) == null) continue;
            preferences.remove(string);
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            LOG.error("enregistrerPref(Properties)", backingStoreException);
        }
    }

    public Preferences(JFrame jFrame) {
        super(jFrame, JaxeResourceBundle.getRB().getString("pref.Preferences"), true);
        String string;
        this.getContentPane().setLayout(new BorderLayout());
        Properties properties = Preferences.getPref();
        String string2 = properties.getProperty("fenetreArbre");
        String string3 = properties.getProperty("fenetreInsertion");
        String string4 = properties.getProperty("fenetreAttributs");
        this.prefNav = properties.getProperty("navigateur");
        String string5 = properties.getProperty("consIndent");
        String string6 = properties.getProperty("indenter");
        String string7 = properties.getProperty("iconeValide");
        String string8 = properties.getProperty("toujoursAfficherAttributs");
        this.prefDico = properties.getProperty("dictionnaire");
        String string9 = properties.getProperty("classeXSLT");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(JaxeResourceBundle.getRB().getString("pref.Fenetres")));
        this.caseArbre = new JCheckBox(JaxeResourceBundle.getRB().getString("pref.Arbre"));
        this.caseArbre.setSelected(Boolean.parseBoolean(string2));
        jPanel2.add(this.caseArbre);
        this.caseInsertion = new JCheckBox(JaxeResourceBundle.getRB().getString("pref.Insertion"));
        this.caseInsertion.setSelected(Boolean.parseBoolean(string3));
        jPanel2.add(this.caseInsertion);
        this.caseAttributs = new JCheckBox(JaxeResourceBundle.getRB().getString("pref.Attributs"));
        this.caseAttributs.setSelected(Boolean.parseBoolean(string4));
        jPanel2.add(this.caseAttributs);
        jPanel.add(jPanel2);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(JaxeResourceBundle.getRB().getString("pref.Navigateur")));
        String string10 = this.prefNav != null ? new File(this.prefNav).getName() : "";
        this.labelNav = new JLabel(string10);
        jPanel3.add(this.labelNav);
        JButton jButton = new JButton(JaxeResourceBundle.getRB().getString("pref.Definir"));
        jButton.addActionListener(this);
        jButton.setActionCommand("defNav");
        jPanel3.add(jButton);
        jPanel.add(jPanel3);
        jPanel3.setAlignmentX(0.0f);
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder(JaxeResourceBundle.getRB().getString("pref.OuvertureEnregistrement")));
        this.caseConsIndent = new JCheckBox(JaxeResourceBundle.getRB().getString("pref.consIndent"));
        this.caseConsIndent.setSelected(Boolean.parseBoolean(string5));
        this.caseConsIndent.addActionListener(this);
        this.caseConsIndent.setActionCommand("consIndent");
        jPanel4.add(this.caseConsIndent);
        this.caseIndenter = new JCheckBox(JaxeResourceBundle.getRB().getString("pref.indenter"));
        this.caseIndenter.setSelected(Boolean.parseBoolean(string6));
        jPanel4.add(this.caseIndenter);
        jPanel.add(jPanel4);
        jPanel4.setAlignmentX(0.0f);
        jPanel4.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setBorder(BorderFactory.createTitledBorder(JaxeResourceBundle.getRB().getString("pref.Affichage")));
        this.caseIconeValide = new JCheckBox(JaxeResourceBundle.getRB().getString("pref.iconeValide"));
        this.caseIconeValide.setSelected(Boolean.parseBoolean(string7));
        jPanel5.add(this.caseIconeValide);
        this.caseAfficherAttributs = new JCheckBox(JaxeResourceBundle.getRB().getString("pref.toujoursAfficherAttributs"));
        this.caseAfficherAttributs.setSelected(Boolean.parseBoolean(string8));
        jPanel5.add(this.caseAfficherAttributs);
        jPanel.add(jPanel5);
        jPanel5.setAlignmentX(0.0f);
        jPanel5.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        JPanel jPanel6 = new JPanel(new FlowLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder(JaxeResourceBundle.getRB().getString("pref.Dictionnaire")));
        if (this.prefDico != null) {
            string = new File(this.prefDico).getName();
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string = string.substring(0, n);
            }
        } else {
            string = "";
        }
        this.labelDico = new JLabel(string);
        jPanel6.add(this.labelDico);
        JButton jButton2 = new JButton(JaxeResourceBundle.getRB().getString("pref.Definir"));
        jButton2.addActionListener(this);
        jButton2.setActionCommand("defDico");
        jPanel6.add(jButton2);
        jPanel.add(jPanel6);
        jPanel6.setAlignmentX(0.0f);
        JPanel jPanel7 = new JPanel(new FlowLayout());
        jPanel7.setBorder(BorderFactory.createTitledBorder(JaxeResourceBundle.getRB().getString("pref.XSLT")));
        this.choixXSLT = new JComboBox<String>(nomsXSLT);
        int n = 0;
        for (int i = 0; i < classesXSLT.length; ++i) {
            if (!classesXSLT[i].equals(string9)) continue;
            n = i;
        }
        this.choixXSLT.setSelectedIndex(n);
        jPanel7.add(this.choixXSLT);
        jPanel.add(jPanel7);
        jPanel7.setAlignmentX(0.0f);
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel8 = new JPanel(new FlowLayout(1, 15, 15));
        JButton jButton3 = new JButton(JaxeResourceBundle.getRB().getString("pref.Annuler"));
        jButton3.addActionListener(this);
        jButton3.setActionCommand("Annuler");
        jPanel8.add(jButton3);
        JButton jButton4 = new JButton(JaxeResourceBundle.getRB().getString("pref.Enregistrer"));
        jButton4.addActionListener(this);
        jButton4.setActionCommand("Enregistrer");
        jPanel8.add(jButton4);
        this.getRootPane().setDefaultButton(jButton4);
        this.getContentPane().add((Component)jPanel8, "South");
        this.pack();
        if (jFrame != null) {
            Rectangle rectangle = jFrame.getBounds();
            this.setLocation(rectangle.x + rectangle.width / 4, rectangle.y + rectangle.height / 4);
        } else {
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.getToolkit().getScreenSize();
            this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Enregistrer".equals(string)) {
            Properties properties = Preferences.getPref();
            properties.setProperty("fenetreArbre", Boolean.toString(this.caseArbre.isSelected()));
            properties.setProperty("fenetreInsertion", Boolean.toString(this.caseInsertion.isSelected()));
            properties.setProperty("fenetreAttributs", Boolean.toString(this.caseAttributs.isSelected()));
            if (this.prefNav != null) {
                properties.setProperty("navigateur", this.prefNav);
            } else if (properties.getProperty("navigateur") != null) {
                properties.remove("navigateur");
            }
            if (this.prefDico != null) {
                properties.setProperty("dictionnaire", this.prefDico);
            } else if (properties.getProperty("dictionnaire") != null) {
                properties.remove("dictionnaire");
            }
            properties.setProperty("consIndent", Boolean.toString(this.caseConsIndent.isSelected()));
            properties.setProperty("indenter", Boolean.toString(this.caseIndenter.isSelected()));
            String string2 = properties.getProperty("iconeValide");
            properties.setProperty("iconeValide", Boolean.toString(this.caseIconeValide.isSelected()));
            properties.setProperty("toujoursAfficherAttributs", Boolean.toString(this.caseAfficherAttributs.isSelected()));
            properties.setProperty("classeXSLT", classesXSLT[this.choixXSLT.getSelectedIndex()]);
            Preferences.enregistrerPref(properties);
            if (Boolean.parseBoolean(string2) != this.caseIconeValide.isSelected()) {
                Jaxe.setIconeValide(this.caseIconeValide.isSelected());
            }
        } else if ("defNav".equals(string)) {
            this.defNavigateur();
        } else if ("defDico".equals(string)) {
            this.defDictionnaire();
        } else if ("consIndent".equals(string)) {
            if (this.caseConsIndent.isSelected() && this.caseIndenter.isSelected()) {
                this.caseIndenter.setSelected(false);
            }
            this.caseIndenter.setEnabled(!this.caseConsIndent.isSelected());
        }
        if ("Enregistrer".equals(string) || "Annuler".equals(string)) {
            this.setVisible(false);
        }
    }

    public void defNavigateur() {
        String string = null;
        String string2 = null;
        if (System.getProperty("os.name").indexOf("Linux") != -1 && System.getProperty("java.version").compareTo("1.7") < 0) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(JaxeResourceBundle.getRB().getString("pref.DefNavigateur"));
            int n = jFileChooser.showOpenDialog((Frame)this.getOwner());
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                string = file.getAbsolutePath();
                string2 = file.getName();
            }
        } else {
            FileDialog fileDialog = new FileDialog((Frame)this.getOwner(), JaxeResourceBundle.getRB().getString("pref.DefNavigateur"), 0);
            fileDialog.setVisible(true);
            String string3 = fileDialog.getDirectory();
            if (string3 != null && string3.endsWith(File.separator)) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string2 = fileDialog.getFile();
            if (string3 == null) {
                string = string2;
            } else if (string2 != null) {
                string = string3 + File.separator + string2;
            }
        }
        if (string != null) {
            this.prefNav = string;
            this.labelNav.setText(string2);
        }
    }

    public void defDictionnaire() {
        Container container;
        String string = null;
        String string2 = null;
        String string3 = System.getProperty("os.name");
        if (string3.indexOf("Linux") != -1 && System.getProperty("java.version").compareTo("1.7") < 0 || string3.indexOf("Windows") != -1) {
            container = new JFileChooser(new File(System.getProperty("user.dir"), "dicos"));
            ((JFileChooser)container).setDialogTitle(JaxeResourceBundle.getRB().getString("pref.Dictionnaire"));
            ((JFileChooser)container).addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.getName().toLowerCase().endsWith(".dico");
                }

                @Override
                public String getDescription() {
                    return ".dico";
                }
            });
            int n = ((JFileChooser)container).showOpenDialog((Frame)this.getOwner());
            if (n == 0) {
                File file = ((JFileChooser)container).getSelectedFile();
                string = file.getAbsolutePath();
                string2 = file.getName();
            }
        } else {
            container = new FileDialog((Frame)this.getOwner(), JaxeResourceBundle.getRB().getString("pref.Dictionnaire"), 0);
            ((FileDialog)container).setFilenameFilter(new ExtFilter("dico"));
            ((FileDialog)container).setDirectory(System.getProperty("user.dir") + File.separator + "dicos");
            ((Dialog)container).setVisible(true);
            String string4 = ((FileDialog)container).getDirectory();
            if (string4 != null && string4.endsWith(File.separator)) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            string2 = ((FileDialog)container).getFile();
            if (string4 == null) {
                string = string2;
            } else if (string2 != null) {
                string = string4 + File.separator + string2;
            }
        }
        if (string != null) {
            int n;
            this.prefDico = string;
            if (string2 != null && (n = string2.lastIndexOf(46)) != -1) {
                string2 = string2.substring(0, n);
            }
            this.labelDico.setText(string2);
        }
    }

    class ExtFilter
    implements FilenameFilter {
        String[] exta;

        public ExtFilter(String string) {
            this.exta = new String[1];
            this.exta[0] = string;
        }

        public ExtFilter(String[] stringArray) {
            this.exta = stringArray;
        }

        @Override
        public boolean accept(File file, String string) {
            for (String string2 : this.exta) {
                if (!string.endsWith("." + string2)) continue;
                return true;
            }
            return false;
        }
    }
}

