/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.im.InputContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jaxe.FragmentXML;
import jaxe.Jaxe;
import jaxe.JaxeDocument;
import jaxe.JaxeElement;
import jaxe.JaxeResourceBundle;
import jaxe.JaxeTextPane;
import jaxe.XMLTransferable;
import jaxe.elements.JECData;
import jaxe.elements.JECommentaire;
import jaxe.elements.JEFichier;
import jaxe.elements.JEStyle;
import jaxe.elements.JESwing;
import jaxe.elements.JETexte;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JaxeTransferHandler
extends TransferHandler {
    private static final Logger LOG = Logger.getLogger(JaxeTransferHandler.class);
    private boolean shouldRemove;
    private Position p0;
    private Position p1;
    private JaxeTextPane exportComp;
    private boolean editionSpeciale;

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (!(jComponent instanceof JaxeTextPane)) {
            return false;
        }
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
            return false;
        }
        return JaxeTransferHandler.choisirUneSaveur(dataFlavorArray, ((JaxeTextPane)jComponent).doc.fsave != null) != null;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        JaxeTextPane jaxeTextPane;
        if (!(jComponent instanceof JaxeTextPane)) {
            return null;
        }
        this.exportComp = jaxeTextPane = (JaxeTextPane)jComponent;
        this.shouldRemove = true;
        this.editionSpeciale = false;
        JaxeDocument jaxeDocument = (JaxeDocument)jaxeTextPane.getDocument();
        try {
            JaxeElement jaxeElement;
            int n = jaxeTextPane.getSelectionStart();
            int n2 = jaxeTextPane.getSelectionEnd();
            this.p0 = jaxeDocument.createPosition(n);
            this.p1 = jaxeDocument.createPosition(n2);
            if (n == n2) {
                return null;
            }
            JaxeElement jaxeElement2 = jaxeDocument.elementA(n);
            if ((jaxeElement2 instanceof JECommentaire || jaxeElement2 instanceof JECData) && jaxeElement2.debut.getOffset() == n) {
                jaxeElement2 = jaxeElement2.getParent();
            }
            if (jaxeElement2 == (jaxeElement = jaxeDocument.elementA(n2 - 1)) && (jaxeElement2 instanceof JETexte || jaxeElement2 instanceof JECommentaire || jaxeElement2 instanceof JECData) && !(jaxeElement2.getParent() instanceof JEStyle)) {
                String string = jaxeDocument.getText(n, n2 - n);
                StringSelection stringSelection = new StringSelection(string);
                return stringSelection;
            }
            FragmentXML fragmentXML = new FragmentXML(jaxeDocument.copier(n, n2));
            XMLTransferable xMLTransferable = new XMLTransferable(fragmentXML);
            return xMLTransferable;
        }
        catch (BadLocationException badLocationException) {
            LOG.error("JaxeTransferHandler.createTransferable", badLocationException);
            return null;
        }
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (this.shouldRemove && n == 2) {
            if (!(jComponent instanceof JaxeTextPane)) {
                return;
            }
            JaxeTextPane jaxeTextPane = (JaxeTextPane)jComponent;
            if (this.p0.getOffset() != this.p1.getOffset()) {
                try {
                    jaxeTextPane.doc.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    LOG.error("JaxeTransferHandler.exportDone", badLocationException);
                }
            }
        }
        if (this.editionSpeciale) {
            this.editionSpeciale = false;
            if (!(jComponent instanceof JaxeTextPane)) {
                return;
            }
            ((JaxeTextPane)jComponent).finEditionSpeciale();
        }
        this.exportComp = null;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return ((JTextComponent)jComponent).isEditable() ? 3 : 1;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        block26: {
            if (jComponent instanceof JaxeTextPane) {
                DataFlavor dataFlavor;
                JaxeTextPane jaxeTextPane = (JaxeTextPane)jComponent;
                int n = jaxeTextPane.getCaretPosition();
                if (jComponent == this.exportComp && n >= this.p0.getOffset() && n <= this.p1.getOffset()) {
                    this.shouldRemove = false;
                    return true;
                }
                if (jComponent == this.exportComp) {
                    jaxeTextPane.debutEditionSpeciale(JaxeResourceBundle.getRB().getString("annulation.GlisserDeposer"), false);
                    this.editionSpeciale = true;
                }
                if ((dataFlavor = JaxeTransferHandler.choisirUneSaveur(transferable.getTransferDataFlavors(), jaxeTextPane.doc.fsave != null)) != null) {
                    InputContext inputContext = jComponent.getInputContext();
                    if (inputContext != null) {
                        inputContext.endComposition();
                    }
                    try {
                        Element element;
                        String string;
                        Object object = transferable.getTransferData(dataFlavor);
                        if (object == null) {
                            return false;
                        }
                        Position position = jaxeTextPane.doc.createPosition(n);
                        DocumentFragment documentFragment = null;
                        if (object instanceof FragmentXML) {
                            documentFragment = ((FragmentXML)object).getFragment();
                        } else if (object instanceof String) {
                            documentFragment = JaxeTransferHandler.analyseString(jaxeTextPane, (String)object);
                        }
                        Element element2 = jaxeTextPane.doc.cfg == null ? null : jaxeTextPane.doc.cfg.premierElementAvecType("fichier");
                        JaxeElement jaxeElement = jaxeTextPane.doc.elementA(n);
                        if (jaxeElement != null && (jaxeElement instanceof JETexte || jaxeElement.debut.getOffset() == n && !(jaxeElement instanceof JESwing))) {
                            jaxeElement = jaxeElement.getParent();
                        }
                        if (documentFragment != null && (jaxeElement == null || !(jaxeElement instanceof JECommentaire) && !(jaxeElement instanceof JECData))) {
                            boolean bl = false;
                            if (jaxeTextPane.getSelectionStart() != jaxeTextPane.getSelectionEnd()) {
                                bl = true;
                                jaxeTextPane.debutEditionSpeciale(JaxeResourceBundle.getRB().getString("menus.Coller"), false);
                                jaxeTextPane.doc.remove(jaxeTextPane.getSelectionStart(), jaxeTextPane.getSelectionEnd() - jaxeTextPane.getSelectionStart());
                            }
                            boolean bl2 = jaxeTextPane.doc.coller(documentFragment, position);
                            if (bl) {
                                jaxeTextPane.finEditionSpeciale();
                                if (!bl2) {
                                    jaxeTextPane.undo();
                                }
                            }
                            return bl2;
                        }
                        if (element2 != null && object instanceof Image && jaxeTextPane.doc.fsave != null) {
                            JEFichier.collerImage((Image)object, jaxeTextPane.doc, position, element2);
                            break block26;
                        }
                        if (element2 != null && dataFlavor.getMimeType().startsWith("image/x-pict") && System.getProperty("os.name").startsWith("Mac OS") && object instanceof InputStream && jaxeTextPane.doc.fsave != null) {
                            Image image = Jaxe.mac.convertirPICT((InputStream)object);
                            JEFichier.collerImage(image, jaxeTextPane.doc, position, element2);
                            break block26;
                        }
                        if (jaxeElement == null) {
                            return false;
                        }
                        if (object instanceof String) {
                            string = ((String)object).replace("\r\n", "\n");
                            string = string.replace("\r", "\n");
                        } else if (object instanceof FragmentXML) {
                            string = ((FragmentXML)object).toString();
                        } else {
                            return false;
                        }
                        if (!(jaxeTextPane.doc.cfg == null || (element = jaxeElement == null || !(jaxeElement.noeud instanceof Element) ? null : jaxeElement.refElement) == null || (jaxeTextPane.doc.cfg.contientDuTexte(element) || "".equals(string.trim())) && jaxeElement.getEditionAutorisee())) {
                            jaxeTextPane.doc.getGestionErreurs().texteInterdit(jaxeElement);
                            return false;
                        }
                        ((JaxeTextPane)jComponent).replaceSelection(string);
                        return true;
                    }
                    catch (BadLocationException badLocationException) {
                        LOG.error("JaxeTransferHandler.importData", badLocationException);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        LOG.error("JaxeTransferHandler.importData", unsupportedFlavorException);
                    }
                    catch (IOException iOException) {
                        LOG.error("JaxeTransferHandler.importData", iOException);
                    }
                }
            }
        }
        return false;
    }

    private static DataFlavor choisirUneSaveur(DataFlavor[] dataFlavorArray, boolean bl) {
        if (dataFlavorArray != null) {
            for (DataFlavor dataFlavor : dataFlavorArray) {
                if (!dataFlavor.equals(XMLTransferable.XMLFragmentFlavor)) continue;
                return dataFlavor;
            }
            if (!bl) {
                for (DataFlavor dataFlavor : dataFlavorArray) {
                    if (!dataFlavor.equals(DataFlavor.stringFlavor)) continue;
                    return dataFlavor;
                }
            }
            for (DataFlavor dataFlavor : dataFlavorArray) {
                if (!dataFlavor.getMimeType().startsWith("image/x-java-image")) continue;
                return dataFlavor;
            }
            for (DataFlavor dataFlavor : dataFlavorArray) {
                if (!dataFlavor.getMimeType().startsWith("image/")) continue;
                return dataFlavor;
            }
            if (bl) {
                for (DataFlavor dataFlavor : dataFlavorArray) {
                    if (!dataFlavor.equals(DataFlavor.stringFlavor)) continue;
                    return dataFlavor;
                }
            }
        }
        return null;
    }

    protected static boolean canAccessSystemClipboard() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkSystemClipboardAccess();
            }
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static DocumentFragment analyseString(JaxeTextPane jaxeTextPane, String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentFragment documentFragment = jaxeTextPane.doc.DOMdoc.createDocumentFragment();
        try {
            Object object;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringBuilder stringBuilder = new StringBuilder();
            Element element = jaxeTextPane.doc.DOMdoc.getDocumentElement();
            if (element == null) {
                stringBuilder.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><import>");
                stringBuilder.append(string);
                stringBuilder.append("</import>");
            } else {
                stringBuilder.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                stringBuilder.append("<");
                object = element.getNodeName();
                stringBuilder.append((String)object);
                NamedNodeMap namedNodeMap = element.getAttributes();
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node = namedNodeMap.item(i);
                    stringBuilder.append(" ");
                    stringBuilder.append(node.getNodeName());
                    stringBuilder.append("=\"");
                    stringBuilder.append(node.getNodeValue());
                    stringBuilder.append("\"");
                }
                stringBuilder.append(">");
                stringBuilder.append(string);
                stringBuilder.append("</");
                stringBuilder.append((String)object);
                stringBuilder.append(">");
            }
            object = documentBuilder.parse(new InputSource(new StringReader(stringBuilder.toString())));
            JaxeTransferHandler.copieEnfants(jaxeTextPane.doc.DOMdoc, object.getDocumentElement(), documentFragment);
            if (JaxeTransferHandler.hasOnlyTextnodes(documentFragment)) {
                documentFragment = null;
            }
        }
        catch (Exception exception) {
            documentFragment = null;
        }
        return documentFragment;
    }

    private static boolean hasOnlyTextnodes(Node node) {
        if (node.hasChildNodes()) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() == 3) continue;
                return false;
            }
        }
        return true;
    }

    private static void copieEnfants(Document document, Node node, Node node2) {
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            node2.appendChild(document.importNode(node3, true));
        }
    }
}

