/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.EditeurFichierConfig;
import editeurconfig.FenetrePrincipale;
import editeurconfig.ListeElements;
import editeurconfig.Outils;
import editeurconfig.Strings;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import jaxe.InterfaceSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GenerationAutomatique {
    private EditeurFichierConfig appl;
    private InterfaceSchema schema;
    private Document doc;
    private Element racine;
    private Element langage;
    private Element fichier_schema;
    private Element menus;
    private Element affichage_noeuds;

    public GenerationAutomatique(EditeurFichierConfig editeurFichierConfig, Document document, Element element) {
        this.appl = editeurFichierConfig;
        this.doc = document;
        this.racine = element;
        this.parcourir();
    }

    private void parcourir() {
        File file = null;
        if (System.getProperty("os.name").indexOf("Linux") != -1 && System.getProperty("java.version").compareTo("1.7") < 0) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = file.getName();
                    int n = string.lastIndexOf(46);
                    return n > 0 && n < string.length() - 1 && (string.substring(n + 1).toLowerCase().equals("xsd") || string.substring(n + 1).toLowerCase().equals("rng"));
                }

                public String getDescription() {
                    return Strings.get("texte.FichiersSchema");
                }
            });
            if (jFileChooser.showOpenDialog(null) == 0) {
                file = jFileChooser.getSelectedFile();
            }
        } else {
            FileDialog fileDialog = new FileDialog((Frame)new JFrame(), null, 0);
            fileDialog.setVisible(true);
            String string = fileDialog.getFile();
            if (string != null) {
                file = new File(fileDialog.getDirectory(), string);
            }
        }
        if (file != null) {
            if (file.getName().toLowerCase().endsWith(".xsd") || file.getName().toLowerCase().endsWith(".rng")) {
                this.charger(file);
            } else {
                JOptionPane.showMessageDialog(null, Strings.get("message.PasUnSchema"), Strings.get("titre.Erreur"), 0);
                new EditeurFichierConfig();
            }
        } else {
            new EditeurFichierConfig();
        }
    }

    private void charger(File file) {
        Object object;
        int n;
        Serializable serializable;
        ListeElements listeElements = null;
        ArrayList<Element> arrayList = null;
        Object var4_4 = null;
        try {
            serializable = file.toURI().toURL();
            listeElements = new ListeElements((URL)serializable, null, null);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Erreur urlFichier " + malformedURLException);
        }
        this.schema = listeElements.getInterfaceSchema();
        this.enregistrerElementLangage();
        this.enregistrerElementSchema(file);
        serializable = null;
        serializable = listeElements.getNomsElementsRacinesP(true);
        for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
            this.enregistrerElementRacine((String)((ArrayList)serializable).get(i));
        }
        this.enregistrerMenus();
        Element element = this.enregistrerMenu("Blocs");
        Element element2 = this.enregistrerMenu("Texte");
        Element element3 = this.enregistrerMenu("Autre");
        this.enregistrerAffichageNoeuds();
        arrayList = listeElements.getReferencesElements();
        for (n = 0; n < arrayList.size(); ++n) {
            object = this.schema.nomElement(arrayList.get(n));
            if (listeElements.elementDeBloc(arrayList.get(n))) {
                this.enregistrerMenuInsertion(element, (String)object);
                continue;
            }
            if (listeElements.elementMelangeTexte(arrayList.get(n))) {
                this.enregistrerMenuInsertion(element2, (String)object);
                continue;
            }
            this.enregistrerMenuInsertion(element3, (String)object);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = this.schema.nomElement(arrayList.get(n));
            if (((ArrayList)serializable).contains(this.schema.nomElement(arrayList.get(n)))) {
                this.enregistrerAffichageElement((String)object, "division");
                continue;
            }
            if (this.schema.listeSousElements(arrayList.get(n)).size() == 0) {
                if (this.schema.contientDuTexte(arrayList.get(n))) {
                    if (this.schema.listeValeursElement(arrayList.get(n)) != null) {
                        this.enregistrerAffichageElement((String)object, "typesimple");
                    }
                } else {
                    this.enregistrerAffichageElement((String)object, "vide");
                }
            }
            if (!this.schema.contientDuTexte(arrayList.get(n)) && this.schema.listeSousElements(arrayList.get(n)).size() <= 0) continue;
            if (listeElements.parentContientDuTexte(arrayList.get(n))) {
                this.enregistrerAffichageElement((String)object, "string");
                continue;
            }
            this.enregistrerAffichageElement((String)object, "zone");
        }
        String string = Locale.getDefault().getLanguage();
        object = this.enregistrerElementStrings(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList<Element> arrayList2;
            String string2 = this.schema.nomElement(arrayList.get(i));
            Element element4 = this.enregistrerStringsElement((Element)object, string2);
            this.enregistrerTitre(element4, string2);
            if (this.schema.documentationElement(arrayList.get(i)) != null) {
                this.enregistrerDocumentation(element4, this.schema.documentationElement(arrayList.get(i)).trim());
            }
            if ((arrayList2 = this.schema.listeAttributs(arrayList.get(i))) == null || arrayList2.size() <= 0) continue;
            for (int j = 0; j < arrayList2.size(); ++j) {
                String string3 = this.schema.nomAttribut(arrayList2.get(j));
                Element element5 = this.enregistrerStringsAttribut(element4, string3);
                this.enregistrerTitre(element5, string3);
                if (this.schema.documentationAttribut(arrayList2.get(j)) == null) continue;
                this.enregistrerDocumentation(element5, this.schema.documentationAttribut(arrayList2.get(j)).trim());
            }
        }
        new FenetrePrincipale(this.appl, null, this.doc, this.racine, listeElements);
    }

    private void enregistrerElementLangage() {
        this.langage = this.doc.createElement("LANGAGE");
        this.racine.appendChild(this.langage);
    }

    private void enregistrerElementSchema(File file) {
        this.fichier_schema = this.doc.createElement("FICHIER_SCHEMA");
        this.fichier_schema.setAttribute("nom", file.getName());
        this.langage.appendChild(this.fichier_schema);
        EditeurFichierConfig.setModif(true);
    }

    private void enregistrerElementRacine(String string) {
        Element element = this.doc.createElement("RACINE");
        this.langage.appendChild(element);
        element.setAttribute("element", string);
        EditeurFichierConfig.setModif(true);
    }

    private Element enregistrerMenus() {
        this.menus = this.doc.createElement("MENUS");
        this.racine.appendChild(this.menus);
        return this.menus;
    }

    private Element enregistrerMenu(String string) {
        Element element = this.doc.createElement("MENU");
        this.menus.appendChild(element);
        element.setAttribute("nom", string);
        return element;
    }

    private Element enregistrerMenuInsertion(Node node, String string) {
        Element element = this.doc.createElement("MENU_INSERTION");
        node.appendChild(element);
        element.setAttribute("nom", string);
        return element;
    }

    private Element enregistrerAffichageNoeuds() {
        this.affichage_noeuds = this.doc.createElement("AFFICHAGE_NOEUDS");
        this.affichage_noeuds = this.doc.createElement("AFFICHAGE_NOEUDS");
        this.racine.appendChild(this.affichage_noeuds);
        return this.affichage_noeuds;
    }

    private void enregistrerAffichageElement(String string, String string2) {
        Element element = this.doc.createElement("AFFICHAGE_ELEMENT");
        this.affichage_noeuds.appendChild(element);
        element.setAttribute("element", string);
        element.setAttribute("type", string2);
        EditeurFichierConfig.setModif(true);
    }

    private Element enregistrerElementStrings(String string) {
        Element element = this.doc.createElement("STRINGS");
        this.racine.appendChild(element);
        element.setAttribute("langue", string);
        return element;
    }

    private Element enregistrerStringsElement(Element element, String string) {
        Element element2 = this.doc.createElement("STRINGS_ELEMENT");
        element.appendChild(element2);
        element2.setAttribute("element", string);
        EditeurFichierConfig.setModif(true);
        return element2;
    }

    private Element enregistrerStringsAttribut(Element element, String string) {
        Element element2 = this.doc.createElement("STRINGS_ATTRIBUT");
        element.appendChild(element2);
        element2.setAttribute("attribut", string);
        EditeurFichierConfig.setModif(true);
        return element2;
    }

    private void enregistrerTitre(Element element, String string) {
        Element element2 = Outils.premierEnfantDeNom(element, "TITRE");
        if (element2 == null) {
            element2 = this.doc.createElement("TITRE");
            element.appendChild(element2);
        }
        Outils.setValeurElement(this.doc, element2, string);
    }

    private void enregistrerDocumentation(Element element, String string) {
        Element element2 = Outils.premierEnfantDeNom(element, "DOCUMENTATION");
        if (element2 == null) {
            element2 = this.doc.createElement("DOCUMENTATION");
            element.appendChild(element2);
        }
        Outils.setValeurElement(this.doc, element2, string);
    }
}

