/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.AutreConfig;
import editeurconfig.ChoixRacine;
import editeurconfig.EditeurDeMenus;
import editeurconfig.EditeurDesElements;
import editeurconfig.EditeurDesExports;
import editeurconfig.EditeurDesTextes;
import editeurconfig.EditeurEnregistrement;
import editeurconfig.EditeurFichierConfig;
import editeurconfig.EditeurSchemaSimple;
import editeurconfig.ListeElements;
import editeurconfig.Outils;
import editeurconfig.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FenetrePrincipale
extends JFrame {
    private EditeurFichierConfig appl;
    private File fichierXML;
    private Document doc;
    private Element racine;
    private Element affichage_noeuds;
    private ListeElements listeElements;
    private EditeurDeMenus editeurM;
    private EditeurDesElements editeurE;
    private EditeurDesTextes editeurT;
    private ArrayList<String> lAffEl = new ArrayList();
    private ArrayList<String> lesElements = new ArrayList();

    public FenetrePrincipale(EditeurFichierConfig editeurFichierConfig, File file, Document document, Element element, ListeElements listeElements) {
        if (file != null) {
            this.setTitle(file.getPath());
        } else {
            this.setTitle(Strings.get("titre.FenetrePrincipale"));
        }
        this.appl = editeurFichierConfig;
        this.fichierXML = file;
        this.doc = document;
        this.racine = element;
        this.listeElements = listeElements;
        this.affichage_noeuds = Outils.premierEnfantDeNom(element, "AFFICHAGE_NOEUDS");
        if (this.affichage_noeuds == null) {
            this.affichage_noeuds = document.createElement("AFFICHAGE_NOEUDS");
            element.insertBefore(this.affichage_noeuds, Outils.premierEnfantDeNom(element, "STRINGS"));
        }
        this.setDefaultCloseOperation(0);
        this.afficher();
        for (Node node = this.affichage_noeuds.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"AFFICHAGE_ELEMENT".equals(node.getNodeName()) || !(node instanceof Element)) continue;
            Element element2 = (Element)node;
            this.lAffEl.add(element2.getAttribute("element"));
        }
        this.lesElements = listeElements.getLesElements();
        for (int i = 0; i < this.lesElements.size(); ++i) {
            if (this.affichage_noeuds.hasChildNodes()) {
                if (this.lAffEl == null || this.lAffEl.contains(this.lesElements.get(i))) continue;
                this.enregistrerAffichageElement(this.lesElements.get(i));
                continue;
            }
            this.enregistrerAffichageElement(this.lesElements.get(i));
        }
    }

    public void afficher() {
        Element element = Outils.premierEnfantDeNom(this.racine, "LANGAGE");
        Element element2 = Outils.premierEnfantDeNom(element, "SCHEMA_SIMPLE");
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "North");
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(40));
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Racines")){

            public void actionPerformed(ActionEvent actionEvent) {
                new ChoixRacine(FenetrePrincipale.this.appl, false, FenetrePrincipale.this.doc, FenetrePrincipale.this.racine, FenetrePrincipale.this.listeElements);
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createVerticalStrut(15));
        JButton jButton2 = new JButton(new AbstractAction(Strings.get("bouton.AutreConfig")){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetrePrincipale.this.autreConfig();
            }
        });
        jPanel.add(jButton2);
        jPanel.add(Box.createVerticalStrut(15));
        JButton jButton3 = new JButton(new AbstractAction(Strings.get("bouton.Enregistrement")){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetrePrincipale.this.setVisible(false);
                FenetrePrincipale.this.editerEnregistrement();
            }
        });
        jPanel.add(jButton3);
        jPanel.add(Box.createVerticalStrut(15));
        JButton jButton4 = new JButton(new AbstractAction(Strings.get("bouton.EditeurDeSchemaSimple")){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetrePrincipale.this.setVisible(false);
                new EditeurSchemaSimple(FenetrePrincipale.this.appl, FenetrePrincipale.this.fichierXML, false, FenetrePrincipale.this.doc, FenetrePrincipale.this.racine);
            }
        });
        jPanel.add(jButton4);
        jPanel.add(Box.createVerticalStrut(15));
        if (element2 != null) {
            jButton4.setEnabled(true);
        } else {
            jButton4.setEnabled(false);
        }
        JButton jButton5 = new JButton(new AbstractAction(Strings.get("bouton.EditeurDeMenus")){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetrePrincipale.this.setVisible(false);
                FenetrePrincipale.this.editerMenus();
            }
        });
        jPanel.add(jButton5);
        jPanel.add(Box.createVerticalStrut(15));
        JButton jButton6 = new JButton(new AbstractAction(Strings.get("bouton.EditeurDesElements")){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetrePrincipale.this.setVisible(false);
                FenetrePrincipale.this.editerElements();
            }
        });
        jPanel.add(jButton6);
        jPanel.add(Box.createVerticalStrut(15));
        JButton jButton7 = new JButton(new AbstractAction(Strings.get("bouton.EditeurDesExports")){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetrePrincipale.this.editerExports();
            }
        });
        jPanel.add(jButton7);
        jPanel.add(Box.createVerticalStrut(15));
        JButton jButton8 = new JButton(new AbstractAction(Strings.get("bouton.EditeurDesTextesG")){

            public void actionPerformed(ActionEvent actionEvent) {
                FenetrePrincipale.this.setVisible(false);
                FenetrePrincipale.this.editerTextesG();
            }
        });
        jPanel.add(jButton8);
        jPanel.add(Box.createVerticalStrut(50));
        this.creerPanelBoutonsBas();
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setVisible(true);
    }

    private void creerPanelBoutonsBas() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Quitter")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FenetrePrincipale.this.appl.getModif()) {
                    int n = JOptionPane.showConfirmDialog(FenetrePrincipale.this, Strings.get("message.EnregistrerAvant"), Strings.get("titre.Fermeture"), 1);
                    if (n == 1) {
                        FenetrePrincipale.this.appl;
                        EditeurFichierConfig.quitter();
                    } else if (n == 0) {
                        if (FenetrePrincipale.this.appl.enregistrerFichier(FenetrePrincipale.this.fichierXML)) {
                            JOptionPane.showMessageDialog(FenetrePrincipale.this, Strings.get("message.EnregistrementReussi"));
                            FenetrePrincipale.this.setVisible(false);
                            new EditeurFichierConfig();
                        }
                    } else if (n == 2) {
                        return;
                    }
                } else {
                    FenetrePrincipale.this.appl;
                    EditeurFichierConfig.quitter();
                }
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(new AbstractAction(Strings.get("bouton.Enregistrer")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FenetrePrincipale.this.appl.enregistrerFichier(FenetrePrincipale.this.fichierXML)) {
                    if (((FenetrePrincipale)FenetrePrincipale.this).appl.fsave != null) {
                        FenetrePrincipale.this.fichierXML = ((FenetrePrincipale)FenetrePrincipale.this).appl.fsave;
                    }
                    FenetrePrincipale.this.appl;
                    EditeurFichierConfig.setModif(false);
                    JOptionPane.showMessageDialog(FenetrePrincipale.this, Strings.get("message.EnregistrementReussi"));
                }
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(new AbstractAction("tester"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurFichierConfig.convertToString(FenetrePrincipale.this.doc);
            }
        });
    }

    private void autreConfig() {
        if (this.appl.fsave != null || this.fichierXML != null) {
            this.setVisible(false);
            File file = null;
            if (this.appl.fsave != null) {
                file = this.appl.fsave;
            }
            if (this.fichierXML != null) {
                file = this.fichierXML;
            }
            new AutreConfig(this, this.doc, this.racine, file);
        } else {
            JOptionPane.showMessageDialog(this, Strings.get("message.SauverAvant"), Strings.get("titre.Erreur"), 0);
        }
    }

    private void editerEnregistrement() {
        new EditeurEnregistrement(this, this.doc, this.racine);
    }

    private void editerMenus() {
        new EditeurDeMenus(this, this.doc, this.racine, this.listeElements);
    }

    private void editerElements() {
        new EditeurDesElements(this, this.doc, this.racine, this.listeElements);
    }

    private void editerExports() {
        if (this.appl.fsave != null || this.fichierXML != null) {
            this.setVisible(false);
            File file = null;
            if (this.appl.fsave != null) {
                file = this.appl.fsave;
            }
            if (this.fichierXML != null) {
                file = this.fichierXML;
            }
            new EditeurDesExports(this, this.doc, this.racine, file);
        } else {
            JOptionPane.showMessageDialog(this, Strings.get("message.SauverAvant"), Strings.get("titre.Erreur"), 0);
        }
    }

    private void editerTextesG() {
        new EditeurDesTextes(this, this.doc, this.racine, this.listeElements);
    }

    private void enregistrerAffichageElement(String string) {
        Element element = Outils.getElementSelectionne(this.affichage_noeuds, "AFFICHAGE_ELEMENT", string, "element");
        if (element == null) {
            element = this.doc.createElement("AFFICHAGE_ELEMENT");
            this.affichage_noeuds.appendChild(element);
            element.setAttribute("element", string);
            element.setAttribute("type", "string");
            EditeurFichierConfig.setModif(true);
        }
    }
}

