/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.AttributSS;
import editeurconfig.ChoixDuSchema;
import editeurconfig.EditeurFichierConfig;
import editeurconfig.ElementSS;
import editeurconfig.EnsembleSS;
import editeurconfig.FenetrePrincipale;
import editeurconfig.ListeElements;
import editeurconfig.Outils;
import editeurconfig.Strings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EditeurSchemaSimple
extends JFrame {
    private EditeurFichierConfig appl;
    private File fichierXML;
    private boolean nouveau;
    private org.w3c.dom.Document doc;
    private Element racine;
    private Element langage;
    private Element schema_simple;
    private int nbSousElements = 0;
    private int nbSousEnsembles = 0;
    private int nbParents = 0;
    private Object elementSelectionne;
    private Object ensembleSelectionne;
    private ElementSS monElementSS;
    private EnsembleSS monEnsembleSS;
    private ArrayList<ElementSS> parents = new ArrayList();
    private ArrayList<ElementSS> sousElements = new ArrayList();
    private ArrayList<EnsembleSS> sousEnsembles = new ArrayList();
    private ArrayList<AttributSS> attributs = new ArrayList();
    private ArrayList<String> valeurs = new ArrayList();
    private JTextField nomElement_t;
    private JTextField nomEnsemble_t;
    private JComboBox texte_c;
    private JPanel panelHaut;
    private JPanel panelListeElements;
    private JPanel panelListeEnsembles;
    private JPanel panelBas;
    private JPanel panelAffichageEns;
    private JPanel panelListeSousElements;
    private JPanel panelListeSousEnsembles;
    private JPanel panelListeParents;
    private JPanel panelOnglets;
    private JPanel listePanelAttribut;
    private JTabbedPane onglets;
    private JScrollPane defilementAffichageEl;
    private DefaultListModel modeleListeElements;
    private DefaultListModel modeleListeEnsembles;
    private DefaultListModel modeleListeSousElements;
    private DefaultListModel modeleListeSousEnsembles;
    private DefaultListModel modeleListeParents;
    private DefaultListModel modeleChoisirElement;
    private DefaultListModel modeleChoisirEnsemble;
    private JList listeElements;
    private JList listeEnsembles;
    private JList listeSousElements;
    private JList listeSousEnsembles;
    private JList listeParents;
    private JList listeChoisirElement;
    private JList listeChoisirEnsemble;
    private JButton boutonPlus;
    private JButton boutonMoins;
    private JButton boutonSelectionner;
    private static final String[] attr_texte_mem = new String[]{"interdit", "autorise"};
    private static final String[] attr_texte = new String[]{Strings.get("label.interdit"), Strings.get("label.autorise")};
    private static final String[] attr_presence = new String[]{Strings.get("label.optionnelle"), Strings.get("label.obligatoire")};
    private DocumentListener docListenerElement;
    private DocumentListener docListenerEnsemble;

    public EditeurSchemaSimple(EditeurFichierConfig editeurFichierConfig, File file, boolean bl, org.w3c.dom.Document document, Element element) {
        super(Strings.get("titre.EditeurDeSchemaSimple"));
        this.setResizable(false);
        this.appl = editeurFichierConfig;
        this.fichierXML = file;
        this.nouveau = bl;
        this.doc = document;
        this.racine = element;
        this.setDefaultCloseOperation(0);
        this.afficher();
        this.langage = Outils.premierEnfantDeNom(element, "LANGAGE");
        if (this.langage != null) {
            this.schema_simple = Outils.premierEnfantDeNom(this.langage, "SCHEMA_SIMPLE");
            if (this.schema_simple != null && this.schema_simple.hasChildNodes()) {
                this.DOMVersClasse();
            }
        }
        this.docListenerElement = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurSchemaSimple.this.ecouteurNomElement(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurSchemaSimple.this.ecouteurNomElement(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurSchemaSimple.this.ecouteurNomElement(documentEvent);
            }
        };
        this.docListenerEnsemble = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurSchemaSimple.this.ecouteurNomEnsemble(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurSchemaSimple.this.ecouteurNomEnsemble(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurSchemaSimple.this.ecouteurNomEnsemble(documentEvent);
            }
        };
    }

    private void afficher() {
        this.creerPanelHaut();
        this.creerPanelBas();
        this.creerPanelBoutons();
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setVisible(true);
        this.listeElements.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EditeurSchemaSimple.this.elementSelectionne = EditeurSchemaSimple.this.listeElements.getSelectedValue();
                if (EditeurSchemaSimple.this.elementSelectionne != null) {
                    if (EditeurSchemaSimple.this.elementSelectionne instanceof ElementSS) {
                        EditeurSchemaSimple.this.monEnsembleSS = null;
                        EditeurSchemaSimple.this.monElementSS = (ElementSS)EditeurSchemaSimple.this.elementSelectionne;
                        EditeurSchemaSimple.this.listeEnsembles.clearSelection();
                        EditeurSchemaSimple.this.panelAffichageEns.setVisible(false);
                        EditeurSchemaSimple.this.defilementAffichageEl.setVisible(true);
                        EditeurSchemaSimple.this.nomElement_t.getDocument().removeDocumentListener(EditeurSchemaSimple.this.docListenerElement);
                        EditeurSchemaSimple.this.nomElement_t.setText(EditeurSchemaSimple.this.elementSelectionne.toString());
                        EditeurSchemaSimple.this.nomElement_t.requestFocus();
                        EditeurSchemaSimple.this.nomElement_t.getDocument().addDocumentListener(EditeurSchemaSimple.this.docListenerElement);
                        if (!"".equals(EditeurSchemaSimple.this.monElementSS.getTexte())) {
                            EditeurSchemaSimple.this.texte_c.setSelectedItem(Strings.get("label." + EditeurSchemaSimple.this.monElementSS.getTexte()));
                        }
                        EditeurSchemaSimple.this.activerComposant(EditeurSchemaSimple.this.panelOnglets, true);
                    }
                    if (EditeurSchemaSimple.this.monElementSS != null) {
                        int n;
                        EditeurSchemaSimple.this.nbSousElements = 0;
                        EditeurSchemaSimple.this.sousElements = null;
                        EditeurSchemaSimple.this.sousElements = EditeurSchemaSimple.this.monElementSS.getSousElements();
                        EditeurSchemaSimple.this.modeleListeSousElements.clear();
                        if (EditeurSchemaSimple.this.sousElements != null && EditeurSchemaSimple.this.sousElements.size() > 0) {
                            for (n = 0; n < EditeurSchemaSimple.this.sousElements.size(); ++n) {
                                EditeurSchemaSimple.this.modeleListeSousElements.addElement(EditeurSchemaSimple.this.sousElements.get(n));
                            }
                            EditeurSchemaSimple.this.nbSousElements = EditeurSchemaSimple.this.sousElements.size();
                        }
                        EditeurSchemaSimple.this.nbSousEnsembles = 0;
                        EditeurSchemaSimple.this.sousEnsembles = null;
                        EditeurSchemaSimple.this.sousEnsembles = EditeurSchemaSimple.this.monElementSS.getSousEnsembles();
                        EditeurSchemaSimple.this.modeleListeSousEnsembles.clear();
                        if (EditeurSchemaSimple.this.sousEnsembles != null && EditeurSchemaSimple.this.sousEnsembles.size() > 0) {
                            for (n = 0; n < EditeurSchemaSimple.this.sousEnsembles.size(); ++n) {
                                EditeurSchemaSimple.this.modeleListeSousEnsembles.addElement(EditeurSchemaSimple.this.sousEnsembles.get(n));
                            }
                            EditeurSchemaSimple.this.nbSousEnsembles = EditeurSchemaSimple.this.sousEnsembles.size();
                        }
                        EditeurSchemaSimple.this.nbParents = 0;
                        EditeurSchemaSimple.this.parents = null;
                        EditeurSchemaSimple.this.parents = EditeurSchemaSimple.this.monElementSS.getParents();
                        EditeurSchemaSimple.this.modeleListeParents.clear();
                        if (EditeurSchemaSimple.this.parents != null && EditeurSchemaSimple.this.parents.size() > 0) {
                            for (n = 0; n < EditeurSchemaSimple.this.parents.size(); ++n) {
                                EditeurSchemaSimple.this.modeleListeParents.addElement(EditeurSchemaSimple.this.parents.get(n));
                            }
                            EditeurSchemaSimple.this.nbParents = EditeurSchemaSimple.this.parents.size();
                        }
                        EditeurSchemaSimple.this.reconstruireOnglets();
                        EditeurSchemaSimple.this.recupererAttributs();
                    }
                } else {
                    EditeurSchemaSimple.this.panelAffichageEns.setVisible(true);
                    EditeurSchemaSimple.this.nomEnsemble_t.setEnabled(false);
                    EditeurSchemaSimple.this.defilementAffichageEl.setVisible(false);
                    EditeurSchemaSimple.this.activerComposant(EditeurSchemaSimple.this.panelOnglets, false);
                    EditeurSchemaSimple.this.modeleListeSousElements.clear();
                    EditeurSchemaSimple.this.nbSousElements = 0;
                    EditeurSchemaSimple.this.nbSousEnsembles = 0;
                    EditeurSchemaSimple.this.nbParents = 0;
                    EditeurSchemaSimple.this.reconstruireOnglets();
                }
            }
        });
        this.listeEnsembles.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EditeurSchemaSimple.this.ensembleSelectionne = EditeurSchemaSimple.this.listeEnsembles.getSelectedValue();
                if (EditeurSchemaSimple.this.ensembleSelectionne != null) {
                    if (EditeurSchemaSimple.this.ensembleSelectionne instanceof EnsembleSS) {
                        EditeurSchemaSimple.this.monElementSS = null;
                        EditeurSchemaSimple.this.monEnsembleSS = (EnsembleSS)EditeurSchemaSimple.this.ensembleSelectionne;
                        EditeurSchemaSimple.this.listeElements.clearSelection();
                        EditeurSchemaSimple.this.defilementAffichageEl.setVisible(false);
                        EditeurSchemaSimple.this.panelAffichageEns.setVisible(true);
                        EditeurSchemaSimple.this.nomEnsemble_t.setEnabled(true);
                        EditeurSchemaSimple.this.nomEnsemble_t.getDocument().removeDocumentListener(EditeurSchemaSimple.this.docListenerEnsemble);
                        EditeurSchemaSimple.this.nomEnsemble_t.setText(EditeurSchemaSimple.this.ensembleSelectionne.toString());
                        EditeurSchemaSimple.this.nomEnsemble_t.requestFocus();
                        EditeurSchemaSimple.this.nomEnsemble_t.getDocument().addDocumentListener(EditeurSchemaSimple.this.docListenerEnsemble);
                        EditeurSchemaSimple.this.activerComposant(EditeurSchemaSimple.this.panelOnglets, true);
                    }
                    if (EditeurSchemaSimple.this.monEnsembleSS != null) {
                        int n;
                        EditeurSchemaSimple.this.nbSousElements = 0;
                        EditeurSchemaSimple.this.sousElements = null;
                        EditeurSchemaSimple.this.sousElements = EditeurSchemaSimple.this.monEnsembleSS.getSousElements();
                        EditeurSchemaSimple.this.modeleListeSousElements.clear();
                        if (EditeurSchemaSimple.this.sousElements != null && EditeurSchemaSimple.this.sousElements.size() > 0) {
                            for (n = 0; n < EditeurSchemaSimple.this.sousElements.size(); ++n) {
                                EditeurSchemaSimple.this.modeleListeSousElements.addElement(EditeurSchemaSimple.this.sousElements.get(n));
                            }
                            EditeurSchemaSimple.this.nbSousElements = EditeurSchemaSimple.this.sousElements.size();
                        }
                        EditeurSchemaSimple.this.nbSousEnsembles = 0;
                        EditeurSchemaSimple.this.sousEnsembles = null;
                        EditeurSchemaSimple.this.sousEnsembles = EditeurSchemaSimple.this.monEnsembleSS.getSousEnsembles();
                        EditeurSchemaSimple.this.modeleListeSousEnsembles.clear();
                        if (EditeurSchemaSimple.this.sousEnsembles != null && EditeurSchemaSimple.this.sousEnsembles.size() > 0) {
                            for (n = 0; n < EditeurSchemaSimple.this.sousEnsembles.size(); ++n) {
                                EditeurSchemaSimple.this.modeleListeSousEnsembles.addElement(EditeurSchemaSimple.this.sousEnsembles.get(n));
                            }
                            EditeurSchemaSimple.this.nbSousEnsembles = EditeurSchemaSimple.this.sousEnsembles.size();
                        }
                        EditeurSchemaSimple.this.nbParents = 0;
                        EditeurSchemaSimple.this.modeleListeParents.clear();
                        EditeurSchemaSimple.this.reconstruireOnglets();
                    }
                } else {
                    EditeurSchemaSimple.this.panelAffichageEns.setVisible(true);
                    EditeurSchemaSimple.this.nomEnsemble_t.setEnabled(false);
                    EditeurSchemaSimple.this.defilementAffichageEl.setVisible(false);
                    EditeurSchemaSimple.this.activerComposant(EditeurSchemaSimple.this.panelOnglets, false);
                }
            }
        });
    }

    private void creerPanelHaut() {
        this.creerPanelListeElements();
        this.creerPanelListeEnsembles();
        this.panelHaut = new JPanel(new FlowLayout(0));
        this.panelHaut.add(this.panelListeElements);
        this.panelHaut.add(this.panelListeEnsembles);
        this.add((Component)this.panelHaut, "North");
        this.panelHaut.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    private void creerPanelListeElements() {
        this.panelListeElements = new JPanel(new FlowLayout(0));
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(Strings.get("label.Elements"));
        jPanel.add((Component)jLabel, "North");
        this.modeleListeElements = new DefaultListModel();
        this.listeElements = new JList(this.modeleListeElements);
        this.listeElements.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.listeElements);
        jPanel.add(jScrollPane);
        jScrollPane.setPreferredSize(new Dimension(220, 200));
        this.panelListeElements.add(jPanel);
        this.creerPanBoutonPlusMoins(this.panelListeElements, true, true, false);
        this.boutonPlus.setAction(new AbstractAction("+"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.nouvelElement(true);
            }
        });
        this.boutonMoins.setAction(new AbstractAction("-"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.supprimerElement();
            }
        });
    }

    private void creerPanelListeEnsembles() {
        this.panelListeEnsembles = new JPanel(new FlowLayout(0));
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(Strings.get("label.Ensembles"));
        jPanel.add((Component)jLabel, "North");
        this.modeleListeEnsembles = new DefaultListModel();
        this.listeEnsembles = new JList(this.modeleListeEnsembles);
        this.listeEnsembles.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.listeEnsembles);
        jPanel.add(jScrollPane);
        jScrollPane.setPreferredSize(new Dimension(220, 200));
        this.panelListeEnsembles.add(jPanel);
        this.creerPanBoutonPlusMoins(this.panelListeEnsembles, true, true, false);
        this.boutonPlus.setAction(new AbstractAction("+"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.nouvelEnsemble(true);
            }
        });
        this.boutonMoins.setAction(new AbstractAction("-"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.supprimerEnsemble();
            }
        });
    }

    private void creerPanelBas() {
        this.panelBas = new JPanel(new FlowLayout(0));
        this.creerPanelAffichageEl();
        this.creerPanelAffichageEns();
        this.creerPanelOnglets();
        this.add((Component)this.panelBas, "Center");
    }

    private void creerPanelAffichageEl() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new TitledBorder(""));
        this.defilementAffichageEl = new JScrollPane(jPanel, 20, 31);
        this.defilementAffichageEl.setPreferredSize(new Dimension(400, 319));
        this.panelBas.add(this.defilementAffichageEl);
        this.defilementAffichageEl.setVisible(false);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.add(jPanel2);
        JLabel jLabel = new JLabel(Strings.get("label.Nom"));
        this.nomElement_t = new JTextField(15);
        jPanel2.add(jLabel);
        jPanel2.add(this.nomElement_t);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel.add(jPanel3);
        JLabel jLabel2 = new JLabel(Strings.get("label.Texte"));
        this.texte_c = new JComboBox<String>(attr_texte);
        this.texte_c.setSelectedIndex(0);
        jPanel3.add(jLabel2);
        jPanel3.add(this.texte_c);
        this.texte_c.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (EditeurSchemaSimple.this.texte_c.getSelectedItem() != null) {
                    EditeurSchemaSimple.this.monElementSS.setTexte(attr_texte_mem[EditeurSchemaSimple.this.texte_c.getSelectedIndex()]);
                }
            }
        });
        this.listePanelAttribut = new JPanel();
        this.listePanelAttribut.setLayout(new BoxLayout(this.listePanelAttribut, 1));
        jPanel.add(this.listePanelAttribut);
    }

    private void creerPanelAffichageEns() {
        this.panelAffichageEns = new JPanel();
        this.panelAffichageEns.setBorder(new TitledBorder(""));
        this.panelAffichageEns.setPreferredSize(new Dimension(400, 319));
        this.panelBas.add(this.panelAffichageEns);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.panelAffichageEns.add(jPanel);
        JLabel jLabel = new JLabel(Strings.get("label.Nom"));
        this.nomEnsemble_t = new JTextField(15);
        this.nomEnsemble_t.setEnabled(false);
        jPanel.add(jLabel);
        jPanel.add(this.nomEnsemble_t);
    }

    private void creerPanelAttribut(final AttributSS attributSS, final int n) {
        final JPanel jPanel = new JPanel(new FlowLayout(0));
        this.listePanelAttribut.add(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(3, 2));
        jPanel.add(jPanel2);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(new TitledBorder(Strings.get("label.Attribut")));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel3);
        JLabel jLabel = new JLabel(Strings.get("label.Nom"));
        final JTextField jTextField = new JTextField(15);
        if (attributSS != null) {
            jTextField.setText(attributSS.getNom());
        }
        jPanel3.add(jLabel);
        jPanel3.add(jTextField);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurSchemaSimple.this.ecouteurNomAttribut(documentEvent, attributSS);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurSchemaSimple.this.ecouteurNomAttribut(documentEvent, attributSS);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurSchemaSimple.this.ecouteurNomAttribut(documentEvent, attributSS);
            }
        });
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel4);
        JLabel jLabel2 = new JLabel(Strings.get("label.presence"));
        final JComboBox<String> jComboBox = new JComboBox<String>(attr_presence);
        jComboBox.setSelectedIndex(0);
        if (attributSS != null && !"".equals(attributSS.getPresence())) {
            jComboBox.setSelectedItem(Strings.get("label." + attributSS.getPresence()));
        }
        jPanel4.add(jLabel2);
        jPanel4.add(jComboBox);
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (jComboBox.getSelectedItem() != null) {
                    attributSS.setPresence(attr_presence[jComboBox.getSelectedIndex()]);
                }
            }
        });
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel2.add(jPanel5);
        if (attributSS != null) {
            this.recupererValeurs(attributSS, jPanel2, jPanel5);
        }
        this.creerPanBoutonPlusMoins(jPanel, true, true, false);
        this.boutonPlus.setAction(new AbstractAction("+"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!"".equals(jTextField.getText()) && jComboBox.getSelectedItem() != null) {
                    EditeurSchemaSimple.this.creerPanelAttribut(EditeurSchemaSimple.this.enregistrerAttribut(EditeurSchemaSimple.this.listePanelAttribut.getComponentCount(), ""), EditeurSchemaSimple.this.listePanelAttribut.getComponentCount());
                    EditeurSchemaSimple.this.listePanelAttribut.revalidate();
                }
            }
        });
        this.boutonMoins.setAction(new AbstractAction("-"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EditeurSchemaSimple.this.listePanelAttribut.getComponentCount() > 1) {
                    EditeurSchemaSimple.this.listePanelAttribut.remove(jPanel);
                    EditeurSchemaSimple.this.listePanelAttribut.revalidate();
                    AttributSS attributSS = EditeurSchemaSimple.this.trouverAttribut(n);
                    if (attributSS != null) {
                        EditeurSchemaSimple.this.monElementSS.supprimerAttribut(attributSS);
                    }
                }
            }
        });
    }

    private void creerPanelValeur(final AttributSS attributSS, String string, final int n, final JPanel jPanel, final JPanel jPanel2) {
        final JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel3.add(jPanel4);
        JLabel jLabel = new JLabel(Strings.get("label.Valeur"));
        final JTextField jTextField = new JTextField(15);
        jTextField.setText(string);
        jPanel4.add(jLabel);
        jPanel4.add(jTextField);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                EditeurSchemaSimple.this.ecouteurValeurAttribut(documentEvent, attributSS, jPanel2.getComponentZOrder(jPanel3));
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                EditeurSchemaSimple.this.ecouteurValeurAttribut(documentEvent, attributSS, jPanel2.getComponentZOrder(jPanel3));
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EditeurSchemaSimple.this.ecouteurValeurAttribut(documentEvent, attributSS, jPanel2.getComponentZOrder(jPanel3));
            }
        });
        this.creerPanBoutonPlusMoins(jPanel3, true, true, false);
        this.boutonPlus.setAction(new AbstractAction("+"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!"".equals(jTextField.getText())) {
                    EditeurSchemaSimple.this.creerPanelValeur(attributSS, EditeurSchemaSimple.this.enregistrerValeurAttribut(attributSS, jPanel2.getComponentCount(), ""), jPanel2.getComponentCount(), jPanel, jPanel2);
                    jPanel2.revalidate();
                }
            }
        });
        this.boutonMoins.setAction(new AbstractAction("-"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jPanel2.getComponentCount() > 1) {
                    jPanel2.remove(jPanel3);
                    jPanel2.revalidate();
                    String string = EditeurSchemaSimple.this.trouverValeur(attributSS, n);
                    if (string != null) {
                        attributSS.supprimerValeur(string);
                    }
                }
            }
        });
    }

    private void creerPanelOnglets() {
        this.panelOnglets = new JPanel();
        this.panelBas.add(this.panelOnglets);
        this.onglets = new JTabbedPane(1);
        this.onglets.setPreferredSize(new Dimension(420, 300));
        this.panelOnglets.add(this.onglets);
        this.creerPanelListeSousElements();
        this.onglets.addTab(Strings.get("label.SousElements") + " (" + this.nbSousElements + ")", this.panelListeSousElements);
        this.creerPanelListeSousEnsembles();
        this.onglets.addTab(Strings.get("label.SousEnsembles") + " (" + this.nbSousEnsembles + ")", this.panelListeSousEnsembles);
        this.creerPanelListeParents();
        this.onglets.addTab(Strings.get("label.Parents") + " (" + this.nbParents + ")", this.panelListeParents);
        this.activerComposant(this.panelOnglets, false);
    }

    private void creerPanelListeSousElements() {
        this.panelListeSousElements = new JPanel(new FlowLayout(0));
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(Strings.get("label.SousElements"));
        jPanel.add((Component)jLabel, "North");
        this.modeleChoisirElement = new DefaultListModel();
        this.listeChoisirElement = new JList(this.modeleChoisirElement);
        this.modeleListeSousElements = new DefaultListModel();
        this.listeSousElements = new JList(this.modeleListeSousElements);
        this.listeSousElements.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.listeSousElements);
        jPanel.add(jScrollPane);
        jScrollPane.setPreferredSize(new Dimension(220, 200));
        this.panelListeSousElements.add(jPanel);
        this.creerPanBoutonPlusMoins(this.panelListeSousElements, true, true, true);
        this.boutonPlus.setAction(new AbstractAction("+"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.ajouterSousElement();
            }
        });
        this.boutonMoins.setAction(new AbstractAction("-"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.supprimerSousElement();
            }
        });
        this.boutonSelectionner.setAction(new AbstractAction("S\u00e9lectionner"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EditeurSchemaSimple.this.listeSousElements.getSelectedValue() instanceof ElementSS) {
                    ElementSS elementSS = (ElementSS)EditeurSchemaSimple.this.listeSousElements.getSelectedValue();
                    EditeurSchemaSimple.this.listeElements.setSelectedValue(elementSS, true);
                    EditeurSchemaSimple.this.listeSousElements.clearSelection();
                }
            }
        });
        this.listeSousElements.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && EditeurSchemaSimple.this.listeSousElements.getSelectedValue() instanceof ElementSS) {
                    ElementSS elementSS = (ElementSS)EditeurSchemaSimple.this.listeSousElements.getSelectedValue();
                    EditeurSchemaSimple.this.listeElements.setSelectedValue(elementSS, true);
                    EditeurSchemaSimple.this.listeSousElements.clearSelection();
                }
            }
        });
    }

    private void creerPanelListeSousEnsembles() {
        this.panelListeSousEnsembles = new JPanel(new FlowLayout(0));
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(Strings.get("label.SousEnsembles"));
        jPanel.add((Component)jLabel, "North");
        this.modeleChoisirEnsemble = new DefaultListModel();
        this.listeChoisirEnsemble = new JList(this.modeleChoisirEnsemble);
        this.modeleListeSousEnsembles = new DefaultListModel();
        this.listeSousEnsembles = new JList(this.modeleListeSousEnsembles);
        this.listeSousEnsembles.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.listeSousEnsembles);
        jPanel.add(jScrollPane);
        jScrollPane.setPreferredSize(new Dimension(220, 200));
        this.panelListeSousEnsembles.add(jPanel);
        this.creerPanBoutonPlusMoins(this.panelListeSousEnsembles, true, true, true);
        this.boutonPlus.setAction(new AbstractAction("+"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.ajouterSousEnsemble();
            }
        });
        this.boutonMoins.setAction(new AbstractAction("-"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.supprimerSousEnsemble();
            }
        });
        this.boutonSelectionner.setAction(new AbstractAction("S\u00e9lectionner"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EditeurSchemaSimple.this.listeSousEnsembles.getSelectedValue() instanceof EnsembleSS) {
                    EnsembleSS ensembleSS = (EnsembleSS)EditeurSchemaSimple.this.listeSousEnsembles.getSelectedValue();
                    EditeurSchemaSimple.this.listeEnsembles.setSelectedValue(ensembleSS, true);
                    EditeurSchemaSimple.this.listeSousEnsembles.clearSelection();
                }
            }
        });
        this.listeSousEnsembles.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && EditeurSchemaSimple.this.listeSousEnsembles.getSelectedValue() instanceof EnsembleSS) {
                    EnsembleSS ensembleSS = (EnsembleSS)EditeurSchemaSimple.this.listeSousEnsembles.getSelectedValue();
                    EditeurSchemaSimple.this.listeEnsembles.setSelectedValue(ensembleSS, true);
                    EditeurSchemaSimple.this.listeSousEnsembles.clearSelection();
                }
            }
        });
    }

    private void creerPanelListeParents() {
        this.panelListeParents = new JPanel(new FlowLayout(0));
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(Strings.get("label.Parents"));
        jPanel.add((Component)jLabel, "North");
        this.modeleListeParents = new DefaultListModel();
        this.listeParents = new JList(this.modeleListeParents);
        this.listeParents.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.listeParents);
        jPanel.add(jScrollPane);
        jScrollPane.setPreferredSize(new Dimension(220, 200));
        this.panelListeParents.add(jPanel);
        this.creerPanBoutonPlusMoins(this.panelListeParents, false, false, true);
        this.boutonSelectionner.setAction(new AbstractAction("S\u00e9lectionner"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EditeurSchemaSimple.this.listeParents.getSelectedValue() instanceof ElementSS) {
                    ElementSS elementSS = (ElementSS)EditeurSchemaSimple.this.listeParents.getSelectedValue();
                    EditeurSchemaSimple.this.listeElements.setSelectedValue(elementSS, true);
                    EditeurSchemaSimple.this.listeParents.clearSelection();
                }
            }
        });
        this.listeParents.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && EditeurSchemaSimple.this.listeParents.getSelectedValue() instanceof ElementSS) {
                    ElementSS elementSS = (ElementSS)EditeurSchemaSimple.this.listeParents.getSelectedValue();
                    EditeurSchemaSimple.this.listeElements.setSelectedValue(elementSS, true);
                    EditeurSchemaSimple.this.listeParents.clearSelection();
                }
            }
        });
    }

    private void creerPanBoutonPlusMoins(JPanel jPanel, boolean bl, boolean bl2, boolean bl3) {
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add(jPanel2);
        if (bl) {
            this.boutonPlus = new JButton("+");
            jPanel2.add((Component)this.boutonPlus, "North");
        }
        if (bl2) {
            this.boutonMoins = new JButton("-");
            jPanel2.add((Component)this.boutonMoins, "Center");
        }
        if (bl3) {
            this.boutonSelectionner = new JButton("S\u00e9lectionner");
            jPanel2.add((Component)this.boutonSelectionner, "South");
        }
    }

    private void creerPanelBoutons() {
        JButton jButton;
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton2 = new JButton(new AbstractAction("Tester"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.ClasseVersDOM();
                EditeurFichierConfig.convertToString(EditeurSchemaSimple.this.doc);
            }
        });
        if (this.nouveau) {
            jButton = new JButton(new AbstractAction(Strings.get("bouton.Annuler")){

                public void actionPerformed(ActionEvent actionEvent) {
                    EditeurSchemaSimple.this.setVisible(false);
                    new ChoixDuSchema(EditeurSchemaSimple.this.appl, EditeurSchemaSimple.this.doc, EditeurSchemaSimple.this.racine);
                }
            });
            jPanel.add(jButton);
        }
        jButton = new JButton(new AbstractAction(Strings.get("bouton.Fermer")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.ClasseVersDOM();
                NodeList nodeList = EditeurSchemaSimple.this.schema_simple.getElementsByTagName("SOUS-ELEMENT");
                if (nodeList.getLength() >= 1) {
                    ListeElements listeElements = new ListeElements(null, null, EditeurSchemaSimple.this.schema_simple);
                    EditeurSchemaSimple.this.setVisible(false);
                    new FenetrePrincipale(EditeurSchemaSimple.this.appl, EditeurSchemaSimple.this.fichierXML, EditeurSchemaSimple.this.doc, EditeurSchemaSimple.this.racine, listeElements);
                } else {
                    JOptionPane.showMessageDialog(null, Strings.get("message.PasElementOuSousElement"));
                }
            }
        });
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
    }

    private void nouvelElement(final boolean bl) {
        final JDialog jDialog = new JDialog(this, Strings.get("titre.NouvelElement"), true);
        jDialog.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel(new FlowLayout());
        jDialog.add(jPanel);
        final JTextField jTextField = new JTextField(15);
        jPanel.add(jTextField);
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.OK")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.actionNouvelElement(jTextField, jDialog, bl);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(new AbstractAction(Strings.get("bouton.Annuler")){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        jPanel.add(jButton2);
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    EditeurSchemaSimple.this.actionNouvelElement(jTextField, jDialog, bl);
                }
            }
        });
        jDialog.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        jDialog.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        jDialog.setVisible(true);
    }

    private void actionNouvelElement(JTextField jTextField, JDialog jDialog, boolean bl) {
        if (!this.verifCaractere(jTextField.getText())) {
            JOptionPane.showMessageDialog(jDialog, Strings.get("message.CaractereInterdit"));
            jTextField.requestFocus();
            jTextField.selectAll();
        } else {
            boolean bl2 = false;
            ElementSS elementSS = new ElementSS(jTextField.getText());
            for (int i = 0; i < this.modeleListeElements.getSize(); ++i) {
                if (!elementSS.toString().equals(this.modeleListeElements.get(i).toString())) continue;
                JOptionPane.showMessageDialog(jDialog, Strings.get("message.ElementExiste"));
                jTextField.requestFocus();
                jTextField.selectAll();
                bl2 = true;
            }
            if (!bl2) {
                jDialog.setVisible(false);
                this.modeleListeElements.addElement(elementSS);
                this.modeleChoisirElement.addElement(elementSS);
                this.trierListe(this.modeleListeElements);
                this.trierListe(this.modeleChoisirElement);
                if (bl) {
                    this.listeElements.setSelectedValue(elementSS, true);
                } else {
                    this.listeChoisirElement.setSelectedValue(elementSS, true);
                    if (this.monElementSS != null && this.monEnsembleSS == null) {
                        this.listeElements.setSelectedValue(this.monElementSS, true);
                    }
                    if (this.monEnsembleSS != null && this.monElementSS == null) {
                        this.listeEnsembles.setSelectedValue(this.monEnsembleSS, true);
                    }
                }
                EditeurFichierConfig.setModif(true);
            }
        }
    }

    private void nouvelEnsemble(final boolean bl) {
        final JDialog jDialog = new JDialog(this, Strings.get("titre.NouvelEnsemble"), true);
        jDialog.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel(new FlowLayout());
        jDialog.add(jPanel);
        final JTextField jTextField = new JTextField(15);
        jPanel.add(jTextField);
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.OK")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.actionNouvelEnsemble(jTextField, jDialog, bl);
                EditeurSchemaSimple.this.onglets.setSelectedComponent(EditeurSchemaSimple.this.panelListeSousEnsembles);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(new AbstractAction(Strings.get("bouton.Annuler")){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        jPanel.add(jButton2);
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    EditeurSchemaSimple.this.actionNouvelEnsemble(jTextField, jDialog, bl);
                }
            }
        });
        jDialog.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        jDialog.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        jDialog.setVisible(true);
    }

    private void actionNouvelEnsemble(JTextField jTextField, JDialog jDialog, boolean bl) {
        if (!this.verifCaractere(jTextField.getText())) {
            JOptionPane.showMessageDialog(jDialog, Strings.get("message.CaractereInterdit"));
            jTextField.requestFocus();
            jTextField.selectAll();
        } else {
            boolean bl2 = false;
            EnsembleSS ensembleSS = new EnsembleSS(jTextField.getText());
            for (int i = 0; i < this.modeleListeEnsembles.getSize(); ++i) {
                if (!ensembleSS.toString().equals(this.modeleListeEnsembles.get(i).toString())) continue;
                JOptionPane.showMessageDialog(jDialog, Strings.get("message.EnsembleExiste"));
                jTextField.requestFocus();
                jTextField.selectAll();
                bl2 = true;
            }
            if (!bl2) {
                jDialog.setVisible(false);
                this.modeleListeEnsembles.addElement(ensembleSS);
                this.modeleChoisirEnsemble.addElement(ensembleSS);
                this.trierListe(this.modeleListeEnsembles);
                this.trierListe(this.modeleChoisirEnsemble);
                if (bl) {
                    this.listeEnsembles.setSelectedValue(ensembleSS, true);
                } else {
                    this.listeChoisirEnsemble.setSelectedValue(ensembleSS, true);
                    if (this.monElementSS != null && this.monEnsembleSS == null) {
                        this.listeElements.setSelectedValue(this.monElementSS, true);
                    }
                    if (this.monEnsembleSS != null && this.monElementSS == null) {
                        this.listeEnsembles.setSelectedValue(this.monEnsembleSS, true);
                    }
                }
                EditeurFichierConfig.setModif(true);
            }
        }
    }

    private void supprimerElement() {
        if (this.elementSelectionne != null && JOptionPane.showConfirmDialog(this, Strings.get("message.SupprimerCetElement"), Strings.get("titre.Message"), 0) == 0) {
            Comparable comparable;
            int n;
            for (n = 0; n < this.modeleListeElements.getSize(); ++n) {
                if (this.monElementSS.toString().equals(this.modeleListeElements.get(n).toString())) continue;
                comparable = (ElementSS)this.modeleListeElements.get(n);
                ((ElementSS)comparable).supprimerSousElement(this.monElementSS);
                ((ElementSS)comparable).supprimerParent(this.monElementSS);
            }
            for (n = 0; n < this.modeleListeEnsembles.getSize(); ++n) {
                comparable = (EnsembleSS)this.modeleListeEnsembles.get(n);
                ((EnsembleSS)comparable).supprimerSousElement(this.monElementSS);
            }
            this.majElements(null, true);
            this.modeleListeElements.removeElement(this.monElementSS);
            this.modeleChoisirElement.removeElement(this.monElementSS);
            n = this.listeElements.getFirstVisibleIndex();
            if (n != -1) {
                this.listeElements.setSelectedIndex(n);
            }
            EditeurFichierConfig.setModif(true);
        }
    }

    private void supprimerEnsemble() {
        if (this.ensembleSelectionne != null && JOptionPane.showConfirmDialog(this, Strings.get("message.SupprimerCetEnsemble"), Strings.get("titre.Message"), 0) == 0) {
            Comparable comparable;
            int n;
            for (n = 0; n < this.modeleListeEnsembles.getSize(); ++n) {
                if (this.monEnsembleSS.toString().equals(this.modeleListeEnsembles.get(n).toString())) continue;
                comparable = (EnsembleSS)this.modeleListeEnsembles.get(n);
                ((EnsembleSS)comparable).supprimerSousEnsemble(this.monEnsembleSS);
            }
            for (n = 0; n < this.modeleListeElements.getSize(); ++n) {
                comparable = (ElementSS)this.modeleListeElements.get(n);
                ((ElementSS)comparable).supprimerSousEnsemble(this.monEnsembleSS);
            }
            this.modeleListeEnsembles.removeElement(this.monEnsembleSS);
            this.modeleChoisirEnsemble.removeElement(this.monEnsembleSS);
            EditeurFichierConfig.setModif(true);
        }
    }

    private void ajouterSousElement() {
        final JDialog jDialog = new JDialog(this, Strings.get("titre.ChoisirElement"), true);
        jDialog.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel(new BorderLayout());
        jDialog.add(jPanel);
        this.listeChoisirElement.setSelectionMode(0);
        this.listeChoisirElement.clearSelection();
        JScrollPane jScrollPane = new JScrollPane(this.listeChoisirElement);
        jPanel.add((Component)jScrollPane, "North");
        jScrollPane.setPreferredSize(new Dimension(220, 200));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.add((Component)jPanel2, "South");
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Nouveau")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.nouvelElement(false);
            }
        });
        jPanel2.add(jButton);
        final JButton jButton2 = new JButton(new AbstractAction(Strings.get("bouton.OK")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EditeurSchemaSimple.this.listeChoisirElement.getSelectedValue() instanceof ElementSS) {
                    ElementSS elementSS = (ElementSS)EditeurSchemaSimple.this.listeChoisirElement.getSelectedValue();
                    if (EditeurSchemaSimple.this.monElementSS != null && EditeurSchemaSimple.this.monEnsembleSS == null) {
                        if (EditeurSchemaSimple.this.modeleListeSousElements.contains(elementSS)) {
                            JOptionPane.showMessageDialog(jDialog, Strings.get("message.SousElementExiste"));
                        } else {
                            EditeurSchemaSimple.this.monElementSS.ajouterSousElement(elementSS);
                            elementSS.ajouterParent(EditeurSchemaSimple.this.monElementSS);
                            jDialog.setVisible(false);
                        }
                        EditeurSchemaSimple.this.sousElements = null;
                        EditeurSchemaSimple.this.sousElements = EditeurSchemaSimple.this.monElementSS.getSousElements();
                    }
                    if (EditeurSchemaSimple.this.monEnsembleSS != null && EditeurSchemaSimple.this.monElementSS == null) {
                        if (EditeurSchemaSimple.this.modeleListeSousElements.contains(elementSS)) {
                            JOptionPane.showMessageDialog(jDialog, Strings.get("message.SousElementExiste"));
                        } else {
                            EditeurSchemaSimple.this.monEnsembleSS.ajouterSousElement(elementSS);
                            jDialog.setVisible(false);
                        }
                        EditeurSchemaSimple.this.sousElements = null;
                        EditeurSchemaSimple.this.sousElements = EditeurSchemaSimple.this.monEnsembleSS.getSousElements();
                    }
                    if (EditeurSchemaSimple.this.sousElements != null && EditeurSchemaSimple.this.sousElements.size() > 0) {
                        EditeurSchemaSimple.this.modeleListeSousElements.clear();
                        for (int i = 0; i < EditeurSchemaSimple.this.sousElements.size(); ++i) {
                            EditeurSchemaSimple.this.modeleListeSousElements.addElement(EditeurSchemaSimple.this.sousElements.get(i));
                        }
                        EditeurSchemaSimple.this.nbSousElements = EditeurSchemaSimple.this.sousElements.size();
                        EditeurSchemaSimple.this.reconstruireOnglets();
                    }
                    EditeurFichierConfig.setModif(true);
                }
            }
        });
        jPanel2.add(jButton2);
        jButton2.setEnabled(false);
        this.listeChoisirElement.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (EditeurSchemaSimple.this.listeChoisirElement.getSelectedValue() != null) {
                    jButton2.setEnabled(true);
                } else {
                    jButton2.setEnabled(false);
                }
            }
        });
        JButton jButton3 = new JButton(new AbstractAction(Strings.get("bouton.Annuler")){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        jPanel2.add(jButton3);
        jDialog.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        jDialog.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        jDialog.setVisible(true);
    }

    private void ajouterSousEnsemble() {
        final JDialog jDialog = new JDialog(this, Strings.get("titre.ChoisirEnsemble"), true);
        jDialog.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel(new BorderLayout());
        jDialog.add(jPanel);
        this.listeChoisirEnsemble.setSelectionMode(0);
        this.listeChoisirEnsemble.clearSelection();
        JScrollPane jScrollPane = new JScrollPane(this.listeChoisirEnsemble);
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.setPreferredSize(new Dimension(220, 200));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.add((Component)jPanel2, "South");
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Nouveau")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurSchemaSimple.this.nouvelEnsemble(false);
            }
        });
        jPanel2.add(jButton);
        final JButton jButton2 = new JButton(new AbstractAction(Strings.get("bouton.OK")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EditeurSchemaSimple.this.listeChoisirEnsemble.getSelectedValue() instanceof EnsembleSS) {
                    EnsembleSS ensembleSS = (EnsembleSS)EditeurSchemaSimple.this.listeChoisirEnsemble.getSelectedValue();
                    if (EditeurSchemaSimple.this.monElementSS != null && EditeurSchemaSimple.this.monEnsembleSS == null) {
                        if (EditeurSchemaSimple.this.modeleListeSousEnsembles.contains(ensembleSS)) {
                            JOptionPane.showMessageDialog(jDialog, Strings.get("message.SousEnsembleExiste"));
                        } else {
                            EditeurSchemaSimple.this.monElementSS.ajouterSousEnsemble(ensembleSS);
                            jDialog.setVisible(false);
                        }
                        EditeurSchemaSimple.this.sousEnsembles = null;
                        EditeurSchemaSimple.this.sousEnsembles = EditeurSchemaSimple.this.monElementSS.getSousEnsembles();
                    }
                    if (EditeurSchemaSimple.this.monEnsembleSS != null && EditeurSchemaSimple.this.monElementSS == null) {
                        if (EditeurSchemaSimple.this.modeleListeSousEnsembles.contains(ensembleSS)) {
                            JOptionPane.showMessageDialog(jDialog, Strings.get("message.SousEnsembleExiste"));
                        } else {
                            EditeurSchemaSimple.this.monEnsembleSS.ajouterSousEnsemble(ensembleSS);
                            jDialog.setVisible(false);
                        }
                        EditeurSchemaSimple.this.sousEnsembles = null;
                        EditeurSchemaSimple.this.sousEnsembles = EditeurSchemaSimple.this.monEnsembleSS.getSousEnsembles();
                    }
                    if (EditeurSchemaSimple.this.sousEnsembles != null && EditeurSchemaSimple.this.sousEnsembles.size() > 0) {
                        EditeurSchemaSimple.this.modeleListeSousEnsembles.clear();
                        for (int i = 0; i < EditeurSchemaSimple.this.sousEnsembles.size(); ++i) {
                            EditeurSchemaSimple.this.modeleListeSousEnsembles.addElement(EditeurSchemaSimple.this.sousEnsembles.get(i));
                        }
                        EditeurSchemaSimple.this.nbSousEnsembles = EditeurSchemaSimple.this.sousEnsembles.size();
                        EditeurSchemaSimple.this.reconstruireOnglets();
                        EditeurSchemaSimple.this.onglets.setSelectedComponent(EditeurSchemaSimple.this.panelListeSousEnsembles);
                    }
                    EditeurFichierConfig.setModif(true);
                }
            }
        });
        jPanel2.add(jButton2);
        jButton2.setEnabled(false);
        this.listeChoisirEnsemble.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (EditeurSchemaSimple.this.listeChoisirEnsemble.getSelectedValue() != null) {
                    jButton2.setEnabled(true);
                } else {
                    jButton2.setEnabled(false);
                }
            }
        });
        JButton jButton3 = new JButton(new AbstractAction(Strings.get("bouton.Annuler")){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        jPanel2.add(jButton3);
        jDialog.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        jDialog.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        jDialog.setVisible(true);
    }

    private void supprimerSousElement() {
        if (this.listeSousElements.getSelectedValue() != null && this.listeSousElements.getSelectedValue() instanceof ElementSS) {
            ElementSS elementSS = (ElementSS)this.listeSousElements.getSelectedValue();
            if (this.monElementSS != null && this.monEnsembleSS == null) {
                this.monElementSS.supprimerSousElement(elementSS);
                elementSS.supprimerParent(this.monElementSS);
                this.sousElements = null;
                this.sousElements = this.monElementSS.getSousElements();
            }
            if (this.monEnsembleSS != null && this.monElementSS == null) {
                this.monEnsembleSS.supprimerSousElement(elementSS);
                this.sousElements = null;
                this.sousElements = this.monEnsembleSS.getSousElements();
            }
            if (this.sousElements != null) {
                this.modeleListeSousElements.clear();
                for (int i = 0; i < this.sousElements.size(); ++i) {
                    this.modeleListeSousElements.addElement(this.sousElements.get(i));
                }
                this.nbSousElements = this.sousElements.size();
                this.reconstruireOnglets();
            }
            EditeurFichierConfig.setModif(true);
        }
    }

    private void supprimerSousEnsemble() {
        if (this.listeSousEnsembles.getSelectedValue() != null && this.listeSousEnsembles.getSelectedValue() instanceof EnsembleSS) {
            EnsembleSS ensembleSS = (EnsembleSS)this.listeSousEnsembles.getSelectedValue();
            if (this.monElementSS != null && this.monEnsembleSS == null) {
                this.monElementSS.supprimerSousEnsemble(ensembleSS);
                this.sousEnsembles = null;
                this.sousEnsembles = this.monElementSS.getSousEnsembles();
            }
            if (this.monEnsembleSS != null && this.monElementSS == null) {
                this.monEnsembleSS.supprimerSousEnsemble(ensembleSS);
                this.sousEnsembles = null;
                this.sousEnsembles = this.monEnsembleSS.getSousEnsembles();
            }
            if (this.sousEnsembles != null) {
                this.modeleListeSousEnsembles.clear();
                for (int i = 0; i < this.sousEnsembles.size(); ++i) {
                    this.modeleListeSousEnsembles.addElement(this.sousEnsembles.get(i));
                }
                this.nbSousEnsembles = this.sousEnsembles.size();
                this.reconstruireOnglets();
                this.onglets.setSelectedComponent(this.panelListeSousEnsembles);
            }
            EditeurFichierConfig.setModif(true);
        }
    }

    private void reconstruireOnglets() {
        this.onglets.removeAll();
        this.onglets.addTab(Strings.get("label.SousElements") + " (" + this.nbSousElements + ")", this.panelListeSousElements);
        this.onglets.addTab(Strings.get("label.SousEnsembles") + " (" + this.nbSousEnsembles + ")", this.panelListeSousEnsembles);
        this.onglets.addTab(Strings.get("label.Parents") + " (" + this.nbParents + ")", this.panelListeParents);
    }

    private void activerComposant(JComponent jComponent, boolean bl) {
        jComponent.setEnabled(bl);
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (!(component instanceof JComponent)) continue;
            this.activerComposant((JComponent)component, bl);
        }
    }

    private void ecouteurNomElement(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            if (!this.verifCaractere(string)) {
                JOptionPane.showMessageDialog(this, Strings.get("message.CaractereInterdit"));
            } else {
                this.majElements(string, false);
                this.monElementSS.setNom(string);
                this.listeElements.repaint();
                this.listeSousElements.repaint();
                this.listeParents.repaint();
                EditeurFichierConfig.setModif(true);
            }
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private void majElements(String string, boolean bl) {
        Element element;
        Node node;
        Element element2 = Outils.premierEnfantDeNom(this.racine, "LANGAGE");
        if (element2 != null) {
            for (node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element) || !"RACINE".equals((element = (Element)node).getNodeName()) || !element.getAttribute("element").equals(this.monElementSS.getNom())) continue;
                if (string != null && !bl) {
                    element.setAttribute("element", string);
                }
                if (!bl || string != null) continue;
                element.getParentNode().removeChild(element);
            }
        }
        if ((node = Outils.premierEnfantDeNom(this.racine, "MENUS")) != null) {
            this.domMenus(node, string, bl);
        }
        if ((element = Outils.premierEnfantDeNom(this.racine, "AFFICHAGE_NOEUDS")) != null) {
            for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                Element element3;
                if (!(node2 instanceof Element) || !"AFFICHAGE_ELEMENT".equals((element3 = (Element)node2).getNodeName()) || !element3.getAttribute("element").equals(this.monElementSS.getNom())) continue;
                if (string != null && !bl) {
                    element3.setAttribute("element", string);
                }
                if (!bl || string != null) continue;
                element3.getParentNode().removeChild(element3);
            }
        }
        EditeurFichierConfig.setModif(true);
    }

    private void domMenus(Node node, String string, boolean bl) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!"MENU".equals(node2.getNodeName())) continue;
            this.domMenus(node2, string, bl);
            for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                Element element;
                if (!(node3 instanceof Element) || !"MENU_INSERTION".equals((element = (Element)node3).getNodeName()) || !element.getAttribute("nom").equals(this.monElementSS.getNom())) continue;
                if (string != null && !bl) {
                    element.setAttribute("nom", string);
                }
                if (!bl || string != null) continue;
                element.getParentNode().removeChild(element);
            }
        }
    }

    private void ecouteurNomAttribut(DocumentEvent documentEvent, AttributSS attributSS) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            if (!this.verifCaractere(string)) {
                JOptionPane.showMessageDialog(this, Strings.get("message.CaractereInterdit"));
            } else {
                attributSS.setNom(string);
                EditeurFichierConfig.setModif(true);
            }
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private void ecouteurValeurAttribut(DocumentEvent documentEvent, AttributSS attributSS, int n) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            attributSS.setValeur(string, n);
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private void ecouteurNomEnsemble(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            if (!this.verifCaractere(string)) {
                JOptionPane.showMessageDialog(this, Strings.get("message.CaractereInterdit"));
            } else {
                this.monEnsembleSS.setNom(string);
                this.listeEnsembles.repaint();
                this.listeSousEnsembles.repaint();
                EditeurFichierConfig.setModif(true);
            }
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private void recupererAttributs() {
        this.listePanelAttribut.removeAll();
        if (this.monElementSS != null) {
            this.attributs = null;
            this.attributs = this.monElementSS.getAttributs();
            if (this.attributs != null && this.attributs.size() > 0) {
                for (int i = 0; i < this.attributs.size(); ++i) {
                    this.creerPanelAttribut(this.attributs.get(i), i);
                }
            } else {
                this.creerPanelAttribut(this.enregistrerAttribut(0, ""), 0);
            }
        }
    }

    private AttributSS enregistrerAttribut(int n, String string) {
        AttributSS attributSS = this.trouverAttribut(n);
        if (attributSS == null) {
            attributSS = new AttributSS();
            this.monElementSS.ajouterAttribut(attributSS);
        }
        attributSS.setNom(string);
        EditeurFichierConfig.setModif(true);
        return attributSS;
    }

    private AttributSS trouverAttribut(int n) {
        if (n == -1) {
            return null;
        }
        if (this.monElementSS == null) {
            return null;
        }
        int n2 = 0;
        this.attributs = null;
        this.attributs = this.monElementSS.getAttributs();
        for (int i = 0; i < this.attributs.size(); ++i) {
            if (n2 == n) {
                return this.attributs.get(i);
            }
            ++n2;
        }
        return null;
    }

    private void recupererValeurs(AttributSS attributSS, JPanel jPanel, JPanel jPanel2) {
        jPanel2.removeAll();
        if (attributSS != null) {
            this.valeurs = null;
            this.valeurs = attributSS.getValeurs();
            if (this.valeurs != null && this.valeurs.size() > 0) {
                for (int i = 0; i < this.valeurs.size(); ++i) {
                    this.creerPanelValeur(attributSS, this.valeurs.get(i), i, jPanel, jPanel2);
                }
            } else {
                this.creerPanelValeur(attributSS, this.enregistrerValeurAttribut(attributSS, 0, ""), 0, jPanel, jPanel2);
            }
        }
    }

    private String enregistrerValeurAttribut(AttributSS attributSS, int n, String string) {
        String string2 = this.trouverValeur(attributSS, n);
        if (string2 == null) {
            attributSS.ajouterValeur(string);
        }
        attributSS.setValeur(string, n);
        EditeurFichierConfig.setModif(true);
        return string;
    }

    private String trouverValeur(AttributSS attributSS, int n) {
        if (n == -1) {
            return null;
        }
        if (attributSS == null) {
            return null;
        }
        int n2 = 0;
        this.valeurs = null;
        this.valeurs = attributSS.getValeurs();
        for (int i = 0; i < this.valeurs.size(); ++i) {
            if (n2 == n) {
                return this.valeurs.get(i);
            }
            ++n2;
        }
        return null;
    }

    private void trierListe(DefaultListModel defaultListModel) {
        Object[] objectArray = defaultListModel.toArray();
        Arrays.sort(objectArray);
        defaultListModel.removeAllElements();
        for (int i = 0; i < objectArray.length; ++i) {
            defaultListModel.addElement(objectArray[i]);
        }
    }

    private void ClasseVersDOM() {
        Object object;
        ArrayList<EnsembleSS> arrayList;
        ArrayList<ElementSS> arrayList2;
        Element element;
        Comparable comparable;
        int n;
        this.langage = Outils.premierEnfantDeNom(this.racine, "LANGAGE");
        if (this.langage != null) {
            this.schema_simple = Outils.premierEnfantDeNom(this.langage, "SCHEMA_SIMPLE");
            if (this.schema_simple != null) {
                this.langage.removeChild(this.schema_simple);
            }
        } else {
            this.langage = this.doc.createElement("LANGAGE");
            this.racine.insertBefore(this.langage, Outils.premierEnfantDeNom(this.racine, "STRINGS"));
        }
        this.schema_simple = this.doc.createElement("SCHEMA_SIMPLE");
        Element element2 = Outils.premierEnfantDeNom(this.langage, "RACINE");
        if (element2 != null) {
            this.langage.insertBefore(this.schema_simple, element2);
        } else {
            this.langage.appendChild(this.schema_simple);
        }
        if (this.modeleListeElements != null && this.modeleListeElements.getSize() > 0) {
            for (n = 0; n < this.modeleListeElements.getSize(); ++n) {
                Object object2;
                Object object3;
                comparable = (ElementSS)this.modeleListeElements.get(n);
                element = this.doc.createElement("ELEMENT");
                this.schema_simple.appendChild(element);
                element.setAttribute("nom", ((ElementSS)comparable).getNom());
                element.setAttribute("texte", ((ElementSS)comparable).getTexte());
                arrayList2 = ((ElementSS)comparable).getSousElements();
                if (arrayList2 != null && arrayList2.size() > 0) {
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        object3 = arrayList2.get(i);
                        object2 = this.doc.createElement("SOUS-ELEMENT");
                        element.appendChild((Node)object2);
                        object2.setAttribute("element", ((ElementSS)object3).getNom());
                    }
                }
                if ((arrayList = ((ElementSS)comparable).getSousEnsembles()) != null && arrayList.size() > 0) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        object2 = arrayList.get(i);
                        object = this.doc.createElement("SOUS-ENSEMBLE");
                        element.appendChild((Node)object);
                        object.setAttribute("ensemble", ((EnsembleSS)object2).getNom());
                    }
                }
                if ((object3 = ((ElementSS)comparable).getAttributs()) == null || ((ArrayList)object3).size() <= 0) continue;
                for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                    object = (AttributSS)((ArrayList)object3).get(i);
                    if ("".equals(((AttributSS)object).getNom())) continue;
                    Element element3 = this.doc.createElement("ATTRIBUT");
                    element.appendChild(element3);
                    element3.setAttribute("nom", ((AttributSS)object).getNom());
                    element3.setAttribute("presence", ((AttributSS)object).getPresence());
                    ArrayList<String> arrayList3 = ((AttributSS)object).getValeurs();
                    if (arrayList3 == null || arrayList3.size() <= 0) continue;
                    for (int j = 0; j < arrayList3.size(); ++j) {
                        String string = arrayList3.get(j);
                        if ("".equals(string)) continue;
                        Element element4 = this.doc.createElement("VALEUR");
                        element3.appendChild(element4);
                        Outils.setValeurElement(this.doc, element4, string);
                    }
                }
            }
        }
        if (this.modeleListeEnsembles != null && this.modeleListeEnsembles.getSize() > 0) {
            for (n = 0; n < this.modeleListeEnsembles.getSize(); ++n) {
                Object object4;
                comparable = (EnsembleSS)this.modeleListeEnsembles.get(n);
                element = this.doc.createElement("ENSEMBLE");
                this.schema_simple.appendChild(element);
                element.setAttribute("nom", ((EnsembleSS)comparable).getNom());
                arrayList2 = ((EnsembleSS)comparable).getSousElements();
                if (arrayList2 != null && arrayList2.size() > 0) {
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        ElementSS elementSS = arrayList2.get(i);
                        object4 = this.doc.createElement("SOUS-ELEMENT");
                        element.appendChild((Node)object4);
                        object4.setAttribute("element", elementSS.getNom());
                    }
                }
                if ((arrayList = ((EnsembleSS)comparable).getSousEnsembles()) == null || arrayList.size() <= 0) continue;
                for (int i = 0; i < arrayList.size(); ++i) {
                    object4 = arrayList.get(i);
                    object = this.doc.createElement("SOUS-ENSEMBLE");
                    element.appendChild((Node)object);
                    object.setAttribute("ensemble", ((EnsembleSS)object4).getNom());
                }
            }
        }
    }

    private void DOMVersClasse() {
        Object object;
        Object object2;
        this.modeleListeElements.clear();
        this.modeleChoisirElement.clear();
        this.modeleListeEnsembles.clear();
        this.modeleChoisirEnsemble.clear();
        NodeList nodeList = this.schema_simple.getElementsByTagName("ELEMENT");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element = (Element)nodeList.item(i);
            object2 = new ElementSS(element.getAttribute("nom"));
            ((ElementSS)object2).setTexte(element.getAttribute("texte"));
            this.modeleListeElements.addElement(object2);
            this.modeleChoisirElement.addElement(object2);
            this.trierListe(this.modeleListeElements);
            this.trierListe(this.modeleChoisirElement);
        }
        NodeList nodeList2 = this.schema_simple.getElementsByTagName("ENSEMBLE");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            if (!(nodeList2.item(i) instanceof Element)) continue;
            object2 = (Element)nodeList2.item(i);
            object = new EnsembleSS(object2.getAttribute("nom"));
            this.modeleListeEnsembles.addElement(object);
            this.modeleChoisirEnsemble.addElement(object);
            this.trierListe(this.modeleListeEnsembles);
            this.trierListe(this.modeleChoisirEnsemble);
        }
        for (Node node = this.schema_simple.getFirstChild(); node != null; node = node.getNextSibling()) {
            Comparable comparable;
            if ("ELEMENT".equals(node.getNodeName()) && (object2 = this.chercherElement(((Element)node).getAttribute("nom"), this.modeleListeElements)) != null) {
                for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                    if ("SOUS-ELEMENT".equals(object.getNodeName())) {
                        comparable = this.chercherElement(((Element)object).getAttribute("element"), this.modeleListeElements);
                        ((ElementSS)object2).ajouterSousElement((ElementSS)comparable);
                        ((ElementSS)comparable).ajouterParent((ElementSS)object2);
                    }
                    if ("SOUS-ENSEMBLE".equals(object.getNodeName())) {
                        comparable = this.chercherEnsemble(((Element)object).getAttribute("ensemble"), this.modeleListeEnsembles);
                        ((ElementSS)object2).ajouterSousEnsemble((EnsembleSS)comparable);
                    }
                    if (!"ATTRIBUT".equals(object.getNodeName())) continue;
                    comparable = new AttributSS();
                    ((AttributSS)comparable).setNom(((Element)object).getAttribute("nom"));
                    ((AttributSS)comparable).setPresence(((Element)object).getAttribute("presence"));
                    ((ElementSS)object2).ajouterAttribut((AttributSS)comparable);
                    for (Node node2 = object.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        if (!"VALEUR".equals(node2.getNodeName())) continue;
                        ((AttributSS)comparable).ajouterValeur(Outils.getValeurElement((Element)node2));
                    }
                }
            }
            if (!"ENSEMBLE".equals(node.getNodeName())) continue;
            object2 = this.chercherEnsemble(((Element)node).getAttribute("nom"), this.modeleListeEnsembles);
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                if ("SOUS-ELEMENT".equals(object.getNodeName())) {
                    comparable = this.chercherElement(((Element)object).getAttribute("element"), this.modeleListeElements);
                    ((EnsembleSS)object2).ajouterSousElement((ElementSS)comparable);
                }
                if (!"SOUS-ENSEMBLE".equals(object.getNodeName())) continue;
                comparable = this.chercherEnsemble(((Element)object).getAttribute("ensemble"), this.modeleListeEnsembles);
                ((EnsembleSS)object2).ajouterSousEnsemble((EnsembleSS)comparable);
            }
        }
    }

    private ElementSS chercherElement(String string, DefaultListModel defaultListModel) {
        ElementSS elementSS = null;
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            if (string.equals(defaultListModel.get(i).toString())) {
                elementSS = (ElementSS)defaultListModel.get(i);
                break;
            }
            elementSS = null;
        }
        return elementSS;
    }

    private EnsembleSS chercherEnsemble(String string, DefaultListModel defaultListModel) {
        EnsembleSS ensembleSS = null;
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            if (string.equals(defaultListModel.get(i).toString())) {
                ensembleSS = (EnsembleSS)defaultListModel.get(i);
                break;
            }
            ensembleSS = null;
        }
        return ensembleSS;
    }

    private boolean verifCaractere(String string) {
        String string2 = "^[A-Za-z_][-_.A-Za-z0-9]*$";
        boolean bl = false;
        if (!"".equals(string)) {
            if (string.matches(string2)) {
                bl = true;
            }
            return bl;
        }
        return bl;
    }
}

