/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.ChoixDuSchema;
import editeurconfig.EditeurFichierConfig;
import editeurconfig.FenetrePrincipale;
import editeurconfig.ListeElements;
import editeurconfig.Outils;
import editeurconfig.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ChoixRacine
extends JDialog {
    private EditeurFichierConfig appl;
    private boolean nouveau;
    private Object racinePossibleSelectionne = null;
    private Object racineSelectionne = null;
    private Document doc;
    private Element racine;
    private Element langage;
    private ListeElements listeElements;
    private JList listeRP;
    private JList listeR;
    private DefaultListModel listeModeleRacinesP;
    private DefaultListModel listeModeleRacines;
    private JButton boutonAjouter;
    private JButton boutonRetirer;

    public ChoixRacine(EditeurFichierConfig editeurFichierConfig, boolean bl, Document document, Element element, ListeElements listeElements) {
        super((Frame)new JFrame(), Strings.get("titre.ChoixRacines"));
        this.setModal(true);
        this.appl = editeurFichierConfig;
        this.nouveau = bl;
        this.doc = document;
        this.racine = element;
        this.listeElements = listeElements;
        this.langage = Outils.premierEnfantDeNom(element, "LANGAGE");
        listeElements.JListeElementsRacinesP(false);
        this.listeModeleRacinesP = listeElements.getListModelRP();
        this.listeRP = new JList();
        this.listeRP.setSelectionMode(0);
        this.listeR = new JList();
        this.listeR.setSelectionMode(0);
        this.retirerRacinesExistantes();
        this.setDefaultCloseOperation(0);
        this.afficher();
    }

    public void afficher() {
        this.creerPanelListes();
        this.listeRP.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ChoixRacine.this.racinePossibleSelectionne = ChoixRacine.this.listeRP.getSelectedValue();
                if (ChoixRacine.this.racinePossibleSelectionne != null) {
                    ChoixRacine.this.listeR.clearSelection();
                    ChoixRacine.this.boutonAjouter.setEnabled(true);
                    ChoixRacine.this.boutonRetirer.setEnabled(false);
                } else {
                    ChoixRacine.this.boutonAjouter.setEnabled(false);
                    ChoixRacine.this.boutonRetirer.setEnabled(false);
                }
            }
        });
        this.listeR.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ChoixRacine.this.racineSelectionne = ChoixRacine.this.listeR.getSelectedValue();
                if (ChoixRacine.this.racineSelectionne != null) {
                    ChoixRacine.this.listeRP.clearSelection();
                    ChoixRacine.this.boutonAjouter.setEnabled(false);
                    ChoixRacine.this.boutonRetirer.setEnabled(true);
                } else {
                    ChoixRacine.this.boutonAjouter.setEnabled(false);
                    ChoixRacine.this.boutonRetirer.setEnabled(false);
                }
            }
        });
        this.creerPanelBoutonsBas();
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setVisible(true);
    }

    private void creerPanelListes() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout());
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add(jPanel2);
        JLabel jLabel = new JLabel(Strings.get("label.ElementsRacinesPossibles"));
        jPanel2.add((Component)jLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.listeRP);
        jScrollPane.setPreferredSize(new Dimension(200, 300));
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel.add(jPanel3);
        this.boutonAjouter = new JButton(new AbstractAction(Strings.get("bouton.Ajouter") + " ->"){

            public void actionPerformed(ActionEvent actionEvent) {
                ChoixRacine.this.ajouter();
            }
        });
        this.boutonAjouter.setEnabled(false);
        jPanel3.add(this.boutonAjouter);
        jPanel3.add(Box.createVerticalStrut(10));
        this.boutonRetirer = new JButton(new AbstractAction("<- " + Strings.get("bouton.Retirer")){

            public void actionPerformed(ActionEvent actionEvent) {
                ChoixRacine.this.retirer();
            }
        });
        this.boutonRetirer.setEnabled(false);
        jPanel3.add(this.boutonRetirer);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel.add(jPanel4);
        JLabel jLabel2 = new JLabel(Strings.get("label.RacinesSelectionnees"));
        jPanel4.add((Component)jLabel2, "North");
        JScrollPane jScrollPane2 = new JScrollPane(this.listeR);
        jScrollPane2.setPreferredSize(new Dimension(200, 300));
        jPanel4.add((Component)jScrollPane2, "Center");
    }

    private void creerPanelBoutonsBas() {
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        if (this.nouveau) {
            JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Annuler")){

                public void actionPerformed(ActionEvent actionEvent) {
                    ChoixRacine.this.setVisible(false);
                    new ChoixDuSchema(ChoixRacine.this.appl, ChoixRacine.this.doc, ChoixRacine.this.racine);
                }
            });
            jPanel.add(jButton);
            JButton jButton2 = new JButton(new AbstractAction(Strings.get("bouton.OK")){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ChoixRacine.this.listeModeleRacines.getSize() == 0) {
                        JOptionPane.showMessageDialog(ChoixRacine.this, Strings.get("message.AuMoinsUneRacine"), Strings.get("titre.Message"), 0);
                    } else {
                        ChoixRacine.this.setVisible(false);
                        new FenetrePrincipale(ChoixRacine.this.appl, null, ChoixRacine.this.doc, ChoixRacine.this.racine, ChoixRacine.this.listeElements);
                    }
                }
            });
            jPanel.add(jButton2);
        } else {
            JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Fermer")){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ChoixRacine.this.listeModeleRacines.getSize() == 0) {
                        JOptionPane.showMessageDialog(ChoixRacine.this, Strings.get("message.AuMoinsUneRacine"), Strings.get("titre.Message"), 0);
                    } else {
                        ChoixRacine.this.setVisible(false);
                    }
                }
            });
            jPanel.add(jButton);
        }
    }

    private void retirerRacinesExistantes() {
        DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < this.listeModeleRacinesP.getSize(); ++i) {
            defaultListModel.addElement(this.listeModeleRacinesP.get(i));
        }
        this.listeModeleRacines = new DefaultListModel();
        for (Node node = this.langage.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !"RACINE".equals(node.getNodeName())) continue;
            String string = ((Element)node).getAttribute("element");
            for (int i = 0; i < defaultListModel.getSize(); ++i) {
                if (!string.equals(defaultListModel.get(i))) continue;
                defaultListModel.removeElement(defaultListModel.get(i));
                this.listeModeleRacines.addElement(string);
            }
        }
        this.listeModeleRacinesP = defaultListModel;
        this.listeRP.setModel(this.listeModeleRacinesP);
        this.trierListe(this.listeModeleRacines);
        this.listeR.setModel(this.listeModeleRacines);
    }

    private void trierListe(DefaultListModel defaultListModel) {
        Object[] objectArray = defaultListModel.toArray();
        Arrays.sort(objectArray);
        defaultListModel.removeAllElements();
        for (int i = 0; i < objectArray.length; ++i) {
            defaultListModel.addElement(objectArray[i]);
        }
    }

    private void ajouter() {
        if (this.racinePossibleSelectionne != null) {
            int n = this.listeRP.getSelectedIndex();
            this.listeModeleRacines.addElement(this.racinePossibleSelectionne);
            this.enregistrerElementRacine(this.racinePossibleSelectionne);
            this.listeModeleRacinesP.removeElement(this.racinePossibleSelectionne);
            this.trierListe(this.listeModeleRacines);
            if (n != -1) {
                this.listeRP.setSelectedIndex(n);
            }
            EditeurFichierConfig.setModif(true);
        }
    }

    private void retirer() {
        Element element;
        if (this.racineSelectionne != null && (element = Outils.getElementSelectionne(this.langage, "RACINE", this.racineSelectionne.toString(), "element")) != null) {
            int n = this.listeR.getSelectedIndex();
            this.langage.removeChild(element);
            this.listeModeleRacinesP.addElement(this.racineSelectionne);
            this.listeModeleRacines.removeElement(this.racineSelectionne);
            this.trierListe(this.listeModeleRacinesP);
            if (n != -1) {
                this.listeR.setSelectedIndex(n);
            } else {
                this.listeR.setSelectedIndex(0);
            }
            EditeurFichierConfig.setModif(true);
        }
    }

    private void enregistrerElementRacine(Object object) {
        Element element = Outils.getElementSelectionne(this.langage, "RACINE", object.toString(), "element");
        if (element == null) {
            element = this.doc.createElement("RACINE");
            element.setAttribute("element", object.toString());
            this.langage.appendChild(element);
            EditeurFichierConfig.setModif(true);
        }
    }
}

