/*
 * Decompiled with CFR 0.152.
 */
package jaxe.equations.element;

import java.awt.Graphics;
import jaxe.equations.element.MathElement;
import jaxe.equations.element.MathTableData;

public class MathTable
extends MathElement {
    public static final String ELEMENT = "mtable";

    @Override
    public void paint(Graphics graphics, int n, int n2) {
        int n3;
        int[] nArray = new int[this.getMathElementCount()];
        int[] nArray2 = new int[this.getMathElementCount()];
        for (n3 = 0; n3 < this.getMathElementCount(); ++n3) {
            nArray[n3] = this.getMaxRowAscentHeight(n3);
            nArray2[n3] = this.getMaxRowDescentHeight(n3);
        }
        int n4 = this.getMaxColumnCount();
        int[] nArray3 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray3[n3] = this.getMaxColumnWidth(n3);
        }
        int n5 = n;
        int n6 = -this.getHeight(true) / 2 + nArray[0] - this.getMiddleShift();
        int n7 = n5;
        int n8 = n6;
        for (n3 = 0; n3 < this.getMathElementCount(); ++n3) {
            MathElement mathElement = this.getMathElement(n3);
            n7 = n5;
            for (int i = 0; i < n4 && i < mathElement.getMathElementCount(); ++i) {
                MathTableData mathTableData = (MathTableData)mathElement.getMathElement(i);
                if ("left".equals(mathTableData.getColumnAlign())) {
                    mathTableData.paint(graphics, n7 + 1, n2 + n8);
                } else if ("right".equals(mathTableData.getColumnAlign())) {
                    mathTableData.paint(graphics, n7 + nArray3[i] - mathTableData.getWidth(true), n2 + n8);
                } else {
                    mathTableData.paint(graphics, n7 + nArray3[i] / 2 - mathTableData.getWidth(true) / 2, n2 + n8);
                }
                n7 += nArray3[i];
            }
            n8 += nArray2[n3];
            if (n3 >= this.getMathElementCount() - 1) continue;
            n8 += nArray[n3 + 1];
        }
    }

    private int getMaxRowAscentHeight(int n) {
        if (n >= this.getMathElementCount()) {
            return 0;
        }
        MathElement mathElement = this.getMathElement(n);
        int n2 = 0;
        for (int i = 0; i < mathElement.getMathElementCount(); ++i) {
            n2 = Math.max(n2, mathElement.getMathElement(i).getAscentHeight(true));
        }
        return n2;
    }

    private int getMaxRowDescentHeight(int n) {
        if (n >= this.getMathElementCount()) {
            return 0;
        }
        MathElement mathElement = this.getMathElement(n);
        int n2 = 0;
        for (int i = 0; i < mathElement.getMathElementCount(); ++i) {
            n2 = Math.max(n2, mathElement.getMathElement(i).getDescentHeight(true));
        }
        return n2;
    }

    private int getMaxColumnWidth(int n) {
        int n2 = 0;
        for (int i = 0; i < this.getMathElementCount(); ++i) {
            MathElement mathElement = this.getMathElement(i);
            if (n >= mathElement.getMathElementCount()) continue;
            n2 = Math.max(n2, mathElement.getMathElement(n).getWidth(true));
        }
        return n2 + 2;
    }

    private int getMaxColumnCount() {
        int n = 0;
        for (int i = 0; i < this.getMathElementCount(); ++i) {
            MathElement mathElement = this.getMathElement(i);
            n = Math.max(n, mathElement.getMathElementCount());
        }
        return n;
    }

    @Override
    public int getWidth(boolean bl) {
        int n = 0;
        int n2 = this.getMaxColumnCount();
        for (int i = 0; i < n2; ++i) {
            n += this.getMaxColumnWidth(i);
        }
        return n;
    }

    @Override
    public int getHeight(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.getMathElementCount(); ++i) {
            n += this.getMaxRowAscentHeight(i) + this.getMaxRowDescentHeight(i);
        }
        return n;
    }

    @Override
    public int getAscentHeight(boolean bl) {
        return this.getHeight(true) / 2 + this.getMiddleShift();
    }

    @Override
    public int getDescentHeight(boolean bl) {
        return this.getHeight(true) / 2 - this.getMiddleShift();
    }
}

