/*
 * Decompiled with CFR 0.152.
 */
package jaxe.elements;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.text.Position;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import jaxe.elements.JEFichier;
import jaxe.equations.DialogueEquation;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JEEquation
extends JEFichier {
    private static final Logger LOG = Logger.getLogger(JEEquation.class);
    public static final String defTexteAtt = "texte";

    public JEEquation(JaxeDocument jaxeDocument) {
        super(jaxeDocument);
        this.alignementY = 0.7f;
    }

    @Override
    public void init(Position position, Node node) {
        Object object;
        Element element = (Element)node;
        this.srcAttr = this.doc.cfg.valeurParametreElement(this.refElement, "srcAtt", "nom");
        String string = element.getAttribute(this.srcAttr);
        File file = this.doc.fsave == null ? new File(string) : new File(this.doc.fsave.getParent() + File.separatorChar + string);
        if (file.exists()) {
            object = node.getNamespaceURI() == null ? this.doc.DOMdoc.getElementsByTagName(node.getNodeName()) : this.doc.DOMdoc.getElementsByTagNameNS(node.getNamespaceURI(), node.getLocalName());
            for (int i = 0; i < object.getLength(); ++i) {
                if (object.item(i) == node || !string.equals(((Element)object.item(i)).getAttribute(this.srcAttr))) continue;
                file = null;
                break;
            }
        }
        if (file == null || !file.exists()) {
            object = this.doc.cfg.valeurParametreElement(this.refElement, "texteAtt", defTexteAtt);
            String string2 = element.getAttribute((String)object);
            BufferedImage bufferedImage = DialogueEquation.creerImage(string2);
            String string3 = file == null ? this.enregistrerImage(bufferedImage, null) : this.enregistrerImage(bufferedImage, file.getPath());
            element.setAttributeNS(this.doc.cfg.espaceAttribut(this.srcAttr), this.srcAttr, string3);
            this.doc.setModif(true);
        }
        super.init(position, node);
    }

    @Override
    protected void affichageLabel() {
        super.affichageLabel();
        Icon icon = this.label.getIcon();
        if (icon != null) {
            int n = icon.getIconHeight();
            this.alignementY = (float)(((double)n / 2.0 + 4.0) / (double)n);
            this.label.setAlignmentY(this.alignementY);
        }
    }

    @Override
    public Node nouvelElement(Element element) {
        if (this.doc.fsave == null) {
            JOptionPane.showMessageDialog(this.doc.jframe, JaxeResourceBundle.getRB().getString("equation.SauverAvant"), JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
            return null;
        }
        this.srcAttr = this.doc.cfg.valeurParametreElement(element, "srcAtt", "nom");
        String string = this.doc.cfg.valeurParametreElement(element, "texteAtt", defTexteAtt);
        String string2 = this.doc.cfg.valeurParametreElement(element, "labelAtt", null);
        Element element2 = JEEquation.nouvelElementDOM(this.doc, element);
        if (element2 == null) {
            return null;
        }
        DialogueEquation dialogueEquation = new DialogueEquation(this.doc, "", string2, null);
        if (!dialogueEquation.afficher()) {
            return null;
        }
        String string3 = dialogueEquation.getTexte();
        String string4 = this.enregistrerImage(DialogueEquation.creerImage(string3), null);
        String string5 = dialogueEquation.getLabel();
        try {
            element2.setAttributeNS(this.doc.cfg.espaceAttribut(string), string, string3);
            element2.setAttributeNS(this.doc.cfg.espaceAttribut(this.srcAttr), this.srcAttr, string4);
            if (string2 != null && string5 != null && !"".equals(string5)) {
                element2.setAttributeNS(this.doc.cfg.espaceAttribut(string2), string2, string5);
            }
        }
        catch (DOMException dOMException) {
            LOG.error("nouvelElement(Element) - DOMException", dOMException);
            return null;
        }
        return element2;
    }

    @Override
    public void afficherDialogue(JFrame jFrame) {
        Element element = (Element)this.noeud;
        String string = this.doc.cfg.valeurParametreElement(this.refElement, "texteAtt", defTexteAtt);
        String string2 = this.doc.cfg.valeurParametreElement(this.refElement, "labelAtt", null);
        String string3 = element.getAttribute(string);
        String string4 = element.getAttribute(this.srcAttr);
        String string5 = string2 != null ? element.getAttribute(string2) : null;
        DialogueEquation dialogueEquation = new DialogueEquation(this.doc, string3, string2, string5);
        if (!dialogueEquation.afficher()) {
            return;
        }
        string3 = dialogueEquation.getTexte();
        string4 = this.enregistrerImage(DialogueEquation.creerImage(string3), string4);
        String string6 = dialogueEquation.getLabel();
        try {
            element.setAttributeNS(this.doc.cfg.espaceAttribut(string), string, string3);
            element.setAttributeNS(this.doc.cfg.espaceAttribut(this.srcAttr), this.srcAttr, string4);
            if (string2 != null) {
                if (string5 != null && "".equals(string6)) {
                    element.removeAttribute(string2);
                } else {
                    element.setAttributeNS(this.doc.cfg.espaceAttribut(string2), string2, string6);
                }
            }
        }
        catch (DOMException dOMException) {
            LOG.error("afficherDialogue(JFrame) - DOMException", dOMException);
            return;
        }
        this.doc.setModif(true);
        this.majAffichage();
    }

    @Override
    public void effacer() {
        String string = ((Element)this.noeud).getAttribute(this.srcAttr);
        File file = this.doc.fsave == null ? new File(string) : new File(this.doc.fsave.getParent() + File.separatorChar + string);
        if (file.exists() && file.isFile() && !file.delete()) {
            LOG.error("delete " + file.getPath());
        }
    }

    protected String enregistrerImage(BufferedImage bufferedImage, String string) {
        File file;
        if (string != null && !"".equals(string) && (file = this.doc.fsave == null ? new File(string) : new File(this.doc.fsave.getParent() + File.separatorChar + string)).exists() && file.isFile() && !file.delete()) {
            LOG.error("delete " + file.getPath());
        }
        if (this.doc.fsave == null) {
            return null;
        }
        file = null;
        String string2 = null;
        String string3 = this.doc.fsave.getName();
        if (string3.indexOf(46) != -1) {
            string3 = string3.substring(0, string3.lastIndexOf(46));
        }
        String string4 = "equations_" + string3;
        File file2 = new File(this.doc.fsave.getParent() + File.separator + string4);
        if (!file2.exists() && !file2.mkdir()) {
            LOG.error("enregistrerImage(BufferedImage, String) - Erreur \u00e0 la cr\u00e9ation du dossier des \u00e9quations");
            return null;
        }
        int n = 1;
        while (file == null || file.exists()) {
            string2 = "equation" + n + ".png";
            file = new File(file2.getPath() + File.separator + string2);
            ++n;
        }
        try {
            DialogueEquation.enregistrerImage(bufferedImage, file);
        }
        catch (IOException iOException) {
            LOG.error("enregistrerImage(BufferedImage, String)", iOException);
            JOptionPane.showMessageDialog(this.doc.jframe, JaxeResourceBundle.getRB().getString("erreur.Enregistrement") + ": " + iOException.getMessage(), JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
            return null;
        }
        return string4 + "/" + string2;
    }
}

