/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;

public class DocumentRenderer
implements Printable {
    protected int currentPage = -1;
    protected JEditorPane jeditorPane;
    protected double pageEndY = 0.0;
    protected double pageStartY = 0.0;
    protected boolean scaleWidthToFit = false;
    protected double scaleBase = 0.75;
    protected PageFormat pFormat;
    protected PrinterJob pJob = PrinterJob.getPrinterJob();

    public DocumentRenderer() {
        this.pFormat = this.pJob.defaultPage();
    }

    public Document getDocument() {
        if (this.jeditorPane != null) {
            return this.jeditorPane.getDocument();
        }
        return null;
    }

    public boolean getScaleWidthToFit() {
        return this.scaleWidthToFit;
    }

    public void pageDialog() {
        this.pFormat = this.pJob.pageDialog(this.pFormat);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        double d = 1.0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.jeditorPane.setSize((int)(pageFormat.getImageableWidth() / this.scaleBase), Integer.MAX_VALUE);
        this.jeditorPane.validate();
        View view = this.jeditorPane.getUI().getRootView(this.jeditorPane);
        if (this.scaleWidthToFit && this.jeditorPane.getMinimumSize().getWidth() > pageFormat.getImageableWidth()) {
            d = pageFormat.getImageableWidth() / this.jeditorPane.getMinimumSize().getWidth();
            graphics2D.scale(d, d);
        }
        if (this.scaleBase != 1.0) {
            d = this.scaleBase;
            graphics2D.scale(d, d);
        }
        graphics2D.setClip((int)(pageFormat.getImageableX() / d), (int)(pageFormat.getImageableY() / d), (int)(pageFormat.getImageableWidth() / d), (int)(pageFormat.getImageableHeight() / d));
        if (n > this.currentPage) {
            this.currentPage = n;
            this.pageStartY += this.pageEndY;
            this.pageEndY = graphics2D.getClipBounds().getHeight();
        }
        graphics2D.translate(graphics2D.getClipBounds().getX(), graphics2D.getClipBounds().getY());
        Rectangle rectangle = new Rectangle(0, (int)(-this.pageStartY), (int)this.jeditorPane.getMinimumSize().getWidth(), (int)this.jeditorPane.getPreferredSize().getHeight());
        if (this.printView(graphics2D, rectangle, view)) {
            return 0;
        }
        this.pageStartY = 0.0;
        this.pageEndY = 0.0;
        this.currentPage = -1;
        return 1;
    }

    public void print(HTMLDocument hTMLDocument) {
        this.setDocument(hTMLDocument);
        this.printDialog();
    }

    public void print(JEditorPane jEditorPane) {
        this.setDocument(jEditorPane);
        Cursor cursor = jEditorPane.getCursor();
        jEditorPane.setCursor(new Cursor(3));
        this.printDialog();
        jEditorPane.setCursor(cursor);
    }

    public void print(PlainDocument plainDocument) {
        this.setDocument(plainDocument);
        this.printDialog();
    }

    protected void printDialog() {
        if (this.pJob.printDialog()) {
            this.pJob.setPrintable(this, this.pFormat);
            try {
                this.pJob.print();
            }
            catch (PrinterException printerException) {
                this.pageStartY = 0.0;
                this.pageEndY = 0.0;
                this.currentPage = -1;
                System.out.println("Error Printing Document");
            }
        }
    }

    protected boolean printView(Graphics2D graphics2D, Shape shape, View view) {
        boolean bl = false;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (view.getViewCount() > 0) {
            for (int i = 0; i < view.getViewCount(); ++i) {
                View view2;
                Shape shape2 = view.getChildAllocation(i, shape);
                if (shape2 == null || !this.printView(graphics2D, shape2, view2 = view.getView(i))) continue;
                bl = true;
            }
        } else if (shape.getBounds().getMaxY() >= rectangle.getY()) {
            bl = true;
            if (shape.getBounds().getHeight() > rectangle.getHeight() && shape.intersects(rectangle)) {
                view.paint(graphics2D, shape);
                if (view instanceof ComponentView) {
                    graphics2D.translate(shape.getBounds().x, shape.getBounds().y);
                    ((ComponentView)view).getComponent().paint(graphics2D);
                    graphics2D.translate(-shape.getBounds().x, -shape.getBounds().y);
                }
            } else if (shape.getBounds().getY() >= rectangle.getY()) {
                if (shape.getBounds().getMaxY() <= rectangle.getMaxY()) {
                    view.paint(graphics2D, shape);
                    if (view instanceof ComponentView) {
                        graphics2D.translate(shape.getBounds().x, shape.getBounds().y);
                        ((ComponentView)view).getComponent().paint(graphics2D);
                        graphics2D.translate(-shape.getBounds().x, -shape.getBounds().y);
                    }
                } else if (shape.getBounds().getY() < this.pageEndY) {
                    this.pageEndY = shape.getBounds().getY();
                }
            }
        }
        return bl;
    }

    protected void setContentType(String string) {
        this.jeditorPane.setContentType(string);
    }

    public void setDocument(HTMLDocument hTMLDocument) {
        this.jeditorPane = new JTextPane();
        this.setDocument("text/html", hTMLDocument);
    }

    public void setDocument(JEditorPane jEditorPane) {
        this.jeditorPane = jEditorPane;
    }

    public void setDocument(PlainDocument plainDocument) {
        this.jeditorPane = new JEditorPane();
        this.setDocument("text/plain", plainDocument);
    }

    protected void setDocument(String string, Document document) {
        this.setContentType(string);
        this.jeditorPane.setDocument(document);
    }

    public void setScaleWidthToFit(boolean bl) {
        this.scaleWidthToFit = bl;
    }
}

