/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import jaxe.Config;
import jaxe.Jaxe;
import jaxe.JaxeFrame;
import jaxe.JaxeResourceBundle;
import org.apache.log4j.Logger;

public class DialogueNouveau
extends JDialog
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(DialogueNouveau.class);
    private static final ResourceBundle rb = JaxeResourceBundle.getRB();
    JList liste;
    Vector<ItemConfig> configs;
    JaxeFrame frame;
    boolean bannulation = false;

    public DialogueNouveau(JaxeFrame jaxeFrame) {
        super((Frame)jaxeFrame, true);
        this.frame = jaxeFrame;
        this.setTitle(rb.getString("nouveau.Titre"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DialogueNouveau.this.annuler();
            }
        });
        this.configs = new Vector();
        File file = new File("config");
        String[] stringArray = file.list();
        if (stringArray == null) {
            LOG.error("DialogueNouveau(JaxeFrame) - " + rb.getString("erreur.DossierConfig"), null);
            return;
        }
        for (String object2 : stringArray) {
            if (!object2.endsWith("_cfg.xml") && !object2.endsWith("_config.xml")) continue;
            this.configs.add(new ItemConfig(object2));
        }
        Collections.sort(this.configs);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        JLabel jLabel = new JLabel(rb.getString("nouveau.Choisir"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        jPanel.add((Component)jLabel, "North");
        this.liste = new JList<ItemConfig>(this.configs);
        if (this.configs.size() > 0) {
            this.liste.setSelectedIndex(0);
        }
        this.liste.setSelectionMode(0);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DialogueNouveau.this.nouveau();
                }
            }
        };
        this.liste.addMouseListener(mouseAdapter);
        this.liste.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.add((Component)this.liste, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(rb.getString("nouveau.Annuler"));
        jButton.setActionCommand("annuler");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(rb.getString("nouveau.Nouveau"));
        jButton2.setActionCommand("nouveau");
        jButton2.addActionListener(this);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(jButton2);
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("nouveau".equals(string)) {
            this.nouveau();
        } else if ("annuler".equals(string)) {
            this.annuler();
        }
    }

    protected void nouveau() {
        JaxeFrame jaxeFrame;
        ItemConfig itemConfig = (ItemConfig)this.liste.getSelectedValue();
        if (this.frame != null && !this.frame.doc.getModif() && this.frame.doc.fsave == null) {
            jaxeFrame = this.frame;
        } else {
            jaxeFrame = new JaxeFrame();
            Jaxe.allFrames.add(jaxeFrame);
        }
        this.setVisible(false);
        jaxeFrame.initNew(itemConfig.chemin);
    }

    protected void annuler() {
        this.bannulation = true;
        this.setVisible(false);
    }

    public boolean annulation() {
        return this.bannulation;
    }

    class ItemConfig
    implements Comparable<ItemConfig> {
        String chemin;
        String description = null;

        ItemConfig(String string) {
            this.chemin = "config" + File.separator + string;
            this.description = null;
            try {
                URL uRL = new File("config" + File.separator + string).toURI().toURL();
                this.description = Config.descriptionDialogueNouveau(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                LOG.error(malformedURLException);
                this.description = null;
            }
            if (this.description == null) {
                this.description = string.substring(0, string.indexOf(46));
            }
        }

        @Override
        public int compareTo(ItemConfig itemConfig) {
            if (this.description == null) {
                return 0;
            }
            return this.description.compareToIgnoreCase(itemConfig.description);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ItemConfig)) {
                return false;
            }
            ItemConfig itemConfig = (ItemConfig)object;
            return this.compareTo(itemConfig) == 0;
        }

        public String toString() {
            return " " + this.description;
        }
    }
}

