/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jkate;

import com.fluendo.jkate.Bitwise;
import com.fluendo.jkate.Event;
import com.fluendo.jkate.Info;
import com.fluendo.jkate.KateException;
import com.fluendo.jkate.KateMarkupType;
import com.fluendo.jkate.KateTextDirectionality;
import com.fluendo.jkate.KateTextEncoding;
import com.fluendo.jkate.Motion;
import com.jcraft.jogg.Buffer;

public final class Decode {
    Buffer opb = new Buffer();
    Info info;

    public Decode(Info info) {
        this.info = info;
    }

    int decodeTextPacket(Event event) {
        int n;
        event.ki = this.info;
        event.start = Bitwise.read64(this.opb);
        event.duration = Bitwise.read64(this.opb);
        event.backlink = Bitwise.read64(this.opb);
        event.start_time = this.granuleDuration(event.start);
        event.end_time = event.start_time + this.granuleDuration(event.duration);
        int n2 = Bitwise.read32(this.opb);
        event.text = new byte[n2];
        Bitwise.readbuf(this.opb, event.text, n2);
        event.id = -1;
        if (this.opb.read1() != 0) {
            event.id = Bitwise.read32v(this.opb);
        }
        event.motions = null;
        if (this.opb.read1() != 0) {
            n = Bitwise.read32v(this.opb);
            if (n < 0) {
                return -1;
            }
            event.motions = new Motion[n];
            for (int i = 0; i < n; ++i) {
                if (this.opb.read1() != 0) {
                    int n3 = Bitwise.read32v(this.opb);
                    if (n3 < 0 || n3 >= this.info.motions.length) {
                        return -1;
                    }
                    event.motions[i] = this.info.motions[n3];
                    continue;
                }
                try {
                    event.motions[i] = this.info.unpackMotion(this.opb);
                    continue;
                }
                catch (KateException kateException) {
                    return -6;
                }
            }
        }
        if (this.opb.read1() != 0) {
            try {
                if (this.opb.read1() != 0) {
                    event.text_encoding = KateTextEncoding.CreateTextEncoding(this.opb.read(8));
                }
                if (this.opb.read1() != 0) {
                    event.text_directionality = KateTextDirectionality.CreateTextDirectionality(this.opb.read(8));
                }
            }
            catch (KateException kateException) {
                return -6;
            }
            if (this.opb.read1() != 0) {
                n = Bitwise.read32v(this.opb);
                if (n < 0) {
                    return -6;
                }
                if (n > 0) {
                    event.language = new byte[n];
                    Bitwise.readbuf(this.opb, event.language, n);
                }
            }
            if (this.opb.read1() != 0) {
                n = Bitwise.read32v(this.opb);
                if (n < 0 || n >= this.info.regions.length) {
                    return -6;
                }
                event.kr = this.info.regions[n];
            }
            if (this.opb.read1() != 0) {
                try {
                    event.kr = this.info.unpackRegion(this.opb);
                }
                catch (KateException kateException) {
                    return -6;
                }
            }
            if (this.opb.read1() != 0) {
                n = Bitwise.read32v(this.opb);
                if (n < 0 || n >= this.info.styles.length) {
                    return -6;
                }
                event.ks = this.info.styles[n];
            }
            if (this.opb.read1() != 0) {
                try {
                    event.ks = this.info.unpackStyle(this.opb);
                }
                catch (KateException kateException) {
                    return -6;
                }
            }
            if (this.opb.read1() != 0) {
                n = Bitwise.read32v(this.opb);
                if (n < 0 || n >= this.info.styles.length) {
                    return -6;
                }
                event.ks2 = this.info.styles[n];
            }
            if (this.opb.read1() != 0) {
                try {
                    event.ks2 = this.info.unpackStyle(this.opb);
                }
                catch (KateException kateException) {
                    return -6;
                }
            }
            if (this.opb.read1() != 0) {
                n = Bitwise.read32v(this.opb);
                if (n < 0 || n >= this.info.font_mappings.length) {
                    return -6;
                }
                event.font_mapping = this.info.font_mappings[n];
            }
        }
        if ((this.info.bitstream_version_major << 8 | this.info.bitstream_version_minor) >= 2) {
            Bitwise.read32v(this.opb);
            if (this.opb.read1() != 0) {
                if (this.opb.read1() != 0) {
                    n = Bitwise.read32v(this.opb);
                    if (n < 0 || n >= this.info.palettes.length) {
                        return -6;
                    }
                    event.palette = this.info.palettes[n];
                }
                if (this.opb.read1() != 0) {
                    try {
                        event.palette = this.info.unpackPalette(this.opb);
                    }
                    catch (KateException kateException) {
                        return -6;
                    }
                }
                if (this.opb.read1() != 0) {
                    n = Bitwise.read32v(this.opb);
                    if (n < 0 || n >= this.info.bitmaps.length) {
                        return -6;
                    }
                    event.bitmap = this.info.bitmaps[n];
                }
                if (this.opb.read1() != 0) {
                    try {
                        event.bitmap = this.info.unpackBitmap(this.opb);
                    }
                    catch (KateException kateException) {
                        return -6;
                    }
                }
                if (this.opb.read1() != 0) {
                    try {
                        event.markup_type = KateMarkupType.CreateMarkupType(this.opb.read(8));
                    }
                    catch (KateException kateException) {
                        return -6;
                    }
                }
            }
        }
        return 0;
    }

    public double granuleTime(long l) {
        if (l >= 0L) {
            long l2 = l >> this.info.granule_shift;
            long l3 = l - (l2 << this.info.granule_shift);
            return (double)(l2 + l3) * ((double)this.info.gps_denominator / (double)this.info.gps_numerator);
        }
        return -1.0;
    }

    public double granuleDuration(long l) {
        if (l >= 0L) {
            return (double)l * ((double)this.info.gps_denominator / (double)this.info.gps_numerator);
        }
        return -1.0;
    }
}

