/*

Copyright (C) 2012  Observatoire de Paris

The JavaScript code in this page is free software: you can
redistribute it and/or modify it under the terms of the GNU
General Public License (GNU GPL) as published by the Free Software
Foundation, either version 3 of the License, or (at your option)
any later version.  The code is distributed WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU GPL for more details.

As additional permission under GNU GPL version 3 section 7, you
may distribute non-source (e.g., minimized or compacted) forms of
that code without the copy of the GNU GPL normally required by
section 4, provided you include this license notice and a URL
through which recipients can access the Corresponding Source.

*/

var tdsel; // cellule sélectionnée
var selr, selc; // position de la cellule sélectionnée
var colonnes; // String[] titres des colonnes
var valeurs; // String[][] valeurs des cellules
var plot = null; // objet jqplot

// create the nodeType constants if the Node object is not defined
if (!window.Node) {
    var Node =
    {
        ELEMENT_NODE                :  1,
        ATTRIBUTE_NODE              :  2,
        TEXT_NODE                   :  3,
        CDATA_SECTION_NODE          :  4,
        ENTITY_REFERENCE_NODE       :  5,
        ENTITY_NODE                 :  6,
        PROCESSING_INSTRUCTION_NODE :  7,
        COMMENT_NODE                :  8,
        DOCUMENT_NODE               :  9,
        DOCUMENT_TYPE_NODE          : 10,
        DOCUMENT_FRAGMENT_NODE      : 11,
        NOTATION_NODE               : 12
    };
}

function getParameter(paramName) {
    var searchString = window.location.search.substring(1),
    i, val, params = searchString.split("&");
    
    for (i=0;i<params.length;i++) {
        val = params[i].split("=");
        if (val[0] == paramName) {
            return unescape(val[1]);
        }
    }
    return null;
}

function init() {
    var fichierXML = getParameter('fichierXML');
    var chemin_fichiers = getParameter('chemin_fichiers');
    var champ = document.getElementById('champ');
    champ.value = '';
    if (fichierXML == null) {
        alert("Il faut passer un paramètre fichierXML à l'URL");
        return;
    }
    if (chemin_fichiers != null) {
        fichierXML = chemin_fichiers + fichierXML;
    }
    var xmlDoc = chargementXML(fichierXML);
    if (xmlDoc == null) {
        alert('fichier introuvable: ' + fichierXML);
        return;
    }
    var racine = xmlDoc.documentElement;
    if (racine.nodeName.toUpperCase() != 'TABLE')
        alert('le fichier XML ne contient pas une table formattée pour le TabloGraphe');
    xmlVersTableaux(racine);
    creationTable();
    remplissageSelect();
    toutRecalculer();
}

function chargementXML(fichierXML) {
    var xmlhttp;
    if (window.XMLHttpRequest) {
        // IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
    } else {
        // IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    xmlhttp.open("GET", fichierXML, false);
    try {
        xmlhttp.send();
    } catch (ex) {
        alert(ex.description);
        return(null);
    }
    return(xmlhttp.responseXML);
}

function xmlVersTableaux(racine) {
    valeurs = new Array();
    colonnes = null;
    var i,j;
    i = 0;
    for (var n=racine.firstChild; n != null; n = n.nextSibling) {
        if (n.nodeType == Node.ELEMENT_NODE && n.nodeName.toUpperCase() == 'TR') {
            j = 0;
            var avecTD = false;
            for (var n2=n.firstChild; n2 != null; n2 = n2.nextSibling) {
                if (n2.nodeType == Node.ELEMENT_NODE) {
                    if (i == 0)
                        valeurs[j] = new Array();
                    if (n2.nodeName.toUpperCase() == 'TH') {
                        if (colonnes == null)
                            colonnes = new Array();
                        colonnes[j] = getTextValue(n2);
                    } else if (n2.nodeName.toUpperCase() == 'TD') {
                        valeurs[j][i] = getTextValue(n2);
                        avecTD = true;
                    }
                    j++;
                }
            }
            if (avecTD)
                i++;
        }
    }
}

function creationTable() {
    var largeurCellule = 100;
    var largeurNumero = 40;
    var padding = 4;
    var bordCellules = 1;
    var bordTable = 1;
    var largeurScrollBar = 17;
    var largeurTotale = largeurNumero + valeurs.length * largeurCellule + (valeurs.length + 1) * 2 * (padding + bordCellules) + 2 * bordTable + largeurScrollBar;
    var largeurBody = $('body').width(); // avec jquery
    if (largeurBody < largeurTotale) {
        // on tente de réduire la largeur des cellules pour que ça rentre dans la fenêtre
        var lc2 = (largeurBody - (largeurNumero + (valeurs.length + 1) * 2 * (padding + bordCellules) + 2 * bordTable + largeurScrollBar)) / valeurs.length;
        if (lc2 > 50) {
            largeurCellule = lc2;
            largeurTotale = largeurNumero + valeurs.length * largeurCellule + (valeurs.length + 1) * 2 * (padding + bordCellules) + 2 * bordTable + largeurScrollBar;
        }
    }
    var divthead = document.getElementById('divthead');
    if (valeurs[0].length > 10)
        divthead.style.width = (largeurTotale - largeurScrollBar) + 'px';
    else
        divthead.style.width = largeurTotale + 'px';
    var divtbody = document.getElementById('divtbody');
    if (valeurs[0].length > 10) {
        divtbody.style.width = largeurTotale + 'px';
        divtbody.style.height = '350px';
        divtbody.style.overflow = 'auto';
    } else
        divtbody.style.width = largeurTotale + 'px';
    var tablethead = document.getElementById('tablethead');
    tablethead.style.width = divthead.style.width;
    var thead = document.createElement('thead');
    var tr = document.createElement('tr');
    for (var i=0; i<valeurs.length+1; i++) {
        var td = document.createElement('td');
        td.className = 'numeros';
        if (i == 0)
            td.style.width = largeurNumero + 'px';
        else {
            td.style.width = largeurCellule + 'px';
            var contenu = document.createTextNode(String.fromCharCode('A'.charCodeAt(0) + (i-1)));
            td.appendChild(contenu);
        }
        tr.appendChild(td);
    }
    thead.appendChild(tr);
    if (colonnes != null) {
        tr = document.createElement('tr');
        for (var i=0; i<colonnes.length+1; i++) {
            if (i == 0) {
                var td = document.createElement('td');
                td.className = 'numeros';
                tr.appendChild(td);
            } else {
                var th = document.createElement('th');
                var contenu = document.createTextNode(colonnes[i-1]);
                th.appendChild(contenu);
                tr.appendChild(th);
            }
        }
        thead.appendChild(tr);
    }
    tablethead.appendChild(thead);
    var table = document.getElementById('table');
    table.style.width = divthead.style.width;
    var tbody = document.createElement('tbody');
    tbody.setAttribute('id', 'tbody');
    for (var i=0; i<valeurs[0].length; i++) {
        tr = document.createElement('tr');
        {
            var td = document.createElement('td');
            td.className = 'numeros';
            if (i == 0)
                td.style.width = largeurNumero + 'px';
            var contenu = document.createTextNode(i+1);
            td.appendChild(contenu);
            tr.appendChild(td);
        }
        for (var j=0; j<valeurs.length; j++) {
            var classe;
            if (i%2 == 0)
                classe = "pair";
            else
                classe = "impair";
            var td = document.createElement('td');
            td.className = classe;
            if (i == 0)
                td.style.width = largeurCellule + 'px';
            var contenu = document.createTextNode(valeurs[j][i] != '' ? valeurs[j][i] : '\u00a0');
            // (espace insécable pour que IE affiche toujours les cellules)
            td.appendChild(contenu);
            if (td.addEventListener)
                td.addEventListener('click', clicCellule, false);
            else
                td.attachEvent('onclick', clicCellule);
            tr.appendChild(td);
        }
        tbody.appendChild(tr);
    }
    table.appendChild(tbody);
    if (document.addEventListener) {
        document.addEventListener('keydown', keydown, false);
    } else if (document.attachEvent) {
        document.attachEvent('onkeydown', keydown);
    }
}

function remplissageSelect() {
    var graphede = document.getElementById('graphede');
    var fonctionde = document.getElementById('fonctionde');
    for (var i=0; i<valeurs.length; i++) {
        var option = document.createElement('option');
        var contenu = document.createTextNode(colonnes != null ? colonnes[i] : String.fromCharCode('A'.charCodeAt(0) + i));
        option.appendChild(contenu);
        graphede.appendChild(option);
        option = option.cloneNode(true);
        fonctionde.appendChild(option);
    }
}

function trim(s) {
    return(s.replace(/^\s+|\s+$/g, ""));
}

function getTextValue(n) {
    if (n.firstChild == null || n.firstChild.nodeValue == null)
        return('');
    else
        return(trim(n.firstChild.nodeValue));
}

function clicCellule(event) {
    var td = (event.target || event.srcElement);
    selectionCellule(td);
    var champ = document.getElementById('champ');
    champ.focus();
    champ.select();
}

function selectionCellule(td) {
    if (tdsel != null) {
        actionChamp();
        tdsel.className = tdsel.className.replace(/ ?select/gi, '');
    }
    tdsel = td;
    tdsel.className = tdsel.className + ' select';
    selc = -1;
    var precedent = tdsel.previousSibling;
    while (precedent != null) {
        precedent = precedent.previousSibling;
        selc++;
    }
    var tr = tdsel.parentNode;
    selr = 0;
    var lprec = tr.previousSibling;
    while (lprec != null) {
        if (lprec != null)
            selr++;
        lprec = lprec.previousSibling;
    }
    majPosition();
    var champ = document.getElementById('champ');
    champ.value = valeurs[selc][selr];
}

function majPosition() {
    var position = document.getElementById('position');
    position.innerHTML = String.fromCharCode("A".charCodeAt(0) + selc) + (selr + 1);
}

// remarque: on pourrait utiliser tabindex pour permettre le focus sur un td
function keydown(event) {
    switch (event.keyCode) {
        case 37: move(0, -1, event); break; // left
        case 38: move(-1, 0, event); break; // up
        case 39: move(0, 1, event); break; // right
        case 40: move(1, 0, event); break; // down
        //case 13: champ.focus(); champ.select(); break; // enter
    }
}

function move(mr, mc, e) {
    if (tdsel == null)
        return;
    if (selr + mr >= 0 && selr + mr < valeurs[0].length &&
            selc + mc >= 0 && selc + mc < valeurs.length) {
        var td = positionVersTd(selr + mr, selc + mc);
        selectionCellule(td);
        var champ = document.getElementById('champ');
        champ.select();
        if (e.preventDefault)
            e.preventDefault();
        e.returnValue = false;
    }
}

function positionVersTd(ligne, colonne) {
    // optimisation possible
    var tbody = document.getElementById('tbody');
    var i = 0;
    for (var tr=tbody.firstChild; tr != null; tr = tr.nextSibling) {
        if (i == ligne) {
            var j = -1;
            for (var td=tr.firstChild; td != null; td = td.nextSibling) {
                if (j == colonne) {
                    return(td);
                }
                j++;
            }
            break;
        }
        i++;
    }
    return(null);
}

function keypress(event) { // keypress dans le champ
    if (tdsel == null)
        return(true);
    if (event.keyCode == 13) { // enter
        actionChamp();
        //tdsel.focus();
        return(false); // pour ne pas que IE déclenche l'aide !
    }
    /*
    var champ = document.getElementById('champ');
    var v = trim(champ.value);
    if (v.indexOf("=") != 0 && valeurs[selc][selr] != v) {
        // on met immédiatement à jour la cellule s'il ne s'agit pas d'un calcul
        valeurs[selc][selr] = v;
        tdsel.innerHTML = champ.value;
    }
    */
    return(true);
}

function setTableElement(ligne, colonne, valeur) {
    var td = positionVersTd(ligne, colonne);
    if (td == null)
        alert("cellule non trouvée: " + ligne + ", " + colonne);
    td.innerHTML = (valeur != '' ? valeur : '&nbsp;');
}


// appelé quand le texte d'une cellule est modifié
function actionChamp() {
    if (selr != -1 && selc != -1) {
        var champ = document.getElementById('champ');
        var texte = trim(champ.value);
        if (texte != valeurs[selc][selr]) {
            valeurs[selc][selr] = texte;
            if (texte.indexOf("=") == 0) {
                texte = trim(texte.substring(1));
                if (texte != "") {
                    texte = ajParentheses(texte);
                    var param = parser(texte);
                    var d = param.evaluer();
                    if (d == null)
                        texte = "";
                    else
                        texte = joliFormattage(d, 4);
                }
            }
            tdsel.innerHTML = (texte != '' ? texte : '&nbsp;');
            toutRecalculer();
            copieAuto();
        }
    }
}

// copie du contenu de la première cellule d'une colonne vers les autres cellules
function copieAuto() {
    var s1 = valeurs[selc][selr];
    if (selr != 0)
        return;
    if (s1 == null || s1.indexOf("=") != 0 || s1.indexOf("moyenne(") != -1 || s1.indexOf("avg(") != -1)
        return;
    // remplacement des noms des colonnes par leur codages, par ex. 'Tsid' -> 'C1'
    if (colonnes != null) {
        for (var i=1; i<s1.length; i++) {
            var cav = s1.charAt(i-1);
            if ((cav >= 'a' && cav <='z') || (cav >= 'A' && cav <= 'Z'))
                continue;
            for (var j=0; j<colonnes.length; j++) {
                if (colonnes[j].length > 0) {
                    var cap = ' ';
                    if (i+colonnes[j].length < s1.length)
                        cap = s1.charAt(i+colonnes[j].length);
                    if ((cap >= 'a' && cap <= 'z') || (cap >= 'A' && cap <= 'Z') || (cap >= '0' && cap <= '9'))
                        continue;
                    if (colonnes[j] != null && s1.length >= i + colonnes[j].length &&
                            colonnes[j] == s1.substring(i, i+colonnes[j].length)) {
                        s1 = s1.substring(0, i) + String.fromCharCode("A".charCodeAt(0) + j) + "1" + s1.substring(i+colonnes[j].length);
                        break;
                    }
                }
            }
        }
    }
    valeurs[selc][selr] = s1;
    
    var s;
    for (var ir=1; ir<valeurs[0].length; ir++) {
        var i1, i2, ni1;
        s = s1;
        i1 = -1;
        for (var i=0; i<s.length-1; i++) {
            var ci = s.charAt(i).toUpperCase();
            var cip1 = s.charAt(i+1);
            if ((ci >= 'A' && ci <= 'Z') && (cip1 >= '0' && cip1 <= '9')) {
                var cim1;
                if (i > 0)
                    cim1 = s.charAt(i-1);
                else
                    cim1 = '';
                // pour distinguer =1E1 de =E1
                if ((ci != 'E' && ci != 'e') || cim1 < '0' || cim1 > '9') {
                    i1 = i;
                    break;
                }
            }
        }
        ni1 = i1;
        while (ni1 != -1) {
            i2 = i1+1;
            while (i2 < s.length && s.charAt(i2) >= '0' && s.charAt(i2) <= '9')
                i2++;
            if (i2 > i1+1) {
                var nl = parseInt(s.substring(i1+1, i2));
                if (isNaN(nl)) {
                    alert("isNaN: " + s.substring(i1+1, i2));
                    return;
                }
                s = s.substring(0,i1+1) + (nl+ir) + s.substring(i2);
            }
            ni1 = i1+1;
            if (ni1 >= s.length)
                ni1 = -1;
            else {
                var c = s.charAt(ni1);
                while (ni1 < s.length && !((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z'))) {
                    ni1++;
                    if (ni1 < s.length)
                        c = s.charAt(ni1);
                }
                if (ni1 >= s.length)
                    ni1 = -1;
            }
            i1 = ni1;
        }
        valeurs[selc][ir] = s;
        setTableElement(ir, selc, s);
    }
    toutRecalculer();
}

function doubleOuNull(s) {
    if (s == null)
        return(null);
    if (s.indexOf('.') == -1 && s.indexOf(',') > 0)
        s = s.replace(',', '.');
    var d = Number(s);
    if (isNaN(d))
        return(null);
    return(d);
}

function joliFormattage(d, precision) {
    if (isNaN(d))
        return('');
    if (d == 0)
        return('0');
    var facteur_precision = Math.pow(10, precision);
    var exposant = Math.floor(Math.log(Math.abs(d))/Math.log(10));
    var mantisse = d / (Math.pow(10,exposant));
    var s;
    if (exposant == 0) {
        mantisse = Math.round(mantisse*facteur_precision)/facteur_precision;
        s = ""+mantisse;
    } else if (exposant == 1) {
        mantisse = Math.round(mantisse*facteur_precision)/(facteur_precision/10);
        s = ""+mantisse;
    } else if (exposant == -1) {
        var signe;
        if (mantisse < 0)
            signe = "-";
        else
            signe = "";
        mantisse = Math.abs(Math.round(mantisse*facteur_precision));
        s = signe + "0."+Math.floor(mantisse);
        s = s.replace(/0+$/g, '');
    } else {
        mantisse = Math.round(mantisse*facteur_precision)/facteur_precision;
        s = mantisse + "E" + exposant;
    }
    return(s);
}


// fonctions de tableur

//public void toutRecalculer() {
function toutRecalculer() {
    for (var i=0; i<valeurs.length; i++)
        for (var j=0; j<valeurs[i].length; j++) {
            var texte = valeurs[i][j];
            if (texte.indexOf("=") == 0) {
                var d = calculer(texte);
                if (d == null)
                    texte = "";
                else
                    texte = joliFormattage(d, 4);
                setTableElement(j, i, texte);
            }
        }
}

//public Double calculer(String s) {
function calculer(s) {
    s = trim(s.substring(1));
    if ("" == s)
        return(null);
    s = ajParentheses(s);
    var param = parser(s);
    var d = param.evaluer();
    return(d);
}

//public String valeurCellule(String nom) {
function valeurCellule(nom) {
    if (nom.length < 2)
        return null;
    nom = nom.toUpperCase();
    var c = nom.charAt(0).charCodeAt(0);
    var nc = c - "A".charCodeAt(0) + 1;
    var nl = Number(nom.substring(1));
    if (isNaN(nl)) {
        //alert("Not a Number: " + nom.substring(1));
        // peut-être un nom de colonne
        return(null);
    }
    if (nc < 1 || nc > valeurs.length || nl < 1 || nl > valeurs[0].length)
        return(null);
    return(valeurs[nc-1][nl-1]);
}

//public String ajParentheses(String s) {
function ajParentheses(s) {
    var sops = "^/*-+";
    for (var iops=0; iops<sops.length; iops++) {
        var cops = sops.charAt(iops);
        var indop = s.indexOf(cops);
        if (indop > 0 && "^*/-+Ee".indexOf(s.charAt(indop-1)) != -1)
            indop = -1; // un - ou + après un E ou un opérateur n'est pas un opérateur !
        var nindop = indop;
        var im,ip;
        var cm=' ',cp=' ';
        var pp;
        var ajp;
        while (nindop != -1) {
            ajp = false;
            im = indop - 1;
            if (im >= 0)
                cm = s.charAt(im);
            pp = 0;
            while (im >= 0 && (pp != 0 || cm != '(') &&
                    (pp != 0 || (sops.indexOf(cm) == -1 ||
                    (im > 0 && "^*/-+Ee".indexOf(s.charAt(im-1)) != -1)))) {
                if (cm == ')')
                    pp++;
                else if (cm == '(')
                    pp--;
                im--;
                if (im >= 0)
                    cm = s.charAt(im);
            }
            if (im < 0 || sops.indexOf(cm) != -1)
                ajp = true;
            ip = indop + 1;
            if (ip >= 0)
                cp = s.charAt(ip);
            pp = 0;
            while (ip < s.length && (pp != 0 || cp != ')') &&
                    (pp != 0 || (sops.indexOf(cp) == -1 ||
                    (ip > 0 && "^*/-+Ee".indexOf(s.charAt(ip-1)) != -1)))) {
                if (cp == '(')
                    pp++;
                else if (cp == ')')
                    pp--;
                ip++;
                if (ip < s.length)
                    cp = s.charAt(ip);
            }
            if (ip >= s.length || sops.indexOf(cp) != -1)
                ajp = true;
            if (ajp) {
                s = s.substring(0, im+1) + "(" + s.substring(im+1, ip) + ")" +
                    s.substring(ip);
                indop++;
            }
            nindop = s.substring(indop+1).indexOf(cops);
            indop = nindop + indop+1;
        }
    }
    return(s);
}

//public Parametre parser(String s) {
function parser(s) {
    var sops = "^/*-+";
    if (s.charAt(0) == '(' && s.charAt(s.length-1) == ')') {
        var retparok = true;
        // on vérifie si on peut retirer les parenthèses qui entourent l'expression
        var pp = 0;
        for (var i=1; i<s.length-1; i++) {
            if (s.charAt(i) == '(')
                pp++;
            else if (s.charAt(i) == ')')
                pp--;
            if (pp < 0) {
                retparok = false;
                break;
            }
        }
        if (retparok)
            s = s.substring(1, s.length-1);
    }
    var indop = -1;
    var pp = 0;
    for (var i=0; i<s.length; i++) {
        if (pp == 0 && sops.indexOf(s.charAt(i)) != -1 &&
                (i==0 || "^*/-+Ee".indexOf(s.charAt(i-1)) == -1)) {
            indop = i;
            break;
        } else if (s.charAt(i) == '(')
            pp++;
        else if (s.charAt(i) == ')')
            pp--;
    }
    if (indop == -1) {
        var nb = true;
        for (var i=0; i<s.length; i++)
            if ("0123456789.,-+ ".indexOf(s.charAt(i)) == -1  &&
                    ((s.charAt(i) != 'E' && s.charAt(i) != 'e') ||
                    (i == 0 || "0123456789".indexOf(s.charAt(i-1)) == -1))) {
                nb = false;
                break;
            }
        if (nb) {
            var d = Number(s);
            if (isNaN(d))
                d = 0;
            return(new Nombre(d));
        } else {
            var indf = s.indexOf('(');
            if (indf != -1 && s.charAt(s.length-1) == ')') {
                var fct = new Fonction(s.substring(0,indf));
                var indv = 0;
                var p1 = null;
                var p2 = null;
                s = s.substring(indf+1, s.length-1);
                indv = s.indexOf(',');
                if (indv != -1) {
                    p1 = parser(trim(s.substring(0,indv)));
                    s = s.substring(indv+1);
                    p2 = parser(trim(s));
                } else
                    p1 = parser(trim(s));
                return(new Expression(fct, p1, p2));
            } else
                return(new Variable(s));
        }
    } else {
        var op = new Fonction(s.charAt(indop));
        var s1 = trim(s.substring(0,indop));
        if (s1 == "")
            s1 = "0"; // -(2+3) = 0 - (2+3)
        var p1 = parser(s1);
        var s2 = trim(s.substring(indop+1));
        var p2 = parser(s2);
        return(new Expression(op, p1, p2));
    }
}

/*
interface Parametre {
    public abstract Double evaluer();
}
*/

//class Expression implements Parametre {
function Expression(fct, p1, p2) {
    this.fct = fct;
    this.p1 = p1;
    this.p2 = p2;
    return(this);
}
Expression.prototype.evaluer = function() {
    if (this.fct.type == Fonction.prototype.moyenne) {
        if (!(this.p1 instanceof Variable))
            return(null);
        var nomCol = this.p1.nom;
        var numc = -1;
        if (nomCol.length == 1) {
            var c = nomCol.charAt(0).toUpperCase();
            if (c >= 'A' && c <= 'Z') {
                numc = c.charCodeAt(0) - "A".charCodeAt(0);
                if (numc >= colonnes.length)
                    numc = -1;
            }
        }
        if (numc == -1 && colonnes != null) {
            for (var i=0; i<colonnes.length; i++)
                if (nomCol == colonnes[i])
                    numc = i;
        }
        if (numc == -1)
            return(null);
        return(moyenne(numc));
    } else if (this.p2 == null) {
        var d1 = this.p1.evaluer();
        if (d1 == null)
            return(null);
        return(this.fct.evaluer(d1, 0));
    } else {
        var d1 = this.p1.evaluer();
        var d2 = this.p2.evaluer();
        if (d1 == null || d2 == null)
            return(null);
        return(this.fct.evaluer(d1, d2));
    }
}

//public double moyenne(int nc) {
function moyenne(nc) {
    var somme = 0;
    var nb = 0;
    for (var i=0; i<valeurs[nc].length; i++) {
        var s = valeurs[nc][i];
        if (s != null && s.indexOf("=") == 0) {
            var td = positionVersTd(i, nc);
            s = getTextValue(td);
        }
        var d = doubleOuNull(s);
        if (d != null) {
            somme += d;
            nb++;
        }
    }
    return(somme / nb);
}

//class Variable implements Parametre {
function Variable(nom) {
    this.nom = nom;
    return(this);
}
Variable.prototype.evaluer = function() {
    var vc, i, c, nc, nl, td, d;
    if (this.nom == null)
        return(null);
    if ("e" == this.nom)
        return(Math.E);
    else if ("pi" == this.nom)
        return(Math.PI);
    nc = -1;
    nl = -1;
    vc = valeurCellule(this.nom);
    if (vc == null && colonnes != null)
        for (i=0; i<colonnes.length; i++)
            if (this.nom == colonnes[i]) {
                vc = valeurCellule(String.fromCharCode("A".charCodeAt(0) + i)+"1");
                nc = i;
                nl = 0;
                break;
            }
    if (vc == null)
        return(null);
    if (vc.indexOf("=") == 0) {
        if (nc == -1) {
            this.nom = this.nom.toUpperCase();
            c = this.nom.charAt(0);
            nc = c.charCodeAt(0) - "A".charCodeAt(0);
            nl = Number(this.nom.substring(1));
            if (isNaN(nl)) {
                alert("isNaN: " + this.nom.substring(1));
                return(null);
            }
            nl = nl - 1;
        }
        td = positionVersTd(nl, nc);
        if (td == null)
            alert("cellule non trouvée: " + nl + ", " + nc);
        vc = getTextValue(td);
        if (vc == null)
            return(null);
    }
    d = Number(vc);
    if (isNaN(d)) {
        //alert("isNaN: " + vc);
        return(null);
    }
    return(d);
}

//static class Nombre implements Parametre {
function Nombre(valeur) {
    this.valeur = valeur;
    return(this);
}
Nombre.prototype.evaluer = function() {
    return(this.valeur);
}

//class Fonction {
function Fonction(nom) {
    switch (nom) {
        case '+': this.type = this.addition; break;
        case '-': this.type = this.soustraction; break;
        case '*': this.type = this.multiplication; break;
        case '/': this.type = this.division; break;
        case '^': this.type = this.puissance; break;
        case 'log': this.type = this.logdecimal; break;
        case 'ln': this.type = this.ln; break;
        case 'exp': this.type = this.exp; break;
        case 'sin': this.type = this.sin; break;
        case 'cos': this.type = this.cos; break;
        case 'tan': this.type = this.tan; break;
        case 'asin': this.type = this.asin; break;
        case 'acos': this.type = this.acos; break;
        case 'atan': this.type = this.atan; break;
        case 'abs': this.type = this.abs; break;
        case 'sqrt': this.type = this.sqrt; break;
        case 'racine': this.type = this.sqrt; break;
        case 'pent': this.type = this.partie_entiere; break;
        case 'floor': this.type = this.partie_entiere; break;
        case 'pfrac': this.type = this.partie_frac; break;
        case 'fpart': this.type = this.partie_frac; break;
        case 'moyenne': this.type = this.moyenne; break;
        case 'avg': this.type = this.moyenne; break;
        default: this.type = 0; break;
    }
    return(this);
}
Fonction.prototype.addition = 1;
Fonction.prototype.soustraction = 2;
Fonction.prototype.multiplication = 3;
Fonction.prototype.division = 4;
Fonction.prototype.puissance = 5;
Fonction.prototype.logdecimal = 6;
Fonction.prototype.ln = 7;
Fonction.prototype.exp = 8;
Fonction.prototype.sin = 9;
Fonction.prototype.cos = 10;
Fonction.prototype.tan = 11;
Fonction.prototype.asin = 12;
Fonction.prototype.acos = 13;
Fonction.prototype.atan = 14;
Fonction.prototype.abs = 15;
Fonction.prototype.sqrt = 16;
Fonction.prototype.partie_entiere = 17;
Fonction.prototype.partie_frac = 18;
Fonction.prototype.moyenne = 19;

Fonction.prototype.evaluer = function(v1, v2) {
    var d;
    switch (this.type) {
        case this.addition: d = v1 + v2; break;
        case this.soustraction:  d = v1 - v2; break;
        case this.multiplication:  d = v1 * v2; break;
        case this.division:  d = v1 / v2; break;
        case this.puissance:  d = Math.pow(v1, v2); break;
        case this.logdecimal:  d = Math.log(v1)/Math.log(10); break;
        case this.ln:  d = Math.log(v1); break;
        case this.exp:  d = Math.exp(v1); break;
        case this.sin:  d = Math.sin(v1); break;
        case this.cos:  d = Math.cos(v1); break;
        case this.tan:  d = Math.tan(v1); break;
        case this.asin:  d = Math.asin(v1); break;
        case this.acos:  d = Math.acos(v1); break;
        case this.atan:  d = Math.atan(v1); break;
        case this.abs:  d = Math.abs(v1); break;
        case this.sqrt:  d = Math.sqrt(v1); break;
        case this.partie_entiere:  d = Math.floor(v1); break;
        case this.partie_frac:  d = v1 - Math.floor(v1); break;
        // moyenne: voir Expression.evaluer
        default: return(null);
    }
    return(d);
}

// graphe
function tracer() {
    var graphede = document.getElementById('graphede');
    var fonctionde = document.getElementById('fonctionde');
    var connecter = document.getElementById('connecter');
    var divtableau = document.getElementById('tableau');
    divtableau.style.display = 'none';
    var divgraphe = document.getElementById('graphe');
    divgraphe.style.display = 'block';
    var dim = dimensionsFrame();
    if (dim != null) {
        var divplot = document.getElementById('plot');
        divplot.style.width = dim.width + 'px';
        divplot.style.height = (dim.height - 100) + 'px';
    }
    affGraphe(fonctionde.selectedIndex, graphede.selectedIndex, connecter.checked);
    var ajustement = document.getElementById('ajustement');
    ajustement.disabled = false;
    var input_a = document.getElementById('a');
    input_a.value = '';
    var input_b = document.getElementById('b');
    input_b.value = '';
}

function dimensionsFrame() {
    var w, h;
    if (typeof(window.innerWidth) == 'number') {
        // autre que IE
        w = window.innerWidth;
        h = window.innerHeight;
    } else if ( document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight) ) {
        // IE 6+ en mode 'standards compliant'
        w = document.documentElement.clientWidth;
        h = document.documentElement.clientHeight;
    } else {
        return(null);
    }
    return( {width: w, height: h} );
}

function retour() {
    var divgraphe = document.getElementById('graphe');
    divgraphe.style.display = 'none';
    var divtableau = document.getElementById('tableau');
    divtableau.style.display = 'block';
}

//function affGraphe(int indx, int indy, boolean connect) {
function affGraphe(indx, indy, connect) {
    var xlab = colonnes != null ? colonnes[indx] : String.fromCharCode('A'.charCodeAt(0) + indx);
    var ylab = colonnes != null ? colonnes[indy] : String.fromCharCode('A'.charCodeAt(0) + indy);
    var svx = valeurs[indx];
    var svy = valeurs[indy];
    vx = new Array();
    vy = new Array();
    for (var i=0; i<svx.length; i++) {
        if (svx[i].indexOf("=") == 0)
            vx[i] = calculer(svx[i]);
        else
            vx[i] = doubleOuNull(svx[i]);
    }
    for (var i=0; i<svy.length; i++)
        if (svy[i].indexOf("=") == 0)
            vy[i] = calculer(svy[i]);
        else
            vy[i] = doubleOuNull(svy[i]);
    
    var xticks = [];
    var sansNombreX = true;
    if (vx.length < 2)
        sansNombreX = false;
    for (var i=0; i<vx.length; i++)
        if (vx[i] != null)
            sansNombreX = false;
    if (sansNombreX) {
        xticks.push([0, '']);
        for (var i=0; i<vx.length; i++) {
            vx[i] = i+1;
            xticks.push([i+1, svx[i]]);
        }
        xticks.push([vx.length+1, '']);
    }
    var yticks = [];
    var sansNombreY = true;
    if (vy.length < 2)
        sansNombreY = false;
    for (var i=0; i<vy.length; i++)
        if (vy[i] != null)
            sansNombreY = false;
    if (sansNombreY) {
        yticks.push([0, '']);
        for (var i=0; i<vy.length; i++) {
            vy[i] = i+1;
            yticks.push([i+1, svy[i]]);
        }
        yticks.push([vy.length+1, '']);
    }
    var points = [];
    for (var i=0; i<vx.length; i++)
        if (vx[i] != null && vy[i] != null)
            points.push([vx[i], vy[i]]);
    if (plot != null)
        $('#plot').empty();
    plot = $.jqplot ('plot', [points, []], {
        sortData: false,
        axesDefaults: {
            labelRenderer: $.jqplot.CanvasAxisLabelRenderer
        },
        axes: {
            xaxis: {
                label: xlab,
                ticks: xticks
            },
            yaxis: {
                label: ylab,
                ticks: yticks
            }
        },
        seriesDefaults: {
            lineWidth: 1.5,
            shadow: false
        },
        series : [
            {
                showLine: connect,
                markerOptions: { size: 6, shadow: false }
            },
            {
                showLine: true,
                markerOptions: { show: false }
            }
        ],
        cursor: {
            show: true,
            zoom: true,
            showTooltip: true
        },
        highlighter: {
            show: true,
            useAxesFormatters: false
        }
    });
}

function tracerDroite() {
    var input_a = document.getElementById('a');
    var sa = input_a.value;
    var input_b = document.getElementById('b');
    var sb = input_b.value;
    if (sa == '')
        return;
    var a = doubleOuNull(sa);
    var b = doubleOuNull(sb);
    if (a != null && b != null) {
        plot.series[1].data = new Array();
        for (var i=0; i<vx.length; i++) {
            if (vx[i] != null) {
                var x = vx[i];
                plot.series[1].data.push([x, a*x + b]);
            }
        }
        plot.replot();
        var ajustement = document.getElementById('ajustement');
        ajustement.disabled = false;
    }
}

function ajustement() {
    var n=0;
    for (var i=0; i<vx.length; i++)
        if (vx[i] != null && vy[i] != null)
            n++;
    var tx = new Array(n);
    var ty = new Array(n);
    var j=0;
    for (var i=0; i<vx.length; i++)
        if (vx[i] != null && vy[i] != null) {
            tx[j] = vx[i];
            ty[j] = vy[i];
            j++;
        }
    var tc = fit(tx, ty);
    var y;
    var points = new Array();
    for (var i=0; i<tx.length; i++) {
        y = tc[0]*tx[i] + tc[1];
        points.push([tx[i], y]);
    }
    plot.series[1].data = points;
    plot.replot();
    var input_a = document.getElementById('a');
    input_a.value = joliFormattage(tc[0], 3);
    var input_b = document.getElementById('b');
    input_b.value = joliFormattage(tc[1], 3);
    var ajustement = document.getElementById('ajustement');
    ajustement.disabled = true;
}

// fit droite moindre carrés
 //double[] fit(double[] tx, double[] ty) {
 function fit(tx, ty) {
    var n = tx.length;
    var sx = 0;
    for (var i=0; i<n; i++)
        sx += tx[i];
    var sy = 0;
    for (var i=0; i<n; i++)
        sy += ty[i];
    var sx2 = 0;
    for (var i=0; i<n; i++)
        sx2 += tx[i] * tx[i];
    var sy2 = 0;
    for (var i=0; i<n; i++)
        sy2 += ty[i] * ty[i];
    var sxy = 0;
    for (var i=0; i<n; i++)
        sxy += tx[i] * ty[i];
    var tc = new Array();
    tc[0] = (n*sxy - sx*sy)/(n*sx2 - sx*sx);
    tc[1] = (sy*sx2 - sx*sxy)/(n*sx2 - sx*sx);
    return(tc);
}

function aide() {
    div_aide = document.getElementById('aide');
    if (div_aide.style.display == 'none')
        div_aide.style.display = 'block';
    else
        div_aide.style.display = 'none';
}
