/*

Copyright (C) 2012  Observatoire de Paris

The JavaScript code in this page is free software: you can
redistribute it and/or modify it under the terms of the GNU
General Public License (GNU GPL) as published by the Free Software
Foundation, either version 3 of the License, or (at your option)
any later version.  The code is distributed WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU GPL for more details.

As additional permission under GNU GPL version 3 section 7, you
may distribute non-source (e.g., minimized or compacted) forms of
that code without the copy of the GNU GPL normally required by
section 4, provided you include this license notice and a URL
through which recipients can access the Corresponding Source.

*/

// Cette bibliothèque modifie la hauteur des éléments avec la classe "extensible"
// récursivement de manière à remplir la fenêtre.

// il faut appeler layout_init() à l'initialisation (body.onload)

var layout_globals;

// remarque: il y a un bug dans IE7 quand on spécifie height pour un élément avec padding qui contient un autre avec margin
// (le padding-top disparaît)
// cf http://stackoverflow.com/questions/7667579/ie7-margin-collapses-into-padding

function layout_init() {
    layout_globals = { emtopx: null, lastsize : getWindowWidth() + 'x' + getWindowHeight(), ignorer_resize: false };
    initEmtopx();
    layout(document.body, getWindowHeight());
    if (window.addEventListener) {
        window.addEventListener('resize', resize, false);
    } else if (window.attachEvent) {
        window.attachEvent('onresize', resize);
    }
}

function initEmtopx() {
    var temp = document.createElement("div");
    temp.style.width = '1em';
    document.body.appendChild(temp);
    layout_globals.emtopx = temp.offsetWidth;
    document.body.removeChild(temp);
}

function getWindowHeight() {
    if (window.innerHeight)
        return(window.innerHeight); // dimension parfois folle avec iOS
    if (window.document.documentElement.clientHeight)
        return(window.document.documentElement.clientHeight); // IE7 retire la taille de la scrollbar
    return(window.document.body.clientHeight);
}

function getWindowWidth() {
    if (window.innerWidth)
        return(window.innerWidth);
    if (window.document.documentElement.clientWidth)
        return(window.document.documentElement.clientWidth);
    return(window.document.body.clientWidth);
}

function resize(e) {
    // bidouille pour éviter le pb d'un autre resize causé par le layout
    // (parce-qu'il fait apparaître ou disparaître des scrollbars, par exemple)
    if (layout_globals.ignorer_resize)
        return;
    layout_globals.ignorer_resize = true;
    var s = getWindowWidth() + 'x' + getWindowHeight();
    if (s == layout_globals.lastsize)
        return;
    layout_globals.lastsize = s;
    initHauteurs(document.body);
    window.setTimeout(function() { layout(document.body, getWindowHeight()); }, 0);
}

function initHauteurs(parent) {
    if (parent.style.display == 'none')
        return;
    if ((' ' + parent.className + ' ').indexOf(' extensible ') > -1)
        parent.style.height = 'auto';
    for (var i=0; i<parent.childNodes.length; i++) {
        if (parent.childNodes[i].nodeType == 1) /* element */
            initHauteurs(parent.childNodes[i]);
    }
}

// layout d'un élément avec sa hauteur, border et padding inclus mais sans margin (comme offsetHeight)
function layout(parent, hauteur) {
    if (parent.style.display == 'none')
        return;
    var enfants = parent.childNodes;
    var minimum = parent.offsetHeight;
    // offsetHeight: hauteur avec border et padding, mais sans margin
    // pb si un enfant (ou descendant) a style.overflow = auto : retirer la hauteur correspondante...
    minimum -= hauteur_overflow(parent);
    // pour document.body : offsetHeight ne comprend pas les marges haut et bas des premier et dernier enfants (avec firefox 10)
    if (parent == document.body) {
        minimum = minimum + marge_haut(document.body) + marge_bas(document.body);
    }
    var extensibles = new Array();
    for (var i=0; i<enfants.length; i++) {
        if (enfants[i].nodeType == 1) { /* element */
            var extensible = (((' ' + enfants[i].className + ' ').indexOf(' extensible ') > -1) &&
                enfants[i].style.display != 'none');
            if (extensible)
                extensibles.push(enfants[i]);
        }
    }
    if (minimum < hauteur && extensibles.length > 0) {
        var libre = hauteur - minimum;
        var dh = Math.floor(libre / extensibles.length);
        for (var i=0; i<extensibles.length; i++) {
            var oh = extensibles[i].offsetHeight;
            oh -= hauteur_overflow(extensibles[i]);
            var border = pixels(getStyle(extensibles[i], 'border-top-width')) + pixels(getStyle(extensibles[i], 'border-bottom-width'));
            var padding = pixels(getStyle(extensibles[i], 'padding-top')) + pixels(getStyle(extensibles[i], 'padding-bottom'));
            var vh = oh - border - padding;
            var nh = vh + dh;
            layout(extensibles[i], nh + border + padding);
            // height: sans border ni padding
            extensibles[i].style.height = nh + 'px';
        }
    }
    window.setTimeout(function() { layout_globals.ignorer_resize = false; }, 100);
}

function hauteur_overflow(parent) {
    if (parent.style.display == 'none')
        return(0);
    if (parent.style.overflow == 'auto') {
        var border = pixels(getStyle(parent, 'border-top-width')) + pixels(getStyle(parent, 'border-bottom-width'));
        var padding = pixels(getStyle(parent, 'padding-top')) + pixels(getStyle(parent, 'padding-bottom'));
        return(parent.offsetHeight - pixels('1em') - border - padding);
    }
    var h = 0;
    for (var i=0; i<parent.childNodes.length; i++) {
        var n = parent.childNodes[i];
        if (n.nodeType == 1) { /* element */
            h += hauteur_overflow(n);
        }
    }
    return(h);
}

function marge_haut(elt) {
    var marge_elt = pixels(getStyle(elt, 'margin-top'));
    for (var i=0; i<elt.childNodes.length; i++) {
        var n = elt.childNodes[i];
        if (n.nodeType == 1 && n.style.display != 'none') // élément visible
            return(Math.max(marge_elt, marge_haut(n)));
        else if (n.nodeType == 3 && trim(n.nodeValue) != '') // texte visible
            return(marge_elt);
    }
    return(marge_elt);
}

function marge_bas(elt) {
    var marge_elt = pixels(getStyle(elt, 'margin-bottom'));
    for (var i=elt.childNodes.length - 1; i>=0; i--) {
        var n = elt.childNodes[i];
        if (n.nodeType == 1 && n.style.display != 'none')
            return(Math.max(marge_elt, marge_bas(n)));
        else if (n.nodeType == 3 && trim(n.nodeValue) != '')
            return(marge_elt);
    }
    return(marge_elt);
}

function trim(s) {
    return(s.replace(/^\s+|\s+$/g, ''));
}

function getStyle(oElm, strCssRule) {
    var strValue = '';
    if (document.defaultView && document.defaultView.getComputedStyle) {
        strValue = document.defaultView.getComputedStyle(oElm, '').getPropertyValue(strCssRule);
    } else if (oElm.currentStyle) {
        strCssRule = strCssRule.replace(/\-(\w)/g, function (strMatch, p1){
            return p1.toUpperCase();
        });
        strValue = oElm.currentStyle[strCssRule];
    }
    return strValue;
}

function pixels(c) {
    if (c == 'auto')
        return(0);
    if (c.indexOf('px') > -1)
        return(Number(c.replace('px', '')));
    if (c.indexOf('em') > -1)
        return(layout_globals.emtopx * Number(c.replace('em', '')));
    if (c == 'thin')
        return(1);
    if (c == 'medium')
        return(3); // thin medium et thick dépendent peut-être du navigateur
    if (c == 'think')
        return(5);
    // à faire: convertir d'autres unités...
    return(Number(c));
}
