/*
 * Decompiled with CFR 0.152.
 */
package tablographe;

import COM.Subrahmanyam.table.TElement;
import COM.Subrahmanyam.table.Table;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import ptolemy.plot.Plot;
import xml.Parser_XML;
import xml.XMLTree;

public class TabloGraphe
extends Applet
implements ActionListener {
    static final String texte_aide = "Pour tracer un graphe avec les valeurs d'une colonne par rapport \u00e0 une autre,\ns\u00e9lectionner les deux colonnes (en bas) et cliquer sur tracer, \u00e9ventuellement avec l'option de connexion des points.\nPour calculer les valeurs d'une colonne \u00e0 partir des valeurs des autres colonnes, cliquer sur la premi\u00e8re cellule de cette colonne, cliquer sur la zone de texte en haut, et entrer une expression en commen\u00e7ant par = et utilisant les premi\u00e8res cellules des autres colonnes, par exemple '=A1+B1'. L'expression est calcul\u00e9e automatiquement pour toutes les lignes.\nChaque colonne correspond \u00e0 une lettre de l'alphabet, et chaque ligne \u00e0 un nombre, B3 correspond donc \u00e0 la troisi\u00e8me cellule de la deuxi\u00e8me colonne. On peut aussi utiliser les noms des colonnes, c'est \u00e0 dire le titre qui est affich\u00e9 en gras, par exemple en \u00e9crivant '=T^2/a^3' si 'T' et 'a' sont des titres de colonnes.\nLes op\u00e9rateurs utilisables sont : + - * / ^ (\u00e9valu\u00e9s dans l'ordre usuel).\nLes fonctions connues sont : log ln exp sin cos tan sin acos atan abs sqrt pent pfrac moyenne.\n La fonction pent donne la partie enti\u00e8re d'un nombre (l'entier plus petit le plus grand).\n pfrac(x) donne x - pent(x) .\n moyenne donne la moyenne des valeurs d'une colonne \u00e0 partir de son nom.\nOn peut aussi utiliser des parenth\u00e8ses pour grouper les expressions.\n";
    Table table;
    Label nomCellule;
    TextField champ;
    Choice xchoice;
    Choice ychoice;
    Checkbox check;
    String[][] valeurs = new String[][]{{"1", "2", "3"}, {"4", "5", "6"}, {"", "", ""}};
    String[] colonnes = new String[]{"colonne 1", "colonne 2", "colonne 3"};
    int selr;
    int selc;
    int numdroite;
    int colx = 0;
    int coly = 1;
    boolean connection = false;
    Label labcoord;
    TextField tffita;
    TextField tffitb;
    Double[] vx;
    Double[] vy;
    Plot plot;
    Button bfit;
    Button bdroite;

    public void init() {
        this.lireTable();
        this.affTable();
    }

    public void lireTable() {
        XMLTree xMLTree;
        URL uRL;
        String string = this.getParameter("fichierXML");
        XMLTree xMLTree2 = new XMLTree(null, "", null, "");
        try {
            uRL = new URL(this.getDocumentBase(), string);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("MalformedURLException: " + malformedURLException.getMessage());
            return;
        }
        Parser_XML parser_XML = new Parser_XML(uRL, (OutputStream)System.out, xMLTree2);
        parser_XML.parse(0);
        if (!"TABLE".equalsIgnoreCase(xMLTree2.tag)) {
            System.err.println("Mauvais fichier XML !");
            return;
        }
        int n = 0;
        int n2 = 0;
        XMLTree xMLTree3 = xMLTree2.first_child;
        while (xMLTree3 != null) {
            if ("TR".equalsIgnoreCase(xMLTree3.tag)) {
                if ("TD".equalsIgnoreCase(xMLTree3.first_child.tag)) {
                    ++n;
                }
                if (n2 == 0) {
                    xMLTree = xMLTree3.first_child;
                    while (xMLTree != null) {
                        if ("TH".equalsIgnoreCase(xMLTree.tag) || "TD".equalsIgnoreCase(xMLTree.tag)) {
                            ++n2;
                        }
                        xMLTree = xMLTree.next_brother;
                    }
                }
            }
            xMLTree3 = xMLTree3.next_brother;
        }
        this.valeurs = new String[n2][n];
        this.colonnes = new String[n2];
        xMLTree3 = xMLTree2.first_child;
        int n3 = 0;
        while (xMLTree3 != null) {
            if ("TR".equalsIgnoreCase(xMLTree3.tag)) {
                xMLTree = xMLTree3.first_child;
                int n4 = 0;
                while (xMLTree != null) {
                    if ("TH".equalsIgnoreCase(xMLTree.tag)) {
                        this.colonnes[n4] = xMLTree.val;
                    } else if ("TD".equalsIgnoreCase(xMLTree.tag)) {
                        this.valeurs[n4][n3] = xMLTree.val;
                    }
                    xMLTree = xMLTree.next_brother;
                    ++n4;
                }
                if ("TD".equalsIgnoreCase(xMLTree3.first_child.tag)) {
                    ++n3;
                }
            }
            xMLTree3 = xMLTree3.next_brother;
        }
    }

    public void enregistrerTable(URL uRL) {
        try {
            OutputStream outputStream = uRL.openConnection().getOutputStream();
            this.enregistrerTable(outputStream);
        }
        catch (IOException iOException) {
            System.err.println("enregistrerTable: " + iOException.getMessage());
        }
    }

    public void enregistrerTable(OutputStream outputStream) {
        XMLTree xMLTree = new XMLTree(null, "TABLE", null, "");
        for (int i = 0; i < this.valeurs.length; ++i) {
            XMLTree xMLTree2 = new XMLTree(xMLTree, "TR", null, "");
            xMLTree.addChild(xMLTree2);
            for (int j = 0; j < this.valeurs[i].length; ++j) {
                XMLTree xMLTree3 = new XMLTree(xMLTree2, "TD", null, this.valeurs[i][j]);
                xMLTree2.addChild(xMLTree3);
            }
        }
        xMLTree.writeTree(outputStream, null);
    }

    public void affTable() {
        int n;
        this.selr = -1;
        this.selc = -1;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.table = new Table();
        this.table.setSize(600, 300);
        this.table.showHorizontalSeparator(true);
        this.table.showVerticalSeparator(true);
        this.table.setHiliteMode(2);
        this.table.setClickMode(20);
        this.table.setColors(Color.black, new Color(1.0f, 1.0f, 0.6f), Color.black, Color.white, Color.black, new Color(0.6f, 1.0f, 0.6f));
        for (int i = 0; i < this.valeurs.length; ++i) {
            this.table.addColumn(this.colonnes[i], this.valeurs[i]);
        }
        this.table.addItemListener(new IL());
        this.table.addActionListener(new ALTable());
        this.table.addKeyListener(new TableKeys());
        this.add((Component)this.table, "Center");
        Panel panel = new Panel(new FlowLayout(0));
        this.nomCellule = new Label("      ");
        panel.add(this.nomCellule);
        this.champ = new TextField(40);
        this.champ.addActionListener(new ALChamp());
        panel.add(this.champ);
        Button button = new Button("aide");
        button.addActionListener(new ALAide());
        panel.add(button);
        this.add((Component)panel, "North");
        Panel panel2 = new Panel(new GridLayout(2, 1));
        Panel panel3 = new Panel();
        Label label = new Label("Afficher le graphe de : ");
        panel3.add(label);
        this.ychoice = new Choice();
        for (n = 0; n < this.valeurs.length; ++n) {
            this.ychoice.add(this.colonnes[n]);
        }
        if (this.valeurs.length >= this.coly) {
            this.ychoice.select(this.coly);
        }
        panel3.add(this.ychoice);
        label = new Label(" fonction de : ");
        panel3.add(label);
        this.xchoice = new Choice();
        for (n = 0; n < this.valeurs.length; ++n) {
            this.xchoice.add(this.colonnes[n]);
        }
        if (this.valeurs.length >= this.colx) {
            this.xchoice.select(this.colx);
        }
        panel3.add(this.xchoice);
        panel2.add(panel3);
        Panel panel4 = new Panel();
        this.check = new Checkbox("Connecter les points", this.connection);
        panel4.add(this.check);
        Button button2 = new Button("Tracer");
        button2.addActionListener(this);
        button2.setActionCommand("tracer");
        panel4.add(button2);
        panel2.add(panel4);
        this.add((Component)panel2, "South");
        this.toutRecalculer();
        this.validate();
    }

    public void actionChamp() {
        String string;
        if (this.selr != -1 && this.selc != -1 && !(string = this.champ.getText()).equals(this.valeurs[this.selc][this.selr])) {
            this.valeurs[this.selc][this.selr] = string;
            if (string.startsWith("=") && !"".equals(string = string.substring(1).trim())) {
                Parametre parametre = this.parser(string = this.ajParentheses(string));
                Double d = parametre.evaluer();
                string = d == null ? "" : this.joliFormattage(d, 8);
            }
            this.table.setElement(this.selr, this.selc, string);
            this.toutRecalculer();
            this.table.requestFocus();
            this.copieAuto();
        }
    }

    public void copieAuto() {
        int n;
        int n2;
        int n3;
        String string = this.valeurs[this.selc][this.selr];
        if (this.selr != 0) {
            return;
        }
        if (string == null || !string.startsWith("=") || string.indexOf("moyenne(") != -1) {
            return;
        }
        block2: for (int i = 1; i < string.length(); ++i) {
            n3 = string.charAt(i - 1);
            if (n3 >= 97 && n3 <= 122 || n3 >= 65 && n3 <= 90) continue;
            for (n2 = 0; n2 < this.colonnes.length; ++n2) {
                n = 32;
                if (i + this.colonnes[n2].length() < string.length()) {
                    n = string.charAt(i + this.colonnes[n2].length());
                }
                if (n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || this.colonnes[n2] == null || string.length() < i + this.colonnes[n2].length() || !this.colonnes[n2].equals(string.substring(i, i + this.colonnes[n2].length()))) continue;
                string = string.substring(0, i) + (char)(65 + n2) + "1" + string.substring(i + this.colonnes[n2].length());
                continue block2;
            }
        }
        this.valeurs[this.selc][this.selr] = string;
        for (n3 = 1; n3 < this.valeurs[0].length; ++n3) {
            int n4;
            String string2 = string;
            n2 = -1;
            for (n4 = 0; n4 < string2.length() - 1; ++n4) {
                if (!Character.isLetter(string2.charAt(n4)) || !Character.isDigit(string2.charAt(n4 + 1))) continue;
                n2 = n4;
                break;
            }
            int n5 = n2;
            while (n5 != -1) {
                for (n = n2 + 1; n < string2.length() && string2.charAt(n) >= '0' && string2.charAt(n) <= '9'; ++n) {
                }
                if (n > n2 + 1) {
                    n4 = -1;
                    try {
                        n4 = new Integer(string2.substring(n2 + 1, n));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("NumberFormatException: " + numberFormatException.getMessage());
                        return;
                    }
                    string2 = string2.substring(0, n2 + 1) + (n4 + n3) + string2.substring(n);
                }
                if ((n5 = n2 + 1) >= string2.length()) {
                    n5 = -1;
                } else {
                    n4 = string2.charAt(n5);
                    while (!(n5 >= string2.length() || n4 >= 97 && n4 <= 122 || n4 >= 65 && n4 <= 90)) {
                        if (++n5 >= string2.length()) continue;
                        n4 = string2.charAt(n5);
                    }
                    if (n5 >= string2.length()) {
                        n5 = -1;
                    }
                }
                n2 = n5;
            }
            this.valeurs[this.selc][n3] = string2;
            this.table.setElement(n3, this.selc, string2);
        }
        this.toutRecalculer();
    }

    private Double doubleOuNull(String string) {
        if (string == null) {
            return null;
        }
        try {
            Double d = new Double(string);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void affGraphe(int n, int n2, boolean bl) {
        int n3;
        this.colx = n;
        this.coly = n2;
        String string = this.colonnes[n];
        String string2 = this.colonnes[n2];
        String[] stringArray = this.valeurs[n];
        String[] stringArray2 = this.valeurs[n2];
        this.vx = new Double[stringArray.length];
        this.vy = new Double[stringArray2.length];
        try {
            int n4;
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                this.vx[n4] = stringArray[n4].startsWith("=") ? this.calculer(stringArray[n4]) : this.doubleOuNull(stringArray[n4]);
            }
            for (n4 = 0; n4 < stringArray2.length; ++n4) {
                this.vy[n4] = stringArray2[n4].startsWith("=") ? this.calculer(stringArray2[n4]) : this.doubleOuNull(stringArray2[n4]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("NumberFormatException: " + numberFormatException.getMessage());
        }
        this.removeAll();
        this.plot = new Plot();
        this.add((Component)this.plot, "Center");
        this.plot.setMarksStyle("cross");
        this.plot.setConnected(bl);
        this.plot.setXLabel(string);
        this.plot.setYLabel(string2);
        boolean bl2 = true;
        if (this.vx.length < 2) {
            bl2 = false;
        }
        for (n3 = 0; n3 < this.vx.length; ++n3) {
            if (this.vx[n3] == null) continue;
            bl2 = false;
        }
        if (bl2) {
            for (n3 = 0; n3 < this.vx.length; ++n3) {
                this.vx[n3] = new Double(n3 + 1);
                this.plot.addXTick(stringArray[n3], n3 + 1);
            }
        }
        for (n3 = 0; n3 < this.vx.length; ++n3) {
            if (this.vx[n3] == null || this.vy[n3] == null) continue;
            this.plot.addPoint(0, this.vx[n3], this.vy[n3], true);
        }
        this.plot.addMouseMotionListener(new MML());
        Panel panel = new Panel(new GridLayout(2, 1));
        this.labcoord = new Label();
        panel.add(this.labcoord);
        Panel panel2 = new Panel(new FlowLayout());
        this.bfit = new Button("Ajustement");
        this.bfit.addActionListener(this);
        this.bfit.setActionCommand("fit");
        panel2.add(this.bfit);
        panel2.add(new Label("fit: a="));
        this.tffita = new TextField(6);
        panel2.add(this.tffita);
        panel2.add(new Label(" b="));
        this.tffitb = new TextField(6);
        panel2.add(this.tffitb);
        this.bdroite = new Button("Tracer");
        this.bdroite.addActionListener(this);
        this.bdroite.setActionCommand("droite");
        this.numdroite = 1;
        panel2.add(this.bdroite);
        Button button = new Button("Revenir au tableau");
        button.addActionListener(this);
        button.setActionCommand("tableau");
        panel2.add(button);
        panel.add(panel2);
        this.add((Component)panel, "South");
        this.plot.setVisible(true);
        this.validate();
    }

    public String joliFormattage(double d, int n) {
        String string;
        double d2 = Math.pow(10.0, n);
        int n2 = (int)Math.floor(Math.log(Math.abs(d)) / Math.log(10.0));
        double d3 = d / Math.pow(10.0, n2);
        if (n2 == 0) {
            d3 = (double)Math.round(d3 * d2) / d2;
            string = "" + d3;
        } else if (n2 == 1) {
            d3 = (double)Math.round(d3 * d2) / (d2 / 10.0);
            string = "" + d3;
        } else if (n2 == -1) {
            String string2 = d3 < 0.0 ? "-" : "";
            d3 = Math.abs(Math.round(d3 * d2));
            string = string2 + "0." + (int)d3;
        } else {
            d3 = (double)Math.round(d3 * d2) / d2;
            string = d3 + "E" + n2;
        }
        return string;
    }

    public void tracerDroite() {
        String string = this.tffita.getText();
        String string2 = this.tffitb.getText();
        Double d = this.doubleOuNull(string);
        Double d2 = this.doubleOuNull(string2);
        if (d != null && d2 != null) {
            ++this.numdroite;
            this.plot.setMarksStyle("none", this.numdroite);
            this.plot.setConnected(true);
            double d3 = d;
            double d4 = d2;
            this.plot.setMarksStyle("none", 1);
            this.plot.setConnected(true);
            for (int i = 0; i < this.vx.length; ++i) {
                if (this.vx[i] == null) continue;
                double d5 = this.vx[i];
                this.plot.addPoint(this.numdroite, d5, d3 * d5 + d4, true);
            }
        }
    }

    public void doFit() {
        int n = 0;
        for (int i = 0; i < this.vx.length; ++i) {
            if (this.vx[i] == null || this.vy[i] == null) continue;
            ++n;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        for (int i = 0; i < this.vx.length; ++i) {
            if (this.vx[i] == null || this.vy[i] == null) continue;
            dArray[n2] = this.vx[i];
            dArray2[n2] = this.vy[i];
            ++n2;
        }
        double[] dArray3 = this.fit(dArray, dArray2);
        this.plot.setMarksStyle("none", 1);
        this.plot.setConnected(true);
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray3[0] * dArray[i] + dArray3[1];
            this.plot.addPoint(1, dArray[i], d, true);
        }
        this.tffita.setText(this.joliFormattage(dArray3[0], 3));
        this.tffitb.setText(this.joliFormattage(dArray3[1], 3));
        this.bfit.setEnabled(false);
        this.validate();
    }

    public double[] fit(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += dArray2[i];
        }
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += dArray[i] * dArray[i];
        }
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            d4 += dArray2[i] * dArray2[i];
        }
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            d5 += dArray[i] * dArray2[i];
        }
        double[] dArray3 = new double[]{((double)n * d5 - d * d2) / ((double)n * d3 - d * d), (d2 * d3 - d * d5) / ((double)n * d3 - d * d)};
        return dArray3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("tableau".equals(string)) {
            this.affTable();
        } else if ("tracer".equals(string)) {
            int n = this.xchoice.getSelectedIndex();
            int n2 = this.ychoice.getSelectedIndex();
            this.connection = this.check.getState();
            this.affGraphe(n, n2, this.connection);
        } else if ("fit".equals(string)) {
            this.doFit();
        } else if ("droite".equals(string)) {
            this.tracerDroite();
        }
    }

    public void toutRecalculer() {
        for (int i = 0; i < this.valeurs.length; ++i) {
            for (int j = 0; j < this.valeurs[i].length; ++j) {
                String string = this.valeurs[i][j];
                if (!string.startsWith("=")) continue;
                Double d = this.calculer(string);
                string = d == null ? "" : this.joliFormattage(d, 8);
                this.table.setElement(j, i, string);
            }
        }
    }

    public Double calculer(String string) {
        if ("".equals(string = string.substring(1).trim())) {
            return null;
        }
        string = this.ajParentheses(string);
        Parametre parametre = this.parser(string);
        Double d = parametre.evaluer();
        return d;
    }

    public String valeurCellule(String string) {
        if (string.length() < 2) {
            return null;
        }
        string = string.toUpperCase();
        char c = string.charAt(0);
        int n = c - 65 + 1;
        int n2 = -1;
        try {
            n2 = new Integer(string.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("NumberFormatException: " + numberFormatException.getMessage());
            return null;
        }
        if (n < 1 || n > this.valeurs.length || n2 < 1 || n2 > this.valeurs[0].length) {
            return null;
        }
        return this.valeurs[n - 1][n2 - 1];
    }

    public String ajParentheses(String string) {
        String string2 = "^/*-+";
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            int n = string.indexOf(c);
            if (n > 0 && "^*/-+Ee".indexOf(string.charAt(n - 1)) != -1) {
                n = -1;
            }
            int n2 = n;
            int n3 = 32;
            int n4 = 32;
            while (n2 != -1) {
                int n5;
                boolean bl = false;
                int n6 = n - 1;
                if (n6 >= 0) {
                    n3 = string.charAt(n6);
                }
                int n7 = 0;
                while (n6 >= 0 && (n7 != 0 || n3 != 40) && (n7 != 0 || string2.indexOf(n3) == -1 || n6 > 0 && "^*/-+Ee".indexOf(string.charAt(n6 - 1)) != -1)) {
                    if (n3 == 41) {
                        ++n7;
                    } else if (n3 == 40) {
                        --n7;
                    }
                    if (--n6 < 0) continue;
                    n3 = string.charAt(n6);
                }
                if (n6 < 0 || string2.indexOf(n3) != -1) {
                    bl = true;
                }
                if ((n5 = n + 1) >= 0) {
                    n4 = string.charAt(n5);
                }
                n7 = 0;
                while (n5 < string.length() && (n7 != 0 || n4 != 41) && (n7 != 0 || string2.indexOf(n4) == -1 || n5 > 0 && "^*/-+Ee".indexOf(string.charAt(n5 - 1)) != -1)) {
                    if (n4 == 40) {
                        ++n7;
                    } else if (n4 == 41) {
                        --n7;
                    }
                    if (++n5 >= string.length()) continue;
                    n4 = string.charAt(n5);
                }
                if (n5 >= string.length() || string2.indexOf(n4) != -1) {
                    bl = true;
                }
                if (bl) {
                    string = string.substring(0, n6 + 1) + "(" + string.substring(n6 + 1, n5) + ")" + string.substring(n5);
                    ++n;
                }
                n2 = string.substring(n + 1).indexOf(c);
                n = n2 + n + 1;
            }
        }
        return string;
    }

    public Parametre parser(String string) {
        int n;
        int n2;
        int n3;
        String string2 = "^/*-+";
        if (string.charAt(0) == '(' && string.charAt(string.length() - 1) == ')') {
            n3 = 1;
            n2 = 0;
            for (n = 1; n < string.length() - 1; ++n) {
                if (string.charAt(n) == '(') {
                    ++n2;
                } else if (string.charAt(n) == ')') {
                    --n2;
                }
                if (n2 >= 0) continue;
                n3 = 0;
                break;
            }
            if (n3 != 0) {
                string = string.substring(1, string.length() - 1);
            }
        }
        n3 = -1;
        n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (n2 == 0 && string2.indexOf(string.charAt(n)) != -1 && (n == 0 || "^*/-+Ee".indexOf(string.charAt(n - 1)) == -1)) {
                n3 = n;
                break;
            }
            if (string.charAt(n) == '(') {
                ++n2;
                continue;
            }
            if (string.charAt(n) != ')') continue;
            --n2;
        }
        if (n3 == -1) {
            int n4;
            n = 1;
            for (n4 = 0; n4 < string.length(); ++n4) {
                if ("0123456789.,-+ ".indexOf(string.charAt(n4)) != -1 || (string.charAt(n4) == 'E' || string.charAt(n4) == 'e') && n4 != 0 && "0123456789".indexOf(string.charAt(n4 - 1)) != -1) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                double d;
                try {
                    d = new Double(string);
                }
                catch (NumberFormatException numberFormatException) {
                    d = 0.0;
                }
                return new Nombre(d);
            }
            n4 = string.indexOf(40);
            if (n4 != -1 && string.charAt(string.length() - 1) == ')') {
                Fonction fonction = new Fonction(string.substring(0, n4));
                int n5 = 0;
                Parametre parametre = null;
                Parametre parametre2 = null;
                n5 = (string = string.substring(n4 + 1, string.length() - 1)).indexOf(44);
                if (n5 != -1) {
                    parametre = this.parser(string.substring(0, n5).trim());
                    string = string.substring(n5 + 1);
                    parametre2 = this.parser(string.trim());
                } else {
                    parametre = this.parser(string.trim());
                }
                return new Expression(fonction, parametre, parametre2);
            }
            return new Variable(string);
        }
        Fonction fonction = new Fonction(string.charAt(n3));
        String string3 = string.substring(0, n3).trim();
        if ("".equals(string3)) {
            string3 = "0";
        }
        Parametre parametre = this.parser(string3);
        String string4 = string.substring(n3 + 1).trim();
        Parametre parametre3 = this.parser(string4);
        return new Expression(fonction, parametre, parametre3);
    }

    public double moyenne(int n) {
        double d = 0.0;
        int n2 = 0;
        for (int i = 0; i < this.valeurs[n].length; ++i) {
            Double d2;
            String string = this.valeurs[n][i];
            if (string != null && string.startsWith("=")) {
                string = this.table.getElement(i, n);
            }
            if ((d2 = this.doubleOuNull(string)) == null) continue;
            d += d2.doubleValue();
            ++n2;
        }
        return d / (double)n2;
    }

    class InfoWindow
    extends Frame
    implements ActionListener {
        public InfoWindow(String string, String string2) {
            this.setTitle(string);
            this.setLayout(new BorderLayout());
            int n = 5;
            if (string2.length() > 200) {
                n = 10;
            }
            TextArea textArea = new TextArea(string2, n, 60, 1);
            textArea.setEditable(false);
            this.add("Center", textArea);
            Button button = new Button("OK");
            button.addActionListener(this);
            Panel panel = new Panel();
            panel.add(button);
            this.add("South", panel);
            this.pack();
            textArea.setCaretPosition(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ((Component)InfoWindow.this).setVisible(false);
                    InfoWindow.this.dispose();
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    class Fonction {
        int type;
        static final int addition = 1;
        static final int soustraction = 2;
        static final int multiplication = 3;
        static final int division = 4;
        static final int puissance = 5;
        static final int logdecimal = 6;
        static final int ln = 7;
        static final int exp = 8;
        static final int sin = 9;
        static final int cos = 10;
        static final int tan = 11;
        static final int asin = 12;
        static final int acos = 13;
        static final int atan = 14;
        static final int abs = 15;
        static final int sqrt = 16;
        static final int partie_entiere = 17;
        static final int partie_frac = 18;
        static final int moyenne = 19;

        public Fonction(char c) {
            switch (c) {
                case '+': {
                    this.type = 1;
                    break;
                }
                case '-': {
                    this.type = 2;
                    break;
                }
                case '*': {
                    this.type = 3;
                    break;
                }
                case '/': {
                    this.type = 4;
                    break;
                }
                case '^': {
                    this.type = 5;
                    break;
                }
                default: {
                    this.type = 0;
                }
            }
        }

        public Fonction(String string) {
            this.type = "log".equals(string) ? 6 : ("ln".equals(string) ? 7 : ("exp".equals(string) ? 8 : ("sin".equals(string) ? 9 : ("cos".equals(string) ? 10 : ("tan".equals(string) ? 11 : ("asin".equals(string) ? 12 : ("acos".equals(string) ? 13 : ("atan".equals(string) ? 14 : ("abs".equals(string) ? 15 : ("sqrt".equals(string) ? 16 : ("pent".equals(string) ? 17 : ("pfrac".equals(string) ? 18 : ("moyenne".equals(string) ? 19 : 0)))))))))))));
        }

        public Double evaluer(double d, double d2) {
            double d3;
            switch (this.type) {
                case 1: {
                    d3 = d + d2;
                    break;
                }
                case 2: {
                    d3 = d - d2;
                    break;
                }
                case 3: {
                    d3 = d * d2;
                    break;
                }
                case 4: {
                    d3 = d / d2;
                    break;
                }
                case 5: {
                    d3 = Math.pow(d, d2);
                    break;
                }
                case 6: {
                    d3 = Math.log(d) / Math.log(10.0);
                    break;
                }
                case 7: {
                    d3 = Math.log(d);
                    break;
                }
                case 8: {
                    d3 = Math.exp(d);
                    break;
                }
                case 9: {
                    d3 = Math.sin(d);
                    break;
                }
                case 10: {
                    d3 = Math.cos(d);
                    break;
                }
                case 11: {
                    d3 = Math.tan(d);
                    break;
                }
                case 12: {
                    d3 = Math.asin(d);
                    break;
                }
                case 13: {
                    d3 = Math.acos(d);
                    break;
                }
                case 14: {
                    d3 = Math.atan(d);
                    break;
                }
                case 15: {
                    d3 = Math.abs(d);
                    break;
                }
                case 16: {
                    d3 = Math.sqrt(d);
                    break;
                }
                case 17: {
                    d3 = Math.floor(d);
                    break;
                }
                case 18: {
                    d3 = d - Math.floor(d);
                    break;
                }
                default: {
                    return null;
                }
            }
            return new Double(d3);
        }
    }

    static class Nombre
    implements Parametre {
        double valeur;

        public Nombre(double d) {
            this.valeur = d;
        }

        public Double evaluer() {
            return new Double(this.valeur);
        }
    }

    class Variable
    implements Parametre {
        String nom;

        public Variable(String string) {
            this.nom = string;
        }

        public Double evaluer() {
            int n;
            if (this.nom == null) {
                return null;
            }
            if ("e".equals(this.nom)) {
                return new Double(Math.E);
            }
            if ("pi".equals(this.nom)) {
                return new Double(Math.PI);
            }
            String string = TabloGraphe.this.valeurCellule(this.nom);
            if (string == null) {
                for (n = 0; n < TabloGraphe.this.colonnes.length; ++n) {
                    if (!this.nom.equals(TabloGraphe.this.colonnes[n])) continue;
                    string = TabloGraphe.this.valeurCellule((char)(65 + n) + "1");
                    break;
                }
            }
            if (string == null) {
                return null;
            }
            if (string.startsWith("=")) {
                this.nom = this.nom.toUpperCase();
                n = this.nom.charAt(0);
                int n2 = n - 65;
                int n3 = -1;
                try {
                    n3 = new Integer(this.nom.substring(1)) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("NumberFormatException: " + numberFormatException.getMessage());
                    return null;
                }
                string = TabloGraphe.this.table.getElement(n3, n2);
                if (string == null) {
                    return null;
                }
            }
            try {
                Double d = new Double(string);
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("NumberFormatException: " + numberFormatException.getMessage());
                return null;
            }
        }
    }

    static interface Parametre {
        public Double evaluer();
    }

    class Expression
    implements Parametre {
        Fonction fct;
        Parametre p1;
        Parametre p2;

        public Expression(Fonction fonction, Parametre parametre, Parametre parametre2) {
            this.fct = fonction;
            this.p1 = parametre;
            this.p2 = parametre2;
        }

        public Double evaluer() {
            if (this.fct.type == 19) {
                int n;
                if (!(this.p1 instanceof Variable)) {
                    return null;
                }
                String string = ((Variable)this.p1).nom;
                int n2 = -1;
                if (string.length() == 1 && (n = Character.toUpperCase(string.charAt(0))) >= 65 && n <= 90) {
                    n2 = n - 65;
                }
                if (n2 == -1) {
                    for (n = 0; n < TabloGraphe.this.colonnes.length; ++n) {
                        if (!string.equals(TabloGraphe.this.colonnes[n])) continue;
                        n2 = n;
                    }
                }
                if (n2 == -1) {
                    return null;
                }
                return new Double(TabloGraphe.this.moyenne(n2));
            }
            if (this.p2 == null) {
                Double d = this.p1.evaluer();
                if (d == null) {
                    return null;
                }
                return this.fct.evaluer(d, 0.0);
            }
            Double d = this.p1.evaluer();
            Double d2 = this.p2.evaluer();
            if (d == null || d2 == null) {
                return null;
            }
            return this.fct.evaluer(d, d2);
        }
    }

    class MML
    implements MouseMotionListener {
        MML() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            double[] dArray = TabloGraphe.this.plot.getPointCoordinates(mouseEvent.getX(), mouseEvent.getY());
            TabloGraphe.this.labcoord.setText("x=" + TabloGraphe.this.joliFormattage(dArray[0], 3) + "  y=" + TabloGraphe.this.joliFormattage(dArray[1], 3));
            TabloGraphe.this.validate();
        }
    }

    class TableKeys
    extends KeyAdapter {
        TableKeys() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 38: {
                    this.move(-1, 0);
                    break;
                }
                case 40: {
                    this.move(1, 0);
                    break;
                }
                case 37: {
                    this.move(0, -1);
                    break;
                }
                case 39: {
                    this.move(0, 1);
                    break;
                }
                case 10: {
                    TabloGraphe.this.champ.requestFocus();
                }
            }
        }

        public void move(int n, int n2) {
            Object[] objectArray = TabloGraphe.this.table.getSelectedObjects();
            if (objectArray != null && objectArray.length > 0) {
                TElement tElement = (TElement)objectArray[0];
                int n3 = tElement.getRow();
                int n4 = tElement.getColumn();
                if (n3 + n >= 0 && n3 + n < TabloGraphe.this.valeurs[0].length && n4 + n2 >= 0 && n4 + n2 < TabloGraphe.this.valeurs.length) {
                    if (n != 0) {
                        TabloGraphe.this.table.selectRow(n3);
                        TabloGraphe.this.table.selectRow(n3 + n);
                    }
                    if (n2 != 0) {
                        TabloGraphe.this.table.selectColumn(n4);
                        TabloGraphe.this.table.selectColumn(n4 + n2);
                    }
                    TabloGraphe.this.selr = n3 + n;
                    TabloGraphe.this.selc = n4 + n2;
                    TabloGraphe.this.nomCellule.setText((char)(65 + TabloGraphe.this.selc) + "" + (TabloGraphe.this.selr + 1) + " ");
                    TabloGraphe.this.champ.setText(TabloGraphe.this.valeurs[TabloGraphe.this.selc][TabloGraphe.this.selr]);
                }
            }
        }
    }

    class ALAide
    implements ActionListener {
        ALAide() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InfoWindow infoWindow = new InfoWindow("Aide", TabloGraphe.texte_aide);
            Point point = TabloGraphe.this.getLocationOnScreen();
            ((Component)infoWindow).setLocation(point.x + 50, point.y + 50);
            ((Component)infoWindow).setVisible(true);
        }
    }

    class ALChamp
    implements ActionListener {
        ALChamp() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabloGraphe.this.actionChamp();
        }
    }

    class ALTable
    implements ActionListener {
        ALTable() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabloGraphe.this.selr = TabloGraphe.this.table.getSelRowIndex();
            TabloGraphe.this.selc = TabloGraphe.this.table.getSelColumnIndex();
            TabloGraphe.this.champ.requestFocus();
        }
    }

    class IL
    implements ItemListener {
        IL() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                TabloGraphe.this.actionChamp();
                Object[] objectArray = TabloGraphe.this.table.getSelectedObjects();
                if (objectArray.length > 0) {
                    TElement tElement = (TElement)objectArray[0];
                    TabloGraphe.this.selr = tElement.getRow();
                    TabloGraphe.this.selc = tElement.getColumn();
                    TabloGraphe.this.nomCellule.setText((char)(65 + TabloGraphe.this.selc) + "" + (TabloGraphe.this.selr + 1) + " ");
                    TabloGraphe.this.champ.setText(TabloGraphe.this.valeurs[TabloGraphe.this.selc][TabloGraphe.this.selr]);
                    TabloGraphe.this.table.requestFocus();
                }
            }
        }
    }
}

