/*
 * Decompiled with CFR 0.152.
 */
package COM.Subrahmanyam.table;

import COM.Subrahmanyam.table.TColors;
import COM.Subrahmanyam.table.TGrid;
import COM.Subrahmanyam.table.TObject;
import COM.Subrahmanyam.table.Table;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;

class TableComponent
extends Canvas {
    protected int noRows;
    protected int noColumns;
    protected Font font;
    protected int ydiff;
    protected TObject[][] tObjects;
    protected Table parent;
    protected int focusedElement;
    protected TGrid grid = new TGrid();
    protected TColors colors = new TColors();
    protected int[] scaleArr;

    TableComponent() {
        this.enableEvents(48L);
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.enableEvents(48L);
        } else {
            this.disableEvents(48L);
        }
    }

    public void setFont(Font font) {
        this.font = font != null ? font : new Font("SansSerif", 0, 12);
        super.setFont(font);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = fontMetrics.getLeading() + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        this.grid.setLineHeight(n);
    }

    Font getFont(Font font) {
        return this.font;
    }

    int getNoColumns() {
        try {
            int n = this.tObjects[0].length;
            return n / 2 + 1;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    int getNoRows() {
        try {
            return this.tObjects.length;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    protected void setXGrid(int n) {
        if (this.noRows > 0 && this.noColumns > 0) {
            int n2;
            int n3 = (int)((float)n / (float)this.noColumns);
            if (this.grid == null) {
                this.grid = new TGrid();
            }
            this.setFont(this.font);
            int[] nArray = new int[2 * this.noColumns];
            nArray[0] = 0;
            for (n2 = 1; n2 < this.noColumns; ++n2) {
                nArray[2 * n2] = nArray[2 * n2 - 2] + n3;
            }
            for (n2 = 0; n2 < this.noColumns - 1; ++n2) {
                nArray[2 * n2 + 1] = nArray[2 * n2 + 2] - this.grid.getSepWidth();
            }
            nArray[nArray.length - 1] = n;
            this.grid.setXArr(nArray);
            nArray = null;
        }
    }

    protected void setYGrid() {
        if (this.noRows > 0 && this.noColumns > 0) {
            int[] nArray = new int[this.noRows + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i * this.grid.getLineHeight();
            }
            this.grid.setYArr(nArray);
        }
    }

    protected void setYGrid(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i * this.grid.getLineHeight();
        }
        this.grid.setYArr(nArray);
    }

    int getLineHeight() {
        return this.grid.getLineHeight();
    }

    protected void resetYGrid() {
        this.setYGrid();
    }

    void scaleX(float f) {
        this.grid.scaleX(f);
    }

    void setColors(TColors tColors) {
        this.colors = tColors;
        try {
            for (int i = 0; i < this.tObjects.length; ++i) {
                for (int j = 0; j < this.tObjects[i].length; ++j) {
                    this.tObjects[i][j].setColors(tColors);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.repaint();
    }

    void setColors(int n, int n2, TColors tColors) {
        try {
            if (n == -1) {
                for (int i = 0; i < this.noRows; ++i) {
                    this.tObjects[i][n2].setColors(tColors);
                }
            } else if (n2 == -1) {
                for (int i = 0; i < this.noColumns; ++i) {
                    this.tObjects[n][2 * i].setColors(tColors);
                }
            } else {
                this.tObjects[n][2 * n2].setColors(tColors);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.repaint();
    }

    void resetGrid() {
        if (this.noColumns > 0) {
            this.grid.setXWidth(this.getSize().width);
            this.setYGrid();
        }
    }

    void setScale(int[] nArray) {
        this.scaleArr = nArray;
        this.grid.setWeights(nArray);
    }

    int[] getScale() {
        return this.grid.getWeights();
    }
}

