/*
 * Decompiled with CFR 0.152.
 */
package COM.Subrahmanyam.table;

import COM.Subrahmanyam.table.TColors;
import COM.Subrahmanyam.table.TGrid;
import COM.Subrahmanyam.table.TObject;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;

class THeadObject
extends TObject {
    private static String FILL = "J";
    private int xpos;
    private int ypos;
    Rectangle border;
    Color backGround;
    int borderThickness = 2;

    public THeadObject(String string, int n, int n2) {
        super(string, n, n2);
        this.border = new Rectangle();
        this.backGround = new Color(155, 155, 155);
    }

    public THeadObject(String string, int n, int n2, TColors tColors) {
        super(string, n, n2, tColors);
        this.border = new Rectangle();
        this.backGround = tColors.getNormalBG();
    }

    public THeadObject(String string, int n, int n2, TGrid tGrid) {
        super(string, n, n2);
        this.border = this.getRectangle(tGrid);
        this.backGround = new Color(192, 192, 192);
    }

    public THeadObject(String string, int n, int n2, TGrid tGrid, TColors tColors) {
        super(string, n, n2, tColors);
        this.border = this.getRectangle(tGrid);
        this.backGround = tColors.getNormalBG();
    }

    public void paint(Graphics graphics, TGrid tGrid) {
        this.border = this.getRectangle(tGrid);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(graphics.getFont());
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getMaxAscent();
        int n3 = fontMetrics.getLeading();
        int n4 = (this.border.height - n) / 2;
        this.xpos = this.border.x + fontMetrics.stringWidth(FILL);
        this.ypos = this.border.y + n4 + n2 + n3;
        this.borderPaint(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setClip(this.border.x, this.border.y, this.border.width - this.borderThickness, this.border.height);
        graphics.setColor(this.colors.getNormalFG());
        graphics.drawString(this.name, this.xpos, this.ypos);
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("THeadObject: ");
        stringBuffer.append(this.iIndex + " " + this.jIndex + "\n");
        return stringBuffer.toString();
    }

    void borderPaint(Graphics graphics) {
        graphics.setColor(this.backGround);
        graphics.fillRect(this.border.x, this.border.y, this.border.width, this.border.height);
        for (int i = 0; i < this.borderThickness; ++i) {
            graphics.setColor(this.backGround.brighter());
            graphics.drawLine(this.border.x + i, this.border.y + i, this.border.x + i, this.border.y + this.border.height - this.borderThickness - i);
            graphics.drawLine(this.border.x + i, this.border.y + i, this.border.x + this.border.width - this.borderThickness - i, this.border.y + i);
            graphics.setColor(this.backGround.darker());
            graphics.drawLine(this.border.x + i, this.border.y + this.border.height - this.borderThickness - i, this.border.x + this.border.width - this.borderThickness - i, this.border.y + this.border.height - this.borderThickness - i);
            graphics.drawLine(this.border.x + this.border.width - this.borderThickness - i, this.border.y + i, this.border.x + this.border.width - this.borderThickness - i, this.border.y + this.border.height - this.borderThickness - i);
        }
    }
}

