/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Liste de valeurs accessibles par leur nom. Plusieurs valeurs avec le même nom
 * sont stockées sous forme de Vector à partir de la deuxième valeur.
 */
function ListeValeurs() {
    this.valeurs = {};
    this.vNoms = new Array(); // ajouté pour permettre de conserver l'ordre des valeurs
}

/**
 * Ajoute une paire (nom, valeur) à la liste. Si une valeur existe déjà
 * pour ce nom, un tableau (Vector) est créé pour contenir les valeurs
 * correspondant au nom. Dans ce dernier cas, un Vector sera renvoyé lors
 * d'un appel à lire.
 */
//public void ajouter(String nom, Object valeur) {
ListeValeurs.prototype.ajouter = function(nom, valeur) {
    var o, v;
    if (this.valeurs.hasOwnProperty(nom)) {
        o = this.valeurs[nom];
        if (Object.prototype.toString.call(o) === '[object Array]')
            o.push(valeur);
        else {
            v = new Array();
            v.push(o);
            v.push(valeur);
            this.valeurs[nom] = v;
        }
    } else {
        this.valeurs[nom] = valeur;
        this.vNoms.push(nom);
    }
}

// remarque : ces fonctions ajouterXXX n'ont pas beaucoup de sens en Javascript...

//public void ajouterString(String nom, String valeur) {
ListeValeurs.prototype.ajouterString = function(nom, valeur) {
    this.ajouter(nom, valeur);
}

//public void ajouterDouble(String nom, double valeur) {
ListeValeurs.prototype.ajouterDouble = function(nom, valeur) {
    this.ajouter(nom, valeur);
}

//public void ajouterEntier(String nom, int valeur) {
ListeValeurs.prototype.ajouterEntier = function(nom, valeur) {
    this.ajouter(nom, valeur);
}

//public void ajouterBooleen(String nom, boolean valeur) {
ListeValeurs.prototype.ajouterBooleen = function(nom, valeur) {
    this.ajouter(nom, valeur);
}

/**
 * Renvoit la valeur correspondant au nom. Si aucune valeur n'a été entrée pour ce nom,
 * lance une erreur SimuException.
 */
//public Object lire(String nom) throws SimuException {
ListeValeurs.prototype.lire = function(nom) {
    var o = this.valeurs[nom];
    if (o == null)
        throw new Error(Messages.get('aucune_valeur') + ': ' + nom);
    return(o);
}

/**
 * Renvoit la valeur correspondant au nom, sous forme de String. Si la valeur
 * entrée était un Double, elle est convertie en String.
 */
//public String lireString(String nom) throws SimuException {
ListeValeurs.prototype.lireString = function(nom) {
    var o = this.lire(nom);
    return('' + o);
}

/**
 * Renvoit la valeur correspondant au nom, sous forme de double. Si la valeur
 * entrée était un String, elle est convertie en double.
 */
//public double lireDouble(String nom) throws SimuException {
ListeValeurs.prototype.lireDouble = function(nom) {
    var o, d;
    o = this.lire(nom);
    if (typeof o != 'number')
        d = Number(o);
    else
        d = o;
    return(d);
}

//public int lireEntier(String nom) throws SimuException {
ListeValeurs.prototype.lireEntier = function(nom) {
    var o, e;
    o = this.lire(nom);
    if (typeof o == 'string')
        e = parseInt(o);
    else if (typeof o == 'number')
        e = o.toFixed();
    else
        e = (Number(o)).toFixed();
    return(e);
}

//public boolean lireBooleen(String nom) throws SimuException {
ListeValeurs.prototype.lireBooleen = function(nom) {
    var o, b;
    o = this.lire(nom);
    if (typeof o == 'string')
        b = (o == 'true');
    else if (typeof o == 'number')
        b = (o != 0);
    else
        b = o;
    return(b);
}

ListeValeurs.prototype.taille = function() {
    return(this.vNoms.length);
}

/**
 * Renvoit la liste de tous les noms, sous forme de Vector.
 */
ListeValeurs.prototype.noms = function() {
    return(this.vNoms);
}

