/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Zone d'affichage d'une image pour AffImage.
 */
//public class ImageCanvas extends Canvas {
//public ImageCanvas(int initialWidth, int initialHeight, IndexColorModel palette) {
function ImageCanvas(initialWidth, initialHeight, palette) {
    this.imagedata = null;
    this.delai = 100; // en ms
    this.w = initialWidth;
    this.h = initialHeight;
    this.palette = palette; // tableau [0-255][0..2] des couleurs RVB
    //this.size = {'width': this.w, 'height': this.h};
    this.source = null;
    
    this.canvas = document.createElement('canvas');
    this.canvas.setAttribute('width', this.w);
    this.canvas.setAttribute('height', this.h);
    this.ctx = this.canvas.getContext('2d');
}

ImageCanvas.prototype.getCanvas = function() {
    return(this.canvas);
}

//public void updateImage(double[][] tval) throws SimuException {
//public void updateImage(Image im) throws SimuException {
ImageCanvas.prototype.updateImage = function(param) {
    var tval, index, j, i, v;
    
    if (param.nodeName == 'CANVAS') {
        if (param.width != this.w)
            throw new Error('Longueur image ' + param.width + ' != ' + this.w);
        if (param.height != this.h)
            throw new Error('Largeur image ' + param.height + ' != ' + this.h);
        
        this.ctx.drawImage(param, 0, 0);
        return;
    }
    
    tval = param;
    if (this.imagedata == null)
        this.imagedata = this.ctx.createImageData(this.w, this.h);
    if (tval.length != this.w)
        throw new Error(Messages.get('longueur_image') + ' ' + tval.length + ' != ' + this.w);
    if (tval[0].length != this.h)
        throw new Error(Messages.get('largeur_image') + ' ' + tval[0].length + ' != ' + this.h);
    index = 0;
    if (this.palette == null) {
        for (j=0; j<this.h; j++) {
            for (i=0; i<this.w; i++) {
                v = Math.round(tval[i][j]);
                this.imagedata.data[index++] = v; // red
                this.imagedata.data[index++] = v; // green
                this.imagedata.data[index++] = v; // blue
                this.imagedata.data[index++] = 255; // alpha
            }
        }
    } else {
        for (j=0; j<this.h; j++) {
            for (i=0; i<this.w; i++) {
                v = Math.round(tval[i][j]);
                this.imagedata.data[index++] = this.palette[v][0];
                this.imagedata.data[index++] = this.palette[v][1];
                this.imagedata.data[index++] = this.palette[v][2];
                this.imagedata.data[index++] = 255;
            }
        }
    }
    this.ctx.putImageData(this.imagedata, 0, 0);
}
