/*
SimuLab
Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Gestion du temps.
 */
//public Chronos(SimuApplet applet, TypeAffichage typeAff, boolean boucle) {
function Chronos(applet, typeAff, boucle, delai) {
    this.applet = applet; // SimuApplet
    this.typeAff = typeAff; // TypeAffichage
    this.boucle = boucle; // boolean
    this.lin = null; // ListeValeurs
    this.delai = delai;
    this.timeout = null;
    
    return(this);
}

//public void initCalculLive(ListeValeurs in) throws SimuException {
Chronos.prototype.initCalculLive = function(lin) {
    this.lin = lin;
    this.applet.initCalculLive(lin);
}

Chronos.prototype.start = function() {
    var that = this;
    this.timeout = setTimeout(function() {that.iteration()}, 0);
}

Chronos.prototype.stop = function() {
    if (this.timeout != null)
        clearTimeout(this.timeout);
}

Chronos.prototype.fin = function() {
    this.typeAff.fin();
}

//public void recopie(ListeValeurs out) throws SimuException {
Chronos.prototype.recopie = function(out) {
    var lin2, i, nom, vout, v2;
    
    lin2 = new ListeValeurs();
    vin = lin.noms();
    for (i=0; i<vin.length; i++) {
        nom = vin[i];
        vout = out.lireString(nom);
        if (vout != null)
            v2 = vout;
        else
            v2 = lin.lireString(nom);
        lin2.ajouterString(nom, v2);
    }
    this.lin = lin2;
}

Chronos.prototype.iteration = function() {
    var out, sfin, t1, t2, attente, continuer, that;
    
    try {
        t1 = new Date().getTime();
        out = this.applet.calculLive();
        sfin = null;
        if (out != null) {
            try {
                sfin = out.lireString('fin');
            } catch (ex) {
            }
        }
        continuer = true;
        if (out == null || sfin == 'simulation') {
            this.fin();
            continuer = false;
        } else if (sfin == 'trajectoire') {
            if (this.boucle)
                this.recopie(out);
            this.applet.initCalculLive(this.lin);
            this.typeAff.avantLancement();
        } else if (sfin == 'courbe') {
            this.typeAff.update(out);
            this.typeAff.avantLancement();
        } else {
            this.typeAff.update(out);
        }
        
        if (continuer) {
            t2 = new Date().getTime();
            attente = this.delai - (t2 - t1);
            if (attente < 10)
                attente = 10;
            that = this;
            this.timeout = setTimeout(function() {that.iteration()}, attente);
        } else {
            if (this.boucle)
                this.applet.changerValeurs(this.lin);
        }
    } catch (ex) {
        this.applet.handleException(ex);
    }
}
