/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * une possibilité d'affichage des résultats, avec diverses options
 */
function Affichage() {
    /** type d'affichage (plot | plotlive | image | tableau | multiplot) */
    this.type = null; // String
    
    /** titre affiché */
    this.titre = null; // String
    
    /** nom de l'affichage, optionnel mais utile pour l'identifier */
    this.label = null; // String
    
    /**
     * liste des noms des paramètres de sortie utilisés pour les différents
     * tracés de la sortie graphique
     */
    this.params = null; // String[][]
    
    /** abscisse de début de l'affichage */
    this.xdebut = null; // String
    
    /** abscisse de fin de l'affichage */
    this.xfin = null; // String
    
    /** ordonnée de début de l'affichage */
    this.ydebut = null; // String
    
    /** ordonnée de fin de l'affichage */
    this.yfin = null; // String
    
    /** échelle logarithmique pour les abcisses d'un graphe */
    this.xlog = false;
    
    /** échelle logarithmique pour les ordonnées d'un graphe */
    this.ylog = false;
    
    /** nom du fichier image à mettre en fond d'un graphe, au format GIF */
    this.fond = null; // String
    
    /** abscisse de début de l'image de fond */
    this.xdebutfond = null; // String
    
    /** abscisse de fin de l'image de fond */
    this.xfinfond = null; // String
    
    /** ordonnée de début de l'image de fond */
    this.ydebutfond = null; // String
    
    /** ordonnée de fin de l'image de fond */
    this.yfinfond = null; // String
    
    /**
     * option de zoom de l'image de fond.
     * La valeur par défaut est false : il n'y a pas de zoom de l'image de fond.
     * Mettre à true dans la classe de la simulation pour permettre un zoom
     * de l'image de fond
     */
    this.zooming = false;

    /** dimension x de l'image pour AffImage */
    this.imgdimx = 100; // entier
    
    /** dimension y de l'image pour AffImage */
    this.imgdimy = 100; // entier
    
    /** palette de couleurs pour AffImage */
    this.palette = null; // type ?
    
    /** option pour connecter les points d'un graphe */
    this.connecter = false;
    
    /** sous-affichages pour afficher plusieurs plotlive en même temps */
    this.sousAff = null; // Affichage[]
    
    /** ordre dans lequel les sous-affichages sont affichés. Valeurs possibles: "x" ou "y". Défaut: "x"
        qui signifie de la gauche vers la droite puis de haut en bas. S'il y a deux affichages, ils seront
        côte à côte avec "x", et l'un au-dessus de l'autre avec "y". */
    this.ordreSousAff = "x"; // String
    
    /**
     * Option de recopie des valeurs de sortie vers les valeurs d'entrée.
     * Valeur par défaut: false.
     * Quand cette option est activée, les nouvelles valeurs d'entrée après
     * l'affichage d'une trajectoire dans plotlive prennent les valeurs des
     * paramètres de sortie correspondants après le calcul.
     */
     this.boucle = false;
     
     /**
      * Affichage des points d'un graphe: "none", "points", "dots", ou "various".
      * Défaut : "points"
      */
     this.points = "points"; // String
     
     /**
      * Utilisation de couleurs pour tracer les courbes des graphes.
      * true (activé) par défaut.
      */
     this.couleurs = true;
     
     /**
      * Pour afficher un histogramme
      */
     this.histogramme = false;
     
     /**
      * Pour effacer le graphique automatiquement à chaque fois
      */
     this.effacer = false;
     
     /**
      * Pour ajuster le graphique automatiquement à chaque fois
      */
     this.ajuster = false;
     
     /**
      * Pour recadrer le graphique à chaque fois à partir des valeur xmin... de l'affichage
      */
     this.recadrer = false;
     
     /**
      * Pour obtenir une zone carrée pour un graphe
      */
     this.carre = false;
     
     return(this);
}
