/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Affichage d'un tableau à partir d'un ensemble de points, dont la position est
 * calculée avec un appel à SimuParams.calcul().
 */
//public class AffPlotTab extends TypeAffichage {
//public AffPlotTab(SimuApplet applet, Affichage aff, boolean sousaff) {

AffPlotTab.prototype = new TypeAffichage();
AffPlotTab.prototype.constructor = AffPlotTab;

function AffPlotTab(applet, aff, sousaff) {
    this.applet = applet;
    this.aff = aff;
    this.sousaff = sousaff;
    this.outp = null;
    this.table = null;
}

//public Panel initPanel(Vector outp) throws SimuException {
AffPlotTab.prototype.initPanel = function(outp, dimensions) {
    var div_affichage;
    
    div_affichage = document.createElement('div');
    if (!this.sousaff)
        div_affichage.setAttribute('id', 'affichage');
    div_affichage.style.width = dimensions.width + 'px';
    div_affichage.style.height = dimensions.height + 'px';
    return(div_affichage);
}

AffPlotTab.prototype.estLive = function() {
    return(false);
}

AffPlotTab.prototype.avantLancement = function() {
    var div_affichage;
    
    div_affichage = document.getElementById('affichage');
    if (div_affichage.firstChild != null)
        div_affichage.removeChild(div_affichage.firstChild);
    this.table = document.createElement('table');
    this.table.appendChild(document.createElement('thead'));
    this.table.appendChild(document.createElement('tbody'));
    div_affichage.appendChild(this.table);
}

//public void affiche(ListeValeurs in, Vector outp) throws SimuException {
AffPlotTab.prototype.affiche = function(lin, outp) {
    var out;
    
    this.outp = outp;
    
    this.avantLancement();
    
    out = this.applet.calcul(lin);
    this.update(out);
}

//public void update(ListeValeurs out) throws SimuException {
AffPlotTab.prototype.update = function(out) {
    var ip, lp, i, par, o, outx, valeurs, j, o2;
    
    if (this.aff.params == null) {
        alert(Messages.get("aucun_parametre_tableau"));
        return;
    }
    for (ip=0; ip<this.aff.params[0].length; ip++) {
        lp = this.aff.params[0][ip];
        for (i=0; i<this.outp.length; i++) {
            par = this.outp[i];
            if (lp == par.label) {
                o = out.lire(par.label);
                if (Object.prototype.toString.call(o) === '[object Array]') {
                    outx = o;
                    valeurs = new Array();
                    for (j=0; j<outx.length; j++) {
                        o2 = outx[j];
                        if (typeof o2 == 'number')
                            valeurs[j] = this.joliFormattage(o2, 8);
                        else
                            valeurs[j] = '' + o2;
                    }
                    this.ajouterColonne(par.label, valeurs);
                } else {
                    valeurs = new Array();
                    valeurs[0] = '' + o;
                    this.ajouterColonne(par.label, valeurs);
                }
            }
        }
    }
}

AffPlotTab.prototype.ajouterColonne = function(titre, valeurs) {
    var thead, tbody, tr, th, td, i, nbtd;
    
    // on suppose qu'il n'y a pas de noeuds de texte entre les lignes et cellules de la table
    thead = this.table.firstChild;
    tbody = thead.nextSibling;
    
    tr = thead.firstChild;
    if (tr == null) {
        tr = document.createElement('tr');
        thead.appendChild(tr);
    }
    nbtd = tr.childNodes.length;
    th = document.createElement('th');
    th.appendChild(document.createTextNode(titre));
    tr.appendChild(th);
    
    tr = tbody.firstChild;
    for (i=0; i<valeurs.length; i++) {
        if (tr == null) {
            tr = document.createElement('tr');
            tbody.appendChild(tr);
        }
        while (tr.childNodes.length < nbtd)
            tr.appendChild(document.createElement('td'));
        td = document.createElement('td');
        td.appendChild(document.createTextNode(valeurs[i]));
        tr.appendChild(td);
        tr = tr.nextSibling;
    }
}

AffPlotTab.prototype.joliFormattage = function(v, precision) {
    var limitesci = 3; // décimales avant de passer en mode sci
    
    if (v == 0)
        return("0");
    var sj = ""+v;
    if ("Infinity" === sj || "-Infinity" === sj || "NaN" === sj)
        return(""+v);
    var signe;
    if (v >= 0)
        signe = "";
    else {
        v = -v;
        signe = "-";
    }
    var exposant = Math.floor(Math.log(v)/Math.log(10));
    var exparr = Math.pow(10, precision);
    var mantisse = v / Math.pow(10, exposant);
    mantisse = Math.round(mantisse*exparr)/exparr;
    if (mantisse >= 10) {
        exposant += 1;
        mantisse = v / Math.pow(10, exposant);
        mantisse = Math.round(mantisse*exparr)/exparr;
    }
    var sv = "";
    var chiffre = Math.floor(mantisse);
    sv += chiffre + ".";
    for (var i=0; i<precision-1; i++) {
        mantisse = (mantisse - chiffre)*10;
        var exparr2 = Math.pow(10, precision-i);
        mantisse = (Math.round(mantisse*exparr))/exparr;
        chiffre = Math.floor(mantisse);
        sv += chiffre;
    }
    mantisse = (mantisse - chiffre)*10;
    chiffre = Math.round(mantisse);
    sv += chiffre;
    var dernier = sv.charAt(sv.length-1);
    while (dernier == '0') {
        sv = sv.substring(0, sv.length-1);
        dernier = sv.charAt(sv.length-1);
    }
    if (exposant != 0) {
        if (exposant > 0 && exposant < limitesci) {
            var sd = sv.substring(0,1);
            if (sv.length-2 < exposant) {
                // transformation de 3.2E2 en 320
                if (sv.length > 2)
                    sd += sv.substring(2,sv.length);
                for (var i=0; i<exposant-(sv.length-2); i++)
                    sd += '0';
            } else {
                // transformation de 3.245E2 en 324.5
                if (sv.length < exposant+2)
                    sd += sv.substring(2);
                else
                    sd += sv.substring(2,exposant+2) + "." + sv.substring(exposant+2);
            }
            sv = sd;
        } else if (exposant < 0 && exposant > -limitesci) {
            // transformation de 3.2E-2 en 0.032
            var sd = "0.";
            for (var i=0; i<-exposant-1; i++)
                sd += '0';
            sv = sd + sv.charAt(0) + sv.substring(2);
        } else
            sv += "E" + exposant;
    }
    if (sv.charAt(sv.length-1) == '.')
        sv = sv.substring(0, sv.length-1);
    
    sv = signe + sv;
    
    return(sv);
}
