/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Affichage d'un ensemble de PlotLive, calculés simultanément. Appelle
 * SimuParams.initCalculLive() au début, puis SimuParams.calculLive() à chaque
 * itération.
 */
//public class AffPlotLive extends TypeAffichage implements ActionListener {
//public AffPlotLive(SimuApplet applet, Affichage aff, boolean sousaff) {

AffPlotLive.prototype = new TypeAffichage();
AffPlotLive.prototype.constructor = AffPlotLive;

function AffPlotLive(applet, aff, sousaff) {
    this.applet = applet;
    this.aff = aff;
    this.sousaff = sousaff;
    this.nd = -1; // numéro dataset, pour changer la couleur quand aff.params.length = 1
    this.vnd = 0; // nombre d'anciens datasets à conserver
    this.plot = null;
    this.outp = null;
    this.couleurs = true; // à ne pas confondre avec this.aff.couleurs
    this.info = null;
    this.bstop = null;
    this.bstart = null;
    this.chrono = null; // Chronos
    this.points = []; // tableau de tableaux de points [x, y]
    this.options = null;
    this.plotid = null;
    
    var moi = this;
    this.actionPerformedProxy = function(e) { moi.actionPerformed(e) };
}

AffPlotLive.prototype.numeroUnique = (function() { var numero=0; return function() { return(numero++); } })();

AffPlotLive.prototype.ajouterBoutons = function(div) {
    var bouton;
    
    divboutons = document.createElement('div');
    divboutons.setAttribute('id', 'boutons');
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("continuer"));
    bouton.setAttribute('id', 'continuer');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    this.bstart = bouton;
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("stop"));
    bouton.setAttribute('id', 'stop');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    this.bstop = bouton;
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("ajuster"));
    bouton.setAttribute('id', 'ajuster');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("effacer"));
    bouton.setAttribute('id', 'effacer');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    
    div.appendChild(divboutons);
}

AffPlotLive.prototype.limitesAxes = function() {
    var x1, x2, y1, y2, ret;
    
    if (this.aff.xdebut != null && this.aff.xfin != null) {
        x1 = parseFloat(this.aff.xdebut);
        x2 = parseFloat(this.aff.xfin);
    } else {
        x1 = 0;
        x2 = 10;
    }
    if (this.aff.ydebut != null && this.aff.yfin != null) {
        y1 = parseFloat(this.aff.ydebut);
        y2 = parseFloat(this.aff.yfin);
    } else {
        y1 = 0;
        y2 = 10;
    }
    ret = $.jqplot.LinearTickGenerator(x1, x2, 1.0, null, false, false); // [min, max, nTicks, format, tickInterval]
    this.options.axes.xaxis.min = ret[0];
    this.options.axes.xaxis.max = ret[1];
    if (!this.aff.histogramme) {
        this.options.axes.xaxis.numberTicks = ret[2];
        this.options.axes.xaxis.tickInterval = ret[4];
    }
    ret = $.jqplot.LinearTickGenerator(y1, y2, 1.0, null, false, false);
    this.options.axes.yaxis.min = ret[0];
    this.options.axes.yaxis.max = ret[1];
    this.options.axes.yaxis.numberTicks = ret[2];
    this.options.axes.yaxis.tickInterval = ret[4];
}

AffPlotLive.prototype.fonctionFormatAxes = function(format, val) {
    if ((val != 0 && val < 1e-2 && val > -1e-2) || val > 1e3 || val < -1e3)
        format = '%.2E';
    else if (Math.floor(val) == val)
        format = '%d';
    else
        format = '%.2f';
    return($.jqplot.sprintf(format, val));
}

AffPlotLive.prototype.initPlot = function(plotdiv, dimensions) {
    var titres, mopt;
    
    titres = this.applet.titresAxes(this.aff, this.outp);
    plotdiv.style.width = dimensions.width + 'px';
    plotdiv.style.height = dimensions.height + 'px';
    
    // styles de jqplot (markerOptions.style) : circle, diamond, square, x, plus, filledCircle, filledDiamond, filledSquare
    // ptplot/simulab : none, points, dots, cross, various
    // avec jqplot, size = 0.5 signifie 1 pixel de large
    if (this.aff.points == 'none' || this.aff.histogramme)
        mopt = { show: false };
    else if (this.aff.points == 'points')
        mopt = { show: true, style: 'filledCircle', size: 2, shadow: false };
    else if (this.aff.points == 'dots')
        mopt = { show: true, style: 'filledCircle', size: 3, shadow: false };
    else if (this.aff.points == 'cross')
        mopt = { show: true, style: 'x', size: 3, lineWidth: 1, shadow: false };
    else
        mopt = { show: true, style: 'filledCircle', size: 2, shadow: false };
    
    this.options = {
        sortData: false,
        seriesColors: [ '#ff0000', '#0000ff', '#00aaaa', '#000000', '#ffa500', '#53868b', '#ff7f50', '#45ab1f', '#90422d', '#a0a0a0', '#14ff14'], /* couleurs de ptplot */
        title: this.aff.titre,
        axesDefaults: {
            labelRenderer: $.jqplot.CanvasAxisLabelRenderer,
            tickOptions: {
                formatter: this.fonctionFormatAxes
            }
        },
        axes: {
            xaxis: {
                label: titres[0]
            },
            yaxis: {
                label: titres[1]
            }
        },
        seriesDefaults: {
            lineWidth: 1,
            shadow: false,
            showLine: this.aff.connecter,
            markerOptions: mopt
        },
        series : [
            {
            }
        ],
        grid : {
        },
        cursor: {
            show: true,
            zoom: true,
            showTooltip: true
        }
    };
    if (!this.aff.couleurs)
        this.options.seriesColors = ['#000000'];
    if (this.aff.xlog) {
        this.options.axes.xaxis.renderer = $.jqplot.LogAxisRenderer;
        this.options.axes.xaxis.tickDistribution = 'power';
        this.options.axes.xaxis.tickOptions = { formatter: $.jqplot.DefaultTickFormatter, formatString: '%.1E' };
    }
    if (this.aff.ylog) {
        this.options.axes.yaxis.renderer = $.jqplot.LogAxisRenderer;
        this.options.axes.yaxis.tickDistribution = 'power';
        this.options.axes.yaxis.tickOptions = { formatter: $.jqplot.DefaultTickFormatter, formatString: '%.1E' };
    }
    if (!this.aff.ajuster)
        this.limitesAxes();
    if (this.aff.histogramme) {
        this.options.seriesDefaults.renderer = $.jqplot.BarRenderer;
        this.options.seriesDefaults.rendererOptions = { barPadding: 2, barMargin: 4 };
        this.options.axes.xaxis.renderer = $.jqplot.CategoryAxisRenderer;
        this.options.seriesDefaults.showLine = true;
    }
    if (this.aff.fond != null) {
        this.options.backgroundImage = {
            show: true,
            file: this.aff.fond
        };
        if (this.aff.xdebutfond != null)
            this.options.backgroundImage.coordinates = [this.aff.xdebutfond, this.aff.ydebutfond, this.aff.xfinfond, this.aff.yfinfond];
    }
}

//public Panel initPanel(Vector outp) throws SimuException {
AffPlotLive.prototype.initPanel = function(outp, dimensions) {
    var div_affichage, plotdiv, w, h, avecinfo, i, par;
    
    this.outp = outp;
    
    div_affichage = document.createElement('div'); // boutons + plots + info
    if (!this.sousaff)
        div_affichage.setAttribute('id', 'affichage');
    else
        div_affichage.className = 'sous-affichage';
    div_affichage.style.width = dimensions.width + 'px';
    div_affichage.style.height = dimensions.height + 'px';
    
    if (!this.sousaff)
        this.ajouterBoutons(div_affichage);
    
    plotdiv = document.createElement('div');
    this.plotid = 'plot' + this.numeroUnique();
    plotdiv.setAttribute('id', this.plotid);
    div_affichage.appendChild(plotdiv);
    w = dimensions.width - 10;
    if (this.sousaff)
        h = dimensions.height;
    else
        h = dimensions.height - 50;
    if (this.aff.carre) {
        if (w > h) {
            w = h;
            if (this.sousaff)
                div_affichage.style.width = (w + 10) + 'px';
        } else {
            h = w;
            if (this.sousaff)
                div_affichage.style.height = h + 'px';
            else
                div_affichage.style.height = (h + 50) + 'px';
        }
    }
    this.initPlot(plotdiv, {'width': w, 'height': h});
    
    avecinfo = false;
    for (i=0; i<outp.length; i++) {
        par = outp[i];
        if (par.type == 'string')
            avecinfo = true;
    }
    if (avecinfo) {
        this.info = document.createElement('div');
        this.info.setAttribute('id', 'info');
        this.info.appendChild(document.createTextNode(' '));
        div_affichage.appendChild(this.info);
    } else
        this.info = null;
    
    this.couleurs = (this.aff.params.length == 1);
    
    return(div_affichage);
}

AffPlotLive.prototype.estLive = function() {
    return(true);
}

//public void setChronos(Chronos chrono) {
AffPlotLive.prototype.setChronos = function(chrono) {
    this.chrono = chrono;
}

//public void affiche(ListeValeurs in, Vector outp) throws SimuException {
AffPlotLive.prototype.affiche = function(lin, outp) {
    this.outp = outp;
    
    this.avantLancement();
    
    this.start();
}

AffPlotLive.prototype.avantLancement = function() {
    if (this.couleurs)
        this.nd++;
    else if (this.nd != -1)
        this.vnd += this.aff.params.length;
}

AffPlotLive.prototype.start = function() {
    this.bstop.disabled = false;
    this.bstart.disabled = true;
    this.chrono.start();
}

AffPlotLive.prototype.stop = function() {
    if (this.bstop != null)
        this.bstop.disabled = true;
    if (this.bstart != null)
        this.bstart.disabled = false;
    if (this.chrono != null)
        this.chrono.stop();
}

AffPlotLive.prototype.fin = function() {
    this.bstop.disabled = true;
    this.bstart.disabled = true;
}

AffPlotLive.prototype.effacer = function() {
    var i;
    
    this.points = [];
    this.nd = -1;
    this.vnd = 0;
    if (this.plot == null)
        return;
    for (i=0; i<this.plot.series.length; i++)
        this.plot.series[i].data = [];
    this.plot.replot();
}

AffPlotLive.prototype.ajuster = function() {
    this.plot.replot({'resetAxes' : true});
}

AffPlotLive.prototype.actionPerformed = function(e) {
    var cmd;
    
    cmd = (e.target || e.srcElement).getAttribute('id');
    if (cmd == 'continuer')
        this.start();
    else if (cmd == 'stop')
        this.stop();
    else if (cmd == 'ajuster')
        this.ajuster();
    else if (cmd == 'effacer')
        this.effacer();
}

//public void update(ListeValeurs out) throws SimuException {
AffPlotLive.prototype.update = function(out) {
    var ip, sx, sy, x, y, vx, vy, i, par, o, connexion, npoints, series;
    
    if (this.aff.effacer)
        this.effacer();
    if (this.nd == -1)
        this.nd = 0;
    npoints = [];
    for (ip=0; ip<this.aff.params.length; ip++) {
        if (!this.couleurs)
            this.nd = ip + this.vnd;
        sx = this.aff.params[ip][0];
        sy = this.aff.params[ip][1];
        x = 0;
        y = 0;
        vx = null; // pour permettre l'envoi de plusieurs valeurs d'un coup
        vy = null;
        for (i=0; i<this.outp.length; i++) {
            par = this.outp[i];
            o = out.lire(par.label);
            if (typeof o == 'number') {
                if (sx == par.label)
                    x = o;
                else if (sy == par.label)
                    y = o;
            } else if (Object.prototype.toString.call(o) === '[object Array]') {
                if (sx == par.label)
                    vx = o;
                else if (sy == par.label)
                    vy = o;
            } else if (!this.sousaff && typeof o == 'string' && this.info != null) {
                if (this.info.firstChild.nodeValue != o)
                    this.info.firstChild.nodeValue = o;
            } else if (o == null) {
                // ?
            }
        }
        if (this.points[this.nd] == undefined)
            this.points[this.nd] = new Array();
        if (vx != null && vy != null) { // cas avec plusieurs points affichés d'un coup
            if (vx.length != vy.length)
                throw new Error(Messages.get("meme_nombre"));
            for (i=0; i<vx.length; i++) {
                x = vx[i];
                y = vy[i];
                // connexion = this.aff.connecter && (!this.appel1 || i > 0);
                this.points[this.nd].push([x, y]);
                if (npoints[this.nd] == undefined)
                    npoints[this.nd] = [];
                npoints[this.nd].push([x, y]);
            }
        } else {
            // connexion = this.aff.connecter && !this.appel1
            this.points[this.nd].push([x, y]);
            if (npoints[this.nd] == undefined)
                npoints[this.nd] = [];
            npoints[this.nd].push([x, y]);
        }
    }
    
    if (this.plot == null) {
        this.plot = $.jqplot(this.plotid, this.points, this.options);
        
    } else if (this.points.length > this.plot.series.length) {
        this.plot.destroy();
        this.plot = $.jqplot(this.plotid, this.points, this.options);
        
    } else if (this.aff.ajuster) {
        for (i=0; i<this.points.length; i++)
            this.plot.series[i].data = this.points[i];
        this.plot.replot({'resetAxes' : this.aff.ajuster});
        
    } else if (!this.couleurs) {
        // pour n'afficher que les nouveaux points :
        for (ip=0; ip<this.aff.params.length; ip++) {
            this.nd = ip + this.vnd;
            if (npoints[this.nd].length > 0) {
                series = this.plot.series[this.nd];
                // pour afficher une ligne, il faut quand même le point précédent :
                if (this.aff.connecter && this.points[this.nd].length > npoints[this.nd].length)
                    npoints[this.nd].unshift(this.points[this.nd][this.points[this.nd].length - 1 - npoints[this.nd].length]);
                series.data = npoints[this.nd];
                series.draw(series.canvas._ctx, {}, this.plot);
                series.data = this.points[this.nd]; // on remet tous les points pour permettre l'ajustement des axes
            }
        }
        
    } else {
        // affichage seulement de la courbe modifiée
        // nécessite une correction de bug dans jqplot (data[i] undefined), ou la version de 2012
        //this.plot.series[this.nd].data = this.points[this.nd];
        //this.plot.drawSeries({}, this.nd);
        
        // pour n'afficher que les nouveaux points :
        series = this.plot.series[this.nd];
        if (this.aff.connecter && this.points[this.nd].length > npoints[this.nd].length)
            npoints[this.nd].unshift(this.points[this.nd][this.points[this.nd].length - 1 - npoints[this.nd].length]);
        series.data = npoints[this.nd];
        series.draw(series.canvas._ctx, {}, this.plot);
        series.data = this.points[this.nd]; // on remet tous les points pour permettre l'ajustement des axes
    }
}

