/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Affichage d'un graphe à partir d'un ensemble de points.
 * Appelle SimuParams.calcul() au début pour le calcul des positions des points.
 */
//public class AffPlot extends TypeAffichage implements ActionListener {
//public AffPlot(SimuApplet applet, Affichage aff, boolean sousaff) {

AffPlot.prototype = new TypeAffichage();
AffPlot.prototype.constructor = AffPlot;

function AffPlot(applet, aff, sousaff) {
    this.applet = applet;
    this.aff = aff;
    this.sousaff = sousaff;
    this.plot = null;
    this.outp = null;
    this.info = null;
    this.nd = -1; // numéro dataset, pour changer la couleur quand aff.params.length = 1 et !effacer
    this.points = []; // tableau de tableaux de points [x, y]
    this.options = null;
    this.plotid = null;
    
    var moi = this;
    this.actionPerformedProxy = function(e) { moi.actionPerformed(e) };
    
    return(this);
}

AffPlot.prototype.numeroUnique = (function() { var numero=0; return function() { return(numero++); } })();

AffPlot.prototype.ajouterBoutons = function(div) {
    var bouton;
    
    divboutons = document.createElement('div');
    divboutons.setAttribute('id', 'boutons');
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("ajuster"));
    bouton.setAttribute('id', 'ajuster');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("effacer"));
    bouton.setAttribute('id', 'effacer');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    
    div.appendChild(divboutons);
}

AffPlot.prototype.limitesAxes = function() {
    var x1, x2, y1, y2, ret;
    
    if (this.aff.xdebut != null && this.aff.xfin != null) {
        x1 = parseFloat(this.aff.xdebut);
        x2 = parseFloat(this.aff.xfin);
    } else {
        x1 = 0;
        x2 = 10;
    }
    if (this.aff.ydebut != null && this.aff.yfin != null) {
        y1 = parseFloat(this.aff.ydebut);
        y2 = parseFloat(this.aff.yfin);
    } else {
        y1 = 0;
        y2 = 10;
    }
    ret = $.jqplot.LinearTickGenerator(x1, x2, 1.0, null, false, false); // [min, max, nTicks, format, tickInterval]
    this.options.axes.xaxis.min = ret[0];
    this.options.axes.xaxis.max = ret[1];
    if (!this.aff.histogramme) {
        this.options.axes.xaxis.numberTicks = ret[2];
        this.options.axes.xaxis.tickInterval = ret[4];
    }
    ret = $.jqplot.LinearTickGenerator(y1, y2, 1.0, null, false, false);
    this.options.axes.yaxis.min = ret[0];
    this.options.axes.yaxis.max = ret[1];
    this.options.axes.yaxis.numberTicks = ret[2];
    this.options.axes.yaxis.tickInterval = ret[4];
}

AffPlot.prototype.fonctionFormatAxes = function(format, val) {
    if ((val != 0 && val < 1e-2 && val > -1e-2) || val > 1e3 || val < -1e3)
        format = '%.2E';
    else if (Math.floor(val) == val)
        format = '%d';
    else
        format = '%.2f';
    return($.jqplot.sprintf(format, val));
}

AffPlot.prototype.initPlot = function(plotdiv, dimensions) {
    var titres, mopt;
    
    titres = this.applet.titresAxes(this.aff, this.outp);
    plotdiv.style.width = dimensions.width + 'px';
    plotdiv.style.height = dimensions.height + 'px';
    
    // styles de jqplot (markerOptions.style) : circle, diamond, square, x, plus, filledCircle, filledDiamond, filledSquare
    // ptplot/simulab : none, points, dots, cross, various
    // avec jqplot, size = 0.5 signifie 1 pixel de large
    if (this.aff.points == 'none' || this.aff.histogramme)
        mopt = { show: false };
    else if (this.aff.points == 'points')
        mopt = { show: true, style: 'filledCircle', size: 2, shadow: false };
    else if (this.aff.points == 'dots')
        mopt = { show: true, style: 'filledCircle', size: 3, shadow: false };
    else if (this.aff.points == 'cross')
        mopt = { show: true, style: 'x', size: 3, lineWidth: 1, shadow: false };
    else
        mopt = { show: true, style: 'filledCircle', size: 2, shadow: false };
    
    this.options = {
        sortData: false,
        seriesColors: [ '#ff0000', '#0000ff', '#00aaaa', '#000000', '#ffa500', '#53868b', '#ff7f50', '#45ab1f', '#90422d', '#a0a0a0', '#14ff14'], /* couleurs de ptplot */
        title: this.aff.titre,
        axesDefaults: {
            labelRenderer: $.jqplot.CanvasAxisLabelRenderer,
            tickOptions: {
                formatter: this.fonctionFormatAxes
            }
        },
        axes: {
            xaxis: {
                label: titres[0]
            },
            yaxis: {
                label: titres[1]
            }
        },
        seriesDefaults: {
            lineWidth: 1,
            shadow: false,
            showLine: this.aff.connecter,
            markerOptions: mopt
        },
        series : [
            {
            }
        ],
        grid : {
        },
        cursor: {
            show: true,
            zoom: true,
            showTooltip: true
        },
        highlighter: {
            show: true,
            useAxesFormatters: true
        }
    };
    if (!this.aff.couleurs)
        this.options.seriesColors = ['#000000'];
    if (this.aff.xlog) {
        this.options.axes.xaxis.renderer = $.jqplot.LogAxisRenderer;
        this.options.axes.xaxis.tickDistribution = 'power';
        this.options.axes.xaxis.tickOptions = { formatter: $.jqplot.DefaultTickFormatter, formatString: '%.1E' };
        this.options.axes.xaxis.tickOptions.formatString
    }
    if (this.aff.ylog) {
        this.options.axes.yaxis.renderer = $.jqplot.LogAxisRenderer;
        this.options.axes.yaxis.tickDistribution = 'power';
        this.options.axes.yaxis.tickOptions = { formatter: $.jqplot.DefaultTickFormatter, formatString: '%.1E' };
    }
    if (this.aff.histogramme) {
        this.options.seriesDefaults.renderer = $.jqplot.BarRenderer;
        this.options.seriesDefaults.rendererOptions = { barPadding: 2, barMargin: 4 };
        this.options.axes.xaxis.renderer = $.jqplot.CategoryAxisRenderer;
        this.options.seriesDefaults.showLine = true;
        this.options.highlighter.tooltipAxes = 'y';
    }
    if (this.aff.fond != null) {
        this.options.backgroundImage = {
            show: true,
            file: this.aff.fond
        };
        if (this.aff.xdebutfond != null)
            this.options.backgroundImage.coordinates = [this.aff.xdebutfond, this.aff.ydebutfond, this.aff.xfinfond, this.aff.yfinfond];
    }
}

//public Panel initPanel(Vector outp) throws SimuException {
AffPlot.prototype.initPanel = function(outp, dimensions) {
    var div_affichage, plotdiv, w, h, avecinfo, i, par;
    
    this.outp = outp;
    
    div_affichage = document.createElement('div');
    if (!this.sousaff)
        div_affichage.setAttribute('id', 'affichage');
    else
        div_affichage.className = 'sous-affichage';
    div_affichage.style.width = dimensions.width + 'px';
    div_affichage.style.height = dimensions.height + 'px';
    
    if (!this.sousaff)
        this.ajouterBoutons(div_affichage);
    
    //plot = new SimuPlot(applet, aff);
    plotdiv = document.createElement('div');
    this.plotid = 'plot' + this.numeroUnique();
    plotdiv.setAttribute('id', this.plotid);
    div_affichage.appendChild(plotdiv);

    w = dimensions.width - 10;
    if (this.sousaff)
        h = dimensions.height;
    else
        h = dimensions.height - 50;
    if (this.aff.carre) {
        if (w > h) {
            w = h;
            div_affichage.style.width = (w + 10) + 'px';
        } else {
            h = w;
            if (this.sousaff)
                div_affichage.style.height = h + 'px';
            else
                div_affichage.style.height = (h + 50) + 'px';
        }
    }
    this.initPlot(plotdiv, {'width': w, 'height': h});
    
    avecinfo = false;
    for (i=0; i<outp.length; i++) {
        par = outp[i];
        if (par.type == 'string')
            avecinfo = true;
    }
    if (avecinfo) {
        this.info = document.createElement('div');
        this.info.setAttribute('id', 'info');
        this.info.appendChild(document.createTextNode(' '));
        div_affichage.appendChild(this.info);
    } else
        this.info = null;
    
    return(div_affichage);
}

AffPlot.prototype.estLive = function() {
    return(false);
}

AffPlot.prototype.effacer = function() {
    this.points = [];
    this.nd = -1;
    if (this.plot == null)
        return;
    this.plot.destroy();
    this.plot = $.jqplot(this.plotid, [[null]], this.options);
}

AffPlot.prototype.ajuster = function() {
    //this.plot.replot({'resetAxes' : true});
    // problème de replot: la taille des labels de l'axe y peut augmenter si les valeurs augmentent,
    // mais la dimension de la zone des labels n'est pas réajustée
    this.plot.destroy();
    this.plot = $.jqplot(this.plotid, this.points, this.options);
}

AffPlot.prototype.actionPerformed = function(e) {
    var cmd;
    
    cmd = (e.target || e.srcElement).getAttribute('id');
    if (cmd == 'ajuster')
        this.ajuster();
    else if (cmd == 'effacer')
        this.effacer();
}

//public void update(ListeValeurs out) throws SimuException {
AffPlot.prototype.update = function(out) {
    var ip, lsx, lsy, outx, outy, i, par, o, x, y, dd;
    
    if (!this.aff.ajuster)
        this.limitesAxes();
    
    if (this.aff.effacer) {
        this.points = [];
        this.nd = 0;
         if (this.plot != null) {
             this.plot.destroy();
             this.plot = null;
         }
    } else if (this.aff.params.length == 1)
        this.nd++;
    for (ip=0; ip<this.aff.params.length; ip++) {
        if (this.aff.params.length != 1)
            this.nd = ip;
        lsx = this.aff.params[ip][0];
        lsy = this.aff.params[ip][1];
        outx = null;
        outy = null;
        for (i=0; i<this.outp.length; i++) {
            par = this.outp[i];
            if (lsx == par.label) {
                o = out.lire(par.label);
                if (o == null)
                    outx = null;
                else if (Object.prototype.toString.call(o) === '[object Array]')
                    outx = o;
                else if (typeof o == 'number') {
                    // cas où la courbe est réduite à un point
                    outx = [ o ];
                } else {
                    outx = null;
                    alert("Type étrange pour la coordonnée x d'un plot : " + (typeof o));
                }
            } else if (lsy == par.label) {
                o = out.lire(par.label);
                if (o == null)
                    outy = null;
                else if (Object.prototype.toString.call(o) === '[object Array]')
                    outy = o;
                else if (typeof o == 'number') {
                    outy = [ o ];
                } else {
                    outy = null;
                    alert("Type étrange pour la coordonnée y d'un plot : " + (typeof o));
                }
            } else if (!this.sousaff && this.info != null && par.type == 'string' &&
                    typeof out.lire(par.label) == 'string')
                this.info.firstChild.nodeValue = out.lire(par.label);
        }
        if (outx == null || outy == null) {
            alert(Messages.get("aucun_resultat"));
            return;
        }
        if (this.points[this.nd] == undefined)
            this.points[this.nd] = new Array();
        for (i=0; i<outx.length; i++) {
            x = outx[i];
            y = outy[i];
            this.points[this.nd].push([x, y]); // à connecter si : this.aff.connecter && (i > 0)
        }
    }
    if (this.plot == null) {
        this.plot = $.jqplot(this.plotid, this.points, this.options);
    } else if (this.points.length > this.plot.series.length) {
        this.plot.destroy();
        this.plot = $.jqplot(this.plotid, this.points, this.options);
    } else {
        for (i=0; i<this.points.length; i++)
            this.plot.series[i].data = this.points[i];
        this.plot.replot({'resetAxes' : this.aff.ajuster});
    }
}

//public void affiche(ListeValeurs in, Vector outp) throws SimuException {
AffPlot.prototype.affiche = function(lin, outp) {
    var out;
    
    this.outp = outp;
    out =  this.applet.calcul(lin);
    this.update(out);
}

