/*
SimuLab

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Affichage d'un ensemble d'affichages, calculés simultanément.
 */
//public class AffMulti extends TypeAffichage implements ActionListener {
//public AffMulti(SimuApplet applet, Affichage aff, boolean sousaff) {

AffMulti.prototype = new TypeAffichage();
AffMulti.prototype.constructor = AffMulti;

function AffMulti(applet, aff, sousaff) {
    var i, moi;
    
    this.applet = applet;
    this.aff = aff;
    this.sousaff = sousaff;
    this.typesaff = null; // TypeAffichage[]
    this.outp = null;
    this.info = null;
    this.bstop = null;
    this.bstart = null;
    this.chrono = null; // Chronos
    this.live = false;
    
    if (this.aff.sousAff == null)
        alert(Messages.get("multiplot_sans_affichage"));
    
    try {
        if (this.aff.sousAff == null) {
            this.typesaff = new Array();
            this.typesaff[0] = this.applet.creationTypeAffichage(this.aff, true);
        } else {
            this.typesaff = new Array();
            for (i=0; i<this.aff.sousAff.length; i++)
                this.typesaff[i] = this.applet.creationTypeAffichage(this.aff.sousAff[i], true);
        }
    } catch (ex) {
        this.applet.handleException(ex);
    }
    if (this.aff.sousAff == null)
        this.live = this.typesaff[0].estLive();
    else {
        this.live = false;
        for (i=0; i<this.typesaff.length; i++)
            this.live = this.live || this.typesaff[i].estLive();
    }
    
    moi = this;
    this.actionPerformedProxy = function(e) { moi.actionPerformed(e) };
}

AffMulti.prototype.estLive = function() {
    return(this.live);
}

AffMulti.prototype.ajouterBoutons = function(div) {
    var bouton;
    
    divboutons = document.createElement('div');
    divboutons.setAttribute('id', 'boutons');
    
    if (this.live) {
        bouton = document.createElement('input');
        bouton.setAttribute('type', 'button');
        bouton.setAttribute('value', Messages.get("continuer"));
        bouton.setAttribute('id', 'continuer');
        if (bouton.addEventListener)
            bouton.addEventListener('click', this.actionPerformedProxy, false);
        else
            bouton.attachEvent('onclick', this.actionPerformedProxy);
        divboutons.appendChild(bouton);
        this.bstart = bouton;
        
        bouton = document.createElement('input');
        bouton.setAttribute('type', 'button');
        bouton.setAttribute('value', Messages.get("stop"));
        bouton.setAttribute('id', 'stop');
        if (bouton.addEventListener)
            bouton.addEventListener('click', this.actionPerformedProxy, false);
        else
            bouton.attachEvent('onclick', this.actionPerformedProxy);
        divboutons.appendChild(bouton);
        this.bstop = bouton;
    }

    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("ajuster"));
    bouton.setAttribute('id', 'ajuster');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("effacer"));
    bouton.setAttribute('id', 'effacer');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    
    div.appendChild(divboutons);
}

//public Panel initPanel(Vector outp) throws SimuException {
AffMulti.prototype.initPanel = function(outp, dimensions) {
    var div_affichage, nbplotsx, nbplotsy, table, tbody, tr, td, i, itr, itd, sousdim, avecinfo, par;
    
    this.outp = outp;
    div_affichage = document.createElement('div');
    if (!this.sousaff)
        div_affichage.setAttribute('id', 'affichage');
    div_affichage.style.width = dimensions.width + 'px';
    div_affichage.style.height = dimensions.height + 'px';
    
    if (!this.sousaff)
        this.ajouterBoutons(div_affichage);
    
    if (this.aff.sousAff == null)
        div_affichage.appendChild(this.typesaff[0].initPanel(outp, dimensions));
    else {
        if (this.aff.ordreSousAff != 'y') {
            // plus long en x
            nbplotsx = Math.ceil(Math.sqrt(this.typesaff.length));
            if (nbplotsx*(nbplotsx-1) < this.typesaff.length)
                nbplotsy = nbplotsx;
            else
                nbplotsy = nbplotsx - 1;
        } else {
            nbplotsy = Math.ceil(Math.sqrt(this.typesaff.length));
            if (nbplotsy*(nbplotsy-1) < this.typesaff.length)
                nbplotsx = nbplotsy;
            else
                nbplotsx = nbplotsy - 1;
        }
        table = document.createElement('table');
        tbody = document.createElement('tbody');
        i = 0;
        for (itr=0; itr<nbplotsy; itr++) {
            tr = document.createElement('tr');
            for (itd=0; itd<nbplotsx; itd++) {
                td = document.createElement('td');
                if (i < this.typesaff.length) {
                    sousdim = {'width': (dimensions.width / nbplotsx - 8), 'height': ((dimensions.height - 50) / nbplotsy - 8)};
                    td.appendChild(this.typesaff[i].initPanel(this.outp, sousdim));
                }
                tr.appendChild(td);
                i++;
            }
            tbody.appendChild(tr);
        }
        table.appendChild(tbody);
        div_affichage.appendChild(table);
    }
    
    avecinfo = false;
    for (i=0; i<this.outp.length; i++) {
        par = this.outp[i];
        if (par.type == 'string')
            avecinfo = true;
    }
    if (avecinfo) {
        this.info = document.createElement('div');
        this.info.setAttribute('id', 'info');
        this.info.appendChild(document.createTextNode(' '));
        div_affichage.appendChild(this.info);
    } else
        this.info = null;
    
    return(div_affichage);
}

AffMulti.prototype.setChronos = function(chrono) {
    this.chrono = chrono;
}

AffMulti.prototype.avantLancement = function() {
    var i;
    
    for (i=0; i<this.typesaff.length; i++)
        this.typesaff[i].avantLancement();
}

//public void affiche(ListeValeurs in, Vector outp) throws SimuException {
AffMulti.prototype.affiche = function(lin, outp) {
    var out;
    
    this.outp = outp;
    this.avantLancement();
    
    if (this.live)
        this.start();
    else {
        out =  this.applet.calcul(lin);
        this.update(out);
    }
}

AffMulti.prototype.start = function() {
    this.bstop.disabled = false;
    this.bstart.disabled = true;
    if (this.chrono != null)
        this.chrono.start();
}

AffMulti.prototype.stop = function() {
    // bstop et bstart sont null s'il y a eu une erreur dans initCalculLive
    if (this.bstop != null)
        this.bstop.disabled = true;
    if (this.bstart != null)
        this.bstart.disabled = false;
    if (this.chrono != null)
        this.chrono.stop();
}

AffMulti.prototype.fin = function() {
    this.bstop.disabled = true;
    this.bstart.disabled = true;
    this.chrono = null;
}

AffMulti.prototype.effacer = function() {
    var i;
    
    for (i=0; i<this.typesaff.length; i++)
        this.typesaff[i].effacer();
}

AffMulti.prototype.ajuster = function() {
    var i;
    
    for (i=0; i<this.typesaff.length; i++)
        this.typesaff[i].ajuster();
}

AffMulti.prototype.actionPerformed = function(e) {
    var cmd;
    
    cmd = (e.target || e.srcElement).getAttribute('id');
    if (cmd == 'continuer')
        this.start();
    else if (cmd == 'stop')
        this.stop();
    else if (cmd == 'ajuster')
        this.ajuster();
    else if (cmd == 'effacer')
        this.effacer();
}

//public void update(ListeValeurs out) throws SimuException {
AffMulti.prototype.update = function(out) {
    var i;
    
    for (i=0; i<this.typesaff.length; i++)
        this.typesaff[i].update(out);
    for (i=0; i<this.outp.length; i++) {
        par = this.outp[i];
        o = out.lire(par.label);
        if (typeof o == 'string' && this.info != null) {
            if (o != this.info.firstChild.nodeValue)
                this.info.firstChild.nodeValue = o;
        }
    }
}

