/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Affichage d'une animation. Appelle SimuParams.initCalculLive() au début,
 * puis SimuParams.calculLive() à chaque itération. Le paramètre de sortie
 * de l'algorithme doit être un tableau avec l'intensité des pixels de l'image
 * à chaque itération, ou un tableau avec des entrées de la palette de couleurs.
 */
//public AffImage(SimuApplet applet, Affichage aff, boolean sousaff, boolean live) {
//public class AffImage extends TypeAffichage implements ActionListener {

AffImage.prototype = new TypeAffichage();
AffImage.prototype.constructor = AffImage;

function AffImage(applet, aff, sousaff, live) {
    this.applet = applet;
    this.aff = aff;
    this.sousaff = sousaff;
    this.live = live;
    this.ic = null; // ImageCanvas
    this.info = null;
    this.chrono = null;
    this.bstop = null;
    this.bstart = null;
    this.outp = null;
    
    var moi = this;
    this.actionPerformedProxy = function(e) { moi.actionPerformed(e) };
}

AffImage.prototype.ajouterBoutons = function(div) {
    var bouton;
    
    divboutons = document.createElement('div');
    divboutons.setAttribute('id', 'boutons');
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("continuer"));
    bouton.setAttribute('id', 'continuer');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    this.bstart = bouton;
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("stop"));
    bouton.setAttribute('id', 'stop');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    this.bstop = bouton;
    
    div.appendChild(divboutons);
}

//public Panel initPanel(Vector outp) throws SimuException {
AffImage.prototype.initPanel = function(outp, dimensions) {
    var div_affichage, avecinfo, i, par;
    
    this.outp = outp;
    
    div_affichage = document.createElement('div');
    if (!this.sousaff)
        div_affichage.setAttribute('id', 'affichage');
    div_affichage.style.width = dimensions.width + 'px';
    div_affichage.style.height = dimensions.height + 'px';
    
    if (!this.sousaff && this.live)
        this.ajouterBoutons(div_affichage);
    
    if (this.ic == null)
        this.ic = new ImageCanvas(this.aff.imgdimx, this.aff.imgdimy, this.aff.palette);
    div_affichage.appendChild(this.ic.getCanvas());
    
    avecinfo = false;
    for (i=0; i<outp.length; i++) {
        par = outp[i];
        if (par.type == 'string')
            avecinfo = true;
    }
    if (avecinfo) {
        this.info = document.createElement('div');
        this.info.setAttribute('id', 'info');
        this.info.appendChild(document.createTextNode(' '));
        div_affichage.appendChild(this.info);
    } else
        this.info = null;

    return(div_affichage);
}

AffImage.prototype.estLive = function() {
    return(this.live);
}

AffImage.prototype.setChronos = function(chrono) {
    this.chrono = chrono;
}

//public void affiche(ListeValeurs in, Vector outp) throws SimuException {
AffImage.prototype.affiche = function(lin, outp) {
    var out;
    
    this.outp = outp;
    
    if (this.live)
        this.start(); // affichage au fur et à mesure dans l'image
    else {
        out =  this.applet.calcul(lin);
        this.update(out);
    }
}

AffImage.prototype.start = function() {
    this.bstop.disabled = false;
    this.bstart.disabled = true;
    this.chrono.start();
}

AffImage.prototype.stop = function() {
    if (this.bstop != null)
        this.bstop.disabled = true;
    if (this.bstart != null)
        this.bstart.disabled = false;
    this.chrono.stop();
}

AffImage.prototype.fin = function() {
    this.bstop.disabled = true;
    this.bstart.disabled = true;
    //this.chrono = null;
}

//public void update(ListeValeurs out) throws SimuException {
AffImage.prototype.update = function(out) {
    var trouve, ip, lp, i, par, o;
    
    trouve = false;
    for (ip=0; ip<this.aff.params[0].length; ip++) {
        lp = this.aff.params[0][ip];
        for (i=0; i<this.outp.length; i++) {
            par = this.outp[i];
            if (lp == par.label) {
                if (par.type == 'tableau') {
                    o = out.lire(par.label);
                    if (Object.prototype.toString.call(o) === '[object Array]') { // normalement test double[][]
                        this.ic.updateImage(o);
                        trouve = true;
                    } else
                        throw new Error(Messages.get('mauvaise_sortie') + ': ' + (typeof o));
                } else if (par.type == 'image') {
                    o = out.lire(par.label);
                    if (o.nodeName == 'CANVAS') {
                        this.ic.updateImage(o);
                        trouve = true;
                    } else
                        throw new Error(Messages.get('mauvaise_sortie') + ': ' + (typeof o));
                } else if (!this.sousaff && par.type == 'string' && this.info != null)
                    this.info.firstChild.nodeValue = out.lireString(par.label);
            }
        }
    }
    if (!trouve)
        throw new Error(Messages.get('aucune_sortie'));
}

AffImage.prototype.actionPerformed = function(e) {
    var cmd;
    
    cmd = e.target.getAttribute('id');
    if (cmd == 'continuer')
        this.start();
    else if (cmd == 'stop')
        this.stop();
}

