/**
 * Background image plugin for jqplot
 *
 * Version: @VERSION
 * Revision: @REVISION
 *
 * Copyright (c) 2012 Observatoire de Paris
 *
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly.
 * 
 * BackgroundImage options:
 * show (default: false)
 * file (required)
 * coordinates : [x1, y1, x2, y2] (default: undefined)
 */
(function($) {
    
    // class: $.jqplot.BackgroundImage
    $.jqplot.BackgroundImage = function(opts) {
        this.options = opts || {};
        this.image = new Image();
        this.image.src = this.options.file;
        this.canvas = null;
    }
    
    $.jqplot.BackgroundImage.postPlotInit = function (target, data, opts) {
        // "this" is the plot
        var options = opts || {};
        this.plugins.backgroundImage = new $.jqplot.BackgroundImage(options.backgroundImage);
        if (this.options.backgroundImage && this.options.backgroundImage.show)
            this.grid.background = 'rgba(0,0,0,0)';
    };
    
    $.jqplot.BackgroundImage.prototype.draw = function(plot) {
        var p1, p2, rect, context, image;
        if (!this.options.show) {
            return;
        }
        context = this.canvas._ctx;
        if (this.options.coordinates) {
            context.clearRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
            p1 = { 'x': plot.axes['xaxis'].series_u2p(this.options.coordinates[0]),
                'y': plot.axes['yaxis'].series_u2p(this.options.coordinates[1]) };
            p2 = { 'x': plot.axes['xaxis'].series_u2p(this.options.coordinates[2]),
                'y': plot.axes['yaxis'].series_u2p(this.options.coordinates[3]) };
            rect = [ Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y) ];
        } else {
            rect = [0, 0, this.canvas.getWidth(), this.canvas.getHeight()];
        }
        if (this.image.complete)
            context.drawImage(this.image, rect[0], rect[1], rect[2], rect[3]);
        else {
            image = this.image;
            image.onload = function() {
                context.drawImage(image, rect[0], rect[1], rect[2], rect[3]);
            };
        }
    }
    
    $.jqplot.BackgroundImage.postPlotDraw = function() {
        // "this" is the plot
        if (!this.options.backgroundImage || !this.options.backgroundImage.show) {
            return;
        }
        var bi = this.plugins.backgroundImage;
        bi.canvas = new $.jqplot.GenericCanvas();
        $(this.grid._elem).before(bi.canvas.createElement(this._gridPadding, 'jqplot-backgroundImage-canvas', this._plotDimensions, this));
        bi.canvas.setContext();
        bi.draw(this);
    };
    
    $.jqplot.postInitHooks.push($.jqplot.BackgroundImage.postPlotInit);
    $.jqplot.postDrawHooks.push($.jqplot.BackgroundImage.postPlotDraw);
})(jQuery);
