/*
  idCanvas : id de l'élément canvas sur lequel le curseur doit être affiché
  min : valeur minimale
  max : valeur maximale
  defaut : valeur par défaut
  nbpas : nombre de pas du curseur
  log : true pour une progression exponentielle
  modif_fct : fonction appelée quand la valeur est modifié, avec en paramètre un évènement ayant la propriété target
 */
function Curseur(idCanvas, min, max, defaut, nbpas, log, modif_fct) {
    this.canvas = document.getElementById(idCanvas);
    this.longueur = this.canvas.width;
    this.hauteur = this.canvas.height;
    this.min = min;
    this.max = max;
    this.valeur = defaut;
    this.nbpas = nbpas; // nombre de valeurs sélectionnables entre min et max
    this.log = log;
    this.modif_fct = modif_fct; // fonction appelée quand la valeur est modifiée
    this.deplacement = false;
    this.largeur_bouton = 10;
    this.margex = 20;
    this.margey = 4;
    this.hauteur_barre = this.hauteur / 2 - this.margey;
    
    var moi = this;
    this.mousedownProxy = function(e) { moi.mousedown(e) };
    this.mousemoveProxy = function(e) { moi.mousemove(e) };
    this.mouseupProxy = function(e) { moi.mouseup(e) };
    if (this.canvas.addEventListener)
        this.canvas.addEventListener('mousedown', this.mousedownProxy, false);
    else
        this.canvas.attachEvent('onmousedown', this.mousedownProxy);
    if ('ontouchstart' in document)
        this.canvas.addEventListener('touchstart', this.mousedownProxy, false);
    
    this.afficher();
    
    return(this);
}

Curseur.prototype = {
    afficher : function() {
        var context = this.canvas.getContext('2d');
        context.save();
        context.font = '12px sans-serif'
        this.margex = Math.max(context.measureText('' + this.min).width, context.measureText('' + this.max).width) / 2; // context n'est pas disponible avant
        context.fillStyle = 'white';
        context.fillRect(0, 0, this.longueur, this.hauteur);
        
        context.translate(this.margex, this.margey);
        context.fillStyle = 'gray';
        var longueur_barre = this.longueur - 2*this.margex;
        context.fillRect(0, this.hauteur_barre / 2 - 2, longueur_barre, 4);
        
        var xv;
        if (this.log)
            xv = longueur_barre * this.invLogPos(this.valeur);
        else
            xv = longueur_barre * (this.valeur - this.min)/(this.max - this.min);
        if (this.deplacement) {
            context.shadowColor = 'green';
            context.shadowBlur = 3;
        }
        context.fillStyle = '#D0D0D0';
        context.strokeStyle = '#505050';
        context.beginPath();
        context.moveTo(xv - this.largeur_bouton/2, 0);
        context.lineTo(xv + this.largeur_bouton/2, 0);
        context.lineTo(xv + this.largeur_bouton/2, this.hauteur_barre * 2/3);
        context.lineTo(xv, this.hauteur_barre);
        context.lineTo(xv - this.largeur_bouton/2, this.hauteur_barre * 2/3);
        context.closePath();
        context.fill();
        context.stroke();
        context.shadowColor = 'white'; // nécessaire à cause d'un bug de Safari ?
        context.shadowBlur = 0;
        
        context.fillStyle = 'black';
        context.textAlign = 'center';
        context.strokeStyle = 'gray';
        context.textBaseline = 'bottom';
        var longueur_traits = this.hauteur - this.margey - this.hauteur_barre - 13;
        
        var xg = 0;
        context.beginPath();
        context.moveTo(xg, this.hauteur_barre + 1);
        context.lineTo(xg, this.hauteur_barre + longueur_traits);
        context.fillText(this.min, xg, this.hauteur - this.margey);
        
        if ((this.nbpas - 1) % 2 == 0) {
            xg = longueur_barre / 2;
            context.moveTo(xg, this.hauteur_barre + 1);
            context.lineTo(xg, this.hauteur_barre + longueur_traits);
            var v;
            if (this.log)
                v = this.logPos(0.5);
            else
                v = this.min + (this.max - this.min)/2;
            context.fillText((new Number(v)).toFixed(0), xg, this.hauteur - this.margey);
        }
        
        xg = longueur_barre;
        context.moveTo(xg, this.hauteur_barre + 1);
        context.lineTo(xg, this.hauteur_barre + longueur_traits);
        context.fillText(this.max, xg, this.hauteur - this.margey);
        
        if (this.nbpas < longueur_barre/4) {
            for (var i=1; i<this.nbpas-1; i++) {
                if (i != Math.round((this.nbpas - 1) / 2) || (this.nbpas - 1) % 2 != 0) {
                    context.moveTo(i * longueur_barre / (this.nbpas - 1), this.hauteur_barre + 1);
                    context.lineTo(i * longueur_barre / (this.nbpas - 1), this.hauteur_barre + longueur_traits / 2);
                }
            }
        }
        context.stroke();
        
        //context.translate(-this.margex, -this.margey); // inutile avec le restore après
        context.restore();
    },
    getValeur : function() {
        return(this.valeur);
    },
    setValeur : function(v) {
        this.valeur = v;
        this.afficher();
    },
    setMaximum : function(maximum) {
        this.max = maximum;
        if (this.valeur > this.max)
            this.valeur = this.max;
    },
    setNbpas : function(nbpas) {
        this.nbpas = nbpas;
    },
    logPos : function(x) {
        return(Math.pow(10, Math.log(this.min)/Math.log(10) + (Math.log(this.max/this.min)/Math.log(10)) * x));
    },
    invLogPos : function(x) {
        return((Math.log(x)/Math.log(10) - Math.log(this.min)/Math.log(10)) / (Math.log(this.max/this.min)/Math.log(10)));
    },
    coordonnees : function(e) {
        var x, y;
        if (e.pageX || e.pageY) {
          x = e.pageX;
          y = e.pageY;
        } else {
          x = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
          y = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
        }
        var totalOffsetX = 0;
        var totalOffsetY = 0;
        var currentElement = this.canvas;
        do {
            totalOffsetX += currentElement.offsetLeft;
            totalOffsetY += currentElement.offsetTop;
        } while (currentElement = currentElement.offsetParent)
        x -= totalOffsetX;
        y -= totalOffsetY;
        return( { x : x, y : y } );
    },
    mousedown : function(e) {
        this.deplacement = true;
        this.mousemove(e);
        if (this.canvas.addEventListener) {
            document.addEventListener('mousemove', this.mousemoveProxy, false);
            document.addEventListener('mouseup', this.mouseupProxy, false);
        } else {
            document.attachEvent('onmousemove', this.mousemoveProxy);
            document.attachEvent('onmouseup', this.mouseupProxy);
        }
        if ('ontouchstart' in document) {
            document.addEventListener('touchmove', this.mousemoveProxy, false);
            document.addEventListener('touchend', this.mouseupProxy, false);
        }
        if (e.preventDefault)
            e.preventDefault();
        else
            e.returnValue = false;
    },
    mousemove : function(e) {
        var pt = this.coordonnees(e);
        if (this.deplacement) {
            var vvaleur = this.valeur;
            if (pt.x < this.margex)
                this.valeur = this.min;
            else if (pt.x > this.longueur - this.margex)
                this.valeur = this.max;
            else if (this.log) {
                var ratio = (pt.x - 0 - this.margex) / (this.longueur - 2*this.margex);
                ratio = Math.round(ratio * (this.nbpas - 1)) / (this.nbpas - 1);
                this.valeur = this.logPos(ratio);
            } else {
                var ratio = (pt.x - 0 - this.margex) / (this.longueur - 2*this.margex);
                ratio = Math.round(ratio * (this.nbpas - 1)) / (this.nbpas - 1);
                this.valeur = this.min + (this.max - this.min) * ratio;
            }
            this.afficher();
            if (this.valeur != vvaleur)
                this.modif_fct({target: this.canvas});
        }
    },
    mouseup : function(e) {
        this.deplacement = false;
        this.afficher();
        if (this.canvas.addEventListener) {
            document.removeEventListener('mousemove', this.mousemoveProxy, false);
            document.removeEventListener('mouseup', this.mouseupProxy, false);
        } else {
            document.detachEvent('onmousemove', this.mousemoveProxy);
            document.detachEvent('onmouseup', this.mouseupProxy);
        }
        if ('ontouchstart' in document) {
            document.removeEventListener('touchmove', this.mousemoveProxy, false);
            document.removeEventListener('touchend', this.mouseupProxy, false);
        }
    }
}
/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: @VERSION
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 *
 * included jsDate library by Chris Leonello:
 *
 * Copyright (c) 2010-2011 Chris Leonello
 *
 * jsDate is currently available for use in all personal or commercial projects 
 * under both the MIT and GPL version 2.0 licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly.
 *
 * jsDate borrows many concepts and ideas from the Date Instance 
 * Methods by Ken Snyder along with some parts of Ken's actual code.
 * 
 * Ken's origianl Date Instance Methods and copyright notice:
 * 
 * Ken Snyder (ken d snyder at gmail dot com)
 * 2008-09-10
 * version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 * Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * jqplotToImage function based on Larry Siden's export-jqplot-to-png.js.
 * Larry has generously given permission to adapt his code for inclusion
 * into jqPlot.
 *
 * Larry's original code can be found here:
 *
 * https://github.com/lsiden/export-jqplot-to-png
 * 
 * 
 */
if(!document.createElement("canvas").getContext){(function(){var ab=Math;var n=ab.round;var l=ab.sin;var A=ab.cos;var H=ab.abs;var N=ab.sqrt;var d=10;var f=d/2;var z=+navigator.userAgent.match(/MSIE ([\d.]+)?/)[1];function y(){return this.context_||(this.context_=new D(this))}var t=Array.prototype.slice;function g(j,m,p){var i=t.call(arguments,2);return function(){return j.apply(m,i.concat(t.call(arguments)))}}function af(i){return String(i).replace(/&/g,"&amp;").replace(/"/g,"&quot;")}function Y(m,j,i){if(!m.namespaces[j]){m.namespaces.add(j,i,"#default#VML")}}function R(j){Y(j,"g_vml_","urn:schemas-microsoft-com:vml");Y(j,"g_o_","urn:schemas-microsoft-com:office:office");if(!j.styleSheets.ex_canvas_){var i=j.createStyleSheet();i.owningElement.id="ex_canvas_";i.cssText="canvas{display:inline-block;overflow:hidden;text-align:left;width:300px;height:150px}"}}R(document);var e={init:function(i){var j=i||document;j.createElement("canvas");j.attachEvent("onreadystatechange",g(this.init_,this,j))},init_:function(p){var m=p.getElementsByTagName("canvas");for(var j=0;j<m.length;j++){this.initElement(m[j])}},initElement:function(j){if(!j.getContext){j.getContext=y;R(j.ownerDocument);j.innerHTML="";j.attachEvent("onpropertychange",x);j.attachEvent("onresize",W);var i=j.attributes;if(i.width&&i.width.specified){j.style.width=i.width.nodeValue+"px"}else{j.width=j.clientWidth}if(i.height&&i.height.specified){j.style.height=i.height.nodeValue+"px"}else{j.height=j.clientHeight}}return j},uninitElement:function(j){if(j.getContext){var i=j.getContext();delete i.element_;delete i.canvas;j.innerHTML="";j.context_=null;j.getContext=null;j.detachEvent("onpropertychange",x);j.detachEvent("onresize",W)}}};function x(j){var i=j.srcElement;switch(j.propertyName){case"width":i.getContext().clearRect();i.style.width=i.attributes.width.nodeValue+"px";i.firstChild.style.width=i.clientWidth+"px";break;case"height":i.getContext().clearRect();i.style.height=i.attributes.height.nodeValue+"px";i.firstChild.style.height=i.clientHeight+"px";break}}function W(j){var i=j.srcElement;if(i.firstChild){i.firstChild.style.width=i.clientWidth+"px";i.firstChild.style.height=i.clientHeight+"px"}}e.init();var k=[];for(var ae=0;ae<16;ae++){for(var ad=0;ad<16;ad++){k[ae*16+ad]=ae.toString(16)+ad.toString(16)}}function B(){return[[1,0,0],[0,1,0],[0,0,1]]}function J(p,m){var j=B();for(var i=0;i<3;i++){for(var ah=0;ah<3;ah++){var Z=0;for(var ag=0;ag<3;ag++){Z+=p[i][ag]*m[ag][ah]}j[i][ah]=Z}}return j}function v(j,i){i.fillStyle=j.fillStyle;i.lineCap=j.lineCap;i.lineJoin=j.lineJoin;i.lineWidth=j.lineWidth;i.miterLimit=j.miterLimit;i.shadowBlur=j.shadowBlur;i.shadowColor=j.shadowColor;i.shadowOffsetX=j.shadowOffsetX;i.shadowOffsetY=j.shadowOffsetY;i.strokeStyle=j.strokeStyle;i.globalAlpha=j.globalAlpha;i.font=j.font;i.textAlign=j.textAlign;i.textBaseline=j.textBaseline;i.arcScaleX_=j.arcScaleX_;i.arcScaleY_=j.arcScaleY_;i.lineScale_=j.lineScale_}var b={aliceblue:"#F0F8FF",antiquewhite:"#FAEBD7",aquamarine:"#7FFFD4",azure:"#F0FFFF",beige:"#F5F5DC",bisque:"#FFE4C4",black:"#000000",blanchedalmond:"#FFEBCD",blueviolet:"#8A2BE2",brown:"#A52A2A",burlywood:"#DEB887",cadetblue:"#5F9EA0",chartreuse:"#7FFF00",chocolate:"#D2691E",coral:"#FF7F50",cornflowerblue:"#6495ED",cornsilk:"#FFF8DC",crimson:"#DC143C",cyan:"#00FFFF",darkblue:"#00008B",darkcyan:"#008B8B",darkgoldenrod:"#B8860B",darkgray:"#A9A9A9",darkgreen:"#006400",darkgrey:"#A9A9A9",darkkhaki:"#BDB76B",darkmagenta:"#8B008B",darkolivegreen:"#556B2F",darkorange:"#FF8C00",darkorchid:"#9932CC",darkred:"#8B0000",darksalmon:"#E9967A",darkseagreen:"#8FBC8F",darkslateblue:"#483D8B",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",darkturquoise:"#00CED1",darkviolet:"#9400D3",deeppink:"#FF1493",deepskyblue:"#00BFFF",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1E90FF",firebrick:"#B22222",floralwhite:"#FFFAF0",forestgreen:"#228B22",gainsboro:"#DCDCDC",ghostwhite:"#F8F8FF",gold:"#FFD700",goldenrod:"#DAA520",grey:"#808080",greenyellow:"#ADFF2F",honeydew:"#F0FFF0",hotpink:"#FF69B4",indianred:"#CD5C5C",indigo:"#4B0082",ivory:"#FFFFF0",khaki:"#F0E68C",lavender:"#E6E6FA",lavenderblush:"#FFF0F5",lawngreen:"#7CFC00",lemonchiffon:"#FFFACD",lightblue:"#ADD8E6",lightcoral:"#F08080",lightcyan:"#E0FFFF",lightgoldenrodyellow:"#FAFAD2",lightgreen:"#90EE90",lightgrey:"#D3D3D3",lightpink:"#FFB6C1",lightsalmon:"#FFA07A",lightseagreen:"#20B2AA",lightskyblue:"#87CEFA",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#B0C4DE",lightyellow:"#FFFFE0",limegreen:"#32CD32",linen:"#FAF0E6",magenta:"#FF00FF",mediumaquamarine:"#66CDAA",mediumblue:"#0000CD",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",mediumseagreen:"#3CB371",mediumslateblue:"#7B68EE",mediumspringgreen:"#00FA9A",mediumturquoise:"#48D1CC",mediumvioletred:"#C71585",midnightblue:"#191970",mintcream:"#F5FFFA",mistyrose:"#FFE4E1",moccasin:"#FFE4B5",navajowhite:"#FFDEAD",oldlace:"#FDF5E6",olivedrab:"#6B8E23",orange:"#FFA500",orangered:"#FF4500",orchid:"#DA70D6",palegoldenrod:"#EEE8AA",palegreen:"#98FB98",paleturquoise:"#AFEEEE",palevioletred:"#DB7093",papayawhip:"#FFEFD5",peachpuff:"#FFDAB9",peru:"#CD853F",pink:"#FFC0CB",plum:"#DDA0DD",powderblue:"#B0E0E6",rosybrown:"#BC8F8F",royalblue:"#4169E1",saddlebrown:"#8B4513",salmon:"#FA8072",sandybrown:"#F4A460",seagreen:"#2E8B57",seashell:"#FFF5EE",sienna:"#A0522D",skyblue:"#87CEEB",slateblue:"#6A5ACD",slategray:"#708090",slategrey:"#708090",snow:"#FFFAFA",springgreen:"#00FF7F",steelblue:"#4682B4",tan:"#D2B48C",thistle:"#D8BFD8",tomato:"#FF6347",turquoise:"#40E0D0",violet:"#EE82EE",wheat:"#F5DEB3",whitesmoke:"#F5F5F5",yellowgreen:"#9ACD32"};function M(j){var p=j.indexOf("(",3);var i=j.indexOf(")",p+1);var m=j.substring(p+1,i).split(",");if(m.length!=4||j.charAt(3)!="a"){m[3]=1}return m}function c(i){return parseFloat(i)/100}function r(j,m,i){return Math.min(i,Math.max(m,j))}function I(ag){var i,ai,aj,ah,ak,Z;ah=parseFloat(ag[0])/360%360;if(ah<0){ah++}ak=r(c(ag[1]),0,1);Z=r(c(ag[2]),0,1);if(ak==0){i=ai=aj=Z}else{var j=Z<0.5?Z*(1+ak):Z+ak-Z*ak;var m=2*Z-j;i=a(m,j,ah+1/3);ai=a(m,j,ah);aj=a(m,j,ah-1/3)}return"#"+k[Math.floor(i*255)]+k[Math.floor(ai*255)]+k[Math.floor(aj*255)]}function a(j,i,m){if(m<0){m++}if(m>1){m--}if(6*m<1){return j+(i-j)*6*m}else{if(2*m<1){return i}else{if(3*m<2){return j+(i-j)*(2/3-m)*6}else{return j}}}}var C={};function F(j){if(j in C){return C[j]}var ag,Z=1;j=String(j);if(j.charAt(0)=="#"){ag=j}else{if(/^rgb/.test(j)){var p=M(j);var ag="#",ah;for(var m=0;m<3;m++){if(p[m].indexOf("%")!=-1){ah=Math.floor(c(p[m])*255)}else{ah=+p[m]}ag+=k[r(ah,0,255)]}Z=+p[3]}else{if(/^hsl/.test(j)){var p=M(j);ag=I(p);Z=p[3]}else{ag=b[j]||j}}}return C[j]={color:ag,alpha:Z}}var o={style:"normal",variant:"normal",weight:"normal",size:10,family:"sans-serif"};var L={};function E(i){if(L[i]){return L[i]}var p=document.createElement("div");var m=p.style;try{m.font=i}catch(j){}return L[i]={style:m.fontStyle||o.style,variant:m.fontVariant||o.variant,weight:m.fontWeight||o.weight,size:m.fontSize||o.size,family:m.fontFamily||o.family}}function u(m,j){var i={};for(var ah in m){i[ah]=m[ah]}var ag=parseFloat(j.currentStyle.fontSize),Z=parseFloat(m.size);if(typeof m.size=="number"){i.size=m.size}else{if(m.size.indexOf("px")!=-1){i.size=Z}else{if(m.size.indexOf("em")!=-1){i.size=ag*Z}else{if(m.size.indexOf("%")!=-1){i.size=(ag/100)*Z}else{if(m.size.indexOf("pt")!=-1){i.size=Z/0.75}else{i.size=ag}}}}}i.size*=0.981;i.family="'"+i.family.replace(/(\'|\")/g,"").replace(/\s*,\s*/g,"', '")+"'";return i}function ac(i){return i.style+" "+i.variant+" "+i.weight+" "+i.size+"px "+i.family}var s={butt:"flat",round:"round"};function S(i){return s[i]||"square"}function D(i){this.m_=B();this.mStack_=[];this.aStack_=[];this.currentPath_=[];this.strokeStyle="#000";this.fillStyle="#000";this.lineWidth=1;this.lineJoin="miter";this.lineCap="butt";this.miterLimit=d*1;this.globalAlpha=1;this.font="10px sans-serif";this.textAlign="left";this.textBaseline="alphabetic";this.canvas=i;var m="width:"+i.clientWidth+"px;height:"+i.clientHeight+"px;overflow:hidden;position:absolute";var j=i.ownerDocument.createElement("div");j.style.cssText=m;i.appendChild(j);var p=j.cloneNode(false);p.style.backgroundColor="red";p.style.filter="alpha(opacity=0)";i.appendChild(p);this.element_=j;this.arcScaleX_=1;this.arcScaleY_=1;this.lineScale_=1}var q=D.prototype;q.clearRect=function(){if(this.textMeasureEl_){this.textMeasureEl_.removeNode(true);this.textMeasureEl_=null}this.element_.innerHTML=""};q.beginPath=function(){this.currentPath_=[]};q.moveTo=function(j,i){var m=V(this,j,i);this.currentPath_.push({type:"moveTo",x:m.x,y:m.y});this.currentX_=m.x;this.currentY_=m.y};q.lineTo=function(j,i){var m=V(this,j,i);this.currentPath_.push({type:"lineTo",x:m.x,y:m.y});this.currentX_=m.x;this.currentY_=m.y};q.bezierCurveTo=function(m,j,ak,aj,ai,ag){var i=V(this,ai,ag);var ah=V(this,m,j);var Z=V(this,ak,aj);K(this,ah,Z,i)};function K(i,Z,m,j){i.currentPath_.push({type:"bezierCurveTo",cp1x:Z.x,cp1y:Z.y,cp2x:m.x,cp2y:m.y,x:j.x,y:j.y});i.currentX_=j.x;i.currentY_=j.y}q.quadraticCurveTo=function(ai,m,j,i){var ah=V(this,ai,m);var ag=V(this,j,i);var aj={x:this.currentX_+2/3*(ah.x-this.currentX_),y:this.currentY_+2/3*(ah.y-this.currentY_)};var Z={x:aj.x+(ag.x-this.currentX_)/3,y:aj.y+(ag.y-this.currentY_)/3};K(this,aj,Z,ag)};q.arc=function(al,aj,ak,ag,j,m){ak*=d;var ap=m?"at":"wa";var am=al+A(ag)*ak-f;var ao=aj+l(ag)*ak-f;var i=al+A(j)*ak-f;var an=aj+l(j)*ak-f;if(am==i&&!m){am+=0.125}var Z=V(this,al,aj);var ai=V(this,am,ao);var ah=V(this,i,an);this.currentPath_.push({type:ap,x:Z.x,y:Z.y,radius:ak,xStart:ai.x,yStart:ai.y,xEnd:ah.x,yEnd:ah.y})};q.rect=function(m,j,i,p){this.moveTo(m,j);this.lineTo(m+i,j);this.lineTo(m+i,j+p);this.lineTo(m,j+p);this.closePath()};q.strokeRect=function(m,j,i,p){var Z=this.currentPath_;this.beginPath();this.moveTo(m,j);this.lineTo(m+i,j);this.lineTo(m+i,j+p);this.lineTo(m,j+p);this.closePath();this.stroke();this.currentPath_=Z};q.fillRect=function(m,j,i,p){var Z=this.currentPath_;this.beginPath();this.moveTo(m,j);this.lineTo(m+i,j);this.lineTo(m+i,j+p);this.lineTo(m,j+p);this.closePath();this.fill();this.currentPath_=Z};q.createLinearGradient=function(j,p,i,m){var Z=new U("gradient");Z.x0_=j;Z.y0_=p;Z.x1_=i;Z.y1_=m;return Z};q.createRadialGradient=function(p,ag,m,j,Z,i){var ah=new U("gradientradial");ah.x0_=p;ah.y0_=ag;ah.r0_=m;ah.x1_=j;ah.y1_=Z;ah.r1_=i;return ah};q.drawImage=function(aq,m){var aj,ah,al,ay,ao,am,at,aA;var ak=aq.runtimeStyle.width;var ap=aq.runtimeStyle.height;aq.runtimeStyle.width="auto";aq.runtimeStyle.height="auto";var ai=aq.width;var aw=aq.height;aq.runtimeStyle.width=ak;aq.runtimeStyle.height=ap;if(arguments.length==3){aj=arguments[1];ah=arguments[2];ao=am=0;at=al=ai;aA=ay=aw}else{if(arguments.length==5){aj=arguments[1];ah=arguments[2];al=arguments[3];ay=arguments[4];ao=am=0;at=ai;aA=aw}else{if(arguments.length==9){ao=arguments[1];am=arguments[2];at=arguments[3];aA=arguments[4];aj=arguments[5];ah=arguments[6];al=arguments[7];ay=arguments[8]}else{throw Error("Invalid number of arguments")}}}var az=V(this,aj,ah);var p=at/2;var j=aA/2;var ax=[];var i=10;var ag=10;ax.push(" <g_vml_:group",' coordsize="',d*i,",",d*ag,'"',' coordorigin="0,0"',' style="width:',i,"px;height:",ag,"px;position:absolute;");if(this.m_[0][0]!=1||this.m_[0][1]||this.m_[1][1]!=1||this.m_[1][0]){var Z=[];Z.push("M11=",this.m_[0][0],",","M12=",this.m_[1][0],",","M21=",this.m_[0][1],",","M22=",this.m_[1][1],",","Dx=",n(az.x/d),",","Dy=",n(az.y/d),"");var av=az;var au=V(this,aj+al,ah);var ar=V(this,aj,ah+ay);var an=V(this,aj+al,ah+ay);av.x=ab.max(av.x,au.x,ar.x,an.x);av.y=ab.max(av.y,au.y,ar.y,an.y);ax.push("padding:0 ",n(av.x/d),"px ",n(av.y/d),"px 0;filter:progid:DXImageTransform.Microsoft.Matrix(",Z.join(""),", sizingmethod='clip');")}else{ax.push("top:",n(az.y/d),"px;left:",n(az.x/d),"px;")}ax.push(' ">','<g_vml_:image src="',aq.src,'"',' style="width:',d*al,"px;"," height:",d*ay,'px"',' cropleft="',ao/ai,'"',' croptop="',am/aw,'"',' cropright="',(ai-ao-at)/ai,'"',' cropbottom="',(aw-am-aA)/aw,'"'," />","</g_vml_:group>");this.element_.insertAdjacentHTML("BeforeEnd",ax.join(""))};q.stroke=function(al){var aj=[];var Z=false;var m=10;var am=10;aj.push("<g_vml_:shape",' filled="',!!al,'"',' style="position:absolute;width:',m,"px;height:",am,'px;"',' coordorigin="0,0"',' coordsize="',d*m,",",d*am,'"',' stroked="',!al,'"',' path="');var an=false;var ag={x:null,y:null};var ak={x:null,y:null};for(var ah=0;ah<this.currentPath_.length;ah++){var j=this.currentPath_[ah];var ai;switch(j.type){case"moveTo":ai=j;aj.push(" m ",n(j.x),",",n(j.y));break;case"lineTo":aj.push(" l ",n(j.x),",",n(j.y));break;case"close":aj.push(" x ");j=null;break;case"bezierCurveTo":aj.push(" c ",n(j.cp1x),",",n(j.cp1y),",",n(j.cp2x),",",n(j.cp2y),",",n(j.x),",",n(j.y));break;case"at":case"wa":aj.push(" ",j.type," ",n(j.x-this.arcScaleX_*j.radius),",",n(j.y-this.arcScaleY_*j.radius)," ",n(j.x+this.arcScaleX_*j.radius),",",n(j.y+this.arcScaleY_*j.radius)," ",n(j.xStart),",",n(j.yStart)," ",n(j.xEnd),",",n(j.yEnd));break}if(j){if(ag.x==null||j.x<ag.x){ag.x=j.x}if(ak.x==null||j.x>ak.x){ak.x=j.x}if(ag.y==null||j.y<ag.y){ag.y=j.y}if(ak.y==null||j.y>ak.y){ak.y=j.y}}}aj.push(' ">');if(!al){w(this,aj)}else{G(this,aj,ag,ak)}aj.push("</g_vml_:shape>");this.element_.insertAdjacentHTML("beforeEnd",aj.join(""))};function w(m,ag){var j=F(m.strokeStyle);var p=j.color;var Z=j.alpha*m.globalAlpha;var i=m.lineScale_*m.lineWidth;if(i<1){Z*=i}ag.push("<g_vml_:stroke",' opacity="',Z,'"',' joinstyle="',m.lineJoin,'"',' miterlimit="',m.miterLimit,'"',' endcap="',S(m.lineCap),'"',' weight="',i,'px"',' color="',p,'" />')}function G(aq,ai,aK,ar){var aj=aq.fillStyle;var aB=aq.arcScaleX_;var aA=aq.arcScaleY_;var j=ar.x-aK.x;var p=ar.y-aK.y;if(aj instanceof U){var an=0;var aF={x:0,y:0};var ax=0;var am=1;if(aj.type_=="gradient"){var al=aj.x0_/aB;var m=aj.y0_/aA;var ak=aj.x1_/aB;var aM=aj.y1_/aA;var aJ=V(aq,al,m);var aI=V(aq,ak,aM);var ag=aI.x-aJ.x;var Z=aI.y-aJ.y;an=Math.atan2(ag,Z)*180/Math.PI;if(an<0){an+=360}if(an<0.000001){an=0}}else{var aJ=V(aq,aj.x0_,aj.y0_);aF={x:(aJ.x-aK.x)/j,y:(aJ.y-aK.y)/p};j/=aB*d;p/=aA*d;var aD=ab.max(j,p);ax=2*aj.r0_/aD;am=2*aj.r1_/aD-ax}var av=aj.colors_;av.sort(function(aN,i){return aN.offset-i.offset});var ap=av.length;var au=av[0].color;var at=av[ap-1].color;var az=av[0].alpha*aq.globalAlpha;var ay=av[ap-1].alpha*aq.globalAlpha;var aE=[];for(var aH=0;aH<ap;aH++){var ao=av[aH];aE.push(ao.offset*am+ax+" "+ao.color)}ai.push('<g_vml_:fill type="',aj.type_,'"',' method="none" focus="100%"',' color="',au,'"',' color2="',at,'"',' colors="',aE.join(","),'"',' opacity="',ay,'"',' g_o_:opacity2="',az,'"',' angle="',an,'"',' focusposition="',aF.x,",",aF.y,'" />')}else{if(aj instanceof T){if(j&&p){var ah=-aK.x;var aC=-aK.y;ai.push("<g_vml_:fill",' position="',ah/j*aB*aB,",",aC/p*aA*aA,'"',' type="tile"',' src="',aj.src_,'" />')}}else{var aL=F(aq.fillStyle);var aw=aL.color;var aG=aL.alpha*aq.globalAlpha;ai.push('<g_vml_:fill color="',aw,'" opacity="',aG,'" />')}}}q.fill=function(){this.stroke(true)};q.closePath=function(){this.currentPath_.push({type:"close"})};function V(j,Z,p){var i=j.m_;return{x:d*(Z*i[0][0]+p*i[1][0]+i[2][0])-f,y:d*(Z*i[0][1]+p*i[1][1]+i[2][1])-f}}q.save=function(){var i={};v(this,i);this.aStack_.push(i);this.mStack_.push(this.m_);this.m_=J(B(),this.m_)};q.restore=function(){if(this.aStack_.length){v(this.aStack_.pop(),this);this.m_=this.mStack_.pop()}};function h(i){return isFinite(i[0][0])&&isFinite(i[0][1])&&isFinite(i[1][0])&&isFinite(i[1][1])&&isFinite(i[2][0])&&isFinite(i[2][1])}function aa(j,i,p){if(!h(i)){return}j.m_=i;if(p){var Z=i[0][0]*i[1][1]-i[0][1]*i[1][0];j.lineScale_=N(H(Z))}}q.translate=function(m,j){var i=[[1,0,0],[0,1,0],[m,j,1]];aa(this,J(i,this.m_),false)};q.rotate=function(j){var p=A(j);var m=l(j);var i=[[p,m,0],[-m,p,0],[0,0,1]];aa(this,J(i,this.m_),false)};q.scale=function(m,j){this.arcScaleX_*=m;this.arcScaleY_*=j;var i=[[m,0,0],[0,j,0],[0,0,1]];aa(this,J(i,this.m_),true)};q.transform=function(Z,p,ah,ag,j,i){var m=[[Z,p,0],[ah,ag,0],[j,i,1]];aa(this,J(m,this.m_),true)};q.setTransform=function(ag,Z,ai,ah,p,j){var i=[[ag,Z,0],[ai,ah,0],[p,j,1]];aa(this,i,true)};q.drawText_=function(am,ak,aj,ap,ai){var ao=this.m_,at=1000,j=0,ar=at,ah={x:0,y:0},ag=[];var i=u(E(this.font),this.element_);var p=ac(i);var au=this.element_.currentStyle;var Z=this.textAlign.toLowerCase();switch(Z){case"left":case"center":case"right":break;case"end":Z=au.direction=="ltr"?"right":"left";break;case"start":Z=au.direction=="rtl"?"right":"left";break;default:Z="left"}switch(this.textBaseline){case"hanging":case"top":ah.y=i.size/1.75;break;case"middle":break;default:case null:case"alphabetic":case"ideographic":case"bottom":ah.y=-i.size/2.25;break}switch(Z){case"right":j=at;ar=0.05;break;case"center":j=ar=at/2;break}var aq=V(this,ak+ah.x,aj+ah.y);ag.push('<g_vml_:line from="',-j,' 0" to="',ar,' 0.05" ',' coordsize="100 100" coordorigin="0 0"',' filled="',!ai,'" stroked="',!!ai,'" style="position:absolute;width:1px;height:1px;">');if(ai){w(this,ag)}else{G(this,ag,{x:-j,y:0},{x:ar,y:i.size})}var an=ao[0][0].toFixed(3)+","+ao[1][0].toFixed(3)+","+ao[0][1].toFixed(3)+","+ao[1][1].toFixed(3)+",0,0";var al=n(aq.x/d+1-ao[0][0])+","+n(aq.y/d-2*ao[1][0]);ag.push('<g_vml_:skew on="t" matrix="',an,'" ',' offset="',al,'" origin="',j,' 0" />','<g_vml_:path textpathok="true" />','<g_vml_:textpath on="true" string="',af(am),'" style="v-text-align:',Z,";font:",af(p),'" /></g_vml_:line>');this.element_.insertAdjacentHTML("beforeEnd",ag.join(""))};q.fillText=function(m,i,p,j){this.drawText_(m,i,p,j,false)};q.strokeText=function(m,i,p,j){this.drawText_(m,i,p,j,true)};q.measureText=function(m){if(!this.textMeasureEl_){var i='<span style="position:absolute;top:-20000px;left:0;padding:0;margin:0;border:none;white-space:pre;"></span>';this.element_.insertAdjacentHTML("beforeEnd",i);this.textMeasureEl_=this.element_.lastChild}var j=this.element_.ownerDocument;this.textMeasureEl_.innerHTML="";this.textMeasureEl_.style.font=this.font;this.textMeasureEl_.appendChild(j.createTextNode(m));return{width:this.textMeasureEl_.offsetWidth}};q.clip=function(){};q.arcTo=function(){};q.createPattern=function(j,i){return new T(j,i)};function U(i){this.type_=i;this.x0_=0;this.y0_=0;this.r0_=0;this.x1_=0;this.y1_=0;this.r1_=0;this.colors_=[]}U.prototype.addColorStop=function(j,i){i=F(i);this.colors_.push({offset:j,color:i.color,alpha:i.alpha})};function T(j,i){Q(j);switch(i){case"repeat":case null:case"":this.repetition_="repeat";break;case"repeat-x":case"repeat-y":case"no-repeat":this.repetition_=i;break;default:O("SYNTAX_ERR")}this.src_=j.src;this.width_=j.width;this.height_=j.height}function O(i){throw new P(i)}function Q(i){if(!i||i.nodeType!=1||i.tagName!="IMG"){O("TYPE_MISMATCH_ERR")}if(i.readyState!="complete"){O("INVALID_STATE_ERR")}}function P(i){this.code=this[i];this.message=i+": DOM Exception "+this.code}var X=P.prototype=new Error;X.INDEX_SIZE_ERR=1;X.DOMSTRING_SIZE_ERR=2;X.HIERARCHY_REQUEST_ERR=3;X.WRONG_DOCUMENT_ERR=4;X.INVALID_CHARACTER_ERR=5;X.NO_DATA_ALLOWED_ERR=6;X.NO_MODIFICATION_ALLOWED_ERR=7;X.NOT_FOUND_ERR=8;X.NOT_SUPPORTED_ERR=9;X.INUSE_ATTRIBUTE_ERR=10;X.INVALID_STATE_ERR=11;X.SYNTAX_ERR=12;X.INVALID_MODIFICATION_ERR=13;X.NAMESPACE_ERR=14;X.INVALID_ACCESS_ERR=15;X.VALIDATION_ERR=16;X.TYPE_MISMATCH_ERR=17;G_vmlCanvasManager=e;CanvasRenderingContext2D=D;CanvasGradient=U;CanvasPattern=T;DOMException=P;G_vmlCanvasManager._version=888})()};/*! jQuery v1.6.4 http://jquery.com/ | http://jquery.org/license */
(function(a,b){function cu(a){return f.isWindow(a)?a:a.nodeType===9?a.defaultView||a.parentWindow:!1}function cr(a){if(!cg[a]){var b=c.body,d=f("<"+a+">").appendTo(b),e=d.css("display");d.remove();if(e==="none"||e===""){ch||(ch=c.createElement("iframe"),ch.frameBorder=ch.width=ch.height=0),b.appendChild(ch);if(!ci||!ch.createElement)ci=(ch.contentWindow||ch.contentDocument).document,ci.write((c.compatMode==="CSS1Compat"?"<!doctype html>":"")+"<html><body>"),ci.close();d=ci.createElement(a),ci.body.appendChild(d),e=f.css(d,"display"),b.removeChild(ch)}cg[a]=e}return cg[a]}function cq(a,b){var c={};f.each(cm.concat.apply([],cm.slice(0,b)),function(){c[this]=a});return c}function cp(){cn=b}function co(){setTimeout(cp,0);return cn=f.now()}function cf(){try{return new a.ActiveXObject("Microsoft.XMLHTTP")}catch(b){}}function ce(){try{return new a.XMLHttpRequest}catch(b){}}function b$(a,c){a.dataFilter&&(c=a.dataFilter(c,a.dataType));var d=a.dataTypes,e={},g,h,i=d.length,j,k=d[0],l,m,n,o,p;for(g=1;g<i;g++){if(g===1)for(h in a.converters)typeof h=="string"&&(e[h.toLowerCase()]=a.converters[h]);l=k,k=d[g];if(k==="*")k=l;else if(l!=="*"&&l!==k){m=l+" "+k,n=e[m]||e["* "+k];if(!n){p=b;for(o in e){j=o.split(" ");if(j[0]===l||j[0]==="*"){p=e[j[1]+" "+k];if(p){o=e[o],o===!0?n=p:p===!0&&(n=o);break}}}}!n&&!p&&f.error("No conversion from "+m.replace(" "," to ")),n!==!0&&(c=n?n(c):p(o(c)))}}return c}function bZ(a,c,d){var e=a.contents,f=a.dataTypes,g=a.responseFields,h,i,j,k;for(i in g)i in d&&(c[g[i]]=d[i]);while(f[0]==="*")f.shift(),h===b&&(h=a.mimeType||c.getResponseHeader("content-type"));if(h)for(i in e)if(e[i]&&e[i].test(h)){f.unshift(i);break}if(f[0]in d)j=f[0];else{for(i in d){if(!f[0]||a.converters[i+" "+f[0]]){j=i;break}k||(k=i)}j=j||k}if(j){j!==f[0]&&f.unshift(j);return d[j]}}function bY(a,b,c,d){if(f.isArray(b))f.each(b,function(b,e){c||bA.test(a)?d(a,e):bY(a+"["+(typeof e=="object"||f.isArray(e)?b:"")+"]",e,c,d)});else if(!c&&b!=null&&typeof b=="object")for(var e in b)bY(a+"["+e+"]",b[e],c,d);else d(a,b)}function bX(a,c){var d,e,g=f.ajaxSettings.flatOptions||{};for(d in c)c[d]!==b&&((g[d]?a:e||(e={}))[d]=c[d]);e&&f.extend(!0,a,e)}function bW(a,c,d,e,f,g){f=f||c.dataTypes[0],g=g||{},g[f]=!0;var h=a[f],i=0,j=h?h.length:0,k=a===bP,l;for(;i<j&&(k||!l);i++)l=h[i](c,d,e),typeof l=="string"&&(!k||g[l]?l=b:(c.dataTypes.unshift(l),l=bW(a,c,d,e,l,g)));(k||!l)&&!g["*"]&&(l=bW(a,c,d,e,"*",g));return l}function bV(a){return function(b,c){typeof b!="string"&&(c=b,b="*");if(f.isFunction(c)){var d=b.toLowerCase().split(bL),e=0,g=d.length,h,i,j;for(;e<g;e++)h=d[e],j=/^\+/.test(h),j&&(h=h.substr(1)||"*"),i=a[h]=a[h]||[],i[j?"unshift":"push"](c)}}}function by(a,b,c){var d=b==="width"?a.offsetWidth:a.offsetHeight,e=b==="width"?bt:bu;if(d>0){c!=="border"&&f.each(e,function(){c||(d-=parseFloat(f.css(a,"padding"+this))||0),c==="margin"?d+=parseFloat(f.css(a,c+this))||0:d-=parseFloat(f.css(a,"border"+this+"Width"))||0});return d+"px"}d=bv(a,b,b);if(d<0||d==null)d=a.style[b]||0;d=parseFloat(d)||0,c&&f.each(e,function(){d+=parseFloat(f.css(a,"padding"+this))||0,c!=="padding"&&(d+=parseFloat(f.css(a,"border"+this+"Width"))||0),c==="margin"&&(d+=parseFloat(f.css(a,c+this))||0)});return d+"px"}function bl(a,b){b.src?f.ajax({url:b.src,async:!1,dataType:"script"}):f.globalEval((b.text||b.textContent||b.innerHTML||"").replace(bd,"/*$0*/")),b.parentNode&&b.parentNode.removeChild(b)}function bk(a){f.nodeName(a,"input")?bj(a):"getElementsByTagName"in a&&f.grep(a.getElementsByTagName("input"),bj)}function bj(a){if(a.type==="checkbox"||a.type==="radio")a.defaultChecked=a.checked}function bi(a){return"getElementsByTagName"in a?a.getElementsByTagName("*"):"querySelectorAll"in a?a.querySelectorAll("*"):[]}function bh(a,b){var c;if(b.nodeType===1){b.clearAttributes&&b.clearAttributes(),b.mergeAttributes&&b.mergeAttributes(a),c=b.nodeName.toLowerCase();if(c==="object")b.outerHTML=a.outerHTML;else if(c!=="input"||a.type!=="checkbox"&&a.type!=="radio"){if(c==="option")b.selected=a.defaultSelected;else if(c==="input"||c==="textarea")b.defaultValue=a.defaultValue}else a.checked&&(b.defaultChecked=b.checked=a.checked),b.value!==a.value&&(b.value=a.value);b.removeAttribute(f.expando)}}function bg(a,b){if(b.nodeType===1&&!!f.hasData(a)){var c=f.expando,d=f.data(a),e=f.data(b,d);if(d=d[c]){var g=d.events;e=e[c]=f.extend({},d);if(g){delete e.handle,e.events={};for(var h in g)for(var i=0,j=g[h].length;i<j;i++)f.event.add(b,h+(g[h][i].namespace?".":"")+g[h][i].namespace,g[h][i],g[h][i].data)}}}}function bf(a,b){return f.nodeName(a,"table")?a.getElementsByTagName("tbody")[0]||a.appendChild(a.ownerDocument.createElement("tbody")):a}function V(a,b,c){b=b||0;if(f.isFunction(b))return f.grep(a,function(a,d){var e=!!b.call(a,d,a);return e===c});if(b.nodeType)return f.grep(a,function(a,d){return a===b===c});if(typeof b=="string"){var d=f.grep(a,function(a){return a.nodeType===1});if(Q.test(b))return f.filter(b,d,!c);b=f.filter(b,d)}return f.grep(a,function(a,d){return f.inArray(a,b)>=0===c})}function U(a){return!a||!a.parentNode||a.parentNode.nodeType===11}function M(a,b){return(a&&a!=="*"?a+".":"")+b.replace(y,"`").replace(z,"&")}function L(a){var b,c,d,e,g,h,i,j,k,l,m,n,o,p=[],q=[],r=f._data(this,"events");if(!(a.liveFired===this||!r||!r.live||a.target.disabled||a.button&&a.type==="click")){a.namespace&&(n=new RegExp("(^|\\.)"+a.namespace.split(".").join("\\.(?:.*\\.)?")+"(\\.|$)")),a.liveFired=this;var s=r.live.slice(0);for(i=0;i<s.length;i++)g=s[i],g.origType.replace(w,"")===a.type?q.push(g.selector):s.splice(i--,1);e=f(a.target).closest(q,a.currentTarget);for(j=0,k=e.length;j<k;j++){m=e[j];for(i=0;i<s.length;i++){g=s[i];if(m.selector===g.selector&&(!n||n.test(g.namespace))&&!m.elem.disabled){h=m.elem,d=null;if(g.preType==="mouseenter"||g.preType==="mouseleave")a.type=g.preType,d=f(a.relatedTarget).closest(g.selector)[0],d&&f.contains(h,d)&&(d=h);(!d||d!==h)&&p.push({elem:h,handleObj:g,level:m.level})}}}for(j=0,k=p.length;j<k;j++){e=p[j];if(c&&e.level>c)break;a.currentTarget=e.elem,a.data=e.handleObj.data,a.handleObj=e.handleObj,o=e.handleObj.origHandler.apply(e.elem,arguments);if(o===!1||a.isPropagationStopped()){c=e.level,o===!1&&(b=!1);if(a.isImmediatePropagationStopped())break}}return b}}function J(a,c,d){var e=f.extend({},d[0]);e.type=a,e.originalEvent={},e.liveFired=b,f.event.handle.call(c,e),e.isDefaultPrevented()&&d[0].preventDefault()}function D(){return!0}function C(){return!1}function m(a,c,d){var e=c+"defer",g=c+"queue",h=c+"mark",i=f.data(a,e,b,!0);i&&(d==="queue"||!f.data(a,g,b,!0))&&(d==="mark"||!f.data(a,h,b,!0))&&setTimeout(function(){!f.data(a,g,b,!0)&&!f.data(a,h,b,!0)&&(f.removeData(a,e,!0),i.resolve())},0)}function l(a){for(var b in a)if(b!=="toJSON")return!1;return!0}function k(a,c,d){if(d===b&&a.nodeType===1){var e="data-"+c.replace(j,"-$1").toLowerCase();d=a.getAttribute(e);if(typeof d=="string"){try{d=d==="true"?!0:d==="false"?!1:d==="null"?null:f.isNaN(d)?i.test(d)?f.parseJSON(d):d:parseFloat(d)}catch(g){}f.data(a,c,d)}else d=b}return d}var c=a.document,d=a.navigator,e=a.location,f=function(){function K(){if(!e.isReady){try{c.documentElement.doScroll("left")}catch(a){setTimeout(K,1);return}e.ready()}}var e=function(a,b){return new e.fn.init(a,b,h)},f=a.jQuery,g=a.$,h,i=/^(?:[^#<]*(<[\w\W]+>)[^>]*$|#([\w\-]*)$)/,j=/\S/,k=/^\s+/,l=/\s+$/,m=/\d/,n=/^<(\w+)\s*\/?>(?:<\/\1>)?$/,o=/^[\],:{}\s]*$/,p=/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,q=/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,r=/(?:^|:|,)(?:\s*\[)+/g,s=/(webkit)[ \/]([\w.]+)/,t=/(opera)(?:.*version)?[ \/]([\w.]+)/,u=/(msie) ([\w.]+)/,v=/(mozilla)(?:.*? rv:([\w.]+))?/,w=/-([a-z]|[0-9])/ig,x=/^-ms-/,y=function(a,b){return(b+"").toUpperCase()},z=d.userAgent,A,B,C,D=Object.prototype.toString,E=Object.prototype.hasOwnProperty,F=Array.prototype.push,G=Array.prototype.slice,H=String.prototype.trim,I=Array.prototype.indexOf,J={};e.fn=e.prototype={constructor:e,init:function(a,d,f){var g,h,j,k;if(!a)return this;if(a.nodeType){this.context=this[0]=a,this.length=1;return this}if(a==="body"&&!d&&c.body){this.context=c,this[0]=c.body,this.selector=a,this.length=1;return this}if(typeof a=="string"){a.charAt(0)!=="<"||a.charAt(a.length-1)!==">"||a.length<3?g=i.exec(a):g=[null,a,null];if(g&&(g[1]||!d)){if(g[1]){d=d instanceof e?d[0]:d,k=d?d.ownerDocument||d:c,j=n.exec(a),j?e.isPlainObject(d)?(a=[c.createElement(j[1])],e.fn.attr.call(a,d,!0)):a=[k.createElement(j[1])]:(j=e.buildFragment([g[1]],[k]),a=(j.cacheable?e.clone(j.fragment):j.fragment).childNodes);return e.merge(this,a)}h=c.getElementById(g[2]);if(h&&h.parentNode){if(h.id!==g[2])return f.find(a);this.length=1,this[0]=h}this.context=c,this.selector=a;return this}return!d||d.jquery?(d||f).find(a):this.constructor(d).find(a)}if(e.isFunction(a))return f.ready(a);a.selector!==b&&(this.selector=a.selector,this.context=a.context);return e.makeArray(a,this)},selector:"",jquery:"1.6.4",length:0,size:function(){return this.length},toArray:function(){return G.call(this,0)},get:function(a){return a==null?this.toArray():a<0?this[this.length+a]:this[a]},pushStack:function(a,b,c){var d=this.constructor();e.isArray(a)?F.apply(d,a):e.merge(d,a),d.prevObject=this,d.context=this.context,b==="find"?d.selector=this.selector+(this.selector?" ":"")+c:b&&(d.selector=this.selector+"."+b+"("+c+")");return d},each:function(a,b){return e.each(this,a,b)},ready:function(a){e.bindReady(),B.done(a);return this},eq:function(a){return a===-1?this.slice(a):this.slice(a,+a+1)},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},slice:function(){return this.pushStack(G.apply(this,arguments),"slice",G.call(arguments).join(","))},map:function(a){return this.pushStack(e.map(this,function(b,c){return a.call(b,c,b)}))},end:function(){return this.prevObject||this.constructor(null)},push:F,sort:[].sort,splice:[].splice},e.fn.init.prototype=e.fn,e.extend=e.fn.extend=function(){var a,c,d,f,g,h,i=arguments[0]||{},j=1,k=arguments.length,l=!1;typeof i=="boolean"&&(l=i,i=arguments[1]||{},j=2),typeof i!="object"&&!e.isFunction(i)&&(i={}),k===j&&(i=this,--j);for(;j<k;j++)if((a=arguments[j])!=null)for(c in a){d=i[c],f=a[c];if(i===f)continue;l&&f&&(e.isPlainObject(f)||(g=e.isArray(f)))?(g?(g=!1,h=d&&e.isArray(d)?d:[]):h=d&&e.isPlainObject(d)?d:{},i[c]=e.extend(l,h,f)):f!==b&&(i[c]=f)}return i},e.extend({noConflict:function(b){a.$===e&&(a.$=g),b&&a.jQuery===e&&(a.jQuery=f);return e},isReady:!1,readyWait:1,holdReady:function(a){a?e.readyWait++:e.ready(!0)},ready:function(a){if(a===!0&&!--e.readyWait||a!==!0&&!e.isReady){if(!c.body)return setTimeout(e.ready,1);e.isReady=!0;if(a!==!0&&--e.readyWait>0)return;B.resolveWith(c,[e]),e.fn.trigger&&e(c).trigger("ready").unbind("ready")}},bindReady:function(){if(!B){B=e._Deferred();if(c.readyState==="complete")return setTimeout(e.ready,1);if(c.addEventListener)c.addEventListener("DOMContentLoaded",C,!1),a.addEventListener("load",e.ready,!1);else if(c.attachEvent){c.attachEvent("onreadystatechange",C),a.attachEvent("onload",e.ready);var b=!1;try{b=a.frameElement==null}catch(d){}c.documentElement.doScroll&&b&&K()}}},isFunction:function(a){return e.type(a)==="function"},isArray:Array.isArray||function(a){return e.type(a)==="array"},isWindow:function(a){return a&&typeof a=="object"&&"setInterval"in a},isNaN:function(a){return a==null||!m.test(a)||isNaN(a)},type:function(a){return a==null?String(a):J[D.call(a)]||"object"},isPlainObject:function(a){if(!a||e.type(a)!=="object"||a.nodeType||e.isWindow(a))return!1;try{if(a.constructor&&!E.call(a,"constructor")&&!E.call(a.constructor.prototype,"isPrototypeOf"))return!1}catch(c){return!1}var d;for(d in a);return d===b||E.call(a,d)},isEmptyObject:function(a){for(var b in a)return!1;return!0},error:function(a){throw a},parseJSON:function(b){if(typeof b!="string"||!b)return null;b=e.trim(b);if(a.JSON&&a.JSON.parse)return a.JSON.parse(b);if(o.test(b.replace(p,"@").replace(q,"]").replace(r,"")))return(new Function("return "+b))();e.error("Invalid JSON: "+b)},parseXML:function(c){var d,f;try{a.DOMParser?(f=new DOMParser,d=f.parseFromString(c,"text/xml")):(d=new ActiveXObject("Microsoft.XMLDOM"),d.async="false",d.loadXML(c))}catch(g){d=b}(!d||!d.documentElement||d.getElementsByTagName("parsererror").length)&&e.error("Invalid XML: "+c);return d},noop:function(){},globalEval:function(b){b&&j.test(b)&&(a.execScript||function(b){a.eval.call(a,b)})(b)},camelCase:function(a){return a.replace(x,"ms-").replace(w,y)},nodeName:function(a,b){return a.nodeName&&a.nodeName.toUpperCase()===b.toUpperCase()},each:function(a,c,d){var f,g=0,h=a.length,i=h===b||e.isFunction(a);if(d){if(i){for(f in a)if(c.apply(a[f],d)===!1)break}else for(;g<h;)if(c.apply(a[g++],d)===!1)break}else if(i){for(f in a)if(c.call(a[f],f,a[f])===!1)break}else for(;g<h;)if(c.call(a[g],g,a[g++])===!1)break;return a},trim:H?function(a){return a==null?"":H.call(a)}:function(a){return a==null?"":(a+"").replace(k,"").replace(l,"")},makeArray:function(a,b){var c=b||[];if(a!=null){var d=e.type(a);a.length==null||d==="string"||d==="function"||d==="regexp"||e.isWindow(a)?F.call(c,a):e.merge(c,a)}return c},inArray:function(a,b){if(!b)return-1;if(I)return I.call(b,a);for(var c=0,d=b.length;c<d;c++)if(b[c]===a)return c;return-1},merge:function(a,c){var d=a.length,e=0;if(typeof c.length=="number")for(var f=c.length;e<f;e++)a[d++]=c[e];else while(c[e]!==b)a[d++]=c[e++];a.length=d;return a},grep:function(a,b,c){var d=[],e;c=!!c;for(var f=0,g=a.length;f<g;f++)e=!!b(a[f],f),c!==e&&d.push(a[f]);return d},map:function(a,c,d){var f,g,h=[],i=0,j=a.length,k=a instanceof e||j!==b&&typeof j=="number"&&(j>0&&a[0]&&a[j-1]||j===0||e.isArray(a));if(k)for(;i<j;i++)f=c(a[i],i,d),f!=null&&(h[h.length]=f);else for(g in a)f=c(a[g],g,d),f!=null&&(h[h.length]=f);return h.concat.apply([],h)},guid:1,proxy:function(a,c){if(typeof c=="string"){var d=a[c];c=a,a=d}if(!e.isFunction(a))return b;var f=G.call(arguments,2),g=function(){return a.apply(c,f.concat(G.call(arguments)))};g.guid=a.guid=a.guid||g.guid||e.guid++;return g},access:function(a,c,d,f,g,h){var i=a.length;if(typeof c=="object"){for(var j in c)e.access(a,j,c[j],f,g,d);return a}if(d!==b){f=!h&&f&&e.isFunction(d);for(var k=0;k<i;k++)g(a[k],c,f?d.call(a[k],k,g(a[k],c)):d,h);return a}return i?g(a[0],c):b},now:function(){return(new Date).getTime()},uaMatch:function(a){a=a.toLowerCase();var b=s.exec(a)||t.exec(a)||u.exec(a)||a.indexOf("compatible")<0&&v.exec(a)||[];return{browser:b[1]||"",version:b[2]||"0"}},sub:function(){function a(b,c){return new a.fn.init(b,c)}e.extend(!0,a,this),a.superclass=this,a.fn=a.prototype=this(),a.fn.constructor=a,a.sub=this.sub,a.fn.init=function(d,f){f&&f instanceof e&&!(f instanceof a)&&(f=a(f));return e.fn.init.call(this,d,f,b)},a.fn.init.prototype=a.fn;var b=a(c);return a},browser:{}}),e.each("Boolean Number String Function Array Date RegExp Object".split(" "),function(a,b){J["[object "+b+"]"]=b.toLowerCase()}),A=e.uaMatch(z),A.browser&&(e.browser[A.browser]=!0,e.browser.version=A.version),e.browser.webkit&&(e.browser.safari=!0),j.test(" ")&&(k=/^[\s\xA0]+/,l=/[\s\xA0]+$/),h=e(c),c.addEventListener?C=function(){c.removeEventListener("DOMContentLoaded",C,!1),e.ready()}:c.attachEvent&&(C=function(){c.readyState==="complete"&&(c.detachEvent("onreadystatechange",C),e.ready())});return e}(),g="done fail isResolved isRejected promise then always pipe".split(" "),h=[].slice;f.extend({_Deferred:function(){var a=[],b,c,d,e={done:function(){if(!d){var c=arguments,g,h,i,j,k;b&&(k=b,b=0);for(g=0,h=c.length;g<h;g++)i=c[g],j=f.type(i),j==="array"?e.done.apply(e,i):j==="function"&&a.push(i);k&&e.resolveWith(k[0],k[1])}return this},resolveWith:function(e,f){if(!d&&!b&&!c){f=f||[],c=1;try{while(a[0])a.shift().apply(e,f)}finally{b=[e,f],c=0}}return this},resolve:function(){e.resolveWith(this,arguments);return this},isResolved:function(){return!!c||!!b},cancel:function(){d=1,a=[];return this}};return e},Deferred:function(a){var b=f._Deferred(),c=f._Deferred(),d;f.extend(b,{then:function(a,c){b.done(a).fail(c);return this},always:function(){return b.done.apply(b,arguments).fail.apply(this,arguments)},fail:c.done,rejectWith:c.resolveWith,reject:c.resolve,isRejected:c.isResolved,pipe:function(a,c){return f.Deferred(function(d){f.each({done:[a,"resolve"],fail:[c,"reject"]},function(a,c){var e=c[0],g=c[1],h;f.isFunction(e)?b[a](function(){h=e.apply(this,arguments),h&&f.isFunction(h.promise)?h.promise().then(d.resolve,d.reject):d[g+"With"](this===b?d:this,[h])}):b[a](d[g])})}).promise()},promise:function(a){if(a==null){if(d)return d;d=a={}}var c=g.length;while(c--)a[g[c]]=b[g[c]];return a}}),b.done(c.cancel).fail(b.cancel),delete b.cancel,a&&a.call(b,b);return b},when:function(a){function i(a){return function(c){b[a]=arguments.length>1?h.call(arguments,0):c,--e||g.resolveWith(g,h.call(b,0))}}var b=arguments,c=0,d=b.length,e=d,g=d<=1&&a&&f.isFunction(a.promise)?a:f.Deferred();if(d>1){for(;c<d;c++)b[c]&&f.isFunction(b[c].promise)?b[c].promise().then(i(c),g.reject):--e;e||g.resolveWith(g,b)}else g!==a&&g.resolveWith(g,d?[a]:[]);return g.promise()}}),f.support=function(){var a=c.createElement("div"),b=c.documentElement,d,e,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u;a.setAttribute("className","t"),a.innerHTML="   <link/><table></table><a href='/a' style='top:1px;float:left;opacity:.55;'>a</a><input type='checkbox'/>",d=a.getElementsByTagName("*"),e=a.getElementsByTagName("a")[0];if(!d||!d.length||!e)return{};g=c.createElement("select"),h=g.appendChild(c.createElement("option")),i=a.getElementsByTagName("input")[0],k={leadingWhitespace:a.firstChild.nodeType===3,tbody:!a.getElementsByTagName("tbody").length,htmlSerialize:!!a.getElementsByTagName("link").length,style:/top/.test(e.getAttribute("style")),hrefNormalized:e.getAttribute("href")==="/a",opacity:/^0.55$/.test(e.style.opacity),cssFloat:!!e.style.cssFloat,checkOn:i.value==="on",optSelected:h.selected,getSetAttribute:a.className!=="t",submitBubbles:!0,changeBubbles:!0,focusinBubbles:!1,deleteExpando:!0,noCloneEvent:!0,inlineBlockNeedsLayout:!1,shrinkWrapBlocks:!1,reliableMarginRight:!0},i.checked=!0,k.noCloneChecked=i.cloneNode(!0).checked,g.disabled=!0,k.optDisabled=!h.disabled;try{delete a.test}catch(v){k.deleteExpando=!1}!a.addEventListener&&a.attachEvent&&a.fireEvent&&(a.attachEvent("onclick",function(){k.noCloneEvent=!1}),a.cloneNode(!0).fireEvent("onclick")),i=c.createElement("input"),i.value="t",i.setAttribute("type","radio"),k.radioValue=i.value==="t",i.setAttribute("checked","checked"),a.appendChild(i),l=c.createDocumentFragment(),l.appendChild(a.firstChild),k.checkClone=l.cloneNode(!0).cloneNode(!0).lastChild.checked,a.innerHTML="",a.style.width=a.style.paddingLeft="1px",m=c.getElementsByTagName("body")[0],o=c.createElement(m?"div":"body"),p={visibility:"hidden",width:0,height:0,border:0,margin:0,background:"none"},m&&f.extend(p,{position:"absolute",left:"-1000px",top:"-1000px"});for(t in p)o.style[t]=p[t];o.appendChild(a),n=m||b,n.insertBefore(o,n.firstChild),k.appendChecked=i.checked,k.boxModel=a.offsetWidth===2,"zoom"in a.style&&(a.style.display="inline",a.style.zoom=1,k.inlineBlockNeedsLayout=a.offsetWidth===2,a.style.display="",a.innerHTML="<div style='width:4px;'></div>",k.shrinkWrapBlocks=a.offsetWidth!==2),a.innerHTML="<table><tr><td style='padding:0;border:0;display:none'></td><td>t</td></tr></table>",q=a.getElementsByTagName("td"),u=q[0].offsetHeight===0,q[0].style.display="",q[1].style.display="none",k.reliableHiddenOffsets=u&&q[0].offsetHeight===0,a.innerHTML="",c.defaultView&&c.defaultView.getComputedStyle&&(j=c.createElement("div"),j.style.width="0",j.style.marginRight="0",a.appendChild(j),k.reliableMarginRight=(parseInt((c.defaultView.getComputedStyle(j,null)||{marginRight:0}).marginRight,10)||0)===0),o.innerHTML="",n.removeChild(o);if(a.attachEvent)for(t in{submit:1,change:1,focusin:1})s="on"+t,u=s in a,u||(a.setAttribute(s,"return;"),u=typeof a[s]=="function"),k[t+"Bubbles"]=u;o=l=g=h=m=j=a=i=null;return k}(),f.boxModel=f.support.boxModel;var i=/^(?:\{.*\}|\[.*\])$/,j=/([A-Z])/g;f.extend({cache:{},uuid:0,expando:"jQuery"+(f.fn.jquery+Math.random()).replace(/\D/g,""),noData:{embed:!0,object:"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",applet:!0},hasData:function(a){a=a.nodeType?f.cache[a[f.expando]]:a[f.expando];return!!a&&!l(a)},data:function(a,c,d,e){if(!!f.acceptData(a)){var g,h,i=f.expando,j=typeof c=="string",k=a.nodeType,l=k?f.cache:a,m=k?a[f.expando]:a[f.expando]&&f.expando;if((!m||e&&m&&l[m]&&!l[m][i])&&j&&d===b)return;m||(k?a[f.expando]=m=++f.uuid:m=f.expando),l[m]||(l[m]={},k||(l[m].toJSON=f.noop));if(typeof c=="object"||typeof c=="function")e?l[m][i]=f.extend(l[m][i],c):l[m]=f.extend(l[m],c);g=l[m],e&&(g[i]||(g[i]={}),g=g[i]),d!==b&&(g[f.camelCase(c)]=d);if(c==="events"&&!g[c])return g[i]&&g[i].events;j?(h=g[c],h==null&&(h=g[f.camelCase(c)])):h=g;return h}},removeData:function(a,b,c){if(!!f.acceptData(a)){var d,e=f.expando,g=a.nodeType,h=g?f.cache:a,i=g?a[f.expando]:f.expando;if(!h[i])return;if(b){d=c?h[i][e]:h[i];if(d){d[b]||(b=f.camelCase(b)),delete d[b];if(!l(d))return}}if(c){delete h[i][e];if(!l(h[i]))return}var j=h[i][e];f.support.deleteExpando||!h.setInterval?delete h[i]:h[i]=null,j?(h[i]={},g||(h[i].toJSON=f.noop),h[i][e]=j):g&&(f.support.deleteExpando?delete a[f.expando]:a.removeAttribute?a.removeAttribute(f.expando):a[f.expando]=null)}},_data:function(a,b,c){return f.data(a,b,c,!0)},acceptData:function(a){if(a.nodeName){var b=f.noData[a.nodeName.toLowerCase()];if(b)return b!==!0&&a.getAttribute("classid")===b}return!0}}),f.fn.extend({data:function(a,c){var d=null;if(typeof a=="undefined"){if(this.length){d=f.data(this[0]);if(this[0].nodeType===1){var e=this[0].attributes,g;for(var h=0,i=e.length;h<i;h++)g=e[h].name,g.indexOf("data-")===0&&(g=f.camelCase(g.substring(5)),k(this[0],g,d[g]))}}return d}if(typeof a=="object")return this.each(function(){f.data(this,a)});var j=a.split(".");j[1]=j[1]?"."+j[1]:"";if(c===b){d=this.triggerHandler("getData"+j[1]+"!",[j[0]]),d===b&&this.length&&(d=f.data(this[0],a),d=k(this[0],a,d));return d===b&&j[1]?this.data(j[0]):d}return this.each(function(){var b=f(this),d=[j[0],c];b.triggerHandler("setData"+j[1]+"!",d),f.data(this,a,c),b.triggerHandler("changeData"+j[1]+"!",d)})},removeData:function(a){return this.each(function(){f.removeData(this,a)})}}),f.extend({_mark:function(a,c){a&&(c=(c||"fx")+"mark",f.data(a,c,(f.data(a,c,b,!0)||0)+1,!0))},_unmark:function(a,c,d){a!==!0&&(d=c,c=a,a=!1);if(c){d=d||"fx";var e=d+"mark",g=a?0:(f.data(c,e,b,!0)||1)-1;g?f.data(c,e,g,!0):(f.removeData(c,e,!0),m(c,d,"mark"))}},queue:function(a,c,d){if(a){c=(c||"fx")+"queue";var e=f.data(a,c,b,!0);d&&(!e||f.isArray(d)?e=f.data(a,c,f.makeArray(d),!0):e.push(d));return e||[]}},dequeue:function(a,b){b=b||"fx";var c=f.queue(a,b),d=c.shift(),e;d==="inprogress"&&(d=c.shift()),d&&(b==="fx"&&c.unshift("inprogress"),d.call(a,function(){f.dequeue(a,b)})),c.length||(f.removeData(a,b+"queue",!0),m(a,b,"queue"))}}),f.fn.extend({queue:function(a,c){typeof a!="string"&&(c=a,a="fx");if(c===b)return f.queue(this[0],a);return this.each(function(){var b=f.queue(this,a,c);a==="fx"&&b[0]!=="inprogress"&&f.dequeue(this,a)})},dequeue:function(a){return this.each(function(){f.dequeue(this,a)})},delay:function(a,b){a=f.fx?f.fx.speeds[a]||a:a,b=b||"fx";return this.queue(b,function(){var c=this;setTimeout(function(){f.dequeue(c,b)},a)})},clearQueue:function(a){return this.queue(a||"fx",[])},promise:function(a,c){function m(){--h||d.resolveWith(e,[e])}typeof a!="string"&&(c=a,a=b),a=a||"fx";var d=f.Deferred(),e=this,g=e.length,h=1,i=a+"defer",j=a+"queue",k=a+"mark",l;while(g--)if(l=f.data(e[g],i,b,!0)||(f.data(e[g],j,b,!0)||f.data(e[g],k,b,!0))&&f.data(e[g],i,f._Deferred(),!0))h++,l.done(m);m();return d.promise()}});var n=/[\n\t\r]/g,o=/\s+/,p=/\r/g,q=/^(?:button|input)$/i,r=/^(?:button|input|object|select|textarea)$/i,s=/^a(?:rea)?$/i,t=/^(?:autofocus|autoplay|async|checked|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped|selected)$/i,u,v;f.fn.extend({attr:function(a,b){return f.access(this,a,b,!0,f.attr)},removeAttr:function(a){return this.each(function(){f.removeAttr(this,a)})},prop:function(a,b){return f.access(this,a,b,!0,f.prop)},removeProp:function(a){a=f.propFix[a]||a;return this.each(function(){try{this[a]=b,delete this[a]}catch(c){}})},addClass:function(a){var b,c,d,e,g,h,i;if(f.isFunction(a))return this.each(function(b){f(this).addClass(a.call(this,b,this.className))});if(a&&typeof a=="string"){b=a.split(o);for(c=0,d=this.length;c<d;c++){e=this[c];if(e.nodeType===1)if(!e.className&&b.length===1)e.className=a;else{g=" "+e.className+" ";for(h=0,i=b.length;h<i;h++)~g.indexOf(" "+b[h]+" ")||(g+=b[h]+" ");e.className=f.trim(g)}}}return this},removeClass:function(a){var c,d,e,g,h,i,j;if(f.isFunction(a))return this.each(function(b){f(this).removeClass(a.call(this,b,this.className))});if(a&&typeof a=="string"||a===b){c=(a||"").split(o);for(d=0,e=this.length;d<e;d++){g=this[d];if(g.nodeType===1&&g.className)if(a){h=(" "+g.className+" ").replace(n," ");for(i=0,j=c.length;i<j;i++)h=h.replace(" "+c[i]+" "," ");g.className=f.trim(h)}else g.className=""}}return this},toggleClass:function(a,b){var c=typeof a,d=typeof b=="boolean";if(f.isFunction(a))return this.each(function(c){f(this).toggleClass(a.call(this,c,this.className,b),b)});return this.each(function(){if(c==="string"){var e,g=0,h=f(this),i=b,j=a.split(o);while(e=j[g++])i=d?i:!h.hasClass(e),h[i?"addClass":"removeClass"](e)}else if(c==="undefined"||c==="boolean")this.className&&f._data(this,"__className__",this.className),this.className=this.className||a===!1?"":f._data(this,"__className__")||""})},hasClass:function(a){var b=" "+a+" ";for(var c=0,d=this.length;c<d;c++)if(this[c].nodeType===1&&(" "+this[c].className+" ").replace(n," ").indexOf(b)>-1)return!0;return!1},val:function(a){var c,d,e=this[0];if(!arguments.length){if(e){c=f.valHooks[e.nodeName.toLowerCase()]||f.valHooks[e.type];if(c&&"get"in c&&(d=c.get(e,"value"))!==b)return d;d=e.value;return typeof d=="string"?d.replace(p,""):d==null?"":d}return b}var g=f.isFunction(a);return this.each(function(d){var e=f(this),h;if(this.nodeType===1){g?h=a.call(this,d,e.val()):h=a,h==null?h="":typeof h=="number"?h+="":f.isArray(h)&&(h=f.map(h,function(a){return a==null?"":a+""})),c=f.valHooks[this.nodeName.toLowerCase()]||f.valHooks[this.type];if(!c||!("set"in c)||c.set(this,h,"value")===b)this.value=h}})}}),f.extend({valHooks:{option:{get:function(a){var b=a.attributes.value;return!b||b.specified?a.value:a.text}},select:{get:function(a){var b,c=a.selectedIndex,d=[],e=a.options,g=a.type==="select-one";if(c<0)return null;for(var h=g?c:0,i=g?c+1:e.length;h<i;h++){var j=e[h];if(j.selected&&(f.support.optDisabled?!j.disabled:j.getAttribute("disabled")===null)&&(!j.parentNode.disabled||!f.nodeName(j.parentNode,"optgroup"))){b=f(j).val();if(g)return b;d.push(b)}}if(g&&!d.length&&e.length)return f(e[c]).val();return d},set:function(a,b){var c=f.makeArray(b);f(a).find("option").each(function(){this.selected=f.inArray(f(this).val(),c)>=0}),c.length||(a.selectedIndex=-1);return c}}},attrFn:{val:!0,css:!0,html:!0,text:!0,data:!0,width:!0,height:!0,offset:!0},attrFix:{tabindex:"tabIndex"},attr:function(a,c,d,e){var g=a.nodeType;if(!a||g===3||g===8||g===2)return b;if(e&&c in f.attrFn)return f(a)[c](d);if(!("getAttribute"in a))return f.prop(a,c,d);var h,i,j=g!==1||!f.isXMLDoc(a);j&&(c=f.attrFix[c]||c,i=f.attrHooks[c],i||(t.test(c)?i=v:u&&(i=u)));if(d!==b){if(d===null){f.removeAttr(a,c);return b}if(i&&"set"in i&&j&&(h=i.set(a,d,c))!==b)return h;a.setAttribute(c,""+d);return d}if(i&&"get"in i&&j&&(h=i.get(a,c))!==null)return h;h=a.getAttribute(c);return h===null?b:h},removeAttr:function(a,b){var c;a.nodeType===1&&(b=f.attrFix[b]||b,f.attr(a,b,""),a.removeAttribute(b),t.test(b)&&(c=f.propFix[b]||b)in a&&(a[c]=!1))},attrHooks:{type:{set:function(a,b){if(q.test(a.nodeName)&&a.parentNode)f.error("type property can't be changed");else if(!f.support.radioValue&&b==="radio"&&f.nodeName(a,"input")){var c=a.value;a.setAttribute("type",b),c&&(a.value=c);return b}}},value:{get:function(a,b){if(u&&f.nodeName(a,"button"))return u.get(a,b);return b in a?a.value:null},set:function(a,b,c){if(u&&f.nodeName(a,"button"))return u.set(a,b,c);a.value=b}}},propFix:{tabindex:"tabIndex",readonly:"readOnly","for":"htmlFor","class":"className",maxlength:"maxLength",cellspacing:"cellSpacing",cellpadding:"cellPadding",rowspan:"rowSpan",colspan:"colSpan",usemap:"useMap",frameborder:"frameBorder",contenteditable:"contentEditable"},prop:function(a,c,d){var e=a.nodeType;if(!a||e===3||e===8||e===2)return b;var g,h,i=e!==1||!f.isXMLDoc(a);i&&(c=f.propFix[c]||c,h=f.propHooks[c]);return d!==b?h&&"set"in h&&(g=h.set(a,d,c))!==b?g:a[c]=d:h&&"get"in h&&(g=h.get(a,c))!==null?g:a[c]},propHooks:{tabIndex:{get:function(a){var c=a.getAttributeNode("tabindex");return c&&c.specified?parseInt(c.value,10):r.test(a.nodeName)||s.test(a.nodeName)&&a.href?0:b}}}}),f.attrHooks.tabIndex=f.propHooks.tabIndex,v={get:function(a,c){var d;return f.prop(a,c)===!0||(d=a.getAttributeNode(c))&&d.nodeValue!==!1?c.toLowerCase():b},set:function(a,b,c){var d;b===!1?f.removeAttr(a,c):(d=f.propFix[c]||c,d in a&&(a[d]=!0),a.setAttribute(c,c.toLowerCase()));return c}},f.support.getSetAttribute||(u=f.valHooks.button={get:function(a,c){var d;d=a.getAttributeNode(c);return d&&d.nodeValue!==""?d.nodeValue:b},set:function(a,b,d){var e=a.getAttributeNode(d);e||(e=c.createAttribute(d),a.setAttributeNode(e));return e.nodeValue=b+""}},f.each(["width","height"],function(a,b){f.attrHooks[b]=f.extend(f.attrHooks[b],{set:function(a,c){if(c===""){a.setAttribute(b,"auto");return c}}})})),f.support.hrefNormalized||f.each(["href","src","width","height"],function(a,c){f.attrHooks[c]=f.extend(f.attrHooks[c],{get:function(a){var d=a.getAttribute(c,2);return d===null?b:d}})}),f.support.style||(f.attrHooks.style={get:function(a){return a.style.cssText.toLowerCase()||b},set:function(a,b){return a.style.cssText=""+b}}),f.support.optSelected||(f.propHooks.selected=f.extend(f.propHooks.selected,{get:function(a){var b=a.parentNode;b&&(b.selectedIndex,b.parentNode&&b.parentNode.selectedIndex);return null}})),f.support.checkOn||f.each(["radio","checkbox"],function(){f.valHooks[this]={get:function(a){return a.getAttribute("value")===null?"on":a.value}}}),f.each(["radio","checkbox"],function(){f.valHooks[this]=f.extend(f.valHooks[this],{set:function(a,b){if(f.isArray(b))return a.checked=f.inArray(f(a).val(),b)>=0}})});var w=/\.(.*)$/,x=/^(?:textarea|input|select)$/i,y=/\./g,z=/ /g,A=/[^\w\s.|`]/g,B=function(a){return a.replace(A,"\\$&")};f.event={add:function(a,c,d,e){if(a.nodeType!==3&&a.nodeType!==8){if(d===!1)d=C;else if(!d)return;var g,h;d.handler&&(g=d,d=g.handler),d.guid||(d.guid=f.guid++);var i=f._data(a);if(!i)return;var j=i.events,k=i.handle;j||(i.events=j={}),k||(i.handle=k=function(a){return typeof f!="undefined"&&(!a||f.event.triggered!==a.type)?f.event.handle.apply(k.elem,arguments):b}),k.elem=a,c=c.split(" ");var l,m=0,n;while(l=c[m++]){h=g?f.extend({},g):{handler:d,data:e},l.indexOf(".")>-1?(n=l.split("."),l=n.shift(),h.namespace=n.slice(0).sort().join(".")):(n=[],h.namespace=""),h.type=l,h.guid||(h.guid=d.guid);var o=j[l],p=f.event.special[l]||{};if(!o){o=j[l]=[];if(!p.setup||p.setup.call(a,e,n,k)===!1)a.addEventListener?a.addEventListener(l,k,!1):a.attachEvent&&a.attachEvent("on"+l,k)}p.add&&(p.add.call(a,h),h.handler.guid||(h.handler.guid=d.guid)),o.push(h),f.event.global[l]=!0}a=null}},global:{},remove:function(a,c,d,e){if(a.nodeType!==3&&a.nodeType!==8){d===!1&&(d=C);var g,h,i,j,k=0,l,m,n,o,p,q,r,s=f.hasData(a)&&f._data(a),t=s&&s.events;if(!s||!t)return;c&&c.type&&(d=c.handler,c=c.type);if(!c||typeof c=="string"&&c.charAt(0)==="."){c=c||"";for(h in t)f.event.remove(a,h+c);return}c=c.split(" ");while(h=c[k++]){r=h,q=null,l=h.indexOf(".")<0,m=[],l||(m=h.split("."),h=m.shift(),n=new RegExp("(^|\\.)"+f.map(m.slice(0).sort(),B).join("\\.(?:.*\\.)?")+"(\\.|$)")),p=t[h];if(!p)continue;if(!d){for(j=0;j<p.length;j++){q=p[j];if(l||n.test(q.namespace))f.event.remove(a,r,q.handler,j),p.splice(j--,1)}continue}o=f.event.special[h]||{};for(j=e||0;j<p.length;j++){q=p[j];if(d.guid===q.guid){if(l||n.test(q.namespace))e==null&&p.splice(j--,1),o.remove&&o.remove.call(a,q);if(e!=null)break}}if(p.length===0||e!=null&&p.length===1)(!o.teardown||o.teardown.call(a,m)===!1)&&f.removeEvent(a,h,s.handle),g=null,delete 
t[h]}if(f.isEmptyObject(t)){var u=s.handle;u&&(u.elem=null),delete s.events,delete s.handle,f.isEmptyObject(s)&&f.removeData(a,b,!0)}}},customEvent:{getData:!0,setData:!0,changeData:!0},trigger:function(c,d,e,g){var h=c.type||c,i=[],j;h.indexOf("!")>=0&&(h=h.slice(0,-1),j=!0),h.indexOf(".")>=0&&(i=h.split("."),h=i.shift(),i.sort());if(!!e&&!f.event.customEvent[h]||!!f.event.global[h]){c=typeof c=="object"?c[f.expando]?c:new f.Event(h,c):new f.Event(h),c.type=h,c.exclusive=j,c.namespace=i.join("."),c.namespace_re=new RegExp("(^|\\.)"+i.join("\\.(?:.*\\.)?")+"(\\.|$)");if(g||!e)c.preventDefault(),c.stopPropagation();if(!e){f.each(f.cache,function(){var a=f.expando,b=this[a];b&&b.events&&b.events[h]&&f.event.trigger(c,d,b.handle.elem)});return}if(e.nodeType===3||e.nodeType===8)return;c.result=b,c.target=e,d=d!=null?f.makeArray(d):[],d.unshift(c);var k=e,l=h.indexOf(":")<0?"on"+h:"";do{var m=f._data(k,"handle");c.currentTarget=k,m&&m.apply(k,d),l&&f.acceptData(k)&&k[l]&&k[l].apply(k,d)===!1&&(c.result=!1,c.preventDefault()),k=k.parentNode||k.ownerDocument||k===c.target.ownerDocument&&a}while(k&&!c.isPropagationStopped());if(!c.isDefaultPrevented()){var n,o=f.event.special[h]||{};if((!o._default||o._default.call(e.ownerDocument,c)===!1)&&(h!=="click"||!f.nodeName(e,"a"))&&f.acceptData(e)){try{l&&e[h]&&(n=e[l],n&&(e[l]=null),f.event.triggered=h,e[h]())}catch(p){}n&&(e[l]=n),f.event.triggered=b}}return c.result}},handle:function(c){c=f.event.fix(c||a.event);var d=((f._data(this,"events")||{})[c.type]||[]).slice(0),e=!c.exclusive&&!c.namespace,g=Array.prototype.slice.call(arguments,0);g[0]=c,c.currentTarget=this;for(var h=0,i=d.length;h<i;h++){var j=d[h];if(e||c.namespace_re.test(j.namespace)){c.handler=j.handler,c.data=j.data,c.handleObj=j;var k=j.handler.apply(this,g);k!==b&&(c.result=k,k===!1&&(c.preventDefault(),c.stopPropagation()));if(c.isImmediatePropagationStopped())break}}return c.result},props:"altKey attrChange attrName bubbles button cancelable charCode clientX clientY ctrlKey currentTarget data detail eventPhase fromElement handler keyCode layerX layerY metaKey newValue offsetX offsetY pageX pageY prevValue relatedNode relatedTarget screenX screenY shiftKey srcElement target toElement view wheelDelta which".split(" "),fix:function(a){if(a[f.expando])return a;var d=a;a=f.Event(d);for(var e=this.props.length,g;e;)g=this.props[--e],a[g]=d[g];a.target||(a.target=a.srcElement||c),a.target.nodeType===3&&(a.target=a.target.parentNode),!a.relatedTarget&&a.fromElement&&(a.relatedTarget=a.fromElement===a.target?a.toElement:a.fromElement);if(a.pageX==null&&a.clientX!=null){var h=a.target.ownerDocument||c,i=h.documentElement,j=h.body;a.pageX=a.clientX+(i&&i.scrollLeft||j&&j.scrollLeft||0)-(i&&i.clientLeft||j&&j.clientLeft||0),a.pageY=a.clientY+(i&&i.scrollTop||j&&j.scrollTop||0)-(i&&i.clientTop||j&&j.clientTop||0)}a.which==null&&(a.charCode!=null||a.keyCode!=null)&&(a.which=a.charCode!=null?a.charCode:a.keyCode),!a.metaKey&&a.ctrlKey&&(a.metaKey=a.ctrlKey),!a.which&&a.button!==b&&(a.which=a.button&1?1:a.button&2?3:a.button&4?2:0);return a},guid:1e8,proxy:f.proxy,special:{ready:{setup:f.bindReady,teardown:f.noop},live:{add:function(a){f.event.add(this,M(a.origType,a.selector),f.extend({},a,{handler:L,guid:a.handler.guid}))},remove:function(a){f.event.remove(this,M(a.origType,a.selector),a)}},beforeunload:{setup:function(a,b,c){f.isWindow(this)&&(this.onbeforeunload=c)},teardown:function(a,b){this.onbeforeunload===b&&(this.onbeforeunload=null)}}}},f.removeEvent=c.removeEventListener?function(a,b,c){a.removeEventListener&&a.removeEventListener(b,c,!1)}:function(a,b,c){a.detachEvent&&a.detachEvent("on"+b,c)},f.Event=function(a,b){if(!this.preventDefault)return new f.Event(a,b);a&&a.type?(this.originalEvent=a,this.type=a.type,this.isDefaultPrevented=a.defaultPrevented||a.returnValue===!1||a.getPreventDefault&&a.getPreventDefault()?D:C):this.type=a,b&&f.extend(this,b),this.timeStamp=f.now(),this[f.expando]=!0},f.Event.prototype={preventDefault:function(){this.isDefaultPrevented=D;var a=this.originalEvent;!a||(a.preventDefault?a.preventDefault():a.returnValue=!1)},stopPropagation:function(){this.isPropagationStopped=D;var a=this.originalEvent;!a||(a.stopPropagation&&a.stopPropagation(),a.cancelBubble=!0)},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=D,this.stopPropagation()},isDefaultPrevented:C,isPropagationStopped:C,isImmediatePropagationStopped:C};var E=function(a){var b=a.relatedTarget,c=!1,d=a.type;a.type=a.data,b!==this&&(b&&(c=f.contains(this,b)),c||(f.event.handle.apply(this,arguments),a.type=d))},F=function(a){a.type=a.data,f.event.handle.apply(this,arguments)};f.each({mouseenter:"mouseover",mouseleave:"mouseout"},function(a,b){f.event.special[a]={setup:function(c){f.event.add(this,b,c&&c.selector?F:E,a)},teardown:function(a){f.event.remove(this,b,a&&a.selector?F:E)}}}),f.support.submitBubbles||(f.event.special.submit={setup:function(a,b){if(!f.nodeName(this,"form"))f.event.add(this,"click.specialSubmit",function(a){var b=a.target,c=f.nodeName(b,"input")||f.nodeName(b,"button")?b.type:"";(c==="submit"||c==="image")&&f(b).closest("form").length&&J("submit",this,arguments)}),f.event.add(this,"keypress.specialSubmit",function(a){var b=a.target,c=f.nodeName(b,"input")||f.nodeName(b,"button")?b.type:"";(c==="text"||c==="password")&&f(b).closest("form").length&&a.keyCode===13&&J("submit",this,arguments)});else return!1},teardown:function(a){f.event.remove(this,".specialSubmit")}});if(!f.support.changeBubbles){var G,H=function(a){var b=f.nodeName(a,"input")?a.type:"",c=a.value;b==="radio"||b==="checkbox"?c=a.checked:b==="select-multiple"?c=a.selectedIndex>-1?f.map(a.options,function(a){return a.selected}).join("-"):"":f.nodeName(a,"select")&&(c=a.selectedIndex);return c},I=function(c){var d=c.target,e,g;if(!!x.test(d.nodeName)&&!d.readOnly){e=f._data(d,"_change_data"),g=H(d),(c.type!=="focusout"||d.type!=="radio")&&f._data(d,"_change_data",g);if(e===b||g===e)return;if(e!=null||g)c.type="change",c.liveFired=b,f.event.trigger(c,arguments[1],d)}};f.event.special.change={filters:{focusout:I,beforedeactivate:I,click:function(a){var b=a.target,c=f.nodeName(b,"input")?b.type:"";(c==="radio"||c==="checkbox"||f.nodeName(b,"select"))&&I.call(this,a)},keydown:function(a){var b=a.target,c=f.nodeName(b,"input")?b.type:"";(a.keyCode===13&&!f.nodeName(b,"textarea")||a.keyCode===32&&(c==="checkbox"||c==="radio")||c==="select-multiple")&&I.call(this,a)},beforeactivate:function(a){var b=a.target;f._data(b,"_change_data",H(b))}},setup:function(a,b){if(this.type==="file")return!1;for(var c in G)f.event.add(this,c+".specialChange",G[c]);return x.test(this.nodeName)},teardown:function(a){f.event.remove(this,".specialChange");return x.test(this.nodeName)}},G=f.event.special.change.filters,G.focus=G.beforeactivate}f.support.focusinBubbles||f.each({focus:"focusin",blur:"focusout"},function(a,b){function e(a){var c=f.event.fix(a);c.type=b,c.originalEvent={},f.event.trigger(c,null,c.target),c.isDefaultPrevented()&&a.preventDefault()}var d=0;f.event.special[b]={setup:function(){d++===0&&c.addEventListener(a,e,!0)},teardown:function(){--d===0&&c.removeEventListener(a,e,!0)}}}),f.each(["bind","one"],function(a,c){f.fn[c]=function(a,d,e){var g;if(typeof a=="object"){for(var h in a)this[c](h,d,a[h],e);return this}if(arguments.length===2||d===!1)e=d,d=b;c==="one"?(g=function(a){f(this).unbind(a,g);return e.apply(this,arguments)},g.guid=e.guid||f.guid++):g=e;if(a==="unload"&&c!=="one")this.one(a,d,e);else for(var i=0,j=this.length;i<j;i++)f.event.add(this[i],a,g,d);return this}}),f.fn.extend({unbind:function(a,b){if(typeof a=="object"&&!a.preventDefault)for(var c in a)this.unbind(c,a[c]);else for(var d=0,e=this.length;d<e;d++)f.event.remove(this[d],a,b);return this},delegate:function(a,b,c,d){return this.live(b,c,d,a)},undelegate:function(a,b,c){return arguments.length===0?this.unbind("live"):this.die(b,null,c,a)},trigger:function(a,b){return this.each(function(){f.event.trigger(a,b,this)})},triggerHandler:function(a,b){if(this[0])return f.event.trigger(a,b,this[0],!0)},toggle:function(a){var b=arguments,c=a.guid||f.guid++,d=0,e=function(c){var e=(f.data(this,"lastToggle"+a.guid)||0)%d;f.data(this,"lastToggle"+a.guid,e+1),c.preventDefault();return b[e].apply(this,arguments)||!1};e.guid=c;while(d<b.length)b[d++].guid=c;return this.click(e)},hover:function(a,b){return this.mouseenter(a).mouseleave(b||a)}});var K={focus:"focusin",blur:"focusout",mouseenter:"mouseover",mouseleave:"mouseout"};f.each(["live","die"],function(a,c){f.fn[c]=function(a,d,e,g){var h,i=0,j,k,l,m=g||this.selector,n=g?this:f(this.context);if(typeof a=="object"&&!a.preventDefault){for(var o in a)n[c](o,d,a[o],m);return this}if(c==="die"&&!a&&g&&g.charAt(0)==="."){n.unbind(g);return this}if(d===!1||f.isFunction(d))e=d||C,d=b;a=(a||"").split(" ");while((h=a[i++])!=null){j=w.exec(h),k="",j&&(k=j[0],h=h.replace(w,""));if(h==="hover"){a.push("mouseenter"+k,"mouseleave"+k);continue}l=h,K[h]?(a.push(K[h]+k),h=h+k):h=(K[h]||h)+k;if(c==="live")for(var p=0,q=n.length;p<q;p++)f.event.add(n[p],"live."+M(h,m),{data:d,selector:m,handler:e,origType:h,origHandler:e,preType:l});else n.unbind("live."+M(h,m),e)}return this}}),f.each("blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error".split(" "),function(a,b){f.fn[b]=function(a,c){c==null&&(c=a,a=null);return arguments.length>0?this.bind(b,a,c):this.trigger(b)},f.attrFn&&(f.attrFn[b]=!0)}),function(){function u(a,b,c,d,e,f){for(var g=0,h=d.length;g<h;g++){var i=d[g];if(i){var j=!1;i=i[a];while(i){if(i.sizcache===c){j=d[i.sizset];break}if(i.nodeType===1){f||(i.sizcache=c,i.sizset=g);if(typeof b!="string"){if(i===b){j=!0;break}}else if(k.filter(b,[i]).length>0){j=i;break}}i=i[a]}d[g]=j}}}function t(a,b,c,d,e,f){for(var g=0,h=d.length;g<h;g++){var i=d[g];if(i){var j=!1;i=i[a];while(i){if(i.sizcache===c){j=d[i.sizset];break}i.nodeType===1&&!f&&(i.sizcache=c,i.sizset=g);if(i.nodeName.toLowerCase()===b){j=i;break}i=i[a]}d[g]=j}}}var a=/((?:\((?:\([^()]+\)|[^()]+)+\)|\[(?:\[[^\[\]]*\]|['"][^'"]*['"]|[^\[\]'"]+)+\]|\\.|[^ >+~,(\[\\]+)+|[>+~])(\s*,\s*)?((?:.|\r|\n)*)/g,d=0,e=Object.prototype.toString,g=!1,h=!0,i=/\\/g,j=/\W/;[0,0].sort(function(){h=!1;return 0});var k=function(b,d,f,g){f=f||[],d=d||c;var h=d;if(d.nodeType!==1&&d.nodeType!==9)return[];if(!b||typeof b!="string")return f;var i,j,n,o,q,r,s,t,u=!0,w=k.isXML(d),x=[],y=b;do{a.exec(""),i=a.exec(y);if(i){y=i[3],x.push(i[1]);if(i[2]){o=i[3];break}}}while(i);if(x.length>1&&m.exec(b))if(x.length===2&&l.relative[x[0]])j=v(x[0]+x[1],d);else{j=l.relative[x[0]]?[d]:k(x.shift(),d);while(x.length)b=x.shift(),l.relative[b]&&(b+=x.shift()),j=v(b,j)}else{!g&&x.length>1&&d.nodeType===9&&!w&&l.match.ID.test(x[0])&&!l.match.ID.test(x[x.length-1])&&(q=k.find(x.shift(),d,w),d=q.expr?k.filter(q.expr,q.set)[0]:q.set[0]);if(d){q=g?{expr:x.pop(),set:p(g)}:k.find(x.pop(),x.length===1&&(x[0]==="~"||x[0]==="+")&&d.parentNode?d.parentNode:d,w),j=q.expr?k.filter(q.expr,q.set):q.set,x.length>0?n=p(j):u=!1;while(x.length)r=x.pop(),s=r,l.relative[r]?s=x.pop():r="",s==null&&(s=d),l.relative[r](n,s,w)}else n=x=[]}n||(n=j),n||k.error(r||b);if(e.call(n)==="[object Array]")if(!u)f.push.apply(f,n);else if(d&&d.nodeType===1)for(t=0;n[t]!=null;t++)n[t]&&(n[t]===!0||n[t].nodeType===1&&k.contains(d,n[t]))&&f.push(j[t]);else for(t=0;n[t]!=null;t++)n[t]&&n[t].nodeType===1&&f.push(j[t]);else p(n,f);o&&(k(o,h,f,g),k.uniqueSort(f));return f};k.uniqueSort=function(a){if(r){g=h,a.sort(r);if(g)for(var b=1;b<a.length;b++)a[b]===a[b-1]&&a.splice(b--,1)}return a},k.matches=function(a,b){return k(a,null,null,b)},k.matchesSelector=function(a,b){return k(b,null,null,[a]).length>0},k.find=function(a,b,c){var d;if(!a)return[];for(var e=0,f=l.order.length;e<f;e++){var g,h=l.order[e];if(g=l.leftMatch[h].exec(a)){var j=g[1];g.splice(1,1);if(j.substr(j.length-1)!=="\\"){g[1]=(g[1]||"").replace(i,""),d=l.find[h](g,b,c);if(d!=null){a=a.replace(l.match[h],"");break}}}}d||(d=typeof b.getElementsByTagName!="undefined"?b.getElementsByTagName("*"):[]);return{set:d,expr:a}},k.filter=function(a,c,d,e){var f,g,h=a,i=[],j=c,m=c&&c[0]&&k.isXML(c[0]);while(a&&c.length){for(var n in l.filter)if((f=l.leftMatch[n].exec(a))!=null&&f[2]){var o,p,q=l.filter[n],r=f[1];g=!1,f.splice(1,1);if(r.substr(r.length-1)==="\\")continue;j===i&&(i=[]);if(l.preFilter[n]){f=l.preFilter[n](f,j,d,i,e,m);if(!f)g=o=!0;else if(f===!0)continue}if(f)for(var s=0;(p=j[s])!=null;s++)if(p){o=q(p,f,s,j);var t=e^!!o;d&&o!=null?t?g=!0:j[s]=!1:t&&(i.push(p),g=!0)}if(o!==b){d||(j=i),a=a.replace(l.match[n],"");if(!g)return[];break}}if(a===h)if(g==null)k.error(a);else break;h=a}return j},k.error=function(a){throw"Syntax error, unrecognized expression: "+a};var l=k.selectors={order:["ID","NAME","TAG"],match:{ID:/#((?:[\w\u00c0-\uFFFF\-]|\\.)+)/,CLASS:/\.((?:[\w\u00c0-\uFFFF\-]|\\.)+)/,NAME:/\[name=['"]*((?:[\w\u00c0-\uFFFF\-]|\\.)+)['"]*\]/,ATTR:/\[\s*((?:[\w\u00c0-\uFFFF\-]|\\.)+)\s*(?:(\S?=)\s*(?:(['"])(.*?)\3|(#?(?:[\w\u00c0-\uFFFF\-]|\\.)*)|)|)\s*\]/,TAG:/^((?:[\w\u00c0-\uFFFF\*\-]|\\.)+)/,CHILD:/:(only|nth|last|first)-child(?:\(\s*(even|odd|(?:[+\-]?\d+|(?:[+\-]?\d*)?n\s*(?:[+\-]\s*\d+)?))\s*\))?/,POS:/:(nth|eq|gt|lt|first|last|even|odd)(?:\((\d*)\))?(?=[^\-]|$)/,PSEUDO:/:((?:[\w\u00c0-\uFFFF\-]|\\.)+)(?:\((['"]?)((?:\([^\)]+\)|[^\(\)]*)+)\2\))?/},leftMatch:{},attrMap:{"class":"className","for":"htmlFor"},attrHandle:{href:function(a){return a.getAttribute("href")},type:function(a){return a.getAttribute("type")}},relative:{"+":function(a,b){var c=typeof b=="string",d=c&&!j.test(b),e=c&&!d;d&&(b=b.toLowerCase());for(var f=0,g=a.length,h;f<g;f++)if(h=a[f]){while((h=h.previousSibling)&&h.nodeType!==1);a[f]=e||h&&h.nodeName.toLowerCase()===b?h||!1:h===b}e&&k.filter(b,a,!0)},">":function(a,b){var c,d=typeof b=="string",e=0,f=a.length;if(d&&!j.test(b)){b=b.toLowerCase();for(;e<f;e++){c=a[e];if(c){var g=c.parentNode;a[e]=g.nodeName.toLowerCase()===b?g:!1}}}else{for(;e<f;e++)c=a[e],c&&(a[e]=d?c.parentNode:c.parentNode===b);d&&k.filter(b,a,!0)}},"":function(a,b,c){var e,f=d++,g=u;typeof b=="string"&&!j.test(b)&&(b=b.toLowerCase(),e=b,g=t),g("parentNode",b,f,a,e,c)},"~":function(a,b,c){var e,f=d++,g=u;typeof b=="string"&&!j.test(b)&&(b=b.toLowerCase(),e=b,g=t),g("previousSibling",b,f,a,e,c)}},find:{ID:function(a,b,c){if(typeof b.getElementById!="undefined"&&!c){var d=b.getElementById(a[1]);return d&&d.parentNode?[d]:[]}},NAME:function(a,b){if(typeof b.getElementsByName!="undefined"){var c=[],d=b.getElementsByName(a[1]);for(var e=0,f=d.length;e<f;e++)d[e].getAttribute("name")===a[1]&&c.push(d[e]);return c.length===0?null:c}},TAG:function(a,b){if(typeof b.getElementsByTagName!="undefined")return b.getElementsByTagName(a[1])}},preFilter:{CLASS:function(a,b,c,d,e,f){a=" "+a[1].replace(i,"")+" ";if(f)return a;for(var g=0,h;(h=b[g])!=null;g++)h&&(e^(h.className&&(" "+h.className+" ").replace(/[\t\n\r]/g," ").indexOf(a)>=0)?c||d.push(h):c&&(b[g]=!1));return!1},ID:function(a){return a[1].replace(i,"")},TAG:function(a,b){return a[1].replace(i,"").toLowerCase()},CHILD:function(a){if(a[1]==="nth"){a[2]||k.error(a[0]),a[2]=a[2].replace(/^\+|\s*/g,"");var b=/(-?)(\d*)(?:n([+\-]?\d*))?/.exec(a[2]==="even"&&"2n"||a[2]==="odd"&&"2n+1"||!/\D/.test(a[2])&&"0n+"+a[2]||a[2]);a[2]=b[1]+(b[2]||1)-0,a[3]=b[3]-0}else a[2]&&k.error(a[0]);a[0]=d++;return a},ATTR:function(a,b,c,d,e,f){var g=a[1]=a[1].replace(i,"");!f&&l.attrMap[g]&&(a[1]=l.attrMap[g]),a[4]=(a[4]||a[5]||"").replace(i,""),a[2]==="~="&&(a[4]=" "+a[4]+" ");return a},PSEUDO:function(b,c,d,e,f){if(b[1]==="not")if((a.exec(b[3])||"").length>1||/^\w/.test(b[3]))b[3]=k(b[3],null,null,c);else{var g=k.filter(b[3],c,d,!0^f);d||e.push.apply(e,g);return!1}else if(l.match.POS.test(b[0])||l.match.CHILD.test(b[0]))return!0;return b},POS:function(a){a.unshift(!0);return a}},filters:{enabled:function(a){return a.disabled===!1&&a.type!=="hidden"},disabled:function(a){return a.disabled===!0},checked:function(a){return a.checked===!0},selected:function(a){a.parentNode&&a.parentNode.selectedIndex;return a.selected===!0},parent:function(a){return!!a.firstChild},empty:function(a){return!a.firstChild},has:function(a,b,c){return!!k(c[3],a).length},header:function(a){return/h\d/i.test(a.nodeName)},text:function(a){var b=a.getAttribute("type"),c=a.type;return a.nodeName.toLowerCase()==="input"&&"text"===c&&(b===c||b===null)},radio:function(a){return a.nodeName.toLowerCase()==="input"&&"radio"===a.type},checkbox:function(a){return a.nodeName.toLowerCase()==="input"&&"checkbox"===a.type},file:function(a){return a.nodeName.toLowerCase()==="input"&&"file"===a.type},password:function(a){return a.nodeName.toLowerCase()==="input"&&"password"===a.type},submit:function(a){var b=a.nodeName.toLowerCase();return(b==="input"||b==="button")&&"submit"===a.type},image:function(a){return a.nodeName.toLowerCase()==="input"&&"image"===a.type},reset:function(a){var b=a.nodeName.toLowerCase();return(b==="input"||b==="button")&&"reset"===a.type},button:function(a){var b=a.nodeName.toLowerCase();return b==="input"&&"button"===a.type||b==="button"},input:function(a){return/input|select|textarea|button/i.test(a.nodeName)},focus:function(a){return a===a.ownerDocument.activeElement}},setFilters:{first:function(a,b){return b===0},last:function(a,b,c,d){return b===d.length-1},even:function(a,b){return b%2===0},odd:function(a,b){return b%2===1},lt:function(a,b,c){return b<c[3]-0},gt:function(a,b,c){return b>c[3]-0},nth:function(a,b,c){return c[3]-0===b},eq:function(a,b,c){return c[3]-0===b}},filter:{PSEUDO:function(a,b,c,d){var e=b[1],f=l.filters[e];if(f)return f(a,c,b,d);if(e==="contains")return(a.textContent||a.innerText||k.getText([a])||"").indexOf(b[3])>=0;if(e==="not"){var g=b[3];for(var h=0,i=g.length;h<i;h++)if(g[h]===a)return!1;return!0}k.error(e)},CHILD:function(a,b){var c=b[1],d=a;switch(c){case"only":case"first":while(d=d.previousSibling)if(d.nodeType===1)return!1;if(c==="first")return!0;d=a;case"last":while(d=d.nextSibling)if(d.nodeType===1)return!1;return!0;case"nth":var e=b[2],f=b[3];if(e===1&&f===0)return!0;var g=b[0],h=a.parentNode;if(h&&(h.sizcache!==g||!a.nodeIndex)){var i=0;for(d=h.firstChild;d;d=d.nextSibling)d.nodeType===1&&(d.nodeIndex=++i);h.sizcache=g}var j=a.nodeIndex-f;return e===0?j===0:j%e===0&&j/e>=0}},ID:function(a,b){return a.nodeType===1&&a.getAttribute("id")===b},TAG:function(a,b){return b==="*"&&a.nodeType===1||a.nodeName.toLowerCase()===b},CLASS:function(a,b){return(" "+(a.className||a.getAttribute("class"))+" ").indexOf(b)>-1},ATTR:function(a,b){var c=b[1],d=l.attrHandle[c]?l.attrHandle[c](a):a[c]!=null?a[c]:a.getAttribute(c),e=d+"",f=b[2],g=b[4];return d==null?f==="!=":f==="="?e===g:f==="*="?e.indexOf(g)>=0:f==="~="?(" "+e+" ").indexOf(g)>=0:g?f==="!="?e!==g:f==="^="?e.indexOf(g)===0:f==="$="?e.substr(e.length-g.length)===g:f==="|="?e===g||e.substr(0,g.length+1)===g+"-":!1:e&&d!==!1},POS:function(a,b,c,d){var e=b[2],f=l.setFilters[e];if(f)return f(a,c,b,d)}}},m=l.match.POS,n=function(a,b){return"\\"+(b-0+1)};for(var o in l.match)l.match[o]=new RegExp(l.match[o].source+/(?![^\[]*\])(?![^\(]*\))/.source),l.leftMatch[o]=new RegExp(/(^(?:.|\r|\n)*?)/.source+l.match[o].source.replace(/\\(\d+)/g,n));var p=function(a,b){a=Array.prototype.slice.call(a,0);if(b){b.push.apply(b,a);return b}return a};try{Array.prototype.slice.call(c.documentElement.childNodes,0)[0].nodeType}catch(q){p=function(a,b){var c=0,d=b||[];if(e.call(a)==="[object Array]")Array.prototype.push.apply(d,a);else if(typeof a.length=="number")for(var f=a.length;c<f;c++)d.push(a[c]);else for(;a[c];c++)d.push(a[c]);return d}}var r,s;c.documentElement.compareDocumentPosition?r=function(a,b){if(a===b){g=!0;return 0}if(!a.compareDocumentPosition||!b.compareDocumentPosition)return a.compareDocumentPosition?-1:1;return a.compareDocumentPosition(b)&4?-1:1}:(r=function(a,b){if(a===b){g=!0;return 0}if(a.sourceIndex&&b.sourceIndex)return a.sourceIndex-b.sourceIndex;var c,d,e=[],f=[],h=a.parentNode,i=b.parentNode,j=h;if(h===i)return s(a,b);if(!h)return-1;if(!i)return 1;while(j)e.unshift(j),j=j.parentNode;j=i;while(j)f.unshift(j),j=j.parentNode;c=e.length,d=f.length;for(var k=0;k<c&&k<d;k++)if(e[k]!==f[k])return s(e[k],f[k]);return k===c?s(a,f[k],-1):s(e[k],b,1)},s=function(a,b,c){if(a===b)return c;var d=a.nextSibling;while(d){if(d===b)return-1;d=d.nextSibling}return 1}),k.getText=function(a){var b="",c;for(var d=0;a[d];d++)c=a[d],c.nodeType===3||c.nodeType===4?b+=c.nodeValue:c.nodeType!==8&&(b+=k.getText(c.childNodes));return b},function(){var a=c.createElement("div"),d="script"+(new Date).getTime(),e=c.documentElement;a.innerHTML="<a name='"+d+"'/>",e.insertBefore(a,e.firstChild),c.getElementById(d)&&(l.find.ID=function(a,c,d){if(typeof c.getElementById!="undefined"&&!d){var e=c.getElementById(a[1]);return e?e.id===a[1]||typeof e.getAttributeNode!="undefined"&&e.getAttributeNode("id").nodeValue===a[1]?[e]:b:[]}},l.filter.ID=function(a,b){var c=typeof a.getAttributeNode!="undefined"&&a.getAttributeNode("id");return a.nodeType===1&&c&&c.nodeValue===b}),e.removeChild(a),e=a=null}(),function(){var a=c.createElement("div");a.appendChild(c.createComment("")),a.getElementsByTagName("*").length>0&&(l.find.TAG=function(a,b){var c=b.getElementsByTagName(a[1]);if(a[1]==="*"){var d=[];for(var e=0;c[e];e++)c[e].nodeType===1&&d.push(c[e]);c=d}return c}),a.innerHTML="<a href='#'></a>",a.firstChild&&typeof a.firstChild.getAttribute!="undefined"&&a.firstChild.getAttribute("href")!=="#"&&(l.attrHandle.href=function(a){return a.getAttribute("href",2)}),a=null}(),c.querySelectorAll&&function(){var a=k,b=c.createElement("div"),d="__sizzle__";b.innerHTML="<p class='TEST'></p>";if(!b.querySelectorAll||b.querySelectorAll(".TEST").length!==0){k=function(b,e,f,g){e=e||c;if(!g&&!k.isXML(e)){var h=/^(\w+$)|^\.([\w\-]+$)|^#([\w\-]+$)/.exec(b);if(h&&(e.nodeType===1||e.nodeType===9)){if(h[1])return p(e.getElementsByTagName(b),f);if(h[2]&&l.find.CLASS&&e.getElementsByClassName)return p(e.getElementsByClassName(h[2]),f)}if(e.nodeType===9){if(b==="body"&&e.body)return p([e.body],f);if(h&&h[3]){var i=e.getElementById(h[3]);if(!i||!i.parentNode)return p([],f);if(i.id===h[3])return p([i],f)}try{return p(e.querySelectorAll(b),f)}catch(j){}}else if(e.nodeType===1&&e.nodeName.toLowerCase()!=="object"){var m=e,n=e.getAttribute("id"),o=n||d,q=e.parentNode,r=/^\s*[+~]/.test(b);n?o=o.replace(/'/g,"\\$&"):e.setAttribute("id",o),r&&q&&(e=e.parentNode);try{if(!r||q)return p(e.querySelectorAll("[id='"+o+"'] "+b),f)}catch(s){}finally{n||m.removeAttribute("id")}}}return a(b,e,f,g)};for(var e in a)k[e]=a[e];b=null}}(),function(){var a=c.documentElement,b=a.matchesSelector||a.mozMatchesSelector||a.webkitMatchesSelector||a.msMatchesSelector;if(b){var d=!b.call(c.createElement("div"),"div"),e=!1;try{b.call(c.documentElement,"[test!='']:sizzle")}catch(f){e=!0}k.matchesSelector=function(a,c){c=c.replace(/\=\s*([^'"\]]*)\s*\]/g,"='$1']");if(!k.isXML(a))try{if(e||!l.match.PSEUDO.test(c)&&!/!=/.test(c)){var f=b.call(a,c);if(f||!d||a.document&&a.document.nodeType!==11)return f}}catch(g){}return k(c,null,null,[a]).length>0}}}(),function(){var a=c.createElement("div");a.innerHTML="<div class='test e'></div><div class='test'></div>";if(!!a.getElementsByClassName&&a.getElementsByClassName("e").length!==0){a.lastChild.className="e";if(a.getElementsByClassName("e").length===1)return;l.order.splice(1,0,"CLASS"),l.find.CLASS=function(a,b,c){if(typeof b.getElementsByClassName!="undefined"&&!c)return b.getElementsByClassName(a[1])},a=null}}(),c.documentElement.contains?k.contains=function(a,b){return a!==b&&(a.contains?a.contains(b):!0)}:c.documentElement.compareDocumentPosition?k.contains=function(a,b){return!!(a.compareDocumentPosition(b)&16)}:k.contains=function(){return!1},k.isXML=function(a){var b=(a?a.ownerDocument||a:0).documentElement;return b?b.nodeName!=="HTML":!1};var v=function(a,b){var c,d=[],e="",f=b.nodeType?[b]:b;while(c=l.match.PSEUDO.exec(a))e+=c[0],a=a.replace(l.match.PSEUDO,"");a=l.relative[a]?a+"*":a;for(var g=0,h=f.length;g<h;g++)k(a,f[g],d);return k.filter(e,d)};f.find=k,f.expr=k.selectors,f.expr[":"]=f.expr.filters,f.unique=k.uniqueSort,f.text=k.getText,f.isXMLDoc=k.isXML,f.contains=k.contains}();var N=/Until$/,O=/^(?:parents|prevUntil|prevAll)/,P=/,/,Q=/^.[^:#\[\.,]*$/,R=Array.prototype.slice,S=f.expr.match.POS,T={children:!0,contents:!0,next:!0,prev:!0};f.fn.extend({find:function(a){var b=this,c,d;if(typeof a!="string")return f(a).filter(function(){for(c=0,d=b.length;c<d;c++)if(f.contains(b[c],this))return!0});var e=this.pushStack("","find",a),g,h,i;for(c=0,d=this.length;c<d;c++){g=e.length,f.find(a,this[c],e);if(c>0)for(h=g;h<e.length;h++)for(i=0;i<g;i++)if(e[i]===e[h]){e.splice(h--,1);break}}return e},has:function(a){var b=f(a);return this.filter(function(){for(var a=0,c=b.length;a<c;a++)if(f.contains(this,b[a]))return!0})},not:function(a){return this.pushStack(V(this,a,!1),"not",a)},filter:function(a){return this.pushStack(V(this,a,!0),"filter",a)},is:function(a){return!!a&&(typeof a=="string"?f.filter(a,this).length>0:this.filter(a).length>0)},closest:function(a,b){var c=[],d,e,g=this[0];if(f.isArray(a)){var h,i,j={},k=1;if(g&&a.length){for(d=0,e=a.length;d<e;d++)i=a[d],j[i]||(j[i]=S.test(i)?f(i,b||this.context):i);while(g&&g.ownerDocument&&g!==b){for(i in j)h=j[i],(h.jquery?h.index(g)>-1:f(g).is(h))&&c.push({selector:i,elem:g,level:k});g=g.parentNode,k++}}return c}var l=S.test(a)||typeof a!="string"?f(a,b||this.context):0;for(d=0,e=this.length;d<e;d++){g=this[d];while(g){if(l?l.index(g)>-1:f.find.matchesSelector(g,a)){c.push(g);break}g=g.parentNode;if(!g||!g.ownerDocument||g===b||g.nodeType===11)break}}c=c.length>1?f.unique(c):c;return this.pushStack(c,"closest",a)},index:function(a){if(!a)return this[0]&&this[0].parentNode?this.prevAll().length:-1;if(typeof a=="string")return f.inArray(this[0],f(a));return f.inArray(a.jquery?a[0]:a,this)},add:function(a,b){var c=typeof a=="string"?f(a,b):f.makeArray(a&&a.nodeType?[a]:a),d=f.merge(this.get(),c);return this.pushStack(U(c[0])||U(d[0])?d:f.unique(d))},andSelf:function(){return this.add(this.prevObject)}}),f.each({parent:function(a){var b=a.parentNode;return b&&b.nodeType!==11?b:null},parents:function(a){return f.dir(a,"parentNode")},parentsUntil:function(a,b,c){return f.dir(a,"parentNode",c)},next:function(a){return f.nth(a,2,"nextSibling")},prev:function(a){return f.nth(a,2,"previousSibling")},nextAll:function(a){return f.dir(a,"nextSibling")},prevAll:function(a){return f.dir(a,"previousSibling")},nextUntil:function(a,b,c){return f.dir(a,"nextSibling",c)},prevUntil:function(a,b,c){return f.dir(a,"previousSibling",c)},siblings:function(a){return f.sibling(a.parentNode.firstChild,a)},children:function(a){return f.sibling(a.firstChild)},contents:function(a){return f.nodeName(a,"iframe")?a.contentDocument||a.contentWindow.document:f.makeArray(a.childNodes)}},function(a,b){f.fn[a]=function(c,d){var e=f.map(this,b,c),g=R.call(arguments);N.test(a)||(d=c),d&&typeof d=="string"&&(e=f.filter(d,e)),e=this.length>1&&!T[a]?f.unique(e):e,(this.length>1||P.test(d))&&O.test(a)&&(e=e.reverse());return this.pushStack(e,a,g.join(","))}}),f.extend({filter:function(a,b,c){c&&(a=":not("+a+")");return b.length===1?f.find.matchesSelector(b[0],a)?[b[0]]:[]:f.find.matches(a,b)},dir:function(a,c,d){var e=[],g=a[c];while(g&&g.nodeType!==9&&(d===b||g.nodeType!==1||!f(g).is(d)))g.nodeType===1&&e.push(g),g=g[c];return e},nth:function(a,b,c,d){b=b||1;var e=0;for(;a;a=a[c])if(a.nodeType===1&&++e===b)break;return a},sibling:function(a,b){var c=[];for(;a;a=a.nextSibling)a.nodeType===1&&a!==b&&c.push(a);return c}});var W=/ jQuery\d+="(?:\d+|null)"/g,X=/^\s+/,Y=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/ig,Z=/<([\w:]+)/,$=/<tbody/i,_=/<|&#?\w+;/,ba=/<(?:script|object|embed|option|style)/i,bb=/checked\s*(?:[^=]|=\s*.checked.)/i,bc=/\/(java|ecma)script/i,bd=/^\s*<!(?:\[CDATA\[|\-\-)/,be={option:[1,"<select multiple='multiple'>","</select>"],legend:[1,"<fieldset>","</fieldset>"],thead:[1,"<table>","</table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],col:[2,"<table><tbody></tbody><colgroup>","</colgroup></table>"],area:[1,"<map>","</map>"],_default:[0,"",""]};be.optgroup=be.option,be.tbody=be.tfoot=be.colgroup=be.caption=be.thead,be.th=be.td,f.support.htmlSerialize||(be._default=[1,"div<div>","</div>"]),f.fn.extend({text:function(a){if(f.isFunction(a))return this.each(function(b){var c=f(this);c.text(a.call(this,b,c.text()))});if(typeof a!="object"&&a!==b)return this.empty().append((this[0]&&this[0].ownerDocument||c).createTextNode(a));return f.text(this)},wrapAll:function(a){if(f.isFunction(a))return this.each(function(b){f(this).wrapAll(a.call(this,b))});if(this[0]){var b=f(a,this[0].ownerDocument).eq(0).clone(!0);this[0].parentNode&&b.insertBefore(this[0]),b.map(function(){var a=this;while(a.firstChild&&a.firstChild.nodeType===1)a=a.firstChild;return a}).append(this)}return this},wrapInner:function(a){if(f.isFunction(a))return this.each(function(b){f(this).wrapInner(a.call(this,b))});return this.each(function(){var b=f(this),c=b.contents();c.length?c.wrapAll(a):b.append(a)})},wrap:function(a){return this.each(function(){f(this).wrapAll(a)})},unwrap:function(){return this.parent().each(function(){f.nodeName(this,"body")||f(this).replaceWith(this.childNodes)}).end()},append:function(){return this.domManip(arguments,!0,function(a){this.nodeType===1&&this.appendChild(a)})},prepend:function(){return this.domManip(arguments,!0,function(a){this.nodeType===1&&this.insertBefore(a,this.firstChild)})},before:function(){if(this[0]&&this[0].parentNode)return this.domManip(arguments,!1,function(a){this.parentNode.insertBefore(a,this)});if(arguments.length){var a=f(arguments[0]);a.push.apply(a,this.toArray());return this.pushStack(a,"before",arguments)}},after:function(){if(this[0]&&this[0].parentNode)return this.domManip(arguments,!1,function(a){this.parentNode.insertBefore(a,this.nextSibling)});if(arguments.length){var a=this.pushStack(this,"after",arguments);a.push.apply(a,f(arguments[0]).toArray());return a}},remove:function(a,b){for(var c=0,d;(d=this[c])!=null;c++)if(!a||f.filter(a,[d]).length)!b&&d.nodeType===1&&(f.cleanData(d.getElementsByTagName("*")),f.cleanData([d])),d.parentNode&&d.parentNode.removeChild(d);return this},empty:function(){for(var a=0,b;(b=this[a])!=null;a++){b.nodeType===1&&f.cleanData(b.getElementsByTagName("*"));while(b.firstChild)b.removeChild(b.firstChild)}return this},clone:function(a,b){a=a==null?!1:a,b=b==null?a:b;return this.map(function(){return f.clone(this,a,b)})},html:function(a){if(a===b)return this[0]&&this[0].nodeType===1?this[0].innerHTML.replace(W,""):null;if(typeof a=="string"&&!ba.test(a)&&(f.support.leadingWhitespace||!X.test(a))&&!be[(Z.exec(a)||["",""])[1].toLowerCase()]){a=a.replace(Y,"<$1></$2>");try{for(var c=0,d=this.length;c<d;c++)this[c].nodeType===1&&(f.cleanData(this[c].getElementsByTagName("*")),this[c].innerHTML=a)}catch(e){this.empty().append(a)}}else f.isFunction(a)?this.each(function(b){var c=f(this);c.html(a.call(this,b,c.html()))}):this.empty().append(a);return this},replaceWith:function(a){if(this[0]&&this[0].parentNode){if(f.isFunction(a))return this.each(function(b){var c=f(this),d=c.html();c.replaceWith(a.call(this,b,d))});typeof a!="string"&&(a=f(a).detach());return this.each(function(){var b=this.nextSibling,c=this.parentNode;f(this).remove(),b?f(b).before(a):f(c).append(a)})}return this.length?this.pushStack(f(f.isFunction(a)?a():a),"replaceWith",a):this},detach:function(a){return this.remove(a,!0)},domManip:function(a,c,d){var e,g,h,i,j=a[0],k=[];if(!f.support.checkClone&&arguments.length===3&&typeof j=="string"&&bb.test(j))return this.each(function(){f(this).domManip(a,c,d,!0)});if(f.isFunction(j))return this.each(function(e){var g=f(this);a[0]=j.call(this,e,c?g.html():b),g.domManip(a,c,d)});if(this[0]){i=j&&j.parentNode,f.support.parentNode&&i&&i.nodeType===11&&i.childNodes.length===this.length?e={fragment:i}:e=f.buildFragment(a,this,k),h=e.fragment,h.childNodes.length===1?g=h=h.firstChild:g=h.firstChild;if(g){c=c&&f.nodeName(g,"tr");for(var l=0,m=this.length,n=m-1;l<m;l++)d.call(c?bf(this[l],g):this[l],e.cacheable||m>1&&l<n?f.clone(h,!0,!0):h)}k.length&&f.each(k,bl)}return this}}),f.buildFragment=function(a,b,d){var e,g,h,i;b&&b[0]&&(i=b[0].ownerDocument||b[0]),i.createDocumentFragment||(i=c),a.length===1&&typeof a[0]=="string"&&a[0].length<512&&i===c&&a[0].charAt(0)==="<"&&!ba.test(a[0])&&(f.support.checkClone||!bb.test(a[0]))&&(g=!0,h=f.fragments[a[0]],h&&h!==1&&(e=h)),e||(e=i.createDocumentFragment(),f.clean
(a,i,e,d)),g&&(f.fragments[a[0]]=h?e:1);return{fragment:e,cacheable:g}},f.fragments={},f.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(a,b){f.fn[a]=function(c){var d=[],e=f(c),g=this.length===1&&this[0].parentNode;if(g&&g.nodeType===11&&g.childNodes.length===1&&e.length===1){e[b](this[0]);return this}for(var h=0,i=e.length;h<i;h++){var j=(h>0?this.clone(!0):this).get();f(e[h])[b](j),d=d.concat(j)}return this.pushStack(d,a,e.selector)}}),f.extend({clone:function(a,b,c){var d=a.cloneNode(!0),e,g,h;if((!f.support.noCloneEvent||!f.support.noCloneChecked)&&(a.nodeType===1||a.nodeType===11)&&!f.isXMLDoc(a)){bh(a,d),e=bi(a),g=bi(d);for(h=0;e[h];++h)g[h]&&bh(e[h],g[h])}if(b){bg(a,d);if(c){e=bi(a),g=bi(d);for(h=0;e[h];++h)bg(e[h],g[h])}}e=g=null;return d},clean:function(a,b,d,e){var g;b=b||c,typeof b.createElement=="undefined"&&(b=b.ownerDocument||b[0]&&b[0].ownerDocument||c);var h=[],i;for(var j=0,k;(k=a[j])!=null;j++){typeof k=="number"&&(k+="");if(!k)continue;if(typeof k=="string")if(!_.test(k))k=b.createTextNode(k);else{k=k.replace(Y,"<$1></$2>");var l=(Z.exec(k)||["",""])[1].toLowerCase(),m=be[l]||be._default,n=m[0],o=b.createElement("div");o.innerHTML=m[1]+k+m[2];while(n--)o=o.lastChild;if(!f.support.tbody){var p=$.test(k),q=l==="table"&&!p?o.firstChild&&o.firstChild.childNodes:m[1]==="<table>"&&!p?o.childNodes:[];for(i=q.length-1;i>=0;--i)f.nodeName(q[i],"tbody")&&!q[i].childNodes.length&&q[i].parentNode.removeChild(q[i])}!f.support.leadingWhitespace&&X.test(k)&&o.insertBefore(b.createTextNode(X.exec(k)[0]),o.firstChild),k=o.childNodes}var r;if(!f.support.appendChecked)if(k[0]&&typeof (r=k.length)=="number")for(i=0;i<r;i++)bk(k[i]);else bk(k);k.nodeType?h.push(k):h=f.merge(h,k)}if(d){g=function(a){return!a.type||bc.test(a.type)};for(j=0;h[j];j++)if(e&&f.nodeName(h[j],"script")&&(!h[j].type||h[j].type.toLowerCase()==="text/javascript"))e.push(h[j].parentNode?h[j].parentNode.removeChild(h[j]):h[j]);else{if(h[j].nodeType===1){var s=f.grep(h[j].getElementsByTagName("script"),g);h.splice.apply(h,[j+1,0].concat(s))}d.appendChild(h[j])}}return h},cleanData:function(a){var b,c,d=f.cache,e=f.expando,g=f.event.special,h=f.support.deleteExpando;for(var i=0,j;(j=a[i])!=null;i++){if(j.nodeName&&f.noData[j.nodeName.toLowerCase()])continue;c=j[f.expando];if(c){b=d[c]&&d[c][e];if(b&&b.events){for(var k in b.events)g[k]?f.event.remove(j,k):f.removeEvent(j,k,b.handle);b.handle&&(b.handle.elem=null)}h?delete j[f.expando]:j.removeAttribute&&j.removeAttribute(f.expando),delete d[c]}}}});var bm=/alpha\([^)]*\)/i,bn=/opacity=([^)]*)/,bo=/([A-Z]|^ms)/g,bp=/^-?\d+(?:px)?$/i,bq=/^-?\d/,br=/^([\-+])=([\-+.\de]+)/,bs={position:"absolute",visibility:"hidden",display:"block"},bt=["Left","Right"],bu=["Top","Bottom"],bv,bw,bx;f.fn.css=function(a,c){if(arguments.length===2&&c===b)return this;return f.access(this,a,c,!0,function(a,c,d){return d!==b?f.style(a,c,d):f.css(a,c)})},f.extend({cssHooks:{opacity:{get:function(a,b){if(b){var c=bv(a,"opacity","opacity");return c===""?"1":c}return a.style.opacity}}},cssNumber:{fillOpacity:!0,fontWeight:!0,lineHeight:!0,opacity:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{"float":f.support.cssFloat?"cssFloat":"styleFloat"},style:function(a,c,d,e){if(!!a&&a.nodeType!==3&&a.nodeType!==8&&!!a.style){var g,h,i=f.camelCase(c),j=a.style,k=f.cssHooks[i];c=f.cssProps[i]||i;if(d===b){if(k&&"get"in k&&(g=k.get(a,!1,e))!==b)return g;return j[c]}h=typeof d,h==="string"&&(g=br.exec(d))&&(d=+(g[1]+1)*+g[2]+parseFloat(f.css(a,c)),h="number");if(d==null||h==="number"&&isNaN(d))return;h==="number"&&!f.cssNumber[i]&&(d+="px");if(!k||!("set"in k)||(d=k.set(a,d))!==b)try{j[c]=d}catch(l){}}},css:function(a,c,d){var e,g;c=f.camelCase(c),g=f.cssHooks[c],c=f.cssProps[c]||c,c==="cssFloat"&&(c="float");if(g&&"get"in g&&(e=g.get(a,!0,d))!==b)return e;if(bv)return bv(a,c)},swap:function(a,b,c){var d={};for(var e in b)d[e]=a.style[e],a.style[e]=b[e];c.call(a);for(e in b)a.style[e]=d[e]}}),f.curCSS=f.css,f.each(["height","width"],function(a,b){f.cssHooks[b]={get:function(a,c,d){var e;if(c){if(a.offsetWidth!==0)return by(a,b,d);f.swap(a,bs,function(){e=by(a,b,d)});return e}},set:function(a,b){if(!bp.test(b))return b;b=parseFloat(b);if(b>=0)return b+"px"}}}),f.support.opacity||(f.cssHooks.opacity={get:function(a,b){return bn.test((b&&a.currentStyle?a.currentStyle.filter:a.style.filter)||"")?parseFloat(RegExp.$1)/100+"":b?"1":""},set:function(a,b){var c=a.style,d=a.currentStyle,e=f.isNaN(b)?"":"alpha(opacity="+b*100+")",g=d&&d.filter||c.filter||"";c.zoom=1;if(b>=1&&f.trim(g.replace(bm,""))===""){c.removeAttribute("filter");if(d&&!d.filter)return}c.filter=bm.test(g)?g.replace(bm,e):g+" "+e}}),f(function(){f.support.reliableMarginRight||(f.cssHooks.marginRight={get:function(a,b){var c;f.swap(a,{display:"inline-block"},function(){b?c=bv(a,"margin-right","marginRight"):c=a.style.marginRight});return c}})}),c.defaultView&&c.defaultView.getComputedStyle&&(bw=function(a,c){var d,e,g;c=c.replace(bo,"-$1").toLowerCase();if(!(e=a.ownerDocument.defaultView))return b;if(g=e.getComputedStyle(a,null))d=g.getPropertyValue(c),d===""&&!f.contains(a.ownerDocument.documentElement,a)&&(d=f.style(a,c));return d}),c.documentElement.currentStyle&&(bx=function(a,b){var c,d=a.currentStyle&&a.currentStyle[b],e=a.runtimeStyle&&a.runtimeStyle[b],f=a.style;!bp.test(d)&&bq.test(d)&&(c=f.left,e&&(a.runtimeStyle.left=a.currentStyle.left),f.left=b==="fontSize"?"1em":d||0,d=f.pixelLeft+"px",f.left=c,e&&(a.runtimeStyle.left=e));return d===""?"auto":d}),bv=bw||bx,f.expr&&f.expr.filters&&(f.expr.filters.hidden=function(a){var b=a.offsetWidth,c=a.offsetHeight;return b===0&&c===0||!f.support.reliableHiddenOffsets&&(a.style.display||f.css(a,"display"))==="none"},f.expr.filters.visible=function(a){return!f.expr.filters.hidden(a)});var bz=/%20/g,bA=/\[\]$/,bB=/\r?\n/g,bC=/#.*$/,bD=/^(.*?):[ \t]*([^\r\n]*)\r?$/mg,bE=/^(?:color|date|datetime|datetime-local|email|hidden|month|number|password|range|search|tel|text|time|url|week)$/i,bF=/^(?:about|app|app\-storage|.+\-extension|file|res|widget):$/,bG=/^(?:GET|HEAD)$/,bH=/^\/\//,bI=/\?/,bJ=/<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi,bK=/^(?:select|textarea)/i,bL=/\s+/,bM=/([?&])_=[^&]*/,bN=/^([\w\+\.\-]+:)(?:\/\/([^\/?#:]*)(?::(\d+))?)?/,bO=f.fn.load,bP={},bQ={},bR,bS,bT=["*/"]+["*"];try{bR=e.href}catch(bU){bR=c.createElement("a"),bR.href="",bR=bR.href}bS=bN.exec(bR.toLowerCase())||[],f.fn.extend({load:function(a,c,d){if(typeof a!="string"&&bO)return bO.apply(this,arguments);if(!this.length)return this;var e=a.indexOf(" ");if(e>=0){var g=a.slice(e,a.length);a=a.slice(0,e)}var h="GET";c&&(f.isFunction(c)?(d=c,c=b):typeof c=="object"&&(c=f.param(c,f.ajaxSettings.traditional),h="POST"));var i=this;f.ajax({url:a,type:h,dataType:"html",data:c,complete:function(a,b,c){c=a.responseText,a.isResolved()&&(a.done(function(a){c=a}),i.html(g?f("<div>").append(c.replace(bJ,"")).find(g):c)),d&&i.each(d,[c,b,a])}});return this},serialize:function(){return f.param(this.serializeArray())},serializeArray:function(){return this.map(function(){return this.elements?f.makeArray(this.elements):this}).filter(function(){return this.name&&!this.disabled&&(this.checked||bK.test(this.nodeName)||bE.test(this.type))}).map(function(a,b){var c=f(this).val();return c==null?null:f.isArray(c)?f.map(c,function(a,c){return{name:b.name,value:a.replace(bB,"\r\n")}}):{name:b.name,value:c.replace(bB,"\r\n")}}).get()}}),f.each("ajaxStart ajaxStop ajaxComplete ajaxError ajaxSuccess ajaxSend".split(" "),function(a,b){f.fn[b]=function(a){return this.bind(b,a)}}),f.each(["get","post"],function(a,c){f[c]=function(a,d,e,g){f.isFunction(d)&&(g=g||e,e=d,d=b);return f.ajax({type:c,url:a,data:d,success:e,dataType:g})}}),f.extend({getScript:function(a,c){return f.get(a,b,c,"script")},getJSON:function(a,b,c){return f.get(a,b,c,"json")},ajaxSetup:function(a,b){b?bX(a,f.ajaxSettings):(b=a,a=f.ajaxSettings),bX(a,b);return a},ajaxSettings:{url:bR,isLocal:bF.test(bS[1]),global:!0,type:"GET",contentType:"application/x-www-form-urlencoded",processData:!0,async:!0,accepts:{xml:"application/xml, text/xml",html:"text/html",text:"text/plain",json:"application/json, text/javascript","*":bT},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:"responseXML",text:"responseText"},converters:{"* text":a.String,"text html":!0,"text json":f.parseJSON,"text xml":f.parseXML},flatOptions:{context:!0,url:!0}},ajaxPrefilter:bV(bP),ajaxTransport:bV(bQ),ajax:function(a,c){function w(a,c,l,m){if(s!==2){s=2,q&&clearTimeout(q),p=b,n=m||"",v.readyState=a>0?4:0;var o,r,u,w=c,x=l?bZ(d,v,l):b,y,z;if(a>=200&&a<300||a===304){if(d.ifModified){if(y=v.getResponseHeader("Last-Modified"))f.lastModified[k]=y;if(z=v.getResponseHeader("Etag"))f.etag[k]=z}if(a===304)w="notmodified",o=!0;else try{r=b$(d,x),w="success",o=!0}catch(A){w="parsererror",u=A}}else{u=w;if(!w||a)w="error",a<0&&(a=0)}v.status=a,v.statusText=""+(c||w),o?h.resolveWith(e,[r,w,v]):h.rejectWith(e,[v,w,u]),v.statusCode(j),j=b,t&&g.trigger("ajax"+(o?"Success":"Error"),[v,d,o?r:u]),i.resolveWith(e,[v,w]),t&&(g.trigger("ajaxComplete",[v,d]),--f.active||f.event.trigger("ajaxStop"))}}typeof a=="object"&&(c=a,a=b),c=c||{};var d=f.ajaxSetup({},c),e=d.context||d,g=e!==d&&(e.nodeType||e instanceof f)?f(e):f.event,h=f.Deferred(),i=f._Deferred(),j=d.statusCode||{},k,l={},m={},n,o,p,q,r,s=0,t,u,v={readyState:0,setRequestHeader:function(a,b){if(!s){var c=a.toLowerCase();a=m[c]=m[c]||a,l[a]=b}return this},getAllResponseHeaders:function(){return s===2?n:null},getResponseHeader:function(a){var c;if(s===2){if(!o){o={};while(c=bD.exec(n))o[c[1].toLowerCase()]=c[2]}c=o[a.toLowerCase()]}return c===b?null:c},overrideMimeType:function(a){s||(d.mimeType=a);return this},abort:function(a){a=a||"abort",p&&p.abort(a),w(0,a);return this}};h.promise(v),v.success=v.done,v.error=v.fail,v.complete=i.done,v.statusCode=function(a){if(a){var b;if(s<2)for(b in a)j[b]=[j[b],a[b]];else b=a[v.status],v.then(b,b)}return this},d.url=((a||d.url)+"").replace(bC,"").replace(bH,bS[1]+"//"),d.dataTypes=f.trim(d.dataType||"*").toLowerCase().split(bL),d.crossDomain==null&&(r=bN.exec(d.url.toLowerCase()),d.crossDomain=!(!r||r[1]==bS[1]&&r[2]==bS[2]&&(r[3]||(r[1]==="http:"?80:443))==(bS[3]||(bS[1]==="http:"?80:443)))),d.data&&d.processData&&typeof d.data!="string"&&(d.data=f.param(d.data,d.traditional)),bW(bP,d,c,v);if(s===2)return!1;t=d.global,d.type=d.type.toUpperCase(),d.hasContent=!bG.test(d.type),t&&f.active++===0&&f.event.trigger("ajaxStart");if(!d.hasContent){d.data&&(d.url+=(bI.test(d.url)?"&":"?")+d.data,delete d.data),k=d.url;if(d.cache===!1){var x=f.now(),y=d.url.replace(bM,"$1_="+x);d.url=y+(y===d.url?(bI.test(d.url)?"&":"?")+"_="+x:"")}}(d.data&&d.hasContent&&d.contentType!==!1||c.contentType)&&v.setRequestHeader("Content-Type",d.contentType),d.ifModified&&(k=k||d.url,f.lastModified[k]&&v.setRequestHeader("If-Modified-Since",f.lastModified[k]),f.etag[k]&&v.setRequestHeader("If-None-Match",f.etag[k])),v.setRequestHeader("Accept",d.dataTypes[0]&&d.accepts[d.dataTypes[0]]?d.accepts[d.dataTypes[0]]+(d.dataTypes[0]!=="*"?", "+bT+"; q=0.01":""):d.accepts["*"]);for(u in d.headers)v.setRequestHeader(u,d.headers[u]);if(d.beforeSend&&(d.beforeSend.call(e,v,d)===!1||s===2)){v.abort();return!1}for(u in{success:1,error:1,complete:1})v[u](d[u]);p=bW(bQ,d,c,v);if(!p)w(-1,"No Transport");else{v.readyState=1,t&&g.trigger("ajaxSend",[v,d]),d.async&&d.timeout>0&&(q=setTimeout(function(){v.abort("timeout")},d.timeout));try{s=1,p.send(l,w)}catch(z){s<2?w(-1,z):f.error(z)}}return v},param:function(a,c){var d=[],e=function(a,b){b=f.isFunction(b)?b():b,d[d.length]=encodeURIComponent(a)+"="+encodeURIComponent(b)};c===b&&(c=f.ajaxSettings.traditional);if(f.isArray(a)||a.jquery&&!f.isPlainObject(a))f.each(a,function(){e(this.name,this.value)});else for(var g in a)bY(g,a[g],c,e);return d.join("&").replace(bz,"+")}}),f.extend({active:0,lastModified:{},etag:{}});var b_=f.now(),ca=/(\=)\?(&|$)|\?\?/i;f.ajaxSetup({jsonp:"callback",jsonpCallback:function(){return f.expando+"_"+b_++}}),f.ajaxPrefilter("json jsonp",function(b,c,d){var e=b.contentType==="application/x-www-form-urlencoded"&&typeof b.data=="string";if(b.dataTypes[0]==="jsonp"||b.jsonp!==!1&&(ca.test(b.url)||e&&ca.test(b.data))){var g,h=b.jsonpCallback=f.isFunction(b.jsonpCallback)?b.jsonpCallback():b.jsonpCallback,i=a[h],j=b.url,k=b.data,l="$1"+h+"$2";b.jsonp!==!1&&(j=j.replace(ca,l),b.url===j&&(e&&(k=k.replace(ca,l)),b.data===k&&(j+=(/\?/.test(j)?"&":"?")+b.jsonp+"="+h))),b.url=j,b.data=k,a[h]=function(a){g=[a]},d.always(function(){a[h]=i,g&&f.isFunction(i)&&a[h](g[0])}),b.converters["script json"]=function(){g||f.error(h+" was not called");return g[0]},b.dataTypes[0]="json";return"script"}}),f.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/javascript|ecmascript/},converters:{"text script":function(a){f.globalEval(a);return a}}}),f.ajaxPrefilter("script",function(a){a.cache===b&&(a.cache=!1),a.crossDomain&&(a.type="GET",a.global=!1)}),f.ajaxTransport("script",function(a){if(a.crossDomain){var d,e=c.head||c.getElementsByTagName("head")[0]||c.documentElement;return{send:function(f,g){d=c.createElement("script"),d.async="async",a.scriptCharset&&(d.charset=a.scriptCharset),d.src=a.url,d.onload=d.onreadystatechange=function(a,c){if(c||!d.readyState||/loaded|complete/.test(d.readyState))d.onload=d.onreadystatechange=null,e&&d.parentNode&&e.removeChild(d),d=b,c||g(200,"success")},e.insertBefore(d,e.firstChild)},abort:function(){d&&d.onload(0,1)}}}});var cb=a.ActiveXObject?function(){for(var a in cd)cd[a](0,1)}:!1,cc=0,cd;f.ajaxSettings.xhr=a.ActiveXObject?function(){return!this.isLocal&&ce()||cf()}:ce,function(a){f.extend(f.support,{ajax:!!a,cors:!!a&&"withCredentials"in a})}(f.ajaxSettings.xhr()),f.support.ajax&&f.ajaxTransport(function(c){if(!c.crossDomain||f.support.cors){var d;return{send:function(e,g){var h=c.xhr(),i,j;c.username?h.open(c.type,c.url,c.async,c.username,c.password):h.open(c.type,c.url,c.async);if(c.xhrFields)for(j in c.xhrFields)h[j]=c.xhrFields[j];c.mimeType&&h.overrideMimeType&&h.overrideMimeType(c.mimeType),!c.crossDomain&&!e["X-Requested-With"]&&(e["X-Requested-With"]="XMLHttpRequest");try{for(j in e)h.setRequestHeader(j,e[j])}catch(k){}h.send(c.hasContent&&c.data||null),d=function(a,e){var j,k,l,m,n;try{if(d&&(e||h.readyState===4)){d=b,i&&(h.onreadystatechange=f.noop,cb&&delete cd[i]);if(e)h.readyState!==4&&h.abort();else{j=h.status,l=h.getAllResponseHeaders(),m={},n=h.responseXML,n&&n.documentElement&&(m.xml=n),m.text=h.responseText;try{k=h.statusText}catch(o){k=""}!j&&c.isLocal&&!c.crossDomain?j=m.text?200:404:j===1223&&(j=204)}}}catch(p){e||g(-1,p)}m&&g(j,k,m,l)},!c.async||h.readyState===4?d():(i=++cc,cb&&(cd||(cd={},f(a).unload(cb)),cd[i]=d),h.onreadystatechange=d)},abort:function(){d&&d(0,1)}}}});var cg={},ch,ci,cj=/^(?:toggle|show|hide)$/,ck=/^([+\-]=)?([\d+.\-]+)([a-z%]*)$/i,cl,cm=[["height","marginTop","marginBottom","paddingTop","paddingBottom"],["width","marginLeft","marginRight","paddingLeft","paddingRight"],["opacity"]],cn;f.fn.extend({show:function(a,b,c){var d,e;if(a||a===0)return this.animate(cq("show",3),a,b,c);for(var g=0,h=this.length;g<h;g++)d=this[g],d.style&&(e=d.style.display,!f._data(d,"olddisplay")&&e==="none"&&(e=d.style.display=""),e===""&&f.css(d,"display")==="none"&&f._data(d,"olddisplay",cr(d.nodeName)));for(g=0;g<h;g++){d=this[g];if(d.style){e=d.style.display;if(e===""||e==="none")d.style.display=f._data(d,"olddisplay")||""}}return this},hide:function(a,b,c){if(a||a===0)return this.animate(cq("hide",3),a,b,c);for(var d=0,e=this.length;d<e;d++)if(this[d].style){var g=f.css(this[d],"display");g!=="none"&&!f._data(this[d],"olddisplay")&&f._data(this[d],"olddisplay",g)}for(d=0;d<e;d++)this[d].style&&(this[d].style.display="none");return this},_toggle:f.fn.toggle,toggle:function(a,b,c){var d=typeof a=="boolean";f.isFunction(a)&&f.isFunction(b)?this._toggle.apply(this,arguments):a==null||d?this.each(function(){var b=d?a:f(this).is(":hidden");f(this)[b?"show":"hide"]()}):this.animate(cq("toggle",3),a,b,c);return this},fadeTo:function(a,b,c,d){return this.filter(":hidden").css("opacity",0).show().end().animate({opacity:b},a,c,d)},animate:function(a,b,c,d){var e=f.speed(b,c,d);if(f.isEmptyObject(a))return this.each(e.complete,[!1]);a=f.extend({},a);return this[e.queue===!1?"each":"queue"](function(){e.queue===!1&&f._mark(this);var b=f.extend({},e),c=this.nodeType===1,d=c&&f(this).is(":hidden"),g,h,i,j,k,l,m,n,o;b.animatedProperties={};for(i in a){g=f.camelCase(i),i!==g&&(a[g]=a[i],delete a[i]),h=a[g],f.isArray(h)?(b.animatedProperties[g]=h[1],h=a[g]=h[0]):b.animatedProperties[g]=b.specialEasing&&b.specialEasing[g]||b.easing||"swing";if(h==="hide"&&d||h==="show"&&!d)return b.complete.call(this);c&&(g==="height"||g==="width")&&(b.overflow=[this.style.overflow,this.style.overflowX,this.style.overflowY],f.css(this,"display")==="inline"&&f.css(this,"float")==="none"&&(f.support.inlineBlockNeedsLayout?(j=cr(this.nodeName),j==="inline"?this.style.display="inline-block":(this.style.display="inline",this.style.zoom=1)):this.style.display="inline-block"))}b.overflow!=null&&(this.style.overflow="hidden");for(i in a)k=new f.fx(this,b,i),h=a[i],cj.test(h)?k[h==="toggle"?d?"show":"hide":h]():(l=ck.exec(h),m=k.cur(),l?(n=parseFloat(l[2]),o=l[3]||(f.cssNumber[i]?"":"px"),o!=="px"&&(f.style(this,i,(n||1)+o),m=(n||1)/k.cur()*m,f.style(this,i,m+o)),l[1]&&(n=(l[1]==="-="?-1:1)*n+m),k.custom(m,n,o)):k.custom(m,h,""));return!0})},stop:function(a,b){a&&this.queue([]),this.each(function(){var a=f.timers,c=a.length;b||f._unmark(!0,this);while(c--)a[c].elem===this&&(b&&a[c](!0),a.splice(c,1))}),b||this.dequeue();return this}}),f.each({slideDown:cq("show",1),slideUp:cq("hide",1),slideToggle:cq("toggle",1),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(a,b){f.fn[a]=function(a,c,d){return this.animate(b,a,c,d)}}),f.extend({speed:function(a,b,c){var d=a&&typeof a=="object"?f.extend({},a):{complete:c||!c&&b||f.isFunction(a)&&a,duration:a,easing:c&&b||b&&!f.isFunction(b)&&b};d.duration=f.fx.off?0:typeof d.duration=="number"?d.duration:d.duration in f.fx.speeds?f.fx.speeds[d.duration]:f.fx.speeds._default,d.old=d.complete,d.complete=function(a){f.isFunction(d.old)&&d.old.call(this),d.queue!==!1?f.dequeue(this):a!==!1&&f._unmark(this)};return d},easing:{linear:function(a,b,c,d){return c+d*a},swing:function(a,b,c,d){return(-Math.cos(a*Math.PI)/2+.5)*d+c}},timers:[],fx:function(a,b,c){this.options=b,this.elem=a,this.prop=c,b.orig=b.orig||{}}}),f.fx.prototype={update:function(){this.options.step&&this.options.step.call(this.elem,this.now,this),(f.fx.step[this.prop]||f.fx.step._default)(this)},cur:function(){if(this.elem[this.prop]!=null&&(!this.elem.style||this.elem.style[this.prop]==null))return this.elem[this.prop];var a,b=f.css(this.elem,this.prop);return isNaN(a=parseFloat(b))?!b||b==="auto"?0:b:a},custom:function(a,b,c){function g(a){return d.step(a)}var d=this,e=f.fx;this.startTime=cn||co(),this.start=a,this.end=b,this.unit=c||this.unit||(f.cssNumber[this.prop]?"":"px"),this.now=this.start,this.pos=this.state=0,g.elem=this.elem,g()&&f.timers.push(g)&&!cl&&(cl=setInterval(e.tick,e.interval))},show:function(){this.options.orig[this.prop]=f.style(this.elem,this.prop),this.options.show=!0,this.custom(this.prop==="width"||this.prop==="height"?1:0,this.cur()),f(this.elem).show()},hide:function(){this.options.orig[this.prop]=f.style(this.elem,this.prop),this.options.hide=!0,this.custom(this.cur(),0)},step:function(a){var b=cn||co(),c=!0,d=this.elem,e=this.options,g,h;if(a||b>=e.duration+this.startTime){this.now=this.end,this.pos=this.state=1,this.update(),e.animatedProperties[this.prop]=!0;for(g in e.animatedProperties)e.animatedProperties[g]!==!0&&(c=!1);if(c){e.overflow!=null&&!f.support.shrinkWrapBlocks&&f.each(["","X","Y"],function(a,b){d.style["overflow"+b]=e.overflow[a]}),e.hide&&f(d).hide();if(e.hide||e.show)for(var i in e.animatedProperties)f.style(d,i,e.orig[i]);e.complete.call(d)}return!1}e.duration==Infinity?this.now=b:(h=b-this.startTime,this.state=h/e.duration,this.pos=f.easing[e.animatedProperties[this.prop]](this.state,h,0,1,e.duration),this.now=this.start+(this.end-this.start)*this.pos),this.update();return!0}},f.extend(f.fx,{tick:function(){for(var a=f.timers,b=0;b<a.length;++b)a[b]()||a.splice(b--,1);a.length||f.fx.stop()},interval:13,stop:function(){clearInterval(cl),cl=null},speeds:{slow:600,fast:200,_default:400},step:{opacity:function(a){f.style(a.elem,"opacity",a.now)},_default:function(a){a.elem.style&&a.elem.style[a.prop]!=null?a.elem.style[a.prop]=(a.prop==="width"||a.prop==="height"?Math.max(0,a.now):a.now)+a.unit:a.elem[a.prop]=a.now}}}),f.expr&&f.expr.filters&&(f.expr.filters.animated=function(a){return f.grep(f.timers,function(b){return a===b.elem}).length});var cs=/^t(?:able|d|h)$/i,ct=/^(?:body|html)$/i;"getBoundingClientRect"in c.documentElement?f.fn.offset=function(a){var b=this[0],c;if(a)return this.each(function(b){f.offset.setOffset(this,a,b)});if(!b||!b.ownerDocument)return null;if(b===b.ownerDocument.body)return f.offset.bodyOffset(b);try{c=b.getBoundingClientRect()}catch(d){}var e=b.ownerDocument,g=e.documentElement;if(!c||!f.contains(g,b))return c?{top:c.top,left:c.left}:{top:0,left:0};var h=e.body,i=cu(e),j=g.clientTop||h.clientTop||0,k=g.clientLeft||h.clientLeft||0,l=i.pageYOffset||f.support.boxModel&&g.scrollTop||h.scrollTop,m=i.pageXOffset||f.support.boxModel&&g.scrollLeft||h.scrollLeft,n=c.top+l-j,o=c.left+m-k;return{top:n,left:o}}:f.fn.offset=function(a){var b=this[0];if(a)return this.each(function(b){f.offset.setOffset(this,a,b)});if(!b||!b.ownerDocument)return null;if(b===b.ownerDocument.body)return f.offset.bodyOffset(b);f.offset.initialize();var c,d=b.offsetParent,e=b,g=b.ownerDocument,h=g.documentElement,i=g.body,j=g.defaultView,k=j?j.getComputedStyle(b,null):b.currentStyle,l=b.offsetTop,m=b.offsetLeft;while((b=b.parentNode)&&b!==i&&b!==h){if(f.offset.supportsFixedPosition&&k.position==="fixed")break;c=j?j.getComputedStyle(b,null):b.currentStyle,l-=b.scrollTop,m-=b.scrollLeft,b===d&&(l+=b.offsetTop,m+=b.offsetLeft,f.offset.doesNotAddBorder&&(!f.offset.doesAddBorderForTableAndCells||!cs.test(b.nodeName))&&(l+=parseFloat(c.borderTopWidth)||0,m+=parseFloat(c.borderLeftWidth)||0),e=d,d=b.offsetParent),f.offset.subtractsBorderForOverflowNotVisible&&c.overflow!=="visible"&&(l+=parseFloat(c.borderTopWidth)||0,m+=parseFloat(c.borderLeftWidth)||0),k=c}if(k.position==="relative"||k.position==="static")l+=i.offsetTop,m+=i.offsetLeft;f.offset.supportsFixedPosition&&k.position==="fixed"&&(l+=Math.max(h.scrollTop,i.scrollTop),m+=Math.max(h.scrollLeft,i.scrollLeft));return{top:l,left:m}},f.offset={initialize:function(){var a=c.body,b=c.createElement("div"),d,e,g,h,i=parseFloat(f.css(a,"marginTop"))||0,j="<div style='position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;'><div></div></div><table style='position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;' cellpadding='0' cellspacing='0'><tr><td></td></tr></table>";f.extend(b.style,{position:"absolute",top:0,left:0,margin:0,border:0,width:"1px",height:"1px",visibility:"hidden"}),b.innerHTML=j,a.insertBefore(b,a.firstChild),d=b.firstChild,e=d.firstChild,h=d.nextSibling.firstChild.firstChild,this.doesNotAddBorder=e.offsetTop!==5,this.doesAddBorderForTableAndCells=h.offsetTop===5,e.style.position="fixed",e.style.top="20px",this.supportsFixedPosition=e.offsetTop===20||e.offsetTop===15,e.style.position=e.style.top="",d.style.overflow="hidden",d.style.position="relative",this.subtractsBorderForOverflowNotVisible=e.offsetTop===-5,this.doesNotIncludeMarginInBodyOffset=a.offsetTop!==i,a.removeChild(b),f.offset.initialize=f.noop},bodyOffset:function(a){var b=a.offsetTop,c=a.offsetLeft;f.offset.initialize(),f.offset.doesNotIncludeMarginInBodyOffset&&(b+=parseFloat(f.css(a,"marginTop"))||0,c+=parseFloat(f.css(a,"marginLeft"))||0);return{top:b,left:c}},setOffset:function(a,b,c){var d=f.css(a,"position");d==="static"&&(a.style.position="relative");var e=f(a),g=e.offset(),h=f.css(a,"top"),i=f.css(a,"left"),j=(d==="absolute"||d==="fixed")&&f.inArray("auto",[h,i])>-1,k={},l={},m,n;j?(l=e.position(),m=l.top,n=l.left):(m=parseFloat(h)||0,n=parseFloat(i)||0),f.isFunction(b)&&(b=b.call(a,c,g)),b.top!=null&&(k.top=b.top-g.top+m),b.left!=null&&(k.left=b.left-g.left+n),"using"in b?b.using.call(a,k):e.css(k)}},f.fn.extend({position:function(){if(!this[0])return null;var a=this[0],b=this.offsetParent(),c=this.offset(),d=ct.test(b[0].nodeName)?{top:0,left:0}:b.offset();c.top-=parseFloat(f.css(a,"marginTop"))||0,c.left-=parseFloat(f.css(a,"marginLeft"))||0,d.top+=parseFloat(f.css(b[0],"borderTopWidth"))||0,d.left+=parseFloat(f.css(b[0],"borderLeftWidth"))||0;return{top:c.top-d.top,left:c.left-d.left}},offsetParent:function(){return this.map(function(){var a=this.offsetParent||c.body;while(a&&!ct.test(a.nodeName)&&f.css(a,"position")==="static")a=a.offsetParent;return a})}}),f.each(["Left","Top"],function(a,c){var d="scroll"+c;f.fn[d]=function(c){var e,g;if(c===b){e=this[0];if(!e)return null;g=cu(e);return g?"pageXOffset"in g?g[a?"pageYOffset":"pageXOffset"]:f.support.boxModel&&g.document.documentElement[d]||g.document.body[d]:e[d]}return this.each(function(){g=cu(this),g?g.scrollTo(a?f(g).scrollLeft():c,a?c:f(g).scrollTop()):this[d]=c})}}),f.each(["Height","Width"],function(a,c){var d=c.toLowerCase();f.fn["inner"+c]=function(){var a=this[0];return a&&a.style?parseFloat(f.css(a,d,"padding")):null},f.fn["outer"+c]=function(a){var b=this[0];return b&&b.style?parseFloat(f.css(b,d,a?"margin":"border")):null},f.fn[d]=function(a){var e=this[0];if(!e)return a==null?null:this;if(f.isFunction(a))return this.each(function(b){var c=f(this);c[d](a.call(this,b,c[d]()))});if(f.isWindow(e)){var g=e.document.documentElement["client"+c],h=e.document.body;return e.document.compatMode==="CSS1Compat"&&g||h&&h["client"+c]||g}if(e.nodeType===9)return Math.max(e.documentElement["client"+c],e.body["scroll"+c],e.documentElement["scroll"+c],e.body["offset"+c],e.documentElement["offset"+c]);if(a===b){var i=f.css(e,d),j=parseFloat(i);return f.isNaN(j)?i:j}return this.css(d,typeof a=="string"?a:a+"px")}}),a.jQuery=a.$=f})(window);/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.1r1097
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 *
 * included jsDate library by Chris Leonello:
 *
 * Copyright (c) 2010-2011 Chris Leonello
 *
 * jsDate is currently available for use in all personal or commercial projects 
 * under both the MIT and GPL version 2.0 licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly.
 *
 * jsDate borrows many concepts and ideas from the Date Instance 
 * Methods by Ken Snyder along with some parts of Ken's actual code.
 * 
 * Ken's origianl Date Instance Methods and copyright notice:
 * 
 * Ken Snyder (ken d snyder at gmail dot com)
 * 2008-09-10
 * version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 * Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * jqplotToImage function based on Larry Siden's export-jqplot-to-png.js.
 * Larry has generously given permission to adapt his code for inclusion
 * into jqPlot.
 *
 * Larry's original code can be found here:
 *
 * https://github.com/lsiden/export-jqplot-to-png
 * 
 * 
 */
(function(H){var r;H.fn.emptyForce=function(){for(var ab=0,ac;(ac=H(this)[ab])!=null;ab++){if(ac.nodeType===1){H.cleanData(ac.getElementsByTagName("*"))}if(H.jqplot.use_excanvas){ac.outerHTML=""}else{while(ac.firstChild){ac.removeChild(ac.firstChild)}}ac=null}return H(this)};H.fn.removeChildForce=function(ab){while(ab.firstChild){this.removeChildForce(ab.firstChild);ab.removeChild(ab.firstChild)}};H.fn.jqplot=function(){var ab=[];var ad=[];for(var ae=0,ac=arguments.length;ae<ac;ae++){if(H.isArray(arguments[ae])){ab.push(arguments[ae])}else{if(H.isPlainObject(arguments[ae])){ad.push(arguments[ae])}}}return this.each(function(ah){var am,al,ak=H(this),ag=ab.length,af=ad.length,aj,ai;if(ah<ag){aj=ab[ah]}else{aj=ag?ab[ag-1]:null}if(ah<af){ai=ad[ah]}else{ai=af?ad[af-1]:null}am=ak.attr("id");if(am===r){am="jqplot_target_"+H.jqplot.targetCounter++;ak.attr("id",am)}al=H.jqplot(am,aj,ai);ak.data("jqplot",al)})};H.jqplot=function(ah,ae,ac){var ad=null,ab=null;if(arguments.length===3){ad=ae;ab=ac}else{if(arguments.length===2){if(H.isArray(ae)){ad=ae}else{if(H.isPlainObject(ae)){ab=ae}}}}if(ad===null&&ab!==null&&ab.data){ad=ab.data}var ag=new N();H("#"+ah).removeClass("jqplot-error");if(H.jqplot.config.catchErrors){try{ag.init(ah,ad,ab);ag.draw();ag.themeEngine.init.call(ag);return ag}catch(af){var ai=H.jqplot.config.errorMessage||af.message;H("#"+ah).append('<div class="jqplot-error-message">'+ai+"</div>");H("#"+ah).addClass("jqplot-error");document.getElementById(ah).style.background=H.jqplot.config.errorBackground;document.getElementById(ah).style.border=H.jqplot.config.errorBorder;document.getElementById(ah).style.fontFamily=H.jqplot.config.errorFontFamily;document.getElementById(ah).style.fontSize=H.jqplot.config.errorFontSize;document.getElementById(ah).style.fontStyle=H.jqplot.config.errorFontStyle;document.getElementById(ah).style.fontWeight=H.jqplot.config.errorFontWeight}}else{ag.init(ah,ad,ab);ag.draw();ag.themeEngine.init.call(ag);return ag}};H.jqplot.version="1.0.1";H.jqplot.revision="1097";H.jqplot.targetCounter=1;H.jqplot.CanvasManager=function(){if(typeof H.jqplot.CanvasManager.canvases=="undefined"){H.jqplot.CanvasManager.canvases=[];H.jqplot.CanvasManager.free=[]}var ab=[];this.getCanvas=function(){var ae;var ad=true;if(!H.jqplot.use_excanvas){for(var af=0,ac=H.jqplot.CanvasManager.canvases.length;af<ac;af++){if(H.jqplot.CanvasManager.free[af]===true){ad=false;ae=H.jqplot.CanvasManager.canvases[af];H.jqplot.CanvasManager.free[af]=false;ab.push(af);break}}}if(ad){ae=document.createElement("canvas");ab.push(H.jqplot.CanvasManager.canvases.length);H.jqplot.CanvasManager.canvases.push(ae);H.jqplot.CanvasManager.free.push(false)}return ae};this.initCanvas=function(ac){if(H.jqplot.use_excanvas){return window.G_vmlCanvasManager.initElement(ac)}return ac};this.freeAllCanvases=function(){for(var ad=0,ac=ab.length;ad<ac;ad++){this.freeCanvas(ab[ad])}ab=[]};this.freeCanvas=function(ac){if(H.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==r){window.G_vmlCanvasManager.uninitElement(H.jqplot.CanvasManager.canvases[ac]);H.jqplot.CanvasManager.canvases[ac]=null}else{var ad=H.jqplot.CanvasManager.canvases[ac];ad.getContext("2d").clearRect(0,0,ad.width,ad.height);H(ad).unbind().removeAttr("class").removeAttr("style");H(ad).css({left:"",top:"",position:""});ad.width=0;ad.height=0;H.jqplot.CanvasManager.free[ac]=true}}};H.jqplot.log=function(){if(window.console){window.console.log.apply(window.console,arguments)}};H.jqplot.config={addDomReference:false,enablePlugins:false,defaultHeight:300,defaultWidth:400,UTCAdjust:false,timezoneOffset:new Date(new Date().getTimezoneOffset()*60000),errorMessage:"",errorBackground:"",errorBorder:"",errorFontFamily:"",errorFontSize:"",errorFontStyle:"",errorFontWeight:"",catchErrors:false,defaultTickFormatString:"%.1f",defaultColors:["#4bb2c5","#EAA228","#c5b47f","#579575","#839557","#958c12","#953579","#4b5de4","#d8b83f","#ff5800","#0085cc","#c747a3","#cddf54","#FBD178","#26B4E3","#bd70c7"],defaultNegativeColors:["#498991","#C08840","#9F9274","#546D61","#646C4A","#6F6621","#6E3F5F","#4F64B0","#A89050","#C45923","#187399","#945381","#959E5C","#C7AF7B","#478396","#907294"],dashLength:4,gapLength:4,dotGapLength:2.5,srcLocation:"jqplot/src/",pluginLocation:"jqplot/src/plugins/"};H.jqplot.arrayMax=function(ab){return Math.max.apply(Math,ab)};H.jqplot.arrayMin=function(ab){return Math.min.apply(Math,ab)};H.jqplot.enablePlugins=H.jqplot.config.enablePlugins;H.jqplot.support_canvas=function(){if(typeof H.jqplot.support_canvas.result=="undefined"){H.jqplot.support_canvas.result=!!document.createElement("canvas").getContext}return H.jqplot.support_canvas.result};H.jqplot.support_canvas_text=function(){if(typeof H.jqplot.support_canvas_text.result=="undefined"){if(window.G_vmlCanvasManager!==r&&window.G_vmlCanvasManager._version>887){H.jqplot.support_canvas_text.result=true}else{H.jqplot.support_canvas_text.result=!!(document.createElement("canvas").getContext&&typeof document.createElement("canvas").getContext("2d").fillText=="function")}}return H.jqplot.support_canvas_text.result};H.jqplot.use_excanvas=(H.browser.msie&&!H.jqplot.support_canvas())?true:false;H.jqplot.preInitHooks=[];H.jqplot.postInitHooks=[];H.jqplot.preParseOptionsHooks=[];H.jqplot.postParseOptionsHooks=[];H.jqplot.preDrawHooks=[];H.jqplot.postDrawHooks=[];H.jqplot.preDrawSeriesHooks=[];H.jqplot.postDrawSeriesHooks=[];H.jqplot.preDrawLegendHooks=[];H.jqplot.addLegendRowHooks=[];H.jqplot.preSeriesInitHooks=[];H.jqplot.postSeriesInitHooks=[];H.jqplot.preParseSeriesOptionsHooks=[];H.jqplot.postParseSeriesOptionsHooks=[];H.jqplot.eventListenerHooks=[];H.jqplot.preDrawSeriesShadowHooks=[];H.jqplot.postDrawSeriesShadowHooks=[];H.jqplot.ElemContainer=function(){this._elem;this._plotWidth;this._plotHeight;this._plotDimensions={height:null,width:null}};H.jqplot.ElemContainer.prototype.createElement=function(ae,ag,ac,ad,ah){this._offsets=ag;var ab=ac||"jqplot";var af=document.createElement(ae);this._elem=H(af);this._elem.addClass(ab);this._elem.css(ad);this._elem.attr(ah);af=null;return this._elem};H.jqplot.ElemContainer.prototype.getWidth=function(){if(this._elem){return this._elem.outerWidth(true)}else{return null}};H.jqplot.ElemContainer.prototype.getHeight=function(){if(this._elem){return this._elem.outerHeight(true)}else{return null}};H.jqplot.ElemContainer.prototype.getPosition=function(){if(this._elem){return this._elem.position()}else{return{top:null,left:null,bottom:null,right:null}}};H.jqplot.ElemContainer.prototype.getTop=function(){return this.getPosition().top};H.jqplot.ElemContainer.prototype.getLeft=function(){return this.getPosition().left};H.jqplot.ElemContainer.prototype.getBottom=function(){return this._elem.css("bottom")};H.jqplot.ElemContainer.prototype.getRight=function(){return this._elem.css("right")};function s(ab){H.jqplot.ElemContainer.call(this);this.name=ab;this._series=[];this.show=false;this.tickRenderer=H.jqplot.AxisTickRenderer;this.tickOptions={};this.labelRenderer=H.jqplot.AxisLabelRenderer;this.labelOptions={};this.label=null;this.showLabel=true;this.min=null;this.max=null;this.autoscale=false;this.pad=1.2;this.padMax=null;this.padMin=null;this.ticks=[];this.numberTicks;this.tickInterval;this.renderer=H.jqplot.LinearAxisRenderer;this.rendererOptions={};this.showTicks=true;this.showTickMarks=true;this.showMinorTicks=true;this.drawMajorGridlines=true;this.drawMinorGridlines=false;this.drawMajorTickMarks=true;this.drawMinorTickMarks=true;this.useSeriesColor=false;this.borderWidth=null;this.borderColor=null;this.scaleToHiddenSeries=false;this._dataBounds={min:null,max:null};this._intervalStats=[];this._offsets={min:null,max:null};this._ticks=[];this._label=null;this.syncTicks=null;this.tickSpacing=75;this._min=null;this._max=null;this._tickInterval=null;this._numberTicks=null;this.__ticks=null;this._options={}}s.prototype=new H.jqplot.ElemContainer();s.prototype.constructor=s;s.prototype.init=function(){if(H.isFunction(this.renderer)){this.renderer=new this.renderer()}this.tickOptions.axis=this.name;if(this.tickOptions.showMark==null){this.tickOptions.showMark=this.showTicks}if(this.tickOptions.showMark==null){this.tickOptions.showMark=this.showTickMarks}if(this.tickOptions.showLabel==null){this.tickOptions.showLabel=this.showTicks}if(this.label==null||this.label==""){this.showLabel=false}else{this.labelOptions.label=this.label}if(this.showLabel==false){this.labelOptions.show=false}if(this.pad==0){this.pad=1}if(this.padMax==0){this.padMax=1}if(this.padMin==0){this.padMin=1}if(this.padMax==null){this.padMax=(this.pad-1)/2+1}if(this.padMin==null){this.padMin=(this.pad-1)/2+1}this.pad=this.padMax+this.padMin-1;if(this.min!=null||this.max!=null){this.autoscale=false}if(this.syncTicks==null&&this.name.indexOf("y")>-1){this.syncTicks=true}else{if(this.syncTicks==null){this.syncTicks=false}}this.renderer.init.call(this,this.rendererOptions)};s.prototype.draw=function(ab,ac){if(this.__ticks){this.__ticks=null}return this.renderer.draw.call(this,ab,ac)};s.prototype.set=function(){this.renderer.set.call(this)};s.prototype.pack=function(ac,ab){if(this.show){this.renderer.pack.call(this,ac,ab)}if(this._min==null){this._min=this.min;this._max=this.max;this._tickInterval=this.tickInterval;this._numberTicks=this.numberTicks;this.__ticks=this._ticks}};s.prototype.reset=function(){this.renderer.reset.call(this)};s.prototype.resetScale=function(ab){H.extend(true,this,{min:null,max:null,numberTicks:null,tickInterval:null,_ticks:[],ticks:[]},ab);this.resetDataBounds()};s.prototype.resetDataBounds=function(){var ai=this._dataBounds;ai.min=null;ai.max=null;var ac,aj,ag;var ad=(this.show)?true:false;for(var af=0;af<this._series.length;af++){aj=this._series[af];if(aj.show||this.scaleToHiddenSeries){ag=aj._plotData;if(aj._type==="line"&&aj.renderer.bands.show&&this.name.charAt(0)!=="x"){ag=[[0,aj.renderer.bands._min],[1,aj.renderer.bands._max]]}var ab=1,ah=1;if(aj._type!=null&&aj._type=="ohlc"){ab=3;ah=2}for(var ae=0,ac=ag.length;ae<ac;ae++){if(this.name=="xaxis"||this.name=="x2axis"){if((ag[ae][0]!=null&&ag[ae][0]<ai.min)||ai.min==null){ai.min=ag[ae][0]}if((ag[ae][0]!=null&&ag[ae][0]>ai.max)||ai.max==null){ai.max=ag[ae][0]}}else{if((ag[ae][ab]!=null&&ag[ae][ab]<ai.min)||ai.min==null){ai.min=ag[ae][ab]}if((ag[ae][ah]!=null&&ag[ae][ah]>ai.max)||ai.max==null){ai.max=ag[ae][ah]}}}if(ad&&aj.renderer.constructor!==H.jqplot.BarRenderer){ad=false}else{if(ad&&this._options.hasOwnProperty("forceTickAt0")&&this._options.forceTickAt0==false){ad=false}else{if(ad&&aj.renderer.constructor===H.jqplot.BarRenderer){if(aj.barDirection=="vertical"&&this.name!="xaxis"&&this.name!="x2axis"){if(this._options.pad!=null||this._options.padMin!=null){ad=false}}else{if(aj.barDirection=="horizontal"&&(this.name=="xaxis"||this.name=="x2axis")){if(this._options.pad!=null||this._options.padMin!=null){ad=false}}}}}}}}if(ad&&this.renderer.constructor===H.jqplot.LinearAxisRenderer&&ai.min>=0){this.padMin=1;this.forceTickAt0=true}};function n(ab){H.jqplot.ElemContainer.call(this);this.show=false;this.location="ne";this.labels=[];this.showLabels=true;this.showSwatches=true;this.placement="insideGrid";this.xoffset=0;this.yoffset=0;this.border;this.background;this.textColor;this.fontFamily;this.fontSize;this.rowSpacing="0.5em";this.renderer=H.jqplot.TableLegendRenderer;this.rendererOptions={};this.preDraw=false;this.marginTop=null;this.marginRight=null;this.marginBottom=null;this.marginLeft=null;this.escapeHtml=false;this._series=[];H.extend(true,this,ab)}n.prototype=new H.jqplot.ElemContainer();n.prototype.constructor=n;n.prototype.setOptions=function(ab){H.extend(true,this,ab);if(this.placement=="inside"){this.placement="insideGrid"}if(this.xoffset>0){if(this.placement=="insideGrid"){switch(this.location){case"nw":case"w":case"sw":if(this.marginLeft==null){this.marginLeft=this.xoffset+"px"}this.marginRight="0px";break;case"ne":case"e":case"se":default:if(this.marginRight==null){this.marginRight=this.xoffset+"px"}this.marginLeft="0px";break}}else{if(this.placement=="outside"){switch(this.location){case"nw":case"w":case"sw":if(this.marginRight==null){this.marginRight=this.xoffset+"px"}this.marginLeft="0px";break;case"ne":case"e":case"se":default:if(this.marginLeft==null){this.marginLeft=this.xoffset+"px"}this.marginRight="0px";break}}}this.xoffset=0}if(this.yoffset>0){if(this.placement=="outside"){switch(this.location){case"sw":case"s":case"se":if(this.marginTop==null){this.marginTop=this.yoffset+"px"}this.marginBottom="0px";break;case"ne":case"n":case"nw":default:if(this.marginBottom==null){this.marginBottom=this.yoffset+"px"}this.marginTop="0px";break}}else{if(this.placement=="insideGrid"){switch(this.location){case"sw":case"s":case"se":if(this.marginBottom==null){this.marginBottom=this.yoffset+"px"}this.marginTop="0px";break;case"ne":case"n":case"nw":default:if(this.marginTop==null){this.marginTop=this.yoffset+"px"}this.marginBottom="0px";break}}}this.yoffset=0}};n.prototype.init=function(){if(H.isFunction(this.renderer)){this.renderer=new this.renderer()}this.renderer.init.call(this,this.rendererOptions)};n.prototype.draw=function(ac,ad){for(var ab=0;ab<H.jqplot.preDrawLegendHooks.length;ab++){H.jqplot.preDrawLegendHooks[ab].call(this,ac)}return this.renderer.draw.call(this,ac,ad)};n.prototype.pack=function(ab){this.renderer.pack.call(this,ab)};function u(ab){H.jqplot.ElemContainer.call(this);this.text=ab;this.show=true;this.fontFamily;this.fontSize;this.textAlign;this.textColor;this.renderer=H.jqplot.DivTitleRenderer;this.rendererOptions={};this.escapeHtml=false}u.prototype=new H.jqplot.ElemContainer();u.prototype.constructor=u;u.prototype.init=function(){if(H.isFunction(this.renderer)){this.renderer=new this.renderer()}this.renderer.init.call(this,this.rendererOptions)};u.prototype.draw=function(ab){return this.renderer.draw.call(this,ab)};u.prototype.pack=function(){this.renderer.pack.call(this)};function O(){H.jqplot.ElemContainer.call(this);this.show=true;this.xaxis="xaxis";this._xaxis;this.yaxis="yaxis";this._yaxis;this.gridBorderWidth=2;this.renderer=H.jqplot.LineRenderer;this.rendererOptions={};this.data=[];this.gridData=[];this.label="";this.showLabel=true;this.color;this.negativeColor;this.lineWidth=2.5;this.lineJoin="round";this.lineCap="round";this.linePattern="solid";this.shadow=true;this.shadowAngle=45;this.shadowOffset=1.25;this.shadowDepth=3;this.shadowAlpha="0.1";this.breakOnNull=false;this.markerRenderer=H.jqplot.MarkerRenderer;this.markerOptions={};this.showLine=true;this.showMarker=true;this.index;this.fill=false;this.fillColor;this.fillAlpha;this.fillAndStroke=false;this.disableStack=false;this._stack=false;this.neighborThreshold=4;this.fillToZero=false;this.fillToValue=0;this.fillAxis="y";this.useNegativeColors=true;this._stackData=[];this._plotData=[];this._plotValues={x:[],y:[]};this._intervals={x:{},y:{}};this._prevPlotData=[];this._prevGridData=[];this._stackAxis="y";this._primaryAxis="_xaxis";this.canvas=new H.jqplot.GenericCanvas();this.shadowCanvas=new H.jqplot.GenericCanvas();this.plugins={};this._sumy=0;this._sumx=0;this._type=""}O.prototype=new H.jqplot.ElemContainer();O.prototype.constructor=O;O.prototype.init=function(ad,ah,af){this.index=ad;this.gridBorderWidth=ah;var ag=this.data;var ac=[],ae;for(ae=0;ae<ag.length;ae++){if(!this.breakOnNull){if(ag[ae]==null||ag[ae][0]==null||ag[ae][1]==null){continue}else{ac.push(ag[ae])}}else{ac.push(ag[ae])}}this.data=ac;if(!this.color){this.color=af.colorGenerator.get(this.index)}if(!this.negativeColor){this.negativeColor=af.negativeColorGenerator.get(this.index)}if(!this.fillColor){this.fillColor=this.color}if(this.fillAlpha){var ab=H.jqplot.normalize2rgb(this.fillColor);var ab=H.jqplot.getColorComponents(ab);this.fillColor="rgba("+ab[0]+","+ab[1]+","+ab[2]+","+this.fillAlpha+")"}if(H.isFunction(this.renderer)){this.renderer=new this.renderer()}this.renderer.init.call(this,this.rendererOptions,af);this.markerRenderer=new this.markerRenderer();if(!this.markerOptions.color){this.markerOptions.color=this.color}if(this.markerOptions.show==null){this.markerOptions.show=this.showMarker}this.showMarker=this.markerOptions.show;this.markerRenderer.init(this.markerOptions)};O.prototype.draw=function(ah,ae,ag){var ac=(ae==r)?{}:ae;ah=(ah==r)?this.canvas._ctx:ah;var ab,af,ad;for(ab=0;ab<H.jqplot.preDrawSeriesHooks.length;ab++){H.jqplot.preDrawSeriesHooks[ab].call(this,ah,ac)}if(this.show){this.renderer.setGridData.call(this,ag);if(!ac.preventJqPlotSeriesDrawTrigger){H(ah.canvas).trigger("jqplotSeriesDraw",[this.data,this.gridData])}af=[];if(ac.data){af=ac.data}else{if(!this._stack){af=this.data}else{af=this._plotData}}ad=ac.gridData||this.renderer.makeGridData.call(this,af,ag);if(this._type==="line"&&this.renderer.smooth&&this.renderer._smoothedData.length){ad=this.renderer._smoothedData}this.renderer.draw.call(this,ah,ad,ac,ag)}for(ab=0;ab<H.jqplot.postDrawSeriesHooks.length;ab++){H.jqplot.postDrawSeriesHooks[ab].call(this,ah,ac,ag)}ah=ae=ag=ab=af=ad=null};O.prototype.drawShadow=function(ah,ae,ag){var ac=(ae==r)?{}:ae;ah=(ah==r)?this.shadowCanvas._ctx:ah;var ab,af,ad;for(ab=0;ab<H.jqplot.preDrawSeriesShadowHooks.length;ab++){H.jqplot.preDrawSeriesShadowHooks[ab].call(this,ah,ac)}if(this.shadow){this.renderer.setGridData.call(this,ag);af=[];if(ac.data){af=ac.data}else{if(!this._stack){af=this.data}else{af=this._plotData}}ad=ac.gridData||this.renderer.makeGridData.call(this,af,ag);this.renderer.drawShadow.call(this,ah,ad,ac)}for(ab=0;ab<H.jqplot.postDrawSeriesShadowHooks.length;ab++){H.jqplot.postDrawSeriesShadowHooks[ab].call(this,ah,ac)}ah=ae=ag=ab=af=ad=null};O.prototype.toggleDisplay=function(ac,ae){var ab,ad;if(ac.data.series){ab=ac.data.series}else{ab=this}if(ac.data.speed){ad=ac.data.speed}if(ad){if(ab.canvas._elem.is(":hidden")||!ab.show){ab.show=true;ab.canvas._elem.removeClass("jqplot-series-hidden");if(ab.shadowCanvas._elem){ab.shadowCanvas._elem.fadeIn(ad)}ab.canvas._elem.fadeIn(ad,ae);ab.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+ab.index).fadeIn(ad)}else{ab.show=false;ab.canvas._elem.addClass("jqplot-series-hidden");if(ab.shadowCanvas._elem){ab.shadowCanvas._elem.fadeOut(ad)}ab.canvas._elem.fadeOut(ad,ae);ab.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+ab.index).fadeOut(ad)}}else{if(ab.canvas._elem.is(":hidden")||!ab.show){ab.show=true;ab.canvas._elem.removeClass("jqplot-series-hidden");if(ab.shadowCanvas._elem){ab.shadowCanvas._elem.show()}ab.canvas._elem.show(0,ae);ab.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+ab.index).show()}else{ab.show=false;ab.canvas._elem.addClass("jqplot-series-hidden");if(ab.shadowCanvas._elem){ab.shadowCanvas._elem.hide()}ab.canvas._elem.hide(0,ae);ab.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+ab.index).hide()}}};function I(){H.jqplot.ElemContainer.call(this);this.drawGridlines=true;this.gridLineColor="#cccccc";this.gridLineWidth=1;this.background="#fffdf6";this.borderColor="#999999";this.borderWidth=2;this.drawBorder=true;this.shadow=true;this.shadowAngle=45;this.shadowOffset=1.5;this.shadowWidth=3;this.shadowDepth=3;this.shadowColor=null;this.shadowAlpha="0.07";this._left;this._top;this._right;this._bottom;this._width;this._height;this._axes=[];this.renderer=H.jqplot.CanvasGridRenderer;this.rendererOptions={};this._offsets={top:null,bottom:null,left:null,right:null}}I.prototype=new H.jqplot.ElemContainer();I.prototype.constructor=I;I.prototype.init=function(){if(H.isFunction(this.renderer)){this.renderer=new this.renderer()}this.renderer.init.call(this,this.rendererOptions)};I.prototype.createElement=function(ab,ac){this._offsets=ab;return this.renderer.createElement.call(this,ac)};I.prototype.draw=function(){this.renderer.draw.call(this)};H.jqplot.GenericCanvas=function(){H.jqplot.ElemContainer.call(this);this._ctx};H.jqplot.GenericCanvas.prototype=new H.jqplot.ElemContainer();H.jqplot.GenericCanvas.prototype.constructor=H.jqplot.GenericCanvas;H.jqplot.GenericCanvas.prototype.createElement=function(af,ad,ac,ag){this._offsets=af;var ab="jqplot";if(ad!=r){ab=ad}var ae;ae=ag.canvasManager.getCanvas();if(ac!=null){this._plotDimensions=ac}ae.width=this._plotDimensions.width-this._offsets.left-this._offsets.right;ae.height=this._plotDimensions.height-this._offsets.top-this._offsets.bottom;this._elem=H(ae);this._elem.css({position:"absolute",left:this._offsets.left,top:this._offsets.top});this._elem.addClass(ab);ae=ag.canvasManager.initCanvas(ae);ae=null;return this._elem};H.jqplot.GenericCanvas.prototype.setContext=function(){this._ctx=this._elem.get(0).getContext("2d");return this._ctx};H.jqplot.GenericCanvas.prototype.resetCanvas=function(){if(this._elem){if(H.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==r){window.G_vmlCanvasManager.uninitElement(this._elem.get(0))}this._elem.emptyForce()}this._ctx=null};H.jqplot.HooksManager=function(){this.hooks=[];this.args=[]};H.jqplot.HooksManager.prototype.addOnce=function(ae,ac){ac=ac||[];var af=false;for(var ad=0,ab=this.hooks.length;ad<ab;ad++){if(this.hooks[ad]==ae){af=true}}if(!af){this.hooks.push(ae);this.args.push(ac)}};H.jqplot.HooksManager.prototype.add=function(ac,ab){ab=ab||[];this.hooks.push(ac);this.args.push(ab)};H.jqplot.EventListenerManager=function(){this.hooks=[]};H.jqplot.EventListenerManager.prototype.addOnce=function(af,ae){var ag=false,ad,ac;for(var ac=0,ab=this.hooks.length;ac<ab;ac++){ad=this.hooks[ac];if(ad[0]==af&&ad[1]==ae){ag=true}}if(!ag){this.hooks.push([af,ae])}};H.jqplot.EventListenerManager.prototype.add=function(ac,ab){this.hooks.push([ac,ab])};var Q=["yMidAxis","xaxis","yaxis","x2axis","y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];function N(){this.animate=false;this.animateReplot=false;this.axes={xaxis:new s("xaxis"),yaxis:new s("yaxis"),x2axis:new s("x2axis"),y2axis:new s("y2axis"),y3axis:new s("y3axis"),y4axis:new s("y4axis"),y5axis:new s("y5axis"),y6axis:new s("y6axis"),y7axis:new s("y7axis"),y8axis:new s("y8axis"),y9axis:new s("y9axis"),yMidAxis:new s("yMidAxis")};this.baseCanvas=new H.jqplot.GenericCanvas();this.captureRightClick=false;this.data=[];this.dataRenderer;this.dataRendererOptions;this.defaults={axesDefaults:{},axes:{xaxis:{},yaxis:{},x2axis:{},y2axis:{},y3axis:{},y4axis:{},y5axis:{},y6axis:{},y7axis:{},y8axis:{},y9axis:{},yMidAxis:{}},seriesDefaults:{},series:[]};this.defaultAxisStart=1;this.drawIfHidden=false;this.eventCanvas=new H.jqplot.GenericCanvas();this.fillBetween={series1:null,series2:null,color:null,baseSeries:0,fill:true};this.fontFamily;this.fontSize;this.grid=new I();this.legend=new n();this.negativeSeriesColors=H.jqplot.config.defaultNegativeColors;this.noDataIndicator={show:false,indicator:"Loading Data...",axes:{xaxis:{min:0,max:10,tickInterval:2,show:true},yaxis:{min:0,max:12,tickInterval:3,show:true}}};this.options={};this.previousSeriesStack=[];this.plugins={};this.series=[];this.seriesStack=[];this.seriesColors=H.jqplot.config.defaultColors;this.sortData=true;this.stackSeries=false;this.syncXTicks=true;this.syncYTicks=true;this.target=null;this.targetId=null;this.textColor;this.title=new u();this._drawCount=0;this._sumy=0;this._sumx=0;this._stackData=[];this._plotData=[];this._width=null;this._height=null;this._plotDimensions={height:null,width:null};this._gridPadding={top:null,right:null,bottom:null,left:null};this._defaultGridPadding={top:10,right:10,bottom:23,left:10};this._addDomReference=H.jqplot.config.addDomReference;this.preInitHooks=new H.jqplot.HooksManager();this.postInitHooks=new H.jqplot.HooksManager();this.preParseOptionsHooks=new H.jqplot.HooksManager();this.postParseOptionsHooks=new H.jqplot.HooksManager();this.preDrawHooks=new H.jqplot.HooksManager();this.postDrawHooks=new H.jqplot.HooksManager();this.preDrawSeriesHooks=new H.jqplot.HooksManager();this.postDrawSeriesHooks=new H.jqplot.HooksManager();this.preDrawLegendHooks=new H.jqplot.HooksManager();this.addLegendRowHooks=new H.jqplot.HooksManager();this.preSeriesInitHooks=new H.jqplot.HooksManager();this.postSeriesInitHooks=new H.jqplot.HooksManager();this.preParseSeriesOptionsHooks=new H.jqplot.HooksManager();this.postParseSeriesOptionsHooks=new H.jqplot.HooksManager();this.eventListenerHooks=new H.jqplot.EventListenerManager();this.preDrawSeriesShadowHooks=new H.jqplot.HooksManager();this.postDrawSeriesShadowHooks=new H.jqplot.HooksManager();this.colorGenerator=new H.jqplot.ColorGenerator();this.negativeColorGenerator=new H.jqplot.ColorGenerator();this.canvasManager=new H.jqplot.CanvasManager();this.themeEngine=new H.jqplot.ThemeEngine();var ad=0;this.init=function(ao,al,aq){aq=aq||{};for(var am=0;am<H.jqplot.preInitHooks.length;am++){H.jqplot.preInitHooks[am].call(this,ao,al,aq)}for(var am=0;am<this.preInitHooks.hooks.length;am++){this.preInitHooks.hooks[am].call(this,ao,al,aq)}this.targetId="#"+ao;this.target=H("#"+ao);if(this._addDomReference){this.target.data("jqplot",this)}this.target.removeClass("jqplot-error");if(!this.target.get(0)){throw"No plot target specified"}if(this.target.css("position")=="static"){this.target.css("position","relative")}if(!this.target.hasClass("jqplot-target")){this.target.addClass("jqplot-target")}if(!this.target.height()){var an;if(aq&&aq.height){an=parseInt(aq.height,10)}else{if(this.target.attr("data-height")){an=parseInt(this.target.attr("data-height"),10)}else{an=parseInt(H.jqplot.config.defaultHeight,10)}}this._height=an;this.target.css("height",an+"px")}else{this._height=an=this.target.height()}if(!this.target.width()){var ap;if(aq&&aq.width){ap=parseInt(aq.width,10)}else{if(this.target.attr("data-width")){ap=parseInt(this.target.attr("data-width"),10)}else{ap=parseInt(H.jqplot.config.defaultWidth,10)}}this._width=ap;this.target.css("width",ap+"px")}else{this._width=ap=this.target.width()}for(var am=0,aj=Q.length;am<aj;am++){this.axes[Q[am]]=new s(Q[am])}this._plotDimensions.height=this._height;this._plotDimensions.width=this._width;this.grid._plotDimensions=this._plotDimensions;this.title._plotDimensions=this._plotDimensions;this.baseCanvas._plotDimensions=this._plotDimensions;this.eventCanvas._plotDimensions=this._plotDimensions;this.legend._plotDimensions=this._plotDimensions;if(this._height<=0||this._width<=0||!this._height||!this._width){throw"Canvas dimension not set"}if(aq.dataRenderer&&H.isFunction(aq.dataRenderer)){if(aq.dataRendererOptions){this.dataRendererOptions=aq.dataRendererOptions}this.dataRenderer=aq.dataRenderer;al=this.dataRenderer(al,this,this.dataRendererOptions)}if(aq.noDataIndicator&&H.isPlainObject(aq.noDataIndicator)){H.extend(true,this.noDataIndicator,aq.noDataIndicator)}if(al==null||H.isArray(al)==false||al.length==0||H.isArray(al[0])==false||al[0].length==0){if(this.noDataIndicator.show==false){throw"No Data"}else{for(var af in this.noDataIndicator.axes){for(var ah in this.noDataIndicator.axes[af]){this.axes[af][ah]=this.noDataIndicator.axes[af][ah]}}this.postDrawHooks.add(function(){var ax=this.eventCanvas.getHeight();var au=this.eventCanvas.getWidth();var at=H('<div class="jqplot-noData-container" style="position:absolute;"></div>');this.target.append(at);at.height(ax);at.width(au);at.css("top",this.eventCanvas._offsets.top);at.css("left",this.eventCanvas._offsets.left);var aw=H('<div class="jqplot-noData-contents" style="text-align:center; position:relative; margin-left:auto; margin-right:auto;"></div>');at.append(aw);aw.html(this.noDataIndicator.indicator);var av=aw.height();var ar=aw.width();aw.height(av);aw.width(ar);aw.css("top",(ax-av)/2+"px")})}}this.data=H.extend(true,[],al);this.parseOptions(aq);if(this.textColor){this.target.css("color",this.textColor)}if(this.fontFamily){this.target.css("font-family",this.fontFamily)}if(this.fontSize){this.target.css("font-size",this.fontSize)}this.title.init();this.legend.init();this._sumy=0;this._sumx=0;for(var am=0;am<this.series.length;am++){this.seriesStack.push(am);this.previousSeriesStack.push(am);this.series[am].shadowCanvas._plotDimensions=this._plotDimensions;this.series[am].canvas._plotDimensions=this._plotDimensions;for(var ak=0;ak<H.jqplot.preSeriesInitHooks.length;ak++){H.jqplot.preSeriesInitHooks[ak].call(this.series[am],ao,this.data,this.options.seriesDefaults,this.options.series[am],this)}for(var ak=0;ak<this.preSeriesInitHooks.hooks.length;ak++){this.preSeriesInitHooks.hooks[ak].call(this.series[am],ao,this.data,this.options.seriesDefaults,this.options.series[am],this)}this.populatePlotData(this.series[am],am);this.series[am]._plotDimensions=this._plotDimensions;this.series[am].init(am,this.grid.borderWidth,this);for(var ak=0;ak<H.jqplot.postSeriesInitHooks.length;ak++){H.jqplot.postSeriesInitHooks[ak].call(this.series[am],ao,this.data,this.options.seriesDefaults,this.options.series[am],this)}for(var ak=0;ak<this.postSeriesInitHooks.hooks.length;ak++){this.postSeriesInitHooks.hooks[ak].call(this.series[am],ao,this.data,this.options.seriesDefaults,this.options.series[am],this)}this._sumy+=this.series[am]._sumy;this._sumx+=this.series[am]._sumx}var ag,ai;for(var am=0,aj=Q.length;am<aj;am++){ag=Q[am];ai=this.axes[ag];ai._plotDimensions=this._plotDimensions;ai.init();if(this.axes[ag].borderColor==null){if(ag.charAt(0)!=="x"&&ai.useSeriesColor===true&&ai.show){ai.borderColor=ai._series[0].color}else{ai.borderColor=this.grid.borderColor}}}if(this.sortData){ab(this.series)}this.grid.init();this.grid._axes=this.axes;this.legend._series=this.series;for(var am=0;am<H.jqplot.postInitHooks.length;am++){H.jqplot.postInitHooks[am].call(this,ao,this.data,aq)}for(var am=0;am<this.postInitHooks.hooks.length;am++){this.postInitHooks.hooks[am].call(this,ao,this.data,aq)}};this.resetAxesScale=function(ak,ag){var ai=ag||{};var aj=ak||this.axes;if(aj===true){aj=this.axes}if(H.isArray(aj)){for(var ah=0;ah<aj.length;ah++){this.axes[aj[ah]].resetScale(ai[aj[ah]])}}else{if(typeof(aj)==="object"){for(var af in aj){this.axes[af].resetScale(ai[af])}}}};this.reInitialize=function(an,af){var ar=H.extend(true,{},this.options,af);var ap=this.targetId.substr(1);var al=(an==null)?this.data:an;for(var ao=0;ao<H.jqplot.preInitHooks.length;ao++){H.jqplot.preInitHooks[ao].call(this,ap,al,ar)}for(var ao=0;ao<this.preInitHooks.hooks.length;ao++){this.preInitHooks.hooks[ao].call(this,ap,al,ar)}this._height=this.target.height();this._width=this.target.width();if(this._height<=0||this._width<=0||!this._height||!this._width){throw"Target dimension not set"}this._plotDimensions.height=this._height;this._plotDimensions.width=this._width;this.grid._plotDimensions=this._plotDimensions;this.title._plotDimensions=this._plotDimensions;this.baseCanvas._plotDimensions=this._plotDimensions;this.eventCanvas._plotDimensions=this._plotDimensions;this.legend._plotDimensions=this._plotDimensions;var ag,aq,am,ai;for(var ao=0,ak=Q.length;ao<ak;ao++){ag=Q[ao];ai=this.axes[ag];aq=ai._ticks;for(var am=0,aj=aq.length;am<aj;am++){var ah=aq[am]._elem;if(ah){if(H.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==r){window.G_vmlCanvasManager.uninitElement(ah.get(0))}ah.emptyForce();ah=null;aq._elem=null}}aq=null;delete ai.ticks;delete ai._ticks;this.axes[ag]=new s(ag);this.axes[ag]._plotWidth=this._width;this.axes[ag]._plotHeight=this._height}if(an){if(ar.dataRenderer&&H.isFunction(ar.dataRenderer)){if(ar.dataRendererOptions){this.dataRendererOptions=ar.dataRendererOptions}this.dataRenderer=ar.dataRenderer;an=this.dataRenderer(an,this,this.dataRendererOptions)}this.data=H.extend(true,[],an)}if(af){this.parseOptions(ar)}this.title._plotWidth=this._width;if(this.textColor){this.target.css("color",this.textColor)}if(this.fontFamily){this.target.css("font-family",this.fontFamily)}if(this.fontSize){this.target.css("font-size",this.fontSize)}this.title.init();this.legend.init();this._sumy=0;this._sumx=0;this.seriesStack=[];this.previousSeriesStack=[];for(var ao=0,ak=this.series.length;ao<ak;ao++){this.seriesStack.push(ao);this.previousSeriesStack.push(ao);this.series[ao].shadowCanvas._plotDimensions=this._plotDimensions;this.series[ao].canvas._plotDimensions=this._plotDimensions;for(var am=0;am<H.jqplot.preSeriesInitHooks.length;am++){H.jqplot.preSeriesInitHooks[am].call(this.series[ao],ap,this.data,this.options.seriesDefaults,this.options.series[ao],this)}for(var am=0;am<this.preSeriesInitHooks.hooks.length;am++){this.preSeriesInitHooks.hooks[am].call(this.series[ao],ap,this.data,this.options.seriesDefaults,this.options.series[ao],this)}this.populatePlotData(this.series[ao],ao);this.series[ao]._plotDimensions=this._plotDimensions;this.series[ao].init(ao,this.grid.borderWidth,this);for(var am=0;am<H.jqplot.postSeriesInitHooks.length;am++){H.jqplot.postSeriesInitHooks[am].call(this.series[ao],ap,this.data,this.options.seriesDefaults,this.options.series[ao],this)}for(var am=0;am<this.postSeriesInitHooks.hooks.length;am++){this.postSeriesInitHooks.hooks[am].call(this.series[ao],ap,this.data,this.options.seriesDefaults,this.options.series[ao],this)}this._sumy+=this.series[ao]._sumy;this._sumx+=this.series[ao]._sumx}for(var ao=0,ak=Q.length;ao<ak;ao++){ag=Q[ao];ai=this.axes[ag];ai._plotDimensions=this._plotDimensions;ai.init();if(ai.borderColor==null){if(ag.charAt(0)!=="x"&&ai.useSeriesColor===true&&ai.show){ai.borderColor=ai._series[0].color}else{ai.borderColor=this.grid.borderColor}}}if(this.sortData){ab(this.series)}this.grid.init();this.grid._axes=this.axes;this.legend._series=this.series;for(var ao=0,ak=H.jqplot.postInitHooks.length;ao<ak;ao++){H.jqplot.postInitHooks[ao].call(this,ap,this.data,ar)}for(var ao=0,ak=this.postInitHooks.hooks.length;ao<ak;ao++){this.postInitHooks.hooks[ao].call(this,ap,this.data,ar)}};this.quickInit=function(){this._height=this.target.height();this._width=this.target.width();if(this._height<=0||this._width<=0||!this._height||!this._width){throw"Target dimension not set"}this._plotDimensions.height=this._height;this._plotDimensions.width=this._width;this.grid._plotDimensions=this._plotDimensions;this.title._plotDimensions=this._plotDimensions;this.baseCanvas._plotDimensions=this._plotDimensions;this.eventCanvas._plotDimensions=this._plotDimensions;this.legend._plotDimensions=this._plotDimensions;for(var ak in this.axes){this.axes[ak]._plotWidth=this._width;this.axes[ak]._plotHeight=this._height}this.title._plotWidth=this._width;if(this.textColor){this.target.css("color",this.textColor)}if(this.fontFamily){this.target.css("font-family",this.fontFamily)}if(this.fontSize){this.target.css("font-size",this.fontSize)}this._sumy=0;this._sumx=0;for(var ai=0;ai<this.series.length;ai++){this.populatePlotData(this.series[ai],ai);if(this.series[ai]._type==="line"&&this.series[ai].renderer.bands.show){this.series[ai].renderer.initBands.call(this.series[ai],this.series[ai].renderer.options,this)}this.series[ai]._plotDimensions=this._plotDimensions;this.series[ai].canvas._plotDimensions=this._plotDimensions;this._sumy+=this.series[ai]._sumy;this._sumx+=this.series[ai]._sumx}var ag;for(var af=0;af<12;af++){ag=Q[af];var ah=this.axes[ag]._ticks;for(var ai=0;ai<ah.length;ai++){var aj=ah[ai]._elem;if(aj){if(H.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==r){window.G_vmlCanvasManager.uninitElement(aj.get(0))}aj.emptyForce();aj=null;ah._elem=null}}ah=null;this.axes[ag]._plotDimensions=this._plotDimensions;this.axes[ag]._ticks=[]}if(this.sortData){ab(this.series)}this.grid._axes=this.axes;this.legend._series=this.series};function ab(aj){var an,ao,ap,af,am;for(var ak=0;ak<aj.length;ak++){var ag;var al=[aj[ak].data,aj[ak]._stackData,aj[ak]._plotData,aj[ak]._prevPlotData];for(var ah=0;ah<4;ah++){ag=true;an=al[ah];if(aj[ak]._stackAxis=="x"){for(var ai=0;ai<an.length;ai++){if(typeof(an[ai][1])!="number"){ag=false;break}}if(ag){an.sort(function(ar,aq){return ar[1]-aq[1]})}}else{for(var ai=0;ai<an.length;ai++){if(typeof(an[ai][0])!="number"){ag=false;break}}if(ag){an.sort(function(ar,aq){return ar[0]-aq[0]})}}}}}this.populatePlotData=function(aj,ak){this._plotData=[];this._stackData=[];aj._stackData=[];aj._plotData=[];var an={x:[],y:[]};if(this.stackSeries&&!aj.disableStack){aj._stack=true;var al=aj._stackAxis=="x"?0:1;var am=al?0:1;var ao=H.extend(true,[],aj.data);var ap=H.extend(true,[],aj.data);for(var ah=0;ah<ak;ah++){var af=this.series[ah].data;for(var ag=0;ag<af.length;ag++){ao[ag][0]+=af[ag][0];ao[ag][1]+=af[ag][1];ap[ag][al]+=af[ag][al]}}for(var ai=0;ai<ap.length;ai++){an.x.push(ap[ai][0]);an.y.push(ap[ai][1])}this._plotData.push(ap);this._stackData.push(ao);aj._stackData=ao;aj._plotData=ap;aj._plotValues=an}else{for(var ai=0;ai<aj.data.length;ai++){an.x.push(aj.data[ai][0]);an.y.push(aj.data[ai][1])}this._stackData.push(aj.data);this.series[ak]._stackData=aj.data;this._plotData.push(aj.data);aj._plotData=aj.data;aj._plotValues=an}if(ak>0){aj._prevPlotData=this.series[ak-1]._plotData}aj._sumy=0;aj._sumx=0;for(ai=aj.data.length-1;ai>-1;ai--){aj._sumy+=aj.data[ai][1];aj._sumx+=aj.data[ai][0]}};this.getNextSeriesColor=(function(ag){var af=0;var ah=ag.seriesColors;return function(){if(af<ah.length){return ah[af++]}else{af=0;return ah[af++]}}})(this);this.parseOptions=function(aq){for(var al=0;al<this.preParseOptionsHooks.hooks.length;al++){this.preParseOptionsHooks.hooks[al].call(this,aq)}for(var al=0;al<H.jqplot.preParseOptionsHooks.length;al++){H.jqplot.preParseOptionsHooks[al].call(this,aq)}this.options=H.extend(true,{},this.defaults,aq);var af=this.options;this.animate=af.animate;this.animateReplot=af.animateReplot;this.stackSeries=af.stackSeries;if(H.isPlainObject(af.fillBetween)){var ap=["series1","series2","color","baseSeries","fill"],am;for(var al=0,aj=ap.length;al<aj;al++){am=ap[al];if(af.fillBetween[am]!=null){this.fillBetween[am]=af.fillBetween[am]}}}if(af.seriesColors){this.seriesColors=af.seriesColors}if(af.negativeSeriesColors){this.negativeSeriesColors=af.negativeSeriesColors}if(af.captureRightClick){this.captureRightClick=af.captureRightClick}this.defaultAxisStart=(aq&&aq.defaultAxisStart!=null)?aq.defaultAxisStart:this.defaultAxisStart;this.colorGenerator.setColors(this.seriesColors);this.negativeColorGenerator.setColors(this.negativeSeriesColors);H.extend(true,this._gridPadding,af.gridPadding);this.sortData=(af.sortData!=null)?af.sortData:this.sortData;for(var al=0;al<12;al++){var ag=Q[al];var ai=this.axes[ag];ai._options=H.extend(true,{},af.axesDefaults,af.axes[ag]);H.extend(true,ai,af.axesDefaults,af.axes[ag]);ai._plotWidth=this._width;ai._plotHeight=this._height}var ao=function(av,at,aw){var ar=[];var au;at=at||"vertical";if(!H.isArray(av[0])){for(au=0;au<av.length;au++){if(at=="vertical"){ar.push([aw+au,av[au]])}else{ar.push([av[au],aw+au])}}}else{H.extend(true,ar,av)}return ar};var an=0;this.series=[];for(var al=0;al<this.data.length;al++){var ap=new O();for(var ak=0;ak<H.jqplot.preParseSeriesOptionsHooks.length;ak++){H.jqplot.preParseSeriesOptionsHooks[ak].call(ap,this.options.seriesDefaults,this.options.series[al])}for(var ak=0;ak<this.preParseSeriesOptionsHooks.hooks.length;ak++){this.preParseSeriesOptionsHooks.hooks[ak].call(ap,this.options.seriesDefaults,this.options.series[al])}H.extend(true,ap,{seriesColors:this.seriesColors,negativeSeriesColors:this.negativeSeriesColors},this.options.seriesDefaults,this.options.series[al],{rendererOptions:{animation:{show:this.animate}}});var ah="vertical";if(ap.renderer===H.jqplot.BarRenderer&&ap.rendererOptions&&ap.rendererOptions.barDirection=="horizontal"&&ap.transposeData===true){ah="horizontal"}ap.data=ao(this.data[al],ah,this.defaultAxisStart);switch(ap.xaxis){case"xaxis":ap._xaxis=this.axes.xaxis;break;case"x2axis":ap._xaxis=this.axes.x2axis;break;default:break}ap._yaxis=this.axes[ap.yaxis];ap._xaxis._series.push(ap);ap._yaxis._series.push(ap);if(ap.show){ap._xaxis.show=true;ap._yaxis.show=true}else{if(ap._xaxis.scaleToHiddenSeries){ap._xaxis.show=true}if(ap._yaxis.scaleToHiddenSeries){ap._yaxis.show=true}}if(!ap.label){ap.label="Series "+(al+1).toString()}this.series.push(ap);for(var ak=0;ak<H.jqplot.postParseSeriesOptionsHooks.length;ak++){H.jqplot.postParseSeriesOptionsHooks[ak].call(this.series[al],this.options.seriesDefaults,this.options.series[al])}for(var ak=0;ak<this.postParseSeriesOptionsHooks.hooks.length;ak++){this.postParseSeriesOptionsHooks.hooks[ak].call(this.series[al],this.options.seriesDefaults,this.options.series[al])}}H.extend(true,this.grid,this.options.grid);for(var al=0,aj=Q.length;al<aj;al++){var ag=Q[al];var ai=this.axes[ag];if(ai.borderWidth==null){ai.borderWidth=this.grid.borderWidth}}if(typeof this.options.title=="string"){this.title.text=this.options.title}else{if(typeof this.options.title=="object"){H.extend(true,this.title,this.options.title)}}this.title._plotWidth=this._width;this.legend.setOptions(this.options.legend);for(var al=0;al<H.jqplot.postParseOptionsHooks.length;al++){H.jqplot.postParseOptionsHooks[al].call(this,aq)}for(var al=0;al<this.postParseOptionsHooks.hooks.length;al++){this.postParseOptionsHooks.hooks[al].call(this,aq)}};this.destroy=function(){this.canvasManager.freeAllCanvases();if(this.eventCanvas&&this.eventCanvas._elem){this.eventCanvas._elem.unbind()}this.target.empty();this.target[0].innerHTML=""};this.replot=function(ag){var ah=ag||{};var aj=ah.data||null;var af=(ah.clear===false)?false:true;var ai=ah.resetAxes||false;delete ah.data;delete ah.clear;delete ah.resetAxes;this.target.trigger("jqplotPreReplot");if(af){this.destroy()}if(aj||!H.isEmptyObject(ah)){this.reInitialize(aj,ah)}else{this.quickInit()}if(ai){this.resetAxesScale(ai,ah.axes)}this.draw();this.target.trigger("jqplotPostReplot")};this.redraw=function(af){af=(af!=null)?af:true;this.target.trigger("jqplotPreRedraw");if(af){this.canvasManager.freeAllCanvases();this.eventCanvas._elem.unbind();this.target.empty()}for(var ah in this.axes){this.axes[ah]._ticks=[]}for(var ag=0;ag<this.series.length;ag++){this.populatePlotData(this.series[ag],ag)}this._sumy=0;this._sumx=0;for(ag=0;ag<this.series.length;ag++){this._sumy+=this.series[ag]._sumy;this._sumx+=this.series[ag]._sumx}this.draw();this.target.trigger("jqplotPostRedraw")};this.draw=function(){if(this.drawIfHidden||this.target.is(":visible")){this.target.trigger("jqplotPreDraw");var aB,az,ay,ai;for(aB=0,ay=H.jqplot.preDrawHooks.length;aB<ay;aB++){H.jqplot.preDrawHooks[aB].call(this)}for(aB=0,ay=this.preDrawHooks.length;aB<ay;aB++){this.preDrawHooks.hooks[aB].apply(this,this.preDrawSeriesHooks.args[aB])}this.target.append(this.baseCanvas.createElement({left:0,right:0,top:0,bottom:0},"jqplot-base-canvas",null,this));this.baseCanvas.setContext();this.target.append(this.title.draw());this.title.pack({top:0,left:0});var aF=this.legend.draw({},this);var af={top:0,left:0,bottom:0,right:0};if(this.legend.placement=="outsideGrid"){this.target.append(aF);switch(this.legend.location){case"n":af.top+=this.legend.getHeight();break;case"s":af.bottom+=this.legend.getHeight();break;case"ne":case"e":case"se":af.right+=this.legend.getWidth();break;case"nw":case"w":case"sw":af.left+=this.legend.getWidth();break;default:af.right+=this.legend.getWidth();break}aF=aF.detach()}var al=this.axes;var aG;for(aB=0;aB<12;aB++){aG=Q[aB];this.target.append(al[aG].draw(this.baseCanvas._ctx,this));al[aG].set()}if(al.yaxis.show){af.left+=al.yaxis.getWidth()}var aA=["y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];var ar=[0,0,0,0,0,0,0,0];var av=0;var au;for(au=0;au<8;au++){if(al[aA[au]].show){av+=al[aA[au]].getWidth();ar[au]=av}}af.right+=av;if(al.x2axis.show){af.top+=al.x2axis.getHeight()}if(this.title.show){af.top+=this.title.getHeight()}if(al.xaxis.show){af.bottom+=al.xaxis.getHeight()}if(this.options.gridDimensions&&H.isPlainObject(this.options.gridDimensions)){var am=parseInt(this.options.gridDimensions.width,10)||0;var aC=parseInt(this.options.gridDimensions.height,10)||0;var ah=(this._width-af.left-af.right-am)/2;var aE=(this._height-af.top-af.bottom-aC)/2;if(aE>=0&&ah>=0){af.top+=aE;af.bottom+=aE;af.left+=ah;af.right+=ah}}var ag=["top","bottom","left","right"];for(var au in ag){if(this._gridPadding[ag[au]]==null&&af[ag[au]]>0){this._gridPadding[ag[au]]=af[ag[au]]}else{if(this._gridPadding[ag[au]]==null){this._gridPadding[ag[au]]=this._defaultGridPadding[ag[au]]}}}var at=this._gridPadding;if(this.legend.placement==="outsideGrid"){at={top:this.title.getHeight(),left:0,right:0,bottom:0};if(this.legend.location==="s"){at.left=this._gridPadding.left;at.right=this._gridPadding.right}}al.xaxis.pack({position:"absolute",bottom:this._gridPadding.bottom-al.xaxis.getHeight(),left:0,width:this._width},{min:this._gridPadding.left,max:this._width-this._gridPadding.right});al.yaxis.pack({position:"absolute",top:0,left:this._gridPadding.left-al.yaxis.getWidth(),height:this._height},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top});al.x2axis.pack({position:"absolute",top:this._gridPadding.top-al.x2axis.getHeight(),left:0,width:this._width},{min:this._gridPadding.left,max:this._width-this._gridPadding.right});for(aB=8;aB>0;aB--){al[aA[aB-1]].pack({position:"absolute",top:0,right:this._gridPadding.right-ar[aB-1]},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top})}var an=(this._width-this._gridPadding.left-this._gridPadding.right)/2+this._gridPadding.left-al.yMidAxis.getWidth()/2;al.yMidAxis.pack({position:"absolute",top:0,left:an,zIndex:9,textAlign:"center"},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top});this.target.append(this.grid.createElement(this._gridPadding,this));this.grid.draw();var ak=this.series;var aD=ak.length;for(aB=0,ay=aD;aB<ay;aB++){az=this.seriesStack[aB];this.target.append(ak[az].shadowCanvas.createElement(this._gridPadding,"jqplot-series-shadowCanvas",null,this));ak[az].shadowCanvas.setContext();ak[az].shadowCanvas._elem.data("seriesIndex",az)}for(aB=0,ay=aD;aB<ay;aB++){az=this.seriesStack[aB];this.target.append(ak[az].canvas.createElement(this._gridPadding,"jqplot-series-canvas",null,this));ak[az].canvas.setContext();ak[az].canvas._elem.data("seriesIndex",az)}this.target.append(this.eventCanvas.createElement(this._gridPadding,"jqplot-event-canvas",null,this));this.eventCanvas.setContext();this.eventCanvas._ctx.fillStyle="rgba(0,0,0,0)";this.eventCanvas._ctx.fillRect(0,0,this.eventCanvas._ctx.canvas.width,this.eventCanvas._ctx.canvas.height);this.bindCustomEvents();if(this.legend.preDraw){this.eventCanvas._elem.before(aF);this.legend.pack(at);if(this.legend._elem){this.drawSeries({legendInfo:{location:this.legend.location,placement:this.legend.placement,width:this.legend.getWidth(),height:this.legend.getHeight(),xoffset:this.legend.xoffset,yoffset:this.legend.yoffset}})}else{this.drawSeries()}}else{this.drawSeries();if(aD){H(ak[aD-1].canvas._elem).after(aF)}this.legend.pack(at)}for(var aB=0,ay=H.jqplot.eventListenerHooks.length;aB<ay;aB++){this.eventCanvas._elem.bind(H.jqplot.eventListenerHooks[aB][0],{plot:this},H.jqplot.eventListenerHooks[aB][1])}for(var aB=0,ay=this.eventListenerHooks.hooks.length;aB<ay;aB++){this.eventCanvas._elem.bind(this.eventListenerHooks.hooks[aB][0],{plot:this},this.eventListenerHooks.hooks[aB][1])}var aq=this.fillBetween;if(aq.fill&&aq.series1!==aq.series2&&aq.series1<aD&&aq.series2<aD&&ak[aq.series1]._type==="line"&&ak[aq.series2]._type==="line"){this.doFillBetweenLines()}for(var aB=0,ay=H.jqplot.postDrawHooks.length;aB<ay;aB++){H.jqplot.postDrawHooks[aB].call(this)}for(var aB=0,ay=this.postDrawHooks.hooks.length;aB<ay;aB++){this.postDrawHooks.hooks[aB].apply(this,this.postDrawHooks.args[aB])}if(this.target.is(":visible")){this._drawCount+=1}var ao,ap,aw,aj;for(aB=0,ay=aD;aB<ay;aB++){ao=ak[aB];ap=ao.renderer;aw=".jqplot-point-label.jqplot-series-"+aB;if(ap.animation&&ap.animation._supported&&ap.animation.show&&(this._drawCount<2||this.animateReplot)){aj=this.target.find(aw);aj.stop(true,true).hide();ao.canvas._elem.stop(true,true).hide();ao.shadowCanvas._elem.stop(true,true).hide();ao.canvas._elem.jqplotEffect("blind",{mode:"show",direction:ap.animation.direction},ap.animation.speed);ao.shadowCanvas._elem.jqplotEffect("blind",{mode:"show",direction:ap.animation.direction},ap.animation.speed);aj.fadeIn(ap.animation.speed*0.8)}}aj=null;this.target.trigger("jqplotPostDraw",[this])}};N.prototype.doFillBetweenLines=function(){var ah=this.fillBetween;var aq=ah.series1;var ao=ah.series2;var ap=(aq<ao)?aq:ao;var an=(ao>aq)?ao:aq;var al=this.series[ap];var ak=this.series[an];if(ak.renderer.smooth){var aj=ak.renderer._smoothedData.slice(0).reverse()}else{var aj=ak.gridData.slice(0).reverse()}if(al.renderer.smooth){var am=al.renderer._smoothedData.concat(aj)}else{var am=al.gridData.concat(aj)}var ai=(ah.color!==null)?ah.color:this.series[aq].fillColor;var ar=(ah.baseSeries!==null)?ah.baseSeries:ap;var ag=this.series[ar].renderer.shapeRenderer;var af={fillStyle:ai,fill:true,closePath:true};ag.draw(al.shadowCanvas._ctx,am,af)};this.bindCustomEvents=function(){this.eventCanvas._elem.bind("click",{plot:this},this.onClick);this.eventCanvas._elem.bind("dblclick",{plot:this},this.onDblClick);this.eventCanvas._elem.bind("mousedown",{plot:this},this.onMouseDown);this.eventCanvas._elem.bind("mousemove",{plot:this},this.onMouseMove);this.eventCanvas._elem.bind("mouseenter",{plot:this},this.onMouseEnter);this.eventCanvas._elem.bind("mouseleave",{plot:this},this.onMouseLeave);if(this.captureRightClick){this.eventCanvas._elem.bind("mouseup",{plot:this},this.onRightClick);this.eventCanvas._elem.get(0).oncontextmenu=function(){return false}}else{this.eventCanvas._elem.bind("mouseup",{plot:this},this.onMouseUp)}};function ac(ao){var am=ao.data.plot;var ai=am.eventCanvas._elem.offset();var al={x:ao.pageX-ai.left,y:ao.pageY-ai.top};var aj={xaxis:null,yaxis:null,x2axis:null,y2axis:null,y3axis:null,y4axis:null,y5axis:null,y6axis:null,y7axis:null,y8axis:null,y9axis:null,yMidAxis:null};var ak=["xaxis","yaxis","x2axis","y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis","yMidAxis"];var af=am.axes;var ag,ah;for(ag=11;ag>0;ag--){ah=ak[ag-1];if(af[ah].show){aj[ah]=af[ah].series_p2u(al[ah.charAt(0)])}}return{offsets:ai,gridPos:al,dataPos:aj}}function ae(af,ag){var ak=ag.series;var aQ,aO,aN,aI,aJ,aD,aC,ap,an,at,au,aE;var aM,aR,aK,al,aB,aG,aP;var ah,aH;for(aN=ag.seriesStack.length-1;aN>=0;aN--){aQ=ag.seriesStack[aN];aI=ak[aQ];aP=aI._highlightThreshold;switch(aI.renderer.constructor){case H.jqplot.BarRenderer:aD=af.x;aC=af.y;for(aO=0;aO<aI._barPoints.length;aO++){aB=aI._barPoints[aO];aK=aI.gridData[aO];if(aD>aB[0][0]&&aD<aB[2][0]&&aC>aB[2][1]&&aC<aB[0][1]){return{seriesIndex:aI.index,pointIndex:aO,gridData:aK,data:aI.data[aO],points:aI._barPoints[aO]}}}break;case H.jqplot.PyramidRenderer:aD=af.x;aC=af.y;for(aO=0;aO<aI._barPoints.length;aO++){aB=aI._barPoints[aO];aK=aI.gridData[aO];if(aD>aB[0][0]+aP[0][0]&&aD<aB[2][0]+aP[2][0]&&aC>aB[2][1]&&aC<aB[0][1]){return{seriesIndex:aI.index,pointIndex:aO,gridData:aK,data:aI.data[aO],points:aI._barPoints[aO]}}}break;case H.jqplot.DonutRenderer:at=aI.startAngle/180*Math.PI;aD=af.x-aI._center[0];aC=af.y-aI._center[1];aJ=Math.sqrt(Math.pow(aD,2)+Math.pow(aC,2));if(aD>0&&-aC>=0){ap=2*Math.PI-Math.atan(-aC/aD)}else{if(aD>0&&-aC<0){ap=-Math.atan(-aC/aD)}else{if(aD<0){ap=Math.PI-Math.atan(-aC/aD)}else{if(aD==0&&-aC>0){ap=3*Math.PI/2}else{if(aD==0&&-aC<0){ap=Math.PI/2}else{if(aD==0&&aC==0){ap=0}}}}}}if(at){ap-=at;if(ap<0){ap+=2*Math.PI}else{if(ap>2*Math.PI){ap-=2*Math.PI}}}an=aI.sliceMargin/180*Math.PI;if(aJ<aI._radius&&aJ>aI._innerRadius){for(aO=0;aO<aI.gridData.length;aO++){au=(aO>0)?aI.gridData[aO-1][1]+an:an;aE=aI.gridData[aO][1];if(ap>au&&ap<aE){return{seriesIndex:aI.index,pointIndex:aO,gridData:aI.gridData[aO],data:aI.data[aO]}}}}break;case H.jqplot.PieRenderer:at=aI.startAngle/180*Math.PI;aD=af.x-aI._center[0];aC=af.y-aI._center[1];aJ=Math.sqrt(Math.pow(aD,2)+Math.pow(aC,2));if(aD>0&&-aC>=0){ap=2*Math.PI-Math.atan(-aC/aD)}else{if(aD>0&&-aC<0){ap=-Math.atan(-aC/aD)}else{if(aD<0){ap=Math.PI-Math.atan(-aC/aD)}else{if(aD==0&&-aC>0){ap=3*Math.PI/2}else{if(aD==0&&-aC<0){ap=Math.PI/2}else{if(aD==0&&aC==0){ap=0}}}}}}if(at){ap-=at;if(ap<0){ap+=2*Math.PI}else{if(ap>2*Math.PI){ap-=2*Math.PI}}}an=aI.sliceMargin/180*Math.PI;if(aJ<aI._radius){for(aO=0;aO<aI.gridData.length;aO++){au=(aO>0)?aI.gridData[aO-1][1]+an:an;aE=aI.gridData[aO][1];if(ap>au&&ap<aE){return{seriesIndex:aI.index,pointIndex:aO,gridData:aI.gridData[aO],data:aI.data[aO]}}}}break;case H.jqplot.BubbleRenderer:aD=af.x;aC=af.y;var az=null;if(aI.show){for(var aO=0;aO<aI.gridData.length;aO++){aK=aI.gridData[aO];aR=Math.sqrt((aD-aK[0])*(aD-aK[0])+(aC-aK[1])*(aC-aK[1]));if(aR<=aK[2]&&(aR<=aM||aM==null)){aM=aR;az={seriesIndex:aQ,pointIndex:aO,gridData:aK,data:aI.data[aO]}}}if(az!=null){return az}}break;case H.jqplot.FunnelRenderer:aD=af.x;aC=af.y;var aF=aI._vertices,aj=aF[0],ai=aF[aF.length-1],am,ay,ar;function aL(aU,aW,aV){var aT=(aW[1]-aV[1])/(aW[0]-aV[0]);var aS=aW[1]-aT*aW[0];var aX=aU+aW[1];return[(aX-aS)/aT,aX]}am=aL(aC,aj[0],ai[3]);ay=aL(aC,aj[1],ai[2]);for(aO=0;aO<aF.length;aO++){ar=aF[aO];if(aC>=ar[0][1]&&aC<=ar[3][1]&&aD>=am[0]&&aD<=ay[0]){return{seriesIndex:aI.index,pointIndex:aO,gridData:null,data:aI.data[aO]}}}break;case H.jqplot.LineRenderer:aD=af.x;aC=af.y;aJ=aI.renderer;if(aI.show){if((aI.fill||(aI.renderer.bands.show&&aI.renderer.bands.fill))&&(!ag.plugins.highlighter||!ag.plugins.highlighter.show)){var aq=false;if(aD>aI._boundingBox[0][0]&&aD<aI._boundingBox[1][0]&&aC>aI._boundingBox[1][1]&&aC<aI._boundingBox[0][1]){var ax=aI._areaPoints.length;var aA;var aO=ax-1;for(var aA=0;aA<ax;aA++){var aw=[aI._areaPoints[aA][0],aI._areaPoints[aA][1]];var av=[aI._areaPoints[aO][0],aI._areaPoints[aO][1]];if(aw[1]<aC&&av[1]>=aC||av[1]<aC&&aw[1]>=aC){if(aw[0]+(aC-aw[1])/(av[1]-aw[1])*(av[0]-aw[0])<aD){aq=!aq}}aO=aA}}if(aq){return{seriesIndex:aQ,pointIndex:null,gridData:aI.gridData,data:aI.data,points:aI._areaPoints}}break}else{aH=aI.markerRenderer.size/2+aI.neighborThreshold;ah=(aH>0)?aH:0;for(var aO=0;aO<aI.gridData.length;aO++){aK=aI.gridData[aO];if(aJ.constructor==H.jqplot.OHLCRenderer){if(aJ.candleStick){var ao=aI._yaxis.series_u2p;if(aD>=aK[0]-aJ._bodyWidth/2&&aD<=aK[0]+aJ._bodyWidth/2&&aC>=ao(aI.data[aO][2])&&aC<=ao(aI.data[aO][3])){return{seriesIndex:aQ,pointIndex:aO,gridData:aK,data:aI.data[aO]}}}else{if(!aJ.hlc){var ao=aI._yaxis.series_u2p;if(aD>=aK[0]-aJ._tickLength&&aD<=aK[0]+aJ._tickLength&&aC>=ao(aI.data[aO][2])&&aC<=ao(aI.data[aO][3])){return{seriesIndex:aQ,pointIndex:aO,gridData:aK,data:aI.data[aO]}}}else{var ao=aI._yaxis.series_u2p;if(aD>=aK[0]-aJ._tickLength&&aD<=aK[0]+aJ._tickLength&&aC>=ao(aI.data[aO][1])&&aC<=ao(aI.data[aO][2])){return{seriesIndex:aQ,pointIndex:aO,gridData:aK,data:aI.data[aO]}}}}}else{if(aK[0]!=null&&aK[1]!=null){aR=Math.sqrt((aD-aK[0])*(aD-aK[0])+(aC-aK[1])*(aC-aK[1]));if(aR<=ah&&(aR<=aM||aM==null)){aM=aR;return{seriesIndex:aQ,pointIndex:aO,gridData:aK,data:aI.data[aO]}}}}}}}break;default:aD=af.x;aC=af.y;aJ=aI.renderer;if(aI.show){aH=aI.markerRenderer.size/2+aI.neighborThreshold;ah=(aH>0)?aH:0;for(var aO=0;aO<aI.gridData.length;aO++){aK=aI.gridData[aO];if(aJ.constructor==H.jqplot.OHLCRenderer){if(aJ.candleStick){var ao=aI._yaxis.series_u2p;if(aD>=aK[0]-aJ._bodyWidth/2&&aD<=aK[0]+aJ._bodyWidth/2&&aC>=ao(aI.data[aO][2])&&aC<=ao(aI.data[aO][3])){return{seriesIndex:aQ,pointIndex:aO,gridData:aK,data:aI.data[aO]}}}else{if(!aJ.hlc){var ao=aI._yaxis.series_u2p;if(aD>=aK[0]-aJ._tickLength&&aD<=aK[0]+aJ._tickLength&&aC>=ao(aI.data[aO][2])&&aC<=ao(aI.data[aO][3])){return{seriesIndex:aQ,pointIndex:aO,gridData:aK,data:aI.data[aO]}}}else{var ao=aI._yaxis.series_u2p;if(aD>=aK[0]-aJ._tickLength&&aD<=aK[0]+aJ._tickLength&&aC>=ao(aI.data[aO][1])&&aC<=ao(aI.data[aO][2])){return{seriesIndex:aQ,pointIndex:aO,gridData:aK,data:aI.data[aO]}}}}}else{aR=Math.sqrt((aD-aK[0])*(aD-aK[0])+(aC-aK[1])*(aC-aK[1]));if(aR<=ah&&(aR<=aM||aM==null)){aM=aR;return{seriesIndex:aQ,pointIndex:aO,gridData:aK,data:aI.data[aO]}}}}}break}}return null}this.onClick=function(ah){var ag=ac(ah);var aj=ah.data.plot;var ai=ae(ag.gridPos,aj);var af=H.Event("jqplotClick");af.pageX=ah.pageX;af.pageY=ah.pageY;H(this).trigger(af,[ag.gridPos,ag.dataPos,ai,aj])};this.onDblClick=function(ah){var ag=ac(ah);var aj=ah.data.plot;var ai=ae(ag.gridPos,aj);var af=H.Event("jqplotDblClick");af.pageX=ah.pageX;af.pageY=ah.pageY;H(this).trigger(af,[ag.gridPos,ag.dataPos,ai,aj])};this.onMouseDown=function(ah){var ag=ac(ah);var aj=ah.data.plot;var ai=ae(ag.gridPos,aj);var af=H.Event("jqplotMouseDown");af.pageX=ah.pageX;af.pageY=ah.pageY;H(this).trigger(af,[ag.gridPos,ag.dataPos,ai,aj])};this.onMouseUp=function(ah){var ag=ac(ah);var af=H.Event("jqplotMouseUp");af.pageX=ah.pageX;af.pageY=ah.pageY;H(this).trigger(af,[ag.gridPos,ag.dataPos,null,ah.data.plot])};this.onRightClick=function(ah){var ag=ac(ah);var aj=ah.data.plot;var ai=ae(ag.gridPos,aj);if(aj.captureRightClick){if(ah.which==3){var af=H.Event("jqplotRightClick");af.pageX=ah.pageX;af.pageY=ah.pageY;H(this).trigger(af,[ag.gridPos,ag.dataPos,ai,aj])}else{var af=H.Event("jqplotMouseUp");af.pageX=ah.pageX;af.pageY=ah.pageY;H(this).trigger(af,[ag.gridPos,ag.dataPos,ai,aj])}}};this.onMouseMove=function(ah){var ag=ac(ah);var aj=ah.data.plot;var ai=ae(ag.gridPos,aj);var af=H.Event("jqplotMouseMove");af.pageX=ah.pageX;af.pageY=ah.pageY;H(this).trigger(af,[ag.gridPos,ag.dataPos,ai,aj])};this.onMouseEnter=function(ah){var ag=ac(ah);var ai=ah.data.plot;var af=H.Event("jqplotMouseEnter");af.pageX=ah.pageX;af.pageY=ah.pageY;af.relatedTarget=ah.relatedTarget;H(this).trigger(af,[ag.gridPos,ag.dataPos,null,ai])};this.onMouseLeave=function(ah){var ag=ac(ah);var ai=ah.data.plot;var af=H.Event("jqplotMouseLeave");af.pageX=ah.pageX;af.pageY=ah.pageY;af.relatedTarget=ah.relatedTarget;H(this).trigger(af,[ag.gridPos,ag.dataPos,null,ai])};this.drawSeries=function(ah,af){var aj,ai,ag;af=(typeof(ah)==="number"&&af==null)?ah:af;ah=(typeof(ah)==="object")?ah:{};if(af!=r){ai=this.series[af];ag=ai.shadowCanvas._ctx;ag.clearRect(0,0,ag.canvas.width,ag.canvas.height);ai.drawShadow(ag,ah,this);ag=ai.canvas._ctx;ag.clearRect(0,0,ag.canvas.width,ag.canvas.height);ai.draw(ag,ah,this);if(ai.renderer.constructor==H.jqplot.BezierCurveRenderer){if(af<this.series.length-1){this.drawSeries(af+1)}}}else{for(aj=0;aj<this.series.length;aj++){ai=this.series[aj];ag=ai.shadowCanvas._ctx;ag.clearRect(0,0,ag.canvas.width,ag.canvas.height);ai.drawShadow(ag,ah,this);ag=ai.canvas._ctx;ag.clearRect(0,0,ag.canvas.width,ag.canvas.height);ai.draw(ag,ah,this)}}ah=af=aj=ai=ag=null};this.moveSeriesToFront=function(ag){ag=parseInt(ag,10);var aj=H.inArray(ag,this.seriesStack);if(aj==-1){return}if(aj==this.seriesStack.length-1){this.previousSeriesStack=this.seriesStack.slice(0);return}var af=this.seriesStack[this.seriesStack.length-1];var ai=this.series[ag].canvas._elem.detach();var ah=this.series[ag].shadowCanvas._elem.detach();this.series[af].shadowCanvas._elem.after(ah);this.series[af].canvas._elem.after(ai);this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack.splice(aj,1);this.seriesStack.push(ag)};this.moveSeriesToBack=function(ag){ag=parseInt(ag,10);var aj=H.inArray(ag,this.seriesStack);if(aj==0||aj==-1){return}var af=this.seriesStack[0];var ai=this.series[ag].canvas._elem.detach();var ah=this.series[ag].shadowCanvas._elem.detach();this.series[af].shadowCanvas._elem.before(ah);this.series[af].canvas._elem.before(ai);this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack.splice(aj,1);this.seriesStack.unshift(ag)};this.restorePreviousSeriesOrder=function(){var al,ak,aj,ai,ah,af,ag;if(this.seriesStack==this.previousSeriesStack){return}for(al=1;al<this.previousSeriesStack.length;al++){af=this.previousSeriesStack[al];ag=this.previousSeriesStack[al-1];aj=this.series[af].canvas._elem.detach();ai=this.series[af].shadowCanvas._elem.detach();this.series[ag].shadowCanvas._elem.after(ai);this.series[ag].canvas._elem.after(aj)}ah=this.seriesStack.slice(0);this.seriesStack=this.previousSeriesStack.slice(0);this.previousSeriesStack=ah};this.restoreOriginalSeriesOrder=function(){var aj,ai,af=[],ah,ag;for(aj=0;aj<this.series.length;aj++){af.push(aj)}if(this.seriesStack==af){return}this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack=af;for(aj=1;aj<this.seriesStack.length;aj++){ah=this.series[aj].canvas._elem.detach();ag=this.series[aj].shadowCanvas._elem.detach();this.series[aj-1].shadowCanvas._elem.after(ag);this.series[aj-1].canvas._elem.after(ah)}};this.activateTheme=function(af){this.themeEngine.activate(this,af)}}H.jqplot.computeHighlightColors=function(ac){var ae;if(H.isArray(ac)){ae=[];for(var ag=0;ag<ac.length;ag++){var af=H.jqplot.getColorComponents(ac[ag]);var ab=[af[0],af[1],af[2]];var ah=ab[0]+ab[1]+ab[2];for(var ad=0;ad<3;ad++){ab[ad]=(ah>660)?ab[ad]*0.85:0.73*ab[ad]+90;ab[ad]=parseInt(ab[ad],10);(ab[ad]>255)?255:ab[ad]}ab[3]=0.3+0.35*af[3];ae.push("rgba("+ab[0]+","+ab[1]+","+ab[2]+","+ab[3]+")")}}else{var af=H.jqplot.getColorComponents(ac);var ab=[af[0],af[1],af[2]];var ah=ab[0]+ab[1]+ab[2];for(var ad=0;ad<3;ad++){ab[ad]=(ah>660)?ab[ad]*0.85:0.73*ab[ad]+90;ab[ad]=parseInt(ab[ad],10);(ab[ad]>255)?255:ab[ad]}ab[3]=0.3+0.35*af[3];ae="rgba("+ab[0]+","+ab[1]+","+ab[2]+","+ab[3]+")"}return ae};H.jqplot.ColorGenerator=function(ac){ac=ac||H.jqplot.config.defaultColors;var ab=0;this.next=function(){if(ab<ac.length){return ac[ab++]}else{ab=0;return ac[ab++]}};this.previous=function(){if(ab>0){return ac[ab--]}else{ab=ac.length-1;return ac[ab]}};this.get=function(ae){var ad=ae-ac.length*Math.floor(ae/ac.length);return ac[ad]};this.setColors=function(ad){ac=ad};this.reset=function(){ab=0};this.getIndex=function(){return ab};this.setIndex=function(ad){ab=ad}};H.jqplot.hex2rgb=function(ad,ab){ad=ad.replace("#","");if(ad.length==3){ad=ad.charAt(0)+ad.charAt(0)+ad.charAt(1)+ad.charAt(1)+ad.charAt(2)+ad.charAt(2)}var ac;ac="rgba("+parseInt(ad.slice(0,2),16)+", "+parseInt(ad.slice(2,4),16)+", "+parseInt(ad.slice(4,6),16);if(ab){ac+=", "+ab}ac+=")";return ac};H.jqplot.rgb2hex=function(ag){var ad=/rgba?\( *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *(?:, *[0-9.]*)?\)/;var ab=ag.match(ad);var af="#";for(var ae=1;ae<4;ae++){var ac;if(ab[ae].search(/%/)!=-1){ac=parseInt(255*ab[ae]/100,10).toString(16);if(ac.length==1){ac="0"+ac}}else{ac=parseInt(ab[ae],10).toString(16);if(ac.length==1){ac="0"+ac}}af+=ac}return af};H.jqplot.normalize2rgb=function(ac,ab){if(ac.search(/^ *rgba?\(/)!=-1){return ac}else{if(ac.search(/^ *#?[0-9a-fA-F]?[0-9a-fA-F]/)!=-1){return H.jqplot.hex2rgb(ac,ab)}else{throw"invalid color spec"}}};H.jqplot.getColorComponents=function(ag){ag=H.jqplot.colorKeywordMap[ag]||ag;var ae=H.jqplot.normalize2rgb(ag);var ad=/rgba?\( *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *,? *([0-9.]* *)?\)/;var ab=ae.match(ad);var ac=[];for(var af=1;af<4;af++){if(ab[af].search(/%/)!=-1){ac[af-1]=parseInt(255*ab[af]/100,10)}else{ac[af-1]=parseInt(ab[af],10)}}ac[3]=parseFloat(ab[4])?parseFloat(ab[4]):1;return ac};H.jqplot.colorKeywordMap={aliceblue:"rgb(240, 248, 255)",antiquewhite:"rgb(250, 235, 215)",aqua:"rgb( 0, 255, 255)",aquamarine:"rgb(127, 255, 212)",azure:"rgb(240, 255, 255)",beige:"rgb(245, 245, 220)",bisque:"rgb(255, 228, 196)",black:"rgb( 0, 0, 0)",blanchedalmond:"rgb(255, 235, 205)",blue:"rgb( 0, 0, 255)",blueviolet:"rgb(138, 43, 226)",brown:"rgb(165, 42, 42)",burlywood:"rgb(222, 184, 135)",cadetblue:"rgb( 95, 158, 160)",chartreuse:"rgb(127, 255, 0)",chocolate:"rgb(210, 105, 30)",coral:"rgb(255, 127, 80)",cornflowerblue:"rgb(100, 149, 237)",cornsilk:"rgb(255, 248, 220)",crimson:"rgb(220, 20, 60)",cyan:"rgb( 0, 255, 255)",darkblue:"rgb( 0, 0, 139)",darkcyan:"rgb( 0, 139, 139)",darkgoldenrod:"rgb(184, 134, 11)",darkgray:"rgb(169, 169, 169)",darkgreen:"rgb( 0, 100, 0)",darkgrey:"rgb(169, 169, 169)",darkkhaki:"rgb(189, 183, 107)",darkmagenta:"rgb(139, 0, 139)",darkolivegreen:"rgb( 85, 107, 47)",darkorange:"rgb(255, 140, 0)",darkorchid:"rgb(153, 50, 204)",darkred:"rgb(139, 0, 0)",darksalmon:"rgb(233, 150, 122)",darkseagreen:"rgb(143, 188, 143)",darkslateblue:"rgb( 72, 61, 139)",darkslategray:"rgb( 47, 79, 79)",darkslategrey:"rgb( 47, 79, 79)",darkturquoise:"rgb( 0, 206, 209)",darkviolet:"rgb(148, 0, 211)",deeppink:"rgb(255, 20, 147)",deepskyblue:"rgb( 0, 191, 255)",dimgray:"rgb(105, 105, 105)",dimgrey:"rgb(105, 105, 105)",dodgerblue:"rgb( 30, 144, 255)",firebrick:"rgb(178, 34, 34)",floralwhite:"rgb(255, 250, 240)",forestgreen:"rgb( 34, 139, 34)",fuchsia:"rgb(255, 0, 255)",gainsboro:"rgb(220, 220, 220)",ghostwhite:"rgb(248, 248, 255)",gold:"rgb(255, 215, 0)",goldenrod:"rgb(218, 165, 32)",gray:"rgb(128, 128, 128)",grey:"rgb(128, 128, 128)",green:"rgb( 0, 128, 0)",greenyellow:"rgb(173, 255, 47)",honeydew:"rgb(240, 255, 240)",hotpink:"rgb(255, 105, 180)",indianred:"rgb(205, 92, 92)",indigo:"rgb( 75, 0, 130)",ivory:"rgb(255, 255, 240)",khaki:"rgb(240, 230, 140)",lavender:"rgb(230, 230, 250)",lavenderblush:"rgb(255, 240, 245)",lawngreen:"rgb(124, 252, 0)",lemonchiffon:"rgb(255, 250, 205)",lightblue:"rgb(173, 216, 230)",lightcoral:"rgb(240, 128, 128)",lightcyan:"rgb(224, 255, 255)",lightgoldenrodyellow:"rgb(250, 250, 210)",lightgray:"rgb(211, 211, 211)",lightgreen:"rgb(144, 238, 144)",lightgrey:"rgb(211, 211, 211)",lightpink:"rgb(255, 182, 193)",lightsalmon:"rgb(255, 160, 122)",lightseagreen:"rgb( 32, 178, 170)",lightskyblue:"rgb(135, 206, 250)",lightslategray:"rgb(119, 136, 153)",lightslategrey:"rgb(119, 136, 153)",lightsteelblue:"rgb(176, 196, 222)",lightyellow:"rgb(255, 255, 224)",lime:"rgb( 0, 255, 0)",limegreen:"rgb( 50, 205, 50)",linen:"rgb(250, 240, 230)",magenta:"rgb(255, 0, 255)",maroon:"rgb(128, 0, 0)",mediumaquamarine:"rgb(102, 205, 170)",mediumblue:"rgb( 0, 0, 205)",mediumorchid:"rgb(186, 85, 211)",mediumpurple:"rgb(147, 112, 219)",mediumseagreen:"rgb( 60, 179, 113)",mediumslateblue:"rgb(123, 104, 238)",mediumspringgreen:"rgb( 0, 250, 154)",mediumturquoise:"rgb( 72, 209, 204)",mediumvioletred:"rgb(199, 21, 133)",midnightblue:"rgb( 25, 25, 112)",mintcream:"rgb(245, 255, 250)",mistyrose:"rgb(255, 228, 225)",moccasin:"rgb(255, 228, 181)",navajowhite:"rgb(255, 222, 173)",navy:"rgb( 0, 0, 128)",oldlace:"rgb(253, 245, 230)",olive:"rgb(128, 128, 0)",olivedrab:"rgb(107, 142, 35)",orange:"rgb(255, 165, 0)",orangered:"rgb(255, 69, 0)",orchid:"rgb(218, 112, 214)",palegoldenrod:"rgb(238, 232, 170)",palegreen:"rgb(152, 251, 152)",paleturquoise:"rgb(175, 238, 238)",palevioletred:"rgb(219, 112, 147)",papayawhip:"rgb(255, 239, 213)",peachpuff:"rgb(255, 218, 185)",peru:"rgb(205, 133, 63)",pink:"rgb(255, 192, 203)",plum:"rgb(221, 160, 221)",powderblue:"rgb(176, 224, 230)",purple:"rgb(128, 0, 128)",red:"rgb(255, 0, 0)",rosybrown:"rgb(188, 143, 143)",royalblue:"rgb( 65, 105, 225)",saddlebrown:"rgb(139, 69, 19)",salmon:"rgb(250, 128, 114)",sandybrown:"rgb(244, 164, 96)",seagreen:"rgb( 46, 139, 87)",seashell:"rgb(255, 245, 238)",sienna:"rgb(160, 82, 45)",silver:"rgb(192, 192, 192)",skyblue:"rgb(135, 206, 235)",slateblue:"rgb(106, 90, 205)",slategray:"rgb(112, 128, 144)",slategrey:"rgb(112, 128, 144)",snow:"rgb(255, 250, 250)",springgreen:"rgb( 0, 255, 127)",steelblue:"rgb( 70, 130, 180)",tan:"rgb(210, 180, 140)",teal:"rgb( 0, 128, 128)",thistle:"rgb(216, 191, 216)",tomato:"rgb(255, 99, 71)",turquoise:"rgb( 64, 224, 208)",violet:"rgb(238, 130, 238)",wheat:"rgb(245, 222, 179)",white:"rgb(255, 255, 255)",whitesmoke:"rgb(245, 245, 245)",yellow:"rgb(255, 255, 0)",yellowgreen:"rgb(154, 205, 50)"};H.jqplot.AxisLabelRenderer=function(ab){H.jqplot.ElemContainer.call(this);this.axis;this.show=true;this.label="";this.fontFamily=null;this.fontSize=null;this.textColor=null;this._elem;this.escapeHTML=false;H.extend(true,this,ab)};H.jqplot.AxisLabelRenderer.prototype=new H.jqplot.ElemContainer();H.jqplot.AxisLabelRenderer.prototype.constructor=H.jqplot.AxisLabelRenderer;H.jqplot.AxisLabelRenderer.prototype.init=function(ab){H.extend(true,this,ab)};H.jqplot.AxisLabelRenderer.prototype.draw=function(ab,ac){if(this._elem){this._elem.emptyForce();this._elem=null}this._elem=H('<div style="position:absolute;" class="jqplot-'+this.axis+'-label"></div>');if(Number(this.label)){this._elem.css("white-space","nowrap")}if(!this.escapeHTML){this._elem.html(this.label)}else{this._elem.text(this.label)}if(this.fontFamily){this._elem.css("font-family",this.fontFamily)}if(this.fontSize){this._elem.css("font-size",this.fontSize)}if(this.textColor){this._elem.css("color",this.textColor)}return this._elem};H.jqplot.AxisLabelRenderer.prototype.pack=function(){};H.jqplot.AxisTickRenderer=function(ab){H.jqplot.ElemContainer.call(this);this.mark="outside";this.axis;this.showMark=true;this.showGridline=true;this.isMinorTick=false;this.size=4;this.markSize=6;this.show=true;this.showLabel=true;this.label=null;this.value=null;this._styles={};this.formatter=H.jqplot.DefaultTickFormatter;this.prefix="";this.suffix="";this.formatString="";this.fontFamily;this.fontSize;this.textColor;this.escapeHTML=false;this._elem;this._breakTick=false;H.extend(true,this,ab)};H.jqplot.AxisTickRenderer.prototype.init=function(ab){H.extend(true,this,ab)};H.jqplot.AxisTickRenderer.prototype=new H.jqplot.ElemContainer();H.jqplot.AxisTickRenderer.prototype.constructor=H.jqplot.AxisTickRenderer;H.jqplot.AxisTickRenderer.prototype.setTick=function(ab,ad,ac){this.value=ab;this.axis=ad;if(ac){this.isMinorTick=true}return this};H.jqplot.AxisTickRenderer.prototype.draw=function(){if(this.label===null){this.label=this.prefix+this.formatter(this.formatString,this.value)+this.suffix}var ac={position:"absolute"};if(Number(this.label)){ac.whitSpace="nowrap"}if(this._elem){this._elem.emptyForce();this._elem=null}this._elem=H(document.createElement("div"));this._elem.addClass("jqplot-"+this.axis+"-tick");if(!this.escapeHTML){this._elem.html(this.label)}else{this._elem.text(this.label)}this._elem.css(ac);for(var ab in this._styles){this._elem.css(ab,this._styles[ab])}if(this.fontFamily){this._elem.css("font-family",this.fontFamily)}if(this.fontSize){this._elem.css("font-size",this.fontSize)}if(this.textColor){this._elem.css("color",this.textColor)}if(this._breakTick){this._elem.addClass("jqplot-breakTick")}return this._elem};H.jqplot.DefaultTickFormatter=function(ab,ac){if(typeof ac=="number"){if(!ab){ab=H.jqplot.config.defaultTickFormatString}return H.jqplot.sprintf(ab,ac)}else{return String(ac)}};H.jqplot.PercentTickFormatter=function(ab,ac){if(typeof ac=="number"){ac=100*ac;if(!ab){ab=H.jqplot.config.defaultTickFormatString}return H.jqplot.sprintf(ab,ac)}else{return String(ac)}};H.jqplot.AxisTickRenderer.prototype.pack=function(){};H.jqplot.CanvasGridRenderer=function(){this.shadowRenderer=new H.jqplot.ShadowRenderer()};H.jqplot.CanvasGridRenderer.prototype.init=function(ac){this._ctx;H.extend(true,this,ac);var ab={lineJoin:"miter",lineCap:"round",fill:false,isarc:false,angle:this.shadowAngle,offset:this.shadowOffset,alpha:this.shadowAlpha,depth:this.shadowDepth,lineWidth:this.shadowWidth,closePath:false,strokeStyle:this.shadowColor};this.renderer.shadowRenderer.init(ab)};H.jqplot.CanvasGridRenderer.prototype.createElement=function(ae){var ad;if(this._elem){if(H.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==r){ad=this._elem.get(0);window.G_vmlCanvasManager.uninitElement(ad);ad=null}this._elem.emptyForce();this._elem=null}ad=ae.canvasManager.getCanvas();var ab=this._plotDimensions.width;var ac=this._plotDimensions.height;ad.width=ab;ad.height=ac;this._elem=H(ad);this._elem.addClass("jqplot-grid-canvas");this._elem.css({position:"absolute",left:0,top:0});ad=ae.canvasManager.initCanvas(ad);this._top=this._offsets.top;this._bottom=ac-this._offsets.bottom;this._left=this._offsets.left;this._right=ab-this._offsets.right;this._width=this._right-this._left;this._height=this._bottom-this._top;ad=null;return this._elem};H.jqplot.CanvasGridRenderer.prototype.draw=function(){this._ctx=this._elem.get(0).getContext("2d");var am=this._ctx;var ap=this._axes;am.save();am.clearRect(0,0,this._plotDimensions.width,this._plotDimensions.height);am.fillStyle=this.backgroundColor||this.background;am.fillRect(this._left,this._top,this._width,this._height);am.save();am.lineJoin="miter";am.lineCap="butt";am.lineWidth=this.gridLineWidth;am.strokeStyle=this.gridLineColor;var at,ar,aj,ak;var ag=["xaxis","yaxis","x2axis","y2axis"];for(var aq=4;aq>0;aq--){var aw=ag[aq-1];var ab=ap[aw];var au=ab._ticks;var al=au.length;if(ab.show){if(ab.drawBaseline){var av={};if(ab.baselineWidth!==null){av.lineWidth=ab.baselineWidth}if(ab.baselineColor!==null){av.strokeStyle=ab.baselineColor}switch(aw){case"xaxis":ai(this._left,this._bottom,this._right,this._bottom,av);break;case"yaxis":ai(this._left,this._bottom,this._left,this._top,av);break;case"x2axis":ai(this._left,this._bottom,this._right,this._bottom,av);break;case"y2axis":ai(this._right,this._bottom,this._right,this._top,av);break}}for(var an=al;an>0;an--){var ah=au[an-1];if(ah.show){var ae=Math.round(ab.u2p(ah.value))+0.5;switch(aw){case"xaxis":if(ah.showGridline&&this.drawGridlines&&((!ah.isMinorTick&&ab.drawMajorGridlines)||(ah.isMinorTick&&ab.drawMinorGridlines))){ai(ae,this._top,ae,this._bottom)}if(ah.showMark&&ah.mark&&((!ah.isMinorTick&&ab.drawMajorTickMarks)||(ah.isMinorTick&&ab.drawMinorTickMarks))){aj=ah.markSize;ak=ah.mark;var ae=Math.round(ab.u2p(ah.value))+0.5;switch(ak){case"outside":at=this._bottom;ar=this._bottom+aj;break;case"inside":at=this._bottom-aj;ar=this._bottom;break;case"cross":at=this._bottom-aj;ar=this._bottom+aj;break;default:at=this._bottom;ar=this._bottom+aj;break}if(this.shadow){this.renderer.shadowRenderer.draw(am,[[ae,at],[ae,ar]],{lineCap:"butt",lineWidth:this.gridLineWidth,offset:this.gridLineWidth*0.75,depth:2,fill:false,closePath:false})}ai(ae,at,ae,ar)}break;case"yaxis":if(ah.showGridline&&this.drawGridlines&&((!ah.isMinorTick&&ab.drawMajorGridlines)||(ah.isMinorTick&&ab.drawMinorGridlines))){ai(this._right,ae,this._left,ae)}if(ah.showMark&&ah.mark&&((!ah.isMinorTick&&ab.drawMajorTickMarks)||(ah.isMinorTick&&ab.drawMinorTickMarks))){aj=ah.markSize;ak=ah.mark;var ae=Math.round(ab.u2p(ah.value))+0.5;switch(ak){case"outside":at=this._left-aj;ar=this._left;break;case"inside":at=this._left;ar=this._left+aj;break;case"cross":at=this._left-aj;ar=this._left+aj;break;default:at=this._left-aj;ar=this._left;break}if(this.shadow){this.renderer.shadowRenderer.draw(am,[[at,ae],[ar,ae]],{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}ai(at,ae,ar,ae,{strokeStyle:ab.borderColor})}break;case"x2axis":if(ah.showGridline&&this.drawGridlines&&((!ah.isMinorTick&&ab.drawMajorGridlines)||(ah.isMinorTick&&ab.drawMinorGridlines))){ai(ae,this._bottom,ae,this._top)}if(ah.showMark&&ah.mark&&((!ah.isMinorTick&&ab.drawMajorTickMarks)||(ah.isMinorTick&&ab.drawMinorTickMarks))){aj=ah.markSize;ak=ah.mark;var ae=Math.round(ab.u2p(ah.value))+0.5;switch(ak){case"outside":at=this._top-aj;ar=this._top;break;case"inside":at=this._top;ar=this._top+aj;break;case"cross":at=this._top-aj;ar=this._top+aj;break;default:at=this._top-aj;ar=this._top;break}if(this.shadow){this.renderer.shadowRenderer.draw(am,[[ae,at],[ae,ar]],{lineCap:"butt",lineWidth:this.gridLineWidth,offset:this.gridLineWidth*0.75,depth:2,fill:false,closePath:false})}ai(ae,at,ae,ar)}break;case"y2axis":if(ah.showGridline&&this.drawGridlines&&((!ah.isMinorTick&&ab.drawMajorGridlines)||(ah.isMinorTick&&ab.drawMinorGridlines))){ai(this._left,ae,this._right,ae)}if(ah.showMark&&ah.mark&&((!ah.isMinorTick&&ab.drawMajorTickMarks)||(ah.isMinorTick&&ab.drawMinorTickMarks))){aj=ah.markSize;ak=ah.mark;var ae=Math.round(ab.u2p(ah.value))+0.5;switch(ak){case"outside":at=this._right;ar=this._right+aj;break;case"inside":at=this._right-aj;ar=this._right;break;case"cross":at=this._right-aj;ar=this._right+aj;break;default:at=this._right;ar=this._right+aj;break}if(this.shadow){this.renderer.shadowRenderer.draw(am,[[at,ae],[ar,ae]],{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}ai(at,ae,ar,ae,{strokeStyle:ab.borderColor})}break;default:break}}}ah=null}ab=null;au=null}ag=["y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis","yMidAxis"];for(var aq=7;aq>0;aq--){var ab=ap[ag[aq-1]];var au=ab._ticks;if(ab.show){var ac=au[ab.numberTicks-1];var af=au[0];var ad=ab.getLeft();var ao=[[ad,ac.getTop()+ac.getHeight()/2],[ad,af.getTop()+af.getHeight()/2+1]];if(this.shadow){this.renderer.shadowRenderer.draw(am,ao,{lineCap:"butt",fill:false,closePath:false})}ai(ao[0][0],ao[0][1],ao[1][0],ao[1][1],{lineCap:"butt",strokeStyle:ab.borderColor,lineWidth:ab.borderWidth});for(var an=au.length;an>0;an--){var ah=au[an-1];aj=ah.markSize;ak=ah.mark;var ae=Math.round(ab.u2p(ah.value))+0.5;if(ah.showMark&&ah.mark){switch(ak){case"outside":at=ad;ar=ad+aj;break;case"inside":at=ad-aj;ar=ad;break;case"cross":at=ad-aj;ar=ad+aj;break;default:at=ad;ar=ad+aj;break}ao=[[at,ae],[ar,ae]];if(this.shadow){this.renderer.shadowRenderer.draw(am,ao,{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}ai(at,ae,ar,ae,{strokeStyle:ab.borderColor})}ah=null}af=null}ab=null;au=null}am.restore();function ai(aB,aA,ay,ax,az){am.save();az=az||{};if(az.lineWidth==null||az.lineWidth!=0){H.extend(true,am,az);am.beginPath();am.moveTo(aB,aA);am.lineTo(ay,ax);am.stroke();am.restore()}}if(this.shadow){var ao=[[this._left,this._bottom],[this._right,this._bottom],[this._right,this._top]];this.renderer.shadowRenderer.draw(am,ao)}if(this.borderWidth!=0&&this.drawBorder){ai(this._left,this._top,this._right,this._top,{lineCap:"round",strokeStyle:ap.x2axis.borderColor,lineWidth:ap.x2axis.borderWidth});ai(this._right,this._top,this._right,this._bottom,{lineCap:"round",strokeStyle:ap.y2axis.borderColor,lineWidth:ap.y2axis.borderWidth});ai(this._right,this._bottom,this._left,this._bottom,{lineCap:"round",strokeStyle:ap.xaxis.borderColor,lineWidth:ap.xaxis.borderWidth});ai(this._left,this._bottom,this._left,this._top,{lineCap:"round",strokeStyle:ap.yaxis.borderColor,lineWidth:ap.yaxis.borderWidth})}am.restore();am=null;ap=null};H.jqplot.DivTitleRenderer=function(){};H.jqplot.DivTitleRenderer.prototype.init=function(ab){H.extend(true,this,ab)};H.jqplot.DivTitleRenderer.prototype.draw=function(){if(this._elem){this._elem.emptyForce();this._elem=null}var ae=this.renderer;var ad=document.createElement("div");this._elem=H(ad);this._elem.addClass("jqplot-title");if(!this.text){this.show=false;this._elem.height(0);this._elem.width(0)}else{if(this.text){var ab;if(this.color){ab=this.color}else{if(this.textColor){ab=this.textColor}}var ac={position:"absolute",top:"0px",left:"0px"};if(this._plotWidth){ac.width=this._plotWidth+"px"}if(this.fontSize){ac.fontSize=this.fontSize}if(typeof this.textAlign==="string"){ac.textAlign=this.textAlign}else{ac.textAlign="center"}if(ab){ac.color=ab}if(this.paddingBottom){ac.paddingBottom=this.paddingBottom}if(this.fontFamily){ac.fontFamily=this.fontFamily}this._elem.css(ac);if(this.escapeHtml){this._elem.text(this.text)}else{this._elem.html(this.text)}}}ad=null;return this._elem};H.jqplot.DivTitleRenderer.prototype.pack=function(){};var o=0.1;H.jqplot.LinePattern=function(ap,ak){var aj={dotted:[o,H.jqplot.config.dotGapLength],dashed:[H.jqplot.config.dashLength,H.jqplot.config.gapLength],solid:null};if(typeof ak==="string"){if(ak[0]==="."||ak[0]==="-"){var aq=ak;ak=[];for(var ai=0,af=aq.length;ai<af;ai++){if(aq[ai]==="."){ak.push(o)}else{if(aq[ai]==="-"){ak.push(H.jqplot.config.dashLength)}else{continue}}ak.push(H.jqplot.config.gapLength)}}else{ak=aj[ak]}}if(!(ak&&ak.length)){return ap}var ae=0;var al=ak[0];var an=0;var am=0;var ah=0;var ab=0;var ao=function(ar,at){ap.moveTo(ar,at);an=ar;am=at;ah=ar;ab=at};var ad=function(ar,ay){var aw=ap.lineWidth;var au=ar-an;var at=ay-am;var av=Math.sqrt(au*au+at*at);if((av>0)&&(aw>0)){au/=av;at/=av;while(true){var ax=aw*al;if(ax<av){an+=ax*au;am+=ax*at;if((ae&1)==0){ap.lineTo(an,am)}else{ap.moveTo(an,am)}av-=ax;ae++;if(ae>=ak.length){ae=0}al=ak[ae]}else{an=ar;am=ay;if((ae&1)==0){ap.lineTo(an,am)}else{ap.moveTo(an,am)}al-=av/aw;break}}}};var ac=function(){ap.beginPath()};var ag=function(){ad(ah,ab)};return{moveTo:ao,lineTo:ad,beginPath:ac,closePath:ag}};H.jqplot.LineRenderer=function(){this.shapeRenderer=new H.jqplot.ShapeRenderer();this.shadowRenderer=new H.jqplot.ShadowRenderer()};H.jqplot.LineRenderer.prototype.init=function(ac,ah){ac=ac||{};this._type="line";this.renderer.animation={show:false,direction:"left",speed:2500,_supported:true};this.renderer.smooth=false;this.renderer.tension=null;this.renderer.constrainSmoothing=true;this.renderer._smoothedData=[];this.renderer._smoothedPlotData=[];this.renderer._hiBandGridData=[];this.renderer._lowBandGridData=[];this.renderer._hiBandSmoothedData=[];this.renderer._lowBandSmoothedData=[];this.renderer.bandData=[];this.renderer.bands={show:false,hiData:[],lowData:[],color:this.color,showLines:false,fill:true,fillColor:null,_min:null,_max:null,interval:"3%"};var af={highlightMouseOver:ac.highlightMouseOver,highlightMouseDown:ac.highlightMouseDown,highlightColor:ac.highlightColor};delete (ac.highlightMouseOver);delete (ac.highlightMouseDown);delete (ac.highlightColor);H.extend(true,this.renderer,ac);this.renderer.options=ac;if(this.renderer.bandData.length>1&&(!ac.bands||ac.bands.show==null)){this.renderer.bands.show=true}else{if(ac.bands&&ac.bands.show==null&&ac.bands.interval!=null){this.renderer.bands.show=true}}if(this.fill){this.renderer.bands.show=false}if(this.renderer.bands.show){this.renderer.initBands.call(this,this.renderer.options,ah)}if(this._stack){this.renderer.smooth=false}var ag={lineJoin:this.lineJoin,lineCap:this.lineCap,fill:this.fill,isarc:false,strokeStyle:this.color,fillStyle:this.fillColor,lineWidth:this.lineWidth,linePattern:this.linePattern,closePath:this.fill};this.renderer.shapeRenderer.init(ag);var ad=ac.shadowOffset;if(ad==null){if(this.lineWidth>2.5){ad=1.25*(1+(Math.atan((this.lineWidth/2.5))/0.785398163-1)*0.6)}else{ad=1.25*Math.atan((this.lineWidth/2.5))/0.785398163}}var ab={lineJoin:this.lineJoin,lineCap:this.lineCap,fill:this.fill,isarc:false,angle:this.shadowAngle,offset:ad,alpha:this.shadowAlpha,depth:this.shadowDepth,lineWidth:this.lineWidth,linePattern:this.linePattern,closePath:this.fill};this.renderer.shadowRenderer.init(ab);this._areaPoints=[];this._boundingBox=[[],[]];if(!this.isTrendline&&this.fill||this.renderer.bands.show){this.highlightMouseOver=true;this.highlightMouseDown=false;this.highlightColor=null;if(af.highlightMouseDown&&af.highlightMouseOver==null){af.highlightMouseOver=false}H.extend(true,this,{highlightMouseOver:af.highlightMouseOver,highlightMouseDown:af.highlightMouseDown,highlightColor:af.highlightColor});if(!this.highlightColor){var ae=(this.renderer.bands.show)?this.renderer.bands.fillColor:this.fillColor;this.highlightColor=H.jqplot.computeHighlightColors(ae)}if(this.highlighter){this.highlighter.show=false}}if(!this.isTrendline&&ah){ah.plugins.lineRenderer={};ah.postInitHooks.addOnce(v);ah.postDrawHooks.addOnce(Z);ah.eventListenerHooks.addOnce("jqplotMouseMove",g);ah.eventListenerHooks.addOnce("jqplotMouseDown",d);ah.eventListenerHooks.addOnce("jqplotMouseUp",Y);ah.eventListenerHooks.addOnce("jqplotClick",f);ah.eventListenerHooks.addOnce("jqplotRightClick",p)}};H.jqplot.LineRenderer.prototype.initBands=function(ae,ao){var af=ae.bandData||[];var ah=this.renderer.bands;ah.hiData=[];ah.lowData=[];var av=this.data;ah._max=null;ah._min=null;if(af.length==2){if(H.isArray(af[0][0])){var ai;var ab=0,al=0;for(var ap=0,am=af[0].length;ap<am;ap++){ai=af[0][ap];if((ai[1]!=null&&ai[1]>ah._max)||ah._max==null){ah._max=ai[1]}if((ai[1]!=null&&ai[1]<ah._min)||ah._min==null){ah._min=ai[1]}}for(var ap=0,am=af[1].length;ap<am;ap++){ai=af[1][ap];if((ai[1]!=null&&ai[1]>ah._max)||ah._max==null){ah._max=ai[1];al=1}if((ai[1]!=null&&ai[1]<ah._min)||ah._min==null){ah._min=ai[1];ab=1}}if(al===ab){ah.show=false}ah.hiData=af[al];ah.lowData=af[ab]}else{if(af[0].length===av.length&&af[1].length===av.length){var ad=(af[0][0]>af[1][0])?0:1;var aw=(ad)?0:1;for(var ap=0,am=av.length;ap<am;ap++){ah.hiData.push([av[ap][0],af[ad][ap]]);ah.lowData.push([av[ap][0],af[aw][ap]])}}else{ah.show=false}}}else{if(af.length>2&&!H.isArray(af[0][0])){var ad=(af[0][0]>af[0][1])?0:1;var aw=(ad)?0:1;for(var ap=0,am=af.length;ap<am;ap++){ah.hiData.push([av[ap][0],af[ap][ad]]);ah.lowData.push([av[ap][0],af[ap][aw]])}}else{var ak=ah.interval;var au=null;var at=null;var ac=null;var an=null;if(H.isArray(ak)){au=ak[0];at=ak[1]}else{au=ak}if(isNaN(au)){if(au.charAt(au.length-1)==="%"){ac="multiply";au=parseFloat(au)/100+1}}else{au=parseFloat(au);ac="add"}if(at!==null&&isNaN(at)){if(at.charAt(at.length-1)==="%"){an="multiply";at=parseFloat(at)/100+1}}else{if(at!==null){at=parseFloat(at);an="add"}}if(au!==null){if(at===null){at=-au;an=ac;if(an==="multiply"){at+=2}}if(au<at){var aq=au;au=at;at=aq;aq=ac;ac=an;an=aq}for(var ap=0,am=av.length;ap<am;ap++){switch(ac){case"add":ah.hiData.push([av[ap][0],av[ap][1]+au]);break;case"multiply":ah.hiData.push([av[ap][0],av[ap][1]*au]);break}switch(an){case"add":ah.lowData.push([av[ap][0],av[ap][1]+at]);break;case"multiply":ah.lowData.push([av[ap][0],av[ap][1]*at]);break}}}else{ah.show=false}}}var ag=ah.hiData;var aj=ah.lowData;for(var ap=0,am=ag.length;ap<am;ap++){if((ag[ap][1]!=null&&ag[ap][1]>ah._max)||ah._max==null){ah._max=ag[ap][1]}}for(var ap=0,am=aj.length;ap<am;ap++){if((aj[ap][1]!=null&&aj[ap][1]<ah._min)||ah._min==null){ah._min=aj[ap][1]}}if(ah.fillColor===null){var ar=H.jqplot.getColorComponents(ah.color);ar[3]=ar[3]*0.5;ah.fillColor="rgba("+ar[0]+", "+ar[1]+", "+ar[2]+", "+ar[3]+")"}};function G(ac,ab){return(3.4182054+ab)*Math.pow(ac,-0.3534992)}function k(ad,ac){var ab=Math.sqrt(Math.pow((ac[0]-ad[0]),2)+Math.pow((ac[1]-ad[1]),2));return 5.7648*Math.log(ab)+7.4456}function w(ab){var ac=(Math.exp(2*ab)-1)/(Math.exp(2*ab)+1);return ac}function F(aD){var am=this.renderer.smooth;var ax=this.canvas.getWidth();var ah=this._xaxis.series_p2u;var aA=this._yaxis.series_p2u;var az=null;var ag=null;var at=aD.length/ax;var ad=[];var ar=[];if(!isNaN(parseFloat(am))){az=parseFloat(am)}else{az=G(at,0.5)}var ap=[];var ae=[];for(var ay=0,au=aD.length;ay<au;ay++){ap.push(aD[ay][1]);ae.push(aD[ay][0])}function ao(aE,aF){if(aE-aF==0){return Math.pow(10,10)}else{return aE-aF}}var aq,al,ak,aj;var ab=aD.length-1;for(var af=1,av=aD.length;af<av;af++){var ac=[];var an=[];for(var aw=0;aw<2;aw++){var ay=af-1+aw;if(ay==0||ay==ab){ac[aw]=Math.pow(10,10)}else{if(ap[ay+1]-ap[ay]==0||ap[ay]-ap[ay-1]==0){ac[aw]=0}else{if(((ae[ay+1]-ae[ay])/(ap[ay+1]-ap[ay])+(ae[ay]-ae[ay-1])/(ap[ay]-ap[ay-1]))==0){ac[aw]=0}else{if((ap[ay+1]-ap[ay])*(ap[ay]-ap[ay-1])<0){ac[aw]=0}else{ac[aw]=2/(ao(ae[ay+1],ae[ay])/(ap[ay+1]-ap[ay])+ao(ae[ay],ae[ay-1])/(ap[ay]-ap[ay-1]))}}}}}if(af==1){ac[0]=3/2*(ap[1]-ap[0])/ao(ae[1],ae[0])-ac[1]/2}else{if(af==ab){ac[1]=3/2*(ap[ab]-ap[ab-1])/ao(ae[ab],ae[ab-1])-ac[0]/2}}an[0]=-2*(ac[1]+2*ac[0])/ao(ae[af],ae[af-1])+6*(ap[af]-ap[af-1])/Math.pow(ao(ae[af],ae[af-1]),2);an[1]=2*(2*ac[1]+ac[0])/ao(ae[af],ae[af-1])-6*(ap[af]-ap[af-1])/Math.pow(ao(ae[af],ae[af-1]),2);aj=1/6*(an[1]-an[0])/ao(ae[af],ae[af-1]);ak=1/2*(ae[af]*an[0]-ae[af-1]*an[1])/ao(ae[af],ae[af-1]);al=(ap[af]-ap[af-1]-ak*(Math.pow(ae[af],2)-Math.pow(ae[af-1],2))-aj*(Math.pow(ae[af],3)-Math.pow(ae[af-1],3)))/ao(ae[af],ae[af-1]);aq=ap[af-1]-al*ae[af-1]-ak*Math.pow(ae[af-1],2)-aj*Math.pow(ae[af-1],3);var aC=(ae[af]-ae[af-1])/az;var aB,ai;for(var aw=0,au=az;aw<au;aw++){aB=[];ai=ae[af-1]+aw*aC;aB.push(ai);aB.push(aq+al*ai+ak*Math.pow(ai,2)+aj*Math.pow(ai,3));ad.push(aB);ar.push([ah(aB[0]),aA(aB[1])])}}ad.push(aD[ay]);ar.push([ah(aD[ay][0]),aA(aD[ay][1])]);return[ad,ar]}function B(aj){var ai=this.renderer.smooth;var aO=this.renderer.tension;var ab=this.canvas.getWidth();var aB=this._xaxis.series_p2u;var ak=this._yaxis.series_p2u;var aC=null;var aD=null;var aN=null;var aI=null;var aG=null;var am=null;var aL=null;var ag=null;var aE,aF,ax,aw,au,ar;var ae,ac,ao,an;var av,at,aH;var ap=[];var ad=[];var af=aj.length/ab;var aM,aq,az,aA,ay;var al=[];var ah=[];if(!isNaN(parseFloat(ai))){aC=parseFloat(ai)}else{aC=G(af,0.5)}if(!isNaN(parseFloat(aO))){aO=parseFloat(aO)}for(var aK=0,aJ=aj.length-1;aK<aJ;aK++){if(aO===null){am=Math.abs((aj[aK+1][1]-aj[aK][1])/(aj[aK+1][0]-aj[aK][0]));aM=0.3;aq=0.6;az=(aq-aM)/2;aA=2.5;ay=-1.4;ag=am/aA+ay;aI=az*w(ag)-az*w(ay)+aM;if(aK>0){aL=Math.abs((aj[aK][1]-aj[aK-1][1])/(aj[aK][0]-aj[aK-1][0]))}ag=aL/aA+ay;aG=az*w(ag)-az*w(ay)+aM;aN=(aI+aG)/2}else{aN=aO}for(aE=0;aE<aC;aE++){aF=aE/aC;ax=(1+2*aF)*Math.pow((1-aF),2);aw=aF*Math.pow((1-aF),2);au=Math.pow(aF,2)*(3-2*aF);ar=Math.pow(aF,2)*(aF-1);if(aj[aK-1]){ae=aN*(aj[aK+1][0]-aj[aK-1][0]);ac=aN*(aj[aK+1][1]-aj[aK-1][1])}else{ae=aN*(aj[aK+1][0]-aj[aK][0]);ac=aN*(aj[aK+1][1]-aj[aK][1])}if(aj[aK+2]){ao=aN*(aj[aK+2][0]-aj[aK][0]);an=aN*(aj[aK+2][1]-aj[aK][1])}else{ao=aN*(aj[aK+1][0]-aj[aK][0]);an=aN*(aj[aK+1][1]-aj[aK][1])}av=ax*aj[aK][0]+au*aj[aK+1][0]+aw*ae+ar*ao;at=ax*aj[aK][1]+au*aj[aK+1][1]+aw*ac+ar*an;aH=[av,at];al.push(aH);ah.push([aB(av),ak(at)])}}al.push(aj[aJ]);ah.push([aB(aj[aJ][0]),ak(aj[aJ][1])]);return[al,ah]}H.jqplot.LineRenderer.prototype.setGridData=function(aj){var af=this._xaxis.series_u2p;var ab=this._yaxis.series_u2p;var ag=this._plotData;var ak=this._prevPlotData;this.gridData=[];this._prevGridData=[];this.renderer._smoothedData=[];this.renderer._smoothedPlotData=[];this.renderer._hiBandGridData=[];this.renderer._lowBandGridData=[];this.renderer._hiBandSmoothedData=[];this.renderer._lowBandSmoothedData=[];var ae=this.renderer.bands;var ac=false;for(var ah=0,ad=ag.length;ah<ad;ah++){if(ag[ah][0]!=null&&ag[ah][1]!=null){this.gridData.push([af.call(this._xaxis,ag[ah][0]),ab.call(this._yaxis,ag[ah][1])])}else{if(ag[ah][0]==null){ac=true;this.gridData.push([null,ab.call(this._yaxis,ag[ah][1])])}else{if(ag[ah][1]==null){ac=true;this.gridData.push([af.call(this._xaxis,ag[ah][0]),null])}}}if(ak[ah]!=null&&ak[ah][0]!=null&&ak[ah][1]!=null){this._prevGridData.push([af.call(this._xaxis,ak[ah][0]),ab.call(this._yaxis,ak[ah][1])])}else{if(ak[ah]!=null&&ak[ah][0]==null){this._prevGridData.push([null,ab.call(this._yaxis,ak[ah][1])])}else{if(ak[ah]!=null&&ak[ah][0]!=null&&ak[ah][1]==null){this._prevGridData.push([af.call(this._xaxis,ak[ah][0]),null])}}}}if(ac){this.renderer.smooth=false;if(this._type==="line"){ae.show=false}}if(this._type==="line"&&ae.show){for(var ah=0,ad=ae.hiData.length;ah<ad;ah++){this.renderer._hiBandGridData.push([af.call(this._xaxis,ae.hiData[ah][0]),ab.call(this._yaxis,ae.hiData[ah][1])])}for(var ah=0,ad=ae.lowData.length;ah<ad;ah++){this.renderer._lowBandGridData.push([af.call(this._xaxis,ae.lowData[ah][0]),ab.call(this._yaxis,ae.lowData[ah][1])])}}if(this._type==="line"&&this.renderer.smooth&&this.gridData.length>2){var ai;if(this.renderer.constrainSmoothing){ai=F.call(this,this.gridData);this.renderer._smoothedData=ai[0];this.renderer._smoothedPlotData=ai[1];if(ae.show){ai=F.call(this,this.renderer._hiBandGridData);this.renderer._hiBandSmoothedData=ai[0];ai=F.call(this,this.renderer._lowBandGridData);this.renderer._lowBandSmoothedData=ai[0]}ai=null}else{ai=B.call(this,this.gridData);this.renderer._smoothedData=ai[0];this.renderer._smoothedPlotData=ai[1];if(ae.show){ai=B.call(this,this.renderer._hiBandGridData);this.renderer._hiBandSmoothedData=ai[0];ai=B.call(this,this.renderer._lowBandGridData);this.renderer._lowBandSmoothedData=ai[0]}ai=null}}};H.jqplot.LineRenderer.prototype.makeGridData=function(ai,ak){var ag=this._xaxis.series_u2p;var ab=this._yaxis.series_u2p;var al=[];var ad=[];this.renderer._smoothedData=[];this.renderer._smoothedPlotData=[];this.renderer._hiBandGridData=[];this.renderer._lowBandGridData=[];this.renderer._hiBandSmoothedData=[];this.renderer._lowBandSmoothedData=[];var af=this.renderer.bands;var ac=false;for(var ah=0;ah<ai.length;ah++){if(ai[ah][0]!=null&&ai[ah][1]!=null){al.push([ag.call(this._xaxis,ai[ah][0]),ab.call(this._yaxis,ai[ah][1])])}else{if(ai[ah][0]==null){ac=true;al.push([null,ab.call(this._yaxis,ai[ah][1])])}else{if(ai[ah][1]==null){ac=true;al.push([ag.call(this._xaxis,ai[ah][0]),null])}}}}if(ac){this.renderer.smooth=false;if(this._type==="line"){af.show=false}}if(this._type==="line"&&af.show){for(var ah=0,ae=af.hiData.length;ah<ae;ah++){this.renderer._hiBandGridData.push([ag.call(this._xaxis,af.hiData[ah][0]),ab.call(this._yaxis,af.hiData[ah][1])])}for(var ah=0,ae=af.lowData.length;ah<ae;ah++){this.renderer._lowBandGridData.push([ag.call(this._xaxis,af.lowData[ah][0]),ab.call(this._yaxis,af.lowData[ah][1])])}}if(this._type==="line"&&this.renderer.smooth&&al.length>2){var aj;if(this.renderer.constrainSmoothing){aj=F.call(this,al);this.renderer._smoothedData=aj[0];this.renderer._smoothedPlotData=aj[1];if(af.show){aj=F.call(this,this.renderer._hiBandGridData);this.renderer._hiBandSmoothedData=aj[0];aj=F.call(this,this.renderer._lowBandGridData);this.renderer._lowBandSmoothedData=aj[0]}aj=null}else{aj=B.call(this,al);this.renderer._smoothedData=aj[0];this.renderer._smoothedPlotData=aj[1];if(af.show){aj=B.call(this,this.renderer._hiBandGridData);this.renderer._hiBandSmoothedData=aj[0];aj=B.call(this,this.renderer._lowBandGridData);this.renderer._lowBandSmoothedData=aj[0]}aj=null}}return al};H.jqplot.LineRenderer.prototype.draw=function(aq,aC,ac,av){var aw;var ak=H.extend(true,{},ac);var ae=(ak.shadow!=r)?ak.shadow:this.shadow;var aD=(ak.showLine!=r)?ak.showLine:this.showLine;var au=(ak.fill!=r)?ak.fill:this.fill;var ab=(ak.fillAndStroke!=r)?ak.fillAndStroke:this.fillAndStroke;var al,ar,ao,ay;aq.save();if(aC.length){if(aD){if(au){if(this.fillToZero){var az=this.negativeColor;if(!this.useNegativeColors){az=ak.fillStyle}var ai=false;var aj=ak.fillStyle;if(ab){var aB=aC.slice(0)}if(this.index==0||!this._stack){var ap=[];var aF=(this.renderer.smooth)?this.renderer._smoothedPlotData:this._plotData;this._areaPoints=[];var aA=this._yaxis.series_u2p(this.fillToValue);var ad=this._xaxis.series_u2p(this.fillToValue);ak.closePath=true;if(this.fillAxis=="y"){ap.push([aC[0][0],aA]);this._areaPoints.push([aC[0][0],aA]);for(var aw=0;aw<aC.length-1;aw++){ap.push(aC[aw]);this._areaPoints.push(aC[aw]);if(aF[aw][1]*aF[aw+1][1]<0){if(aF[aw][1]<0){ai=true;ak.fillStyle=az}else{ai=false;ak.fillStyle=aj}var ah=aC[aw][0]+(aC[aw+1][0]-aC[aw][0])*(aA-aC[aw][1])/(aC[aw+1][1]-aC[aw][1]);ap.push([ah,aA]);this._areaPoints.push([ah,aA]);if(ae){this.renderer.shadowRenderer.draw(aq,ap,ak)}this.renderer.shapeRenderer.draw(aq,ap,ak);ap=[[ah,aA]]}}if(aF[aC.length-1][1]<0){ai=true;ak.fillStyle=az}else{ai=false;ak.fillStyle=aj}ap.push(aC[aC.length-1]);this._areaPoints.push(aC[aC.length-1]);ap.push([aC[aC.length-1][0],aA]);this._areaPoints.push([aC[aC.length-1][0],aA])}if(ae){this.renderer.shadowRenderer.draw(aq,ap,ak)}this.renderer.shapeRenderer.draw(aq,ap,ak)}else{var an=this._prevGridData;for(var aw=an.length;aw>0;aw--){aC.push(an[aw-1])}if(ae){this.renderer.shadowRenderer.draw(aq,aC,ak)}this._areaPoints=aC;this.renderer.shapeRenderer.draw(aq,aC,ak)}}else{if(ab){var aB=aC.slice(0)}if(this.index==0||!this._stack){var af=aq.canvas.height;aC.unshift([aC[0][0],af]);var ax=aC.length;aC.push([aC[ax-1][0],af])}else{var an=this._prevGridData;for(var aw=an.length;aw>0;aw--){aC.push(an[aw-1])}}this._areaPoints=aC;if(ae){this.renderer.shadowRenderer.draw(aq,aC,ak)}this.renderer.shapeRenderer.draw(aq,aC,ak)}if(ab){var at=H.extend(true,{},ak,{fill:false,closePath:false});this.renderer.shapeRenderer.draw(aq,aB,at);if(this.markerRenderer.show){if(this.renderer.smooth){aB=this.gridData}for(aw=0;aw<aB.length;aw++){this.markerRenderer.draw(aB[aw][0],aB[aw][1],aq,ak.markerOptions)}}}}else{if(this.renderer.bands.show){var ag;var aE=H.extend(true,{},ak);if(this.renderer.bands.showLines){ag=(this.renderer.smooth)?this.renderer._hiBandSmoothedData:this.renderer._hiBandGridData;this.renderer.shapeRenderer.draw(aq,ag,ak);ag=(this.renderer.smooth)?this.renderer._lowBandSmoothedData:this.renderer._lowBandGridData;this.renderer.shapeRenderer.draw(aq,ag,aE)}if(this.renderer.bands.fill){if(this.renderer.smooth){ag=this.renderer._hiBandSmoothedData.concat(this.renderer._lowBandSmoothedData.reverse())}else{ag=this.renderer._hiBandGridData.concat(this.renderer._lowBandGridData.reverse())}this._areaPoints=ag;aE.closePath=true;aE.fill=true;aE.fillStyle=this.renderer.bands.fillColor;this.renderer.shapeRenderer.draw(aq,ag,aE)}}if(ae){this.renderer.shadowRenderer.draw(aq,aC,ak)}this.renderer.shapeRenderer.draw(aq,aC,ak)}}var al=ao=ar=ay=null;for(aw=0;aw<this._areaPoints.length;aw++){var am=this._areaPoints[aw];if(al>am[0]||al==null){al=am[0]}if(ay<am[1]||ay==null){ay=am[1]}if(ao<am[0]||ao==null){ao=am[0]}if(ar>am[1]||ar==null){ar=am[1]}}if(this.type==="line"&&this.renderer.bands.show){ay=this._yaxis.series_u2p(this.renderer.bands._min);ar=this._yaxis.series_u2p(this.renderer.bands._max)}this._boundingBox=[[al,ay],[ao,ar]];if(this.markerRenderer.show&&!au){if(this.renderer.smooth){aC=this.gridData}for(aw=0;aw<aC.length;aw++){if(aC[aw][0]!=null&&aC[aw][1]!=null){this.markerRenderer.draw(aC[aw][0],aC[aw][1],aq,ak.markerOptions)}}}}aq.restore()};H.jqplot.LineRenderer.prototype.drawShadow=function(ab,ad,ac){};function v(ae,ad,ab){for(var ac=0;ac<this.series.length;ac++){if(this.series[ac].renderer.constructor==H.jqplot.LineRenderer){if(this.series[ac].highlightMouseOver){this.series[ac].highlightMouseDown=false}}}}function Z(){if(this.plugins.lineRenderer&&this.plugins.lineRenderer.highlightCanvas){this.plugins.lineRenderer.highlightCanvas.resetCanvas();this.plugins.lineRenderer.highlightCanvas=null}this.plugins.lineRenderer.highlightedSeriesIndex=null;this.plugins.lineRenderer.highlightCanvas=new H.jqplot.GenericCanvas();this.eventCanvas._elem.before(this.plugins.lineRenderer.highlightCanvas.createElement(this._gridPadding,"jqplot-lineRenderer-highlight-canvas",this._plotDimensions,this));this.plugins.lineRenderer.highlightCanvas.setContext();this.eventCanvas._elem.bind("mouseleave",{plot:this},function(ab){V(ab.data.plot)})}function X(ah,ag,ae,ad){var ac=ah.series[ag];var ab=ah.plugins.lineRenderer.highlightCanvas;ab._ctx.clearRect(0,0,ab._ctx.canvas.width,ab._ctx.canvas.height);ac._highlightedPoint=ae;ah.plugins.lineRenderer.highlightedSeriesIndex=ag;var af={fillStyle:ac.highlightColor};if(ac.type==="line"&&ac.renderer.bands.show){af.fill=true;af.closePath=true}ac.renderer.shapeRenderer.draw(ab._ctx,ad,af);ab=null}function V(ad){var ab=ad.plugins.lineRenderer.highlightCanvas;ab._ctx.clearRect(0,0,ab._ctx.canvas.width,ab._ctx.canvas.height);for(var ac=0;ac<ad.series.length;ac++){ad.series[ac]._highlightedPoint=null}ad.plugins.lineRenderer.highlightedSeriesIndex=null;ad.target.trigger("jqplotDataUnhighlight");ab=null}function g(af,ae,ai,ah,ag){if(ah){var ad=[ah.seriesIndex,ah.pointIndex,ah.data];var ac=jQuery.Event("jqplotDataMouseOver");ac.pageX=af.pageX;ac.pageY=af.pageY;ag.target.trigger(ac,ad);if(ag.series[ad[0]].highlightMouseOver&&!(ad[0]==ag.plugins.lineRenderer.highlightedSeriesIndex)){var ab=jQuery.Event("jqplotDataHighlight");ab.which=af.which;ab.pageX=af.pageX;ab.pageY=af.pageY;ag.target.trigger(ab,ad);X(ag,ah.seriesIndex,ah.pointIndex,ah.points)}}else{if(ah==null){V(ag)}}}function d(ae,ad,ah,ag,af){if(ag){var ac=[ag.seriesIndex,ag.pointIndex,ag.data];if(af.series[ac[0]].highlightMouseDown&&!(ac[0]==af.plugins.lineRenderer.highlightedSeriesIndex)){var ab=jQuery.Event("jqplotDataHighlight");ab.which=ae.which;ab.pageX=ae.pageX;ab.pageY=ae.pageY;af.target.trigger(ab,ac);X(af,ag.seriesIndex,ag.pointIndex,ag.points)}}else{if(ag==null){V(af)}}}function Y(ad,ac,ag,af,ae){var ab=ae.plugins.lineRenderer.highlightedSeriesIndex;if(ab!=null&&ae.series[ab].highlightMouseDown){V(ae)}}function f(ae,ad,ah,ag,af){if(ag){var ac=[ag.seriesIndex,ag.pointIndex,ag.data];var ab=jQuery.Event("jqplotDataClick");ab.which=ae.which;ab.pageX=ae.pageX;ab.pageY=ae.pageY;af.target.trigger(ab,ac)}}function p(af,ae,ai,ah,ag){if(ah){var ad=[ah.seriesIndex,ah.pointIndex,ah.data];var ab=ag.plugins.lineRenderer.highlightedSeriesIndex;if(ab!=null&&ag.series[ab].highlightMouseDown){V(ag)}var ac=jQuery.Event("jqplotDataRightClick");ac.which=af.which;ac.pageX=af.pageX;ac.pageY=af.pageY;ag.target.trigger(ac,ad)}}H.jqplot.LinearAxisRenderer=function(){};H.jqplot.LinearAxisRenderer.prototype.init=function(ab){this.breakPoints=null;this.breakTickLabel="&asymp;";this.drawBaseline=true;this.baselineWidth=null;this.baselineColor=null;this.forceTickAt0=false;this.forceTickAt100=false;this.tickInset=0;this.minorTicks=0;this.alignTicks=false;this._autoFormatString="";this._overrideFormatString=false;this._scalefact=1;H.extend(true,this,ab);if(this.breakPoints){if(!H.isArray(this.breakPoints)){this.breakPoints=null}else{if(this.breakPoints.length<2||this.breakPoints[1]<=this.breakPoints[0]){this.breakPoints=null}}}if(this.numberTicks!=null&&this.numberTicks<2){this.numberTicks=2}this.resetDataBounds()};H.jqplot.LinearAxisRenderer.prototype.draw=function(ab,ai){if(this.show){this.renderer.createTicks.call(this,ai);var ah=0;var ac;if(this._elem){this._elem.emptyForce();this._elem=null}this._elem=H(document.createElement("div"));this._elem.addClass("jqplot-axis jqplot-"+this.name);this._elem.css("position","absolute");if(this.name=="xaxis"||this.name=="x2axis"){this._elem.width(this._plotDimensions.width)}else{this._elem.height(this._plotDimensions.height)}this.labelOptions.axis=this.name;this._label=new this.labelRenderer(this.labelOptions);if(this._label.show){var ag=this._label.draw(ab,ai);ag.appendTo(this._elem);ag=null}var af=this._ticks;var ae;for(var ad=0;ad<af.length;ad++){ae=af[ad];if(ae.show&&ae.showLabel&&(!ae.isMinorTick||this.showMinorTicks)){this._elem.append(ae.draw(ab,ai))}}ae=null;af=null}return this._elem};H.jqplot.LinearAxisRenderer.prototype.reset=function(){this.min=this._options.min;this.max=this._options.max;this.tickInterval=this._options.tickInterval;this.numberTicks=this._options.numberTicks;this._autoFormatString="";if(this._overrideFormatString&&this.tickOptions&&this.tickOptions.formatString){this.tickOptions.formatString=""}};H.jqplot.LinearAxisRenderer.prototype.set=function(){var ai=0;var ad;var ac=0;var ah=0;var ab=(this._label==null)?false:this._label.show;if(this.show){var ag=this._ticks;var af;for(var ae=0;ae<ag.length;ae++){af=ag[ae];if(!af._breakTick&&af.show&&af.showLabel&&(!af.isMinorTick||this.showMinorTicks)){if(this.name=="xaxis"||this.name=="x2axis"){ad=af._elem.outerHeight(true)}else{ad=af._elem.outerWidth(true)}if(ad>ai){ai=ad}}}af=null;ag=null;if(ab){ac=this._label._elem.outerWidth(true);ah=this._label._elem.outerHeight(true)}if(this.name=="xaxis"){ai=ai+ah;this._elem.css({height:ai+"px",left:"0px",bottom:"0px"})}else{if(this.name=="x2axis"){ai=ai+ah;this._elem.css({height:ai+"px",left:"0px",top:"0px"})}else{if(this.name=="yaxis"){ai=ai+ac;this._elem.css({width:ai+"px",left:"0px",top:"0px"});if(ab&&this._label.constructor==H.jqplot.AxisLabelRenderer){this._label._elem.css("width",ac+"px")}}else{ai=ai+ac;this._elem.css({width:ai+"px",right:"0px",top:"0px"});if(ab&&this._label.constructor==H.jqplot.AxisLabelRenderer){this._label._elem.css("width",ac+"px")}}}}}};H.jqplot.LinearAxisRenderer.prototype.createTicks=function(ad){var aN=this._ticks;var aE=this.ticks;var at=this.name;var av=this._dataBounds;var ab=(this.name.charAt(0)==="x")?this._plotDimensions.width:this._plotDimensions.height;var ah;var a0,aC;var aj,ai;var aY,aU;var aB=this.min;var aZ=this.max;var aQ=this.numberTicks;var a4=this.tickInterval;var ag=30;this._scalefact=(Math.max(ab,ag+1)-ag)/300;if(aE.length){for(aU=0;aU<aE.length;aU++){var aI=aE[aU];var aO=new this.tickRenderer(this.tickOptions);if(H.isArray(aI)){aO.value=aI[0];if(this.breakPoints){if(aI[0]==this.breakPoints[0]){aO.label=this.breakTickLabel;aO._breakTick=true;aO.showGridline=false;aO.showMark=false}else{if(aI[0]>this.breakPoints[0]&&aI[0]<=this.breakPoints[1]){aO.show=false;aO.showGridline=false;aO.label=aI[1]}else{aO.label=aI[1]}}}else{aO.label=aI[1]}aO.setTick(aI[0],this.name);this._ticks.push(aO)}else{if(H.isPlainObject(aI)){H.extend(true,aO,aI);aO.axis=this.name;this._ticks.push(aO)}else{aO.value=aI;if(this.breakPoints){if(aI==this.breakPoints[0]){aO.label=this.breakTickLabel;aO._breakTick=true;aO.showGridline=false;aO.showMark=false}else{if(aI>this.breakPoints[0]&&aI<=this.breakPoints[1]){aO.show=false;aO.showGridline=false}}}aO.setTick(aI,this.name);this._ticks.push(aO)}}}this.numberTicks=aE.length;this.min=this._ticks[0].value;this.max=this._ticks[this.numberTicks-1].value;this.tickInterval=(this.max-this.min)/(this.numberTicks-1)}else{if(at=="xaxis"||at=="x2axis"){ab=this._plotDimensions.width}else{ab=this._plotDimensions.height}var aq=this.numberTicks;if(this.alignTicks){if(this.name==="x2axis"&&ad.axes.xaxis.show){aq=ad.axes.xaxis.numberTicks}else{if(this.name.charAt(0)==="y"&&this.name!=="yaxis"&&this.name!=="yMidAxis"&&ad.axes.yaxis.show){aq=ad.axes.yaxis.numberTicks}}}a0=((this.min!=null)?this.min:av.min);aC=((this.max!=null)?this.max:av.max);var ao=aC-a0;var aM,ar;var am;if(this.tickOptions==null||!this.tickOptions.formatString){this._overrideFormatString=true}if(this.min==null||this.max==null&&this.tickInterval==null&&!this.autoscale){if(this.forceTickAt0){if(a0>0){a0=0}if(aC<0){aC=0}}if(this.forceTickAt100){if(a0>100){a0=100}if(aC<100){aC=100}}var ay=false,aV=false;if(this.min!=null){ay=true}else{if(this.max!=null){aV=true}}var aJ=H.jqplot.LinearTickGenerator(a0,aC,this._scalefact,aq,ay,aV);var ap=(this.min!=null)?a0:a0+ao*(this.padMin-1);var aK=(this.max!=null)?aC:aC-ao*(this.padMax-1);if(a0<ap||aC>aK){ap=(this.min!=null)?a0:a0-ao*(this.padMin-1);aK=(this.max!=null)?aC:aC+ao*(this.padMax-1);aJ=H.jqplot.LinearTickGenerator(ap,aK,this._scalefact,aq,ay,aV)}this.min=aJ[0];this.max=aJ[1];this.numberTicks=aJ[2];this._autoFormatString=aJ[3];this.tickInterval=aJ[4]}else{if(a0==aC){var ac=0.05;if(a0>0){ac=Math.max(Math.log(a0)/Math.LN10,0.05)}a0-=ac;aC+=ac}if(this.autoscale&&this.min==null&&this.max==null){var ae,af,al;var aw=false;var aH=false;var au={min:null,max:null,average:null,stddev:null};for(var aU=0;aU<this._series.length;aU++){var aP=this._series[aU];var ax=(aP.fillAxis=="x")?aP._xaxis.name:aP._yaxis.name;if(this.name==ax){var aL=aP._plotValues[aP.fillAxis];var aA=aL[0];var aW=aL[0];for(var aT=1;aT<aL.length;aT++){if(aL[aT]<aA){aA=aL[aT]}else{if(aL[aT]>aW){aW=aL[aT]}}}var an=(aW-aA)/aW;if(aP.renderer.constructor==H.jqplot.BarRenderer){if(aA>=0&&(aP.fillToZero||an>0.1)){aw=true}else{aw=false;if(aP.fill&&aP.fillToZero&&aA<0&&aW>0){aH=true}else{aH=false}}}else{if(aP.fill){if(aA>=0&&(aP.fillToZero||an>0.1)){aw=true}else{if(aA<0&&aW>0&&aP.fillToZero){aw=false;aH=true}else{aw=false;aH=false}}}else{if(aA<0){aw=false}}}}}if(aw){this.numberTicks=2+Math.ceil((ab-(this.tickSpacing-1))/this.tickSpacing);this.min=0;aB=0;af=aC/(this.numberTicks-1);am=Math.pow(10,Math.abs(Math.floor(Math.log(af)/Math.LN10)));if(af/am==parseInt(af/am,10)){af+=am}this.tickInterval=Math.ceil(af/am)*am;this.max=this.tickInterval*(this.numberTicks-1)}else{if(aH){this.numberTicks=2+Math.ceil((ab-(this.tickSpacing-1))/this.tickSpacing);var aD=Math.ceil(Math.abs(a0)/ao*(this.numberTicks-1));var a3=this.numberTicks-1-aD;af=Math.max(Math.abs(a0/aD),Math.abs(aC/a3));am=Math.pow(10,Math.abs(Math.floor(Math.log(af)/Math.LN10)));this.tickInterval=Math.ceil(af/am)*am;this.max=this.tickInterval*a3;this.min=-this.tickInterval*aD}else{if(this.numberTicks==null){if(this.tickInterval){this.numberTicks=3+Math.ceil(ao/this.tickInterval)}else{this.numberTicks=2+Math.ceil((ab-(this.tickSpacing-1))/this.tickSpacing)}}if(this.tickInterval==null){af=ao/(this.numberTicks-1);if(af<1){am=Math.pow(10,Math.abs(Math.floor(Math.log(af)/Math.LN10)))}else{am=1}this.tickInterval=Math.ceil(af*am*this.pad)/am}else{am=1/this.tickInterval}ae=this.tickInterval*(this.numberTicks-1);al=(ae-ao)/2;if(this.min==null){this.min=Math.floor(am*(a0-al))/am}if(this.max==null){this.max=this.min+ae}}}var az=H.jqplot.getSignificantFigures(this.tickInterval);var aG;if(az.digitsLeft>=az.significantDigits){aG="%d"}else{var am=Math.max(0,5-az.digitsLeft);am=Math.min(am,az.digitsRight);aG="%."+am+"f"}this._autoFormatString=aG}else{aM=(this.min!=null)?this.min:a0-ao*(this.padMin-1);ar=(this.max!=null)?this.max:aC+ao*(this.padMax-1);ao=ar-aM;if(this.numberTicks==null){if(this.tickInterval!=null){this.numberTicks=Math.ceil((ar-aM)/this.tickInterval)+1}else{if(ab>100){this.numberTicks=parseInt(3+(ab-100)/75,10)}else{this.numberTicks=2}}}if(this.tickInterval==null){this.tickInterval=ao/(this.numberTicks-1)}if(this.max==null){ar=aM+this.tickInterval*(this.numberTicks-1)}if(this.min==null){aM=ar-this.tickInterval*(this.numberTicks-1)}var az=H.jqplot.getSignificantFigures(this.tickInterval);var aG;if(az.digitsLeft>=az.significantDigits){aG="%d"}else{var am=Math.max(0,5-az.digitsLeft);am=Math.min(am,az.digitsRight);aG="%."+am+"f"}this._autoFormatString=aG;this.min=aM;this.max=ar}if(this.renderer.constructor==H.jqplot.LinearAxisRenderer&&this._autoFormatString==""){ao=this.max-this.min;var a1=new this.tickRenderer(this.tickOptions);var aF=a1.formatString||H.jqplot.config.defaultTickFormatString;var aF=aF.match(H.jqplot.sprintf.regex)[0];var aX=0;if(aF){if(aF.search(/[fFeEgGpP]/)>-1){var aS=aF.match(/\%\.(\d{0,})?[eEfFgGpP]/);if(aS){aX=parseInt(aS[1],10)}else{aX=6}}else{if(aF.search(/[di]/)>-1){aX=0}}var ak=Math.pow(10,-aX);if(this.tickInterval<ak){if(aQ==null&&a4==null){this.tickInterval=ak;if(aZ==null&&aB==null){this.min=Math.floor(this._dataBounds.min/ak)*ak;if(this.min==this._dataBounds.min){this.min=this._dataBounds.min-this.tickInterval}this.max=Math.ceil(this._dataBounds.max/ak)*ak;if(this.max==this._dataBounds.max){this.max=this._dataBounds.max+this.tickInterval}var aR=(this.max-this.min)/this.tickInterval;aR=aR.toFixed(11);aR=Math.ceil(aR);this.numberTicks=aR+1}else{if(aZ==null){var aR=(this._dataBounds.max-this.min)/this.tickInterval;aR=aR.toFixed(11);this.numberTicks=Math.ceil(aR)+2;this.max=this.min+this.tickInterval*(this.numberTicks-1)}else{if(aB==null){var aR=(this.max-this._dataBounds.min)/this.tickInterval;aR=aR.toFixed(11);this.numberTicks=Math.ceil(aR)+2;this.min=this.max-this.tickInterval*(this.numberTicks-1)}else{this.numberTicks=Math.ceil((aZ-aB)/this.tickInterval)+1;this.min=Math.floor(aB*Math.pow(10,aX))/Math.pow(10,aX);this.max=Math.ceil(aZ*Math.pow(10,aX))/Math.pow(10,aX);this.numberTicks=Math.ceil((this.max-this.min)/this.tickInterval)+1}}}}}}}}if(this._overrideFormatString&&this._autoFormatString!=""){this.tickOptions=this.tickOptions||{};this.tickOptions.formatString=this._autoFormatString}var aO,a2;for(var aU=0;aU<this.numberTicks;aU++){aY=this.min+aU*this.tickInterval;aO=new this.tickRenderer(this.tickOptions);aO.setTick(aY,this.name);this._ticks.push(aO);if(aU<this.numberTicks-1){for(var aT=0;aT<this.minorTicks;aT++){aY+=this.tickInterval/(this.minorTicks+1);a2=H.extend(true,{},this.tickOptions,{name:this.name,value:aY,label:"",isMinorTick:true});aO=new this.tickRenderer(a2);this._ticks.push(aO)}}aO=null}}if(this.tickInset){this.min=this.min-this.tickInset*this.tickInterval;this.max=this.max+this.tickInset*this.tickInterval}aN=null};H.jqplot.LinearAxisRenderer.prototype.resetTickValues=function(ad){if(H.isArray(ad)&&ad.length==this._ticks.length){var ac;for(var ab=0;ab<ad.length;ab++){ac=this._ticks[ab];ac.value=ad[ab];ac.label=ac.formatter(ac.formatString,ad[ab]);ac.label=ac.prefix+ac.label;ac._elem.html(ac.label)}ac=null;this.min=H.jqplot.arrayMin(ad);this.max=H.jqplot.arrayMax(ad);this.pack()}};H.jqplot.LinearAxisRenderer.prototype.pack=function(ad,ac){ad=ad||{};ac=ac||this._offsets;var ar=this._ticks;var an=this.max;var am=this.min;var ai=ac.max;var ag=ac.min;var ak=(this._label==null)?false:this._label.show;for(var al in ad){this._elem.css(al,ad[al])}this._offsets=ac;var ae=ai-ag;var af=an-am;if(this.breakPoints){af=af-this.breakPoints[1]+this.breakPoints[0];this.p2u=function(au){return(au-ag)*af/ae+am};this.u2p=function(au){if(au>this.breakPoints[0]&&au<this.breakPoints[1]){au=this.breakPoints[0]}if(au<=this.breakPoints[0]){return(au-am)*ae/af+ag}else{return(au-this.breakPoints[1]+this.breakPoints[0]-am)*ae/af+ag}};if(this.name.charAt(0)=="x"){this.series_u2p=function(au){if(au>this.breakPoints[0]&&au<this.breakPoints[1]){au=this.breakPoints[0]}if(au<=this.breakPoints[0]){return(au-am)*ae/af}else{return(au-this.breakPoints[1]+this.breakPoints[0]-am)*ae/af}};this.series_p2u=function(au){return au*af/ae+am}}else{this.series_u2p=function(au){if(au>this.breakPoints[0]&&au<this.breakPoints[1]){au=this.breakPoints[0]}if(au>=this.breakPoints[1]){return(au-an)*ae/af}else{return(au+this.breakPoints[1]-this.breakPoints[0]-an)*ae/af}};this.series_p2u=function(au){return au*af/ae+an}}}else{this.p2u=function(au){return(au-ag)*af/ae+am};this.u2p=function(au){return(au-am)*ae/af+ag};if(this.name=="xaxis"||this.name=="x2axis"){this.series_u2p=function(au){return(au-am)*ae/af};this.series_p2u=function(au){return au*af/ae+am}}else{this.series_u2p=function(au){return(au-an)*ae/af};this.series_p2u=function(au){return au*af/ae+an}}}if(this.show){if(this.name=="xaxis"||this.name=="x2axis"){for(var ao=0;ao<ar.length;ao++){var aj=ar[ao];if(aj.show&&aj.showLabel){var ab;if(aj.constructor==H.jqplot.CanvasAxisTickRenderer&&aj.angle){var aq=(this.name=="xaxis")?1:-1;switch(aj.labelPosition){case"auto":if(aq*aj.angle<0){ab=-aj.getWidth()+aj._textRenderer.height*Math.sin(-aj._textRenderer.angle)/2}else{ab=-aj._textRenderer.height*Math.sin(aj._textRenderer.angle)/2}break;case"end":ab=-aj.getWidth()+aj._textRenderer.height*Math.sin(-aj._textRenderer.angle)/2;break;case"start":ab=-aj._textRenderer.height*Math.sin(aj._textRenderer.angle)/2;break;case"middle":ab=-aj.getWidth()/2+aj._textRenderer.height*Math.sin(-aj._textRenderer.angle)/2;break;default:ab=-aj.getWidth()/2+aj._textRenderer.height*Math.sin(-aj._textRenderer.angle)/2;break}}else{ab=-aj.getWidth()/2}var at=this.u2p(aj.value)+ab+"px";aj._elem.css("left",at);aj.pack()}}if(ak){var ah=this._label._elem.outerWidth(true);this._label._elem.css("left",ag+ae/2-ah/2+"px");if(this.name=="xaxis"){this._label._elem.css("bottom","0px")}else{this._label._elem.css("top","0px")}this._label.pack()}}else{for(var ao=0;ao<ar.length;ao++){var aj=ar[ao];if(aj.show&&aj.showLabel){var ab;if(aj.constructor==H.jqplot.CanvasAxisTickRenderer&&aj.angle){var aq=(this.name=="yaxis")?1:-1;switch(aj.labelPosition){case"auto":case"end":if(aq*aj.angle<0){ab=-aj._textRenderer.height*Math.cos(-aj._textRenderer.angle)/2}else{ab=-aj.getHeight()+aj._textRenderer.height*Math.cos(aj._textRenderer.angle)/2}break;case"start":if(aj.angle>0){ab=-aj._textRenderer.height*Math.cos(-aj._textRenderer.angle)/2}else{ab=-aj.getHeight()+aj._textRenderer.height*Math.cos(aj._textRenderer.angle)/2}break;case"middle":ab=-aj.getHeight()/2;break;default:ab=-aj.getHeight()/2;break}}else{ab=-aj.getHeight()/2}var at=this.u2p(aj.value)+ab+"px";aj._elem.css("top",at);aj.pack()}}if(ak){var ap=this._label._elem.outerHeight(true);this._label._elem.css("top",ai-ae/2-ap/2+"px");if(this.name=="yaxis"){this._label._elem.css("left","0px")}else{this._label._elem.css("right","0px")}this._label.pack()}}}ar=null};function h(ac){var ab;ac=Math.abs(ac);if(ac>=10){ab="%d"}else{if(ac>1){if(ac===parseInt(ac,10)){ab="%d"}else{ab="%.1f"}}else{var ad=-Math.floor(Math.log(ac)/Math.LN10);ab="%."+ad+"f"}}return ab}var a=[0.1,0.2,0.3,0.4,0.5,0.8,1,2,3,4,5];var b=function(ac){var ab=a.indexOf(ac);if(ab>0){return a[ab-1]}else{return a[a.length-1]/100}};var i=function(ac){var ab=a.indexOf(ac);if(ab<a.length-1){return a[ab+1]}else{return a[0]*100}};function c(af,an,am){var ak=Math.floor(am/2);var ac=Math.ceil(am*1.5);var ae=Number.MAX_VALUE;var ab=(an-af);var aq;var aj;var al;var ar=H.jqplot.getSignificantFigures;var ap;var ah;var ai;var ao;for(var ag=0,ad=ac-ak+1;ag<ad;ag++){ai=ak+ag;aq=ab/(ai-1);aj=ar(aq);aq=Math.abs(am-ai)+aj.digitsRight;if(aq<ae){ae=aq;al=ai;ao=aj.digitsRight}else{if(aq===ae){if(aj.digitsRight<ao){al=ai;ao=aj.digitsRight}}}}ap=Math.max(ao,Math.max(ar(af).digitsRight,ar(an).digitsRight));if(ap===0){ah="%d"}else{ah="%."+ap+"f"}aq=ab/(al-1);return[af,an,al,ah,aq]}function S(ac,af){af=af||7;var ae=ac/(af-1);var ad=Math.pow(10,Math.floor(Math.log(ae)/Math.LN10));var ag=ae/ad;var ab;if(ad<1){if(ag>5){ab=10*ad}else{if(ag>2){ab=5*ad}else{if(ag>1){ab=2*ad}else{ab=ad}}}}else{if(ag>5){ab=10*ad}else{if(ag>4){ab=5*ad}else{if(ag>3){ab=4*ad}else{if(ag>2){ab=3*ad}else{if(ag>1){ab=2*ad}else{ab=ad}}}}}}return ab}function M(ac,ab){ab=ab||1;var ae=Math.floor(Math.log(ac)/Math.LN10);var ag=Math.pow(10,ae);var af=ac/ag;var ad;af=af/ab;if(af<=0.38){ad=0.1}else{if(af<=1.6){ad=0.2}else{if(af<=4){ad=0.5}else{if(af<=8){ad=1}else{if(af<=16){ad=2}else{ad=5}}}}}return ad*ag}function t(ad,ac){var af=Math.floor(Math.log(ad)/Math.LN10);var ah=Math.pow(10,af);var ag=ad/ah;var ab;var ae;ag=ag/ac;if(ag<=0.38){ae=0.1}else{if(ag<=1.6){ae=0.2}else{if(ag<=4){ae=0.5}else{if(ag<=8){ae=1}else{if(ag<=16){ae=2}else{ae=5}}}}}ab=ae*ah;return[ab,ae,ah]}H.jqplot.LinearTickGenerator=function(ah,ak,ad,ae,ai,al){ai=(ai===null)?false:ai;al=(al===null||ai)?false:al;if(ah===ak){ak=(ak)?0:1}ad=ad||1;if(ak<ah){var am=ak;ak=ah;ah=am}var ac=[];var ap=M(ak-ah,ad);var ao=H.jqplot.getSignificantFigures;if(ae==null){if(!ai&&!al){ac[0]=Math.floor(ah/ap)*ap;ac[1]=Math.ceil(ak/ap)*ap;ac[2]=Math.round((ac[1]-ac[0])/ap+1);ac[3]=h(ap);ac[4]=ap}else{if(ai){ac[0]=ah;ac[2]=Math.ceil((ak-ah)/ap+1);ac[1]=ah+(ac[2]-1)*ap;var an=ao(ah).digitsRight;var aj=ao(ap).digitsRight;if(an<aj){ac[3]=h(ap)}else{ac[3]="%."+an+"f"}ac[4]=ap}else{if(al){ac[1]=ak;ac[2]=Math.ceil((ak-ah)/ap+1);ac[0]=ak-(ac[2]-1)*ap;var af=ao(ak).digitsRight;var aj=ao(ap).digitsRight;if(af<aj){ac[3]=h(ap)}else{ac[3]="%."+af+"f"}ac[4]=ap}}}}else{var ag=[];ag[0]=Math.floor(ah/ap)*ap;ag[1]=Math.ceil(ak/ap)*ap;ag[2]=Math.round((ag[1]-ag[0])/ap+1);ag[3]=h(ap);ag[4]=ap;if(ag[2]===ae){ac=ag}else{var ab=S(ag[1]-ag[0],ae);ac[0]=ag[0];ac[2]=ae;ac[4]=ab;ac[3]=h(ab);ac[1]=ac[0]+(ac[2]-1)*ac[4]}}return ac};H.jqplot.LinearTickGenerator.bestLinearInterval=M;H.jqplot.LinearTickGenerator.bestInterval=S;H.jqplot.LinearTickGenerator.bestLinearComponents=t;H.jqplot.LinearTickGenerator.bestConstrainedInterval=c;H.jqplot.MarkerRenderer=function(ab){this.show=true;this.style="filledCircle";this.lineWidth=2;this.size=9;this.color="#666666";this.shadow=true;this.shadowAngle=45;this.shadowOffset=1;this.shadowDepth=3;this.shadowAlpha="0.07";this.shadowRenderer=new H.jqplot.ShadowRenderer();this.shapeRenderer=new H.jqplot.ShapeRenderer();H.extend(true,this,ab)};H.jqplot.MarkerRenderer.prototype.init=function(ab){H.extend(true,this,ab);var ad={angle:this.shadowAngle,offset:this.shadowOffset,alpha:this.shadowAlpha,lineWidth:this.lineWidth,depth:this.shadowDepth,closePath:true};if(this.style.indexOf("filled")!=-1){ad.fill=true}if(this.style.indexOf("ircle")!=-1){ad.isarc=true;ad.closePath=false}this.shadowRenderer.init(ad);var ac={fill:false,isarc:false,strokeStyle:this.color,fillStyle:this.color,lineWidth:this.lineWidth,closePath:true};if(this.style.indexOf("filled")!=-1){ac.fill=true}if(this.style.indexOf("ircle")!=-1){ac.isarc=true;ac.closePath=false}this.shapeRenderer.init(ac)};H.jqplot.MarkerRenderer.prototype.drawDiamond=function(ad,ac,ag,af,ai){var ab=1.2;var aj=this.size/2/ab;var ah=this.size/2*ab;var ae=[[ad-aj,ac],[ad,ac+ah],[ad+aj,ac],[ad,ac-ah]];if(this.shadow){this.shadowRenderer.draw(ag,ae)}this.shapeRenderer.draw(ag,ae,ai)};H.jqplot.MarkerRenderer.prototype.drawPlus=function(ae,ad,ah,ag,ak){var ac=1;var al=this.size/2*ac;var ai=this.size/2*ac;var aj=[[ae,ad-ai],[ae,ad+ai]];var af=[[ae+al,ad],[ae-al,ad]];var ab=H.extend(true,{},this.options,{closePath:false});if(this.shadow){this.shadowRenderer.draw(ah,aj,{closePath:false});this.shadowRenderer.draw(ah,af,{closePath:false})}this.shapeRenderer.draw(ah,aj,ab);this.shapeRenderer.draw(ah,af,ab)};H.jqplot.MarkerRenderer.prototype.drawX=function(ae,ad,ah,ag,ak){var ac=1;var al=this.size/2*ac;var ai=this.size/2*ac;var ab=H.extend(true,{},this.options,{closePath:false});var aj=[[ae-al,ad-ai],[ae+al,ad+ai]];var af=[[ae-al,ad+ai],[ae+al,ad-ai]];if(this.shadow){this.shadowRenderer.draw(ah,aj,{closePath:false});this.shadowRenderer.draw(ah,af,{closePath:false})}this.shapeRenderer.draw(ah,aj,ab);this.shapeRenderer.draw(ah,af,ab)};H.jqplot.MarkerRenderer.prototype.drawDash=function(ad,ac,ag,af,ai){var ab=1;var aj=this.size/2*ab;var ah=this.size/2*ab;var ae=[[ad-aj,ac],[ad+aj,ac]];if(this.shadow){this.shadowRenderer.draw(ag,ae)}this.shapeRenderer.draw(ag,ae,ai)};H.jqplot.MarkerRenderer.prototype.drawLine=function(ag,af,ab,ae,ac){var ad=[ag,af];if(this.shadow){this.shadowRenderer.draw(ab,ad)}this.shapeRenderer.draw(ab,ad,ac)};H.jqplot.MarkerRenderer.prototype.drawSquare=function(ad,ac,ag,af,ai){var ab=1;var aj=this.size/2/ab;var ah=this.size/2*ab;var ae=[[ad-aj,ac-ah],[ad-aj,ac+ah],[ad+aj,ac+ah],[ad+aj,ac-ah]];if(this.shadow){this.shadowRenderer.draw(ag,ae)}this.shapeRenderer.draw(ag,ae,ai)};H.jqplot.MarkerRenderer.prototype.drawCircle=function(ac,ai,ae,ah,af){var ab=this.size/2;var ad=2*Math.PI;var ag=[ac,ai,ab,0,ad,true];if(this.shadow){this.shadowRenderer.draw(ae,ag)}this.shapeRenderer.draw(ae,ag,af)};H.jqplot.MarkerRenderer.prototype.draw=function(ab,ae,ac,ad){ad=ad||{};if(ad.show==null||ad.show!=false){if(ad.color&&!ad.fillStyle){ad.fillStyle=ad.color}if(ad.color&&!ad.strokeStyle){ad.strokeStyle=ad.color}switch(this.style){case"diamond":this.drawDiamond(ab,ae,ac,false,ad);break;case"filledDiamond":this.drawDiamond(ab,ae,ac,true,ad);break;case"circle":this.drawCircle(ab,ae,ac,false,ad);break;case"filledCircle":this.drawCircle(ab,ae,ac,true,ad);break;case"square":this.drawSquare(ab,ae,ac,false,ad);break;case"filledSquare":this.drawSquare(ab,ae,ac,true,ad);break;case"x":this.drawX(ab,ae,ac,true,ad);break;case"plus":this.drawPlus(ab,ae,ac,true,ad);break;case"dash":this.drawDash(ab,ae,ac,true,ad);break;case"line":this.drawLine(ab,ae,ac,false,ad);break;default:this.drawDiamond(ab,ae,ac,false,ad);break}}};H.jqplot.ShadowRenderer=function(ab){this.angle=45;this.offset=1;this.alpha=0.07;this.lineWidth=1.5;this.lineJoin="miter";this.lineCap="round";this.closePath=false;this.fill=false;this.depth=3;this.strokeStyle="rgba(0,0,0,0.1)";this.isarc=false;H.extend(true,this,ab)};H.jqplot.ShadowRenderer.prototype.init=function(ab){H.extend(true,this,ab)};H.jqplot.ShadowRenderer.prototype.draw=function(ao,am,aq){ao.save();var ab=(aq!=null)?aq:{};var an=(ab.fill!=null)?ab.fill:this.fill;var aj=(ab.fillRect!=null)?ab.fillRect:this.fillRect;var ai=(ab.closePath!=null)?ab.closePath:this.closePath;var af=(ab.offset!=null)?ab.offset:this.offset;var ad=(ab.alpha!=null)?ab.alpha:this.alpha;var ah=(ab.depth!=null)?ab.depth:this.depth;var ap=(ab.isarc!=null)?ab.isarc:this.isarc;var ak=(ab.linePattern!=null)?ab.linePattern:this.linePattern;ao.lineWidth=(ab.lineWidth!=null)?ab.lineWidth:this.lineWidth;ao.lineJoin=(ab.lineJoin!=null)?ab.lineJoin:this.lineJoin;ao.lineCap=(ab.lineCap!=null)?ab.lineCap:this.lineCap;ao.strokeStyle=ab.strokeStyle||this.strokeStyle||"rgba(0,0,0,"+ad+")";ao.fillStyle=ab.fillStyle||this.fillStyle||"rgba(0,0,0,"+ad+")";for(var ae=0;ae<ah;ae++){var al=H.jqplot.LinePattern(ao,ak);ao.translate(Math.cos(this.angle*Math.PI/180)*af,Math.sin(this.angle*Math.PI/180)*af);al.beginPath();if(ap){ao.arc(am[0],am[1],am[2],am[3],am[4],true)}else{if(aj){if(aj){ao.fillRect(am[0],am[1],am[2],am[3])}}else{if(am&&am.length){var ac=true;for(var ag=0;ag<am.length;ag++){if(am[ag][0]!=null&&am[ag][1]!=null){if(ac){al.moveTo(am[ag][0],am[ag][1]);ac=false}else{al.lineTo(am[ag][0],am[ag][1])}}else{ac=true}}}}}if(ai){al.closePath()}if(an){ao.fill()}else{ao.stroke()}}ao.restore()};H.jqplot.ShapeRenderer=function(ab){this.lineWidth=1.5;this.linePattern="solid";this.lineJoin="miter";this.lineCap="round";this.closePath=false;this.fill=false;this.isarc=false;this.fillRect=false;this.strokeRect=false;this.clearRect=false;this.strokeStyle="#999999";this.fillStyle="#999999";H.extend(true,this,ab)};H.jqplot.ShapeRenderer.prototype.init=function(ab){H.extend(true,this,ab)};H.jqplot.ShapeRenderer.prototype.draw=function(am,ak,ao){am.save();var ab=(ao!=null)?ao:{};var al=(ab.fill!=null)?ab.fill:this.fill;var ag=(ab.closePath!=null)?ab.closePath:this.closePath;var ah=(ab.fillRect!=null)?ab.fillRect:this.fillRect;var ae=(ab.strokeRect!=null)?ab.strokeRect:this.strokeRect;var ac=(ab.clearRect!=null)?ab.clearRect:this.clearRect;var an=(ab.isarc!=null)?ab.isarc:this.isarc;var ai=(ab.linePattern!=null)?ab.linePattern:this.linePattern;var aj=H.jqplot.LinePattern(am,ai);am.lineWidth=ab.lineWidth||this.lineWidth;am.lineJoin=ab.lineJoin||this.lineJoin;am.lineCap=ab.lineCap||this.lineCap;am.strokeStyle=(ab.strokeStyle||ab.color)||this.strokeStyle;am.fillStyle=ab.fillStyle||this.fillStyle;am.beginPath();if(an){am.arc(ak[0],ak[1],ak[2],ak[3],ak[4],true);if(ag){am.closePath()}if(al){am.fill()}else{am.stroke()}am.restore();return}else{if(ac){am.clearRect(ak[0],ak[1],ak[2],ak[3]);am.restore();return}else{if(ah||ae){if(ah){am.fillRect(ak[0],ak[1],ak[2],ak[3])}if(ae){am.strokeRect(ak[0],ak[1],ak[2],ak[3]);am.restore();return}}else{if(ak&&ak.length){var ad=true;for(var af=0;af<ak.length;af++){if(ak[af][0]!=null&&ak[af][1]!=null){if(ad){aj.moveTo(ak[af][0],ak[af][1]);ad=false}else{aj.lineTo(ak[af][0],ak[af][1])}}else{ad=true}}if(ag){aj.closePath()}if(al){am.fill()}else{am.stroke()}}}}}am.restore()};H.jqplot.TableLegendRenderer=function(){};H.jqplot.TableLegendRenderer.prototype.init=function(ab){H.extend(true,this,ab)};H.jqplot.TableLegendRenderer.prototype.addrow=function(ak,ae,ab,ai){var af=(ab)?this.rowSpacing+"px":"0px";var aj;var ad;var ac;var ah;var ag;ac=document.createElement("tr");aj=H(ac);aj.addClass("jqplot-table-legend");ac=null;if(ai){aj.prependTo(this._elem)}else{aj.appendTo(this._elem)}if(this.showSwatches){ad=H(document.createElement("td"));ad.addClass("jqplot-table-legend jqplot-table-legend-swatch");ad.css({textAlign:"center",paddingTop:af});ah=H(document.createElement("div"));ah.addClass("jqplot-table-legend-swatch-outline");ag=H(document.createElement("div"));ag.addClass("jqplot-table-legend-swatch");ag.css({backgroundColor:ae,borderColor:ae});aj.append(ad.append(ah.append(ag)))}if(this.showLabels){ad=H(document.createElement("td"));ad.addClass("jqplot-table-legend jqplot-table-legend-label");ad.css("paddingTop",af);aj.append(ad);if(this.escapeHtml){ad.text(ak)}else{ad.html(ak)}}ad=null;ah=null;ag=null;aj=null;ac=null};H.jqplot.TableLegendRenderer.prototype.draw=function(){if(this._elem){this._elem.emptyForce();this._elem=null}if(this.show){var ag=this._series;var ac=document.createElement("table");this._elem=H(ac);this._elem.addClass("jqplot-table-legend");var al={position:"absolute"};if(this.background){al.background=this.background}if(this.border){al.border=this.border}if(this.fontSize){al.fontSize=this.fontSize}if(this.fontFamily){al.fontFamily=this.fontFamily}if(this.textColor){al.textColor=this.textColor}if(this.marginTop!=null){al.marginTop=this.marginTop}if(this.marginBottom!=null){al.marginBottom=this.marginBottom}if(this.marginLeft!=null){al.marginLeft=this.marginLeft}if(this.marginRight!=null){al.marginRight=this.marginRight}var ab=false,ai=false,ak;for(var ah=0;ah<ag.length;ah++){ak=ag[ah];if(ak._stack||ak.renderer.constructor==H.jqplot.BezierCurveRenderer){ai=true}if(ak.show&&ak.showLabel){var af=this.labels[ah]||ak.label.toString();if(af){var ad=ak.color;if(ai&&ah<ag.length-1){ab=true}else{if(ai&&ah==ag.length-1){ab=false}}this.renderer.addrow.call(this,af,ad,ab,ai);ab=true}for(var ae=0;ae<H.jqplot.addLegendRowHooks.length;ae++){var aj=H.jqplot.addLegendRowHooks[ae].call(this,ak);if(aj){this.renderer.addrow.call(this,aj.label,aj.color,ab);ab=true}}af=null}}}return this._elem};H.jqplot.TableLegendRenderer.prototype.pack=function(ad){if(this.show){if(this.placement=="insideGrid"){switch(this.location){case"nw":var ac=ad.left;var ab=ad.top;this._elem.css("left",ac);this._elem.css("top",ab);break;case"n":var ac=(ad.left+(this._plotDimensions.width-ad.right))/2-this.getWidth()/2;var ab=ad.top;this._elem.css("left",ac);this._elem.css("top",ab);break;case"ne":var ac=ad.right;var ab=ad.top;this._elem.css({right:ac,top:ab});break;case"e":var ac=ad.right;var ab=(ad.top+(this._plotDimensions.height-ad.bottom))/2-this.getHeight()/2;this._elem.css({right:ac,top:ab});break;case"se":var ac=ad.right;var ab=ad.bottom;this._elem.css({right:ac,bottom:ab});break;case"s":var ac=(ad.left+(this._plotDimensions.width-ad.right))/2-this.getWidth()/2;var ab=ad.bottom;this._elem.css({left:ac,bottom:ab});break;case"sw":var ac=ad.left;var ab=ad.bottom;this._elem.css({left:ac,bottom:ab});break;case"w":var ac=ad.left;var ab=(ad.top+(this._plotDimensions.height-ad.bottom))/2-this.getHeight()/2;this._elem.css({left:ac,top:ab});break;default:var ac=ad.right;var ab=ad.bottom;this._elem.css({right:ac,bottom:ab});break}}else{if(this.placement=="outside"){switch(this.location){case"nw":var ac=this._plotDimensions.width-ad.left;var ab=ad.top;this._elem.css("right",ac);this._elem.css("top",ab);break;case"n":var ac=(ad.left+(this._plotDimensions.width-ad.right))/2-this.getWidth()/2;var ab=this._plotDimensions.height-ad.top;this._elem.css("left",ac);this._elem.css("bottom",ab);break;case"ne":var ac=this._plotDimensions.width-ad.right;var ab=ad.top;this._elem.css({left:ac,top:ab});break;case"e":var ac=this._plotDimensions.width-ad.right;var ab=(ad.top+(this._plotDimensions.height-ad.bottom))/2-this.getHeight()/2;this._elem.css({left:ac,top:ab});break;case"se":var ac=this._plotDimensions.width-ad.right;var ab=ad.bottom;this._elem.css({left:ac,bottom:ab});break;case"s":var ac=(ad.left+(this._plotDimensions.width-ad.right))/2-this.getWidth()/2;var ab=this._plotDimensions.height-ad.bottom;this._elem.css({left:ac,top:ab});break;case"sw":var ac=this._plotDimensions.width-ad.left;var ab=ad.bottom;this._elem.css({right:ac,bottom:ab});break;case"w":var ac=this._plotDimensions.width-ad.left;var ab=(ad.top+(this._plotDimensions.height-ad.bottom))/2-this.getHeight()/2;this._elem.css({right:ac,top:ab});break;default:var ac=ad.right;var ab=ad.bottom;this._elem.css({right:ac,bottom:ab});break}}else{switch(this.location){case"nw":this._elem.css({left:0,top:ad.top});break;case"n":var ac=(ad.left+(this._plotDimensions.width-ad.right))/2-this.getWidth()/2;this._elem.css({left:ac,top:ad.top});break;case"ne":this._elem.css({right:0,top:ad.top});break;case"e":var ab=(ad.top+(this._plotDimensions.height-ad.bottom))/2-this.getHeight()/2;this._elem.css({right:ad.right,top:ab});break;case"se":this._elem.css({right:ad.right,bottom:ad.bottom});break;case"s":var ac=(ad.left+(this._plotDimensions.width-ad.right))/2-this.getWidth()/2;this._elem.css({left:ac,bottom:ad.bottom});break;case"sw":this._elem.css({left:ad.left,bottom:ad.bottom});break;case"w":var ab=(ad.top+(this._plotDimensions.height-ad.bottom))/2-this.getHeight()/2;this._elem.css({left:ad.left,top:ab});break;default:this._elem.css({right:ad.right,bottom:ad.bottom});break}}}}};H.jqplot.ThemeEngine=function(){this.themes={};this.activeTheme=null};H.jqplot.ThemeEngine.prototype.init=function(){var ae=new H.jqplot.Theme({_name:"Default"});var ah,ac,ag;for(ah in ae.target){if(ah=="textColor"){ae.target[ah]=this.target.css("color")}else{ae.target[ah]=this.target.css(ah)}}if(this.title.show&&this.title._elem){for(ah in ae.title){if(ah=="textColor"){ae.title[ah]=this.title._elem.css("color")}else{ae.title[ah]=this.title._elem.css(ah)}}}for(ah in ae.grid){ae.grid[ah]=this.grid[ah]}if(ae.grid.backgroundColor==null&&this.grid.background!=null){ae.grid.backgroundColor=this.grid.background}if(this.legend.show&&this.legend._elem){for(ah in ae.legend){if(ah=="textColor"){ae.legend[ah]=this.legend._elem.css("color")}else{ae.legend[ah]=this.legend._elem.css(ah)}}}var ad;for(ac=0;ac<this.series.length;ac++){ad=this.series[ac];if(ad.renderer.constructor==H.jqplot.LineRenderer){ae.series.push(new m())}else{if(ad.renderer.constructor==H.jqplot.BarRenderer){ae.series.push(new P())}else{if(ad.renderer.constructor==H.jqplot.PieRenderer){ae.series.push(new e())}else{if(ad.renderer.constructor==H.jqplot.DonutRenderer){ae.series.push(new C())}else{if(ad.renderer.constructor==H.jqplot.FunnelRenderer){ae.series.push(new U())}else{if(ad.renderer.constructor==H.jqplot.MeterGaugeRenderer){ae.series.push(new z())}else{ae.series.push({})}}}}}}for(ah in ae.series[ac]){ae.series[ac][ah]=ad[ah]}}var ab,af;for(ah in this.axes){af=this.axes[ah];ab=ae.axes[ah]=new L();ab.borderColor=af.borderColor;ab.borderWidth=af.borderWidth;if(af._ticks&&af._ticks[0]){for(ag in ab.ticks){if(af._ticks[0].hasOwnProperty(ag)){ab.ticks[ag]=af._ticks[0][ag]}else{if(af._ticks[0]._elem){ab.ticks[ag]=af._ticks[0]._elem.css(ag)}}}}if(af._label&&af._label.show){for(ag in ab.label){if(af._label[ag]){ab.label[ag]=af._label[ag]}else{if(af._label._elem){if(ag=="textColor"){ab.label[ag]=af._label._elem.css("color")}else{ab.label[ag]=af._label._elem.css(ag)}}}}}}this.themeEngine._add(ae);this.themeEngine.activeTheme=this.themeEngine.themes[ae._name]};H.jqplot.ThemeEngine.prototype.get=function(ab){if(!ab){return this.activeTheme}else{return this.themes[ab]}};function K(ac,ab){return ac-ab}H.jqplot.ThemeEngine.prototype.getThemeNames=function(){var ab=[];for(var ac in this.themes){ab.push(ac)}return ab.sort(K)};H.jqplot.ThemeEngine.prototype.getThemes=function(){var ac=[];var ab=[];for(var ae in this.themes){ac.push(ae)}ac.sort(K);for(var ad=0;ad<ac.length;ad++){ab.push(this.themes[ac[ad]])}return ab};H.jqplot.ThemeEngine.prototype.activate=function(ao,au){var ab=false;if(!au&&this.activeTheme&&this.activeTheme._name){au=this.activeTheme._name}if(!this.themes.hasOwnProperty(au)){throw new Error("No theme of that name")}else{var ag=this.themes[au];this.activeTheme=ag;var at,am=false,al=false;var ac=["xaxis","x2axis","yaxis","y2axis"];for(ap=0;ap<ac.length;ap++){var ah=ac[ap];if(ag.axesStyles.borderColor!=null){ao.axes[ah].borderColor=ag.axesStyles.borderColor}if(ag.axesStyles.borderWidth!=null){ao.axes[ah].borderWidth=ag.axesStyles.borderWidth}}for(var ar in ao.axes){var ae=ao.axes[ar];if(ae.show){var ak=ag.axes[ar]||{};var ai=ag.axesStyles;var af=H.jqplot.extend(true,{},ak,ai);at=(ag.axesStyles.borderColor!=null)?ag.axesStyles.borderColor:af.borderColor;if(af.borderColor!=null){ae.borderColor=af.borderColor;ab=true}at=(ag.axesStyles.borderWidth!=null)?ag.axesStyles.borderWidth:af.borderWidth;if(af.borderWidth!=null){ae.borderWidth=af.borderWidth;ab=true}if(ae._ticks&&ae._ticks[0]){for(var ad in af.ticks){at=af.ticks[ad];if(at!=null){ae.tickOptions[ad]=at;ae._ticks=[];ab=true}}}if(ae._label&&ae._label.show){for(var ad in af.label){at=af.label[ad];if(at!=null){ae.labelOptions[ad]=at;ab=true}}}}}for(var an in ag.grid){if(ag.grid[an]!=null){ao.grid[an]=ag.grid[an]}}if(!ab){ao.grid.draw()}if(ao.legend.show){for(an in ag.legend){if(ag.legend[an]!=null){ao.legend[an]=ag.legend[an]}}}if(ao.title.show){for(an in ag.title){if(ag.title[an]!=null){ao.title[an]=ag.title[an]}}}var ap;for(ap=0;ap<ag.series.length;ap++){var aj={};var aq=false;for(an in ag.series[ap]){at=(ag.seriesStyles[an]!=null)?ag.seriesStyles[an]:ag.series[ap][an];if(at!=null){aj[an]=at;if(an=="color"){ao.series[ap].renderer.shapeRenderer.fillStyle=at;ao.series[ap].renderer.shapeRenderer.strokeStyle=at;ao.series[ap][an]=at}else{if((an=="lineWidth")||(an=="linePattern")){ao.series[ap].renderer.shapeRenderer[an]=at;ao.series[ap][an]=at}else{if(an=="markerOptions"){R(ao.series[ap].markerOptions,at);R(ao.series[ap].markerRenderer,at)}else{ao.series[ap][an]=at}}}ab=true}}}if(ab){ao.target.empty();ao.draw()}for(an in ag.target){if(ag.target[an]!=null){ao.target.css(an,ag.target[an])}}}};H.jqplot.ThemeEngine.prototype._add=function(ac,ab){if(ab){ac._name=ab}if(!ac._name){ac._name=Date.parse(new Date())}if(!this.themes.hasOwnProperty(ac._name)){this.themes[ac._name]=ac}else{throw new Error("jqplot.ThemeEngine Error: Theme already in use")}};H.jqplot.ThemeEngine.prototype.remove=function(ab){if(ab=="Default"){return false}return delete this.themes[ab]};H.jqplot.ThemeEngine.prototype.newTheme=function(ab,ad){if(typeof(ab)=="object"){ad=ad||ab;ab=null}if(ad&&ad._name){ab=ad._name}else{ab=ab||Date.parse(new Date())}var ac=this.copy(this.themes.Default._name,ab);H.jqplot.extend(ac,ad);return ac};function x(ad){if(ad==null||typeof(ad)!="object"){return ad}var ab=new ad.constructor();for(var ac in ad){ab[ac]=x(ad[ac])}return ab}H.jqplot.clone=x;function R(ad,ac){if(ac==null||typeof(ac)!="object"){return}for(var ab in ac){if(ab=="highlightColors"){ad[ab]=x(ac[ab])}if(ac[ab]!=null&&typeof(ac[ab])=="object"){if(!ad.hasOwnProperty(ab)){ad[ab]={}}R(ad[ab],ac[ab])}else{ad[ab]=ac[ab]}}}H.jqplot.merge=R;H.jqplot.extend=function(){var ag=arguments[0]||{},ae=1,af=arguments.length,ab=false,ad;if(typeof ag==="boolean"){ab=ag;ag=arguments[1]||{};ae=2}if(typeof ag!=="object"&&!toString.call(ag)==="[object Function]"){ag={}}for(;ae<af;ae++){if((ad=arguments[ae])!=null){for(var ac in ad){var ah=ag[ac],ai=ad[ac];if(ag===ai){continue}if(ab&&ai&&typeof ai==="object"&&!ai.nodeType){ag[ac]=H.jqplot.extend(ab,ah||(ai.length!=null?[]:{}),ai)}else{if(ai!==r){ag[ac]=ai}}}}}return ag};H.jqplot.ThemeEngine.prototype.rename=function(ac,ab){if(ac=="Default"||ab=="Default"){throw new Error("jqplot.ThemeEngine Error: Cannot rename from/to Default")}if(this.themes.hasOwnProperty(ab)){throw new Error("jqplot.ThemeEngine Error: New name already in use.")}else{if(this.themes.hasOwnProperty(ac)){var ad=this.copy(ac,ab);this.remove(ac);return ad}}throw new Error("jqplot.ThemeEngine Error: Old name or new name invalid")};H.jqplot.ThemeEngine.prototype.copy=function(ab,ad,af){if(ad=="Default"){throw new Error("jqplot.ThemeEngine Error: Cannot copy over Default theme")}if(!this.themes.hasOwnProperty(ab)){var ac="jqplot.ThemeEngine Error: Source name invalid";throw new Error(ac)}if(this.themes.hasOwnProperty(ad)){var ac="jqplot.ThemeEngine Error: Target name invalid";throw new Error(ac)}else{var ae=x(this.themes[ab]);ae._name=ad;H.jqplot.extend(true,ae,af);this._add(ae);return ae}};H.jqplot.Theme=function(ab,ac){if(typeof(ab)=="object"){ac=ac||ab;ab=null}ab=ab||Date.parse(new Date());this._name=ab;this.target={backgroundColor:null};this.legend={textColor:null,fontFamily:null,fontSize:null,border:null,background:null};this.title={textColor:null,fontFamily:null,fontSize:null,textAlign:null};this.seriesStyles={};this.series=[];this.grid={drawGridlines:null,gridLineColor:null,gridLineWidth:null,backgroundColor:null,borderColor:null,borderWidth:null,shadow:null};this.axesStyles={label:{},ticks:{}};this.axes={};if(typeof(ac)=="string"){this._name=ac}else{if(typeof(ac)=="object"){H.jqplot.extend(true,this,ac)}}};var L=function(){this.borderColor=null;this.borderWidth=null;this.ticks=new l();this.label=new q()};var l=function(){this.show=null;this.showGridline=null;this.showLabel=null;this.showMark=null;this.size=null;this.textColor=null;this.whiteSpace=null;this.fontSize=null;this.fontFamily=null};var q=function(){this.textColor=null;this.whiteSpace=null;this.fontSize=null;this.fontFamily=null;this.fontWeight=null};var m=function(){this.color=null;this.lineWidth=null;this.linePattern=null;this.shadow=null;this.fillColor=null;this.showMarker=null;this.markerOptions=new E()};var E=function(){this.show=null;this.style=null;this.lineWidth=null;this.size=null;this.color=null;this.shadow=null};var P=function(){this.color=null;this.seriesColors=null;this.lineWidth=null;this.shadow=null;this.barPadding=null;this.barMargin=null;this.barWidth=null;this.highlightColors=null};var e=function(){this.seriesColors=null;this.padding=null;this.sliceMargin=null;this.fill=null;this.shadow=null;this.startAngle=null;this.lineWidth=null;this.highlightColors=null};var C=function(){this.seriesColors=null;this.padding=null;this.sliceMargin=null;this.fill=null;this.shadow=null;this.startAngle=null;this.lineWidth=null;this.innerDiameter=null;this.thickness=null;this.ringMargin=null;this.highlightColors=null};var U=function(){this.color=null;this.lineWidth=null;this.shadow=null;this.padding=null;this.sectionMargin=null;this.seriesColors=null;this.highlightColors=null};var z=function(){this.padding=null;this.backgroundColor=null;this.ringColor=null;this.tickColor=null;this.ringWidth=null;this.intervalColors=null;this.intervalInnerRadius=null;this.intervalOuterRadius=null;this.hubRadius=null;this.needleThickness=null;this.needlePad=null};H.fn.jqplotChildText=function(){return H(this).contents().filter(function(){return this.nodeType==3}).text()};H.fn.jqplotGetComputedFontStyle=function(){var ae=window.getComputedStyle?window.getComputedStyle(this[0],""):this[0].currentStyle;var ac=ae["font-style"]?["font-style","font-weight","font-size","font-family"]:["fontStyle","fontWeight","fontSize","fontFamily"];var af=[];for(var ad=0;ad<ac.length;++ad){var ab=String(ae[ac[ad]]);if(ab&&ab!="normal"){af.push(ab)}}return af.join(" ")};H.fn.jqplotToImageCanvas=function(ad){ad=ad||{};var ao=(ad.x_offset==null)?0:ad.x_offset;var aq=(ad.y_offset==null)?0:ad.y_offset;var af=(ad.backgroundColor==null)?"rgb(255,255,255)":ad.backgroundColor;if(H(this).width()==0||H(this).height()==0){return null}if(H.jqplot.use_excanvas){return null}var ah=document.createElement("canvas");var au=H(this).outerHeight(true);var am=H(this).outerWidth(true);var ag=H(this).offset();var ai=ag.left;var ak=ag.top;var an=0,al=0;var ar=["jqplot-table-legend","jqplot-xaxis-tick","jqplot-x2axis-tick","jqplot-yaxis-tick","jqplot-y2axis-tick","jqplot-y3axis-tick","jqplot-y4axis-tick","jqplot-y5axis-tick","jqplot-y6axis-tick","jqplot-y7axis-tick","jqplot-y8axis-tick","jqplot-y9axis-tick","jqplot-xaxis-label","jqplot-x2axis-label","jqplot-yaxis-label","jqplot-y2axis-label","jqplot-y3axis-label","jqplot-y4axis-label","jqplot-y5axis-label","jqplot-y6axis-label","jqplot-y7axis-label","jqplot-y8axis-label","jqplot-y9axis-label"];var aj,ab,ac,av;for(var at=0;at<ar.length;at++){H(this).find("."+ar[at]).each(function(){aj=H(this).offset().top-ak;ab=H(this).offset().left-ai;av=ab+H(this).outerWidth(true)+an;ac=aj+H(this).outerHeight(true)+al;if(ab<-an){am=am-an-ab;an=-ab}if(aj<-al){au=au-al-aj;al=-aj}if(av>am){am=av}if(ac>au){au=ac}})}ah.width=am+Number(ao);ah.height=au+Number(aq);var ae=ah.getContext("2d");ae.save();ae.fillStyle=af;ae.fillRect(0,0,ah.width,ah.height);ae.restore();ae.translate(an,al);ae.textAlign="left";ae.textBaseline="top";function aw(ay){var az=parseInt(H(ay).css("line-height"),10);if(isNaN(az)){az=parseInt(H(ay).css("font-size"),10)*1.2}return az}function ax(az,ay,aM,aA,aI,aB){var aK=aw(az);var aE=H(az).innerWidth();var aF=H(az).innerHeight();var aH=aM.split(/\s+/);var aL=aH.length;var aJ="";var aG=[];var aO=aI;var aN=aA;for(var aD=0;aD<aL;aD++){aJ+=aH[aD];if(ay.measureText(aJ).width>aE){aG.push(aD);aJ="";aD--}}if(aG.length===0){if(H(az).css("textAlign")==="center"){aN=aA+(aB-ay.measureText(aJ).width)/2-an}ay.fillText(aM,aN,aI)}else{aJ=aH.slice(0,aG[0]).join(" ");if(H(az).css("textAlign")==="center"){aN=aA+(aB-ay.measureText(aJ).width)/2-an}ay.fillText(aJ,aN,aO);aO+=aK;for(var aD=1,aC=aG.length;aD<aC;aD++){aJ=aH.slice(aG[aD-1],aG[aD]).join(" ");if(H(az).css("textAlign")==="center"){aN=aA+(aB-ay.measureText(aJ).width)/2-an}ay.fillText(aJ,aN,aO);aO+=aK}aJ=aH.slice(aG[aD-1],aH.length).join(" ");if(H(az).css("textAlign")==="center"){aN=aA+(aB-ay.measureText(aJ).width)/2-an}ay.fillText(aJ,aN,aO)}}function ap(aA,aD,ay){var aH=aA.tagName.toLowerCase();var az=H(aA).position();var aE=window.getComputedStyle?window.getComputedStyle(aA,""):aA.currentStyle;var aC=aD+az.left+parseInt(aE.marginLeft,10)+parseInt(aE.borderLeftWidth,10)+parseInt(aE.paddingLeft,10);var aF=ay+az.top+parseInt(aE.marginTop,10)+parseInt(aE.borderTopWidth,10)+parseInt(aE.paddingTop,10);var aG=ah.width;if((aH=="div"||aH=="span")&&!H(aA).hasClass("jqplot-highlighter-tooltip")){H(aA).children().each(function(){ap(this,aC,aF)});var aI=H(aA).jqplotChildText();if(aI){ae.font=H(aA).jqplotGetComputedFontStyle();ae.fillStyle=H(aA).css("color");ax(aA,ae,aI,aC,aF,aG)}}else{if(aH==="table"&&H(aA).hasClass("jqplot-table-legend")){ae.strokeStyle=H(aA).css("border-top-color");ae.fillStyle=H(aA).css("background-color");ae.fillRect(aC,aF,H(aA).innerWidth(),H(aA).innerHeight());if(parseInt(H(aA).css("border-top-width"),10)>0){ae.strokeRect(aC,aF,H(aA).innerWidth(),H(aA).innerHeight())}H(aA).find("div.jqplot-table-legend-swatch-outline").each(function(){var aO=H(this);ae.strokeStyle=aO.css("border-top-color");var aK=aC+aO.position().left;var aL=aF+aO.position().top;ae.strokeRect(aK,aL,aO.innerWidth(),aO.innerHeight());aK+=parseInt(aO.css("padding-left"),10);aL+=parseInt(aO.css("padding-top"),10);var aN=aO.innerHeight()-2*parseInt(aO.css("padding-top"),10);var aJ=aO.innerWidth()-2*parseInt(aO.css("padding-left"),10);var aM=aO.children("div.jqplot-table-legend-swatch");ae.fillStyle=aM.css("background-color");ae.fillRect(aK,aL,aJ,aN)});H(aA).find("td.jqplot-table-legend-label").each(function(){var aL=H(this);var aJ=aC+aL.position().left;var aK=aF+aL.position().top+parseInt(aL.css("padding-top"),10);ae.font=aL.jqplotGetComputedFontStyle();ae.fillStyle=aL.css("color");ax(aL,ae,aL.text(),aJ,aK,aG)});var aB=null}else{if(aH=="canvas"){ae.drawImage(aA,aC,aF)}}}}H(this).children().each(function(){ap(this,ao,aq)});return ah};H.fn.jqplotToImageStr=function(ac){var ab=H(this).jqplotToImageCanvas(ac);if(ab){return ab.toDataURL("image/png")}else{return null}};H.fn.jqplotToImageElem=function(ab){var ac=document.createElement("img");var ad=H(this).jqplotToImageStr(ab);ac.src=ad;return ac};H.fn.jqplotToImageElemStr=function(ab){var ac="<img src="+H(this).jqplotToImageStr(ab)+" />";return ac};H.fn.jqplotSaveImage=function(){var ab=H(this).jqplotToImageStr({});if(ab){window.location.href=ab.replace("image/png","image/octet-stream")}};H.fn.jqplotViewImage=function(){var ac=H(this).jqplotToImageElemStr({});var ad=H(this).jqplotToImageStr({});if(ac){var ab=window.open("");ab.document.open("image/png");ab.document.write(ac);ab.document.close();ab=null}};var aa=function(){this.syntax=aa.config.syntax;this._type="jsDate";this.proxy=new Date();this.options={};this.locale=aa.regional.getLocale();this.formatString="";this.defaultCentury=aa.config.defaultCentury;switch(arguments.length){case 0:break;case 1:if(j(arguments[0])=="[object Object]"&&arguments[0]._type!="jsDate"){var ad=this.options=arguments[0];this.syntax=ad.syntax||this.syntax;this.defaultCentury=ad.defaultCentury||this.defaultCentury;this.proxy=aa.createDate(ad.date)}else{this.proxy=aa.createDate(arguments[0])}break;default:var ab=[];for(var ac=0;ac<arguments.length;ac++){ab.push(arguments[ac])}this.proxy=new Date();this.proxy.setFullYear.apply(this.proxy,ab.slice(0,3));if(ab.slice(3).length){this.proxy.setHours.apply(this.proxy,ab.slice(3))}break}};aa.config={defaultLocale:"en",syntax:"perl",defaultCentury:1900};aa.prototype.add=function(ad,ac){var ab=A[ac]||A.day;if(typeof ab=="number"){this.proxy.setTime(this.proxy.getTime()+(ab*ad))}else{ab.add(this,ad)}return this};aa.prototype.clone=function(){return new aa(this.proxy.getTime())};aa.prototype.getUtcOffset=function(){return this.proxy.getTimezoneOffset()*60000};aa.prototype.diff=function(ac,af,ab){ac=new aa(ac);if(ac===null){return null}var ad=A[af]||A.day;if(typeof ad=="number"){var ae=(this.proxy.getTime()-ac.proxy.getTime())/ad}else{var ae=ad.diff(this.proxy,ac.proxy)}return(ab?ae:Math[ae>0?"floor":"ceil"](ae))};aa.prototype.getAbbrDayName=function(){return aa.regional[this.locale]["dayNamesShort"][this.proxy.getDay()]};aa.prototype.getAbbrMonthName=function(){return aa.regional[this.locale]["monthNamesShort"][this.proxy.getMonth()]};aa.prototype.getAMPM=function(){return this.proxy.getHours()>=12?"PM":"AM"};aa.prototype.getAmPm=function(){return this.proxy.getHours()>=12?"pm":"am"};aa.prototype.getCentury=function(){return parseInt(this.proxy.getFullYear()/100,10)};aa.prototype.getDate=function(){return this.proxy.getDate()};aa.prototype.getDay=function(){return this.proxy.getDay()};aa.prototype.getDayOfWeek=function(){var ab=this.proxy.getDay();return ab===0?7:ab};aa.prototype.getDayOfYear=function(){var ac=this.proxy;var ab=ac-new Date(""+ac.getFullYear()+"/1/1 GMT");ab+=ac.getTimezoneOffset()*60000;ac=null;return parseInt(ab/60000/60/24,10)+1};aa.prototype.getDayName=function(){return aa.regional[this.locale]["dayNames"][this.proxy.getDay()]};aa.prototype.getFullWeekOfYear=function(){var ae=this.proxy;var ab=this.getDayOfYear();var ad=6-ae.getDay();var ac=parseInt((ab+ad)/7,10);return ac};aa.prototype.getFullYear=function(){return this.proxy.getFullYear()};aa.prototype.getGmtOffset=function(){var ab=this.proxy.getTimezoneOffset()/60;var ac=ab<0?"+":"-";ab=Math.abs(ab);return ac+J(Math.floor(ab),2)+":"+J((ab%1)*60,2)};aa.prototype.getHours=function(){return this.proxy.getHours()};aa.prototype.getHours12=function(){var ab=this.proxy.getHours();return ab>12?ab-12:(ab==0?12:ab)};aa.prototype.getIsoWeek=function(){var ae=this.proxy;var ad=ae.getWeekOfYear();var ab=(new Date(""+ae.getFullYear()+"/1/1")).getDay();var ac=ad+(ab>4||ab<=1?0:1);if(ac==53&&(new Date(""+ae.getFullYear()+"/12/31")).getDay()<4){ac=1}else{if(ac===0){ae=new aa(new Date(""+(ae.getFullYear()-1)+"/12/31"));ac=ae.getIsoWeek()}}ae=null;return ac};aa.prototype.getMilliseconds=function(){return this.proxy.getMilliseconds()};aa.prototype.getMinutes=function(){return this.proxy.getMinutes()};aa.prototype.getMonth=function(){return this.proxy.getMonth()};aa.prototype.getMonthName=function(){return aa.regional[this.locale]["monthNames"][this.proxy.getMonth()]};aa.prototype.getMonthNumber=function(){return this.proxy.getMonth()+1};aa.prototype.getSeconds=function(){return this.proxy.getSeconds()};aa.prototype.getShortYear=function(){return this.proxy.getYear()%100};aa.prototype.getTime=function(){return this.proxy.getTime()};aa.prototype.getTimezoneAbbr=function(){return this.proxy.toString().replace(/^.*\(([^)]+)\)$/,"$1")};aa.prototype.getTimezoneName=function(){var ab=/(?:\((.+)\)$| ([A-Z]{3}) )/.exec(this.toString());return ab[1]||ab[2]||"GMT"+this.getGmtOffset()};aa.prototype.getTimezoneOffset=function(){return this.proxy.getTimezoneOffset()};aa.prototype.getWeekOfYear=function(){var ab=this.getDayOfYear();var ad=7-this.getDayOfWeek();var ac=parseInt((ab+ad)/7,10);return ac};aa.prototype.getUnix=function(){return Math.round(this.proxy.getTime()/1000,0)};aa.prototype.getYear=function(){return this.proxy.getYear()};aa.prototype.next=function(ab){ab=ab||"day";return this.clone().add(1,ab)};aa.prototype.set=function(){switch(arguments.length){case 0:this.proxy=new Date();break;case 1:if(j(arguments[0])=="[object Object]"&&arguments[0]._type!="jsDate"){var ad=this.options=arguments[0];this.syntax=ad.syntax||this.syntax;this.defaultCentury=ad.defaultCentury||this.defaultCentury;this.proxy=aa.createDate(ad.date)}else{this.proxy=aa.createDate(arguments[0])}break;default:var ab=[];for(var ac=0;ac<arguments.length;ac++){ab.push(arguments[ac])}this.proxy=new Date();this.proxy.setFullYear.apply(this.proxy,ab.slice(0,3));if(ab.slice(3).length){this.proxy.setHours.apply(this.proxy,ab.slice(3))}break}return this};aa.prototype.setDate=function(ab){this.proxy.setDate(ab);return this};aa.prototype.setFullYear=function(){this.proxy.setFullYear.apply(this.proxy,arguments);return this};aa.prototype.setHours=function(){this.proxy.setHours.apply(this.proxy,arguments);return this};aa.prototype.setMilliseconds=function(ab){this.proxy.setMilliseconds(ab);return this};aa.prototype.setMinutes=function(){this.proxy.setMinutes.apply(this.proxy,arguments);return this};aa.prototype.setMonth=function(){this.proxy.setMonth.apply(this.proxy,arguments);return this};aa.prototype.setSeconds=function(){this.proxy.setSeconds.apply(this.proxy,arguments);return this};aa.prototype.setTime=function(ab){this.proxy.setTime(ab);return this};aa.prototype.setYear=function(){this.proxy.setYear.apply(this.proxy,arguments);return this};aa.prototype.strftime=function(ab){ab=ab||this.formatString||aa.regional[this.locale]["formatString"];return aa.strftime(this,ab,this.syntax)};aa.prototype.toString=function(){return this.proxy.toString()};aa.prototype.toYmdInt=function(){return(this.proxy.getFullYear()*10000)+(this.getMonthNumber()*100)+this.proxy.getDate()};aa.regional={en:{monthNames:["January","February","March","April","May","June","July","August","September","October","November","December"],monthNamesShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],dayNames:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],dayNamesShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],formatString:"%Y-%m-%d %H:%M:%S"},fr:{monthNames:["Janvier","Février","Mars","Avril","Mai","Juin","Juillet","Août","Septembre","Octobre","Novembre","Décembre"],monthNamesShort:["Jan","Fév","Mar","Avr","Mai","Jun","Jul","Aoû","Sep","Oct","Nov","Déc"],dayNames:["Dimanche","Lundi","Mardi","Mercredi","Jeudi","Vendredi","Samedi"],dayNamesShort:["Dim","Lun","Mar","Mer","Jeu","Ven","Sam"],formatString:"%Y-%m-%d %H:%M:%S"},de:{monthNames:["Januar","Februar","März","April","Mai","Juni","Juli","August","September","Oktober","November","Dezember"],monthNamesShort:["Jan","Feb","Mär","Apr","Mai","Jun","Jul","Aug","Sep","Okt","Nov","Dez"],dayNames:["Sonntag","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag"],dayNamesShort:["So","Mo","Di","Mi","Do","Fr","Sa"],formatString:"%Y-%m-%d %H:%M:%S"},es:{monthNames:["Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"],monthNamesShort:["Ene","Feb","Mar","Abr","May","Jun","Jul","Ago","Sep","Oct","Nov","Dic"],dayNames:["Domingo","Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado"],dayNamesShort:["Dom","Lun","Mar","Mi&eacute;","Juv","Vie","S&aacute;b"],formatString:"%Y-%m-%d %H:%M:%S"},ru:{monthNames:["Январь","Февраль","Март","Апрель","Май","Июнь","Июль","Август","Сентябрь","Октябрь","Ноябрь","Декабрь"],monthNamesShort:["Янв","Фев","Мар","Апр","Май","Июн","Июл","Авг","Сен","Окт","Ноя","Дек"],dayNames:["воскресенье","понедельник","вторник","среда","четверг","пятница","суббота"],dayNamesShort:["вск","пнд","втр","срд","чтв","птн","сбт"],formatString:"%Y-%m-%d %H:%M:%S"},ar:{monthNames:["كانون الثاني","شباط","آذار","نيسان","آذار","حزيران","تموز","آب","أيلول","تشرين الأول","تشرين الثاني","كانون الأول"],monthNamesShort:["1","2","3","4","5","6","7","8","9","10","11","12"],dayNames:["السبت","الأحد","الاثنين","الثلاثاء","الأربعاء","الخميس","الجمعة"],dayNamesShort:["سبت","أحد","اثنين","ثلاثاء","أربعاء","خميس","جمعة"],formatString:"%Y-%m-%d %H:%M:%S"},pt:{monthNames:["Janeiro","Fevereiro","Mar&ccedil;o","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"],monthNamesShort:["Jan","Fev","Mar","Abr","Mai","Jun","Jul","Ago","Set","Out","Nov","Dez"],dayNames:["Domingo","Segunda-feira","Ter&ccedil;a-feira","Quarta-feira","Quinta-feira","Sexta-feira","S&aacute;bado"],dayNamesShort:["Dom","Seg","Ter","Qua","Qui","Sex","S&aacute;b"],formatString:"%Y-%m-%d %H:%M:%S"},"pt-BR":{monthNames:["Janeiro","Fevereiro","Mar&ccedil;o","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"],monthNamesShort:["Jan","Fev","Mar","Abr","Mai","Jun","Jul","Ago","Set","Out","Nov","Dez"],dayNames:["Domingo","Segunda-feira","Ter&ccedil;a-feira","Quarta-feira","Quinta-feira","Sexta-feira","S&aacute;bado"],dayNamesShort:["Dom","Seg","Ter","Qua","Qui","Sex","S&aacute;b"],formatString:"%Y-%m-%d %H:%M:%S"}};aa.regional["en-US"]=aa.regional["en-GB"]=aa.regional.en;aa.regional.getLocale=function(){var ab=aa.config.defaultLocale;if(document&&document.getElementsByTagName("html")&&document.getElementsByTagName("html")[0].lang){ab=document.getElementsByTagName("html")[0].lang;if(!aa.regional.hasOwnProperty(ab)){ab=aa.config.defaultLocale}}return ab};var y=24*60*60*1000;var J=function(ab,ae){ab=String(ab);var ac=ae-ab.length;var ad=String(Math.pow(10,ac)).slice(1);return ad.concat(ab)};var A={millisecond:1,second:1000,minute:60*1000,hour:60*60*1000,day:y,week:7*y,month:{add:function(ad,ab){A.year.add(ad,Math[ab>0?"floor":"ceil"](ab/12));var ac=ad.getMonth()+(ab%12);if(ac==12){ac=0;ad.setYear(ad.getFullYear()+1)}else{if(ac==-1){ac=11;ad.setYear(ad.getFullYear()-1)}}ad.setMonth(ac)},diff:function(af,ad){var ab=af.getFullYear()-ad.getFullYear();var ac=af.getMonth()-ad.getMonth()+(ab*12);var ae=af.getDate()-ad.getDate();return ac+(ae/30)}},year:{add:function(ac,ab){ac.setYear(ac.getFullYear()+Math[ab>0?"floor":"ceil"](ab))},diff:function(ac,ab){return A.month.diff(ac,ab)/12}}};for(var T in A){if(T.substring(T.length-1)!="s"){A[T+"s"]=A[T]}}var D=function(af,ae,ac){if(aa.formats[ac]["shortcuts"][ae]){return aa.strftime(af,aa.formats[ac]["shortcuts"][ae],ac)}else{var ab=(aa.formats[ac]["codes"][ae]||"").split(".");var ad=af["get"+ab[0]]?af["get"+ab[0]]():"";if(ab[1]){ad=J(ad,ab[1])}return ad}};aa.strftime=function(ah,ae,ad,ai){var ac="perl";var ag=aa.regional.getLocale();if(ad&&aa.formats.hasOwnProperty(ad)){ac=ad}else{if(ad&&aa.regional.hasOwnProperty(ad)){ag=ad}}if(ai&&aa.formats.hasOwnProperty(ai)){ac=ai}else{if(ai&&aa.regional.hasOwnProperty(ai)){ag=ai}}if(j(ah)!="[object Object]"||ah._type!="jsDate"){ah=new aa(ah);ah.locale=ag}if(!ae){ae=ah.formatString||aa.regional[ag]["formatString"]}var ab=ae||"%Y-%m-%d",aj="",af;while(ab.length>0){if(af=ab.match(aa.formats[ac].codes.matcher)){aj+=ab.slice(0,af.index);aj+=(af[1]||"")+D(ah,af[2],ac);ab=ab.slice(af.index+af[0].length)}else{aj+=ab;ab=""}}return aj};aa.formats={ISO:"%Y-%m-%dT%H:%M:%S.%N%G",SQL:"%Y-%m-%d %H:%M:%S"};aa.formats.perl={codes:{matcher:/()%(#?(%|[a-z]))/i,Y:"FullYear",y:"ShortYear.2",m:"MonthNumber.2","#m":"MonthNumber",B:"MonthName",b:"AbbrMonthName",d:"Date.2","#d":"Date",e:"Date",A:"DayName",a:"AbbrDayName",w:"Day",H:"Hours.2","#H":"Hours",I:"Hours12.2","#I":"Hours12",p:"AMPM",M:"Minutes.2","#M":"Minutes",S:"Seconds.2","#S":"Seconds",s:"Unix",N:"Milliseconds.3","#N":"Milliseconds",O:"TimezoneOffset",Z:"TimezoneName",G:"GmtOffset"},shortcuts:{F:"%Y-%m-%d",T:"%H:%M:%S",X:"%H:%M:%S",x:"%m/%d/%y",D:"%m/%d/%y","#c":"%a %b %e %H:%M:%S %Y",v:"%e-%b-%Y",R:"%H:%M",r:"%I:%M:%S %p",t:"\t",n:"\n","%":"%"}};aa.formats.php={codes:{matcher:/()%((%|[a-z]))/i,a:"AbbrDayName",A:"DayName",d:"Date.2",e:"Date",j:"DayOfYear.3",u:"DayOfWeek",w:"Day",U:"FullWeekOfYear.2",V:"IsoWeek.2",W:"WeekOfYear.2",b:"AbbrMonthName",B:"MonthName",m:"MonthNumber.2",h:"AbbrMonthName",C:"Century.2",y:"ShortYear.2",Y:"FullYear",H:"Hours.2",I:"Hours12.2",l:"Hours12",p:"AMPM",P:"AmPm",M:"Minutes.2",S:"Seconds.2",s:"Unix",O:"TimezoneOffset",z:"GmtOffset",Z:"TimezoneAbbr"},shortcuts:{D:"%m/%d/%y",F:"%Y-%m-%d",T:"%H:%M:%S",X:"%H:%M:%S",x:"%m/%d/%y",R:"%H:%M",r:"%I:%M:%S %p",t:"\t",n:"\n","%":"%"}};aa.createDate=function(ad){if(ad==null){return new Date()}if(ad instanceof Date){return ad}if(typeof ad=="number"){return new Date(ad)}var ai=String(ad).replace(/^\s*(.+)\s*$/g,"$1");ai=ai.replace(/^([0-9]{1,4})-([0-9]{1,2})-([0-9]{1,4})/,"$1/$2/$3");ai=ai.replace(/^(3[01]|[0-2]?\d)[-\/]([a-z]{3,})[-\/](\d{4})/i,"$1 $2 $3");var ah=ai.match(/^(3[01]|[0-2]?\d)[-\/]([a-z]{3,})[-\/](\d{2})\D*/i);if(ah&&ah.length>3){var am=parseFloat(ah[3]);var ag=aa.config.defaultCentury+am;ag=String(ag);ai=ai.replace(/^(3[01]|[0-2]?\d)[-\/]([a-z]{3,})[-\/](\d{2})\D*/i,ah[1]+" "+ah[2]+" "+ag)}ah=ai.match(/^([0-9]{1,2})[-\/]([0-9]{1,2})[-\/]([0-9]{1,2})[^0-9]/);function al(aq,ap){var aw=parseFloat(ap[1]);var av=parseFloat(ap[2]);var au=parseFloat(ap[3]);var at=aa.config.defaultCentury;var ao,an,ax,ar;if(aw>31){an=au;ax=av;ao=at+aw}else{an=av;ax=aw;ao=at+au}ar=ax+"/"+an+"/"+ao;return aq.replace(/^([0-9]{1,2})[-\/]([0-9]{1,2})[-\/]([0-9]{1,2})/,ar)}if(ah&&ah.length>3){ai=al(ai,ah)}var ah=ai.match(/^([0-9]{1,2})[-\/]([0-9]{1,2})[-\/]([0-9]{1,2})$/);if(ah&&ah.length>3){ai=al(ai,ah)}var af=0;var ac=aa.matchers.length;var ak,ab,aj=ai,ae;while(af<ac){ab=Date.parse(aj);if(!isNaN(ab)){return new Date(ab)}ak=aa.matchers[af];if(typeof ak=="function"){ae=ak.call(aa,aj);if(ae instanceof Date){return ae}}else{aj=ai.replace(ak[0],ak[1])}af++}return NaN};aa.daysInMonth=function(ab,ac){if(ac==2){return new Date(ab,1,29).getDate()==29?29:28}return[r,31,r,31,30,31,30,31,31,30,31,30,31][ac]};aa.matchers=[[/(3[01]|[0-2]\d)\s*\.\s*(1[0-2]|0\d)\s*\.\s*([1-9]\d{3})/,"$2/$1/$3"],[/([1-9]\d{3})\s*-\s*(1[0-2]|0\d)\s*-\s*(3[01]|[0-2]\d)/,"$2/$3/$1"],function(ae){var ac=ae.match(/^(?:(.+)\s+)?([012]?\d)(?:\s*\:\s*(\d\d))?(?:\s*\:\s*(\d\d(\.\d*)?))?\s*(am|pm)?\s*$/i);if(ac){if(ac[1]){var ad=this.createDate(ac[1]);if(isNaN(ad)){return}}else{var ad=new Date();ad.setMilliseconds(0)}var ab=parseFloat(ac[2]);if(ac[6]){ab=ac[6].toLowerCase()=="am"?(ab==12?0:ab):(ab==12?12:ab+12)}ad.setHours(ab,parseInt(ac[3]||0,10),parseInt(ac[4]||0,10),((parseFloat(ac[5]||0))||0)*1000);return ad}else{return ae}},function(ae){var ac=ae.match(/^(?:(.+))[T|\s+]([012]\d)(?:\:(\d\d))(?:\:(\d\d))(?:\.\d+)([\+\-]\d\d\:\d\d)$/i);if(ac){if(ac[1]){var ad=this.createDate(ac[1]);if(isNaN(ad)){return}}else{var ad=new Date();ad.setMilliseconds(0)}var ab=parseFloat(ac[2]);ad.setHours(ab,parseInt(ac[3],10),parseInt(ac[4],10),parseFloat(ac[5])*1000);return ad}else{return ae}},function(af){var ad=af.match(/^([0-3]?\d)\s*[-\/.\s]{1}\s*([a-zA-Z]{3,9})\s*[-\/.\s]{1}\s*([0-3]?\d)$/);if(ad){var ae=new Date();var ag=aa.config.defaultCentury;var ai=parseFloat(ad[1]);var ah=parseFloat(ad[3]);var ac,ab,aj;if(ai>31){ab=ah;ac=ag+ai}else{ab=ai;ac=ag+ah}var aj=W(ad[2],aa.regional[aa.regional.getLocale()]["monthNamesShort"]);if(aj==-1){aj=W(ad[2],aa.regional[aa.regional.getLocale()]["monthNames"])}ae.setFullYear(ac,aj,ab);ae.setHours(0,0,0,0);return ae}else{return af}}];function W(ad,ae){if(ae.indexOf){return ae.indexOf(ad)}for(var ab=0,ac=ae.length;ab<ac;ab++){if(ae[ab]===ad){return ab}}return -1}function j(ab){if(ab===null){return"[object Null]"}return Object.prototype.toString.call(ab)}H.jsDate=aa;H.jqplot.sprintf=function(){function ah(an,aj,ak,am){var al=(an.length>=aj)?"":Array(1+aj-an.length>>>0).join(ak);return am?an+al:al+an}function ae(al){var ak=new String(al);for(var aj=10;aj>0;aj--){if(ak==(ak=ak.replace(/^(\d+)(\d{3})/,"$1"+H.jqplot.sprintf.thousandsSeparator+"$2"))){break}}return ak}function ad(ao,an,aq,al,am,ak){var ap=al-ao.length;if(ap>0){var aj=" ";if(ak){aj="&nbsp;"}if(aq||!am){ao=ah(ao,al,aj,aq)}else{ao=ao.slice(0,an.length)+ah("",ap,"0",true)+ao.slice(an.length)}}return ao}function ai(ar,ak,ap,al,aj,ao,aq,an){var am=ar>>>0;ap=ap&&am&&{"2":"0b","8":"0","16":"0x"}[ak]||"";ar=ap+ah(am.toString(ak),ao||0,"0",false);return ad(ar,ap,al,aj,aq,an)}function ab(an,ao,al,aj,am,ak){if(aj!=null){an=an.slice(0,aj)}return ad(an,"",ao,al,am,ak)}var ac=arguments,af=0,ag=ac[af++];return ag.replace(H.jqplot.sprintf.regex,function(aG,aq,ar,av,aI,aD,ao){if(aG=="%%"){return"%"}var ax=false,at="",au=false,aF=false,ap=false,an=false;for(var aC=0;ar&&aC<ar.length;aC++){switch(ar.charAt(aC)){case" ":at=" ";break;case"+":at="+";break;case"-":ax=true;break;case"0":au=true;break;case"#":aF=true;break;case"&":ap=true;break;case"'":an=true;break}}if(!av){av=0}else{if(av=="*"){av=+ac[af++]}else{if(av.charAt(0)=="*"){av=+ac[av.slice(1,-1)]}else{av=+av}}}if(av<0){av=-av;ax=true}if(!isFinite(av)){throw new Error("$.jqplot.sprintf: (minimum-)width must be finite")}if(!aD){aD="fFeE".indexOf(ao)>-1?6:(ao=="d")?0:void (0)}else{if(aD=="*"){aD=+ac[af++]}else{if(aD.charAt(0)=="*"){aD=+ac[aD.slice(1,-1)]}else{aD=+aD}}}var az=aq?ac[aq.slice(0,-1)]:ac[af++];switch(ao){case"s":if(az==null){return""}return ab(String(az),ax,av,aD,au,ap);case"c":return ab(String.fromCharCode(+az),ax,av,aD,au,ap);case"b":return ai(az,2,aF,ax,av,aD,au,ap);case"o":return ai(az,8,aF,ax,av,aD,au,ap);case"x":return ai(az,16,aF,ax,av,aD,au,ap);case"X":return ai(az,16,aF,ax,av,aD,au,ap).toUpperCase();case"u":return ai(az,10,aF,ax,av,aD,au,ap);case"i":var al=parseInt(+az,10);if(isNaN(al)){return""}var aB=al<0?"-":at;var aE=an?ae(String(Math.abs(al))):String(Math.abs(al));az=aB+ah(aE,aD,"0",false);return ad(az,aB,ax,av,au,ap);case"d":var al=Math.round(+az);if(isNaN(al)){return""}var aB=al<0?"-":at;var aE=an?ae(String(Math.abs(al))):String(Math.abs(al));az=aB+ah(aE,aD,"0",false);return ad(az,aB,ax,av,au,ap);case"e":case"E":case"f":case"F":case"g":case"G":var al=+az;if(isNaN(al)){return""}var aB=al<0?"-":at;var am=["toExponential","toFixed","toPrecision"]["efg".indexOf(ao.toLowerCase())];var aH=["toString","toUpperCase"]["eEfFgG".indexOf(ao)%2];var aE=Math.abs(al)[am](aD);aE=an?ae(aE):aE;az=aB+aE;var aw=ad(az,aB,ax,av,au,ap)[aH]();if(H.jqplot.sprintf.decimalMark!=="."&&H.jqplot.sprintf.decimalMark!==H.jqplot.sprintf.thousandsSeparator){return aw.replace(/\./,H.jqplot.sprintf.decimalMark)}else{return aw}case"p":case"P":var al=+az;if(isNaN(al)){return""}var aB=al<0?"-":at;var ay=String(Number(Math.abs(al)).toExponential()).split(/e|E/);var ak=(ay[0].indexOf(".")!=-1)?ay[0].length-1:ay[0].length;var aA=(ay[1]<0)?-ay[1]-1:0;if(Math.abs(al)<1){if(ak+aA<=aD){az=aB+Math.abs(al).toPrecision(ak)}else{if(ak<=aD-1){az=aB+Math.abs(al).toExponential(ak-1)}else{az=aB+Math.abs(al).toExponential(aD-1)}}}else{var aj=(ak<=aD)?ak:aD;az=aB+Math.abs(al).toPrecision(aj)}var aH=["toString","toUpperCase"]["pP".indexOf(ao)%2];return ad(az,aB,ax,av,au,ap)[aH]();case"n":return"";default:return aG}})};H.jqplot.sprintf.thousandsSeparator=",";H.jqplot.sprintf.decimalMark=".";H.jqplot.sprintf.regex=/%%|%(\d+\$)?([-+#0&\' ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([nAscboxXuidfegpEGP])/g;H.jqplot.getSignificantFigures=function(af){var ah=String(Number(Math.abs(af)).toExponential()).split(/e|E/);var ag=(ah[0].indexOf(".")!=-1)?ah[0].length-1:ah[0].length;var ac=(ah[1]<0)?-ah[1]-1:0;var ab=parseInt(ah[1],10);var ad=(ab+1>0)?ab+1:0;var ae=(ag<=ad)?0:ag-ab-1;return{significantDigits:ag,digitsLeft:ad,digitsRight:ae,zeros:ac,exponent:ab}};H.jqplot.getPrecision=function(ab){return H.jqplot.getSignificantFigures(ab).digitsRight}})(jQuery);var backCompat=$.uiBackCompat!==false;$.jqplot.effects={effect:{}};var dataSpace="jqplot.storage.";$.extend($.jqplot.effects,{version:"1.9pre",save:function(b,c){for(var a=0;a<c.length;a++){if(c[a]!==null){b.data(dataSpace+c[a],b[0].style[c[a]])}}},restore:function(b,c){for(var a=0;a<c.length;a++){if(c[a]!==null){b.css(c[a],b.data(dataSpace+c[a]))}}},setMode:function(a,b){if(b==="toggle"){b=a.is(":hidden")?"show":"hide"}return b},createWrapper:function(b){if(b.parent().is(".ui-effects-wrapper")){return b.parent()}var c={width:b.outerWidth(true),height:b.outerHeight(true),"float":b.css("float")},e=$("<div></div>").addClass("ui-effects-wrapper").css({fontSize:"100%",background:"transparent",border:"none",margin:0,padding:0}),a={width:b.width(),height:b.height()},d=document.activeElement;b.wrap(e);if(b[0]===d||$.contains(b[0],d)){$(d).focus()}e=b.parent();if(b.css("position")==="static"){e.css({position:"relative"});b.css({position:"relative"})}else{$.extend(c,{position:b.css("position"),zIndex:b.css("z-index")});$.each(["top","left","bottom","right"],function(f,g){c[g]=b.css(g);if(isNaN(parseInt(c[g],10))){c[g]="auto"}});b.css({position:"relative",top:0,left:0,right:"auto",bottom:"auto"})}b.css(a);return e.css(c).show()},removeWrapper:function(a){var b=document.activeElement;if(a.parent().is(".ui-effects-wrapper")){a.parent().replaceWith(a);if(a[0]===b||$.contains(a[0],b)){$(b).focus()}}return a}});function _normalizeArguments(b,a,c,d){if($.isPlainObject(b)){return b}b={effect:b};if(a===undefined){a={}}if($.isFunction(a)){d=a;c=null;a={}}if($.type(a)==="number"||$.fx.speeds[a]){d=c;c=a;a={}}if($.isFunction(c)){d=c;c=null}if(a){$.extend(b,a)}c=c||a.duration;b.duration=$.fx.off?0:typeof c==="number"?c:c in $.fx.speeds?$.fx.speeds[c]:$.fx.speeds._default;b.complete=d||a.complete;return b}function standardSpeed(a){if(!a||typeof a==="number"||$.fx.speeds[a]){return true}if(typeof a==="string"&&!$.jqplot.effects.effect[a]){if(backCompat&&$.jqplot.effects[a]){return false}return true}return false}$.fn.extend({jqplotEffect:function(i,j,b,h){var g=_normalizeArguments.apply(this,arguments),d=g.mode,e=g.queue,f=$.jqplot.effects.effect[g.effect],a=!f&&backCompat&&$.jqplot.effects[g.effect];if($.fx.off||!(f||a)){if(d){return this[d](g.duration,g.complete)}else{return this.each(function(){if(g.complete){g.complete.call(this)}})}}function c(m){var n=$(this),l=g.complete,o=g.mode;function k(){if($.isFunction(l)){l.call(n[0])}if($.isFunction(m)){m()}}if(n.is(":hidden")?o==="hide":o==="show"){k()}else{f.call(n[0],g,k)}}if(f){return e===false?this.each(c):this.queue(e||"fx",c)}else{return a.call(this,{options:g,duration:g.duration,callback:g.complete,mode:g.mode})}}});var rvertical=/up|down|vertical/,rpositivemotion=/up|left|vertical|horizontal/;$.jqplot.effects.effect.blind=function(c,h){var d=$(this),k=["position","top","bottom","left","right","height","width"],i=$.jqplot.effects.setMode(d,c.mode||"hide"),m=c.direction||"up",f=rvertical.test(m),e=f?"height":"width",j=f?"top":"left",p=rpositivemotion.test(m),g={},n=i==="show",b,a,l;if(d.parent().is(".ui-effects-wrapper")){$.jqplot.effects.save(d.parent(),k)}else{$.jqplot.effects.save(d,k)}d.show();l=parseInt(d.css("top"),10);b=$.jqplot.effects.createWrapper(d).css({overflow:"hidden"});a=f?b[e]()+l:b[e]();g[e]=n?String(a):"0";if(!p){d.css(f?"bottom":"right",0).css(f?"top":"left","").css({position:"absolute"});g[j]=n?"0":String(a)}if(n){b.css(e,0);if(!p){b.css(j,a)}}b.animate(g,{duration:c.duration,easing:c.easing,queue:false,complete:function(){if(i==="hide"){d.hide()}$.jqplot.effects.restore(d,k);$.jqplot.effects.removeWrapper(d);h()}})};/**
 * Background image plugin for jqplot
 *
 * Version: @VERSION
 * Revision: @REVISION
 *
 * Copyright (c) 2012 Observatoire de Paris
 *
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly.
 * 
 * BackgroundImage options:
 * show (default: false)
 * file (required)
 * coordinates : [x1, y1, x2, y2] (default: undefined)
 */
(function($) {
    
    // class: $.jqplot.BackgroundImage
    $.jqplot.BackgroundImage = function(opts) {
        this.options = opts || {};
        this.image = new Image();
        this.image.src = this.options.file;
        this.canvas = null;
    }
    
    $.jqplot.BackgroundImage.postPlotInit = function (target, data, opts) {
        // "this" is the plot
        var options = opts || {};
        this.plugins.backgroundImage = new $.jqplot.BackgroundImage(options.backgroundImage);
        if (this.options.backgroundImage && this.options.backgroundImage.show)
            this.grid.background = 'rgba(0,0,0,0)';
    };
    
    $.jqplot.BackgroundImage.prototype.draw = function(plot) {
        var p1, p2, rect, context, image;
        if (!this.options.show) {
            return;
        }
        context = this.canvas._ctx;
        if (this.options.coordinates) {
            context.clearRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
            p1 = { 'x': plot.axes['xaxis'].series_u2p(this.options.coordinates[0]),
                'y': plot.axes['yaxis'].series_u2p(this.options.coordinates[1]) };
            p2 = { 'x': plot.axes['xaxis'].series_u2p(this.options.coordinates[2]),
                'y': plot.axes['yaxis'].series_u2p(this.options.coordinates[3]) };
            rect = [ Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y) ];
        } else {
            rect = [0, 0, this.canvas.getWidth(), this.canvas.getHeight()];
        }
        if (this.image.complete)
            context.drawImage(this.image, rect[0], rect[1], rect[2], rect[3]);
        else {
            image = this.image;
            image.onload = function() {
                context.drawImage(image, rect[0], rect[1], rect[2], rect[3]);
            };
        }
    }
    
    $.jqplot.BackgroundImage.postPlotDraw = function() {
        // "this" is the plot
        if (!this.options.backgroundImage || !this.options.backgroundImage.show) {
            return;
        }
        var bi = this.plugins.backgroundImage;
        bi.canvas = new $.jqplot.GenericCanvas();
        $(this.grid._elem).before(bi.canvas.createElement(this._gridPadding, 'jqplot-backgroundImage-canvas', this._plotDimensions, this));
        bi.canvas.setContext();
        bi.draw(this);
    };
    
    $.jqplot.postInitHooks.push($.jqplot.BackgroundImage.postPlotInit);
    $.jqplot.postDrawHooks.push($.jqplot.BackgroundImage.postPlotDraw);
})(jQuery);
/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.1r1097
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 *
 * included jsDate library by Chris Leonello:
 *
 * Copyright (c) 2010-2011 Chris Leonello
 *
 * jsDate is currently available for use in all personal or commercial projects 
 * under both the MIT and GPL version 2.0 licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly.
 *
 * jsDate borrows many concepts and ideas from the Date Instance 
 * Methods by Ken Snyder along with some parts of Ken's actual code.
 * 
 * Ken's origianl Date Instance Methods and copyright notice:
 * 
 * Ken Snyder (ken d snyder at gmail dot com)
 * 2008-09-10
 * version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 * Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * jqplotToImage function based on Larry Siden's export-jqplot-to-png.js.
 * Larry has generously given permission to adapt his code for inclusion
 * into jqPlot.
 *
 * Larry's original code can be found here:
 *
 * https://github.com/lsiden/export-jqplot-to-png
 * 
 * 
 */
(function(d){d.jqplot.BarRenderer=function(){d.jqplot.LineRenderer.call(this)};d.jqplot.BarRenderer.prototype=new d.jqplot.LineRenderer();d.jqplot.BarRenderer.prototype.constructor=d.jqplot.BarRenderer;d.jqplot.BarRenderer.prototype.init=function(n,p){this.barPadding=8;this.barMargin=10;this.barDirection="vertical";this.barWidth=null;this.shadowOffset=2;this.shadowDepth=5;this.shadowAlpha=0.08;this.waterfall=false;this.groups=1;this.varyBarColor=false;this.highlightMouseOver=true;this.highlightMouseDown=false;this.highlightColors=[];this.transposedData=true;this.renderer.animation={show:false,direction:"down",speed:3000,_supported:true};this._type="bar";if(n.highlightMouseDown&&n.highlightMouseOver==null){n.highlightMouseOver=false}d.extend(true,this,n);d.extend(true,this.renderer,n);this.fill=true;if(this.barDirection==="horizontal"&&this.rendererOptions.animation&&this.rendererOptions.animation.direction==null){this.renderer.animation.direction="left"}if(this.waterfall){this.fillToZero=false;this.disableStack=true}if(this.barDirection=="vertical"){this._primaryAxis="_xaxis";this._stackAxis="y";this.fillAxis="y"}else{this._primaryAxis="_yaxis";this._stackAxis="x";this.fillAxis="x"}this._highlightedPoint=null;this._plotSeriesInfo=null;this._dataColors=[];this._barPoints=[];var o={lineJoin:"miter",lineCap:"round",fill:true,isarc:false,strokeStyle:this.color,fillStyle:this.color,closePath:this.fill};this.renderer.shapeRenderer.init(o);var m={lineJoin:"miter",lineCap:"round",fill:true,isarc:false,angle:this.shadowAngle,offset:this.shadowOffset,alpha:this.shadowAlpha,depth:this.shadowDepth,closePath:this.fill};this.renderer.shadowRenderer.init(m);p.postInitHooks.addOnce(h);p.postDrawHooks.addOnce(i);p.eventListenerHooks.addOnce("jqplotMouseMove",b);p.eventListenerHooks.addOnce("jqplotMouseDown",a);p.eventListenerHooks.addOnce("jqplotMouseUp",k);p.eventListenerHooks.addOnce("jqplotClick",e);p.eventListenerHooks.addOnce("jqplotRightClick",l)};function g(s,o,n,v){if(this.rendererOptions.barDirection=="horizontal"){this._stackAxis="x";this._primaryAxis="_yaxis"}if(this.rendererOptions.waterfall==true){this._data=d.extend(true,[],this.data);var r=0;var t=(!this.rendererOptions.barDirection||this.rendererOptions.barDirection==="vertical"||this.transposedData===false)?1:0;for(var p=0;p<this.data.length;p++){r+=this.data[p][t];if(p>0){this.data[p][t]+=this.data[p-1][t]}}this.data[this.data.length]=(t==1)?[this.data.length+1,r]:[r,this.data.length+1];this._data[this._data.length]=(t==1)?[this._data.length+1,r]:[r,this._data.length+1]}if(this.rendererOptions.groups>1){this.breakOnNull=true;var m=this.data.length;var u=parseInt(m/this.rendererOptions.groups,10);var q=0;for(var p=u;p<m;p+=u){this.data.splice(p+q,0,[null,null]);q++}for(p=0;p<this.data.length;p++){if(this._primaryAxis=="_xaxis"){this.data[p][0]=p+1}else{this.data[p][1]=p+1}}}}d.jqplot.preSeriesInitHooks.push(g);d.jqplot.BarRenderer.prototype.calcSeriesNumbers=function(){var q=0;var r=0;var p=this[this._primaryAxis];var o,n,t;for(var m=0;m<p._series.length;m++){n=p._series[m];if(n===this){t=m}if(n.renderer.constructor==d.jqplot.BarRenderer){q+=n.data.length;r+=1}}return[q,r,t]};d.jqplot.BarRenderer.prototype.setBarWidth=function(){var p;var m=0;var n=0;var r=this[this._primaryAxis];var w,q,u;var v=this._plotSeriesInfo=this.renderer.calcSeriesNumbers.call(this);m=v[0];n=v[1];var t=r.numberTicks;var o=(t-1)/2;if(r.name=="xaxis"||r.name=="x2axis"){if(this._stack){this.barWidth=(r._offsets.max-r._offsets.min)/m*n-this.barMargin}else{this.barWidth=((r._offsets.max-r._offsets.min)/o-this.barPadding*(n-1)-this.barMargin*2)/n}}else{if(this._stack){this.barWidth=(r._offsets.min-r._offsets.max)/m*n-this.barMargin}else{this.barWidth=((r._offsets.min-r._offsets.max)/o-this.barPadding*(n-1)-this.barMargin*2)/n}}return[m,n]};function f(n){var p=[];for(var r=0;r<n.length;r++){var q=d.jqplot.getColorComponents(n[r]);var m=[q[0],q[1],q[2]];var s=m[0]+m[1]+m[2];for(var o=0;o<3;o++){m[o]=(s>570)?m[o]*0.8:m[o]+0.3*(255-m[o]);m[o]=parseInt(m[o],10)}p.push("rgb("+m[0]+","+m[1]+","+m[2]+")")}return p}d.jqplot.BarRenderer.prototype.draw=function(D,J,p){var G;var z=d.extend({},p);var u=(z.shadow!=undefined)?z.shadow:this.shadow;var M=(z.showLine!=undefined)?z.showLine:this.showLine;var E=(z.fill!=undefined)?z.fill:this.fill;var o=this.xaxis;var H=this.yaxis;var x=this._xaxis.series_u2p;var I=this._yaxis.series_u2p;var C,B;this._dataColors=[];this._barPoints=[];if(this.barWidth==null){this.renderer.setBarWidth.call(this)}var L=this._plotSeriesInfo=this.renderer.calcSeriesNumbers.call(this);var w=L[0];var v=L[1];var r=L[2];var F=[];if(this._stack){this._barNudge=0}else{this._barNudge=(-Math.abs(v/2-0.5)+r)*(this.barWidth+this.barPadding)}if(M){var t=new d.jqplot.ColorGenerator(this.negativeSeriesColors);var A=new d.jqplot.ColorGenerator(this.seriesColors);var K=t.get(this.index);if(!this.useNegativeColors){K=z.fillStyle}var s=z.fillStyle;var q;var N;var n;if(this.barDirection=="vertical"){for(var G=0;G<J.length;G++){if(!this._stack&&this.data[G][1]==null){continue}F=[];q=J[G][0]+this._barNudge;n;if(this._stack&&this._prevGridData.length){n=this._prevGridData[G][1];if(n===null){n=this._yaxis.series_u2p(0)}}else{if(this.fillToZero){n=this._yaxis.series_u2p(0)}else{if(this.waterfall&&G>0&&G<this.gridData.length-1){n=this.gridData[G-1][1]}else{if(this.waterfall&&G==0&&G<this.gridData.length-1){if(this._yaxis.min<=0&&this._yaxis.max>=0){n=this._yaxis.series_u2p(0)}else{if(this._yaxis.min>0){n=D.canvas.height}else{n=0}}}else{if(this.waterfall&&G==this.gridData.length-1){if(this._yaxis.min<=0&&this._yaxis.max>=0){n=this._yaxis.series_u2p(0)}else{if(this._yaxis.min>0){n=D.canvas.height}else{n=0}}}else{n=D.canvas.height}}}}}if((this.fillToZero&&this._plotData[G][1]<0)||(this.waterfall&&this._data[G][1]<0)){if(this.varyBarColor&&!this._stack){if(this.useNegativeColors){z.fillStyle=t.next()}else{z.fillStyle=A.next()}}else{z.fillStyle=K}}else{if(this.varyBarColor&&!this._stack){z.fillStyle=A.next()}else{z.fillStyle=s}}if(!this.fillToZero||this._plotData[G][1]>=0){F.push([q-this.barWidth/2,n]);F.push([q-this.barWidth/2,J[G][1]]);F.push([q+this.barWidth/2,J[G][1]]);F.push([q+this.barWidth/2,n])}else{F.push([q-this.barWidth/2,J[G][1]]);F.push([q-this.barWidth/2,n]);F.push([q+this.barWidth/2,n]);F.push([q+this.barWidth/2,J[G][1]])}this._barPoints.push(F);if(u&&!this._stack){var y=d.extend(true,{},z);delete y.fillStyle;this.renderer.shadowRenderer.draw(D,F,y)}var m=z.fillStyle||this.color;this._dataColors.push(m);this.renderer.shapeRenderer.draw(D,F,z)}}else{if(this.barDirection=="horizontal"){for(var G=0;G<J.length;G++){if(this.data[G][0]==null){continue}F=[];q=J[G][1]-this._barNudge;N;if(this._stack&&this._prevGridData.length){N=this._prevGridData[G][0]}else{if(this.fillToZero){N=this._xaxis.series_u2p(0)}else{if(this.waterfall&&G>0&&G<this.gridData.length-1){N=this.gridData[G-1][1]}else{if(this.waterfall&&G==0&&G<this.gridData.length-1){if(this._xaxis.min<=0&&this._xaxis.max>=0){N=this._xaxis.series_u2p(0)}else{if(this._xaxis.min>0){N=0}else{N=D.canvas.width}}}else{if(this.waterfall&&G==this.gridData.length-1){if(this._xaxis.min<=0&&this._xaxis.max>=0){N=this._xaxis.series_u2p(0)}else{if(this._xaxis.min>0){N=0}else{N=D.canvas.width}}}else{N=0}}}}}if((this.fillToZero&&this._plotData[G][1]<0)||(this.waterfall&&this._data[G][1]<0)){if(this.varyBarColor&&!this._stack){if(this.useNegativeColors){z.fillStyle=t.next()}else{z.fillStyle=A.next()}}}else{if(this.varyBarColor&&!this._stack){z.fillStyle=A.next()}else{z.fillStyle=s}}if(!this.fillToZero||this._plotData[G][0]>=0){F.push([N,q+this.barWidth/2]);F.push([N,q-this.barWidth/2]);F.push([J[G][0],q-this.barWidth/2]);F.push([J[G][0],q+this.barWidth/2])}else{F.push([J[G][0],q+this.barWidth/2]);F.push([J[G][0],q-this.barWidth/2]);F.push([N,q-this.barWidth/2]);F.push([N,q+this.barWidth/2])}this._barPoints.push(F);if(u&&!this._stack){var y=d.extend(true,{},z);delete y.fillStyle;this.renderer.shadowRenderer.draw(D,F,y)}var m=z.fillStyle||this.color;this._dataColors.push(m);this.renderer.shapeRenderer.draw(D,F,z)}}}}if(this.highlightColors.length==0){this.highlightColors=d.jqplot.computeHighlightColors(this._dataColors)}else{if(typeof(this.highlightColors)=="string"){var L=this.highlightColors;this.highlightColors=[];for(var G=0;G<this._dataColors.length;G++){this.highlightColors.push(L)}}}};d.jqplot.BarRenderer.prototype.drawShadow=function(y,E,o){var B;var v=(o!=undefined)?o:{};var r=(v.shadow!=undefined)?v.shadow:this.shadow;var G=(v.showLine!=undefined)?v.showLine:this.showLine;var z=(v.fill!=undefined)?v.fill:this.fill;var n=this.xaxis;var C=this.yaxis;var u=this._xaxis.series_u2p;var D=this._yaxis.series_u2p;var x,A,w,t,s,q;if(this._stack&&this.shadow){if(this.barWidth==null){this.renderer.setBarWidth.call(this)}var F=this._plotSeriesInfo=this.renderer.calcSeriesNumbers.call(this);t=F[0];s=F[1];q=F[2];if(this._stack){this._barNudge=0}else{this._barNudge=(-Math.abs(s/2-0.5)+q)*(this.barWidth+this.barPadding)}if(G){if(this.barDirection=="vertical"){for(var B=0;B<E.length;B++){if(this.data[B][1]==null){continue}A=[];var p=E[B][0]+this._barNudge;var m;if(this._stack&&this._prevGridData.length){m=this._prevGridData[B][1]}else{if(this.fillToZero){m=this._yaxis.series_u2p(0)}else{m=y.canvas.height}}A.push([p-this.barWidth/2,m]);A.push([p-this.barWidth/2,E[B][1]]);A.push([p+this.barWidth/2,E[B][1]]);A.push([p+this.barWidth/2,m]);this.renderer.shadowRenderer.draw(y,A,v)}}else{if(this.barDirection=="horizontal"){for(var B=0;B<E.length;B++){if(this.data[B][0]==null){continue}A=[];var p=E[B][1]-this._barNudge;var H;if(this._stack&&this._prevGridData.length){H=this._prevGridData[B][0]}else{H=0}A.push([H,p+this.barWidth/2]);A.push([E[B][0],p+this.barWidth/2]);A.push([E[B][0],p-this.barWidth/2]);A.push([H,p-this.barWidth/2]);this.renderer.shadowRenderer.draw(y,A,v)}}}}}};function h(p,o,m){for(var n=0;n<this.series.length;n++){if(this.series[n].renderer.constructor==d.jqplot.BarRenderer){if(this.series[n].highlightMouseOver){this.series[n].highlightMouseDown=false}}}}function i(){if(this.plugins.barRenderer&&this.plugins.barRenderer.highlightCanvas){this.plugins.barRenderer.highlightCanvas.resetCanvas();this.plugins.barRenderer.highlightCanvas=null}this.plugins.barRenderer={highlightedSeriesIndex:null};this.plugins.barRenderer.highlightCanvas=new d.jqplot.GenericCanvas();this.eventCanvas._elem.before(this.plugins.barRenderer.highlightCanvas.createElement(this._gridPadding,"jqplot-barRenderer-highlight-canvas",this._plotDimensions,this));this.plugins.barRenderer.highlightCanvas.setContext();this.eventCanvas._elem.bind("mouseleave",{plot:this},function(m){j(m.data.plot)})}function c(t,r,p,o){var n=t.series[r];var m=t.plugins.barRenderer.highlightCanvas;m._ctx.clearRect(0,0,m._ctx.canvas.width,m._ctx.canvas.height);n._highlightedPoint=p;t.plugins.barRenderer.highlightedSeriesIndex=r;var q={fillStyle:n.highlightColors[p]};n.renderer.shapeRenderer.draw(m._ctx,o,q);m=null}function j(o){var m=o.plugins.barRenderer.highlightCanvas;m._ctx.clearRect(0,0,m._ctx.canvas.width,m._ctx.canvas.height);for(var n=0;n<o.series.length;n++){o.series[n]._highlightedPoint=null}o.plugins.barRenderer.highlightedSeriesIndex=null;o.target.trigger("jqplotDataUnhighlight");m=null}function b(q,p,t,s,r){if(s){var o=[s.seriesIndex,s.pointIndex,s.data];var n=jQuery.Event("jqplotDataMouseOver");n.pageX=q.pageX;n.pageY=q.pageY;r.target.trigger(n,o);if(r.series[o[0]].highlightMouseOver&&!(o[0]==r.plugins.barRenderer.highlightedSeriesIndex&&o[1]==r.series[o[0]]._highlightedPoint)){var m=jQuery.Event("jqplotDataHighlight");m.which=q.which;m.pageX=q.pageX;m.pageY=q.pageY;r.target.trigger(m,o);c(r,s.seriesIndex,s.pointIndex,s.points)}}else{if(s==null){j(r)}}}function a(p,o,s,r,q){if(r){var n=[r.seriesIndex,r.pointIndex,r.data];if(q.series[n[0]].highlightMouseDown&&!(n[0]==q.plugins.barRenderer.highlightedSeriesIndex&&n[1]==q.series[n[0]]._highlightedPoint)){var m=jQuery.Event("jqplotDataHighlight");m.which=p.which;m.pageX=p.pageX;m.pageY=p.pageY;q.target.trigger(m,n);c(q,r.seriesIndex,r.pointIndex,r.points)}}else{if(r==null){j(q)}}}function k(o,n,r,q,p){var m=p.plugins.barRenderer.highlightedSeriesIndex;if(m!=null&&p.series[m].highlightMouseDown){j(p)}}function e(p,o,s,r,q){if(r){var n=[r.seriesIndex,r.pointIndex,r.data];var m=jQuery.Event("jqplotDataClick");m.which=p.which;m.pageX=p.pageX;m.pageY=p.pageY;q.target.trigger(m,n)}}function l(q,p,t,s,r){if(s){var o=[s.seriesIndex,s.pointIndex,s.data];var m=r.plugins.barRenderer.highlightedSeriesIndex;if(m!=null&&r.series[m].highlightMouseDown){j(r)}var n=jQuery.Event("jqplotDataRightClick");n.which=q.which;n.pageX=q.pageX;n.pageY=q.pageY;r.target.trigger(n,o)}}})(jQuery);/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.1r1097
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 *
 * included jsDate library by Chris Leonello:
 *
 * Copyright (c) 2010-2011 Chris Leonello
 *
 * jsDate is currently available for use in all personal or commercial projects 
 * under both the MIT and GPL version 2.0 licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly.
 *
 * jsDate borrows many concepts and ideas from the Date Instance 
 * Methods by Ken Snyder along with some parts of Ken's actual code.
 * 
 * Ken's origianl Date Instance Methods and copyright notice:
 * 
 * Ken Snyder (ken d snyder at gmail dot com)
 * 2008-09-10
 * version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 * Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * jqplotToImage function based on Larry Siden's export-jqplot-to-png.js.
 * Larry has generously given permission to adapt his code for inclusion
 * into jqPlot.
 *
 * Larry's original code can be found here:
 *
 * https://github.com/lsiden/export-jqplot-to-png
 * 
 * 
 */
(function(a){a.jqplot.CanvasAxisLabelRenderer=function(b){this.angle=0;this.axis;this.show=true;this.showLabel=true;this.label="";this.fontFamily='"Trebuchet MS", Arial, Helvetica, sans-serif';this.fontSize="11pt";this.fontWeight="normal";this.fontStretch=1;this.textColor="#666666";this.enableFontSupport=true;this.pt2px=null;this._elem;this._ctx;this._plotWidth;this._plotHeight;this._plotDimensions={height:null,width:null};a.extend(true,this,b);if(b.angle==null&&this.axis!="xaxis"&&this.axis!="x2axis"){this.angle=-90}var c={fontSize:this.fontSize,fontWeight:this.fontWeight,fontStretch:this.fontStretch,fillStyle:this.textColor,angle:this.getAngleRad(),fontFamily:this.fontFamily};if(this.pt2px){c.pt2px=this.pt2px}if(this.enableFontSupport){if(a.jqplot.support_canvas_text()){this._textRenderer=new a.jqplot.CanvasFontRenderer(c)}else{this._textRenderer=new a.jqplot.CanvasTextRenderer(c)}}else{this._textRenderer=new a.jqplot.CanvasTextRenderer(c)}};a.jqplot.CanvasAxisLabelRenderer.prototype.init=function(b){a.extend(true,this,b);this._textRenderer.init({fontSize:this.fontSize,fontWeight:this.fontWeight,fontStretch:this.fontStretch,fillStyle:this.textColor,angle:this.getAngleRad(),fontFamily:this.fontFamily})};a.jqplot.CanvasAxisLabelRenderer.prototype.getWidth=function(d){if(this._elem){return this._elem.outerWidth(true)}else{var f=this._textRenderer;var c=f.getWidth(d);var e=f.getHeight(d);var b=Math.abs(Math.sin(f.angle)*e)+Math.abs(Math.cos(f.angle)*c);return b}};a.jqplot.CanvasAxisLabelRenderer.prototype.getHeight=function(d){if(this._elem){return this._elem.outerHeight(true)}else{var f=this._textRenderer;var c=f.getWidth(d);var e=f.getHeight(d);var b=Math.abs(Math.cos(f.angle)*e)+Math.abs(Math.sin(f.angle)*c);return b}};a.jqplot.CanvasAxisLabelRenderer.prototype.getAngleRad=function(){var b=this.angle*Math.PI/180;return b};a.jqplot.CanvasAxisLabelRenderer.prototype.draw=function(c,f){if(this._elem){if(a.jqplot.use_excanvas&&window.G_vmlCanvasManager.uninitElement!==undefined){window.G_vmlCanvasManager.uninitElement(this._elem.get(0))}this._elem.emptyForce();this._elem=null}var e=f.canvasManager.getCanvas();this._textRenderer.setText(this.label,c);var b=this.getWidth(c);var d=this.getHeight(c);e.width=b;e.height=d;e.style.width=b;e.style.height=d;e=f.canvasManager.initCanvas(e);this._elem=a(e);this._elem.css({position:"absolute"});this._elem.addClass("jqplot-"+this.axis+"-label");e=null;return this._elem};a.jqplot.CanvasAxisLabelRenderer.prototype.pack=function(){this._textRenderer.draw(this._elem.get(0).getContext("2d"),this.label)}})(jQuery);/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.1r1097
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 *
 * included jsDate library by Chris Leonello:
 *
 * Copyright (c) 2010-2011 Chris Leonello
 *
 * jsDate is currently available for use in all personal or commercial projects 
 * under both the MIT and GPL version 2.0 licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly.
 *
 * jsDate borrows many concepts and ideas from the Date Instance 
 * Methods by Ken Snyder along with some parts of Ken's actual code.
 * 
 * Ken's origianl Date Instance Methods and copyright notice:
 * 
 * Ken Snyder (ken d snyder at gmail dot com)
 * 2008-09-10
 * version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 * Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * jqplotToImage function based on Larry Siden's export-jqplot-to-png.js.
 * Larry has generously given permission to adapt his code for inclusion
 * into jqPlot.
 *
 * Larry's original code can be found here:
 *
 * https://github.com/lsiden/export-jqplot-to-png
 * 
 * 
 */
(function(a){a.jqplot.CanvasTextRenderer=function(b){this.fontStyle="normal";this.fontVariant="normal";this.fontWeight="normal";this.fontSize="10px";this.fontFamily="sans-serif";this.fontStretch=1;this.fillStyle="#666666";this.angle=0;this.textAlign="start";this.textBaseline="alphabetic";this.text;this.width;this.height;this.pt2px=1.28;a.extend(true,this,b);this.normalizedFontSize=this.normalizeFontSize(this.fontSize);this.setHeight()};a.jqplot.CanvasTextRenderer.prototype.init=function(b){a.extend(true,this,b);this.normalizedFontSize=this.normalizeFontSize(this.fontSize);this.setHeight()};a.jqplot.CanvasTextRenderer.prototype.normalizeFontSize=function(b){b=String(b);var c=parseFloat(b);if(b.indexOf("px")>-1){return c/this.pt2px}else{if(b.indexOf("pt")>-1){return c}else{if(b.indexOf("em")>-1){return c*12}else{if(b.indexOf("%")>-1){return c*12/100}else{return c/this.pt2px}}}}};a.jqplot.CanvasTextRenderer.prototype.fontWeight2Float=function(b){if(Number(b)){return b/400}else{switch(b){case"normal":return 1;break;case"bold":return 1.75;break;case"bolder":return 2.25;break;case"lighter":return 0.75;break;default:return 1;break}}};a.jqplot.CanvasTextRenderer.prototype.getText=function(){return this.text};a.jqplot.CanvasTextRenderer.prototype.setText=function(c,b){this.text=c;this.setWidth(b);return this};a.jqplot.CanvasTextRenderer.prototype.getWidth=function(b){return this.width};a.jqplot.CanvasTextRenderer.prototype.setWidth=function(c,b){if(!b){this.width=this.measure(c,this.text)}else{this.width=b}return this};a.jqplot.CanvasTextRenderer.prototype.getHeight=function(b){return this.height};a.jqplot.CanvasTextRenderer.prototype.setHeight=function(b){if(!b){this.height=this.normalizedFontSize*this.pt2px}else{this.height=b}return this};a.jqplot.CanvasTextRenderer.prototype.letter=function(b){return this.letters[b]};a.jqplot.CanvasTextRenderer.prototype.ascent=function(){return this.normalizedFontSize};a.jqplot.CanvasTextRenderer.prototype.descent=function(){return 7*this.normalizedFontSize/25};a.jqplot.CanvasTextRenderer.prototype.measure=function(d,g){var f=0;var b=g.length;for(var e=0;e<b;e++){var h=this.letter(g.charAt(e));if(h){f+=h.width*this.normalizedFontSize/25*this.fontStretch}}return f};a.jqplot.CanvasTextRenderer.prototype.draw=function(s,n){var r=0;var o=this.height*0.72;var p=0;var l=n.length;var k=this.normalizedFontSize/25;s.save();var h,f;if((-Math.PI/2<=this.angle&&this.angle<=0)||(Math.PI*3/2<=this.angle&&this.angle<=Math.PI*2)){h=0;f=-Math.sin(this.angle)*this.width}else{if((0<this.angle&&this.angle<=Math.PI/2)||(-Math.PI*2<=this.angle&&this.angle<=-Math.PI*3/2)){h=Math.sin(this.angle)*this.height;f=0}else{if((-Math.PI<this.angle&&this.angle<-Math.PI/2)||(Math.PI<=this.angle&&this.angle<=Math.PI*3/2)){h=-Math.cos(this.angle)*this.width;f=-Math.sin(this.angle)*this.width-Math.cos(this.angle)*this.height}else{if((-Math.PI*3/2<this.angle&&this.angle<Math.PI)||(Math.PI/2<this.angle&&this.angle<Math.PI)){h=Math.sin(this.angle)*this.height-Math.cos(this.angle)*this.width;f=-Math.cos(this.angle)*this.height}}}}s.strokeStyle=this.fillStyle;s.fillStyle=this.fillStyle;s.translate(h,f);s.rotate(this.angle);s.lineCap="round";var t=(this.normalizedFontSize>30)?2:2+(30-this.normalizedFontSize)/20;s.lineWidth=t*k*this.fontWeight2Float(this.fontWeight);for(var g=0;g<l;g++){var m=this.letter(n.charAt(g));if(!m){continue}s.beginPath();var e=1;var b=0;for(var d=0;d<m.points.length;d++){var q=m.points[d];if(q[0]==-1&&q[1]==-1){e=1;continue}if(e){s.moveTo(r+q[0]*k*this.fontStretch,o-q[1]*k);e=false}else{s.lineTo(r+q[0]*k*this.fontStretch,o-q[1]*k)}}s.stroke();r+=m.width*k*this.fontStretch}s.restore();return p};a.jqplot.CanvasTextRenderer.prototype.letters={" ":{width:16,points:[]},"!":{width:10,points:[[5,21],[5,7],[-1,-1],[5,2],[4,1],[5,0],[6,1],[5,2]]},'"':{width:16,points:[[4,21],[4,14],[-1,-1],[12,21],[12,14]]},"#":{width:21,points:[[11,25],[4,-7],[-1,-1],[17,25],[10,-7],[-1,-1],[4,12],[18,12],[-1,-1],[3,6],[17,6]]},"$":{width:20,points:[[8,25],[8,-4],[-1,-1],[12,25],[12,-4],[-1,-1],[17,18],[15,20],[12,21],[8,21],[5,20],[3,18],[3,16],[4,14],[5,13],[7,12],[13,10],[15,9],[16,8],[17,6],[17,3],[15,1],[12,0],[8,0],[5,1],[3,3]]},"%":{width:24,points:[[21,21],[3,0],[-1,-1],[8,21],[10,19],[10,17],[9,15],[7,14],[5,14],[3,16],[3,18],[4,20],[6,21],[8,21],[10,20],[13,19],[16,19],[19,20],[21,21],[-1,-1],[17,7],[15,6],[14,4],[14,2],[16,0],[18,0],[20,1],[21,3],[21,5],[19,7],[17,7]]},"&":{width:26,points:[[23,12],[23,13],[22,14],[21,14],[20,13],[19,11],[17,6],[15,3],[13,1],[11,0],[7,0],[5,1],[4,2],[3,4],[3,6],[4,8],[5,9],[12,13],[13,14],[14,16],[14,18],[13,20],[11,21],[9,20],[8,18],[8,16],[9,13],[11,10],[16,3],[18,1],[20,0],[22,0],[23,1],[23,2]]},"'":{width:10,points:[[5,19],[4,20],[5,21],[6,20],[6,18],[5,16],[4,15]]},"(":{width:14,points:[[11,25],[9,23],[7,20],[5,16],[4,11],[4,7],[5,2],[7,-2],[9,-5],[11,-7]]},")":{width:14,points:[[3,25],[5,23],[7,20],[9,16],[10,11],[10,7],[9,2],[7,-2],[5,-5],[3,-7]]},"*":{width:16,points:[[8,21],[8,9],[-1,-1],[3,18],[13,12],[-1,-1],[13,18],[3,12]]},"+":{width:26,points:[[13,18],[13,0],[-1,-1],[4,9],[22,9]]},",":{width:10,points:[[6,1],[5,0],[4,1],[5,2],[6,1],[6,-1],[5,-3],[4,-4]]},"-":{width:18,points:[[6,9],[12,9]]},".":{width:10,points:[[5,2],[4,1],[5,0],[6,1],[5,2]]},"/":{width:22,points:[[20,25],[2,-7]]},"0":{width:20,points:[[9,21],[6,20],[4,17],[3,12],[3,9],[4,4],[6,1],[9,0],[11,0],[14,1],[16,4],[17,9],[17,12],[16,17],[14,20],[11,21],[9,21]]},"1":{width:20,points:[[6,17],[8,18],[11,21],[11,0]]},"2":{width:20,points:[[4,16],[4,17],[5,19],[6,20],[8,21],[12,21],[14,20],[15,19],[16,17],[16,15],[15,13],[13,10],[3,0],[17,0]]},"3":{width:20,points:[[5,21],[16,21],[10,13],[13,13],[15,12],[16,11],[17,8],[17,6],[16,3],[14,1],[11,0],[8,0],[5,1],[4,2],[3,4]]},"4":{width:20,points:[[13,21],[3,7],[18,7],[-1,-1],[13,21],[13,0]]},"5":{width:20,points:[[15,21],[5,21],[4,12],[5,13],[8,14],[11,14],[14,13],[16,11],[17,8],[17,6],[16,3],[14,1],[11,0],[8,0],[5,1],[4,2],[3,4]]},"6":{width:20,points:[[16,18],[15,20],[12,21],[10,21],[7,20],[5,17],[4,12],[4,7],[5,3],[7,1],[10,0],[11,0],[14,1],[16,3],[17,6],[17,7],[16,10],[14,12],[11,13],[10,13],[7,12],[5,10],[4,7]]},"7":{width:20,points:[[17,21],[7,0],[-1,-1],[3,21],[17,21]]},"8":{width:20,points:[[8,21],[5,20],[4,18],[4,16],[5,14],[7,13],[11,12],[14,11],[16,9],[17,7],[17,4],[16,2],[15,1],[12,0],[8,0],[5,1],[4,2],[3,4],[3,7],[4,9],[6,11],[9,12],[13,13],[15,14],[16,16],[16,18],[15,20],[12,21],[8,21]]},"9":{width:20,points:[[16,14],[15,11],[13,9],[10,8],[9,8],[6,9],[4,11],[3,14],[3,15],[4,18],[6,20],[9,21],[10,21],[13,20],[15,18],[16,14],[16,9],[15,4],[13,1],[10,0],[8,0],[5,1],[4,3]]},":":{width:10,points:[[5,14],[4,13],[5,12],[6,13],[5,14],[-1,-1],[5,2],[4,1],[5,0],[6,1],[5,2]]},";":{width:10,points:[[5,14],[4,13],[5,12],[6,13],[5,14],[-1,-1],[6,1],[5,0],[4,1],[5,2],[6,1],[6,-1],[5,-3],[4,-4]]},"<":{width:24,points:[[20,18],[4,9],[20,0]]},"=":{width:26,points:[[4,12],[22,12],[-1,-1],[4,6],[22,6]]},">":{width:24,points:[[4,18],[20,9],[4,0]]},"?":{width:18,points:[[3,16],[3,17],[4,19],[5,20],[7,21],[11,21],[13,20],[14,19],[15,17],[15,15],[14,13],[13,12],[9,10],[9,7],[-1,-1],[9,2],[8,1],[9,0],[10,1],[9,2]]},"@":{width:27,points:[[18,13],[17,15],[15,16],[12,16],[10,15],[9,14],[8,11],[8,8],[9,6],[11,5],[14,5],[16,6],[17,8],[-1,-1],[12,16],[10,14],[9,11],[9,8],[10,6],[11,5],[-1,-1],[18,16],[17,8],[17,6],[19,5],[21,5],[23,7],[24,10],[24,12],[23,15],[22,17],[20,19],[18,20],[15,21],[12,21],[9,20],[7,19],[5,17],[4,15],[3,12],[3,9],[4,6],[5,4],[7,2],[9,1],[12,0],[15,0],[18,1],[20,2],[21,3],[-1,-1],[19,16],[18,8],[18,6],[19,5]]},A:{width:18,points:[[9,21],[1,0],[-1,-1],[9,21],[17,0],[-1,-1],[4,7],[14,7]]},B:{width:21,points:[[4,21],[4,0],[-1,-1],[4,21],[13,21],[16,20],[17,19],[18,17],[18,15],[17,13],[16,12],[13,11],[-1,-1],[4,11],[13,11],[16,10],[17,9],[18,7],[18,4],[17,2],[16,1],[13,0],[4,0]]},C:{width:21,points:[[18,16],[17,18],[15,20],[13,21],[9,21],[7,20],[5,18],[4,16],[3,13],[3,8],[4,5],[5,3],[7,1],[9,0],[13,0],[15,1],[17,3],[18,5]]},D:{width:21,points:[[4,21],[4,0],[-1,-1],[4,21],[11,21],[14,20],[16,18],[17,16],[18,13],[18,8],[17,5],[16,3],[14,1],[11,0],[4,0]]},E:{width:19,points:[[4,21],[4,0],[-1,-1],[4,21],[17,21],[-1,-1],[4,11],[12,11],[-1,-1],[4,0],[17,0]]},F:{width:18,points:[[4,21],[4,0],[-1,-1],[4,21],[17,21],[-1,-1],[4,11],[12,11]]},G:{width:21,points:[[18,16],[17,18],[15,20],[13,21],[9,21],[7,20],[5,18],[4,16],[3,13],[3,8],[4,5],[5,3],[7,1],[9,0],[13,0],[15,1],[17,3],[18,5],[18,8],[-1,-1],[13,8],[18,8]]},H:{width:22,points:[[4,21],[4,0],[-1,-1],[18,21],[18,0],[-1,-1],[4,11],[18,11]]},I:{width:8,points:[[4,21],[4,0]]},J:{width:16,points:[[12,21],[12,5],[11,2],[10,1],[8,0],[6,0],[4,1],[3,2],[2,5],[2,7]]},K:{width:21,points:[[4,21],[4,0],[-1,-1],[18,21],[4,7],[-1,-1],[9,12],[18,0]]},L:{width:17,points:[[4,21],[4,0],[-1,-1],[4,0],[16,0]]},M:{width:24,points:[[4,21],[4,0],[-1,-1],[4,21],[12,0],[-1,-1],[20,21],[12,0],[-1,-1],[20,21],[20,0]]},N:{width:22,points:[[4,21],[4,0],[-1,-1],[4,21],[18,0],[-1,-1],[18,21],[18,0]]},O:{width:22,points:[[9,21],[7,20],[5,18],[4,16],[3,13],[3,8],[4,5],[5,3],[7,1],[9,0],[13,0],[15,1],[17,3],[18,5],[19,8],[19,13],[18,16],[17,18],[15,20],[13,21],[9,21]]},P:{width:21,points:[[4,21],[4,0],[-1,-1],[4,21],[13,21],[16,20],[17,19],[18,17],[18,14],[17,12],[16,11],[13,10],[4,10]]},Q:{width:22,points:[[9,21],[7,20],[5,18],[4,16],[3,13],[3,8],[4,5],[5,3],[7,1],[9,0],[13,0],[15,1],[17,3],[18,5],[19,8],[19,13],[18,16],[17,18],[15,20],[13,21],[9,21],[-1,-1],[12,4],[18,-2]]},R:{width:21,points:[[4,21],[4,0],[-1,-1],[4,21],[13,21],[16,20],[17,19],[18,17],[18,15],[17,13],[16,12],[13,11],[4,11],[-1,-1],[11,11],[18,0]]},S:{width:20,points:[[17,18],[15,20],[12,21],[8,21],[5,20],[3,18],[3,16],[4,14],[5,13],[7,12],[13,10],[15,9],[16,8],[17,6],[17,3],[15,1],[12,0],[8,0],[5,1],[3,3]]},T:{width:16,points:[[8,21],[8,0],[-1,-1],[1,21],[15,21]]},U:{width:22,points:[[4,21],[4,6],[5,3],[7,1],[10,0],[12,0],[15,1],[17,3],[18,6],[18,21]]},V:{width:18,points:[[1,21],[9,0],[-1,-1],[17,21],[9,0]]},W:{width:24,points:[[2,21],[7,0],[-1,-1],[12,21],[7,0],[-1,-1],[12,21],[17,0],[-1,-1],[22,21],[17,0]]},X:{width:20,points:[[3,21],[17,0],[-1,-1],[17,21],[3,0]]},Y:{width:18,points:[[1,21],[9,11],[9,0],[-1,-1],[17,21],[9,11]]},Z:{width:20,points:[[17,21],[3,0],[-1,-1],[3,21],[17,21],[-1,-1],[3,0],[17,0]]},"[":{width:14,points:[[4,25],[4,-7],[-1,-1],[5,25],[5,-7],[-1,-1],[4,25],[11,25],[-1,-1],[4,-7],[11,-7]]},"\\":{width:14,points:[[0,21],[14,-3]]},"]":{width:14,points:[[9,25],[9,-7],[-1,-1],[10,25],[10,-7],[-1,-1],[3,25],[10,25],[-1,-1],[3,-7],[10,-7]]},"^":{width:16,points:[[6,15],[8,18],[10,15],[-1,-1],[3,12],[8,17],[13,12],[-1,-1],[8,17],[8,0]]},_:{width:16,points:[[0,-2],[16,-2]]},"`":{width:10,points:[[6,21],[5,20],[4,18],[4,16],[5,15],[6,16],[5,17]]},a:{width:19,points:[[15,14],[15,0],[-1,-1],[15,11],[13,13],[11,14],[8,14],[6,13],[4,11],[3,8],[3,6],[4,3],[6,1],[8,0],[11,0],[13,1],[15,3]]},b:{width:19,points:[[4,21],[4,0],[-1,-1],[4,11],[6,13],[8,14],[11,14],[13,13],[15,11],[16,8],[16,6],[15,3],[13,1],[11,0],[8,0],[6,1],[4,3]]},c:{width:18,points:[[15,11],[13,13],[11,14],[8,14],[6,13],[4,11],[3,8],[3,6],[4,3],[6,1],[8,0],[11,0],[13,1],[15,3]]},d:{width:19,points:[[15,21],[15,0],[-1,-1],[15,11],[13,13],[11,14],[8,14],[6,13],[4,11],[3,8],[3,6],[4,3],[6,1],[8,0],[11,0],[13,1],[15,3]]},e:{width:18,points:[[3,8],[15,8],[15,10],[14,12],[13,13],[11,14],[8,14],[6,13],[4,11],[3,8],[3,6],[4,3],[6,1],[8,0],[11,0],[13,1],[15,3]]},f:{width:12,points:[[10,21],[8,21],[6,20],[5,17],[5,0],[-1,-1],[2,14],[9,14]]},g:{width:19,points:[[15,14],[15,-2],[14,-5],[13,-6],[11,-7],[8,-7],[6,-6],[-1,-1],[15,11],[13,13],[11,14],[8,14],[6,13],[4,11],[3,8],[3,6],[4,3],[6,1],[8,0],[11,0],[13,1],[15,3]]},h:{width:19,points:[[4,21],[4,0],[-1,-1],[4,10],[7,13],[9,14],[12,14],[14,13],[15,10],[15,0]]},i:{width:8,points:[[3,21],[4,20],[5,21],[4,22],[3,21],[-1,-1],[4,14],[4,0]]},j:{width:10,points:[[5,21],[6,20],[7,21],[6,22],[5,21],[-1,-1],[6,14],[6,-3],[5,-6],[3,-7],[1,-7]]},k:{width:17,points:[[4,21],[4,0],[-1,-1],[14,14],[4,4],[-1,-1],[8,8],[15,0]]},l:{width:8,points:[[4,21],[4,0]]},m:{width:30,points:[[4,14],[4,0],[-1,-1],[4,10],[7,13],[9,14],[12,14],[14,13],[15,10],[15,0],[-1,-1],[15,10],[18,13],[20,14],[23,14],[25,13],[26,10],[26,0]]},n:{width:19,points:[[4,14],[4,0],[-1,-1],[4,10],[7,13],[9,14],[12,14],[14,13],[15,10],[15,0]]},o:{width:19,points:[[8,14],[6,13],[4,11],[3,8],[3,6],[4,3],[6,1],[8,0],[11,0],[13,1],[15,3],[16,6],[16,8],[15,11],[13,13],[11,14],[8,14]]},p:{width:19,points:[[4,14],[4,-7],[-1,-1],[4,11],[6,13],[8,14],[11,14],[13,13],[15,11],[16,8],[16,6],[15,3],[13,1],[11,0],[8,0],[6,1],[4,3]]},q:{width:19,points:[[15,14],[15,-7],[-1,-1],[15,11],[13,13],[11,14],[8,14],[6,13],[4,11],[3,8],[3,6],[4,3],[6,1],[8,0],[11,0],[13,1],[15,3]]},r:{width:13,points:[[4,14],[4,0],[-1,-1],[4,8],[5,11],[7,13],[9,14],[12,14]]},s:{width:17,points:[[14,11],[13,13],[10,14],[7,14],[4,13],[3,11],[4,9],[6,8],[11,7],[13,6],[14,4],[14,3],[13,1],[10,0],[7,0],[4,1],[3,3]]},t:{width:12,points:[[5,21],[5,4],[6,1],[8,0],[10,0],[-1,-1],[2,14],[9,14]]},u:{width:19,points:[[4,14],[4,4],[5,1],[7,0],[10,0],[12,1],[15,4],[-1,-1],[15,14],[15,0]]},v:{width:16,points:[[2,14],[8,0],[-1,-1],[14,14],[8,0]]},w:{width:22,points:[[3,14],[7,0],[-1,-1],[11,14],[7,0],[-1,-1],[11,14],[15,0],[-1,-1],[19,14],[15,0]]},x:{width:17,points:[[3,14],[14,0],[-1,-1],[14,14],[3,0]]},y:{width:16,points:[[2,14],[8,0],[-1,-1],[14,14],[8,0],[6,-4],[4,-6],[2,-7],[1,-7]]},z:{width:17,points:[[14,14],[3,0],[-1,-1],[3,14],[14,14],[-1,-1],[3,0],[14,0]]},"{":{width:14,points:[[9,25],[7,24],[6,23],[5,21],[5,19],[6,17],[7,16],[8,14],[8,12],[6,10],[-1,-1],[7,24],[6,22],[6,20],[7,18],[8,17],[9,15],[9,13],[8,11],[4,9],[8,7],[9,5],[9,3],[8,1],[7,0],[6,-2],[6,-4],[7,-6],[-1,-1],[6,8],[8,6],[8,4],[7,2],[6,1],[5,-1],[5,-3],[6,-5],[7,-6],[9,-7]]},"|":{width:8,points:[[4,25],[4,-7]]},"}":{width:14,points:[[5,25],[7,24],[8,23],[9,21],[9,19],[8,17],[7,16],[6,14],[6,12],[8,10],[-1,-1],[7,24],[8,22],[8,20],[7,18],[6,17],[5,15],[5,13],[6,11],[10,9],[6,7],[5,5],[5,3],[6,1],[7,0],[8,-2],[8,-4],[7,-6],[-1,-1],[8,8],[6,6],[6,4],[7,2],[8,1],[9,-1],[9,-3],[8,-5],[7,-6],[5,-7]]},"~":{width:24,points:[[3,6],[3,8],[4,11],[6,12],[8,12],[10,11],[14,8],[16,7],[18,7],[20,8],[21,10],[-1,-1],[3,8],[4,10],[6,11],[8,11],[10,10],[14,7],[16,6],[18,6],[20,7],[21,10],[21,12]]}};a.jqplot.CanvasFontRenderer=function(b){b=b||{};if(!b.pt2px){b.pt2px=1.5}a.jqplot.CanvasTextRenderer.call(this,b)};a.jqplot.CanvasFontRenderer.prototype=new a.jqplot.CanvasTextRenderer({});a.jqplot.CanvasFontRenderer.prototype.constructor=a.jqplot.CanvasFontRenderer;a.jqplot.CanvasFontRenderer.prototype.measure=function(c,e){var d=this.fontSize+" "+this.fontFamily;c.save();c.font=d;var b=c.measureText(e).width;c.restore();return b};a.jqplot.CanvasFontRenderer.prototype.draw=function(e,g){var c=0;var h=this.height*0.72;e.save();var d,b;if((-Math.PI/2<=this.angle&&this.angle<=0)||(Math.PI*3/2<=this.angle&&this.angle<=Math.PI*2)){d=0;b=-Math.sin(this.angle)*this.width}else{if((0<this.angle&&this.angle<=Math.PI/2)||(-Math.PI*2<=this.angle&&this.angle<=-Math.PI*3/2)){d=Math.sin(this.angle)*this.height;b=0}else{if((-Math.PI<this.angle&&this.angle<-Math.PI/2)||(Math.PI<=this.angle&&this.angle<=Math.PI*3/2)){d=-Math.cos(this.angle)*this.width;b=-Math.sin(this.angle)*this.width-Math.cos(this.angle)*this.height}else{if((-Math.PI*3/2<this.angle&&this.angle<Math.PI)||(Math.PI/2<this.angle&&this.angle<Math.PI)){d=Math.sin(this.angle)*this.height-Math.cos(this.angle)*this.width;b=-Math.cos(this.angle)*this.height}}}}e.strokeStyle=this.fillStyle;e.fillStyle=this.fillStyle;var f=this.fontSize+" "+this.fontFamily;e.font=f;e.translate(d,b);e.rotate(this.angle);e.fillText(g,c,h);e.restore()}})(jQuery);/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.0b2_r1012
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 *
 * included jsDate library by Chris Leonello:
 *
 * Copyright (c) 2010-2011 Chris Leonello
 *
 * jsDate is currently available for use in all personal or commercial projects 
 * under both the MIT and GPL version 2.0 licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly.
 *
 * jsDate borrows many concepts and ideas from the Date Instance 
 * Methods by Ken Snyder along with some parts of Ken's actual code.
 * 
 * Ken's origianl Date Instance Methods and copyright notice:
 * 
 * Ken Snyder (ken d snyder at gmail dot com)
 * 2008-09-10
 * version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 * Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * jqplotToImage function based on Larry Siden's export-jqplot-to-png.js.
 * Larry has generously given permission to adapt his code for inclusion
 * into jqPlot.
 *
 * Larry's original code can be found here:
 *
 * https://github.com/lsiden/export-jqplot-to-png
 * 
 * 
 */
(function(a){a.jqplot.CategoryAxisRenderer=function(b){a.jqplot.LinearAxisRenderer.call(this);this.sortMergedLabels=false};a.jqplot.CategoryAxisRenderer.prototype=new a.jqplot.LinearAxisRenderer();a.jqplot.CategoryAxisRenderer.prototype.constructor=a.jqplot.CategoryAxisRenderer;a.jqplot.CategoryAxisRenderer.prototype.init=function(e){this.groups=1;this.groupLabels=[];this._groupLabels=[];this._grouped=false;this._barsPerGroup=null;a.extend(true,this,{tickOptions:{formatString:"%d"}},e);var b=this._dataBounds;for(var f=0;f<this._series.length;f++){var g=this._series[f];if(g.groups){this.groups=g.groups}var h=g.data;for(var c=0;c<h.length;c++){if(this.name=="xaxis"||this.name=="x2axis"){if(h[c][0]<b.min||b.min==null){b.min=h[c][0]}if(h[c][0]>b.max||b.max==null){b.max=h[c][0]}}else{if(h[c][1]<b.min||b.min==null){b.min=h[c][1]}if(h[c][1]>b.max||b.max==null){b.max=h[c][1]}}}}if(this.groupLabels.length){this.groups=this.groupLabels.length}};a.jqplot.CategoryAxisRenderer.prototype.createTicks=function(){var D=this._ticks;var z=this.ticks;var F=this.name;var C=this._dataBounds;var v,A;var q,w;var d,c;var b,x;if(z.length){if(this.groups>1&&!this._grouped){var r=z.length;var p=parseInt(r/this.groups,10);var e=0;for(var x=p;x<r;x+=p){z.splice(x+e,0," ");e++}this._grouped=true}this.min=0.5;this.max=z.length+0.5;var m=this.max-this.min;this.numberTicks=2*z.length+1;for(x=0;x<z.length;x++){b=this.min+2*x*m/(this.numberTicks-1);var h=new this.tickRenderer(this.tickOptions);h.showLabel=false;h.setTick(b,this.name);this._ticks.push(h);var h=new this.tickRenderer(this.tickOptions);h.label=z[x];h.showMark=false;h.showGridline=false;h.setTick(b+0.5,this.name);this._ticks.push(h)}var h=new this.tickRenderer(this.tickOptions);h.showLabel=false;h.setTick(b+1,this.name);this._ticks.push(h)}else{if(F=="xaxis"||F=="x2axis"){v=this._plotDimensions.width}else{v=this._plotDimensions.height}if(this.min!=null&&this.max!=null&&this.numberTicks!=null){this.tickInterval=null}if(this.min!=null&&this.max!=null&&this.tickInterval!=null){if(parseInt((this.max-this.min)/this.tickInterval,10)!=(this.max-this.min)/this.tickInterval){this.tickInterval=null}}var y=[];var B=0;var q=0.5;var w,E;var f=false;for(var x=0;x<this._series.length;x++){var k=this._series[x];for(var u=0;u<k.data.length;u++){if(this.name=="xaxis"||this.name=="x2axis"){E=k.data[u][0]}else{E=k.data[u][1]}if(a.inArray(E,y)==-1){f=true;B+=1;y.push(E)}}}if(f&&this.sortMergedLabels){y.sort(function(j,i){return j-i})}this.ticks=y;for(var x=0;x<this._series.length;x++){var k=this._series[x];for(var u=0;u<k.data.length;u++){if(this.name=="xaxis"||this.name=="x2axis"){E=k.data[u][0]}else{E=k.data[u][1]}var n=a.inArray(E,y)+1;if(this.name=="xaxis"||this.name=="x2axis"){k.data[u][0]=n}else{k.data[u][1]=n}}}if(this.groups>1&&!this._grouped){var r=y.length;var p=parseInt(r/this.groups,10);var e=0;for(var x=p;x<r;x+=p+1){y[x]=" "}this._grouped=true}w=B+0.5;if(this.numberTicks==null){this.numberTicks=2*B+1}var m=w-q;this.min=q;this.max=w;var o=0;var g=parseInt(3+v/10,10);var p=parseInt(B/g,10);if(this.tickInterval==null){this.tickInterval=m/(this.numberTicks-1)}for(var x=0;x<this.numberTicks;x++){b=this.min+x*this.tickInterval;var h=new this.tickRenderer(this.tickOptions);if(x/2==parseInt(x/2,10)){h.showLabel=false;h.showMark=true}else{if(p>0&&o<p){h.showLabel=false;o+=1}else{h.showLabel=true;o=0}h.label=h.formatter(h.formatString,y[(x-1)/2]);h.showMark=false;h.showGridline=false}h.setTick(b,this.name);this._ticks.push(h)}}};a.jqplot.CategoryAxisRenderer.prototype.draw=function(b,j){if(this.show){this.renderer.createTicks.call(this);var h=0;var c;if(this._elem){this._elem.emptyForce()}this._elem=this._elem||a('<div class="jqplot-axis jqplot-'+this.name+'" style="position:absolute;"></div>');if(this.name=="xaxis"||this.name=="x2axis"){this._elem.width(this._plotDimensions.width)}else{this._elem.height(this._plotDimensions.height)}this.labelOptions.axis=this.name;this._label=new this.labelRenderer(this.labelOptions);if(this._label.show){var g=this._label.draw(b,j);g.appendTo(this._elem)}var f=this._ticks;for(var e=0;e<f.length;e++){var d=f[e];if(d.showLabel&&(!d.isMinorTick||this.showMinorTicks)){var g=d.draw(b,j);g.appendTo(this._elem)}}this._groupLabels=[];for(var e=0;e<this.groupLabels.length;e++){var g=a('<div style="position:absolute;" class="jqplot-'+this.name+'-groupLabel"></div>');g.html(this.groupLabels[e]);this._groupLabels.push(g);g.appendTo(this._elem)}}return this._elem};a.jqplot.CategoryAxisRenderer.prototype.set=function(){var e=0;var m;var k=0;var f=0;var d=(this._label==null)?false:this._label.show;if(this.show){var n=this._ticks;for(var c=0;c<n.length;c++){var g=n[c];if(g.showLabel&&(!g.isMinorTick||this.showMinorTicks)){if(this.name=="xaxis"||this.name=="x2axis"){m=g._elem.outerHeight(true)}else{m=g._elem.outerWidth(true)}if(m>e){e=m}}}var j=0;for(var c=0;c<this._groupLabels.length;c++){var b=this._groupLabels[c];if(this.name=="xaxis"||this.name=="x2axis"){m=b.outerHeight(true)}else{m=b.outerWidth(true)}if(m>j){j=m}}if(d){k=this._label._elem.outerWidth(true);f=this._label._elem.outerHeight(true)}if(this.name=="xaxis"){e+=j+f;this._elem.css({height:e+"px",left:"0px",bottom:"0px"})}else{if(this.name=="x2axis"){e+=j+f;this._elem.css({height:e+"px",left:"0px",top:"0px"})}else{if(this.name=="yaxis"){e+=j+k;this._elem.css({width:e+"px",left:"0px",top:"0px"});if(d&&this._label.constructor==a.jqplot.AxisLabelRenderer){this._label._elem.css("width",k+"px")}}else{e+=j+k;this._elem.css({width:e+"px",right:"0px",top:"0px"});if(d&&this._label.constructor==a.jqplot.AxisLabelRenderer){this._label._elem.css("width",k+"px")}}}}}};a.jqplot.CategoryAxisRenderer.prototype.pack=function(e,c){var C=this._ticks;var v=this.max;var s=this.min;var n=c.max;var l=c.min;var q=(this._label==null)?false:this._label.show;var x;for(var r in e){this._elem.css(r,e[r])}this._offsets=c;var g=n-l;var k=v-s;this.p2u=function(h){return(h-l)*k/g+s};this.u2p=function(h){return(h-s)*g/k+l};if(this.name=="xaxis"||this.name=="x2axis"){this.series_u2p=function(h){return(h-s)*g/k};this.series_p2u=function(h){return h*k/g+s}}else{this.series_u2p=function(h){return(h-v)*g/k};this.series_p2u=function(h){return h*k/g+v}}if(this.show){if(this.name=="xaxis"||this.name=="x2axis"){for(x=0;x<C.length;x++){var o=C[x];if(o.show&&o.showLabel){var b;if(o.constructor==a.jqplot.CanvasAxisTickRenderer&&o.angle){var A=(this.name=="xaxis")?1:-1;switch(o.labelPosition){case"auto":if(A*o.angle<0){b=-o.getWidth()+o._textRenderer.height*Math.sin(-o._textRenderer.angle)/2}else{b=-o._textRenderer.height*Math.sin(o._textRenderer.angle)/2}break;case"end":b=-o.getWidth()+o._textRenderer.height*Math.sin(-o._textRenderer.angle)/2;break;case"start":b=-o._textRenderer.height*Math.sin(o._textRenderer.angle)/2;break;case"middle":b=-o.getWidth()/2+o._textRenderer.height*Math.sin(-o._textRenderer.angle)/2;break;default:b=-o.getWidth()/2+o._textRenderer.height*Math.sin(-o._textRenderer.angle)/2;break}}else{b=-o.getWidth()/2}var D=this.u2p(o.value)+b+"px";o._elem.css("left",D);o.pack()}}var z=["bottom",0];if(q){var m=this._label._elem.outerWidth(true);this._label._elem.css("left",l+g/2-m/2+"px");if(this.name=="xaxis"){this._label._elem.css("bottom","0px");z=["bottom",this._label._elem.outerHeight(true)]}else{this._label._elem.css("top","0px");z=["top",this._label._elem.outerHeight(true)]}this._label.pack()}var d=parseInt(this._ticks.length/this.groups,10);for(x=0;x<this._groupLabels.length;x++){var B=0;var f=0;for(var u=x*d;u<=(x+1)*d;u++){if(this._ticks[u]._elem&&this._ticks[u].label!=" "){var o=this._ticks[u]._elem;var r=o.position();B+=r.left+o.outerWidth(true)/2;f++}}B=B/f;this._groupLabels[x].css({left:(B-this._groupLabels[x].outerWidth(true)/2)});this._groupLabels[x].css(z[0],z[1])}}else{for(x=0;x<C.length;x++){var o=C[x];if(o.show&&o.showLabel){var b;if(o.constructor==a.jqplot.CanvasAxisTickRenderer&&o.angle){var A=(this.name=="yaxis")?1:-1;switch(o.labelPosition){case"auto":case"end":if(A*o.angle<0){b=-o._textRenderer.height*Math.cos(-o._textRenderer.angle)/2}else{b=-o.getHeight()+o._textRenderer.height*Math.cos(o._textRenderer.angle)/2}break;case"start":if(o.angle>0){b=-o._textRenderer.height*Math.cos(-o._textRenderer.angle)/2}else{b=-o.getHeight()+o._textRenderer.height*Math.cos(o._textRenderer.angle)/2}break;case"middle":b=-o.getHeight()/2;break;default:b=-o.getHeight()/2;break}}else{b=-o.getHeight()/2}var D=this.u2p(o.value)+b+"px";o._elem.css("top",D);o.pack()}}var z=["left",0];if(q){var y=this._label._elem.outerHeight(true);this._label._elem.css("top",n-g/2-y/2+"px");if(this.name=="yaxis"){this._label._elem.css("left","0px");z=["left",this._label._elem.outerWidth(true)]}else{this._label._elem.css("right","0px");z=["right",this._label._elem.outerWidth(true)]}this._label.pack()}var d=parseInt(this._ticks.length/this.groups,10);for(x=0;x<this._groupLabels.length;x++){var B=0;var f=0;for(var u=x*d;u<=(x+1)*d;u++){if(this._ticks[u]._elem&&this._ticks[u].label!=" "){var o=this._ticks[u]._elem;var r=o.position();B+=r.top+o.outerHeight()/2;f++}}B=B/f;this._groupLabels[x].css({top:B-this._groupLabels[x].outerHeight()/2});this._groupLabels[x].css(z[0],z[1])}}}}})(jQuery);/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.1r1097
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 *
 * included jsDate library by Chris Leonello:
 *
 * Copyright (c) 2010-2011 Chris Leonello
 *
 * jsDate is currently available for use in all personal or commercial projects 
 * under both the MIT and GPL version 2.0 licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly.
 *
 * jsDate borrows many concepts and ideas from the Date Instance 
 * Methods by Ken Snyder along with some parts of Ken's actual code.
 * 
 * Ken's origianl Date Instance Methods and copyright notice:
 * 
 * Ken Snyder (ken d snyder at gmail dot com)
 * 2008-09-10
 * version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 * Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * jqplotToImage function based on Larry Siden's export-jqplot-to-png.js.
 * Larry has generously given permission to adapt his code for inclusion
 * into jqPlot.
 *
 * Larry's original code can be found here:
 *
 * https://github.com/lsiden/export-jqplot-to-png
 * 
 * 
 */
(function(j){j.jqplot.Cursor=function(q){this.style="crosshair";this.previousCursor="auto";this.show=j.jqplot.config.enablePlugins;this.showTooltip=true;this.followMouse=false;this.tooltipLocation="se";this.tooltipOffset=6;this.showTooltipGridPosition=false;this.showTooltipUnitPosition=true;this.showTooltipDataPosition=false;this.tooltipFormatString="%.4P, %.4P";this.useAxesFormatters=true;this.tooltipAxisGroups=[];this.zoom=false;this.zoomProxy=false;this.zoomTarget=false;this.looseZoom=true;this.clickReset=false;this.dblClickReset=true;this.showVerticalLine=false;this.showHorizontalLine=false;this.constrainZoomTo="none";this.shapeRenderer=new j.jqplot.ShapeRenderer();this._zoom={start:[],end:[],started:false,zooming:false,isZoomed:false,axes:{start:{},end:{}},gridpos:{},datapos:{}};this._tooltipElem;this.zoomCanvas;this.cursorCanvas;this.intersectionThreshold=2;this.showCursorLegend=false;this.cursorLegendFormatString=j.jqplot.Cursor.cursorLegendFormatString;this._oldHandlers={onselectstart:null,ondrag:null,onmousedown:null};this.constrainOutsideZoom=true;this.showTooltipOutsideZoom=false;this.onGrid=false;j.extend(true,this,q)};j.jqplot.Cursor.cursorLegendFormatString="%s x:%s, y:%s";j.jqplot.Cursor.init=function(t,s,r){var q=r||{};this.plugins.cursor=new j.jqplot.Cursor(q.cursor);var u=this.plugins.cursor;if(u.show){j.jqplot.eventListenerHooks.push(["jqplotMouseEnter",b]);j.jqplot.eventListenerHooks.push(["jqplotMouseLeave",f]);j.jqplot.eventListenerHooks.push(["jqplotMouseMove",i]);if(u.showCursorLegend){r.legend=r.legend||{};r.legend.renderer=j.jqplot.CursorLegendRenderer;r.legend.formatString=this.plugins.cursor.cursorLegendFormatString;r.legend.show=true}if(u.zoom){j.jqplot.eventListenerHooks.push(["jqplotMouseDown",a]);if(u.clickReset){j.jqplot.eventListenerHooks.push(["jqplotClick",k])}if(u.dblClickReset){j.jqplot.eventListenerHooks.push(["jqplotDblClick",c])}}this.resetZoom=function(){var x=this.axes;if(!u.zoomProxy){for(var w in x){x[w].reset();x[w]._ticks=[];if(u._zoom.axes[w]!==undefined){x[w]._autoFormatString=u._zoom.axes[w].tickFormatString}}this.redraw()}else{var v=this.plugins.cursor.zoomCanvas._ctx;v.clearRect(0,0,v.canvas.width,v.canvas.height);v=null}this.plugins.cursor._zoom.isZoomed=false;this.target.trigger("jqplotResetZoom",[this,this.plugins.cursor])};if(u.showTooltipDataPosition){u.showTooltipUnitPosition=false;u.showTooltipGridPosition=false;if(q.cursor.tooltipFormatString==undefined){u.tooltipFormatString=j.jqplot.Cursor.cursorLegendFormatString}}}};j.jqplot.Cursor.postDraw=function(){var x=this.plugins.cursor;if(x.zoomCanvas){x.zoomCanvas.resetCanvas();x.zoomCanvas=null}if(x.cursorCanvas){x.cursorCanvas.resetCanvas();x.cursorCanvas=null}if(x._tooltipElem){x._tooltipElem.emptyForce();x._tooltipElem=null}if(x.zoom){x.zoomCanvas=new j.jqplot.GenericCanvas();this.eventCanvas._elem.before(x.zoomCanvas.createElement(this._gridPadding,"jqplot-zoom-canvas",this._plotDimensions,this));x.zoomCanvas.setContext()}var v=document.createElement("div");x._tooltipElem=j(v);v=null;x._tooltipElem.addClass("jqplot-cursor-tooltip");x._tooltipElem.css({position:"absolute",display:"none"});if(x.zoomCanvas){x.zoomCanvas._elem.before(x._tooltipElem)}else{this.eventCanvas._elem.before(x._tooltipElem)}if(x.showVerticalLine||x.showHorizontalLine){x.cursorCanvas=new j.jqplot.GenericCanvas();this.eventCanvas._elem.before(x.cursorCanvas.createElement(this._gridPadding,"jqplot-cursor-canvas",this._plotDimensions,this));x.cursorCanvas.setContext()}if(x.showTooltipUnitPosition){if(x.tooltipAxisGroups.length===0){var t=this.series;var u;var q=[];for(var r=0;r<t.length;r++){u=t[r];var w=u.xaxis+","+u.yaxis;if(j.inArray(w,q)==-1){q.push(w)}}for(var r=0;r<q.length;r++){x.tooltipAxisGroups.push(q[r].split(","))}}}};j.jqplot.Cursor.zoomProxy=function(v,r){var q=v.plugins.cursor;var u=r.plugins.cursor;q.zoomTarget=true;q.zoom=true;q.style="auto";q.dblClickReset=false;u.zoom=true;u.zoomProxy=true;r.target.bind("jqplotZoom",t);r.target.bind("jqplotResetZoom",s);function t(x,w,z,y,A){q.doZoom(w,z,v,A)}function s(w,x,y){v.resetZoom()}};j.jqplot.Cursor.prototype.resetZoom=function(u,v){var t=u.axes;var s=v._zoom.axes;if(!u.plugins.cursor.zoomProxy&&v._zoom.isZoomed){for(var r in t){t[r].reset();t[r]._ticks=[];t[r]._autoFormatString=s[r].tickFormatString}u.redraw();v._zoom.isZoomed=false}else{var q=v.zoomCanvas._ctx;q.clearRect(0,0,q.canvas.width,q.canvas.height);q=null}u.target.trigger("jqplotResetZoom",[u,v])};j.jqplot.Cursor.resetZoom=function(q){q.resetZoom()};j.jqplot.Cursor.prototype.doZoom=function(G,t,C,u){var I=u;var F=C.axes;var r=I._zoom.axes;var w=r.start;var s=r.end;var B,E,z,D,v,x,q,H,J;var A=C.plugins.cursor.zoomCanvas._ctx;if((I.constrainZoomTo=="none"&&Math.abs(G.x-I._zoom.start[0])>6&&Math.abs(G.y-I._zoom.start[1])>6)||(I.constrainZoomTo=="x"&&Math.abs(G.x-I._zoom.start[0])>6)||(I.constrainZoomTo=="y"&&Math.abs(G.y-I._zoom.start[1])>6)){if(!C.plugins.cursor.zoomProxy){for(var y in t){if(I._zoom.axes[y]==undefined){I._zoom.axes[y]={};I._zoom.axes[y].numberTicks=F[y].numberTicks;I._zoom.axes[y].tickInterval=F[y].tickInterval;I._zoom.axes[y].daTickInterval=F[y].daTickInterval;I._zoom.axes[y].min=F[y].min;I._zoom.axes[y].max=F[y].max;I._zoom.axes[y].tickFormatString=(F[y].tickOptions!=null)?F[y].tickOptions.formatString:""}if((I.constrainZoomTo=="none")||(I.constrainZoomTo=="x"&&y.charAt(0)=="x")||(I.constrainZoomTo=="y"&&y.charAt(0)=="y")){z=t[y];if(z!=null){if(z>w[y]){v=w[y];x=z}else{D=w[y]-z;v=z;x=w[y]}q=F[y];H=null;if(q.alignTicks){if(q.name==="x2axis"&&C.axes.xaxis.show){H=C.axes.xaxis.numberTicks}else{if(q.name.charAt(0)==="y"&&q.name!=="yaxis"&&q.name!=="yMidAxis"&&C.axes.yaxis.show){H=C.axes.yaxis.numberTicks}}}if(this.looseZoom&&(F[y].renderer.constructor===j.jqplot.LinearAxisRenderer||F[y].renderer.constructor===j.jqplot.LogAxisRenderer)){J=j.jqplot.LinearTickGenerator(v,x,q._scalefact,H);if(F[y].tickInset&&J[0]<F[y].min+F[y].tickInset*F[y].tickInterval){J[0]+=J[4];J[2]-=1}if(F[y].tickInset&&J[1]>F[y].max-F[y].tickInset*F[y].tickInterval){J[1]-=J[4];J[2]-=1}if(F[y].renderer.constructor===j.jqplot.LogAxisRenderer&&J[0]<F[y].min){J[0]+=J[4];J[2]-=1}F[y].min=J[0];F[y].max=J[1];F[y]._autoFormatString=J[3];F[y].numberTicks=J[2];F[y].tickInterval=J[4];F[y].daTickInterval=[J[4]/1000,"seconds"]}else{F[y].min=v;F[y].max=x;F[y].tickInterval=null;F[y].numberTicks=null;F[y].daTickInterval=null}F[y]._ticks=[]}}}A.clearRect(0,0,A.canvas.width,A.canvas.height);C.redraw();I._zoom.isZoomed=true;A=null}C.target.trigger("jqplotZoom",[G,t,C,u])}};j.jqplot.preInitHooks.push(j.jqplot.Cursor.init);j.jqplot.postDrawHooks.push(j.jqplot.Cursor.postDraw);function e(G,r,C){var J=C.plugins.cursor;var w="";var N=false;if(J.showTooltipGridPosition){w=G.x+", "+G.y;N=true}if(J.showTooltipUnitPosition){var F;for(var E=0;E<J.tooltipAxisGroups.length;E++){F=J.tooltipAxisGroups[E];if(N){w+="<br />"}if(J.useAxesFormatters){for(var D=0;D<F.length;D++){if(D){w+=", "}var H=C.axes[F[D]]._ticks[0].formatter;var B=C.axes[F[D]]._ticks[0].formatString;w+=H(B,r[F[D]])}}else{w+=j.jqplot.sprintf(J.tooltipFormatString,r[F[0]],r[F[1]])}N=true}}if(J.showTooltipDataPosition){var u=C.series;var M=d(C,G.x,G.y);var N=false;for(var E=0;E<u.length;E++){if(u[E].show){var y=u[E].index;var t=u[E].label.toString();var I=j.inArray(y,M.indices);var z=undefined;var x=undefined;if(I!=-1){var L=M.data[I].data;if(J.useAxesFormatters){var A=u[E]._xaxis._ticks[0].formatter;var q=u[E]._yaxis._ticks[0].formatter;var K=u[E]._xaxis._ticks[0].formatString;var v=u[E]._yaxis._ticks[0].formatString;z=A(K,L[0]);x=q(v,L[1])}else{z=L[0];x=L[1]}if(N){w+="<br />"}w+=j.jqplot.sprintf(J.tooltipFormatString,t,z,x);N=true}}}}J._tooltipElem.html(w)}function g(C,A){var E=A.plugins.cursor;var z=E.cursorCanvas._ctx;z.clearRect(0,0,z.canvas.width,z.canvas.height);if(E.showVerticalLine){E.shapeRenderer.draw(z,[[C.x,0],[C.x,z.canvas.height]])}if(E.showHorizontalLine){E.shapeRenderer.draw(z,[[0,C.y],[z.canvas.width,C.y]])}var G=d(A,C.x,C.y);if(E.showCursorLegend){var r=j(A.targetId+" td.jqplot-cursor-legend-label");for(var B=0;B<r.length;B++){var v=j(r[B]).data("seriesIndex");var t=A.series[v];var s=t.label.toString();var D=j.inArray(v,G.indices);var x=undefined;var w=undefined;if(D!=-1){var H=G.data[D].data;if(E.useAxesFormatters){var y=t._xaxis._ticks[0].formatter;var q=t._yaxis._ticks[0].formatter;var F=t._xaxis._ticks[0].formatString;var u=t._yaxis._ticks[0].formatString;x=y(F,H[0]);w=q(u,H[1])}else{x=H[0];w=H[1]}}if(A.legend.escapeHtml){j(r[B]).text(j.jqplot.sprintf(E.cursorLegendFormatString,s,x,w))}else{j(r[B]).html(j.jqplot.sprintf(E.cursorLegendFormatString,s,x,w))}}}z=null}function d(A,F,E){var B={indices:[],data:[]};var G,w,u,C,v,q,t;var z;var D=A.plugins.cursor;for(var w=0;w<A.series.length;w++){G=A.series[w];q=G.renderer;if(G.show){z=D.intersectionThreshold;if(G.showMarker){z+=G.markerRenderer.size/2}for(var v=0;v<G.gridData.length;v++){t=G.gridData[v];if(D.showVerticalLine){if(Math.abs(F-t[0])<=z){B.indices.push(w);B.data.push({seriesIndex:w,pointIndex:v,gridData:t,data:G.data[v]})}}}}}return B}function n(r,t){var v=t.plugins.cursor;var s=v._tooltipElem;switch(v.tooltipLocation){case"nw":var q=r.x+t._gridPadding.left-s.outerWidth(true)-v.tooltipOffset;var u=r.y+t._gridPadding.top-v.tooltipOffset-s.outerHeight(true);break;case"n":var q=r.x+t._gridPadding.left-s.outerWidth(true)/2;var u=r.y+t._gridPadding.top-v.tooltipOffset-s.outerHeight(true);break;case"ne":var q=r.x+t._gridPadding.left+v.tooltipOffset;var u=r.y+t._gridPadding.top-v.tooltipOffset-s.outerHeight(true);break;case"e":var q=r.x+t._gridPadding.left+v.tooltipOffset;var u=r.y+t._gridPadding.top-s.outerHeight(true)/2;break;case"se":var q=r.x+t._gridPadding.left+v.tooltipOffset;var u=r.y+t._gridPadding.top+v.tooltipOffset;break;case"s":var q=r.x+t._gridPadding.left-s.outerWidth(true)/2;var u=r.y+t._gridPadding.top+v.tooltipOffset;break;case"sw":var q=r.x+t._gridPadding.left-s.outerWidth(true)-v.tooltipOffset;var u=r.y+t._gridPadding.top+v.tooltipOffset;break;case"w":var q=r.x+t._gridPadding.left-s.outerWidth(true)-v.tooltipOffset;var u=r.y+t._gridPadding.top-s.outerHeight(true)/2;break;default:var q=r.x+t._gridPadding.left+v.tooltipOffset;var u=r.y+t._gridPadding.top+v.tooltipOffset;break}s.css("left",q);s.css("top",u);s=null}function m(u){var s=u._gridPadding;var v=u.plugins.cursor;var t=v._tooltipElem;switch(v.tooltipLocation){case"nw":var r=s.left+v.tooltipOffset;var q=s.top+v.tooltipOffset;t.css("left",r);t.css("top",q);break;case"n":var r=(s.left+(u._plotDimensions.width-s.right))/2-t.outerWidth(true)/2;var q=s.top+v.tooltipOffset;t.css("left",r);t.css("top",q);break;case"ne":var r=s.right+v.tooltipOffset;var q=s.top+v.tooltipOffset;t.css({right:r,top:q});break;case"e":var r=s.right+v.tooltipOffset;var q=(s.top+(u._plotDimensions.height-s.bottom))/2-t.outerHeight(true)/2;t.css({right:r,top:q});break;case"se":var r=s.right+v.tooltipOffset;var q=s.bottom+v.tooltipOffset;t.css({right:r,bottom:q});break;case"s":var r=(s.left+(u._plotDimensions.width-s.right))/2-t.outerWidth(true)/2;var q=s.bottom+v.tooltipOffset;t.css({left:r,bottom:q});break;case"sw":var r=s.left+v.tooltipOffset;var q=s.bottom+v.tooltipOffset;t.css({left:r,bottom:q});break;case"w":var r=s.left+v.tooltipOffset;var q=(s.top+(u._plotDimensions.height-s.bottom))/2-t.outerHeight(true)/2;t.css({left:r,top:q});break;default:var r=s.right-v.tooltipOffset;var q=s.bottom+v.tooltipOffset;t.css({right:r,bottom:q});break}t=null}function k(r,q,v,u,t){r.preventDefault();r.stopImmediatePropagation();var w=t.plugins.cursor;if(w.clickReset){w.resetZoom(t,w)}var s=window.getSelection;if(document.selection&&document.selection.empty){document.selection.empty()}else{if(s&&!s().isCollapsed){s().collapse()}}return false}function c(r,q,v,u,t){r.preventDefault();r.stopImmediatePropagation();var w=t.plugins.cursor;if(w.dblClickReset){w.resetZoom(t,w)}var s=window.getSelection;if(document.selection&&document.selection.empty){document.selection.empty()}else{if(s&&!s().isCollapsed){s().collapse()}}return false}function f(w,t,q,z,u){var v=u.plugins.cursor;v.onGrid=false;if(v.show){j(w.target).css("cursor",v.previousCursor);if(v.showTooltip&&!(v._zoom.zooming&&v.showTooltipOutsideZoom&&!v.constrainOutsideZoom)){v._tooltipElem.empty();v._tooltipElem.hide()}if(v.zoom){v._zoom.gridpos=t;v._zoom.datapos=q}if(v.showVerticalLine||v.showHorizontalLine){var B=v.cursorCanvas._ctx;B.clearRect(0,0,B.canvas.width,B.canvas.height);B=null}if(v.showCursorLegend){var A=j(u.targetId+" td.jqplot-cursor-legend-label");for(var s=0;s<A.length;s++){var y=j(A[s]).data("seriesIndex");var r=u.series[y];var x=r.label.toString();if(u.legend.escapeHtml){j(A[s]).text(j.jqplot.sprintf(v.cursorLegendFormatString,x,undefined,undefined))}else{j(A[s]).html(j.jqplot.sprintf(v.cursorLegendFormatString,x,undefined,undefined))}}}}}function b(r,q,u,t,s){var v=s.plugins.cursor;v.onGrid=true;if(v.show){v.previousCursor=r.target.style.cursor;r.target.style.cursor=v.style;if(v.showTooltip){e(q,u,s);if(v.followMouse){n(q,s)}else{m(s)}v._tooltipElem.show()}if(v.showVerticalLine||v.showHorizontalLine){g(q,s)}}}function i(r,q,u,t,s){var v=s.plugins.cursor;if(v.show){if(v.showTooltip){e(q,u,s);if(v.followMouse){n(q,s)}}if(v.showVerticalLine||v.showHorizontalLine){g(q,s)}}}function o(y){var x=y.data.plot;var t=x.eventCanvas._elem.offset();var w={x:y.pageX-t.left,y:y.pageY-t.top};var u={xaxis:null,yaxis:null,x2axis:null,y2axis:null,y3axis:null,y4axis:null,y5axis:null,y6axis:null,y7axis:null,y8axis:null,y9axis:null,yMidAxis:null};var v=["xaxis","yaxis","x2axis","y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis","yMidAxis"];var q=x.axes;var r,s;for(r=11;r>0;r--){s=v[r-1];if(q[s].show){u[s]=q[s].series_p2u(w[s.charAt(0)])}}return{offsets:t,gridPos:w,dataPos:u}}function h(z){var x=z.data.plot;var y=x.plugins.cursor;if(y.show&&y.zoom&&y._zoom.started&&!y.zoomTarget){z.preventDefault();var B=y.zoomCanvas._ctx;var v=o(z);var w=v.gridPos;var t=v.dataPos;y._zoom.gridpos=w;y._zoom.datapos=t;y._zoom.zooming=true;var u=w.x;var s=w.y;var A=B.canvas.height;var q=B.canvas.width;if(y.showTooltip&&!y.onGrid&&y.showTooltipOutsideZoom){e(w,t,x);if(y.followMouse){n(w,x)}}if(y.constrainZoomTo=="x"){y._zoom.end=[u,A]}else{if(y.constrainZoomTo=="y"){y._zoom.end=[q,s]}else{y._zoom.end=[u,s]}}var r=window.getSelection;if(document.selection&&document.selection.empty){document.selection.empty()}else{if(r&&!r().isCollapsed){r().collapse()}}l.call(y);B=null}}function a(w,s,r,x,t){var v=t.plugins.cursor;if(t.plugins.mobile){j(document).one("vmouseup.jqplot_cursor",{plot:t},p)}else{j(document).one("mouseup.jqplot_cursor",{plot:t},p)}var u=t.axes;if(document.onselectstart!=undefined){v._oldHandlers.onselectstart=document.onselectstart;document.onselectstart=function(){return false}}if(document.ondrag!=undefined){v._oldHandlers.ondrag=document.ondrag;document.ondrag=function(){return false}}if(document.onmousedown!=undefined){v._oldHandlers.onmousedown=document.onmousedown;document.onmousedown=function(){return false}}if(v.zoom){if(!v.zoomProxy){var y=v.zoomCanvas._ctx;y.clearRect(0,0,y.canvas.width,y.canvas.height);y=null}if(v.constrainZoomTo=="x"){v._zoom.start=[s.x,0]}else{if(v.constrainZoomTo=="y"){v._zoom.start=[0,s.y]}else{v._zoom.start=[s.x,s.y]}}v._zoom.started=true;for(var q in r){v._zoom.axes.start[q]=r[q]}if(t.plugins.mobile){j(document).bind("vmousemove.jqplotCursor",{plot:t},h)}else{j(document).bind("mousemove.jqplotCursor",{plot:t},h)}}}function p(y){var v=y.data.plot;var x=v.plugins.cursor;if(x.zoom&&x._zoom.zooming&&!x.zoomTarget){var u=x._zoom.gridpos.x;var r=x._zoom.gridpos.y;var t=x._zoom.datapos;var z=x.zoomCanvas._ctx.canvas.height;var q=x.zoomCanvas._ctx.canvas.width;var w=v.axes;if(x.constrainOutsideZoom&&!x.onGrid){if(u<0){u=0}else{if(u>q){u=q}}if(r<0){r=0}else{if(r>z){r=z}}for(var s in t){if(t[s]){if(s.charAt(0)=="x"){t[s]=w[s].series_p2u(u)}else{t[s]=w[s].series_p2u(r)}}}}if(x.constrainZoomTo=="x"){r=z}else{if(x.constrainZoomTo=="y"){u=q}}x._zoom.end=[u,r];x._zoom.gridpos={x:u,y:r};x.doZoom(x._zoom.gridpos,t,v,x)}x._zoom.started=false;x._zoom.zooming=false;j(document).unbind("mousemove.jqplotCursor",h);if(document.onselectstart!=undefined&&x._oldHandlers.onselectstart!=null){document.onselectstart=x._oldHandlers.onselectstart;x._oldHandlers.onselectstart=null}if(document.ondrag!=undefined&&x._oldHandlers.ondrag!=null){document.ondrag=x._oldHandlers.ondrag;x._oldHandlers.ondrag=null}if(document.onmousedown!=undefined&&x._oldHandlers.onmousedown!=null){document.onmousedown=x._oldHandlers.onmousedown;x._oldHandlers.onmousedown=null}}function l(){var y=this._zoom.start;var u=this._zoom.end;var s=this.zoomCanvas._ctx;var r,v,x,q;if(u[0]>y[0]){r=y[0];q=u[0]-y[0]}else{r=u[0];q=y[0]-u[0]}if(u[1]>y[1]){v=y[1];x=u[1]-y[1]}else{v=u[1];x=y[1]-u[1]}s.fillStyle="rgba(0,0,0,0.2)";s.strokeStyle="#999999";s.lineWidth=1;s.clearRect(0,0,s.canvas.width,s.canvas.height);s.fillRect(0,0,s.canvas.width,s.canvas.height);s.clearRect(r,v,q,x);s.strokeRect(r,v,q,x);s=null}j.jqplot.CursorLegendRenderer=function(q){j.jqplot.TableLegendRenderer.call(this,q);this.formatString="%s"};j.jqplot.CursorLegendRenderer.prototype=new j.jqplot.TableLegendRenderer();j.jqplot.CursorLegendRenderer.prototype.constructor=j.jqplot.CursorLegendRenderer;j.jqplot.CursorLegendRenderer.prototype.draw=function(){if(this._elem){this._elem.emptyForce();this._elem=null}if(this.show){var w=this._series,A;var r=document.createElement("div");this._elem=j(r);r=null;this._elem.addClass("jqplot-legend jqplot-cursor-legend");this._elem.css("position","absolute");var q=false;for(var x=0;x<w.length;x++){A=w[x];if(A.show&&A.showLabel){var v=j.jqplot.sprintf(this.formatString,A.label.toString());if(v){var t=A.color;if(A._stack&&!A.fill){t=""}z.call(this,v,t,q,x);q=true}for(var u=0;u<j.jqplot.addLegendRowHooks.length;u++){var y=j.jqplot.addLegendRowHooks[u].call(this,A);if(y){z.call(this,y.label,y.color,q);q=true}}}}w=A=null;delete w;delete A}function z(D,C,F,s){var B=(F)?this.rowSpacing:"0";var E=j('<tr class="jqplot-legend jqplot-cursor-legend"></tr>').appendTo(this._elem);E.data("seriesIndex",s);j('<td class="jqplot-legend jqplot-cursor-legend-swatch" style="padding-top:'+B+';"><div style="border:1px solid #cccccc;padding:0.2em;"><div class="jqplot-cursor-legend-swatch" style="background-color:'+C+';"></div></div></td>').appendTo(E);var G=j('<td class="jqplot-legend jqplot-cursor-legend-label" style="vertical-align:middle;padding-top:'+B+';"></td>');G.appendTo(E);G.data("seriesIndex",s);if(this.escapeHtml){G.text(D)}else{G.html(D)}E=null;G=null}return this._elem}})(jQuery);/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.1r1097
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 *
 * included jsDate library by Chris Leonello:
 *
 * Copyright (c) 2010-2011 Chris Leonello
 *
 * jsDate is currently available for use in all personal or commercial projects 
 * under both the MIT and GPL version 2.0 licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly.
 *
 * jsDate borrows many concepts and ideas from the Date Instance 
 * Methods by Ken Snyder along with some parts of Ken's actual code.
 * 
 * Ken's origianl Date Instance Methods and copyright notice:
 * 
 * Ken Snyder (ken d snyder at gmail dot com)
 * 2008-09-10
 * version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 * Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * jqplotToImage function based on Larry Siden's export-jqplot-to-png.js.
 * Larry has generously given permission to adapt his code for inclusion
 * into jqPlot.
 *
 * Larry's original code can be found here:
 *
 * https://github.com/lsiden/export-jqplot-to-png
 * 
 * 
 */
(function(d){d.jqplot.eventListenerHooks.push(["jqplotMouseMove",f]);d.jqplot.Highlighter=function(h){this.show=d.jqplot.config.enablePlugins;this.markerRenderer=new d.jqplot.MarkerRenderer({shadow:false});this.showMarker=true;this.lineWidthAdjust=2.5;this.sizeAdjust=5;this.showTooltip=true;this.tooltipLocation="nw";this.fadeTooltip=true;this.tooltipFadeSpeed="fast";this.tooltipOffset=2;this.tooltipAxes="both";this.tooltipSeparator=", ";this.tooltipContentEditor=null;this.useAxesFormatters=true;this.tooltipFormatString="%.5P";this.formatString=null;this.yvalues=1;this.bringSeriesToFront=false;this._tooltipElem;this.isHighlighting=false;this.currentNeighbor=null;d.extend(true,this,h)};var b=["nw","n","ne","e","se","s","sw","w"];var e={nw:0,n:1,ne:2,e:3,se:4,s:5,sw:6,w:7};var c=["se","s","sw","w","nw","n","ne","e"];d.jqplot.Highlighter.init=function(k,j,i){var h=i||{};this.plugins.highlighter=new d.jqplot.Highlighter(h.highlighter)};d.jqplot.Highlighter.parseOptions=function(i,h){this.showHighlight=true};d.jqplot.Highlighter.postPlotDraw=function(){if(this.plugins.highlighter&&this.plugins.highlighter.highlightCanvas){this.plugins.highlighter.highlightCanvas.resetCanvas();this.plugins.highlighter.highlightCanvas=null}if(this.plugins.highlighter&&this.plugins.highlighter._tooltipElem){this.plugins.highlighter._tooltipElem.emptyForce();this.plugins.highlighter._tooltipElem=null}this.plugins.highlighter.highlightCanvas=new d.jqplot.GenericCanvas();this.eventCanvas._elem.before(this.plugins.highlighter.highlightCanvas.createElement(this._gridPadding,"jqplot-highlight-canvas",this._plotDimensions,this));this.plugins.highlighter.highlightCanvas.setContext();var h=document.createElement("div");this.plugins.highlighter._tooltipElem=d(h);h=null;this.plugins.highlighter._tooltipElem.addClass("jqplot-highlighter-tooltip");this.plugins.highlighter._tooltipElem.css({position:"absolute",display:"none"});this.eventCanvas._elem.before(this.plugins.highlighter._tooltipElem)};d.jqplot.preInitHooks.push(d.jqplot.Highlighter.init);d.jqplot.preParseSeriesOptionsHooks.push(d.jqplot.Highlighter.parseOptions);d.jqplot.postDrawHooks.push(d.jqplot.Highlighter.postPlotDraw);function a(m,o){var j=m.plugins.highlighter;var p=m.series[o.seriesIndex];var h=p.markerRenderer;var i=j.markerRenderer;i.style=h.style;i.lineWidth=h.lineWidth+j.lineWidthAdjust;i.size=h.size+j.sizeAdjust;var l=d.jqplot.getColorComponents(h.color);var n=[l[0],l[1],l[2]];var k=(l[3]>=0.6)?l[3]*0.6:l[3]*(2-l[3]);i.color="rgba("+n[0]+","+n[1]+","+n[2]+","+k+")";i.init();i.draw(p.gridData[o.pointIndex][0],p.gridData[o.pointIndex][1],j.highlightCanvas._ctx)}function g(A,q,m){var k=A.plugins.highlighter;var D=k._tooltipElem;var r=q.highlighter||{};var t=d.extend(true,{},k,r);if(t.useAxesFormatters){var w=q._xaxis._ticks[0].formatter;var h=q._yaxis._ticks[0].formatter;var E=q._xaxis._ticks[0].formatString;var s=q._yaxis._ticks[0].formatString;var z;var u=w(E,m.data[0]);var l=[];for(var B=1;B<t.yvalues+1;B++){l.push(h(s,m.data[B]))}if(typeof t.formatString==="string"){switch(t.tooltipAxes){case"both":case"xy":l.unshift(u);l.unshift(t.formatString);z=d.jqplot.sprintf.apply(d.jqplot.sprintf,l);break;case"yx":l.push(u);l.unshift(t.formatString);z=d.jqplot.sprintf.apply(d.jqplot.sprintf,l);break;case"x":z=d.jqplot.sprintf.apply(d.jqplot.sprintf,[t.formatString,u]);break;case"y":l.unshift(t.formatString);z=d.jqplot.sprintf.apply(d.jqplot.sprintf,l);break;default:l.unshift(u);l.unshift(t.formatString);z=d.jqplot.sprintf.apply(d.jqplot.sprintf,l);break}}else{switch(t.tooltipAxes){case"both":case"xy":z=u;for(var B=0;B<l.length;B++){z+=t.tooltipSeparator+l[B]}break;case"yx":z="";for(var B=0;B<l.length;B++){z+=l[B]+t.tooltipSeparator}z+=u;break;case"x":z=u;break;case"y":z=l.join(t.tooltipSeparator);break;default:z=u;for(var B=0;B<l.length;B++){z+=t.tooltipSeparator+l[B]}break}}}else{var z;if(typeof t.formatString==="string"){z=d.jqplot.sprintf.apply(d.jqplot.sprintf,[t.formatString].concat(m.data))}else{if(t.tooltipAxes=="both"||t.tooltipAxes=="xy"){z=d.jqplot.sprintf(t.tooltipFormatString,m.data[0])+t.tooltipSeparator+d.jqplot.sprintf(t.tooltipFormatString,m.data[1])}else{if(t.tooltipAxes=="yx"){z=d.jqplot.sprintf(t.tooltipFormatString,m.data[1])+t.tooltipSeparator+d.jqplot.sprintf(t.tooltipFormatString,m.data[0])}else{if(t.tooltipAxes=="x"){z=d.jqplot.sprintf(t.tooltipFormatString,m.data[0])}else{if(t.tooltipAxes=="y"){z=d.jqplot.sprintf(t.tooltipFormatString,m.data[1])}}}}}}if(d.isFunction(t.tooltipContentEditor)){z=t.tooltipContentEditor(z,m.seriesIndex,m.pointIndex,A)}D.html(z);var C={x:m.gridData[0],y:m.gridData[1]};var v=0;var j=0.707;if(q.markerRenderer.show==true){v=(q.markerRenderer.size+t.sizeAdjust)/2}var o=b;if(q.fillToZero&&q.fill&&m.data[1]<0){o=c}switch(o[e[t.tooltipLocation]]){case"nw":var p=C.x+A._gridPadding.left-D.outerWidth(true)-t.tooltipOffset-j*v;var n=C.y+A._gridPadding.top-t.tooltipOffset-D.outerHeight(true)-j*v;break;case"n":var p=C.x+A._gridPadding.left-D.outerWidth(true)/2;var n=C.y+A._gridPadding.top-t.tooltipOffset-D.outerHeight(true)-v;break;case"ne":var p=C.x+A._gridPadding.left+t.tooltipOffset+j*v;var n=C.y+A._gridPadding.top-t.tooltipOffset-D.outerHeight(true)-j*v;break;case"e":var p=C.x+A._gridPadding.left+t.tooltipOffset+v;var n=C.y+A._gridPadding.top-D.outerHeight(true)/2;break;case"se":var p=C.x+A._gridPadding.left+t.tooltipOffset+j*v;var n=C.y+A._gridPadding.top+t.tooltipOffset+j*v;break;case"s":var p=C.x+A._gridPadding.left-D.outerWidth(true)/2;var n=C.y+A._gridPadding.top+t.tooltipOffset+v;break;case"sw":var p=C.x+A._gridPadding.left-D.outerWidth(true)-t.tooltipOffset-j*v;var n=C.y+A._gridPadding.top+t.tooltipOffset+j*v;break;case"w":var p=C.x+A._gridPadding.left-D.outerWidth(true)-t.tooltipOffset-v;var n=C.y+A._gridPadding.top-D.outerHeight(true)/2;break;default:var p=C.x+A._gridPadding.left-D.outerWidth(true)-t.tooltipOffset-j*v;var n=C.y+A._gridPadding.top-t.tooltipOffset-D.outerHeight(true)-j*v;break}D.css("left",p);D.css("top",n);if(t.fadeTooltip){D.stop(true,true).fadeIn(t.tooltipFadeSpeed)}else{D.show()}D=null}function f(n,j,i,p,l){var h=l.plugins.highlighter;var m=l.plugins.cursor;if(h.show){if(p==null&&h.isHighlighting){var o=jQuery.Event("jqplotHighlighterUnhighlight");l.target.trigger(o);var q=h.highlightCanvas._ctx;q.clearRect(0,0,q.canvas.width,q.canvas.height);if(h.fadeTooltip){h._tooltipElem.fadeOut(h.tooltipFadeSpeed)}else{h._tooltipElem.hide()}if(h.bringSeriesToFront){l.restorePreviousSeriesOrder()}h.isHighlighting=false;h.currentNeighbor=null;q=null}else{if(p!=null&&l.series[p.seriesIndex].showHighlight&&!h.isHighlighting){var o=jQuery.Event("jqplotHighlighterHighlight");o.which=n.which;o.pageX=n.pageX;o.pageY=n.pageY;var k=[p.seriesIndex,p.pointIndex,p.data,l];l.target.trigger(o,k);h.isHighlighting=true;h.currentNeighbor=p;if(h.showMarker){a(l,p)}if(h.showTooltip&&(!m||!m._zoom.started)){g(l,l.series[p.seriesIndex],p)}if(h.bringSeriesToFront){l.moveSeriesToFront(p.seriesIndex)}}else{if(p!=null&&h.isHighlighting&&h.currentNeighbor!=p){if(l.series[p.seriesIndex].showHighlight){var q=h.highlightCanvas._ctx;q.clearRect(0,0,q.canvas.width,q.canvas.height);h.isHighlighting=true;h.currentNeighbor=p;if(h.showMarker){a(l,p)}if(h.showTooltip&&(!m||!m._zoom.started)){g(l,l.series[p.seriesIndex],p)}if(h.bringSeriesToFront){l.moveSeriesToFront(p.seriesIndex)}}}}}}}})(jQuery);/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.1r1097
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 *
 * included jsDate library by Chris Leonello:
 *
 * Copyright (c) 2010-2011 Chris Leonello
 *
 * jsDate is currently available for use in all personal or commercial projects 
 * under both the MIT and GPL version 2.0 licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly.
 *
 * jsDate borrows many concepts and ideas from the Date Instance 
 * Methods by Ken Snyder along with some parts of Ken's actual code.
 * 
 * Ken's origianl Date Instance Methods and copyright notice:
 * 
 * Ken Snyder (ken d snyder at gmail dot com)
 * 2008-09-10
 * version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 * Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * jqplotToImage function based on Larry Siden's export-jqplot-to-png.js.
 * Larry has generously given permission to adapt his code for inclusion
 * into jqPlot.
 *
 * Larry's original code can be found here:
 *
 * https://github.com/lsiden/export-jqplot-to-png
 * 
 * 
 */
(function(a){a.jqplot.LogAxisRenderer=function(){a.jqplot.LinearAxisRenderer.call(this);this.axisDefaults={base:10,tickDistribution:"power"}};a.jqplot.LogAxisRenderer.prototype=new a.jqplot.LinearAxisRenderer();a.jqplot.LogAxisRenderer.prototype.constructor=a.jqplot.LogAxisRenderer;a.jqplot.LogAxisRenderer.prototype.init=function(b){this.drawBaseline=true;this.minorTicks="auto";this._scalefact=1;a.extend(true,this,b);this._autoFormatString="%d";this._overrideFormatString=false;for(var c in this.renderer.axisDefaults){if(this[c]==null){this[c]=this.renderer.axisDefaults[c]}}this.resetDataBounds()};a.jqplot.LogAxisRenderer.prototype.createTicks=function(d){var G=this._ticks;var w=this.ticks;var s=this.name;var u=this._dataBounds;var b=(this.name.charAt(0)==="x")?this._plotDimensions.width:this._plotDimensions.height;var k;var N,v;var m,l;var M,K;var g=30;this._scalefact=(Math.max(b,g+1)-g)/300;if(w.length){for(K=0;K<w.length;K++){var A=w[K];var H=new this.tickRenderer(this.tickOptions);if(A.constructor==Array){H.value=A[0];H.label=A[1];if(!this.showTicks){H.showLabel=false;H.showMark=false}else{if(!this.showTickMarks){H.showMark=false}}H.setTick(A[0],this.name);this._ticks.push(H)}else{if(a.isPlainObject(A)){a.extend(true,H,A);H.axis=this.name;this._ticks.push(H)}else{H.value=A;if(!this.showTicks){H.showLabel=false;H.showMark=false}else{if(!this.showTickMarks){H.showMark=false}}H.setTick(A,this.name);this._ticks.push(H)}}}this.numberTicks=w.length;this.min=this._ticks[0].value;this.max=this._ticks[this.numberTicks-1].value}else{if(this.min==null&&this.max==null){N=u.min*(2-this.padMin);v=u.max*this.padMax;if(N==v){var c=0.05;N=N*(1-c);v=v*(1+c)}if(this.min!=null&&this.min<=0){throw ("log axis minimum must be greater than 0")}if(this.max!=null&&this.max<=0){throw ("log axis maximum must be greater than 0")}function f(j){var i=Math.pow(10,Math.floor(Math.log(j)/Math.LN10));return Math.ceil(j/i)*i}function x(j){var i=Math.pow(10,Math.floor(Math.log(j)/Math.LN10));return Math.floor(j/i)*i}var F,r;F=Math.pow(this.base,Math.floor(Math.log(N)/Math.log(this.base)));r=Math.pow(this.base,Math.ceil(Math.log(v)/Math.log(this.base)));var E=Math.round(Math.log(F)/Math.LN10);if(this.tickOptions==null||!this.tickOptions.formatString){this._overrideFormatString=true}this.min=F;this.max=r;var q=this.max-this.min;var C=(this.minorTicks==="auto")?0:this.minorTicks;var h;if(this.numberTicks==null){if(b>140){h=Math.round(Math.log(this.max/this.min)/Math.log(this.base)+1);if(h<2){h=2}if(C===0){var o=b/(h-1);if(o<100){C=0}else{if(o<190){C=1}else{if(o<250){C=3}else{if(o<600){C=4}else{C=9}}}}}}else{h=2;if(C===0){C=1}C=0}}else{h=this.numberTicks}if(E>=0&&C!==3){this._autoFormatString="%d"}else{if(E<=0&&C===3){var o=-(E-1);this._autoFormatString="%."+Math.abs(E-1)+"f"}else{if(E<0){var o=-E;this._autoFormatString="%."+Math.abs(E)+"f"}else{this._autoFormatString="%d"}}}var O,H,z,p,n,k;for(var K=0;K<h;K++){M=Math.pow(this.base,K-h+1)*this.max;H=new this.tickRenderer(this.tickOptions);if(this._overrideFormatString){H.formatString=this._autoFormatString}if(!this.showTicks){H.showLabel=false;H.showMark=false}else{if(!this.showTickMarks){H.showMark=false}}H.setTick(M,this.name);this._ticks.push(H);if(C&&K<h-1){p=Math.pow(this.base,K-h+2)*this.max;n=p-M;k=p/(C+1);for(var J=C-1;J>=0;J--){z=p-k*(J+1);H=new this.tickRenderer(this.tickOptions);if(this._overrideFormatString&&this._autoFormatString!=""){H.formatString=this._autoFormatString}if(!this.showTicks){H.showLabel=false;H.showMark=false}else{if(!this.showTickMarks){H.showMark=false}}H.setTick(z,this.name);this._ticks.push(H)}}}}else{if(this.min!=null&&this.max!=null){var y=a.extend(true,{},this.tickOptions,{name:this.name,value:null});var I,e;if(this.numberTicks==null&&this.tickInterval==null){var D=Math.max(b,g+1);var L=Math.ceil((D-g)/35+1);var B=a.jqplot.LinearTickGenerator.bestConstrainedInterval(this.min,this.max,L);this._autoFormatString=B[3];I=B[2];e=B[4];for(var K=0;K<I;K++){y.value=this.min+K*e;H=new this.tickRenderer(y);if(this._overrideFormatString&&this._autoFormatString!=""){H.formatString=this._autoFormatString}if(!this.showTicks){H.showLabel=false;H.showMark=false}else{if(!this.showTickMarks){H.showMark=false}}this._ticks.push(H)}}else{if(this.numberTicks!=null&&this.tickInterval!=null){I=this.numberTicks;for(var K=0;K<I;K++){y.value=this.min+K*this.tickInterval;H=new this.tickRenderer(y);if(this._overrideFormatString&&this._autoFormatString!=""){H.formatString=this._autoFormatString}if(!this.showTicks){H.showLabel=false;H.showMark=false}else{if(!this.showTickMarks){H.showMark=false}}this._ticks.push(H)}}}}}}};a.jqplot.LogAxisRenderer.prototype.pack=function(f,e){var r=parseInt(this.base,10);var y=this._ticks;var d=function(h){return Math.log(h)/Math.log(r)};var b=function(h){return Math.pow(Math.E,(Math.log(r)*h))};var u=d(this.max);var s=d(this.min);var m=e.max;var k=e.min;var o=(this._label==null)?false:this._label.show;for(var q in f){this._elem.css(q,f[q])}this._offsets=e;var g=m-k;var j=u-s;this.p2u=function(h){return b((h-k)*j/g+s)};this.u2p=function(h){return(d(h)-s)*g/j+k};if(this.name=="xaxis"||this.name=="x2axis"){this.series_u2p=function(h){return(d(h)-s)*g/j};this.series_p2u=function(h){return b(h*j/g+s)}}else{this.series_u2p=function(h){return(d(h)-u)*g/j};this.series_p2u=function(h){return b(h*j/g+u)}}if(this.show){if(this.name=="xaxis"||this.name=="x2axis"){for(var v=0;v<y.length;v++){var n=y[v];if(n.show&&n.showLabel){var c;if(n.constructor==a.jqplot.CanvasAxisTickRenderer&&n.angle){switch(n.labelPosition){case"auto":if(n.angle<0){c=-n.getWidth()+n._textRenderer.height*Math.sin(-n._textRenderer.angle)/2}else{c=-n._textRenderer.height*Math.sin(n._textRenderer.angle)/2}break;case"end":c=-n.getWidth()+n._textRenderer.height*Math.sin(-n._textRenderer.angle)/2;break;case"start":c=-n._textRenderer.height*Math.sin(n._textRenderer.angle)/2;break;case"middle":c=-n.getWidth()/2+n._textRenderer.height*Math.sin(-n._textRenderer.angle)/2;break;default:c=-n.getWidth()/2+n._textRenderer.height*Math.sin(-n._textRenderer.angle)/2;break}}else{c=-n.getWidth()/2}var z=this.u2p(n.value)+c+"px";n._elem.css("left",z);n.pack()}}if(o){var l=this._label._elem.outerWidth(true);this._label._elem.css("left",k+g/2-l/2+"px");if(this.name=="xaxis"){this._label._elem.css("bottom","0px")}else{this._label._elem.css("top","0px")}this._label.pack()}}else{for(var v=0;v<y.length;v++){var n=y[v];if(n.show&&n.showLabel){var c;if(n.constructor==a.jqplot.CanvasAxisTickRenderer&&n.angle){switch(n.labelPosition){case"auto":case"end":if(n.angle<0){c=-n._textRenderer.height*Math.cos(-n._textRenderer.angle)/2}else{c=-n.getHeight()+n._textRenderer.height*Math.cos(n._textRenderer.angle)/2}break;case"start":if(n.angle>0){c=-n._textRenderer.height*Math.cos(-n._textRenderer.angle)/2}else{c=-n.getHeight()+n._textRenderer.height*Math.cos(n._textRenderer.angle)/2}break;case"middle":c=-n.getHeight()/2;break;default:c=-n.getHeight()/2;break}}else{c=-n.getHeight()/2}var z=this.u2p(n.value)+c+"px";n._elem.css("top",z);n.pack()}}if(o){var x=this._label._elem.outerHeight(true);this._label._elem.css("top",m-g/2-x/2+"px");if(this.name=="yaxis"){this._label._elem.css("left","0px")}else{this._label._elem.css("right","0px")}this._label.pack()}}}}})(jQuery);/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Affichage d'une animation. Appelle SimuParams.initCalculLive() au début,
 * puis SimuParams.calculLive() à chaque itération. Le paramètre de sortie
 * de l'algorithme doit être un tableau avec l'intensité des pixels de l'image
 * à chaque itération, ou un tableau avec des entrées de la palette de couleurs.
 */
//public AffImage(SimuApplet applet, Affichage aff, boolean sousaff, boolean live) {
//public class AffImage extends TypeAffichage implements ActionListener {

AffImage.prototype = new TypeAffichage();
AffImage.prototype.constructor = AffImage;

function AffImage(applet, aff, sousaff, live) {
    this.applet = applet;
    this.aff = aff;
    this.sousaff = sousaff;
    this.live = live;
    this.ic = null; // ImageCanvas
    this.info = null;
    this.chrono = null;
    this.bstop = null;
    this.bstart = null;
    this.outp = null;
    
    var moi = this;
    this.actionPerformedProxy = function(e) { moi.actionPerformed(e) };
}

AffImage.prototype.ajouterBoutons = function(div) {
    var bouton;
    
    divboutons = document.createElement('div');
    divboutons.setAttribute('id', 'boutons');
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("continuer"));
    bouton.setAttribute('id', 'continuer');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    this.bstart = bouton;
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("stop"));
    bouton.setAttribute('id', 'stop');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    this.bstop = bouton;
    
    div.appendChild(divboutons);
}

//public Panel initPanel(Vector outp) throws SimuException {
AffImage.prototype.initPanel = function(outp, dimensions) {
    var div_affichage, avecinfo, i, par;
    
    this.outp = outp;
    
    div_affichage = document.createElement('div');
    if (!this.sousaff)
        div_affichage.setAttribute('id', 'affichage');
    div_affichage.style.width = dimensions.width + 'px';
    div_affichage.style.height = dimensions.height + 'px';
    
    if (!this.sousaff && this.live)
        this.ajouterBoutons(div_affichage);
    
    if (this.ic == null)
        this.ic = new ImageCanvas(this.aff.imgdimx, this.aff.imgdimy, this.aff.palette);
    div_affichage.appendChild(this.ic.getCanvas());
    
    avecinfo = false;
    for (i=0; i<outp.length; i++) {
        par = outp[i];
        if (par.type == 'string')
            avecinfo = true;
    }
    if (avecinfo) {
        this.info = document.createElement('div');
        this.info.setAttribute('id', 'info');
        this.info.appendChild(document.createTextNode(' '));
        div_affichage.appendChild(this.info);
    } else
        this.info = null;

    return(div_affichage);
}

AffImage.prototype.estLive = function() {
    return(this.live);
}

AffImage.prototype.setChronos = function(chrono) {
    this.chrono = chrono;
}

//public void affiche(ListeValeurs in, Vector outp) throws SimuException {
AffImage.prototype.affiche = function(lin, outp) {
    var out;
    
    this.outp = outp;
    
    if (this.live)
        this.start(); // affichage au fur et à mesure dans l'image
    else {
        out =  this.applet.calcul(lin);
        this.update(out);
    }
}

AffImage.prototype.start = function() {
    this.bstop.disabled = false;
    this.bstart.disabled = true;
    this.chrono.start();
}

AffImage.prototype.stop = function() {
    if (this.bstop != null)
        this.bstop.disabled = true;
    if (this.bstart != null)
        this.bstart.disabled = false;
    this.chrono.stop();
}

AffImage.prototype.fin = function() {
    this.bstop.disabled = true;
    this.bstart.disabled = true;
    //this.chrono = null;
}

//public void update(ListeValeurs out) throws SimuException {
AffImage.prototype.update = function(out) {
    var trouve, ip, lp, i, par, o;
    
    trouve = false;
    for (ip=0; ip<this.aff.params[0].length; ip++) {
        lp = this.aff.params[0][ip];
        for (i=0; i<this.outp.length; i++) {
            par = this.outp[i];
            if (lp == par.label) {
                if (par.type == 'tableau') {
                    o = out.lire(par.label);
                    if (Object.prototype.toString.call(o) === '[object Array]') { // normalement test double[][]
                        this.ic.updateImage(o);
                        trouve = true;
                    } else
                        throw new Error(Messages.get('mauvaise_sortie') + ': ' + (typeof o));
                } else if (par.type == 'image') {
                    o = out.lire(par.label);
                    if (o.nodeName == 'CANVAS') {
                        this.ic.updateImage(o);
                        trouve = true;
                    } else
                        throw new Error(Messages.get('mauvaise_sortie') + ': ' + (typeof o));
                } else if (!this.sousaff && par.type == 'string' && this.info != null)
                    this.info.firstChild.nodeValue = out.lireString(par.label);
            }
        }
    }
    if (!trouve)
        throw new Error(Messages.get('aucune_sortie'));
}

AffImage.prototype.actionPerformed = function(e) {
    var cmd;
    
    cmd = e.target.getAttribute('id');
    if (cmd == 'continuer')
        this.start();
    else if (cmd == 'stop')
        this.stop();
}

/*
SimuLab

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Affichage d'un ensemble d'affichages, calculés simultanément.
 */
//public class AffMulti extends TypeAffichage implements ActionListener {
//public AffMulti(SimuApplet applet, Affichage aff, boolean sousaff) {

AffMulti.prototype = new TypeAffichage();
AffMulti.prototype.constructor = AffMulti;

function AffMulti(applet, aff, sousaff) {
    var i, moi;
    
    this.applet = applet;
    this.aff = aff;
    this.sousaff = sousaff;
    this.typesaff = null; // TypeAffichage[]
    this.outp = null;
    this.info = null;
    this.bstop = null;
    this.bstart = null;
    this.chrono = null; // Chronos
    this.live = false;
    
    if (this.aff.sousAff == null)
        alert(Messages.get("multiplot_sans_affichage"));
    
    try {
        if (this.aff.sousAff == null) {
            this.typesaff = new Array();
            this.typesaff[0] = this.applet.creationTypeAffichage(this.aff, true);
        } else {
            this.typesaff = new Array();
            for (i=0; i<this.aff.sousAff.length; i++)
                this.typesaff[i] = this.applet.creationTypeAffichage(this.aff.sousAff[i], true);
        }
    } catch (ex) {
        this.applet.handleException(ex);
    }
    if (this.aff.sousAff == null)
        this.live = this.typesaff[0].estLive();
    else {
        this.live = false;
        for (i=0; i<this.typesaff.length; i++)
            this.live = this.live || this.typesaff[i].estLive();
    }
    
    moi = this;
    this.actionPerformedProxy = function(e) { moi.actionPerformed(e) };
}

AffMulti.prototype.estLive = function() {
    return(this.live);
}

AffMulti.prototype.ajouterBoutons = function(div) {
    var bouton;
    
    divboutons = document.createElement('div');
    divboutons.setAttribute('id', 'boutons');
    
    if (this.live) {
        bouton = document.createElement('input');
        bouton.setAttribute('type', 'button');
        bouton.setAttribute('value', Messages.get("continuer"));
        bouton.setAttribute('id', 'continuer');
        if (bouton.addEventListener)
            bouton.addEventListener('click', this.actionPerformedProxy, false);
        else
            bouton.attachEvent('onclick', this.actionPerformedProxy);
        divboutons.appendChild(bouton);
        this.bstart = bouton;
        
        bouton = document.createElement('input');
        bouton.setAttribute('type', 'button');
        bouton.setAttribute('value', Messages.get("stop"));
        bouton.setAttribute('id', 'stop');
        if (bouton.addEventListener)
            bouton.addEventListener('click', this.actionPerformedProxy, false);
        else
            bouton.attachEvent('onclick', this.actionPerformedProxy);
        divboutons.appendChild(bouton);
        this.bstop = bouton;
    }

    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("ajuster"));
    bouton.setAttribute('id', 'ajuster');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("effacer"));
    bouton.setAttribute('id', 'effacer');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    
    div.appendChild(divboutons);
}

//public Panel initPanel(Vector outp) throws SimuException {
AffMulti.prototype.initPanel = function(outp, dimensions) {
    var div_affichage, nbplotsx, nbplotsy, table, tbody, tr, td, i, itr, itd, sousdim, avecinfo, par;
    
    this.outp = outp;
    div_affichage = document.createElement('div');
    if (!this.sousaff)
        div_affichage.setAttribute('id', 'affichage');
    div_affichage.style.width = dimensions.width + 'px';
    div_affichage.style.height = dimensions.height + 'px';
    
    if (!this.sousaff)
        this.ajouterBoutons(div_affichage);
    
    if (this.aff.sousAff == null)
        div_affichage.appendChild(this.typesaff[0].initPanel(outp, dimensions));
    else {
        if (this.aff.ordreSousAff != 'y') {
            // plus long en x
            nbplotsx = Math.ceil(Math.sqrt(this.typesaff.length));
            if (nbplotsx*(nbplotsx-1) < this.typesaff.length)
                nbplotsy = nbplotsx;
            else
                nbplotsy = nbplotsx - 1;
        } else {
            nbplotsy = Math.ceil(Math.sqrt(this.typesaff.length));
            if (nbplotsy*(nbplotsy-1) < this.typesaff.length)
                nbplotsx = nbplotsy;
            else
                nbplotsx = nbplotsy - 1;
        }
        table = document.createElement('table');
        tbody = document.createElement('tbody');
        i = 0;
        for (itr=0; itr<nbplotsy; itr++) {
            tr = document.createElement('tr');
            for (itd=0; itd<nbplotsx; itd++) {
                td = document.createElement('td');
                if (i < this.typesaff.length) {
                    sousdim = {'width': (dimensions.width / nbplotsx - 8), 'height': ((dimensions.height - 50) / nbplotsy - 8)};
                    td.appendChild(this.typesaff[i].initPanel(this.outp, sousdim));
                }
                tr.appendChild(td);
                i++;
            }
            tbody.appendChild(tr);
        }
        table.appendChild(tbody);
        div_affichage.appendChild(table);
    }
    
    avecinfo = false;
    for (i=0; i<this.outp.length; i++) {
        par = this.outp[i];
        if (par.type == 'string')
            avecinfo = true;
    }
    if (avecinfo) {
        this.info = document.createElement('div');
        this.info.setAttribute('id', 'info');
        this.info.appendChild(document.createTextNode(' '));
        div_affichage.appendChild(this.info);
    } else
        this.info = null;
    
    return(div_affichage);
}

AffMulti.prototype.setChronos = function(chrono) {
    this.chrono = chrono;
}

AffMulti.prototype.avantLancement = function() {
    var i;
    
    for (i=0; i<this.typesaff.length; i++)
        this.typesaff[i].avantLancement();
}

//public void affiche(ListeValeurs in, Vector outp) throws SimuException {
AffMulti.prototype.affiche = function(lin, outp) {
    var out;
    
    this.outp = outp;
    this.avantLancement();
    
    if (this.live)
        this.start();
    else {
        out =  this.applet.calcul(lin);
        this.update(out);
    }
}

AffMulti.prototype.start = function() {
    this.bstop.disabled = false;
    this.bstart.disabled = true;
    if (this.chrono != null)
        this.chrono.start();
}

AffMulti.prototype.stop = function() {
    // bstop et bstart sont null s'il y a eu une erreur dans initCalculLive
    if (this.bstop != null)
        this.bstop.disabled = true;
    if (this.bstart != null)
        this.bstart.disabled = false;
    if (this.chrono != null)
        this.chrono.stop();
}

AffMulti.prototype.fin = function() {
    this.bstop.disabled = true;
    this.bstart.disabled = true;
    this.chrono = null;
}

AffMulti.prototype.effacer = function() {
    var i;
    
    for (i=0; i<this.typesaff.length; i++)
        this.typesaff[i].effacer();
}

AffMulti.prototype.ajuster = function() {
    var i;
    
    for (i=0; i<this.typesaff.length; i++)
        this.typesaff[i].ajuster();
}

AffMulti.prototype.actionPerformed = function(e) {
    var cmd;
    
    cmd = (e.target || e.srcElement).getAttribute('id');
    if (cmd == 'continuer')
        this.start();
    else if (cmd == 'stop')
        this.stop();
    else if (cmd == 'ajuster')
        this.ajuster();
    else if (cmd == 'effacer')
        this.effacer();
}

//public void update(ListeValeurs out) throws SimuException {
AffMulti.prototype.update = function(out) {
    var i;
    
    for (i=0; i<this.typesaff.length; i++)
        this.typesaff[i].update(out);
    for (i=0; i<this.outp.length; i++) {
        par = this.outp[i];
        o = out.lire(par.label);
        if (typeof o == 'string' && this.info != null) {
            if (o != this.info.firstChild.nodeValue)
                this.info.firstChild.nodeValue = o;
        }
    }
}

/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Affichage d'un graphe à partir d'un ensemble de points.
 * Appelle SimuParams.calcul() au début pour le calcul des positions des points.
 */
//public class AffPlot extends TypeAffichage implements ActionListener {
//public AffPlot(SimuApplet applet, Affichage aff, boolean sousaff) {

AffPlot.prototype = new TypeAffichage();
AffPlot.prototype.constructor = AffPlot;

function AffPlot(applet, aff, sousaff) {
    this.applet = applet;
    this.aff = aff;
    this.sousaff = sousaff;
    this.plot = null;
    this.outp = null;
    this.info = null;
    this.nd = -1; // numéro dataset, pour changer la couleur quand aff.params.length = 1 et !effacer
    this.points = []; // tableau de tableaux de points [x, y]
    this.options = null;
    this.plotid = null;
    
    var moi = this;
    this.actionPerformedProxy = function(e) { moi.actionPerformed(e) };
    
    return(this);
}

AffPlot.prototype.numeroUnique = (function() { var numero=0; return function() { return(numero++); } })();

AffPlot.prototype.ajouterBoutons = function(div) {
    var bouton;
    
    divboutons = document.createElement('div');
    divboutons.setAttribute('id', 'boutons');
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("ajuster"));
    bouton.setAttribute('id', 'ajuster');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("effacer"));
    bouton.setAttribute('id', 'effacer');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    
    div.appendChild(divboutons);
}

AffPlot.prototype.limitesAxes = function() {
    var x1, x2, y1, y2, ret;
    
    if (this.aff.xdebut != null && this.aff.xfin != null) {
        x1 = parseFloat(this.aff.xdebut);
        x2 = parseFloat(this.aff.xfin);
    } else {
        x1 = 0;
        x2 = 10;
    }
    if (this.aff.ydebut != null && this.aff.yfin != null) {
        y1 = parseFloat(this.aff.ydebut);
        y2 = parseFloat(this.aff.yfin);
    } else {
        y1 = 0;
        y2 = 10;
    }
    ret = $.jqplot.LinearTickGenerator(x1, x2, 1.0, null, false, false); // [min, max, nTicks, format, tickInterval]
    this.options.axes.xaxis.min = ret[0];
    this.options.axes.xaxis.max = ret[1];
    if (!this.aff.histogramme) {
        this.options.axes.xaxis.numberTicks = ret[2];
        this.options.axes.xaxis.tickInterval = ret[4];
    }
    ret = $.jqplot.LinearTickGenerator(y1, y2, 1.0, null, false, false);
    this.options.axes.yaxis.min = ret[0];
    this.options.axes.yaxis.max = ret[1];
    this.options.axes.yaxis.numberTicks = ret[2];
    this.options.axes.yaxis.tickInterval = ret[4];
}

AffPlot.prototype.fonctionFormatAxes = function(format, val) {
    if ((val != 0 && val < 1e-2 && val > -1e-2) || val > 1e3 || val < -1e3)
        format = '%.2E';
    else if (Math.floor(val) == val)
        format = '%d';
    else
        format = '%.2f';
    return($.jqplot.sprintf(format, val));
}

AffPlot.prototype.initPlot = function(plotdiv, dimensions) {
    var titres, mopt;
    
    titres = this.applet.titresAxes(this.aff, this.outp);
    plotdiv.style.width = dimensions.width + 'px';
    plotdiv.style.height = dimensions.height + 'px';
    
    // styles de jqplot (markerOptions.style) : circle, diamond, square, x, plus, filledCircle, filledDiamond, filledSquare
    // ptplot/simulab : none, points, dots, cross, various
    // avec jqplot, size = 0.5 signifie 1 pixel de large
    if (this.aff.points == 'none' || this.aff.histogramme)
        mopt = { show: false };
    else if (this.aff.points == 'points')
        mopt = { show: true, style: 'filledCircle', size: 2, shadow: false };
    else if (this.aff.points == 'dots')
        mopt = { show: true, style: 'filledCircle', size: 3, shadow: false };
    else if (this.aff.points == 'cross')
        mopt = { show: true, style: 'x', size: 3, lineWidth: 1, shadow: false };
    else
        mopt = { show: true, style: 'filledCircle', size: 2, shadow: false };
    
    this.options = {
        sortData: false,
        seriesColors: [ '#ff0000', '#0000ff', '#00aaaa', '#000000', '#ffa500', '#53868b', '#ff7f50', '#45ab1f', '#90422d', '#a0a0a0', '#14ff14'], /* couleurs de ptplot */
        title: this.aff.titre,
        axesDefaults: {
            labelRenderer: $.jqplot.CanvasAxisLabelRenderer,
            tickOptions: {
                formatter: this.fonctionFormatAxes
            }
        },
        axes: {
            xaxis: {
                label: titres[0]
            },
            yaxis: {
                label: titres[1]
            }
        },
        seriesDefaults: {
            lineWidth: 1,
            shadow: false,
            showLine: this.aff.connecter,
            markerOptions: mopt
        },
        series : [
            {
            }
        ],
        grid : {
        },
        cursor: {
            show: true,
            zoom: true,
            showTooltip: true
        },
        highlighter: {
            show: true,
            useAxesFormatters: true
        }
    };
    if (!this.aff.couleurs)
        this.options.seriesColors = ['#000000'];
    if (this.aff.xlog) {
        this.options.axes.xaxis.renderer = $.jqplot.LogAxisRenderer;
        this.options.axes.xaxis.tickDistribution = 'power';
        this.options.axes.xaxis.tickOptions = { formatter: $.jqplot.DefaultTickFormatter, formatString: '%.1E' };
        this.options.axes.xaxis.tickOptions.formatString
    }
    if (this.aff.ylog) {
        this.options.axes.yaxis.renderer = $.jqplot.LogAxisRenderer;
        this.options.axes.yaxis.tickDistribution = 'power';
        this.options.axes.yaxis.tickOptions = { formatter: $.jqplot.DefaultTickFormatter, formatString: '%.1E' };
    }
    if (this.aff.histogramme) {
        this.options.seriesDefaults.renderer = $.jqplot.BarRenderer;
        this.options.seriesDefaults.rendererOptions = { barPadding: 2, barMargin: 4 };
        this.options.axes.xaxis.renderer = $.jqplot.CategoryAxisRenderer;
        this.options.seriesDefaults.showLine = true;
        this.options.highlighter.tooltipAxes = 'y';
    }
    if (this.aff.fond != null) {
        this.options.backgroundImage = {
            show: true,
            file: this.aff.fond
        };
        if (this.aff.xdebutfond != null)
            this.options.backgroundImage.coordinates = [this.aff.xdebutfond, this.aff.ydebutfond, this.aff.xfinfond, this.aff.yfinfond];
    }
}

//public Panel initPanel(Vector outp) throws SimuException {
AffPlot.prototype.initPanel = function(outp, dimensions) {
    var div_affichage, plotdiv, w, h, avecinfo, i, par;
    
    this.outp = outp;
    
    div_affichage = document.createElement('div');
    if (!this.sousaff)
        div_affichage.setAttribute('id', 'affichage');
    else
        div_affichage.className = 'sous-affichage';
    div_affichage.style.width = dimensions.width + 'px';
    div_affichage.style.height = dimensions.height + 'px';
    
    if (!this.sousaff)
        this.ajouterBoutons(div_affichage);
    
    //plot = new SimuPlot(applet, aff);
    plotdiv = document.createElement('div');
    this.plotid = 'plot' + this.numeroUnique();
    plotdiv.setAttribute('id', this.plotid);
    div_affichage.appendChild(plotdiv);

    w = dimensions.width - 10;
    if (this.sousaff)
        h = dimensions.height;
    else
        h = dimensions.height - 50;
    if (this.aff.carre) {
        if (w > h) {
            w = h;
            div_affichage.style.width = (w + 10) + 'px';
        } else {
            h = w;
            if (this.sousaff)
                div_affichage.style.height = h + 'px';
            else
                div_affichage.style.height = (h + 50) + 'px';
        }
    }
    this.initPlot(plotdiv, {'width': w, 'height': h});
    
    avecinfo = false;
    for (i=0; i<outp.length; i++) {
        par = outp[i];
        if (par.type == 'string')
            avecinfo = true;
    }
    if (avecinfo) {
        this.info = document.createElement('div');
        this.info.setAttribute('id', 'info');
        this.info.appendChild(document.createTextNode(' '));
        div_affichage.appendChild(this.info);
    } else
        this.info = null;
    
    return(div_affichage);
}

AffPlot.prototype.estLive = function() {
    return(false);
}

AffPlot.prototype.effacer = function() {
    this.points = [];
    this.nd = -1;
    if (this.plot == null)
        return;
    this.plot.destroy();
    this.plot = $.jqplot(this.plotid, [[null]], this.options);
}

AffPlot.prototype.ajuster = function() {
    //this.plot.replot({'resetAxes' : true});
    // problème de replot: la taille des labels de l'axe y peut augmenter si les valeurs augmentent,
    // mais la dimension de la zone des labels n'est pas réajustée
    this.plot.destroy();
    this.plot = $.jqplot(this.plotid, this.points, this.options);
}

AffPlot.prototype.actionPerformed = function(e) {
    var cmd;
    
    cmd = (e.target || e.srcElement).getAttribute('id');
    if (cmd == 'ajuster')
        this.ajuster();
    else if (cmd == 'effacer')
        this.effacer();
}

//public void update(ListeValeurs out) throws SimuException {
AffPlot.prototype.update = function(out) {
    var ip, lsx, lsy, outx, outy, i, par, o, x, y, dd;
    
    if (!this.aff.ajuster)
        this.limitesAxes();
    
    if (this.aff.effacer) {
        this.points = [];
        this.nd = 0;
         if (this.plot != null) {
             this.plot.destroy();
             this.plot = null;
         }
    } else if (this.aff.params.length == 1)
        this.nd++;
    for (ip=0; ip<this.aff.params.length; ip++) {
        if (this.aff.params.length != 1)
            this.nd = ip;
        lsx = this.aff.params[ip][0];
        lsy = this.aff.params[ip][1];
        outx = null;
        outy = null;
        for (i=0; i<this.outp.length; i++) {
            par = this.outp[i];
            if (lsx == par.label) {
                o = out.lire(par.label);
                if (o == null)
                    outx = null;
                else if (Object.prototype.toString.call(o) === '[object Array]')
                    outx = o;
                else if (typeof o == 'number') {
                    // cas où la courbe est réduite à un point
                    outx = [ o ];
                } else {
                    outx = null;
                    alert("Type étrange pour la coordonnée x d'un plot : " + (typeof o));
                }
            } else if (lsy == par.label) {
                o = out.lire(par.label);
                if (o == null)
                    outy = null;
                else if (Object.prototype.toString.call(o) === '[object Array]')
                    outy = o;
                else if (typeof o == 'number') {
                    outy = [ o ];
                } else {
                    outy = null;
                    alert("Type étrange pour la coordonnée y d'un plot : " + (typeof o));
                }
            } else if (!this.sousaff && this.info != null && par.type == 'string' &&
                    typeof out.lire(par.label) == 'string')
                this.info.firstChild.nodeValue = out.lire(par.label);
        }
        if (outx == null || outy == null) {
            alert(Messages.get("aucun_resultat"));
            return;
        }
        if (this.points[this.nd] == undefined)
            this.points[this.nd] = new Array();
        for (i=0; i<outx.length; i++) {
            x = outx[i];
            y = outy[i];
            this.points[this.nd].push([x, y]); // à connecter si : this.aff.connecter && (i > 0)
        }
    }
    if (this.plot == null) {
        this.plot = $.jqplot(this.plotid, this.points, this.options);
    } else if (this.points.length > this.plot.series.length) {
        this.plot.destroy();
        this.plot = $.jqplot(this.plotid, this.points, this.options);
    } else {
        for (i=0; i<this.points.length; i++)
            this.plot.series[i].data = this.points[i];
        this.plot.replot({'resetAxes' : this.aff.ajuster});
    }
}

//public void affiche(ListeValeurs in, Vector outp) throws SimuException {
AffPlot.prototype.affiche = function(lin, outp) {
    var out;
    
    this.outp = outp;
    out =  this.applet.calcul(lin);
    this.update(out);
}

/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Affichage d'un ensemble de PlotLive, calculés simultanément. Appelle
 * SimuParams.initCalculLive() au début, puis SimuParams.calculLive() à chaque
 * itération.
 */
//public class AffPlotLive extends TypeAffichage implements ActionListener {
//public AffPlotLive(SimuApplet applet, Affichage aff, boolean sousaff) {

AffPlotLive.prototype = new TypeAffichage();
AffPlotLive.prototype.constructor = AffPlotLive;

function AffPlotLive(applet, aff, sousaff) {
    this.applet = applet;
    this.aff = aff;
    this.sousaff = sousaff;
    this.nd = -1; // numéro dataset, pour changer la couleur quand aff.params.length = 1
    this.vnd = 0; // nombre d'anciens datasets à conserver
    this.plot = null;
    this.outp = null;
    this.couleurs = true; // à ne pas confondre avec this.aff.couleurs
    this.info = null;
    this.bstop = null;
    this.bstart = null;
    this.chrono = null; // Chronos
    this.points = []; // tableau de tableaux de points [x, y]
    this.options = null;
    this.plotid = null;
    
    var moi = this;
    this.actionPerformedProxy = function(e) { moi.actionPerformed(e) };
}

AffPlotLive.prototype.numeroUnique = (function() { var numero=0; return function() { return(numero++); } })();

AffPlotLive.prototype.ajouterBoutons = function(div) {
    var bouton;
    
    divboutons = document.createElement('div');
    divboutons.setAttribute('id', 'boutons');
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("continuer"));
    bouton.setAttribute('id', 'continuer');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    this.bstart = bouton;
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("stop"));
    bouton.setAttribute('id', 'stop');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    this.bstop = bouton;
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("ajuster"));
    bouton.setAttribute('id', 'ajuster');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    
    bouton = document.createElement('input');
    bouton.setAttribute('type', 'button');
    bouton.setAttribute('value', Messages.get("effacer"));
    bouton.setAttribute('id', 'effacer');
    if (bouton.addEventListener)
        bouton.addEventListener('click', this.actionPerformedProxy, false);
    else
        bouton.attachEvent('onclick', this.actionPerformedProxy);
    divboutons.appendChild(bouton);
    
    div.appendChild(divboutons);
}

AffPlotLive.prototype.limitesAxes = function() {
    var x1, x2, y1, y2, ret;
    
    if (this.aff.xdebut != null && this.aff.xfin != null) {
        x1 = parseFloat(this.aff.xdebut);
        x2 = parseFloat(this.aff.xfin);
    } else {
        x1 = 0;
        x2 = 10;
    }
    if (this.aff.ydebut != null && this.aff.yfin != null) {
        y1 = parseFloat(this.aff.ydebut);
        y2 = parseFloat(this.aff.yfin);
    } else {
        y1 = 0;
        y2 = 10;
    }
    ret = $.jqplot.LinearTickGenerator(x1, x2, 1.0, null, false, false); // [min, max, nTicks, format, tickInterval]
    this.options.axes.xaxis.min = ret[0];
    this.options.axes.xaxis.max = ret[1];
    if (!this.aff.histogramme) {
        this.options.axes.xaxis.numberTicks = ret[2];
        this.options.axes.xaxis.tickInterval = ret[4];
    }
    ret = $.jqplot.LinearTickGenerator(y1, y2, 1.0, null, false, false);
    this.options.axes.yaxis.min = ret[0];
    this.options.axes.yaxis.max = ret[1];
    this.options.axes.yaxis.numberTicks = ret[2];
    this.options.axes.yaxis.tickInterval = ret[4];
}

AffPlotLive.prototype.fonctionFormatAxes = function(format, val) {
    if ((val != 0 && val < 1e-2 && val > -1e-2) || val > 1e3 || val < -1e3)
        format = '%.2E';
    else if (Math.floor(val) == val)
        format = '%d';
    else
        format = '%.2f';
    return($.jqplot.sprintf(format, val));
}

AffPlotLive.prototype.initPlot = function(plotdiv, dimensions) {
    var titres, mopt;
    
    titres = this.applet.titresAxes(this.aff, this.outp);
    plotdiv.style.width = dimensions.width + 'px';
    plotdiv.style.height = dimensions.height + 'px';
    
    // styles de jqplot (markerOptions.style) : circle, diamond, square, x, plus, filledCircle, filledDiamond, filledSquare
    // ptplot/simulab : none, points, dots, cross, various
    // avec jqplot, size = 0.5 signifie 1 pixel de large
    if (this.aff.points == 'none' || this.aff.histogramme)
        mopt = { show: false };
    else if (this.aff.points == 'points')
        mopt = { show: true, style: 'filledCircle', size: 2, shadow: false };
    else if (this.aff.points == 'dots')
        mopt = { show: true, style: 'filledCircle', size: 3, shadow: false };
    else if (this.aff.points == 'cross')
        mopt = { show: true, style: 'x', size: 3, lineWidth: 1, shadow: false };
    else
        mopt = { show: true, style: 'filledCircle', size: 2, shadow: false };
    
    this.options = {
        sortData: false,
        seriesColors: [ '#ff0000', '#0000ff', '#00aaaa', '#000000', '#ffa500', '#53868b', '#ff7f50', '#45ab1f', '#90422d', '#a0a0a0', '#14ff14'], /* couleurs de ptplot */
        title: this.aff.titre,
        axesDefaults: {
            labelRenderer: $.jqplot.CanvasAxisLabelRenderer,
            tickOptions: {
                formatter: this.fonctionFormatAxes
            }
        },
        axes: {
            xaxis: {
                label: titres[0]
            },
            yaxis: {
                label: titres[1]
            }
        },
        seriesDefaults: {
            lineWidth: 1,
            shadow: false,
            showLine: this.aff.connecter,
            markerOptions: mopt
        },
        series : [
            {
            }
        ],
        grid : {
        },
        cursor: {
            show: true,
            zoom: true,
            showTooltip: true
        }
    };
    if (!this.aff.couleurs)
        this.options.seriesColors = ['#000000'];
    if (this.aff.xlog) {
        this.options.axes.xaxis.renderer = $.jqplot.LogAxisRenderer;
        this.options.axes.xaxis.tickDistribution = 'power';
        this.options.axes.xaxis.tickOptions = { formatter: $.jqplot.DefaultTickFormatter, formatString: '%.1E' };
    }
    if (this.aff.ylog) {
        this.options.axes.yaxis.renderer = $.jqplot.LogAxisRenderer;
        this.options.axes.yaxis.tickDistribution = 'power';
        this.options.axes.yaxis.tickOptions = { formatter: $.jqplot.DefaultTickFormatter, formatString: '%.1E' };
    }
    if (!this.aff.ajuster)
        this.limitesAxes();
    if (this.aff.histogramme) {
        this.options.seriesDefaults.renderer = $.jqplot.BarRenderer;
        this.options.seriesDefaults.rendererOptions = { barPadding: 2, barMargin: 4 };
        this.options.axes.xaxis.renderer = $.jqplot.CategoryAxisRenderer;
        this.options.seriesDefaults.showLine = true;
    }
    if (this.aff.fond != null) {
        this.options.backgroundImage = {
            show: true,
            file: this.aff.fond
        };
        if (this.aff.xdebutfond != null)
            this.options.backgroundImage.coordinates = [this.aff.xdebutfond, this.aff.ydebutfond, this.aff.xfinfond, this.aff.yfinfond];
    }
}

//public Panel initPanel(Vector outp) throws SimuException {
AffPlotLive.prototype.initPanel = function(outp, dimensions) {
    var div_affichage, plotdiv, w, h, avecinfo, i, par;
    
    this.outp = outp;
    
    div_affichage = document.createElement('div'); // boutons + plots + info
    if (!this.sousaff)
        div_affichage.setAttribute('id', 'affichage');
    else
        div_affichage.className = 'sous-affichage';
    div_affichage.style.width = dimensions.width + 'px';
    div_affichage.style.height = dimensions.height + 'px';
    
    if (!this.sousaff)
        this.ajouterBoutons(div_affichage);
    
    plotdiv = document.createElement('div');
    this.plotid = 'plot' + this.numeroUnique();
    plotdiv.setAttribute('id', this.plotid);
    div_affichage.appendChild(plotdiv);
    w = dimensions.width - 10;
    if (this.sousaff)
        h = dimensions.height;
    else
        h = dimensions.height - 50;
    if (this.aff.carre) {
        if (w > h) {
            w = h;
            if (this.sousaff)
                div_affichage.style.width = (w + 10) + 'px';
        } else {
            h = w;
            if (this.sousaff)
                div_affichage.style.height = h + 'px';
            else
                div_affichage.style.height = (h + 50) + 'px';
        }
    }
    this.initPlot(plotdiv, {'width': w, 'height': h});
    
    avecinfo = false;
    for (i=0; i<outp.length; i++) {
        par = outp[i];
        if (par.type == 'string')
            avecinfo = true;
    }
    if (avecinfo) {
        this.info = document.createElement('div');
        this.info.setAttribute('id', 'info');
        this.info.appendChild(document.createTextNode(' '));
        div_affichage.appendChild(this.info);
    } else
        this.info = null;
    
    this.couleurs = (this.aff.params.length == 1);
    
    return(div_affichage);
}

AffPlotLive.prototype.estLive = function() {
    return(true);
}

//public void setChronos(Chronos chrono) {
AffPlotLive.prototype.setChronos = function(chrono) {
    this.chrono = chrono;
}

//public void affiche(ListeValeurs in, Vector outp) throws SimuException {
AffPlotLive.prototype.affiche = function(lin, outp) {
    this.outp = outp;
    
    this.avantLancement();
    
    this.start();
}

AffPlotLive.prototype.avantLancement = function() {
    if (this.couleurs)
        this.nd++;
    else if (this.nd != -1)
        this.vnd += this.aff.params.length;
}

AffPlotLive.prototype.start = function() {
    this.bstop.disabled = false;
    this.bstart.disabled = true;
    this.chrono.start();
}

AffPlotLive.prototype.stop = function() {
    if (this.bstop != null)
        this.bstop.disabled = true;
    if (this.bstart != null)
        this.bstart.disabled = false;
    if (this.chrono != null)
        this.chrono.stop();
}

AffPlotLive.prototype.fin = function() {
    this.bstop.disabled = true;
    this.bstart.disabled = true;
}

AffPlotLive.prototype.effacer = function() {
    var i;
    
    this.points = [];
    this.nd = -1;
    this.vnd = 0;
    if (this.plot == null)
        return;
    for (i=0; i<this.plot.series.length; i++)
        this.plot.series[i].data = [];
    this.plot.replot();
}

AffPlotLive.prototype.ajuster = function() {
    this.plot.replot({'resetAxes' : true});
}

AffPlotLive.prototype.actionPerformed = function(e) {
    var cmd;
    
    cmd = (e.target || e.srcElement).getAttribute('id');
    if (cmd == 'continuer')
        this.start();
    else if (cmd == 'stop')
        this.stop();
    else if (cmd == 'ajuster')
        this.ajuster();
    else if (cmd == 'effacer')
        this.effacer();
}

//public void update(ListeValeurs out) throws SimuException {
AffPlotLive.prototype.update = function(out) {
    var ip, sx, sy, x, y, vx, vy, i, par, o, connexion, npoints, series;
    
    if (this.aff.effacer)
        this.effacer();
    if (this.nd == -1)
        this.nd = 0;
    npoints = [];
    for (ip=0; ip<this.aff.params.length; ip++) {
        if (!this.couleurs)
            this.nd = ip + this.vnd;
        sx = this.aff.params[ip][0];
        sy = this.aff.params[ip][1];
        x = 0;
        y = 0;
        vx = null; // pour permettre l'envoi de plusieurs valeurs d'un coup
        vy = null;
        for (i=0; i<this.outp.length; i++) {
            par = this.outp[i];
            o = out.lire(par.label);
            if (typeof o == 'number') {
                if (sx == par.label)
                    x = o;
                else if (sy == par.label)
                    y = o;
            } else if (Object.prototype.toString.call(o) === '[object Array]') {
                if (sx == par.label)
                    vx = o;
                else if (sy == par.label)
                    vy = o;
            } else if (!this.sousaff && typeof o == 'string' && this.info != null) {
                if (this.info.firstChild.nodeValue != o)
                    this.info.firstChild.nodeValue = o;
            } else if (o == null) {
                // ?
            }
        }
        if (this.points[this.nd] == undefined)
            this.points[this.nd] = new Array();
        if (vx != null && vy != null) { // cas avec plusieurs points affichés d'un coup
            if (vx.length != vy.length)
                throw new Error(Messages.get("meme_nombre"));
            for (i=0; i<vx.length; i++) {
                x = vx[i];
                y = vy[i];
                // connexion = this.aff.connecter && (!this.appel1 || i > 0);
                this.points[this.nd].push([x, y]);
                if (npoints[this.nd] == undefined)
                    npoints[this.nd] = [];
                npoints[this.nd].push([x, y]);
            }
        } else {
            // connexion = this.aff.connecter && !this.appel1
            this.points[this.nd].push([x, y]);
            if (npoints[this.nd] == undefined)
                npoints[this.nd] = [];
            npoints[this.nd].push([x, y]);
        }
    }
    
    if (this.plot == null) {
        this.plot = $.jqplot(this.plotid, this.points, this.options);
        
    } else if (this.points.length > this.plot.series.length) {
        this.plot.destroy();
        this.plot = $.jqplot(this.plotid, this.points, this.options);
        
    } else if (this.aff.ajuster) {
        for (i=0; i<this.points.length; i++)
            this.plot.series[i].data = this.points[i];
        this.plot.replot({'resetAxes' : this.aff.ajuster});
        
    } else if (!this.couleurs) {
        // pour n'afficher que les nouveaux points :
        for (ip=0; ip<this.aff.params.length; ip++) {
            this.nd = ip + this.vnd;
            if (npoints[this.nd].length > 0) {
                series = this.plot.series[this.nd];
                // pour afficher une ligne, il faut quand même le point précédent :
                if (this.aff.connecter && this.points[this.nd].length > npoints[this.nd].length)
                    npoints[this.nd].unshift(this.points[this.nd][this.points[this.nd].length - 1 - npoints[this.nd].length]);
                series.data = npoints[this.nd];
                series.draw(series.canvas._ctx, {}, this.plot);
                series.data = this.points[this.nd]; // on remet tous les points pour permettre l'ajustement des axes
            }
        }
        
    } else {
        // affichage seulement de la courbe modifiée
        // nécessite une correction de bug dans jqplot (data[i] undefined), ou la version de 2012
        //this.plot.series[this.nd].data = this.points[this.nd];
        //this.plot.drawSeries({}, this.nd);
        
        // pour n'afficher que les nouveaux points :
        series = this.plot.series[this.nd];
        if (this.aff.connecter && this.points[this.nd].length > npoints[this.nd].length)
            npoints[this.nd].unshift(this.points[this.nd][this.points[this.nd].length - 1 - npoints[this.nd].length]);
        series.data = npoints[this.nd];
        series.draw(series.canvas._ctx, {}, this.plot);
        series.data = this.points[this.nd]; // on remet tous les points pour permettre l'ajustement des axes
    }
}

/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Affichage d'un tableau à partir d'un ensemble de points, dont la position est
 * calculée avec un appel à SimuParams.calcul().
 */
//public class AffPlotTab extends TypeAffichage {
//public AffPlotTab(SimuApplet applet, Affichage aff, boolean sousaff) {

AffPlotTab.prototype = new TypeAffichage();
AffPlotTab.prototype.constructor = AffPlotTab;

function AffPlotTab(applet, aff, sousaff) {
    this.applet = applet;
    this.aff = aff;
    this.sousaff = sousaff;
    this.outp = null;
    this.table = null;
}

//public Panel initPanel(Vector outp) throws SimuException {
AffPlotTab.prototype.initPanel = function(outp, dimensions) {
    var div_affichage;
    
    div_affichage = document.createElement('div');
    if (!this.sousaff)
        div_affichage.setAttribute('id', 'affichage');
    div_affichage.style.width = dimensions.width + 'px';
    div_affichage.style.height = dimensions.height + 'px';
    return(div_affichage);
}

AffPlotTab.prototype.estLive = function() {
    return(false);
}

AffPlotTab.prototype.avantLancement = function() {
    var div_affichage;
    
    div_affichage = document.getElementById('affichage');
    if (div_affichage.firstChild != null)
        div_affichage.removeChild(div_affichage.firstChild);
    this.table = document.createElement('table');
    this.table.appendChild(document.createElement('thead'));
    this.table.appendChild(document.createElement('tbody'));
    div_affichage.appendChild(this.table);
}

//public void affiche(ListeValeurs in, Vector outp) throws SimuException {
AffPlotTab.prototype.affiche = function(lin, outp) {
    var out;
    
    this.outp = outp;
    
    this.avantLancement();
    
    out = this.applet.calcul(lin);
    this.update(out);
}

//public void update(ListeValeurs out) throws SimuException {
AffPlotTab.prototype.update = function(out) {
    var ip, lp, i, par, o, outx, valeurs, j, o2;
    
    if (this.aff.params == null) {
        alert(Messages.get("aucun_parametre_tableau"));
        return;
    }
    for (ip=0; ip<this.aff.params[0].length; ip++) {
        lp = this.aff.params[0][ip];
        for (i=0; i<this.outp.length; i++) {
            par = this.outp[i];
            if (lp == par.label) {
                o = out.lire(par.label);
                if (Object.prototype.toString.call(o) === '[object Array]') {
                    outx = o;
                    valeurs = new Array();
                    for (j=0; j<outx.length; j++) {
                        o2 = outx[j];
                        if (typeof o2 == 'number')
                            valeurs[j] = this.joliFormattage(o2, 8);
                        else
                            valeurs[j] = '' + o2;
                    }
                    this.ajouterColonne(par.label, valeurs);
                } else {
                    valeurs = new Array();
                    valeurs[0] = '' + o;
                    this.ajouterColonne(par.label, valeurs);
                }
            }
        }
    }
}

AffPlotTab.prototype.ajouterColonne = function(titre, valeurs) {
    var thead, tbody, tr, th, td, i, nbtd;
    
    // on suppose qu'il n'y a pas de noeuds de texte entre les lignes et cellules de la table
    thead = this.table.firstChild;
    tbody = thead.nextSibling;
    
    tr = thead.firstChild;
    if (tr == null) {
        tr = document.createElement('tr');
        thead.appendChild(tr);
    }
    nbtd = tr.childNodes.length;
    th = document.createElement('th');
    th.appendChild(document.createTextNode(titre));
    tr.appendChild(th);
    
    tr = tbody.firstChild;
    for (i=0; i<valeurs.length; i++) {
        if (tr == null) {
            tr = document.createElement('tr');
            tbody.appendChild(tr);
        }
        while (tr.childNodes.length < nbtd)
            tr.appendChild(document.createElement('td'));
        td = document.createElement('td');
        td.appendChild(document.createTextNode(valeurs[i]));
        tr.appendChild(td);
        tr = tr.nextSibling;
    }
}

AffPlotTab.prototype.joliFormattage = function(v, precision) {
    var limitesci = 3; // décimales avant de passer en mode sci
    
    if (v == 0)
        return("0");
    var sj = ""+v;
    if ("Infinity" === sj || "-Infinity" === sj || "NaN" === sj)
        return(""+v);
    var signe;
    if (v >= 0)
        signe = "";
    else {
        v = -v;
        signe = "-";
    }
    var exposant = Math.floor(Math.log(v)/Math.log(10));
    var exparr = Math.pow(10, precision);
    var mantisse = v / Math.pow(10, exposant);
    mantisse = Math.round(mantisse*exparr)/exparr;
    if (mantisse >= 10) {
        exposant += 1;
        mantisse = v / Math.pow(10, exposant);
        mantisse = Math.round(mantisse*exparr)/exparr;
    }
    var sv = "";
    var chiffre = Math.floor(mantisse);
    sv += chiffre + ".";
    for (var i=0; i<precision-1; i++) {
        mantisse = (mantisse - chiffre)*10;
        var exparr2 = Math.pow(10, precision-i);
        mantisse = (Math.round(mantisse*exparr))/exparr;
        chiffre = Math.floor(mantisse);
        sv += chiffre;
    }
    mantisse = (mantisse - chiffre)*10;
    chiffre = Math.round(mantisse);
    sv += chiffre;
    var dernier = sv.charAt(sv.length-1);
    while (dernier == '0') {
        sv = sv.substring(0, sv.length-1);
        dernier = sv.charAt(sv.length-1);
    }
    if (exposant != 0) {
        if (exposant > 0 && exposant < limitesci) {
            var sd = sv.substring(0,1);
            if (sv.length-2 < exposant) {
                // transformation de 3.2E2 en 320
                if (sv.length > 2)
                    sd += sv.substring(2,sv.length);
                for (var i=0; i<exposant-(sv.length-2); i++)
                    sd += '0';
            } else {
                // transformation de 3.245E2 en 324.5
                if (sv.length < exposant+2)
                    sd += sv.substring(2);
                else
                    sd += sv.substring(2,exposant+2) + "." + sv.substring(exposant+2);
            }
            sv = sd;
        } else if (exposant < 0 && exposant > -limitesci) {
            // transformation de 3.2E-2 en 0.032
            var sd = "0.";
            for (var i=0; i<-exposant-1; i++)
                sd += '0';
            sv = sd + sv.charAt(0) + sv.substring(2);
        } else
            sv += "E" + exposant;
    }
    if (sv.charAt(sv.length-1) == '.')
        sv = sv.substring(0, sv.length-1);
    
    sv = signe + sv;
    
    return(sv);
}
/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * une possibilité d'affichage des résultats, avec diverses options
 */
function Affichage() {
    /** type d'affichage (plot | plotlive | image | tableau | multiplot) */
    this.type = null; // String
    
    /** titre affiché */
    this.titre = null; // String
    
    /** nom de l'affichage, optionnel mais utile pour l'identifier */
    this.label = null; // String
    
    /**
     * liste des noms des paramètres de sortie utilisés pour les différents
     * tracés de la sortie graphique
     */
    this.params = null; // String[][]
    
    /** abscisse de début de l'affichage */
    this.xdebut = null; // String
    
    /** abscisse de fin de l'affichage */
    this.xfin = null; // String
    
    /** ordonnée de début de l'affichage */
    this.ydebut = null; // String
    
    /** ordonnée de fin de l'affichage */
    this.yfin = null; // String
    
    /** échelle logarithmique pour les abcisses d'un graphe */
    this.xlog = false;
    
    /** échelle logarithmique pour les ordonnées d'un graphe */
    this.ylog = false;
    
    /** nom du fichier image à mettre en fond d'un graphe, au format GIF */
    this.fond = null; // String
    
    /** abscisse de début de l'image de fond */
    this.xdebutfond = null; // String
    
    /** abscisse de fin de l'image de fond */
    this.xfinfond = null; // String
    
    /** ordonnée de début de l'image de fond */
    this.ydebutfond = null; // String
    
    /** ordonnée de fin de l'image de fond */
    this.yfinfond = null; // String
    
    /**
     * option de zoom de l'image de fond.
     * La valeur par défaut est false : il n'y a pas de zoom de l'image de fond.
     * Mettre à true dans la classe de la simulation pour permettre un zoom
     * de l'image de fond
     */
    this.zooming = false;

    /** dimension x de l'image pour AffImage */
    this.imgdimx = 100; // entier
    
    /** dimension y de l'image pour AffImage */
    this.imgdimy = 100; // entier
    
    /** palette de couleurs pour AffImage */
    this.palette = null; // type ?
    
    /** option pour connecter les points d'un graphe */
    this.connecter = false;
    
    /** sous-affichages pour afficher plusieurs plotlive en même temps */
    this.sousAff = null; // Affichage[]
    
    /** ordre dans lequel les sous-affichages sont affichés. Valeurs possibles: "x" ou "y". Défaut: "x"
        qui signifie de la gauche vers la droite puis de haut en bas. S'il y a deux affichages, ils seront
        côte à côte avec "x", et l'un au-dessus de l'autre avec "y". */
    this.ordreSousAff = "x"; // String
    
    /**
     * Option de recopie des valeurs de sortie vers les valeurs d'entrée.
     * Valeur par défaut: false.
     * Quand cette option est activée, les nouvelles valeurs d'entrée après
     * l'affichage d'une trajectoire dans plotlive prennent les valeurs des
     * paramètres de sortie correspondants après le calcul.
     */
     this.boucle = false;
     
     /**
      * Affichage des points d'un graphe: "none", "points", "dots", ou "various".
      * Défaut : "points"
      */
     this.points = "points"; // String
     
     /**
      * Utilisation de couleurs pour tracer les courbes des graphes.
      * true (activé) par défaut.
      */
     this.couleurs = true;
     
     /**
      * Pour afficher un histogramme
      */
     this.histogramme = false;
     
     /**
      * Pour effacer le graphique automatiquement à chaque fois
      */
     this.effacer = false;
     
     /**
      * Pour ajuster le graphique automatiquement à chaque fois
      */
     this.ajuster = false;
     
     /**
      * Pour recadrer le graphique à chaque fois à partir des valeur xmin... de l'affichage
      */
     this.recadrer = false;
     
     /**
      * Pour obtenir une zone carrée pour un graphe
      */
     this.carre = false;
     
     return(this);
}
/*
SimuLab
Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Gestion du temps.
 */
//public Chronos(SimuApplet applet, TypeAffichage typeAff, boolean boucle) {
function Chronos(applet, typeAff, boucle, delai) {
    this.applet = applet; // SimuApplet
    this.typeAff = typeAff; // TypeAffichage
    this.boucle = boucle; // boolean
    this.lin = null; // ListeValeurs
    this.delai = delai;
    this.timeout = null;
    
    return(this);
}

//public void initCalculLive(ListeValeurs in) throws SimuException {
Chronos.prototype.initCalculLive = function(lin) {
    this.lin = lin;
    this.applet.initCalculLive(lin);
}

Chronos.prototype.start = function() {
    var that = this;
    this.timeout = setTimeout(function() {that.iteration()}, 0);
}

Chronos.prototype.stop = function() {
    if (this.timeout != null)
        clearTimeout(this.timeout);
}

Chronos.prototype.fin = function() {
    this.typeAff.fin();
}

//public void recopie(ListeValeurs out) throws SimuException {
Chronos.prototype.recopie = function(out) {
    var lin2, i, nom, vout, v2;
    
    lin2 = new ListeValeurs();
    vin = lin.noms();
    for (i=0; i<vin.length; i++) {
        nom = vin[i];
        vout = out.lireString(nom);
        if (vout != null)
            v2 = vout;
        else
            v2 = lin.lireString(nom);
        lin2.ajouterString(nom, v2);
    }
    this.lin = lin2;
}

Chronos.prototype.iteration = function() {
    var out, sfin, t1, t2, attente, continuer, that;
    
    try {
        t1 = new Date().getTime();
        out = this.applet.calculLive();
        sfin = null;
        if (out != null) {
            try {
                sfin = out.lireString('fin');
            } catch (ex) {
            }
        }
        continuer = true;
        if (out == null || sfin == 'simulation') {
            this.fin();
            continuer = false;
        } else if (sfin == 'trajectoire') {
            if (this.boucle)
                this.recopie(out);
            this.applet.initCalculLive(this.lin);
            this.typeAff.avantLancement();
        } else if (sfin == 'courbe') {
            this.typeAff.update(out);
            this.typeAff.avantLancement();
        } else {
            this.typeAff.update(out);
        }
        
        if (continuer) {
            t2 = new Date().getTime();
            attente = this.delai - (t2 - t1);
            if (attente < 10)
                attente = 10;
            that = this;
            this.timeout = setTimeout(function() {that.iteration()}, attente);
        } else {
            if (this.boucle)
                this.applet.changerValeurs(this.lin);
        }
    } catch (ex) {
        this.applet.handleException(ex);
    }
}
/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Zone d'affichage d'une image pour AffImage.
 */
//public class ImageCanvas extends Canvas {
//public ImageCanvas(int initialWidth, int initialHeight, IndexColorModel palette) {
function ImageCanvas(initialWidth, initialHeight, palette) {
    this.imagedata = null;
    this.delai = 100; // en ms
    this.w = initialWidth;
    this.h = initialHeight;
    this.palette = palette; // tableau [0-255][0..2] des couleurs RVB
    //this.size = {'width': this.w, 'height': this.h};
    this.source = null;
    
    this.canvas = document.createElement('canvas');
    this.canvas.setAttribute('width', this.w);
    this.canvas.setAttribute('height', this.h);
    this.ctx = this.canvas.getContext('2d');
}

ImageCanvas.prototype.getCanvas = function() {
    return(this.canvas);
}

//public void updateImage(double[][] tval) throws SimuException {
//public void updateImage(Image im) throws SimuException {
ImageCanvas.prototype.updateImage = function(param) {
    var tval, index, j, i, v;
    
    if (param.nodeName == 'CANVAS') {
        if (param.width != this.w)
            throw new Error('Longueur image ' + param.width + ' != ' + this.w);
        if (param.height != this.h)
            throw new Error('Largeur image ' + param.height + ' != ' + this.h);
        
        this.ctx.drawImage(param, 0, 0);
        return;
    }
    
    tval = param;
    if (this.imagedata == null)
        this.imagedata = this.ctx.createImageData(this.w, this.h);
    if (tval.length != this.w)
        throw new Error(Messages.get('longueur_image') + ' ' + tval.length + ' != ' + this.w);
    if (tval[0].length != this.h)
        throw new Error(Messages.get('largeur_image') + ' ' + tval[0].length + ' != ' + this.h);
    index = 0;
    if (this.palette == null) {
        for (j=0; j<this.h; j++) {
            for (i=0; i<this.w; i++) {
                v = Math.round(tval[i][j]);
                this.imagedata.data[index++] = v; // red
                this.imagedata.data[index++] = v; // green
                this.imagedata.data[index++] = v; // blue
                this.imagedata.data[index++] = 255; // alpha
            }
        }
    } else {
        for (j=0; j<this.h; j++) {
            for (i=0; i<this.w; i++) {
                v = Math.round(tval[i][j]);
                this.imagedata.data[index++] = this.palette[v][0];
                this.imagedata.data[index++] = this.palette[v][1];
                this.imagedata.data[index++] = this.palette[v][2];
                this.imagedata.data[index++] = 255;
            }
        }
    }
    this.ctx.putImageData(this.imagedata, 0, 0);
}
/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Liste de valeurs accessibles par leur nom. Plusieurs valeurs avec le même nom
 * sont stockées sous forme de Vector à partir de la deuxième valeur.
 */
function ListeValeurs() {
    this.valeurs = {};
    this.vNoms = new Array(); // ajouté pour permettre de conserver l'ordre des valeurs
}

/**
 * Ajoute une paire (nom, valeur) à la liste. Si une valeur existe déjà
 * pour ce nom, un tableau (Vector) est créé pour contenir les valeurs
 * correspondant au nom. Dans ce dernier cas, un Vector sera renvoyé lors
 * d'un appel à lire.
 */
//public void ajouter(String nom, Object valeur) {
ListeValeurs.prototype.ajouter = function(nom, valeur) {
    var o, v;
    if (this.valeurs.hasOwnProperty(nom)) {
        o = this.valeurs[nom];
        if (Object.prototype.toString.call(o) === '[object Array]')
            o.push(valeur);
        else {
            v = new Array();
            v.push(o);
            v.push(valeur);
            this.valeurs[nom] = v;
        }
    } else {
        this.valeurs[nom] = valeur;
        this.vNoms.push(nom);
    }
}

// remarque : ces fonctions ajouterXXX n'ont pas beaucoup de sens en Javascript...

//public void ajouterString(String nom, String valeur) {
ListeValeurs.prototype.ajouterString = function(nom, valeur) {
    this.ajouter(nom, valeur);
}

//public void ajouterDouble(String nom, double valeur) {
ListeValeurs.prototype.ajouterDouble = function(nom, valeur) {
    this.ajouter(nom, valeur);
}

//public void ajouterEntier(String nom, int valeur) {
ListeValeurs.prototype.ajouterEntier = function(nom, valeur) {
    this.ajouter(nom, valeur);
}

//public void ajouterBooleen(String nom, boolean valeur) {
ListeValeurs.prototype.ajouterBooleen = function(nom, valeur) {
    this.ajouter(nom, valeur);
}

/**
 * Renvoit la valeur correspondant au nom. Si aucune valeur n'a été entrée pour ce nom,
 * lance une erreur SimuException.
 */
//public Object lire(String nom) throws SimuException {
ListeValeurs.prototype.lire = function(nom) {
    var o = this.valeurs[nom];
    if (o == null)
        throw new Error(Messages.get('aucune_valeur') + ': ' + nom);
    return(o);
}

/**
 * Renvoit la valeur correspondant au nom, sous forme de String. Si la valeur
 * entrée était un Double, elle est convertie en String.
 */
//public String lireString(String nom) throws SimuException {
ListeValeurs.prototype.lireString = function(nom) {
    var o = this.lire(nom);
    return('' + o);
}

/**
 * Renvoit la valeur correspondant au nom, sous forme de double. Si la valeur
 * entrée était un String, elle est convertie en double.
 */
//public double lireDouble(String nom) throws SimuException {
ListeValeurs.prototype.lireDouble = function(nom) {
    var o, d;
    o = this.lire(nom);
    if (typeof o != 'number')
        d = Number(o);
    else
        d = o;
    return(d);
}

//public int lireEntier(String nom) throws SimuException {
ListeValeurs.prototype.lireEntier = function(nom) {
    var o, e;
    o = this.lire(nom);
    if (typeof o == 'string')
        e = parseInt(o);
    else if (typeof o == 'number')
        e = o.toFixed();
    else
        e = (Number(o)).toFixed();
    return(e);
}

//public boolean lireBooleen(String nom) throws SimuException {
ListeValeurs.prototype.lireBooleen = function(nom) {
    var o, b;
    o = this.lire(nom);
    if (typeof o == 'string')
        b = (o == 'true');
    else if (typeof o == 'number')
        b = (o != 0);
    else
        b = o;
    return(b);
}

ListeValeurs.prototype.taille = function() {
    return(this.vNoms.length);
}

/**
 * Renvoit la liste de tous les noms, sous forme de Vector.
 */
ListeValeurs.prototype.noms = function() {
    return(this.vNoms);
}

/*
SimuLab

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

function Messages() {
}

Messages.langue = 'fr';

Messages.messages = {
    'fr' : {
        /* SimuApplet */
        '?' : "?",
        'Relancer' : "Relancer",
        'Erreur' : "Erreur",
        'Reinitialiser' : "Réinitialiser",
        'pas_un_nombre' : "n'est pas un nombre !",
        'parametre_affichage' : "Attention: le paramètre d'affichage",
        'pas_declare' : "n'a pas été déclaré comme paramètre de sortie !",
        'affichage_non_defini' : "Affichage non défini",
        'affichage_inconnu' : "type d'affichage inconnu",
        'sans_appletdoc' : "Pas de APPLETDOC sous DEADOC ???",
        'sans_listeparams' : "Pas de LISTEPARAMS sous APPLETDOC ???",
        'sans_parametre' : "Pas de PARAMETRE",
        'dans_xml' : "dans le fichier XML ???",
        'parametre' : "Paramètre",
        'Ensembles' : "Ensembles",
        'ressource_introuvable' : "Erreur: ressource introuvable",
        'mauvais_xml' : "Mauvais fichier XML !",
        'calculLive_necessaire' : "Les affichages plotlive et image nécessite l'implémentation de la méthode calculLive dans l'applet de simulation",
        'calcul_necessaire' : "Les affichages plot et tableau nécessite l'implémentation de la méthode calcul dans l'applet de simulation",
        'OK' : "OK",

        /* affichages */
        'continuer' : "continuer",
        'stop' : "stop",
        'ajuster' : "ajuster",
        'effacer' : "effacer",
        'meme_nombre' : "pas le même nombre de coordonnées x et y !",
        'multiplot_sans_affichage' : "Erreur: multiplot utilisé sans sous-affichage",
        'mauvaise_sortie' : "Mauvais type de paramètre en sortie",
        'aucune_sortie' : "Aucun paramètre de sortie trouvé pour l'image",
        'aucun_resultat' : "Impossible de trouver les résultats pour le plot",
        'aucun_parametre_tableau' : "erreur: aucun paramètre pour l'affichage tableau",

        /* ListeValeurs */
        'aucune_valeur' : "ListeValeurs.lire: Aucune valeur pour ce nom",

        /* ImageCanvas */
        'longueur_image' : "Longueur image",
        'largeur_image' : "Largeur image"
    },
    'en' : {
        /* SimuApplet */
        '?' : "?",
        'Relancer' : "Restart",
        'Erreur' : "Error",
        'Reinitialiser' : "Reset",
        'pas_un_nombre' : "is not a number !",
        'parametre_affichage' : "Warning: the display parameter",
        'pas_declare' : "has not been declared as output parameter !",
        'affichage_non_defini' : "Undefined display",
        'affichage_inconnu' : "Unknown type of display",
        'sans_appletdoc' : "No APPLETDOC within DEADOC ???",
        'sans_listeparams' : "No LISTEPARAMS within APPLETDOC ???",
        'sans_parametre' : "No PARAMETRE",
        'dans_xml' : "in the XML file ???",
        'parametre' : "Parameter",
        'Ensembles' : "Sets",
        'ressource_introuvable' : "Error: resource not found",
        'mauvais_xml' : "Bad XML file !",
        'calculLive_necessaire' : "plotlive and image displays require the implementation of the calculLive method in the simulation applet",
        'calcul_necessaire' : "plot and tableau displays require the implementation of the calcul method in the simulation applet",
        'OK' : "OK",

        /* affichages */
        'continuer' : "continue",
        'stop' : "stop",
        'ajuster' : "fill",
        'effacer' : "erase",
        'meme_nombre' : "Not the same number of x and y coordinates !",
        'multiplot_sans_affichage' : "Error: multiplot used without any sub-display",
        'mauvaise_sortie' : "Bad type of output parameter",
        'aucune_sortie' : "No exit parameter found for the image",
        'aucun_resultat' : "Plot results not found",
        'aucun_parametre_tableau' : "error: no parameter for the tableau display",

        /* ListeValeurs */
        'aucune_valeur' : "ListeValeurs.lire: No value for this name",

        /* ImageCanvas */
        'longueur_image' : "Image width",
        'largeur_image' : "Image height"
    }
}

Messages.get = function(nom) {
    return(Messages.messages[Messages.langue][nom]);
}
/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/


/**
 * Paramètre d'entrée
 */
function ParamIn() {
    /** nombre | string */
    this.type = null; // String
    
    /** nom de la variable */
    this.label = null; // String
    
    /** titre utilisé pour demander la valeur ou l'afficher */
    this.titre = null; // String
    
    /** unité */
    this.unit = null; // String
    
    /**
     * méthode d'acquisition; valeurs autorisées: champ | choix | curseur | case.
     * champ: champ texte,
     * choix: pop-up menu avec une liste de valeurs possibles,
     * curseur: curseur permettant d'entrer une valeur numérique de 0 à 100,
     * case: case à cocher, renvoyant les valeurs "on" (coché) ou "off" (pas coché)
     */
    this.acquisition = null; // String
    
    /** liste de choix possibles, utilisé si acquisition="choix" (tableau de String) */
    this.choix = null; // String[]
    
    /** valeur par défaut sous forme de String */
    this.defaut = null; // String
    
    /** Description pour l'aide en ligne */
    this.description = null; // String
    
    
    if (arguments.length == 8) {
        this.type = arguments[0];
        this.label = arguments[1];
        this.titre = arguments[2];
        this.unit = arguments[3];
        this.acquisition = arguments[4];
        this.choix = arguments[5];
        this.defaut = arguments[6];
        this.description = arguments[7];
    }
    
    return(this);
}
/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Paramètre de sortie de l'algorithme
 */
function ParamOut() {
    
    /** nombre | string | tableau | image */
    this.type = null; // String
    
    /** nom de la variable, utilisé dans les paramètres d'affichage */
    this.label = null; // String
    
    /** titre utilisé pour demander la valeur ou l'afficher */
    this.titre = null; // String
    
    /** unité */
    this.unit = null; // String
    
    
    if (arguments.length == 4) {
        this.type = arguments[0];
        this.label = arguments[1];
        this.titre = arguments[2];
        this.unit = arguments[3];
    }
    
    return(this);
}
/*

Copyright (C) 2012  Observatoire de Paris

The JavaScript code in this page is free software: you can
redistribute it and/or modify it under the terms of the GNU
General Public License (GNU GPL) as published by the Free Software
Foundation, either version 3 of the License, or (at your option)
any later version.  The code is distributed WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU GPL for more details.

As additional permission under GNU GPL version 3 section 7, you
may distribute non-source (e.g., minimized or compacted) forms of
that code without the copy of the GNU GPL normally required by
section 4, provided you include this license notice and a URL
through which recipients can access the Corresponding Source.

*/

if (!window.Node) {
    var Node = {
        ELEMENT_NODE                :  1,
        ATTRIBUTE_NODE              :  2,
        TEXT_NODE                   :  3,
        CDATA_SECTION_NODE          :  4,
        ENTITY_REFERENCE_NODE       :  5,
        ENTITY_NODE                 :  6,
        PROCESSING_INSTRUCTION_NODE :  7,
        COMMENT_NODE                :  8,
        DOCUMENT_NODE               :  9,
        DOCUMENT_TYPE_NODE          : 10,
        DOCUMENT_FRAGMENT_NODE      : 11,
        NOTATION_NODE               : 12
    };
}

/**
 * Application créant une interface pour un problème donné dans une classe dérivée.
 * Une classe dérivée de SimuApplet doit définir le problème physique (paramètres et
 * calcul) avec les méthodes définies dans SimuParams.
 * Cette classe dérivée doit implémenter les méthodes
 * initCalculLive, calculLive et/ou calcul, et peut utiliser les méthodes
 * addParamIn, addParamOut et addAffichage définies dans SimuApplet.
 */
function SimuApplet(calculs) {
    // méthodes de calculs (avec les méthodes calcul et/ou initCalculLive + calculLive)
    this.calculs = calculs;
    
    // attributs de SimuParams ("publics")
    this.inparams = new Array();
    this.outparams = new Array();
    this.affichages = new Array();
    this.ensembles = new ListeValeurs();
    this.titreEnsembles = 'Ensembles';
    
    // attributs "privés"
    this.champs = null; // Array
    this.noaff = -1; // int
    this.za = null; // TypeAffichage
    this.chxens = null;
    this.selens = null; // string
    this.nomFichierXML = null; // string
    this.xmlDoc = null;
    this.delai = 50;
    this.reinit = false; // utilisé pour réinitialiser après une erreur
    
    var moi = this;
    this.actionPerformedProxy = function(e) { moi.actionPerformed(e) };
    this.itemStateChangedProxy = function(e) { moi.itemStateChanged(e) };
    
    if (window.addEventListener)
        window.addEventListener('load', function() { moi.initParams(); }, false);
    else if (window.attachEvent)
        window.attachEvent('onload', function() { moi.initParams(); });
    
    return(this);
}

// *************************************
// méthodes pour SimuParams

/** renvoit la liste des paramètres d'entrée (Array of ParamIn) */
SimuApplet.prototype.getInParams = function() {
    return(this.inparams);
}

/** renvoit la liste des paramètres de sortie (Array of ParamOut) */
SimuApplet.prototype.getOutParams = function() {
    return(this.outparams);
}

/** renvoit la liste des possibilités d'affichage (Array of Affichage) */
SimuApplet.prototype.getAffichages = function() {
    return(this.affichages);
}

/** renvoit l'affichage avec le label donné */
SimuApplet.prototype.getAffichage = function(label) {
    var i, j;
    if (label == null)
        return(null);
    for (i=0; i<this.affichages.length; i++)
        if (label == this.affichages[i].label)
            return(this.affichages[i]);
    for (i=0; i<this.affichages.length; i++)
        if (this.affichages[i].sousAff != null)
            for (j=0; j<this.affichages[i].sousAff.length; j++)
                if (label == this.affichages[i].sousAff[j].label)
                    return(this.affichages[i].sousAff[j]);
    return(null);
}

/** renvoit l'affichage choisi par l'utilisateur */
SimuApplet.prototype.getAffichageChoisi = function() {
    if (this.noaff == -1)
        return(null);
    return(this.affichages[this.noaff]);
}

/** ajoute un paramètre d'entrée à la liste */
SimuApplet.prototype.addParamIn = function(p) {
    this.inparams.push(p);
}

/** ajoute un paramètre de sortie à la liste */
SimuApplet.prototype.addParamOut = function(p) {
    this.outparams.push(p);
}

/** ajoute une option d'affichage à la liste */
SimuApplet.prototype.addAffichage = function(p) {
    this.affichages.push(p);
}

/** ajoute un ensemble de valeurs */
//public void addEnsemble(String nom, ListeValeurs l) {
SimuApplet.prototype.addEnsemble = function(nom, l) {
    this.ensembles.ajouter(nom, l);
}

/** Définit le titre des ensembles de valeurs */
SimuApplet.prototype.setTitreEnsembles = function(titre) {
    this.titreEnsembles = titre;
}

/** Spécifie le fichier XML avec la définition des paramètres et des affichages. */
SimuApplet.prototype.appletDoc = function(nomFichier) {
    this.nomFichierXML = nomFichier;
}


SimuApplet.prototype.toutEffacer = function() {
    var inputp, div_affichage;
    inputp = document.getElementById('inputp');
    if (inputp != null)
        inputp.parentNode.removeChild(inputp);
    div_affichage = document.getElementById('affichage');
    if (div_affichage != null)
        div_affichage.parentNode.removeChild(div_affichage);
}

/**
 * Affichage de la fenêtre et appel la lecture du fichier de configuration
 */
SimuApplet.prototype.initParams = function() {
    if (this.inparams.length == 0)
        this.lireParametres();
    this.noaff = -1;
    this.za = null;
    this.toutEffacer();
    var inputp = this.makeInputPanel(null);
    if (inputp != null)
        document.body.appendChild(inputp);
}

/**
 * Création de la zone avec les paramètres d'entrée
 */
SimuApplet.prototype.makeInputPanel = function(lin) {
    var inp, inputp, nbgrid, table, tbody, cellules, ip, tr, td, defauts, texte, noms, io, nom, option, par, bhelp, titre, vdef, tf, choix, ic, curseur, canvas_curseur, labcurseur, chk, actionsp, vaff, ia, aff, bok;
    
    inp = this.getInParams();
    inputp = document.createElement('table');
    inputp.setAttribute('id', 'inputp');
    //inputp.setAttribute('class', 'parametres');
    // pour IE7:
    //inputp.className = 'parametres';
    // IE7 nécessite aussi l'utilisation de tbody, et display: inline-block ne marche pas pour obtenir la taille de la zone,
    // du coup on est obligé d'utiliser une table pour tout, ce qui complique l'ajout d'éléments...
    tbody = document.createElement('tbody');
    inputp.appendChild(tbody);
    this.champs = new Array();
    try {
        defauts = null;
        if (this.ensembles.taille() > 0) {
            tr = document.createElement('tr');
            tbody.appendChild(tr);
            td = document.createElement('td');
            tr.appendChild(td);
            texte = document.createTextNode(this.titreEnsembles + ':');
            td.appendChild(texte);
            this.chxens = document.createElement('select');
            noms = this.ensembles.noms();
            for (io=0; io<noms.length; io++) {
                nom = noms[io];
                option = document.createElement('option');
                option.setAttribute('value', nom);
                option.appendChild(document.createTextNode(nom));
                this.chxens.appendChild(option);
                if (defauts == null)
                    defauts = this.ensembles.lire(nom);
                if (this.selens == nom) {
                    option.selected = true;
                    defauts = this.ensembles.lire(this.selens);
                }
            }
            if (this.chxens.addEventListener)
                this.chxens.addEventListener('change', this.itemStateChangedProxy, false);
            else
                this.chxens.attachEvent('onchange', this.itemStateChangedProxy);
            td.appendChild(this.chxens);
        }
        for (ip=0; ip<inp.length; ip++) {
            tr = document.createElement('tr');
            tbody.appendChild(tr);
            td = document.createElement('td');
            tr.appendChild(td);
            par = inp[ip];
            
            bhelp = null;
            if (this.verifExistenceAide(par)) {
                bhelp = document.createElement('input');
                bhelp.setAttribute('type', 'button');
                bhelp.setAttribute('value', Messages.get('?'));
                bhelp.setAttribute('id', 'help' + ip);
                if (bhelp.addEventListener)
                    bhelp.addEventListener('click', this.actionPerformedProxy, false);
                else
                    bhelp.attachEvent('onclick', this.actionPerformedProxy);
            }

            titre = par.titre;
            if (titre == null)
                titre = par.label;
            if (par.unit != null)
                titre += ' (' + par.unit + ')';
            if (bhelp != null)
                titre = ' ' + titre;
            
            vdef = null;
            if (lin != null)
                vdef = lin.lireString(par.label);
            else if (defauts != null) {
                try {
                    vdef = defauts.lireString(par.label);
                } catch (ex) {
                }
            }
            if (vdef == null && par.defaut != null)
                vdef = par.defaut;
            
            if (par.acquisition == 'champ') {
                if (bhelp != null)
                    td.appendChild(bhelp);
                td.appendChild(document.createTextNode(titre + ': '));
                tf = document.createElement('input');
                tf.setAttribute('type', 'text');
                tf.setAttribute('size', '10');
                if (vdef != null)
                    tf.value = vdef;
                this.champs.push(tf);
                td.appendChild(tf);
            } else if (par.acquisition == 'choix') {
                if (bhelp != null)
                    td.appendChild(bhelp);
                td.appendChild(document.createTextNode(titre + ': '));
                choix = document.createElement('select');
                for (ic=0; ic < par.choix.length; ic++) {
                    option = document.createElement('option');
                    option.setAttribute('value', par.choix[ic]);
                    option.appendChild(document.createTextNode(par.choix[ic]));
                    if (vdef == par.choix[ic])
                        option.selected = true;
                    choix.appendChild(option);
                }
                this.champs.push(choix);
                td.appendChild(choix);
            } else if (par.acquisition == 'curseur') {
                if (bhelp != null) {
                    td.appendChild(bhelp);
                    td.appendChild(document.createTextNode(titre + ': '));
                } else {
                    td.appendChild(document.createTextNode(titre + ': '));
                }
                td.appendChild(document.createElement('br'));
                canvas_curseur = document.createElement('canvas');
                canvas_curseur.setAttribute('id', 'curseur' + ip);
                td.appendChild(canvas_curseur);
                curseur = new Curseur('curseur' + ip, 0, 100, vdef == null ? 0 : vdef, 101, false, function(e) {
                    var curs = e.target;
                    var labcurseur = document.getElementById('labcurseur' + ip);
                    labcurseur.innerHTML = ' = ' + curs.getValeur();
                });
                labcurseur = document.createElement('span');
                if (vdef != null) {
                    labcurseur.innerHTML = ' = ' + vdef + '  ';
                } else {
                    labcurseur.innerHTML = ' = 0  ';
                }
                td.appendChild(labcurseur);
                this.champs.push(curseur);
            } else if (par.acquisition == 'case') {
                if (bhelp != null)
                    td.appendChild(bhelp);
                chk = document.createElement('input');
                chk.setAttribute('type', 'checkbox');
                td.appendChild(document.createTextNode(titre));
                if (vdef != null)
                    if (vdef == 'on')
                        chk.checked = true;
                td.appendChild(chk);
                this.champs.push(chk);
            } else
                this.champs.push(null);
        }
    } catch (ex) {
        this.handleException(ex);
        return(null);
    }
    tr = document.createElement('tr');
    td = document.createElement('td');
    tr.appendChild(td);
    //td.setAttribute('id', 'actions');
    vaff = this.getAffichages();
    if (this.noaff == -1) {
        for (ia=0; ia < vaff.length; ia++) {
            aff = vaff[ia];
            bok = document.createElement('input');
            bok.setAttribute('type', 'button');
            bok.setAttribute('value', aff.titre);
            bok.setAttribute('id', 'OK' + ia);
            if (bok.addEventListener)
                bok.addEventListener('click', this.actionPerformedProxy, false);
            else
                bok.attachEvent('onclick', this.actionPerformedProxy);
            td.appendChild(bok);
        }
    } else {
        aff = vaff[this.noaff];
        bok = document.createElement('input');
        bok.setAttribute('type', 'button');
        bok.setAttribute('value', Messages.get('Relancer'));
        bok.setAttribute('id', 'Relancer');
        if (bok.addEventListener)
            bok.addEventListener('click', this.actionPerformedProxy, false);
        else
            bok.attachEvent('onclick', this.actionPerformedProxy);
        td.appendChild(bok);
    }
    tbody.appendChild(tr);
    return(inputp);
}

// renvoie le premier enfant de premier niveau de l'élément XML parent avec le nom donné, ou null s'il n'est pas trouvé
SimuApplet.prototype.enfantParNom = function(parent, nom) {
    var n;
    for (n=parent.firstChild; n != null; n = n.nextSibling) {
        if (n.nodeType == Node.ELEMENT_NODE && n.nodeName == nom)
            return(n);
    }
    return(null);
}

/**
* Lit les paramètres spécifiés dans le fichier XML
*/
SimuApplet.prototype.lireParametres = function() {
    var appletdoc, listeparams, node, param_in, attribute_value, node_valeurs, tab_choix, node_choix, node_description, param_out, ensemble, n;
    
    // lecture du fichier XML si nécessaire
    if (this.xmlDoc == null)
        this.lireXML();
    
    appletdoc = null;
    if (this.xmlDoc.documentElement.nodeName == 'APPLET_SIMULAB')
        appletdoc = this.xmlDoc.documentElement;
    else // cas DEADOC
        appletdoc = this.enfantParNom(this.xmlDoc.documentElement, 'APPLETDOC');
    if (appletdoc == null) {
        alert(Messages.get('sans_appletdoc'));
        return;
    }
    listeparams = this.enfantParNom(appletdoc, 'LISTEPARAMS');
    if (listeparams == null) {
        alert(Messages.get('sans_listeparams'));
        return;
    }
    
    for (node = listeparams.firstChild; node != null; node = node.nextSibling) {
        
        // Paramètre pour la compatibilité ascendente
        // (PARAMETRE a été remplacé par PARAMETRE_ENTREE)
        if ( node.nodeName == 'PARAMETRE' ) {
            
            param_in = new ParamIn();
            attribute_value = null;

            if ((attribute_value = node.getAttribute('acquisition')) != null)
                param_in.acquisition = attribute_value;

            if ((attribute_value = node.getAttribute('defaut')) != null)
                param_in.defaut = attribute_value;
                
            if ((attribute_value = node.getAttribute('label')) != null)
                param_in.label = attribute_value;

            if ((attribute_value = node.getAttribute('titre')) != null)
                param_in.titre = attribute_value;

            if ((attribute_value = node.getAttribute('type')) != null)
                param_in.type = attribute_value;

            if ((attribute_value = node.getAttribute('unite')) != null)
                param_in.unit = attribute_value;
            
            if (node.firstChild != null && node.firstChild.nodeValue != '')
                param_in.description = node.firstChild.nodeValue;
            
            this.addParamIn(param_in);
        }
        
       // Paramètres d'entrée
       if ( node.nodeName == 'PARAMETRE_ENTREE' ) {
            param_in = new ParamIn();
            attribute_value = null;
            
            if (  ( attribute_value = node.getAttribute('acquisition') ) != null ) {
                param_in.acquisition = attribute_value;
                
                if ( attribute_value == 'choix' ) {
                    node_valeurs = this.enfantParNom(node, 'VALEURS');
                    if (node_valeurs == null) {
                        alert('Erreur: acquisition choix sans élément VALEURS sous PARAMETRE_ENTREE');
                    } else {
                        tab_choix = new Array();
                        
                        for (node_choix=node_valeurs.firstChild; node_choix != null; node_choix = node_choix.nextSibling) {
                            if (node_choix.nodeType == Node.ELEMENT_NODE && node_choix.nodeName == 'CHOIX') {
                                if ( (attribute_value = node_choix.getAttribute('valeur')) != null )
                                    tab_choix.push(attribute_value);
                                else
                                    tab_choix.push('');
                            }
                        }
                        param_in.choix = tab_choix;
                    }
                }
            }

            if (  (attribute_value = node.getAttribute('defaut')) != null )
                param_in.defaut = attribute_value;
            
            if (  (attribute_value = node.getAttribute('label')) != null )
                param_in.label = attribute_value;

            if (  (attribute_value = node.getAttribute('titre')) != null )
                param_in.titre = attribute_value;

            if (  (attribute_value = node.getAttribute('type')) != null )
                param_in.type = attribute_value;

            if (  (attribute_value = node.getAttribute('unite')) != null )
                param_in.unit = attribute_value;
            
            node_description = this.enfantParNom(node, 'DESCRIPTION');
            if ( node_description != null && node_description.firstChild != null )
                param_in.description = node_description.firstChild.nodeValue;
            
            this.addParamIn(param_in);
        }
        
        // Paramètres de sortie
        if ( node.nodeName == 'PARAMETRE_SORTIE' ) {
            param_out = new ParamOut();
            attribute_value = null;

            if (  (attribute_value = node.getAttribute('label')) != null )
                param_out.label = attribute_value;
            
            if (  (attribute_value = node.getAttribute('type')) != null )
                 param_out.type = attribute_value;
            
            if (  (attribute_value = node.getAttribute('titre')) != null )
                 param_out.titre = attribute_value;
            
            if (  (attribute_value = node.getAttribute('unite')) != null )
                param_out.unit = attribute_value;
            
            this.addParamOut(param_out);
        }
        
        // Paramètres d'affichage
        if ( node.nodeName == 'AFFICHAGE' )
            this.addAffichage(this.lireAffichage(node));
       
       // Ensembles de valeurs
       if ( node.nodeName == 'ENSEMBLE' ) {
            ensemble = new ListeValeurs();
            
            for (n = node.firstChild; n != null; n = n.nextSibling)
                if (n.nodeType == Node.ELEMENT_NODE && n.nodeName == 'VALEURPARAM')
                    ensemble.ajouterString(n.getAttribute('label'), n.getAttribute('valeur'));
            
            this.addEnsemble(node.getAttribute('titre'), ensemble);
       }
    } 
}

/** Parcours récursif des paramètres d'affichages */
//public Affichage lireAffichage(XMLTree noeud_affichage) {
SimuApplet.prototype.lireAffichage = function(noeud_affichage) {
    var affichage, sous_affichages, n;
    
    affichage = new Affichage();

    this.parcourirParametreAffichage(noeud_affichage, affichage);
    
    this.lireListeRefParams(noeud_affichage, affichage);
    
    sous_affichages = new Array(); // de Affichage 
    
    for (n = noeud_affichage.firstChild; n != null; n = n.nextSibling)
        if (n.nodeName == 'AFFICHAGE')
            sous_affichages.push(this.lireAffichage(n));
    
    if (sous_affichages.length > 0)
        affichage.sousAff = sous_affichages;
    
    return affichage; 
}

//public void lireListeRefParams(XMLTree noeud_affichage, Affichage affichage) {
SimuApplet.prototype.lireListeRefParams = function(noeud_affichage, affichage) {
    var listes, nbrefs, n, i, n2;
    
    listes = new Array(); // listes de références, Array de Array de string
    // toutes les listes de références doivent avoir le même nombre de références
    nbrefs = 0;
    for (n = noeud_affichage.firstChild; n != null; n = n.nextSibling)
        if (n.nodeName == 'LISTEREFPARAMS') {
            liste = new Array(); // liste de références
            for (n2 = n.firstChild; n2 != null; n2 = n2.nextSibling)
                if (n2.nodeName == 'REFPARAM')
                    liste.push(n2.getAttribute('nom'));
            listes.push(liste);
            if (nbrefs == 0)
                nbrefs = liste.length;
            else if (nbrefs != liste.length)
                alert('Erreur: pas le même nombre de références dans toutes les listes de références de paramètres');
        }
    if (listes.length > 0)
        affichage.params = listes;
}

/** Sert à lire les attributs d'un paramètre d'affichage */
//public void parcourirParametreAffichage(XMLTree noeud_affichage, Affichage affichage) {
SimuApplet.prototype.parcourirParametreAffichage = function(noeud_affichage, affichage) {
    var attribute_value = null;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('type') ) != null )
        affichage.type = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('titre') ) != null )
        affichage.titre = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('label') ) != null )
        affichage.label = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('xdebut') ) != null )
        affichage.xdebut = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('xfin') ) != null )
        affichage.xfin = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('ydebut') ) != null )
        affichage.ydebut = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('yfin') ) != null )
        affichage.yfin = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('xlog') ) != null )
        affichage.xlog = (attribute_value == 'true');
    
    if (  ( attribute_value = noeud_affichage.getAttribute('ylog') ) != null )
       affichage.ylog = (attribute_value == 'true');
    
    if (  ( attribute_value = noeud_affichage.getAttribute('fond') ) != null )
        affichage.fond = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('xdebutfond') ) != null )
        affichage.xdebutfond = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('xfinfond') ) != null )
        affichage.xfinfond = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('ydebutfond') ) != null )
        affichage.ydebutfond = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('yfinfond') ) != null )
        affichage.yfinfond = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('zooming') ) != null )
        affichage.zooming = (attribute_value == 'true');
    
    if (  ( attribute_value = noeud_affichage.getAttribute('imgdimx') ) != null )
        affichage.imgdimx = parseInt(attribute_value);
    
    if (  ( attribute_value = noeud_affichage.getAttribute('imgdimy') ) != null )
        affichage.imgdimy = parseInt(attribute_value);
    
    // palette ?
    
    if (  ( attribute_value = noeud_affichage.getAttribute('connecter') ) != null )
        affichage.connecter = (attribute_value == 'true');
    
    if (  ( attribute_value = noeud_affichage.getAttribute('ordreSousAff') ) != null )
// attention aux majuscules pour ordreSousAff (remplacées par le parser dans une ancienne version)
        affichage.ordreSousAff = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('boucle') ) != null )
        affichage.boucle = (attribute_value == 'true');
    
    if (  ( attribute_value = noeud_affichage.getAttribute('points') ) != null )
        affichage.points = attribute_value;
    
    if (  ( attribute_value = noeud_affichage.getAttribute('couleurs') ) != null )
        affichage.couleurs = (attribute_value == 'true');
    
    if (  ( attribute_value = noeud_affichage.getAttribute('histogramme') ) != null )
        affichage.histogramme = (attribute_value == 'true');
    
    if (  ( attribute_value = noeud_affichage.getAttribute('effacer') ) != null )
        affichage.effacer = (attribute_value == 'true');
    
    if (  ( attribute_value = noeud_affichage.getAttribute('ajuster') ) != null )
        affichage.ajuster = (attribute_value == 'true');
    
    if (  ( attribute_value = noeud_affichage.getAttribute('recadrer') ) != null )
        affichage.recadrer = (attribute_value == 'true');
    
    if (  ( attribute_value = noeud_affichage.getAttribute('carre') ) != null )
        affichage.carre = (attribute_value == 'true');  
}

/**
 * Traitement des actions de l'utilisateur
 */
SimuApplet.prototype.actionPerformed = function(e) {
    var cmd, noparam;
    
    cmd = (e.target || e.srcElement).getAttribute('id');
    if (cmd.indexOf('OK') == 0) {
        this.noaff = parseInt(cmd.substring(2));
        this.startSimu(true);
    } else if (cmd == 'Reset') {
        if (this.za != null && this.za.estLive())
            this.za.stop();
        this.initParams();
    } else if (cmd == 'Relancer') {
        if (this.za != null && this.za.estLive())
            this.za.stop();
        this.startSimu(this.reinit);
    } else if (cmd.indexOf('help') == 0) {
        noparam = parseInt(cmd.substring(4));
        this.aideParam(noparam);
    }
}

//public void changerValeurs(ListeValeurs l) throws SimuException {
SimuApplet.prototype.changerValeurs = function(l) {
    var inp, i, par, val, chp;
    
    inp = this.getInParams();
    for (i=0; i<inp.length; i++) {
        par = inp[i];
        try {
            val = l.lireString(par.label);
        } catch (ex) {
            continue;
        }
        chp = this.champs[i];
        if (chp.nodeName.toLowerCase() == 'input' && chp.getAttribute('type') == 'text')
            chp.value = val;
        else if (chp instanceof Curseur)
            chp.setValeur(val);
        else if (chp.nodeName.toLowerCase() == 'select')
            chp.value = val;
        else if (chp.nodeName.toLowerCase() == 'input' && chp.getAttribute('type') == 'checkbox')
            chp.value = (val == 'on');
    }
}

SimuApplet.prototype.itemStateChanged = function(e) {
    // itemStateChanged est appelé par chxens via itemStateChangedProxy
    var nom, l;
    
    nom = this.chxens.value;
    try {
        l = this.ensembles.lire(nom);
        this.changerValeurs(l);
    } catch (ex) {
        this.handleException(ex);
        return;
    }
}

/**
 * Traitement d'une erreur
 */
SimuApplet.prototype.handleException = function(ex) {
    var s;
    if (ex.message)
        s = ex.message;
    else
        s = ex;
    if (ex.fileName)
        s += ' in ' + ex.fileName;
    if (ex.lineNumber)
        s += ' line ' + ex.lineNumber;
    alert(Messages.get('Erreur') + ': ' + s);
}

/**
 * Lecture des champs des paramètres d'entrée
 */
//public ListeValeurs lireChamps() throws SimuException {
SimuApplet.prototype.lireChamps = function() {
    var lin, inp, i, par, text, d;
    
    lin = new ListeValeurs();
    inp = this.getInParams();
    for (i=0; i<inp.length; i++) {
        par = inp[i];
        text = null;
        if (this.champs[i].nodeName.toLowerCase() == 'input' && this.champs[i].getAttribute('type') == 'text') {
            text = this.champs[i].value;
            // test si le type de text est par.type
            if (par.type == 'nombre') {
                d = parseFloat(text);
                if (d == NaN)
                    throw new Error(text + ' ' + Messages.get('pas_un_nombre'));
            }
        } else if (this.champs[i].nodeName.toLowerCase() == 'select') {
            text = this.champs[i].value;
        } else if (this.champs[i] instanceof Curseur) {
            text = toString(this.champs[i].getValeur());
        } else if (this.champs[i].nodeName.toLowerCase() == 'input' && this.champs[i].getAttribute('type') == 'checkbox') {
            if (this.champs[i].checked)
                text = 'on';
            else
                text = 'off';
        }
        lin.ajouterString(par.label, text);
    }
    if (this.chxens != null)
        this.selens = this.chxens.value;
    return(lin);
}

/**
 * vérification que les paramètres de l'affichage sont tous déclarés comme ParamOut
 */
//protected void verifParametres(Affichage aff, Vector outp) {
SimuApplet.prototype.verifParametres = function(aff, outp) {
    var ip, jp, nomp, trouv, io, ia;
    
    if (aff.params != null)
        for (ip=0; ip<aff.params.length; ip++)
            for (jp=0; jp<aff.params[ip].length; jp++) {
                nomp = aff.params[ip][jp];
                trouv = false;
                for (io=0; io<outp.length; io++)
                    if (nomp != null && nomp == outp[io].label)
                        trouv = true;
                if (!trouv)
                    alert(Messages.get('parametre_affichage') + ' ' + nomp +
                        ' ' + Messages.get('pas_declare'));
            }
    if (aff.sousAff != null)
        for (ia=0; ia<aff.sousAff.length; ia++)
            this.verifParametres(aff.sousAff[ia], outp);
}

SimuApplet.prototype.getWindowWidth = function() {
    if (window.innerWidth)
        return(window.innerWidth);
    if (window.document.documentElement.clientWidth)
        return(window.document.documentElement.clientWidth);
    return(window.document.body.clientWidth);
}

SimuApplet.prototype.getWindowHeight = function() {
    if (window.innerHeight)
        return(window.innerHeight); // dimension parfois folle avec iOS
    if (window.document.documentElement.clientHeight)
        return(window.document.documentElement.clientHeight); // IE7 retire la taille de la scrollbar
    return(window.document.body.clientHeight);
}

/**
 * Lancement de la simulation
 */
//public void startSimu(boolean init) {
SimuApplet.prototype.startSimu = function(init) {
    var lin, outp, vaff, aff, pval1, urgent, w, h, dimensions, breset;
    
    this.reinit = false;
    try {
        lin = this.lireChamps();
    } catch (ex) {
        this.handleException(ex);
        return;
    }
    outp = this.getOutParams();
    vaff = this.getAffichages();
    aff = vaff[this.noaff];
    
    if (init) {
        this.verifParametres(aff, outp);
        this.toutEffacer();
        pval1 = this.makeInputPanel(lin);
        if (pval1 == null)
            return;
        document.body.appendChild(pval1);
        if (pval1.offsetWidth > this.getWindowWidth() / 2)
            pval1.style.width = (this.getWindowWidth() / 2) + 'px';
    }
    
    try {
        if (aff == null)
            throw new Error(Messages.get('affichage_non_defini'));
        if (init || this.za == null)
            this.za = this.creationTypeAffichage(aff, false);
        urgent = null;
        if (this.za.estLive()) {
            urgent = new Chronos(this, this.za, aff.boucle, this.delai);
            this.za.setChronos(urgent);
            urgent.initCalculLive(lin);
        }
        if (init) {
            w = this.getWindowWidth() - pval1.offsetWidth - 10;
            if (w < 100)
                w = 100;
            h = this.getWindowHeight() - 10;
            if (h < 100)
                h = 100;
            dimensions = {'width': w, 'height': h};
            document.body.appendChild(this.za.initPanel(outp, dimensions));
        }
        this.za.affiche(lin, outp);
    } catch (ex) {
        this.reinit = true;
        this.handleException(ex);
        return;
    }
    
    if (init) {
        breset = document.createElement('input');
        breset.setAttribute('type', 'button');
        breset.setAttribute('value', Messages.get('Reinitialiser'));
        breset.setAttribute('id', 'Reset');
        if (breset.addEventListener)
            breset.addEventListener('click', this.actionPerformedProxy, false);
        else
            breset.attachEvent('onclick', this.actionPerformedProxy);
        pval1.firstChild.lastChild.lastChild.appendChild(breset); // tbody > tr > td
    }
}

//public TypeAffichage creationTypeAffichage(Affichage aff, boolean sousaff) throws SimuException {
SimuApplet.prototype.creationTypeAffichage = function(aff, sousaff) {
    var ta;
    if (aff.type == 'plotlive')
        ta = new AffPlotLive(this, aff, sousaff);
    else if (aff.type == 'plot')
        ta = new AffPlot(this, aff, sousaff);
    else if (aff.type == 'tableau')
        ta = new AffPlotTab(this, aff, sousaff);
    else if (aff.type == 'image')
        ta = new AffImage(this, aff, sousaff, true);
    else if (aff.type == 'imagestatique')
        ta = new AffImage(this, aff, sousaff, false);
    else if (aff.type == 'multiplot')
        ta = new AffMulti(this, aff, sousaff);
    else
        throw new Error(Messages.get('affichage_inconnu') + ': ' + aff.type);
    return(ta);
}

/**
 * titres des axes
 */
//public static String[] titresAxes(Affichage aff, Vector outp) {
SimuApplet.prototype.titresAxes = function(aff, outp) {
    var sx, sy, lsx, lsy, i, par, res;
    
    if (aff == null)
        return null;
    if (aff.params == null)
        return null;
    sx = null;
    sy = null;
    lsx = aff.params[0][0];
    lsy = aff.params[0][1];
    sx = lsx;
    sy = lsy;
    for (i=0; i<outp.length; i++) {
        par = outp[i];
        if (lsx == par.label) {
            if (par.titre != null)
                sx = par.titre;
            if (par.unit != null)
                sx += ' (' + par.unit + ')';
        }
        if (lsy == par.label) {
            if (par.titre != null)
                sy = par.titre;
            if (par.unit != null)
                sy += ' (' + par.unit + ')';
        }
    }
    res = new Array(sx, sy);
    return(res);
}

/**
 * Renvoit l'aide pour le paramètre indiqué à partir du fichier XML,
 * ou null s'il n'y a pas d'aide pour ce paramètre
 */
//protected String lireAideParam(ParamIn param) {
SimuApplet.prototype.lireAideParam = function(param) {
    var aide, appletdoc, listeparams, node, description;
    
    if (param.description != null)
        return(param.description);
    
    if (this.xmlDoc == null)
        return(null);
    
    aide = null;
    appletdoc = null;
    
    if (this.xmlDoc.documentElement.nodeName == 'APPLET_SIMULAB')
        appletdoc = this.xmlDoc.documentElement;
    else
        appletdoc = this.enfantParNom(this.xmlDoc.documentElement, 'APPLETDOC');
    if (appletdoc == null)
        alert(Messages.get('sans_appletdoc'));
    else {
        listeparams = this.enfantParNom(appletdoc, 'LISTEPARAMS');
        if (listeparams == null)
            alert(Messages.get('sans_listeparams'));
        else {
            for (node=listeparams.firstChild; node!=null; node=node.nextSibling) {
                if (node.nodeName == 'PARAMETRE') {
                    if (node.getAttribute('label') == param.label)
                        aide = node.firstChild.nodeValue;
                } else if (node.nodeName == 'PARAMETRE_ENTREE') {
                    if (node.getAttribute('label') == param.label) {
                        description = this.enfantParNom(node, 'DESCRIPTION');
                        if (description != null && description.firstChild != null)
                            aide = description.firstChild.nodeValue;
                    }
                }
            }
        }
    }
    if (aide != null)
        param.description = aide;
    return(aide);
}

/**
 * Affiche l'aide pour le paramètre indiqué à partir du fichier XML.
 * On suppose ici que le fichier XML est correct (le test est fait ailleurs).
 */
//public void aideParam(int nop) {
SimuApplet.prototype.aideParam = function(nop) {
    var par, aide, label, f;
    
    if (this.xmlDoc == null)
        this.lireXML();
    par = this.getInParams()[nop];
    aide = this.lireAideParam(par);
    label = par.label;
    if (aide == null)
        alert(Messages.get('sans_parametre') + ' ' + label + ' ' + Messages.get('dans_xml'));
    if (aide != null) {
        f = new InfoWindow(Messages.get('parametre') + ' ' + label, aide);
        f.afficher();
    }
}

/**
* Vérifie l'existence de l'aide dans le ficher de configuration XML
* @return true si l'aide existe, false sinon
*/
//protected boolean verifExistenceAide(ParamIn param) {
SimuApplet.prototype.verifExistenceAide = function(param) {
    var aide;
    
    aide = this.lireAideParam(param);
    return(aide != null && aide != '');
}

/**
 * pour bloquer le programme pendant nms millisecondes
 */
//public void dormir(long nms) {
SimuApplet.prototype.dormir = function(nms) {
    // sans gestion des threads, Javascript est incapable de faire une pause sans bloquer le navigateur
    // il vaut mieux utiliser setTimeout en Javascript
    alert("Erreur: dormir n'est pas utilisable en javascript, utiliser setDelaiIterations à la place");
}

/**
 * Durée minimum d'une itération en ms. Une pause sera effectuée si un calcul se termine plus vite.
 */
SimuApplet.prototype.setDelaiIterations = function(nms) {
    this.delai = nms;
}

SimuApplet.prototype.lireXML = function() {
    var xmlhttp, arbre, racine;
    
    xmlhttp = new XMLHttpRequest();
    xmlhttp.open('GET', this.nomFichierXML, false);
    try {
        xmlhttp.send();
    } catch (ex) {
        alert('Lecture du fichier ' + this.nomFichierXML + ': ' + (ex.message ? ex.message : ex));
        return(null);
    }
    arbre = xmlhttp.responseXML;
    racine = arbre.documentElement;
    if (racine.nodeName != 'DEADOC' && racine.nodeName != 'APPLET_SIMULAB') {
        alert(Messages.get('mauvais_xml'));
        return;
    }
    this.xmlDoc = arbre;
}

//public void initCalculLive(ListeValeurs in) throws SimuException {
SimuApplet.prototype.initCalculLive = function(lin) {
    if (this.calculs.initCalculLive != undefined)
        this.calculs.initCalculLive(lin);
}

//public ListeValeurs calculLive() throws SimuException {
SimuApplet.prototype.calculLive = function() {
    if (this.calculs.calculLive == undefined)
        throw new Error(Messages.get('calculLive_necessaire'));
    return(this.calculs.calculLive());
}

//public ListeValeurs calcul(ListeValeurs in) throws SimuException {
SimuApplet.prototype.calcul = function(lin) {
    if (this.calculs.calcul == undefined)
        throw new Error(Messages.get('calcul_necessaire'));
    return(this.calculs.calcul(lin));
}


function InfoWindow(titre, message) {
    this.titre = titre;
    this.message = message;
}
InfoWindow.prototype.afficher = function() {
    alert(this.titre + ': ' + this.message);
}
/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Méthode d'affichage (classe abstraite)
 */
function TypeAffichage() {
}

/**
 * Création des composants AWT à afficher
 */
//public abstract Panel initPanel(Vector outp) throws SimuException;
TypeAffichage.prototype.initPanel = function(outp, dimensions) {
}

TypeAffichage.prototype.estLive = function() {
}

TypeAffichage.prototype.setChronos = function(chrono) {
}

TypeAffichage.prototype.avantLancement = function() {
}

/** 
* méthode d'affichage 
* En entrée : paramètres d'entrée sous forme d'objets
*            type d'affichage
*            paramètres de sortie sous forme d'objets
*            état de la simulation
*/
//public abstract void affiche(ListeValeurs in, Vector outp) throws SimuException;
TypeAffichage.prototype.affiche = function(lin, outp) {
}

/**
 * Mise à jour de l'affichage à partir des valeurs de sortie
 */
//public abstract void update(ListeValeurs out) throws SimuException;
TypeAffichage.prototype.update = function(out) {
}

// pour les types d'affichage "live":

/** lancement simu */
TypeAffichage.prototype.start = function() {
}

/** arrêt temporaire de la simu */
TypeAffichage.prototype.stop = function() {
}

/** fin de la simu */
TypeAffichage.prototype.fin = function() {
}

/** effacement affichage */
TypeAffichage.prototype.effacer = function() {
}

/** ajustement du graphe */
TypeAffichage.prototype.ajuster = function() {
}
