/*
Projectile - algorithme de simulation pour SimuApplet

Copyright (C) 2012 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Algorithme de simulation pour SimuApplet.
 * Simule un projectile lancé sur Terre avec une vitesse initiale donnée et un angle donné.
 */
//public class Projectile extends SimuApplet {

new Projectile();

// constructeur de la classe, avec la définition des paramètres de simulation
// et des options d'affichage.
function Projectile() {
    this.g = 9.81;
    this.dt = 0.05;
    this.x = 0;
    this.y = 0;;
    this.vx = 0;
    this.vy = 0;
    
    this.applet = new SimuApplet(this);
    this.applet.appletDoc("projectile_doc.xml");
    this.applet.setDelaiIterations(this.dt * 1000);
}

// calcul live (utilisé avec affichage "plotlive")
// initialisation
//public void initCalculLive(ListeValeurs in) throws SimuException {
Projectile.prototype.initCalculLive = function(lin) {
    var v0, angle;
    
    this.x = 0;
    this.y = 0;
    v0 = lin.lireDouble('v0');
    angle = lin.lireDouble('direction');
    this.vx = v0 * Math.cos(angle/180*Math.PI);
    this.vy = v0 * Math.sin(angle/180*Math.PI);
}

// Calcul du temps t au temps t+1.
//public ListeValeurs calculLive() throws SimuException {
Projectile.prototype.calculLive = function() {
    var out;
    
    if (this.y < 0)
        return null; // fin du calcul
    out = new ListeValeurs();
    this.x += this.vx * this.dt;
    this.y += this.vy * this.dt;
    this.vy -= this.g * this.dt;
    out.ajouterDouble('x', this.x);
    out.ajouterDouble('y', this.y);
    return(out);
}

// calcul complet d'un coup (utilisé avec les affichages "plot" et "tableau")
//public ListeValeurs calcul(ListeValeurs in) throws SimuException {
Projectile.prototype.calcul = function(lin) {
    var v0, angle, out;
    
    this.x = 0;
    this.y = 0;
    v0 = lin.lireDouble('v0');
    angle = lin.lireDouble('direction');
    this.vx = v0 * Math.cos(angle/180*Math.PI);
    this.vy = v0 * Math.sin(angle/180*Math.PI);
    out = new ListeValeurs();
    while (this.y >= 0) {
        this.x += this.vx * this.dt;
        this.y += this.vy * this.dt;
        this.vy -= this.g * this.dt;
        out.ajouterDouble('x', this.x);
        out.ajouterDouble('y', this.y);
    }
    return(out);
}

