/*
Pendule - algorithme de simulation pour SimuLab

Copyright (C) 2012 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Algorithme de simulation pour SimuLab.
 * Pendule de Foucault
 */
//public class Pendule extends SimuApplet {

new Pendule();

function Pendule() {
    this.applet = new SimuApplet(this);
    this.applet.appletDoc("pendule_doc.xml");
    
    this.g = 9.81;
    this.omterre = 2*Math.PI/(24*3600); // rotation de la terre en radian par seconde
    this.pulsation = 0;
    this.omega = 0;
    this.x0 = 0;
    this.v0 = 0;
    this.x = 0;
    this.y = 0;
    this.t = 0;
    this.dt = 0.01; // intervalle de temps entre deux points, en s
    this.duree = 0;
    
    this.applet.setDelaiIterations(Math.round(this.dt*1000));
}

// calcul live (utilisé avec affichage "plotlive")
// initialisation
Pendule.prototype.initCalculLive = function(lin) {
    var latitude, L, vitrot, ajuster;
    
    this.x = this.x0;
    this.y = 0;
    this.t = 0;
    latitude = lin.lireDouble("latitude");
    L = lin.lireDouble("longueur");
    vitrot = lin.lireDouble("vitrot");
    ajuster = lin.lireString("ajuster");
    this.applet.getAffichage("afflive").ajuster = (ajuster == 'on');
    this.x0 = lin.lireDouble("x0");
    this.v0 = lin.lireDouble("v0");
    this.duree = lin.lireDouble("duree");
    this.dt = lin.lireDouble("intervalle");
    this.pulsation = Math.sqrt(this.g / L);
    this.omega = this.omterre * Math.sin(latitude/180.0*Math.PI) * vitrot;
}

// Calcul du temps t au temps t+1.
Pendule.prototype.calculLive = function() {
    var out;
    
    out = new ListeValeurs();
    this.t += this.dt;
    this.xy();
    out.ajouterDouble("x", this.x);
    out.ajouterDouble("y", this.y);
    return out;
}

Pendule.prototype.calcul = function(lin) {
    var out;
    
    out = new ListeValeurs();
    this.initCalculLive(lin);
    while (this.t < this.duree) {
        this.t += this.dt;
        this.xy();
        out.ajouterDouble("x", this.x);
        out.ajouterDouble("y", this.y);
    }
    return out;
}

Pendule.prototype.xy = function() {
    
    /*
    // calcul oversimplifié (vu sur le web) avec v0=0 en supposant omega << pulsation
    double temp = Math.cos(Math.sqrt(pulsation*pulsation + omega*omega)*t);
    x = x0 * Math.cos(omega*t) * temp;
    y = -x0 * Math.sin(omega*t) * temp;
    */
    /*
    // avec v0=0 en supposant omega << pulsation (mais moins de simplifications)
    x = x0 * (Math.cos(omega*t) * Math.cos(pulsation*t) +
        omega/pulsation*Math.sin(omega*t)*Math.sin(pulsation*t));
    y = - x0 * (Math.sin(omega*t) * Math.cos(pulsation*t) -
        omega/pulsation*Math.cos(omega*t)*Math.sin(pulsation*t));
    */
    
    var delta, temp1, temp2, x1, y1, x2, y2;
    
    // mon calcul à moi, calcul de x,y avec v0=0
    delta = Math.sqrt(this.pulsation*this.pulsation + this.omega*this.omega);
    temp1 = this.omega + delta;
    temp2 = this.omega - delta;
    x1 = this.x0*temp1/(2*delta)*Math.cos(temp2*this.t) - this.x0*temp2/(2*delta)*Math.cos(temp1*this.t);
    y1 = -this.x0*temp1/(2*delta)*Math.sin(temp2*this.t) + this.x0*temp2/(2*delta)*Math.sin(temp1*this.t);
    
    // mon calcul avec x0=0
    //double delta = Math.sqrt(pulsation*pulsation + omega*omega);
    x2 = this.v0/delta*Math.sin(delta*this.t)*Math.cos(this.omega*this.t);
    y2 = -this.v0/delta*Math.sin(this.omega*this.t)*Math.sin(delta*this.t);
    
    // cas général
    this.x = x1 + x2;
    this.y = y1 + y2;
}

