/*
Projectile - algorithme de simulation pour SimuApplet

Copyright (C) 2012 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

/**
 * Algorithme de simulation pour SimuApplet.
 * Propagation d'une onde.
 */
//public class Onde extends SimuApplet {

new Onde();

function Onde() {
    this.delai = 50;
    this.applet = new SimuApplet(this);
    this.applet.appletDoc("onde_doc.xml");
    this.applet.setDelaiIterations(this.delai);
    
    this.tmasque = null;
    this.dx = 200;
    this.dy = 200;
    this.dz = 0;
    this.z0 = null;
    this.w = 0;
    this.tps = 0;
    this.champ = null;;
}

Onde.prototype.initTableau = function(x, y) {
    var t, i;
    
    t = new Array(x);
    for (i=0; i<x; i++)
        t[i] = new Array(y);
    
    return(t);
}

// calcul en image (utilisé avec affichage image)
Onde.prototype.initCalculLive = function(lin) {
    var kx, ky, T, rx, ry, long_onde, vitesse, direction, i, j;
    
    long_onde = lin.lireDouble("long_onde");
    vitesse = lin.lireDouble("vitesse") / (1000 / this.delai);
    direction = lin.lireDouble("direction");
    
    this.tmasque = this.initTableau(this.dx, this.dy);
    for (i=0; i<this.dx; i++) {
        for (j=0; j<this.dy; j++){
            this.tmasque[i][j] = 1;
        }
    }
    
    T = long_onde / vitesse;
    this.w = 2 * Math.PI / T;
    this.dz = Math.floor(Math.abs(T));
    rx = this.initTableau(this.dx, this.dy);
    ry = this.initTableau(this.dx, this.dy);
    this.z0 = this.initTableau(this.dx, this.dy);
    kx = Math.cos(direction * Math.PI/180) * 2 * Math.PI / long_onde;
    ky = Math.sin(direction * Math.PI/180) * 2 * Math.PI / long_onde;
    for (i=0; i<this.dx; i++) {
        for (j=0; j<this.dy; j++) {
            rx[i][j] = i;
            ry[i][j] = j;
            this.z0[i][j] = kx*rx[i][j] + ky*ry[i][j];
        }
    }
    this.tps = 0;
    this.champ = this.initTableau(this.dx, this.dy);
}

Onde.prototype.calculLive = function() {
    var out, i, j;
    
    out = new ListeValeurs();
    this.onde_plane();
    for (i=0; i<this.dx; i++) {
        for (j=0; j<this.dy; j++) {
            this.champ[i][j] = 255*this.champ[i][j];
        }
    
    }
    out.ajouter('champ', this.champ);
    this.tps++;
    return out;
}

Onde.prototype.onde_plane = function() {
    var tpsmod, i, j;
    tpsmod = this.tps % this.dz;
    for (i=0; i<this.dx; i++)
        for (j=0; j<this.dy; j++)
            this.champ[i][j] = (Math.cos(this.w * tpsmod - this.z0[i][j]) * this.tmasque[i][j] + 1) / 2;
}

Onde.prototype.calcul = function() {
    throw new Error("calcul n'est pas implémenté dans Onde: " +
        "utiliser calculLive à la place");
}


