/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import java.awt.*;
import java.awt.image.*;
import java.applet.*;

/**
 * Utilis dans SimuPlotLive et SimuPlot pour calculer le zoom de l'image de fond
 */
public class ZoomImage {
    
    /**
     * Renvoit une portion de l'image, agrandie  la taille de l'image d'origine.
     * La portion de l'image est le rectangle  la position x,y de dimension larg x haut.
     * Elle est transforme en une image de dimensions tailleX x tailleY.
     */
    public static Image ajusterImage(Image imsrc, int x, int y, int larg, int haut,
        Applet app, int tailleX, int tailleY) {
        
        CropImageFilter cif;
        Image imres, imaff;
        ImageProducer prod;
        
        if (app == null) {
            System.err.println("ZoomImage: erreur: la rfrence  l'applet est nulle");
            return(null);
        }
        if (imsrc == null) {
            System.err.println("ZoomImage: erreur: la rfrence  l'image est nulle");
            return(null);
        }
        cif = new CropImageFilter(x, y, larg, haut);
        prod = new FilteredImageSource(imsrc.getSource(), cif);
        imres = app.createImage(prod);
        imaff = imres.getScaledInstance(tailleX, tailleY, Image.SCALE_REPLICATE);
        
        return imaff;
    }

}
