/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import java.awt.Panel;
import java.util.Vector;

/**
 * Mthode d'affichage (classe abstraite)
 */
public abstract class TypeAffichage {
    
    /**
     * Cration des composants AWT  afficher
     */
    public abstract Panel initPanel(Vector outp) throws SimuException;
    
    public abstract boolean estLive();
    
    public void setChronos(Chronos chrono) {
    }
    
    public void avantLancement() {
    }
    
    /** 
    * mthode d'affichage 
    * En entre : paramtres d'entre sous forme d'objets
    *            type d'affichage
    *            paramtres de sortie sous forme d'objets
    *            tat de la simulation
    */
    public abstract void affiche(ListeValeurs in, Vector outp) throws SimuException;
    
    /**
     * Mise  jour de l'affichage  partir des valeurs de sortie
     */
    public abstract void update(ListeValeurs out) throws SimuException;
    
    
    // pour les types d'affichage "live":
    
    /** lancement simu */
    public void start() {
    }
    
    /** arrt temporaire de la simu */
    public void stop() {
    }
    
    /** fin de la simu */
    public void fin() {
    }
    
    /** effacement affichage */
    public void effacer() {
    }
    
    /** ajustement du graphe */
    public void ajuster() {
    }
}
