/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import ptolemy.plot.*;
import java.awt.*;
import java.applet.Applet;
import java.awt.image.*;

/**
 * Zone d'affichage du graphe pour AffPlot.
 */
public class SimuPlot extends Plot {

    Applet applet;
    String fond; // image de fond
    boolean zooming;
    int tailleX, tailleY; // taille en pixels de la portion d'image affiche
    double echImgX, echImgY; // chelle image en pixels/units
    double minImgX, maxImgX, minImgY, maxImgY; // position de l'image
    Image img;
    
    /**
     * Construct a plot.
     *  Configure the title, points style, and persistence.
     */
    public SimuPlot(Applet app, Affichage aff) {
        super();
        applet = app;
        fond = aff.fond;
        zooming = aff.zooming;
        setTitle("SimuPlot");
        setPointsPersistence(0);
        setMarksStyle("points");
        setSquareArea(aff.carre);
        setXLog(aff.xlog);
        setYLog(aff.ylog);
        if (fond != null) {
            // recherche de l'image  ct du fichier HTML
            img = applet.getImage(applet.getDocumentBase(), fond);
            if (img != null)
                img = chargementImage(applet, img);
            if (img == null) {
                // recherche de l'image dans le .jar, au mme niveau que la classe de l'applet
                img = applet.getImage(applet.getClass().getResource(fond));
                if (img != null)
                    img = chargementImage(applet, img);
            }
            if (img == null)
                System.err.println("erreur au chargement de l'image " + fond);
            else {
                tailleY = img.getHeight(null);
                tailleX = img.getWidth(null);
                setBackgroundImage(img);
            }
        } else if (zooming) {
            System.err.println("erreur: zoomimg ne peut tre activ car aucune image de fond n'a t spcifi");
            zooming = false;
        }
        if (zooming) {
            if (aff.xdebut == null)
                System.err.println("xdebut n'a pas t initialis + zooming = bug");
            
            /*
            // pos. x du dbut et de la fin de la zone que l'on souhaite visible
            double interminx = new Double(aff.xdebut).doubleValue();
            double intermaxx = new Double(aff.xfin).doubleValue();
            
            // pos. x du dbut et de la fin de la zone d'affichage du graphe
            minX0 = interminx - ((intermaxx - interminx) * _PADDING);
            maxX0 = intermaxx + ((intermaxx - interminx) * _PADDING);
            
            // pos. y du dbut et de la fin de la zone que l'on souhaite visible
            double interminy = new Double(aff.ydebut).doubleValue();
            double intermaxy = new Double(aff.yfin).doubleValue();
            
            // pos. y du dbut et de la fin de la zone d'affichage du graphe
            minY0 = interminy - ((intermaxy - interminy) * _PADDING);
            maxY0 = intermaxy + ((intermaxy - interminy) * _PADDING);
            */
            
            if (aff.xdebutfond != null && aff.xfinfond != null &&
                    aff.ydebutfond != null && aff.yfinfond != null) {
                // pos. x du dbut et de la fin de l'image
                minImgX = new Double(aff.xdebutfond).doubleValue();
                maxImgX = new Double(aff.xfinfond).doubleValue();
                
                // pos. y du dbut et de la fin de l'image
                minImgY = new Double(aff.ydebutfond).doubleValue();
                maxImgY = new Double(aff.yfinfond).doubleValue();
                
                // GROS problme: _lrx et _lry sont indispensables pour calculer la taille
                // et la position de l'image dans setImage, mais on ne les connait
                // que aprs un premier _drawPlot, donc aprs l'affichage initial...
                
            } else {
                // pos. x du dbut et de la fin de la zone que l'on souhaite visible
                double interminx = new Double(aff.xdebut).doubleValue();
                double intermaxx = new Double(aff.xfin).doubleValue();
                
                // pos. x du dbut et de la fin de la zone d'affichage du graphe
                minImgX = interminx - ((intermaxx - interminx) * _PADDING);
                maxImgX = intermaxx + ((intermaxx - interminx) * _PADDING);
                
                // pos. y du dbut et de la fin de la zone que l'on souhaite visible
                double interminy = new Double(aff.ydebut).doubleValue();
                double intermaxy = new Double(aff.yfin).doubleValue();
                
                // pos. y du dbut et de la fin de la zone d'affichage du graphe
                minImgY = interminy - ((intermaxy - interminy) * _PADDING);
                maxImgY = intermaxy + ((intermaxy - interminy) * _PADDING);
            }
            
            // chelle image en pixels/units
            echImgX = tailleX / (maxImgX - minImgX);
            echImgY = tailleY / (maxImgY - minImgY);
        }
    }
    
    public static Image chargementImage(Applet applet, Image img) {
        MediaTracker tracker = new MediaTracker(applet);
        tracker.addImage(img, 0);
        try {
            tracker.waitForAll();
        } catch (InterruptedException ex) {
            return(null);
        }
        if (tracker.isErrorAny())
            return(null);
        return(img);
    }
    
    public void addPoint(int ip, double x, double y, boolean connecte){
        super.addPoint(ip, x, y, connecte);
    }

    public void setXRange(double min, double max) {
        super.setXRange(min, max);
        if(zooming) setImage();
    }
    
    // utilise pour recalculer l'image de fond lors d'un zoom      
    public void setImage() {
        Image im;
        int X1, Y1, X2, Y2; // position de la portion de l'image  afficher (en pixels sur l'image)
        int larg, haut; // dimensions de la portion de l'image  afficher (en pixels sur l'image)
        double ppx, ppy; // position de l'image affiche, en % de la zone affiche
        double ptx, pty; // taille image, en % de la zone affiche
        // _xMin _xMax _yMin _yMax: coordonnes de la zone affiche
        
        if (minImgX > _xMin) {
            ppx = (minImgX - _xMin) / (_xMax - _xMin);
            X1 = 0;
        } else {
            ppx = 0;
            X1 = (int)Math.round((_xMin - minImgX) * echImgX);
        }
        
        if (minImgX > _xMin && maxImgX < _xMax) {
            ptx = (maxImgX - minImgX) / (_xMax - _xMin);
            larg = tailleX;
        } else if (minImgX <= _xMin && maxImgX < _xMax) {
            ptx = (maxImgX - _xMin) / (_xMax - _xMin);
            larg = (int)Math.round((maxImgX - _xMin) * echImgX);
        } else if (minImgX > _xMin && maxImgX >= _xMax) {
            ptx = (_xMax - minImgX) / (_xMax - _xMin);
            larg = (int)Math.round((_xMax - minImgX) * echImgX);
        } else {
            ptx = 1.0;
            larg = (int)Math.round((_xMax - _xMin) * echImgX);
        }
        
        // les coordonnes y sont inverses par rapport  la position sur l'cran
        if (maxImgY < _yMax) {
            ppy = (_yMax - maxImgY) / (_yMax - _yMin);
            Y1 = 0;
        } else {
            ppy = 0;
            Y1 = (int)Math.round((maxImgY - _yMax) * echImgY);
        }
        
        if (minImgY > _yMin && maxImgY < _yMax) {
            pty = (maxImgY - minImgY) / (_yMax - _yMin);
            haut = tailleY;
        } else if (minImgY <= _yMin && maxImgY < _yMax) {
            pty = (maxImgY - _yMin) / (_yMax - _yMin);
            haut = (int)Math.round((maxImgY - _yMin) * echImgY);
        } else if (minImgY > _yMin && maxImgY >= _yMax) {
            pty = (_yMax - minImgY) / (_yMax - _yMin);
            haut = (int)Math.round((_yMax - minImgY) * echImgY);
        } else {
            pty = 1.0;
            haut = (int)Math.round((_yMax - _yMin) * echImgY);
        }
        
        // cas o l'image est tellement tire que l'on cherche  prendre une portion de l'image
        // plus petite que 1 pixel en largeur ou en hauteur
        if (larg == 0) {
            larg = 1;
            if (X1 == tailleX)
                X1 = tailleX - 1;
        }
        if (haut == 0) {
            haut = 1;
            if (Y1 == tailleY)
                Y1 = tailleY - 1;
        }
        
        if ((_xMin > maxImgX) || (_xMax < minImgX) || (_yMin > maxImgY) || (_yMax < minImgY)) {
            im = null;
            ppx = 0;
            ppy = 0;
            ptx = 0;
            pty = 0;
        } else {
            if (X1 != 0 || Y1 != 0 || larg != tailleX || haut != tailleY)
                im = ZoomImage.ajusterImage(img, (int)X1, (int)Y1, (int)larg, (int)haut,
                    applet, tailleX, tailleY);
            else
                im = img;
        }
        setBackgroundImage(im, ppx, ppy, ptx, pty);
    }
    
    public void setYRange(double min, double max) {
        super.setYRange(min, max);
        if(zooming) setImage();
    }
    
    public synchronized void zoom(double lowx, double lowy,
            double highx, double highy) {
        super.zoom(lowx, lowy, highx, highy);
        if(zooming) setImage();
    }
    
    public synchronized void fillPlot() {
        super.fillPlot();
        if(zooming) setImage();
    }
}

