/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import java.util.Vector;

/**
 * Interface pour une classe implmentant une simulation. Cette classe doit grer
 * les listes de paramtres (entre et sortie) et d'affichage, et les mthodes
 * de calcul, initCalculLive+calculLive et/ou calcul.
 */
public interface SimuParams {

    /**
     * Calcul complet.<br>
     * En entre: la liste des valeurs (sous forme d'objets) des paramtres d'entre.<br>
     * En sortie: la liste des valeurs (sous forme d'objets) des paramtres de sortie.<br>
     */
    public abstract ListeValeurs calcul(ListeValeurs in) throws SimuException;
    
    /**
     * Initialisation du calcul en temps rel.<br>
     * En entre: la liste des valeurs (sous forme d'objets) des paramtres d'entre.
     */
    public abstract void initCalculLive(ListeValeurs in) throws SimuException;
    
    /**
     * Calcul du temps t au temps t+1.<br>
     * En sortie: la liste des valeurs (sous forme d'objets) des paramtres de sortie,
     * ou null si la fin du calcul est atteinte.<br>
     * On peut ajouter  la liste de valeurs le paramtre "fin", qui indique suivant la valeur qu'on lui donne :
     * <ul>
     * <li> "simulation" : la fin de la simulation (comme si on renvoyait null) </li>
     * <li> "courbe" : le passage  une autre courbe, d'une autre couleur si couleurs=true. initCalculLive n'est pas rappel. </li>
     * <li> "trajectoire" : la fin d'une trajectoire, avec passage  une autre couleur et recopie des valeurs
     * de sortie vers les valeurs d'entre si boucle=true. initCalculLive est appel au dbut de chaque trajectoire. </li>
     * </ul>
     */
    public abstract ListeValeurs calculLive() throws SimuException;
    
    /** renvoit la liste des paramtres d'entre (Vector of ParamIn) */
    public abstract Vector getInParams();

    /** renvoit la liste des paramtres de sortie (Vector of ParamOut) */
    public abstract Vector getOutParams();

    /** renvoit la liste des possibilits d'affichage (Vector of Affichage) */
    public abstract Vector getAffichage();
    
    /** renvoit l'affichage avec le label donn */
    public abstract Affichage getAffichage(String label);
    
    /** ajoute un paramtre d'entre  la liste */
    public abstract void addParamIn(ParamIn p);

    /** ajoute un paramtre de sortie  la liste */
    public abstract void addParamOut(ParamOut p);

    /** ajoute un ensemble de valeurs par dfaut */
    public abstract void addEnsemble(String nom, ListeValeurs l);
    
    /** dfinit un titre pour les ensembles de valeurs */
    public abstract void setTitreEnsembles(String titre);
    
    /** Spcifie le fichier XML avec la dfinition des paramtres et des affichages. */
    public abstract void appletDoc(String nomFichier);
}
