/*
Projectile - algorithme de simulation pour SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

/**
 * Exemple d'applet de simulation utilisant SimuLab.
 * Simule un projectile lanc sur Terre avec une vitesse initiale donne et un angle
 * donn.
 */
public class Projectile extends SimuApplet {

    static final double g = 9.81;
    double dt = 0.05;
    double x,y;
    double vx,vy;
    int nbtraj=0;
    int maxtraj = 5;
    
    // constructeur de la classe, avec la dfinition des paramtres de simulation
    // et des options d'affichage.
    public Projectile() {
        // paramtres d'entre
        ParamIn v0 = new ParamIn();
        v0.type = "nombre";
        v0.label = "v0";
        v0.titre = "vitesse initiale";
        v0.unit = "m/s";
        v0.acquisition = "choix";
        String[] choix = {"8", "10", "12", "14"};
        v0.choix = choix;
        addParamIn(v0);
        
        ParamIn dir = new ParamIn();
        dir.type = "nombre";
        dir.label = "direction";
        dir.titre = "angle";
        dir.unit = "degres";
        dir.acquisition = "champ";
        addParamIn(dir);
        
        ParamIn chk = new ParamIn();
        chk.type = "string";
        chk.label = "test";
        chk.titre = "test de case";
        chk.acquisition = "case";
        chk.defaut = "on";
        addParamIn(chk);


        // paramtres de sortie
        ParamOut xv = new ParamOut();
        xv.type = "nombre";
        xv.label = "x";
        addParamOut(xv);
        ParamOut yv = new ParamOut();
        yv.type = "nombre";
        yv.label = "y";
        addParamOut(yv);
        ParamOut info = new ParamOut();
        info.type = "string";
        info.label = "info";
        addParamOut(info);
        
        // options d'affichage
        
        // affichage "plot"
        Affichage p = new Affichage();
        p.type = "plot";
        p.titre = "plot";
        String[][] pparams = {{"x", "y"}};
        p.params = pparams;
        p.fond = "apple.gif";
        addAffichage(p);

        // affichage "plotlive"
        p = new Affichage();
        p.type = "plotlive";
        p.titre = "plotlive";
        p.params = pparams;
        p.fond = "apple.gif";
        p.points = "dots";
        addAffichage(p);
        
        // affichage "tableau"
        p = new Affichage();
        p.type = "tableau";
        p.titre = "tableau";
        p.params = pparams;
        addAffichage(p);
        
        
        // affichage "multiplot"
        Affichage multi = new Affichage();
        multi.type = "multiplot";
        multi.titre = "multiplot";
        multi.sousAff = new Affichage[2];
        
        Affichage m1 = new Affichage();
        m1.type = "plot";
        m1.titre = "mouvement du projectile y/x";
        String[][] pparamsm1 = {{"x", "y"},{"y", "x"}};
        m1.params = pparamsm1;
        m1.fond = "apple.gif";
        m1.connecter = true;
        multi.sousAff[0] = m1;
        
        Affichage m2 = new Affichage();
        m2.type = "plot";
        m2.titre = "mouvement du projectile x/y";
        String[][] pparamsm2 = {{"y", "x"}};
        m2.params = pparamsm2;
        m2.fond = "apple.gif";
        m2.connecter = true;
        multi.sousAff[1] = m2;
        
        addAffichage(multi);
        
        // affichage "multiplot" live
        Affichage multilive = new Affichage();
        multilive.type = "multiplot";
        multilive.titre = "multiplot live";
        multilive.sousAff = new Affichage[2];
        
        Affichage ml1 = new Affichage();
        ml1.type = "plotlive";
        ml1.titre = "mouvement du projectile y/x live";
        String[][] pparamsml1 = {{"x", "y"},{"y", "x"}};
        ml1.params = pparamsml1;
        ml1.fond = "apple.gif";
        ml1.connecter = true;
        multilive.sousAff[0] = ml1;
        
        Affichage ml2 = new Affichage();
        ml2.type = "plotlive";
        ml2.titre = "mouvement du projectile x/y live";
        String[][] pparamsml2 = {{"y", "x"}};
        ml2.params = pparamsml2;
        ml2.fond = "apple.gif";
        ml2.connecter = true;
        multilive.sousAff[1] = ml2;
        
        addAffichage(multilive);
        
        // dfinition de deux ensembles de valeurs des paramtres
        setTitreEnsembles("schtroumpfs");
        ListeValeurs l1 = new ListeValeurs();
        //l1.ajouterString("v0", "10");
        l1.ajouterString("direction", "70");
        //l1.ajouterString("test", "10");
        addEnsemble("caillou", l1);
        ListeValeurs l2 = new ListeValeurs();
        //l2.ajouterString("v0", "10");
        l2.ajouterString("direction", "45");
        //l2.ajouterString("test", "90");
        addEnsemble("lanc optimal", l2);
        
        appletDoc("appletdoc.xml");
    }
    
    // calcul live (utilis avec affichage "plotlive")
    // initialisation
    public void initCalculLive(ListeValeurs in) throws SimuException {
        x = 0;
        y = 0;
        double v0 = in.lireDouble("v0");
        double angle = in.lireDouble("direction");
        angle += nbtraj*5;
        vx = v0 * Math.cos(angle/180*Math.PI);
        vy = v0 * Math.sin(angle/180*Math.PI);
    }
    
    // Calcul du temps t au temps t+1.
    public ListeValeurs calculLive() throws SimuException {
        ListeValeurs out = new ListeValeurs();
        if (y < 0) {
            nbtraj++;
            if (nbtraj > maxtraj) {
                nbtraj = 0;
                out.ajouterString("fin", "simulation");
            } else
                out.ajouterString("fin", "trajectoire");
            return(out);
        }
        x += vx * dt;
        y += vy * dt;
        vy -= g * dt;
        out.ajouterDouble("x", x);
        out.ajouterDouble("y", y);
        String message;
        if (y < 0)
            message = "le projectile est tomb au sol";
        else if (vy > 0)
            message = "le projectile monte";
        else
            message = "le projectile descend";
        out.ajouterString("info", message);
        dormir(Math.round(dt*1000)); // pour bloquer le programme pendant dt secondes
        return out;
    }
    
    // calcul complet d'un coup (utilis avec les affichages "plot" et "tableau")
    public ListeValeurs calcul(ListeValeurs in) throws SimuException {
        x = 0;
        y = 0;
        double v0 = in.lireDouble("v0");
        double angle = in.lireDouble("direction");
        vx = v0 * Math.cos(angle/180*Math.PI);
        vy = v0 * Math.sin(angle/180*Math.PI);
        ListeValeurs out = new ListeValeurs();
        while (y >= 0) {
            x += vx * dt;
            y += vy * dt;
            vy -= g * dt;
            out.ajouterDouble("x", x);
            out.ajouterDouble("y", y);
        }
        out.ajouterString("info", "le projectile est tomb au sol");
        return out;
    }
}
