/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import java.util.Vector;

/**
 * Paramtre d'entre
 */
public class ParamIn {
    /** nombre | string */
    public String type;
    
    /** nom de la variable */
    public String label;
    
    /** titre utilis pour demander la valeur ou l'afficher */
    public String titre;
    
    /** unit */
    public String unit;
    
    /**
     * mthode d'acquisition; valeurs autorises: champ | choix | curseur | case.
     * champ: champ texte,
     * choix: pop-up menu avec une liste de valeurs possibles,
     * curseur: curseur permettant d'entrer une valeur numrique de 0  100,
     * case: case  cocher, renvoyant les valeurs "on" (coch) ou "off" (pas coch)
     */
    public String acquisition;
    
    /** liste de choix possibles, utilis si acquisition="choix" (tableau de String) */
    public String[] choix;
    
    /** valeur par dfaut sous forme de String */
    public String defaut;
    
    /** Description pour l'aide en ligne */
    public String description;
    
    
    public ParamIn() {
        type = null;
        label = null;
        titre = null;
        unit = null;
        acquisition = null;
        choix = null;
        defaut = null;
        description = null;
    }

    public ParamIn(String type, String label, String titre, String unit,
        String acquisition, String[] choix, String defaut, String description) {
        this.type = type;
        this.label = label;
        this.titre = titre;
        this.unit = unit;
        this.acquisition = acquisition;
        this.choix = choix;
        this.defaut = defaut;
        this.description = description;
    }
}
