/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import java.util.*;

/**
 * Liste de valeurs accessibles par leur nom. Plusieurs valeurs avec le mme nom
 * sont stockes sous forme de Vector  partir de la deuxime valeur.
 */
public class ListeValeurs {

    Hashtable valeurs = new Hashtable();
    Vector vNoms = new Vector(); // ajout pour permettre de conserver l'ordre des valeurs
    
    /**
     * Ajoute une paire (nom, valeur)  la liste. Si une valeur existe dj
     * pour ce nom, un tableau (Vector) est cr pour contenir les valeurs
     * correspondant au nom. Dans ce dernier cas, un Vector sera renvoy lors
     * d'un appel  lire.
     */
    public void ajouter(String nom, Object valeur) {
        if (valeurs.containsKey(nom)) {
            Object o = valeurs.get(nom);
            if (o instanceof Vector)
                ((Vector)o).addElement(valeur);
            else {
                Vector v = new Vector();
                v.addElement(o);
                v.addElement(valeur);
                valeurs.put(nom, v);
            }
        } else {
            valeurs.put(nom, valeur);
            vNoms.addElement(nom);
        }
    }

    public void ajouterString(String nom, String valeur) {
        ajouter(nom, valeur);
    }

    public void ajouterDouble(String nom, double valeur) {
        ajouter(nom, new Double(valeur));
    }

    public void ajouterEntier(String nom, int valeur) {
        ajouter(nom, new Integer(valeur));
    }

    public void ajouterBooleen(String nom, boolean valeur) {
        ajouter(nom, new Boolean(valeur));
    }

    /**
     * Renvoit la valeur correspondant au nom. Si aucune valeur n'a t entre pour ce nom,
     * lance une erreur SimuException.
     */
    public Object lire(String nom) throws SimuException {
        Object o = valeurs.get(nom);
        if (o == null)
            throw new SimuException(Messages.get("aucune_valeur") + ": " + nom);
        return(o);
    }

    /**
     * Renvoit la valeur correspondant au nom, sous forme de String. Si la valeur
     * entre tait un Double, elle est convertie en String.
     */
    public String lireString(String nom) throws SimuException {
        Object o = lire(nom);
        return(String.valueOf(o));
    }

    /**
     * Renvoit la valeur correspondant au nom, sous forme de double. Si la valeur
     * entre tait un String, elle est convertie en double.
     */
    public double lireDouble(String nom) throws SimuException {
        Object o = lire(nom);
        Double d;
        if (o instanceof String)
            d = new Double((String)o);
        else
            d = (Double)o;
        return(d.doubleValue());
    }
    
    public int lireEntier(String nom) throws SimuException {
        Object o = lire(nom);
        Integer e;
        if (o instanceof String)
            e = new Integer((String)o);
        else
            e = (Integer)o;
        return(e.intValue());
    }
    
    public boolean lireBooleen(String nom) throws SimuException {
        Object o = lire(nom);
        Boolean b;
        if (o instanceof String)
            b = new Boolean((String)o);
        else
            b = (Boolean)o;
        return(b.booleanValue());
    }

    public int taille() {
        return(valeurs.size());
    }
    
    /**
     * Renvoit la liste de tous les noms, sous forme de Vector.
     */
    public Vector noms() {
        return(vNoms);
    }

    /*
      Renvoit la liste de toutes les valeurs, sous forme d'une numration.
     
    public Enumeration elements() {
        return(valeurs.elements());
    }
    */
}
