/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import java.awt.*;
import java.awt.image.*;

/**
 * Zone d'affichage d'une image pour AffImage.
 */
public class ImageCanvas extends Canvas {
    Dimension size;
    int w, h;
    Image image = null;
    int pix[] = null;
    byte[] bpix = null;
    long delai = 100; // en ms
    long time1;
    MemoryImageSource source;
    IndexColorModel palette;
    
    public ImageCanvas(int initialWidth, int initialHeight, IndexColorModel palette) {

        w = initialWidth;
        h = initialHeight;
        this.palette = palette;

        size = new Dimension(w+2, h+2);
        setSize(size);
        time1 = System.currentTimeMillis();
        source = null;
    }

    public Dimension getPreferredSize() {
        return getMinimumSize();
    }

    public synchronized Dimension getMinimumSize() {
        return size;
    }

    public void paint(Graphics g) {
        if (image != null)
            g.drawImage(image, 1, 1, null);
        g.drawRect(0, 0, w + 1, h + 1);
    }
    
    public void update(Graphics g) {
        paint(g);
    }
    
    public void updateImage(double[][] tval) throws SimuException {
        if (pix == null && bpix == null) {
            if (palette == null)
                pix = new int[w*h];
            else
                bpix = new byte[w*h];
        }
        if (tval.length != w)
            throw new SimuException(Messages.get("longueur_image") + " " + tval.length + " != " + w);
        if (tval[0].length != h)
            throw new SimuException(Messages.get("largeur_image") + " " + tval[0].length + " != " + h);
        int index=0;
        if (palette == null) {
            for(int j=0; j<h; j++)
                for(int i=0; i<w; i++) {
                    int v = (int)Math.round(tval[i][j]);
                    pix[index++]=(255  << 24) | (v << 16) | (v << 8) | (v);
                }
        } else
            for(int j=0; j<h; j++)
                for(int i=0; i<w; i++)
                    bpix[index++]=(byte)Math.round(tval[i][j]);
        
        verifDelai();

        if (source == null) {
            if (palette == null)
                source = new MemoryImageSource(w, h, pix, 0, w);
            else
                source = new MemoryImageSource(w, h, palette, bpix, 0, w);
            source.setAnimated(true);
            image = createImage(source);
        } else
            source.newPixels();
        
        repaint();
    }
    
    public void updateImage(Image im) throws SimuException {
        if (im.getWidth(null) != w)
            throw new SimuException("Longueur image " + im.getWidth(null) + " != " + w);
        if (im.getHeight(null) != h)
            throw new SimuException("Largeur image " + im.getHeight(null) + " != " + h);
        
        image = im;
        repaint();
        verifDelai();
    }
    
    protected void verifDelai() {
        long time2 = System.currentTimeMillis();
        if (time2 - time1 < delai) {
            //System.out.println("sleep " + (delai - (time2 - time1)));
            try { // pour bloquer le programme pendant x millisecondes
                Thread.currentThread().sleep(delai - (time2 - time1));
            } catch (InterruptedException e) {}
        } //else
            //System.out.println("no sleep");
        time1 = System.currentTimeMillis();
    }
}
